-- MariaDB dump 10.19  Distrib 10.9.8-MariaDB, for Win64 (AMD64)
--
-- Host: vm-db-digital-gov-back    Database: transport_cms
-- ------------------------------------------------------
-- Server version	10.5.11-MariaDB-1:10.5.11+maria~bionic-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `autopark_categories`
--
CREATE DATABASE IF NOT EXISTS transport_cms CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

use transport_cms;

DROP TABLE IF EXISTS `autopark_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autopark_categories` (
  `page_Id` int(11) NOT NULL,
  `transport_type_id` int(11) DEFAULT NULL,
  `group_object_id` int(11) DEFAULT NULL,
  `IsVisible` tinyint(1) DEFAULT NULL,
  `BaseCategory` tinyint(1) DEFAULT NULL,
  `IsVisibleOnMain` tinyint(1) DEFAULT NULL,
  `SortId` int(11) DEFAULT NULL,
  `ShortContent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`page_Id`) USING BTREE,
  KEY `page_Id` (`page_Id`) USING BTREE,
  KEY `transport_type_id` (`transport_type_id`) USING BTREE,
  KEY `group_object_id` (`group_object_id`) USING BTREE,
  CONSTRAINT `FK_70A6B2F9` FOREIGN KEY (`group_object_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_8DD62233` FOREIGN KEY (`transport_type_id`) REFERENCES `transport_type` (`id`),
  CONSTRAINT `FK_C378118A` FOREIGN KEY (`page_Id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autopark_categories`
--

LOCK TABLES `autopark_categories` WRITE;
/*!40000 ALTER TABLE `autopark_categories` DISABLE KEYS */;
INSERT INTO `autopark_categories` VALUES
(2,NULL,NULL,1,1,1,999,''),
(27,NULL,2,1,1,0,999,''),
(36,NULL,2,1,1,0,999,''),
(45,NULL,2,1,1,0,999,'');
/*!40000 ALTER TABLE `autopark_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_keys`
--

DROP TABLE IF EXISTS `cache_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` int(11) DEFAULT NULL,
  `is_site` tinyint(1) DEFAULT NULL,
  `method_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_keys`
--

LOCK TABLES `cache_keys` WRITE;
/*!40000 ALTER TABLE `cache_keys` DISABLE KEYS */;
INSERT INTO `cache_keys` VALUES
(1,'SiteMapNodeCache-GetAll',12,0,'GetAll'),
(2,'PageCache-{0}',1,1,''),
(3,'AutoparkCategoryCache-{0}',6,1,''),
(4,'ServiceCache-{0}',4,1,''),
(5,'PortfolioCache-{0}',2,1,''),
(6,'LanguageCache-GetForList',17,0,'GetForList');
/*!40000 ALTER TABLE `cache_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_gpt_history`
--

DROP TABLE IF EXISTS `chat_gpt_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chat_gpt_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `request` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `result` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_2A4DF48D` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_gpt_history`
--

LOCK TABLES `chat_gpt_history` WRITE;
/*!40000 ALTER TABLE `chat_gpt_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat_gpt_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `client`
--

DROP TABLE IF EXISTS `client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_on_site` tinyint(1) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_994B128A` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_CA0D9551` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `client`
--

LOCK TABLES `client` WRITE;
/*!40000 ALTER TABLE `client` DISABLE KEYS */;
INSERT INTO `client` VALUES
(1,'Условный Мегафон','',1,1,1,'2024-11-06 11:04:06'),
(2,NULL,NULL,0,1,1,'2025-06-03 12:38:25');
/*!40000 ALTER TABLE `client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cluster`
--

DROP TABLE IF EXISTS `cluster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cluster` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ClusterId` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_BBE9A3BE` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cluster`
--

LOCK TABLES `cluster` WRITE;
/*!40000 ALTER TABLE `cluster` DISABLE KEYS */;
INSERT INTO `cluster` VALUES
(1,1,NULL,'0001-01-01 00:00:00'),
(2,11,NULL,'0001-01-01 00:00:00'),
(3,10,NULL,'0001-01-01 00:00:00'),
(4,9,NULL,'0001-01-01 00:00:00'),
(5,8,NULL,'0001-01-01 00:00:00'),
(6,7,NULL,'0001-01-01 00:00:00'),
(7,6,NULL,'0001-01-01 00:00:00'),
(8,5,NULL,'0001-01-01 00:00:00'),
(9,4,NULL,'0001-01-01 00:00:00'),
(10,3,NULL,'0001-01-01 00:00:00'),
(11,2,NULL,'0001-01-01 00:00:00'),
(12,12,NULL,'0001-01-01 00:00:00');
/*!40000 ALTER TABLE `cluster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cluster_to_autoparkcategory`
--

DROP TABLE IF EXISTS `cluster_to_autoparkcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cluster_to_autoparkcategory` (
  `AutoparkCategory_id` int(11) NOT NULL,
  `Cluster_id` int(11) NOT NULL,
  PRIMARY KEY (`AutoparkCategory_id`,`Cluster_id`) USING BTREE,
  KEY `Cluster_id` (`Cluster_id`) USING BTREE,
  KEY `AutoparkCategory_id` (`AutoparkCategory_id`) USING BTREE,
  CONSTRAINT `FK_9FE5FD9B` FOREIGN KEY (`AutoparkCategory_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_E4E9521E` FOREIGN KEY (`Cluster_id`) REFERENCES `cluster` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cluster_to_autoparkcategory`
--

LOCK TABLES `cluster_to_autoparkcategory` WRITE;
/*!40000 ALTER TABLE `cluster_to_autoparkcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `cluster_to_autoparkcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_price`
--

DROP TABLE IF EXISTS `custom_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_price` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` int(11) DEFAULT NULL,
  `Price` int(11) DEFAULT NULL,
  `busid` int(11) DEFAULT NULL,
  `siteid` int(11) DEFAULT NULL,
  `IsActive` tinyint(1) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `busid` (`busid`) USING BTREE,
  KEY `siteid` (`siteid`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_233814DE` FOREIGN KEY (`typeid`) REFERENCES `custom_price_type` (`id`),
  CONSTRAINT `FK_3CE7E210` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_58D4EF2F` FOREIGN KEY (`busid`) REFERENCES `transport_model` (`id`),
  CONSTRAINT `FK_7FD3DCA6` FOREIGN KEY (`siteid`) REFERENCES `site` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_price`
--

LOCK TABLES `custom_price` WRITE;
/*!40000 ALTER TABLE `custom_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_price_group`
--

DROP TABLE IF EXISTS `custom_price_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_price_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_4051E2C0` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_price_group`
--

LOCK TABLES `custom_price_group` WRITE;
/*!40000 ALTER TABLE `custom_price_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_price_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_price_type`
--

DROP TABLE IF EXISTS `custom_price_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_price_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `custom_price_group_id` (`custom_price_group_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_176C8AB0` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_E8A510FD` FOREIGN KEY (`custom_price_group_id`) REFERENCES `custom_price_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_price_type`
--

LOCK TABLES `custom_price_type` WRITE;
/*!40000 ALTER TABLE `custom_price_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_price_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `description_page`
--

DROP TABLE IF EXISTS `description_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `description_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `PageLink` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `priority_id` (`priority_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_BE8F2AA0` FOREIGN KEY (`priority_id`) REFERENCES `gb_avtobus66`.`ticket_priority` (`id`),
  CONSTRAINT `FK_C12CD13A` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `description_page`
--

LOCK TABLES `description_page` WRITE;
/*!40000 ALTER TABLE `description_page` DISABLE KEYS */;
INSERT INTO `description_page` VALUES
(1,'\\',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(2,'/sites',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(3,'/sitenetworks',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(4,'/transportmodels',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(5,'/pages',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(6,'/clients',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(7,'/portfoliotypes',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(8,'/portfolios',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(9,'/semanticcores',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(10,'/seoplanning',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(11,'/metadataofpages',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(12,'/textofpages',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(13,'/cmsseoclusters',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(14,'/holdingpostweights',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(15,'/cmsseosubclusters',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(16,'/pipelines',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(17,'/pipelinestatuses',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(18,'/testchatgpt',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(19,'/struct',NULL,NULL,NULL,'0001-01-01 00:00:00'),
(20,'/account/logout',NULL,NULL,NULL,'0001-01-01 00:00:00');
/*!40000 ALTER TABLE `description_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `holding_post_weight`
--

DROP TABLE IF EXISTS `holding_post_weight`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `holding_post_weight` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holding_post_id` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT 0,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `holding_post_id` (`holding_post_id`,`weight`) USING BTREE,
  KEY `holding_post_id_2` (`holding_post_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_70FC7EA5` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_CCDD0926` FOREIGN KEY (`holding_post_id`) REFERENCES `gb_avtobus66`.`holding_post` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `holding_post_weight`
--

LOCK TABLES `holding_post_weight` WRITE;
/*!40000 ALTER TABLE `holding_post_weight` DISABLE KEYS */;
INSERT INTO `holding_post_weight` VALUES
(1,1,10,1,'0001-01-01 00:00:00');
/*!40000 ALTER TABLE `holding_post_weight` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `monitor_pages`
--

DROP TABLE IF EXISTS `monitor_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `monitor_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_id` int(11) DEFAULT NULL,
  `http_status_code` int(11) DEFAULT NULL,
  `page_id` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_id` (`site_id`) USING BTREE,
  KEY `page_id` (`page_id`) USING BTREE,
  CONSTRAINT `FK_71EA38C7` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_B47B057D` FOREIGN KEY (`page_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `monitor_pages`
--

LOCK TABLES `monitor_pages` WRITE;
/*!40000 ALTER TABLE `monitor_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `monitor_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `page`
--

DROP TABLE IF EXISTS `page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_use_in_link_formation` tinyint(1) DEFAULT 1,
  `is_use_in_bread_crumb_formation` tinyint(1) DEFAULT 1,
  `is_prevent_navigation_to_page` tinyint(1) DEFAULT 0,
  `Site_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `transport_model_id` int(11) DEFAULT NULL,
  `Url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `HOne` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PageTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PageDescription` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PageContent` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PageContentBottom` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IsEntityPage` tinyint(1) DEFAULT NULL,
  `DateOfChange` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  `ShortContent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `Site_id` (`Site_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `transport_model_id` (`transport_model_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_5C363D65` FOREIGN KEY (`transport_model_id`) REFERENCES `transport_model` (`id`),
  CONSTRAINT `FK_63C28D9F` FOREIGN KEY (`parent_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_735978EB` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_AFC1225E` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`),
  CONSTRAINT `FK_CF2D8108` FOREIGN KEY (`Site_id`) REFERENCES `site` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `page`
--

LOCK TABLES `page` WRITE;
/*!40000 ALTER TABLE `page` DISABLE KEYS */;
INSERT INTO `page` VALUES
(1,0,NULL,'',0,0,0,NULL,1,NULL,'main','Главная страница проекта ТестБус ','ТестБус - №1','ТестБус - №1','','',0,'2024-11-06 10:57:59',1,'2024-11-06 10:56:43',NULL),
(2,5,1,'Автопарк',1,1,0,NULL,1,NULL,'autopark',NULL,NULL,NULL,'','',0,'2024-11-06 11:00:40',1,'2024-11-06 10:59:57',NULL),
(3,1,1,'Услуга перевозки',1,1,0,NULL,1,NULL,'services',NULL,NULL,NULL,'','',0,'0001-01-01 00:00:00',1,'2024-11-06 11:01:01',NULL),
(4,2,1,'Перевозка сотрудников',1,1,0,NULL,1,NULL,'employee-transportation',NULL,NULL,NULL,'','',0,'0001-01-01 00:00:00',1,'2024-11-06 11:01:54',NULL),
(5,3,4,'Перевозка сотрудников на мероприятие',1,1,0,NULL,1,NULL,'transporting-employees-to-an-event',NULL,NULL,NULL,'','',0,'0001-01-01 00:00:00',1,'2024-11-06 11:03:18',NULL),
(10,0,13,'',1,1,0,NULL,1,5,'turkuaz','Заголовок turkuaz','Turkuaz','Turkuaz','','',0,'2024-11-06 12:18:33',1,'2024-11-06 12:17:47',NULL),
(11,0,13,'',1,1,0,NULL,1,4,'toyota-camry','Toyota Camry на сайте','Toyota Camry на сайте','Toyota Camry  в Description ','','',0,'2024-11-06 12:19:28',1,'2024-11-06 12:18:53',NULL),
(12,0,13,'',1,1,0,NULL,1,3,'toyota-hiace','Страница Toyota Hiace','Страница Toyota Hiace','Страница Toyota Hiace','','',0,'2024-11-06 12:20:09',1,'2024-11-06 12:19:46',NULL),
(13,0,1,'',0,0,1,NULL,1,NULL,'buses','','','','','',0,'2024-11-06 12:20:50',1,'2024-11-06 12:20:43',NULL),
(18,0,NULL,'',0,0,0,1,NULL,NULL,'main',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:39',261,'2024-11-06 12:27:39',NULL),
(23,0,26,'',1,1,0,1,NULL,5,'turkuaz',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(24,0,26,'',1,1,0,1,NULL,4,'toyota-camry',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(25,0,26,'',1,1,0,1,NULL,3,'toyota-hiace',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(26,0,18,'',0,0,1,1,NULL,NULL,'buses',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(27,5,18,'Автопарк',1,1,0,1,NULL,NULL,'autopark',NULL,NULL,NULL,'','',0,'2024-11-06 12:36:37',261,'2024-11-06 12:27:47',NULL),
(28,1,18,'Услуга перевозки',1,1,0,1,NULL,NULL,'services',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(29,2,18,'Перевозка сотрудников',1,1,0,1,NULL,NULL,'employee-transportation',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(30,3,29,'Перевозка сотрудников на мероприятие',1,1,0,1,NULL,NULL,'transporting-employees-to-an-event',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:27:47',261,'2024-11-06 12:27:47',NULL),
(31,0,NULL,'',0,0,0,2,NULL,NULL,'main',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(32,0,35,'',1,1,0,2,NULL,5,'turkuaz',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(33,0,35,'',1,1,0,2,NULL,4,'toyota-camry',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(34,0,35,'',1,1,0,2,NULL,3,'toyota-hiace',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(35,0,31,'',0,0,1,2,NULL,NULL,'buses',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(36,5,31,'Автопарк',1,1,0,2,NULL,NULL,'autopark',NULL,NULL,NULL,'','',0,'2024-11-06 12:36:50',261,'2024-11-06 12:35:04',NULL),
(37,1,31,'Услуга перевозки',1,1,0,2,NULL,NULL,'services',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(38,2,31,'Перевозка сотрудников',1,1,0,2,NULL,NULL,'employee-transportation',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(39,3,38,'Перевозка сотрудников на мероприятие',1,1,0,2,NULL,NULL,'transporting-employees-to-an-event',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:04',261,'2024-11-06 12:35:04',NULL),
(40,0,NULL,'',0,0,0,3,NULL,NULL,'main',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(41,0,44,'',1,1,0,3,NULL,5,'turkuaz',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(42,0,44,'',1,1,0,3,NULL,4,'toyota-camry',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(43,0,44,'',1,1,0,3,NULL,3,'toyota-hiace',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(44,0,40,'',0,0,1,3,NULL,NULL,'buses',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(45,5,40,'Автопарк',1,1,0,3,NULL,NULL,'autopark',NULL,NULL,NULL,'','',0,'2024-11-06 12:36:55',261,'2024-11-06 12:35:23',NULL),
(46,1,40,'Услуга перевозки',1,1,0,3,NULL,NULL,'services',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(47,2,40,'Перевозка сотрудников',1,1,0,3,NULL,NULL,'employee-transportation',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL),
(48,3,47,'Перевозка сотрудников на мероприятие',1,1,0,3,NULL,NULL,'transporting-employees-to-an-event',NULL,NULL,NULL,NULL,NULL,0,'2024-11-06 12:35:23',261,'2024-11-06 12:35:23',NULL);
/*!40000 ALTER TABLE `page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `page_report`
--

DROP TABLE IF EXISTS `page_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `page_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `text_quality_pipeline_status_id` int(11) DEFAULT NULL,
  `unique_text` tinyint(1) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `responsible_id` (`responsible_id`) USING BTREE,
  KEY `priority_id` (`priority_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_1DF5F3B` FOREIGN KEY (`priority_id`) REFERENCES `gb_avtobus66`.`ticket_priority` (`id`),
  CONSTRAINT `FK_6969D363` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_8C61854B` FOREIGN KEY (`responsible_id`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `page_report`
--

LOCK TABLES `page_report` WRITE;
/*!40000 ALTER TABLE `page_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `page_report` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `page_report_semantic_core`
--

DROP TABLE IF EXISTS `page_report_semantic_core`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `page_report_semantic_core` (
  `page_report_id` int(11) NOT NULL,
  `back_semantic_core_id` int(11) NOT NULL,
  PRIMARY KEY (`page_report_id`,`back_semantic_core_id`) USING BTREE,
  KEY `back_semantic_core_id` (`back_semantic_core_id`) USING BTREE,
  KEY `page_report_id` (`page_report_id`) USING BTREE,
  CONSTRAINT `FK_3A327F79` FOREIGN KEY (`page_report_id`) REFERENCES `page_report` (`id`),
  CONSTRAINT `FK_4634943B` FOREIGN KEY (`back_semantic_core_id`) REFERENCES `gb_avtobus66`.`semantic_core` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `page_report_semantic_core`
--

LOCK TABLES `page_report_semantic_core` WRITE;
/*!40000 ALTER TABLE `page_report_semantic_core` DISABLE KEYS */;
/*!40000 ALTER TABLE `page_report_semantic_core` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photo_resolutions`
--

DROP TABLE IF EXISTS `photo_resolutions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `photo_resolutions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `height` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `photo_type` int(11) DEFAULT NULL,
  `adaptive_type` int(11) DEFAULT NULL,
  `max_width` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_F391B46A` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `photo_resolutions`
--

LOCK TABLES `photo_resolutions` WRITE;
/*!40000 ALTER TABLE `photo_resolutions` DISABLE KEYS */;
/*!40000 ALTER TABLE `photo_resolutions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photos`
--

DROP TABLE IF EXISTS `photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PhotoType_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PhotoLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IconLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Site_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `converted` tinyint(1) DEFAULT 0,
  `grid_sort` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `Site_id` (`Site_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  KEY `entity_id_idx` (`entity_id`,`entity_type_id`) USING BTREE,
  CONSTRAINT `FK_4F4E4D24` FOREIGN KEY (`Site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_8272DF91` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`),
  CONSTRAINT `FK_BD42A74B` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `photos`
--

LOCK TABLES `photos` WRITE;
/*!40000 ALTER TABLE `photos` DISABLE KEYS */;
/*!40000 ALTER TABLE `photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photos_converted`
--

DROP TABLE IF EXISTS `photos_converted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `photos_converted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photo_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `photo_id` (`photo_id`) USING BTREE,
  KEY `resolution_id` (`resolution_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_8DCB8BD8` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`),
  CONSTRAINT `FK_E0240443` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_F0EAC41B` FOREIGN KEY (`resolution_id`) REFERENCES `photo_resolutions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `photos_converted`
--

LOCK TABLES `photos_converted` WRITE;
/*!40000 ALTER TABLE `photos_converted` DISABLE KEYS */;
/*!40000 ALTER TABLE `photos_converted` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photos_history`
--

DROP TABLE IF EXISTS `photos_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `photos_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photo_type_id` int(11) DEFAULT NULL,
  `entity_type_id` int(11) DEFAULT NULL,
  `event_listener_type` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `old_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `site_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_61F2B9F4` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `photos_history`
--

LOCK TABLES `photos_history` WRITE;
/*!40000 ALTER TABLE `photos_history` DISABLE KEYS */;
INSERT INTO `photos_history` VALUES
(1,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,1,'2025-06-03 12:38:25');
/*!40000 ALTER TABLE `photos_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pipeline`
--

DROP TABLE IF EXISTS `pipeline`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pipeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` int(11) DEFAULT NULL,
  `visualization_type` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_FC73D2A2` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pipeline`
--

LOCK TABLES `pipeline` WRITE;
/*!40000 ALTER TABLE `pipeline` DISABLE KEYS */;
INSERT INTO `pipeline` VALUES
(1,'Воронка SEO-планирования','',14,1,1,'2024-11-06 11:19:41'),
(2,'Воронка сетей','',11,1,1,'2024-11-06 11:19:55');
/*!40000 ALTER TABLE `pipeline` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pipeline_status`
--

DROP TABLE IF EXISTS `pipeline_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pipeline_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pipeline_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_start` tinyint(1) DEFAULT NULL,
  `is_end` tinyint(1) DEFAULT NULL,
  `sort_index` int(11) DEFAULT 0,
  `todo` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pipeline_id` (`pipeline_id`) USING BTREE,
  KEY `color_id` (`color_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_89AA5FE5` FOREIGN KEY (`color_id`) REFERENCES `gb_avtobus66`.`htmlcolor` (`id`),
  CONSTRAINT `FK_A255B4C` FOREIGN KEY (`pipeline_id`) REFERENCES `pipeline` (`id`),
  CONSTRAINT `FK_CA916223` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pipeline_status`
--

LOCK TABLES `pipeline_status` WRITE;
/*!40000 ALTER TABLE `pipeline_status` DISABLE KEYS */;
INSERT INTO `pipeline_status` VALUES
(1,1,'Еще не брались',NULL,0,1,0,1,'',1,'0001-01-01 00:00:00'),
(2,1,'Исполнитель сделал, на согласовании',NULL,50,0,0,2,'',1,'0001-01-01 00:00:00'),
(3,1,'Согласовано, на утверждении',NULL,80,0,0,3,'',1,'0001-01-01 00:00:00'),
(4,1,'Утверждено',NULL,100,0,1,4,'',1,'0001-01-01 00:00:00'),
(5,1,'Непонятно что делать',NULL,0,0,0,5,'',1,'0001-01-01 00:00:00'),
(6,2,'Не работает',NULL,0,1,0,1,'',1,'0001-01-01 00:00:00'),
(7,2,'В разработке',NULL,0,0,0,2,'',1,'0001-01-01 00:00:00'),
(8,2,'Работает',NULL,0,0,1,3,'',1,'0001-01-01 00:00:00');
/*!40000 ALTER TABLE `pipeline_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pipeline_status_trace`
--

DROP TABLE IF EXISTS `pipeline_status_trace`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pipeline_status_trace` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type` int(11) DEFAULT NULL,
  `from_status_id` int(11) DEFAULT NULL,
  `to_status_id` int(11) DEFAULT NULL,
  `changed_on` datetime DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `from_status_id` (`from_status_id`) USING BTREE,
  KEY `to_status_id` (`to_status_id`) USING BTREE,
  KEY `responsible_id` (`responsible_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_7BA9CB6E` FOREIGN KEY (`from_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_7BF1F98A` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_A791BE32` FOREIGN KEY (`to_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_BEB27F83` FOREIGN KEY (`responsible_id`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pipeline_status_trace`
--

LOCK TABLES `pipeline_status_trace` WRITE;
/*!40000 ALTER TABLE `pipeline_status_trace` DISABLE KEYS */;
/*!40000 ALTER TABLE `pipeline_status_trace` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `portfolio`
--

DROP TABLE IF EXISTS `portfolio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `portfolio` (
  `Page_Id` int(11) NOT NULL,
  `DateStart` datetime DEFAULT NULL,
  `DateFinish` datetime DEFAULT NULL,
  `AboutShort` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AboutFromManager` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `StatisticsPepole` int(11) DEFAULT NULL,
  `StatisticsFlight` int(11) DEFAULT NULL,
  `StatisticsCars` int(11) DEFAULT NULL,
  `StatisticsTrucks` int(11) DEFAULT NULL,
  `StatisticsBuses` int(11) DEFAULT NULL,
  `town_id` int(11) DEFAULT NULL,
  `Client_id` int(11) DEFAULT NULL,
  `group_object_id` int(11) DEFAULT NULL,
  `is_visible` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`Page_Id`) USING BTREE,
  KEY `Page_Id` (`Page_Id`) USING BTREE,
  KEY `town_id` (`town_id`) USING BTREE,
  KEY `Client_id` (`Client_id`) USING BTREE,
  KEY `group_object_id` (`group_object_id`) USING BTREE,
  CONSTRAINT `FK_782F9713` FOREIGN KEY (`town_id`) REFERENCES `gb_avtobus66`.`city` (`id`),
  CONSTRAINT `FK_92082AF5` FOREIGN KEY (`group_object_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_AB09F5C1` FOREIGN KEY (`Page_Id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_AD436000` FOREIGN KEY (`Client_id`) REFERENCES `client` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `portfolio`
--

LOCK TABLES `portfolio` WRITE;
/*!40000 ALTER TABLE `portfolio` DISABLE KEYS */;
INSERT INTO `portfolio` VALUES
(5,'2024-11-13 00:00:00','2024-11-22 00:00:00',NULL,NULL,10,5,0,0,1,NULL,1,NULL,1),
(30,'2024-11-13 00:00:00','2024-11-22 00:00:00',NULL,NULL,10,5,0,0,1,NULL,1,5,1),
(39,'2024-11-13 00:00:00','2024-11-22 00:00:00',NULL,NULL,10,5,0,0,1,NULL,1,5,1),
(48,'2024-11-13 00:00:00','2024-11-22 00:00:00',NULL,NULL,10,5,0,0,1,NULL,1,5,1);
/*!40000 ALTER TABLE `portfolio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `portfolio_type`
--

DROP TABLE IF EXISTS `portfolio_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `portfolio_type` (
  `Page_Id` int(11) NOT NULL,
  `group_object_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`Page_Id`) USING BTREE,
  KEY `Page_Id` (`Page_Id`) USING BTREE,
  KEY `group_object_id` (`group_object_id`) USING BTREE,
  CONSTRAINT `FK_559A7FC2` FOREIGN KEY (`group_object_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_97A91E4C` FOREIGN KEY (`Page_Id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `portfolio_type`
--

LOCK TABLES `portfolio_type` WRITE;
/*!40000 ALTER TABLE `portfolio_type` DISABLE KEYS */;
INSERT INTO `portfolio_type` VALUES
(4,NULL),
(29,4),
(38,4),
(47,4);
/*!40000 ALTER TABLE `portfolio_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `portfolio_video`
--

DROP TABLE IF EXISTS `portfolio_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `portfolio_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_link` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `portfolio_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `portfolio_id` (`portfolio_id`) USING BTREE,
  CONSTRAINT `FK_FE4C8CC3` FOREIGN KEY (`portfolio_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `portfolio_video`
--

LOCK TABLES `portfolio_video` WRITE;
/*!40000 ALTER TABLE `portfolio_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `portfolio_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_page`
--

DROP TABLE IF EXISTS `price_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_page` (
  `page_id` int(11) NOT NULL,
  PRIMARY KEY (`page_id`) USING BTREE,
  KEY `page_id` (`page_id`) USING BTREE,
  CONSTRAINT `FK_E430DE9C` FOREIGN KEY (`page_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_page`
--

LOCK TABLES `price_page` WRITE;
/*!40000 ALTER TABLE `price_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_page_to_category`
--

DROP TABLE IF EXISTS `price_page_to_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_page_to_category` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `autopark_category_id` int(11) DEFAULT NULL,
  `price_page_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `autopark_category_id` (`autopark_category_id`) USING BTREE,
  KEY `price_page_id` (`price_page_id`) USING BTREE,
  CONSTRAINT `FK_1D149F1F` FOREIGN KEY (`price_page_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_77876D16` FOREIGN KEY (`autopark_category_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_page_to_category`
--

LOCK TABLES `price_page_to_category` WRITE;
/*!40000 ALTER TABLE `price_page_to_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_page_to_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `redirection_links`
--

DROP TABLE IF EXISTS `redirection_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `redirection_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_network_id` int(11) DEFAULT NULL,
  `is_development` tinyint(1) DEFAULT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_54C60C58` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_A6B6985` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `redirection_links`
--

LOCK TABLES `redirection_links` WRITE;
/*!40000 ALTER TABLE `redirection_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `redirection_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region_page`
--

DROP TABLE IF EXISTS `region_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `region_page` (
  `page_id` int(11) NOT NULL,
  `town_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`page_id`) USING BTREE,
  KEY `page_id` (`page_id`) USING BTREE,
  KEY `town_id` (`town_id`) USING BTREE,
  CONSTRAINT `FK_4350909` FOREIGN KEY (`town_id`) REFERENCES `gb_avtobus66`.`city` (`id`),
  CONSTRAINT `FK_F229C503` FOREIGN KEY (`page_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region_page`
--

LOCK TABLES `region_page` WRITE;
/*!40000 ALTER TABLE `region_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `region_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seo_cluster`
--

DROP TABLE IF EXISTS `seo_cluster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_cluster` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_B9F9D5D9` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seo_cluster`
--

LOCK TABLES `seo_cluster` WRITE;
/*!40000 ALTER TABLE `seo_cluster` DISABLE KEYS */;
INSERT INTO `seo_cluster` VALUES
(1,'Контент на сайте',1,'2024-11-06 12:38:31'),
(2,'Ссылки',1,'2024-11-06 12:38:39'),
(3,'Структура и мета-теги',1,'2024-11-06 12:38:52');
/*!40000 ALTER TABLE `seo_cluster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seo_planing`
--

DROP TABLE IF EXISTS `seo_planing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_planing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_id` int(11) DEFAULT NULL,
  `microregion_id` int(11) DEFAULT NULL,
  `town_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `seo_cluster_id` int(11) DEFAULT NULL,
  `seo_sub_cluster_id` int(11) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_id` (`site_id`) USING BTREE,
  KEY `microregion_id` (`microregion_id`) USING BTREE,
  KEY `town_id` (`town_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `seo_cluster_id` (`seo_cluster_id`) USING BTREE,
  KEY `seo_sub_cluster_id` (`seo_sub_cluster_id`) USING BTREE,
  KEY `employee_id` (`employee_id`) USING BTREE,
  KEY `pipeline_status_id` (`pipeline_status_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_3DB053A1` FOREIGN KEY (`town_id`) REFERENCES `gb_avtobus66`.`city` (`id`),
  CONSTRAINT `FK_4BE2AB2A` FOREIGN KEY (`microregion_id`) REFERENCES `gb_avtobus66`.`region` (`id`),
  CONSTRAINT `FK_5CE63C78` FOREIGN KEY (`seo_cluster_id`) REFERENCES `seo_cluster` (`id`),
  CONSTRAINT `FK_7F4D5F96` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`),
  CONSTRAINT `FK_9140554C` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_9FFDF8D0` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_B40E1BF2` FOREIGN KEY (`employee_id`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_C9297A12` FOREIGN KEY (`seo_sub_cluster_id`) REFERENCES `seo_sub_cluster` (`id`),
  CONSTRAINT `FK_D34BFDBB` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seo_planing`
--

LOCK TABLES `seo_planing` WRITE;
/*!40000 ALTER TABLE `seo_planing` DISABLE KEYS */;
INSERT INTO `seo_planing` VALUES
(1,1,NULL,NULL,1,2,1,1,1,1,'2024-11-06 12:43:32'),
(2,2,NULL,NULL,1,2,1,1,1,1,'2024-11-06 12:43:33'),
(3,3,NULL,NULL,1,2,1,1,1,1,'2024-11-06 12:43:33'),
(4,1,NULL,NULL,1,3,2,1,1,1,'2024-11-06 12:44:22'),
(5,2,NULL,NULL,1,3,2,1,1,1,'2024-11-06 12:44:22'),
(6,3,NULL,NULL,1,3,2,1,1,1,'2024-11-06 12:44:22'),
(7,1,NULL,NULL,1,1,3,1,1,1,'2024-11-06 12:45:15'),
(8,2,NULL,NULL,1,1,3,1,1,1,'2024-11-06 12:45:15'),
(9,3,NULL,NULL,1,1,3,1,1,1,'2024-11-06 12:45:15');
/*!40000 ALTER TABLE `seo_planing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seo_sub_cluster`
--

DROP TABLE IF EXISTS `seo_sub_cluster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_sub_cluster` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_cluster_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `budget` decimal(19,5) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `seo_cluster_id` (`seo_cluster_id`) USING BTREE,
  KEY `priority_id` (`priority_id`) USING BTREE,
  KEY `employee_id` (`employee_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_560CB92F` FOREIGN KEY (`employee_id`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_60F9AEE7` FOREIGN KEY (`seo_cluster_id`) REFERENCES `seo_cluster` (`id`),
  CONSTRAINT `FK_8587F2CC` FOREIGN KEY (`priority_id`) REFERENCES `gb_avtobus66`.`ticket_priority` (`id`),
  CONSTRAINT `FK_D301AB19` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seo_sub_cluster`
--

LOCK TABLES `seo_sub_cluster` WRITE;
/*!40000 ALTER TABLE `seo_sub_cluster` DISABLE KEYS */;
INSERT INTO `seo_sub_cluster` VALUES
(1,'Настроена перелинковка на сайте',2,6,70,1,875.00000,120,1,'2024-11-06 12:43:32'),
(2,'Дублирующихся тегов Title и Description нет',3,9,70,1,109.00000,15,1,'2024-11-06 12:44:22'),
(3,'Все тексты на сайте уникальны',1,10,150,1,4375.00000,600,1,'2024-11-06 12:45:15');
/*!40000 ALTER TABLE `seo_sub_cluster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seo_sub_cluster_holding_post_weight`
--

DROP TABLE IF EXISTS `seo_sub_cluster_holding_post_weight`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_sub_cluster_holding_post_weight` (
  `seo_sub_cluster_id` int(11) NOT NULL,
  `holding_post_weight_id` int(11) NOT NULL,
  KEY `holding_post_weight_id` (`holding_post_weight_id`) USING BTREE,
  KEY `seo_sub_cluster_id` (`seo_sub_cluster_id`) USING BTREE,
  CONSTRAINT `FK_2343ABF6` FOREIGN KEY (`holding_post_weight_id`) REFERENCES `holding_post_weight` (`id`),
  CONSTRAINT `FK_A87A8E89` FOREIGN KEY (`seo_sub_cluster_id`) REFERENCES `seo_sub_cluster` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seo_sub_cluster_holding_post_weight`
--

LOCK TABLES `seo_sub_cluster_holding_post_weight` WRITE;
/*!40000 ALTER TABLE `seo_sub_cluster_holding_post_weight` DISABLE KEYS */;
INSERT INTO `seo_sub_cluster_holding_post_weight` VALUES
(1,1),
(2,1),
(3,1);
/*!40000 ALTER TABLE `seo_sub_cluster_holding_post_weight` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `service` (
  `page_Id` int(11) NOT NULL,
  `group_object_id` int(11) DEFAULT NULL,
  `ServiceIsVisible` tinyint(1) DEFAULT NULL,
  `BaseService` tinyint(1) DEFAULT NULL,
  `IsVisibleOnMain` tinyint(1) DEFAULT NULL,
  `SortId` int(11) DEFAULT NULL,
  `Content` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`page_Id`) USING BTREE,
  KEY `page_Id` (`page_Id`) USING BTREE,
  KEY `group_object_id` (`group_object_id`) USING BTREE,
  CONSTRAINT `FK_2BE8623B` FOREIGN KEY (`page_Id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_63288867` FOREIGN KEY (`group_object_id`) REFERENCES `page` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` VALUES
(3,NULL,1,1,1,999,NULL),
(28,3,1,1,1,0,NULL),
(37,3,1,1,1,0,NULL),
(46,3,1,1,1,0,NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `site`
--

DROP TABLE IF EXISTS `site`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_network_id` int(11) DEFAULT NULL,
  `Url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ProjectNameForSite` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PhysicalAdress` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `LegalAdress` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RequireDetails` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `YaMetrika` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_web_master` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DefaultPhone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DefaultDeliveryPhone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `MetaYandex` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `MetaGoogle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RoistatClassId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AirportName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ReCaptchaSiteKey` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ReCaptchaSecretKey` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ProjectNameLegal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Ages` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `LicenceName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Town_id` int(11) DEFAULT NULL,
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `WatermarkPath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Robots` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IdInBack` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `Town_id` (`Town_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_30B0B863` FOREIGN KEY (`Town_id`) REFERENCES `gb_avtobus66`.`city` (`id`),
  CONSTRAINT `FK_93EFF47E` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_B5EF8BF0` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `site`
--

LOCK TABLES `site` WRITE;
/*!40000 ALTER TABLE `site` DISABLE KEYS */;
INSERT INTO `site` VALUES
(1,1,'test1.ru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,1,1,'2024-11-06 12:21:54'),
(2,1,'ekanterinburg.test1.ru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,2,1,'2024-11-06 12:23:09'),
(3,1,'spb.test1.ru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,NULL,NULL,NULL,3,1,'2024-11-06 12:23:27');
/*!40000 ALTER TABLE `site` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `site_menu`
--

DROP TABLE IF EXISTS `site_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `site_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `page_id` int(11) DEFAULT NULL,
  `site_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `controller` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `index_field` int(11) DEFAULT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_burger` tinyint(1) DEFAULT NULL,
  `is_employee_name` tinyint(1) DEFAULT NULL,
  `visible` tinyint(1) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `page_id` (`page_id`) USING BTREE,
  KEY `site_id` (`site_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_5097CE6F` FOREIGN KEY (`page_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_99C7CE5E` FOREIGN KEY (`parent_id`) REFERENCES `site_menu` (`id`),
  CONSTRAINT `FK_CABA6560` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`),
  CONSTRAINT `FK_E1530B98` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_EA581B3E` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `site_menu`
--

LOCK TABLES `site_menu` WRITE;
/*!40000 ALTER TABLE `site_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `site_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `site_network`
--

DROP TABLE IF EXISTS `site_network`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `site_network` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `network_type` int(11) DEFAULT NULL,
  `main_site_id` int(11) DEFAULT NULL,
  `number` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `site_network_type_id` int(11) DEFAULT NULL,
  `project_name_legal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_canonical` tinyint(4) NOT NULL DEFAULT 0,
  `requisites` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `licence_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ages` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `work_time_disp` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `yandex_metrika` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_web_master` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sitemap_expressions` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sitemap_exclusion` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `robots` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `watermark_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `back_id` int(11) NOT NULL,
  `redirection_link_id` int(11) DEFAULT NULL,
  `sort_index` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `main_site_id` (`main_site_id`) USING BTREE,
  KEY `pipeline_status_id` (`pipeline_status_id`) USING BTREE,
  KEY `priority_id` (`priority_id`) USING BTREE,
  KEY `site_network_type_id` (`site_network_type_id`) USING BTREE,
  KEY `redirection_link_id` (`redirection_link_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_36B3554E` FOREIGN KEY (`main_site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_4880FF31` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_66129DF6` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_809687E6` FOREIGN KEY (`site_network_type_id`) REFERENCES `site_network_type` (`id`),
  CONSTRAINT `FK_A3D1C03C` FOREIGN KEY (`priority_id`) REFERENCES `gb_avtobus66`.`ticket_priority` (`id`),
  CONSTRAINT `FK_BD3DDDD6` FOREIGN KEY (`redirection_link_id`) REFERENCES `redirection_links` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `site_network`
--

LOCK TABLES `site_network` WRITE;
/*!40000 ALTER TABLE `site_network` DISABLE KEYS */;
INSERT INTO `site_network` VALUES
(1,'ТестСайт',2,1,1,7,8,1,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,'2024-11-06 10:55:17');
/*!40000 ALTER TABLE `site_network` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `site_network_type`
--

DROP TABLE IF EXISTS `site_network_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `site_network_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_18332014` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `site_network_type`
--

LOCK TABLES `site_network_type` WRITE;
/*!40000 ALTER TABLE `site_network_type` DISABLE KEYS */;
INSERT INTO `site_network_type` VALUES
(1,'Поддомен: \"ТестБус\"',1,'2024-11-06 10:55:17');
/*!40000 ALTER TABLE `site_network_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sitemap_node`
--

DROP TABLE IF EXISTS `sitemap_node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sitemap_node` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `controller` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `index_field` int(11) DEFAULT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_employee_name` tinyint(1) DEFAULT NULL,
  `visible` tinyint(1) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_9CEF429D` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_A158E381` FOREIGN KEY (`parent_id`) REFERENCES `sitemap_node` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sitemap_node`
--

LOCK TABLES `sitemap_node` WRITE;
/*!40000 ALTER TABLE `sitemap_node` DISABLE KEYS */;
INSERT INTO `sitemap_node` VALUES
(1,NULL,'Главная','\\','','',0,'',1,1,1,'2024-11-06 10:18:34'),
(2,1,'Сайты','','Sites','Sites',1,'',1,1,1,'2024-11-06 10:33:59'),
(3,1,'Проекты','','SiteNetworks','SiteNetwork',2,'',1,1,1,'2024-11-06 10:35:12'),
(4,1,'Главная','\\','','',0,'',1,1,1,'2024-11-06 10:37:50'),
(5,NULL,'Разделы сайтов','','','',1,'',1,1,1,'2024-11-06 10:38:15'),
(6,NULL,'Прочее','','','',2,'',1,1,1,'2024-11-06 10:38:28'),
(7,NULL,'Справочники','','','',3,'',1,1,1,'2024-11-06 10:38:42'),
(9,NULL,'Выход','','LogOut','Account',4,'',1,1,1,'2024-11-06 10:39:41'),
(10,5,'Транспорт на сайтах','','TransportModels','TransportModels',0,'',1,1,1,'2024-11-06 10:41:10'),
(11,5,'Страницы сайтов','','Pages','Pages',1,'',1,1,1,'2024-11-06 10:41:33'),
(12,5,'Клиенты на сайтах','','Clients','Clients',2,'',1,1,1,'2024-11-06 10:41:59'),
(13,5,'Типы кейсов на сайтах','','PortfolioTypes','PortfolioTypes',3,'',1,1,1,'2024-11-06 10:42:31'),
(14,5,'Кейсы на сайтах','','Portfolios','Portfolios',4,'',1,1,1,'2024-11-06 10:43:01'),
(15,6,'Семантическое ядро','','SemanticCores','SemanticCore',0,'',1,1,1,'2024-11-06 10:44:36'),
(16,6,'SEO планирование','','Index','SeoPlanning',1,'',1,1,1,'2024-11-06 10:45:06'),
(17,6,'Мета данные всех страниц всех сайтов','','MetaDataOfPages','PageReport',2,'',1,1,1,'2024-11-06 10:46:18'),
(18,6,'Тексты всех страниц всех сайтов','','TextOfPages','PageReport',3,'',1,1,1,'2024-11-06 10:46:53'),
(19,7,'Категории SEO работ','','CmsSeoClusters','CmsSeoCluster',0,'',1,1,1,'2024-11-06 10:47:48'),
(20,7,'Вес должности','','Index','HoldingPostWeight',1,'',1,1,1,'2024-11-06 10:48:35'),
(21,7,'Подкатегории SEO работ','','CmsSeoSubClusters','CmsSeoSubCluster',2,'',1,1,1,'2024-11-06 10:49:07'),
(22,7,'Воронки','','Index','CmsPipeline',3,'',1,1,1,'2024-11-06 10:49:30'),
(23,7,'Статусы воронок','','Index','CmsPipelineStatus',4,'',1,1,1,'2024-11-06 10:50:34');
/*!40000 ALTER TABLE `sitemap_node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template`
--

DROP TABLE IF EXISTS `template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `TemplateValue` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_9FBDD7EA` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template`
--

LOCK TABLES `template` WRITE;
/*!40000 ALTER TABLE `template` DISABLE KEYS */;
/*!40000 ALTER TABLE `template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_class`
--

DROP TABLE IF EXISTS `transport_class`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `UrlName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_569A4CD9` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_class`
--

LOCK TABLES `transport_class` WRITE;
/*!40000 ALTER TABLE `transport_class` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_model`
--

DROP TABLE IF EXISTS `transport_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_model` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `UrlName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `NumPlaces` int(11) DEFAULT NULL,
  `is_show_num_places` tinyint(1) DEFAULT 1,
  `back_transport_model_id` int(11) DEFAULT NULL,
  `NameInBack` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TransportType_id` int(11) DEFAULT NULL,
  `transport_class_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `back_transport_model_id` (`back_transport_model_id`) USING BTREE,
  KEY `TransportType_id` (`TransportType_id`) USING BTREE,
  KEY `transport_class_id` (`transport_class_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_70B2F5BD` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_769A2CD0` FOREIGN KEY (`transport_class_id`) REFERENCES `transport_class` (`id`),
  CONSTRAINT `FK_9665D0D0` FOREIGN KEY (`back_transport_model_id`) REFERENCES `gb_avtobus66`.`transport_model` (`id`),
  CONSTRAINT `FK_F0D80170` FOREIGN KEY (`TransportType_id`) REFERENCES `transport_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_model`
--

LOCK TABLES `transport_model` WRITE;
/*!40000 ALTER TABLE `transport_model` DISABLE KEYS */;
INSERT INTO `transport_model` VALUES
(1,'3205','paz-3205','ПАЗ',23,1,5,NULL,NULL,NULL,1,'2024-11-06 11:52:04'),
(2,'Higer KLQ6608','klq6608','Higer',20,0,1,NULL,NULL,NULL,1,'2024-11-06 12:14:21'),
(3,'Toyota Hiace','toyota-hiace','Toyota',11,0,2,NULL,NULL,NULL,1,'2024-11-06 12:14:34'),
(4,'Toyota Camry','toyota-camry','Toyota',4,0,3,NULL,NULL,NULL,1,'2024-11-06 12:14:47'),
(5,'Isuzu Turkuaz','turkuaz','Isuzu',31,0,4,NULL,NULL,NULL,1,'2024-11-06 12:15:01');
/*!40000 ALTER TABLE `transport_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_model_photo`
--

DROP TABLE IF EXISTS `transport_model_photo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_model_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Type` int(11) DEFAULT NULL,
  `TransportModel_id` int(11) DEFAULT NULL,
  `OrderIndex` int(11) DEFAULT NULL,
  `IsMainPhoto` tinyint(1) DEFAULT NULL,
  `SortId` int(11) DEFAULT NULL,
  `Title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PhotoLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IconLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Site_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `converted` tinyint(1) DEFAULT 0,
  `Sort` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  `Transport_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `TransportModel_id` (`TransportModel_id`) USING BTREE,
  KEY `Site_id` (`Site_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  KEY `Transport_id` (`Transport_id`) USING BTREE,
  CONSTRAINT `FK_12844BD1` FOREIGN KEY (`TransportModel_id`) REFERENCES `transport_model` (`id`),
  CONSTRAINT `FK_2556319` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_461EBB32` FOREIGN KEY (`Site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_B470BBF1` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`),
  CONSTRAINT `FK_C91B888F` FOREIGN KEY (`Transport_id`) REFERENCES `transport_model` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_model_photo`
--

LOCK TABLES `transport_model_photo` WRITE;
/*!40000 ALTER TABLE `transport_model_photo` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_model_photo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_model_site_data`
--

DROP TABLE IF EXISTS `transport_model_site_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_model_site_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_id` int(11) DEFAULT NULL,
  `site_network_id` int(11) DEFAULT NULL,
  `transport_model_id` int(11) DEFAULT NULL,
  `is_visible` tinyint(1) DEFAULT NULL,
  `show_vehicles_on_homepage` tinyint(1) DEFAULT 0,
  `is_temp_unable` tinyint(1) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `site_id` (`site_id`) USING BTREE,
  KEY `site_network_id` (`site_network_id`) USING BTREE,
  KEY `transport_model_id` (`transport_model_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_49AEA50E` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_D378C317` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_E3772BA8` FOREIGN KEY (`transport_model_id`) REFERENCES `transport_model` (`id`),
  CONSTRAINT `FK_EE7E7A2D` FOREIGN KEY (`site_network_id`) REFERENCES `site_network` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_model_site_data`
--

LOCK TABLES `transport_model_site_data` WRITE;
/*!40000 ALTER TABLE `transport_model_site_data` DISABLE KEYS */;
INSERT INTO `transport_model_site_data` VALUES
(1,NULL,1,1,1,1,0,NULL,'0001-01-01 00:00:00'),
(2,NULL,1,2,1,1,0,NULL,'0001-01-01 00:00:00'),
(3,NULL,1,3,1,0,1,NULL,'0001-01-01 00:00:00'),
(4,NULL,1,4,1,0,1,NULL,'0001-01-01 00:00:00'),
(5,NULL,1,5,1,1,0,NULL,'0001-01-01 00:00:00');
/*!40000 ALTER TABLE `transport_model_site_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_models_to_services`
--

DROP TABLE IF EXISTS `transport_models_to_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_models_to_services` (
  `TransportModel_id` int(11) NOT NULL,
  `Service_id` int(11) NOT NULL,
  PRIMARY KEY (`Service_id`,`TransportModel_id`) USING BTREE,
  KEY `Service_id` (`Service_id`) USING BTREE,
  KEY `TransportModel_id` (`TransportModel_id`) USING BTREE,
  CONSTRAINT `FK_44AC3D8E` FOREIGN KEY (`Service_id`) REFERENCES `page` (`id`),
  CONSTRAINT `FK_E1FD241F` FOREIGN KEY (`TransportModel_id`) REFERENCES `transport_model` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_models_to_services`
--

LOCK TABLES `transport_models_to_services` WRITE;
/*!40000 ALTER TABLE `transport_models_to_services` DISABLE KEYS */;
INSERT INTO `transport_models_to_services` VALUES
(1,3);
/*!40000 ALTER TABLE `transport_models_to_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_photos_converted`
--

DROP TABLE IF EXISTS `transport_photos_converted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_photos_converted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photo_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `photo_id` (`photo_id`) USING BTREE,
  KEY `resolution_id` (`resolution_id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_6206709D` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`),
  CONSTRAINT `FK_7812A4A2` FOREIGN KEY (`resolution_id`) REFERENCES `photo_resolutions` (`id`),
  CONSTRAINT `FK_EB819231` FOREIGN KEY (`photo_id`) REFERENCES `transport_model_photo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_photos_converted`
--

LOCK TABLES `transport_photos_converted` WRITE;
/*!40000 ALTER TABLE `transport_photos_converted` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_photos_converted` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_sale`
--

DROP TABLE IF EXISTS `transport_sale`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seller` int(11) DEFAULT NULL,
  `autoteka` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type_of_vehicle_id` int(11) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `engine` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transmission` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mileage` int(11) DEFAULT NULL,
  `num_places` int(11) DEFAULT NULL,
  `vin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `type_of_vehicle_id` (`type_of_vehicle_id`) USING BTREE,
  KEY `color_id` (`color_id`) USING BTREE,
  CONSTRAINT `FK_8F74F89` FOREIGN KEY (`color_id`) REFERENCES `gb_avtobus66`.`htmlcolor` (`id`),
  CONSTRAINT `FK_E5863088` FOREIGN KEY (`type_of_vehicle_id`) REFERENCES `transport_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_sale`
--

LOCK TABLES `transport_sale` WRITE;
/*!40000 ALTER TABLE `transport_sale` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_sale` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_type`
--

DROP TABLE IF EXISTS `transport_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transport_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `SortId` int(11) DEFAULT NULL,
  `IdInBack` int(11) DEFAULT NULL,
  `Url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `NameRP` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `NameIP` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `NameRPmn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_by` (`created_by`) USING BTREE,
  CONSTRAINT `FK_A10AEB07` FOREIGN KEY (`created_by`) REFERENCES `gb_avtobus66`.`employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_type`
--

LOCK TABLES `transport_type` WRITE;
/*!40000 ALTER TABLE `transport_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_type` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-05 23:29:48
