function teleportHtmlElement(el, to, type = "prepend") {
    const htmlEl = $(el);
    const dataAttrTo = to? to : htmlEl.data('teleport-to');
    let typeMove = htmlEl.data('teleport-type');
    if(!typeMove) {
        typeMove = type;
    }
    htmlEl.removeAttr('data-teleport-to');
    htmlEl.removeAttr('data-teleport-type');
    
    switch (typeMove) {
        case "prepend":{
            $(dataAttrTo).prepend(htmlEl.detach());
            return;
        }
        case "append":{
            $(dataAttrTo).append(htmlEl.detach());
            return;
        }
    }
    
}

$(() => setTimeout(() => $('[data-teleport-to]').each((_, el) => teleportHtmlElement(el))));