function setGridPipelineStatusBackColor(grid, fieldName, colorFieldName) {
    if (!grid || !fieldName || !colorFieldName)
        return;
    let statusColumnIndex = getColumnIndexByField(grid, fieldName);
    if (statusColumnIndex !== -1) {
        const rows = statusColumnIndex < -1
            ? grid.lockedTable.children().last().children()
            : grid.tbody.children();
        statusColumnIndex = statusColumnIndex < -1 ? -statusColumnIndex - 2 : statusColumnIndex;
        for (let i = 0; i < rows.length; i++) {
            const row = $(rows[i]);
            const dataItem = grid.dataItem(row);
            if (dataItem && !row.hasClass('k-group-footer')) {
                const statusCell = row.children().eq(statusColumnIndex);
                const cell = statusCell[0];
                if(cell === null || cell === undefined)
                    continue;

                const color = dataItem.get(colorFieldName);
                if(color)
                    cell.style.setProperty('background-color', `#${color.replace('#', '')}`, 'important');
            }
        }
    }
}
function getColumnIndexByField(grid, field) {
    if (grid.wrapper.find(`.k-grid-content-locked`).length > 0) {
        const headers = grid.wrapper.find(`.k-grid-header`).children();
        return headers.first().find(`[data-field=${field}]`).length !== 0
            ? -headers.first().find(`[data-field=${field}]`).index() - 2
            : headers.last().find(`[data-field=${field}]`).index();
    }
    else {
        return grid.wrapper.find(`.k-grid-header [data-field=${field}]`).index();
    }
}