kendo.culture('ru-RU');
/*!
 * jQuery Validation Plugin v1.19.3
 *
 * https://jqueryvalidation.org/
 *
 * Copyright (c) 2021 Jörn Zaefferer
 * Released under the MIT license
 */
(function( factory ) {
	if ( typeof define === "function" && define.amd ) {
		define( ["jquery"], factory );
	} else if (typeof module === "object" && module.exports) {
		module.exports = factory( require( "jquery" ) );
	} else {
		factory( jQuery );
	}
}(function( $ ) {

$.extend( $.fn, {

	// https://jqueryvalidation.org/validate/
	validate: function( options ) {

		// If nothing is selected, return nothing; can't chain anyway
		if ( !this.length ) {
			if ( options && options.debug && window.console ) {
				console.warn( "Nothing selected, can't validate, returning nothing." );
			}
			return;
		}

		// Check if a validator for this form was already created
		var validator = $.data( this[ 0 ], "validator" );
		if ( validator ) {
			return validator;
		}

		// Add novalidate tag if HTML5.
		this.attr( "novalidate", "novalidate" );

		validator = new $.validator( options, this[ 0 ] );
		$.data( this[ 0 ], "validator", validator );

		if ( validator.settings.onsubmit ) {

			this.on( "click.validate", ":submit", function( event ) {

				// Track the used submit button to properly handle scripted
				// submits later.
				validator.submitButton = event.currentTarget;

				// Allow suppressing validation by adding a cancel class to the submit button
				if ( $( this ).hasClass( "cancel" ) ) {
					validator.cancelSubmit = true;
				}

				// Allow suppressing validation by adding the html5 formnovalidate attribute to the submit button
				if ( $( this ).attr( "formnovalidate" ) !== undefined ) {
					validator.cancelSubmit = true;
				}
			} );

			// Validate the form on submit
			this.on( "submit.validate", function( event ) {
				if ( validator.settings.debug ) {

					// Prevent form submit to be able to see console output
					event.preventDefault();
				}

				function handle() {
					var hidden, result;

					// Insert a hidden input as a replacement for the missing submit button
					// The hidden input is inserted in two cases:
					//   - A user defined a `submitHandler`
					//   - There was a pending request due to `remote` method and `stopRequest()`
					//     was called to submit the form in case it's valid
					if ( validator.submitButton && ( validator.settings.submitHandler || validator.formSubmitted ) ) {
						hidden = $( "<input type='hidden'/>" )
							.attr( "name", validator.submitButton.name )
							.val( $( validator.submitButton ).val() )
							.appendTo( validator.currentForm );
					}

					if ( validator.settings.submitHandler && !validator.settings.debug ) {
						result = validator.settings.submitHandler.call( validator, validator.currentForm, event );
						if ( hidden ) {

							// And clean up afterwards; thanks to no-block-scope, hidden can be referenced
							hidden.remove();
						}
						if ( result !== undefined ) {
							return result;
						}
						return false;
					}
					return true;
				}

				// Prevent submit for invalid forms or custom submit handlers
				if ( validator.cancelSubmit ) {
					validator.cancelSubmit = false;
					return handle();
				}
				if ( validator.form() ) {
					if ( validator.pendingRequest ) {
						validator.formSubmitted = true;
						return false;
					}
					return handle();
				} else {
					validator.focusInvalid();
					return false;
				}
			} );
		}

		return validator;
	},

	// https://jqueryvalidation.org/valid/
	valid: function() {
		var valid, validator, errorList;

		if ( $( this[ 0 ] ).is( "form" ) ) {
			valid = this.validate().form();
		} else {
			errorList = [];
			valid = true;
			validator = $( this[ 0 ].form ).validate();
			this.each( function() {
				valid = validator.element( this ) && valid;
				if ( !valid ) {
					errorList = errorList.concat( validator.errorList );
				}
			} );
			validator.errorList = errorList;
		}
		return valid;
	},

	// https://jqueryvalidation.org/rules/
	rules: function( command, argument ) {
		var element = this[ 0 ],
			isContentEditable = typeof this.attr( "contenteditable" ) !== "undefined" && this.attr( "contenteditable" ) !== "false",
			settings, staticRules, existingRules, data, param, filtered;

		// If nothing is selected, return empty object; can't chain anyway
		if ( element == null ) {
			return;
		}

		if ( !element.form && isContentEditable ) {
			element.form = this.closest( "form" )[ 0 ];
			element.name = this.attr( "name" );
		}

		if ( element.form == null ) {
			return;
		}

		if ( command ) {
			settings = $.data( element.form, "validator" ).settings;
			staticRules = settings.rules;
			existingRules = $.validator.staticRules( element );
			switch ( command ) {
			case "add":
				$.extend( existingRules, $.validator.normalizeRule( argument ) );

				// Remove messages from rules, but allow them to be set separately
				delete existingRules.messages;
				staticRules[ element.name ] = existingRules;
				if ( argument.messages ) {
					settings.messages[ element.name ] = $.extend( settings.messages[ element.name ], argument.messages );
				}
				break;
			case "remove":
				if ( !argument ) {
					delete staticRules[ element.name ];
					return existingRules;
				}
				filtered = {};
				$.each( argument.split( /\s/ ), function( index, method ) {
					filtered[ method ] = existingRules[ method ];
					delete existingRules[ method ];
				} );
				return filtered;
			}
		}

		data = $.validator.normalizeRules(
		$.extend(
			{},
			$.validator.classRules( element ),
			$.validator.attributeRules( element ),
			$.validator.dataRules( element ),
			$.validator.staticRules( element )
		), element );

		// Make sure required is at front
		if ( data.required ) {
			param = data.required;
			delete data.required;
			data = $.extend( { required: param }, data );
		}

		// Make sure remote is at back
		if ( data.remote ) {
			param = data.remote;
			delete data.remote;
			data = $.extend( data, { remote: param } );
		}

		return data;
	}
} );

// JQuery trim is deprecated, provide a trim method based on String.prototype.trim
var trim = function( str ) {

	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trim#Polyfill
	return str.replace( /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "" );
};

// Custom selectors
$.extend( $.expr.pseudos || $.expr[ ":" ], {		// '|| $.expr[ ":" ]' here enables backwards compatibility to jQuery 1.7. Can be removed when dropping jQ 1.7.x support

	// https://jqueryvalidation.org/blank-selector/
	blank: function( a ) {
		return !trim( "" + $( a ).val() );
	},

	// https://jqueryvalidation.org/filled-selector/
	filled: function( a ) {
		var val = $( a ).val();
		return val !== null && !!trim( "" + val );
	},

	// https://jqueryvalidation.org/unchecked-selector/
	unchecked: function( a ) {
		return !$( a ).prop( "checked" );
	}
} );

// Constructor for validator
$.validator = function( options, form ) {
	this.settings = $.extend( true, {}, $.validator.defaults, options );
	this.currentForm = form;
	this.init();
};

// https://jqueryvalidation.org/jQuery.validator.format/
$.validator.format = function( source, params ) {
	if ( arguments.length === 1 ) {
		return function() {
			var args = $.makeArray( arguments );
			args.unshift( source );
			return $.validator.format.apply( this, args );
		};
	}
	if ( params === undefined ) {
		return source;
	}
	if ( arguments.length > 2 && params.constructor !== Array  ) {
		params = $.makeArray( arguments ).slice( 1 );
	}
	if ( params.constructor !== Array ) {
		params = [ params ];
	}
	$.each( params, function( i, n ) {
		source = source.replace( new RegExp( "\\{" + i + "\\}", "g" ), function() {
			return n;
		} );
	} );
	return source;
};

$.extend( $.validator, {

	defaults: {
		messages: {},
		groups: {},
		rules: {},
		errorClass: "error",
		pendingClass: "pending",
		validClass: "valid",
		errorElement: "label",
		focusCleanup: false,
		focusInvalid: true,
		errorContainer: $( [] ),
		errorLabelContainer: $( [] ),
		onsubmit: true,
		ignore: ":hidden",
		ignoreTitle: false,
		onfocusin: function( element ) {
			this.lastActive = element;

			// Hide error label and remove error class on focus if enabled
			if ( this.settings.focusCleanup ) {
				if ( this.settings.unhighlight ) {
					this.settings.unhighlight.call( this, element, this.settings.errorClass, this.settings.validClass );
				}
				this.hideThese( this.errorsFor( element ) );
			}
		},
		onfocusout: function( element ) {
			if ( !this.checkable( element ) && ( element.name in this.submitted || !this.optional( element ) ) ) {
				this.element( element );
			}
		},
		onkeyup: function( element, event ) {

			// Avoid revalidate the field when pressing one of the following keys
			// Shift       => 16
			// Ctrl        => 17
			// Alt         => 18
			// Caps lock   => 20
			// End         => 35
			// Home        => 36
			// Left arrow  => 37
			// Up arrow    => 38
			// Right arrow => 39
			// Down arrow  => 40
			// Insert      => 45
			// Num lock    => 144
			// AltGr key   => 225
			var excludedKeys = [
				16, 17, 18, 20, 35, 36, 37,
				38, 39, 40, 45, 144, 225
			];

			if ( event.which === 9 && this.elementValue( element ) === "" || $.inArray( event.keyCode, excludedKeys ) !== -1 ) {
				return;
			} else if ( element.name in this.submitted || element.name in this.invalid ) {
				this.element( element );
			}
		},
		onclick: function( element ) {

			// Click on selects, radiobuttons and checkboxes
			if ( element.name in this.submitted ) {
				this.element( element );

			// Or option elements, check parent select in that case
			} else if ( element.parentNode.name in this.submitted ) {
				this.element( element.parentNode );
			}
		},
		highlight: function( element, errorClass, validClass ) {
			if ( element.type === "radio" ) {
				this.findByName( element.name ).addClass( errorClass ).removeClass( validClass );
			} else {
				$( element ).addClass( errorClass ).removeClass( validClass );
			}
		},
		unhighlight: function( element, errorClass, validClass ) {
			if ( element.type === "radio" ) {
				this.findByName( element.name ).removeClass( errorClass ).addClass( validClass );
			} else {
				$( element ).removeClass( errorClass ).addClass( validClass );
			}
		}
	},

	// https://jqueryvalidation.org/jQuery.validator.setDefaults/
	setDefaults: function( settings ) {
		$.extend( $.validator.defaults, settings );
	},

	messages: {
		required: "This field is required.",
		remote: "Please fix this field.",
		email: "Please enter a valid email address.",
		url: "Please enter a valid URL.",
		date: "Please enter a valid date.",
		dateISO: "Please enter a valid date (ISO).",
		number: "Please enter a valid number.",
		digits: "Please enter only digits.",
		equalTo: "Please enter the same value again.",
		maxlength: $.validator.format( "Please enter no more than {0} characters." ),
		minlength: $.validator.format( "Please enter at least {0} characters." ),
		rangelength: $.validator.format( "Please enter a value between {0} and {1} characters long." ),
		range: $.validator.format( "Please enter a value between {0} and {1}." ),
		max: $.validator.format( "Please enter a value less than or equal to {0}." ),
		min: $.validator.format( "Please enter a value greater than or equal to {0}." ),
		step: $.validator.format( "Please enter a multiple of {0}." )
	},

	autoCreateRanges: false,

	prototype: {

		init: function() {
			this.labelContainer = $( this.settings.errorLabelContainer );
			this.errorContext = this.labelContainer.length && this.labelContainer || $( this.currentForm );
			this.containers = $( this.settings.errorContainer ).add( this.settings.errorLabelContainer );
			this.submitted = {};
			this.valueCache = {};
			this.pendingRequest = 0;
			this.pending = {};
			this.invalid = {};
			this.reset();

			var currentForm = this.currentForm,
				groups = ( this.groups = {} ),
				rules;
			$.each( this.settings.groups, function( key, value ) {
				if ( typeof value === "string" ) {
					value = value.split( /\s/ );
				}
				$.each( value, function( index, name ) {
					groups[ name ] = key;
				} );
			} );
			rules = this.settings.rules;
			$.each( rules, function( key, value ) {
				rules[ key ] = $.validator.normalizeRule( value );
			} );

			function delegate( event ) {
				var isContentEditable = typeof $( this ).attr( "contenteditable" ) !== "undefined" && $( this ).attr( "contenteditable" ) !== "false";

				// Set form expando on contenteditable
				if ( !this.form && isContentEditable ) {
					this.form = $( this ).closest( "form" )[ 0 ];
					this.name = $( this ).attr( "name" );
				}

				// Ignore the element if it belongs to another form. This will happen mainly
				// when setting the `form` attribute of an input to the id of another form.
				if ( currentForm !== this.form ) {
					return;
				}

				var validator = $.data( this.form, "validator" ),
					eventType = "on" + event.type.replace( /^validate/, "" ),
					settings = validator.settings;
				if ( settings[ eventType ] && !$( this ).is( settings.ignore ) ) {
					settings[ eventType ].call( validator, this, event );
				}
			}

			$( this.currentForm )
				.on( "focusin.validate focusout.validate keyup.validate",
					":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'], " +
					"[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], " +
					"[type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'], " +
					"[type='radio'], [type='checkbox'], [contenteditable], [type='button']", delegate )

				// Support: Chrome, oldIE
				// "select" is provided as event.target when clicking a option
				.on( "click.validate", "select, option, [type='radio'], [type='checkbox']", delegate );

			if ( this.settings.invalidHandler ) {
				$( this.currentForm ).on( "invalid-form.validate", this.settings.invalidHandler );
			}
		},

		// https://jqueryvalidation.org/Validator.form/
		form: function() {
			this.checkForm();
			$.extend( this.submitted, this.errorMap );
			this.invalid = $.extend( {}, this.errorMap );
			if ( !this.valid() ) {
				$( this.currentForm ).triggerHandler( "invalid-form", [ this ] );
			}
			this.showErrors();
			return this.valid();
		},

		checkForm: function() {
			this.prepareForm();
			for ( var i = 0, elements = ( this.currentElements = this.elements() ); elements[ i ]; i++ ) {
				this.check( elements[ i ] );
			}
			return this.valid();
		},

		// https://jqueryvalidation.org/Validator.element/
		element: function( element ) {
			var cleanElement = this.clean( element ),
				checkElement = this.validationTargetFor( cleanElement ),
				v = this,
				result = true,
				rs, group;

			if ( checkElement === undefined ) {
				delete this.invalid[ cleanElement.name ];
			} else {
				this.prepareElement( checkElement );
				this.currentElements = $( checkElement );

				// If this element is grouped, then validate all group elements already
				// containing a value
				group = this.groups[ checkElement.name ];
				if ( group ) {
					$.each( this.groups, function( name, testgroup ) {
						if ( testgroup === group && name !== checkElement.name ) {
							cleanElement = v.validationTargetFor( v.clean( v.findByName( name ) ) );
							if ( cleanElement && cleanElement.name in v.invalid ) {
								v.currentElements.push( cleanElement );
								result = v.check( cleanElement ) && result;
							}
						}
					} );
				}

				rs = this.check( checkElement ) !== false;
				result = result && rs;
				if ( rs ) {
					this.invalid[ checkElement.name ] = false;
				} else {
					this.invalid[ checkElement.name ] = true;
				}

				if ( !this.numberOfInvalids() ) {

					// Hide error containers on last error
					this.toHide = this.toHide.add( this.containers );
				}
				this.showErrors();

				// Add aria-invalid status for screen readers
				$( element ).attr( "aria-invalid", !rs );
			}

			return result;
		},

		// https://jqueryvalidation.org/Validator.showErrors/
		showErrors: function( errors ) {
			if ( errors ) {
				var validator = this;

				// Add items to error list and map
				$.extend( this.errorMap, errors );
				this.errorList = $.map( this.errorMap, function( message, name ) {
					return {
						message: message,
						element: validator.findByName( name )[ 0 ]
					};
				} );

				// Remove items from success list
				this.successList = $.grep( this.successList, function( element ) {
					return !( element.name in errors );
				} );
			}
			if ( this.settings.showErrors ) {
				this.settings.showErrors.call( this, this.errorMap, this.errorList );
			} else {
				this.defaultShowErrors();
			}
		},

		// https://jqueryvalidation.org/Validator.resetForm/
		resetForm: function() {
			if ( $.fn.resetForm ) {
				$( this.currentForm ).resetForm();
			}
			this.invalid = {};
			this.submitted = {};
			this.prepareForm();
			this.hideErrors();
			var elements = this.elements()
				.removeData( "previousValue" )
				.removeAttr( "aria-invalid" );

			this.resetElements( elements );
		},

		resetElements: function( elements ) {
			var i;

			if ( this.settings.unhighlight ) {
				for ( i = 0; elements[ i ]; i++ ) {
					this.settings.unhighlight.call( this, elements[ i ],
						this.settings.errorClass, "" );
					this.findByName( elements[ i ].name ).removeClass( this.settings.validClass );
				}
			} else {
				elements
					.removeClass( this.settings.errorClass )
					.removeClass( this.settings.validClass );
			}
		},

		numberOfInvalids: function() {
			return this.objectLength( this.invalid );
		},

		objectLength: function( obj ) {
			/* jshint unused: false */
			var count = 0,
				i;
			for ( i in obj ) {

				// This check allows counting elements with empty error
				// message as invalid elements
				if ( obj[ i ] !== undefined && obj[ i ] !== null && obj[ i ] !== false ) {
					count++;
				}
			}
			return count;
		},

		hideErrors: function() {
			this.hideThese( this.toHide );
		},

		hideThese: function( errors ) {
			errors.not( this.containers ).text( "" );
			this.addWrapper( errors ).hide();
		},

		valid: function() {
			return this.size() === 0;
		},

		size: function() {
			return this.errorList.length;
		},

		focusInvalid: function() {
			if ( this.settings.focusInvalid ) {
				try {
					$( this.findLastActive() || this.errorList.length && this.errorList[ 0 ].element || [] )
					.filter( ":visible" )
					.trigger( "focus" )

					// Manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find
					.trigger( "focusin" );
				} catch ( e ) {

					// Ignore IE throwing errors when focusing hidden elements
				}
			}
		},

		findLastActive: function() {
			var lastActive = this.lastActive;
			return lastActive && $.grep( this.errorList, function( n ) {
				return n.element.name === lastActive.name;
			} ).length === 1 && lastActive;
		},

		elements: function() {
			var validator = this,
				rulesCache = {};

			// Select all valid inputs inside the form (no submit or reset buttons)
			return $( this.currentForm )
			.find( "input, select, textarea, [contenteditable]" )
			.not( ":submit, :reset, :image, :disabled" )
			.not( this.settings.ignore )
			.filter( function() {
				var name = this.name || $( this ).attr( "name" ); // For contenteditable
				var isContentEditable = typeof $( this ).attr( "contenteditable" ) !== "undefined" && $( this ).attr( "contenteditable" ) !== "false";

				if ( !name && validator.settings.debug && window.console ) {
					console.error( "%o has no name assigned", this );
				}

				// Set form expando on contenteditable
				if ( isContentEditable ) {
					this.form = $( this ).closest( "form" )[ 0 ];
					this.name = name;
				}

				// Ignore elements that belong to other/nested forms
				if ( this.form !== validator.currentForm ) {
					return false;
				}

				// Select only the first element for each name, and only those with rules specified
				if ( name in rulesCache || !validator.objectLength( $( this ).rules() ) ) {
					return false;
				}

				rulesCache[ name ] = true;
				return true;
			} );
		},

		clean: function( selector ) {
			return $( selector )[ 0 ];
		},

		errors: function() {
			var errorClass = this.settings.errorClass.split( " " ).join( "." );
			return $( this.settings.errorElement + "." + errorClass, this.errorContext );
		},

		resetInternals: function() {
			this.successList = [];
			this.errorList = [];
			this.errorMap = {};
			this.toShow = $( [] );
			this.toHide = $( [] );
		},

		reset: function() {
			this.resetInternals();
			this.currentElements = $( [] );
		},

		prepareForm: function() {
			this.reset();
			this.toHide = this.errors().add( this.containers );
		},

		prepareElement: function( element ) {
			this.reset();
			this.toHide = this.errorsFor( element );
		},

		elementValue: function( element ) {
			var $element = $( element ),
				type = element.type,
				isContentEditable = typeof $element.attr( "contenteditable" ) !== "undefined" && $element.attr( "contenteditable" ) !== "false",
				val, idx;

			if ( type === "radio" || type === "checkbox" ) {
				return this.findByName( element.name ).filter( ":checked" ).val();
			} else if ( type === "number" && typeof element.validity !== "undefined" ) {
				return element.validity.badInput ? "NaN" : $element.val();
			}

			if ( isContentEditable ) {
				val = $element.text();
			} else {
				val = $element.val();
			}

			if ( type === "file" ) {

				// Modern browser (chrome & safari)
				if ( val.substr( 0, 12 ) === "C:\\fakepath\\" ) {
					return val.substr( 12 );
				}

				// Legacy browsers
				// Unix-based path
				idx = val.lastIndexOf( "/" );
				if ( idx >= 0 ) {
					return val.substr( idx + 1 );
				}

				// Windows-based path
				idx = val.lastIndexOf( "\\" );
				if ( idx >= 0 ) {
					return val.substr( idx + 1 );
				}

				// Just the file name
				return val;
			}

			if ( typeof val === "string" ) {
				return val.replace( /\r/g, "" );
			}
			return val;
		},

		check: function( element ) {
			element = this.validationTargetFor( this.clean( element ) );

			var rules = $( element ).rules(),
				rulesCount = $.map( rules, function( n, i ) {
					return i;
				} ).length,
				dependencyMismatch = false,
				val = this.elementValue( element ),
				result, method, rule, normalizer;

			// Prioritize the local normalizer defined for this element over the global one
			// if the former exists, otherwise user the global one in case it exists.
			if ( typeof rules.normalizer === "function" ) {
				normalizer = rules.normalizer;
			} else if (	typeof this.settings.normalizer === "function" ) {
				normalizer = this.settings.normalizer;
			}

			// If normalizer is defined, then call it to retreive the changed value instead
			// of using the real one.
			// Note that `this` in the normalizer is `element`.
			if ( normalizer ) {
				val = normalizer.call( element, val );

				// Delete the normalizer from rules to avoid treating it as a pre-defined method.
				delete rules.normalizer;
			}

			for ( method in rules ) {
				rule = { method: method, parameters: rules[ method ] };
				try {
					result = $.validator.methods[ method ].call( this, val, element, rule.parameters );

					// If a method indicates that the field is optional and therefore valid,
					// don't mark it as valid when there are no other rules
					if ( result === "dependency-mismatch" && rulesCount === 1 ) {
						dependencyMismatch = true;
						continue;
					}
					dependencyMismatch = false;

					if ( result === "pending" ) {
						this.toHide = this.toHide.not( this.errorsFor( element ) );
						return;
					}

					if ( !result ) {
						this.formatAndAdd( element, rule );
						return false;
					}
				} catch ( e ) {
					if ( this.settings.debug && window.console ) {
						console.log( "Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.", e );
					}
					if ( e instanceof TypeError ) {
						e.message += ".  Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.";
					}

					throw e;
				}
			}
			if ( dependencyMismatch ) {
				return;
			}
			if ( this.objectLength( rules ) ) {
				this.successList.push( element );
			}
			return true;
		},

		// Return the custom message for the given element and validation method
		// specified in the element's HTML5 data attribute
		// return the generic message if present and no method specific message is present
		customDataMessage: function( element, method ) {
			return $( element ).data( "msg" + method.charAt( 0 ).toUpperCase() +
				method.substring( 1 ).toLowerCase() ) || $( element ).data( "msg" );
		},

		// Return the custom message for the given element name and validation method
		customMessage: function( name, method ) {
			var m = this.settings.messages[ name ];
			return m && ( m.constructor === String ? m : m[ method ] );
		},

		// Return the first defined argument, allowing empty strings
		findDefined: function() {
			for ( var i = 0; i < arguments.length; i++ ) {
				if ( arguments[ i ] !== undefined ) {
					return arguments[ i ];
				}
			}
			return undefined;
		},

		// The second parameter 'rule' used to be a string, and extended to an object literal
		// of the following form:
		// rule = {
		//     method: "method name",
		//     parameters: "the given method parameters"
		// }
		//
		// The old behavior still supported, kept to maintain backward compatibility with
		// old code, and will be removed in the next major release.
		defaultMessage: function( element, rule ) {
			if ( typeof rule === "string" ) {
				rule = { method: rule };
			}

			var message = this.findDefined(
					this.customMessage( element.name, rule.method ),
					this.customDataMessage( element, rule.method ),

					// 'title' is never undefined, so handle empty string as undefined
					!this.settings.ignoreTitle && element.title || undefined,
					$.validator.messages[ rule.method ],
					"<strong>Warning: No message defined for " + element.name + "</strong>"
				),
				theregex = /\$?\{(\d+)\}/g;
			if ( typeof message === "function" ) {
				message = message.call( this, rule.parameters, element );
			} else if ( theregex.test( message ) ) {
				message = $.validator.format( message.replace( theregex, "{$1}" ), rule.parameters );
			}

			return message;
		},

		formatAndAdd: function( element, rule ) {
			var message = this.defaultMessage( element, rule );

			this.errorList.push( {
				message: message,
				element: element,
				method: rule.method
			} );

			this.errorMap[ element.name ] = message;
			this.submitted[ element.name ] = message;
		},

		addWrapper: function( toToggle ) {
			if ( this.settings.wrapper ) {
				toToggle = toToggle.add( toToggle.parent( this.settings.wrapper ) );
			}
			return toToggle;
		},

		defaultShowErrors: function() {
			var i, elements, error;
			for ( i = 0; this.errorList[ i ]; i++ ) {
				error = this.errorList[ i ];
				if ( this.settings.highlight ) {
					this.settings.highlight.call( this, error.element, this.settings.errorClass, this.settings.validClass );
				}
				this.showLabel( error.element, error.message );
			}
			if ( this.errorList.length ) {
				this.toShow = this.toShow.add( this.containers );
			}
			if ( this.settings.success ) {
				for ( i = 0; this.successList[ i ]; i++ ) {
					this.showLabel( this.successList[ i ] );
				}
			}
			if ( this.settings.unhighlight ) {
				for ( i = 0, elements = this.validElements(); elements[ i ]; i++ ) {
					this.settings.unhighlight.call( this, elements[ i ], this.settings.errorClass, this.settings.validClass );
				}
			}
			this.toHide = this.toHide.not( this.toShow );
			this.hideErrors();
			this.addWrapper( this.toShow ).show();
		},

		validElements: function() {
			return this.currentElements.not( this.invalidElements() );
		},

		invalidElements: function() {
			return $( this.errorList ).map( function() {
				return this.element;
			} );
		},

		showLabel: function( element, message ) {
			var place, group, errorID, v,
				error = this.errorsFor( element ),
				elementID = this.idOrName( element ),
				describedBy = $( element ).attr( "aria-describedby" );

			if ( error.length ) {

				// Refresh error/success class
				error.removeClass( this.settings.validClass ).addClass( this.settings.errorClass );

				// Replace message on existing label
				error.html( message );
			} else {

				// Create error element
				error = $( "<" + this.settings.errorElement + ">" )
					.attr( "id", elementID + "-error" )
					.addClass( this.settings.errorClass )
					.html( message || "" );

				// Maintain reference to the element to be placed into the DOM
				place = error;
				if ( this.settings.wrapper ) {

					// Make sure the element is visible, even in IE
					// actually showing the wrapped element is handled elsewhere
					place = error.hide().show().wrap( "<" + this.settings.wrapper + "/>" ).parent();
				}
				if ( this.labelContainer.length ) {
					this.labelContainer.append( place );
				} else if ( this.settings.errorPlacement ) {
					this.settings.errorPlacement.call( this, place, $( element ) );
				} else {
					place.insertAfter( element );
				}

				// Link error back to the element
				if ( error.is( "label" ) ) {

					// If the error is a label, then associate using 'for'
					error.attr( "for", elementID );

					// If the element is not a child of an associated label, then it's necessary
					// to explicitly apply aria-describedby
				} else if ( error.parents( "label[for='" + this.escapeCssMeta( elementID ) + "']" ).length === 0 ) {
					errorID = error.attr( "id" );

					// Respect existing non-error aria-describedby
					if ( !describedBy ) {
						describedBy = errorID;
					} else if ( !describedBy.match( new RegExp( "\\b" + this.escapeCssMeta( errorID ) + "\\b" ) ) ) {

						// Add to end of list if not already present
						describedBy += " " + errorID;
					}
					$( element ).attr( "aria-describedby", describedBy );

					// If this element is grouped, then assign to all elements in the same group
					group = this.groups[ element.name ];
					if ( group ) {
						v = this;
						$.each( v.groups, function( name, testgroup ) {
							if ( testgroup === group ) {
								$( "[name='" + v.escapeCssMeta( name ) + "']", v.currentForm )
									.attr( "aria-describedby", error.attr( "id" ) );
							}
						} );
					}
				}
			}
			if ( !message && this.settings.success ) {
				error.text( "" );
				if ( typeof this.settings.success === "string" ) {
					error.addClass( this.settings.success );
				} else {
					this.settings.success( error, element );
				}
			}
			this.toShow = this.toShow.add( error );
		},

		errorsFor: function( element ) {
			var name = this.escapeCssMeta( this.idOrName( element ) ),
				describer = $( element ).attr( "aria-describedby" ),
				selector = "label[for='" + name + "'], label[for='" + name + "'] *";

			// 'aria-describedby' should directly reference the error element
			if ( describer ) {
				selector = selector + ", #" + this.escapeCssMeta( describer )
					.replace( /\s+/g, ", #" );
			}

			return this
				.errors()
				.filter( selector );
		},

		// See https://api.jquery.com/category/selectors/, for CSS
		// meta-characters that should be escaped in order to be used with JQuery
		// as a literal part of a name/id or any selector.
		escapeCssMeta: function( string ) {
			return string.replace( /([\\!"#$%&'()*+,./:;<=>?@\[\]^`{|}~])/g, "\\$1" );
		},

		idOrName: function( element ) {
			return this.groups[ element.name ] || ( this.checkable( element ) ? element.name : element.id || element.name );
		},

		validationTargetFor: function( element ) {

			// If radio/checkbox, validate first element in group instead
			if ( this.checkable( element ) ) {
				element = this.findByName( element.name );
			}

			// Always apply ignore filter
			return $( element ).not( this.settings.ignore )[ 0 ];
		},

		checkable: function( element ) {
			return ( /radio|checkbox/i ).test( element.type );
		},

		findByName: function( name ) {
			return $( this.currentForm ).find( "[name='" + this.escapeCssMeta( name ) + "']" );
		},

		getLength: function( value, element ) {
			switch ( element.nodeName.toLowerCase() ) {
			case "select":
				return $( "option:selected", element ).length;
			case "input":
				if ( this.checkable( element ) ) {
					return this.findByName( element.name ).filter( ":checked" ).length;
				}
			}
			return value.length;
		},

		depend: function( param, element ) {
			return this.dependTypes[ typeof param ] ? this.dependTypes[ typeof param ]( param, element ) : true;
		},

		dependTypes: {
			"boolean": function( param ) {
				return param;
			},
			"string": function( param, element ) {
				return !!$( param, element.form ).length;
			},
			"function": function( param, element ) {
				return param( element );
			}
		},

		optional: function( element ) {
			var val = this.elementValue( element );
			return !$.validator.methods.required.call( this, val, element ) && "dependency-mismatch";
		},

		startRequest: function( element ) {
			if ( !this.pending[ element.name ] ) {
				this.pendingRequest++;
				$( element ).addClass( this.settings.pendingClass );
				this.pending[ element.name ] = true;
			}
		},

		stopRequest: function( element, valid ) {
			this.pendingRequest--;

			// Sometimes synchronization fails, make sure pendingRequest is never < 0
			if ( this.pendingRequest < 0 ) {
				this.pendingRequest = 0;
			}
			delete this.pending[ element.name ];
			$( element ).removeClass( this.settings.pendingClass );
			if ( valid && this.pendingRequest === 0 && this.formSubmitted && this.form() ) {
				$( this.currentForm ).submit();

				// Remove the hidden input that was used as a replacement for the
				// missing submit button. The hidden input is added by `handle()`
				// to ensure that the value of the used submit button is passed on
				// for scripted submits triggered by this method
				if ( this.submitButton ) {
					$( "input:hidden[name='" + this.submitButton.name + "']", this.currentForm ).remove();
				}

				this.formSubmitted = false;
			} else if ( !valid && this.pendingRequest === 0 && this.formSubmitted ) {
				$( this.currentForm ).triggerHandler( "invalid-form", [ this ] );
				this.formSubmitted = false;
			}
		},

		previousValue: function( element, method ) {
			method = typeof method === "string" && method || "remote";

			return $.data( element, "previousValue" ) || $.data( element, "previousValue", {
				old: null,
				valid: true,
				message: this.defaultMessage( element, { method: method } )
			} );
		},

		// Cleans up all forms and elements, removes validator-specific events
		destroy: function() {
			this.resetForm();

			$( this.currentForm )
				.off( ".validate" )
				.removeData( "validator" )
				.find( ".validate-equalTo-blur" )
					.off( ".validate-equalTo" )
					.removeClass( "validate-equalTo-blur" )
				.find( ".validate-lessThan-blur" )
					.off( ".validate-lessThan" )
					.removeClass( "validate-lessThan-blur" )
				.find( ".validate-lessThanEqual-blur" )
					.off( ".validate-lessThanEqual" )
					.removeClass( "validate-lessThanEqual-blur" )
				.find( ".validate-greaterThanEqual-blur" )
					.off( ".validate-greaterThanEqual" )
					.removeClass( "validate-greaterThanEqual-blur" )
				.find( ".validate-greaterThan-blur" )
					.off( ".validate-greaterThan" )
					.removeClass( "validate-greaterThan-blur" );
		}

	},

	classRuleSettings: {
		required: { required: true },
		email: { email: true },
		url: { url: true },
		date: { date: true },
		dateISO: { dateISO: true },
		number: { number: true },
		digits: { digits: true },
		creditcard: { creditcard: true }
	},

	addClassRules: function( className, rules ) {
		if ( className.constructor === String ) {
			this.classRuleSettings[ className ] = rules;
		} else {
			$.extend( this.classRuleSettings, className );
		}
	},

	classRules: function( element ) {
		var rules = {},
			classes = $( element ).attr( "class" );

		if ( classes ) {
			$.each( classes.split( " " ), function() {
				if ( this in $.validator.classRuleSettings ) {
					$.extend( rules, $.validator.classRuleSettings[ this ] );
				}
			} );
		}
		return rules;
	},

	normalizeAttributeRule: function( rules, type, method, value ) {

		// Convert the value to a number for number inputs, and for text for backwards compability
		// allows type="date" and others to be compared as strings
		if ( /min|max|step/.test( method ) && ( type === null || /number|range|text/.test( type ) ) ) {
			value = Number( value );

			// Support Opera Mini, which returns NaN for undefined minlength
			if ( isNaN( value ) ) {
				value = undefined;
			}
		}

		if ( value || value === 0 ) {
			rules[ method ] = value;
		} else if ( type === method && type !== "range" ) {

			// Exception: the jquery validate 'range' method
			// does not test for the html5 'range' type
			rules[ method ] = true;
		}
	},

	attributeRules: function( element ) {
		var rules = {},
			$element = $( element ),
			type = element.getAttribute( "type" ),
			method, value;

		for ( method in $.validator.methods ) {

			// Support for <input required> in both html5 and older browsers
			if ( method === "required" ) {
				value = element.getAttribute( method );

				// Some browsers return an empty string for the required attribute
				// and non-HTML5 browsers might have required="" markup
				if ( value === "" ) {
					value = true;
				}

				// Force non-HTML5 browsers to return bool
				value = !!value;
			} else {
				value = $element.attr( method );
			}

			this.normalizeAttributeRule( rules, type, method, value );
		}

		// 'maxlength' may be returned as -1, 2147483647 ( IE ) and 524288 ( safari ) for text inputs
		if ( rules.maxlength && /-1|2147483647|524288/.test( rules.maxlength ) ) {
			delete rules.maxlength;
		}

		return rules;
	},

	dataRules: function( element ) {
		var rules = {},
			$element = $( element ),
			type = element.getAttribute( "type" ),
			method, value;

		for ( method in $.validator.methods ) {
			value = $element.data( "rule" + method.charAt( 0 ).toUpperCase() + method.substring( 1 ).toLowerCase() );

			// Cast empty attributes like `data-rule-required` to `true`
			if ( value === "" ) {
				value = true;
			}

			this.normalizeAttributeRule( rules, type, method, value );
		}
		return rules;
	},

	staticRules: function( element ) {
		var rules = {},
			validator = $.data( element.form, "validator" );

		if ( validator.settings.rules ) {
			rules = $.validator.normalizeRule( validator.settings.rules[ element.name ] ) || {};
		}
		return rules;
	},

	normalizeRules: function( rules, element ) {

		// Handle dependency check
		$.each( rules, function( prop, val ) {

			// Ignore rule when param is explicitly false, eg. required:false
			if ( val === false ) {
				delete rules[ prop ];
				return;
			}
			if ( val.param || val.depends ) {
				var keepRule = true;
				switch ( typeof val.depends ) {
				case "string":
					keepRule = !!$( val.depends, element.form ).length;
					break;
				case "function":
					keepRule = val.depends.call( element, element );
					break;
				}
				if ( keepRule ) {
					rules[ prop ] = val.param !== undefined ? val.param : true;
				} else {
					$.data( element.form, "validator" ).resetElements( $( element ) );
					delete rules[ prop ];
				}
			}
		} );

		// Evaluate parameters
		$.each( rules, function( rule, parameter ) {
			rules[ rule ] = typeof parameter === "function" && rule !== "normalizer" ? parameter( element ) : parameter;
		} );

		// Clean number parameters
		$.each( [ "minlength", "maxlength" ], function() {
			if ( rules[ this ] ) {
				rules[ this ] = Number( rules[ this ] );
			}
		} );
		$.each( [ "rangelength", "range" ], function() {
			var parts;
			if ( rules[ this ] ) {
				if ( Array.isArray( rules[ this ] ) ) {
					rules[ this ] = [ Number( rules[ this ][ 0 ] ), Number( rules[ this ][ 1 ] ) ];
				} else if ( typeof rules[ this ] === "string" ) {
					parts = rules[ this ].replace( /[\[\]]/g, "" ).split( /[\s,]+/ );
					rules[ this ] = [ Number( parts[ 0 ] ), Number( parts[ 1 ] ) ];
				}
			}
		} );

		if ( $.validator.autoCreateRanges ) {

			// Auto-create ranges
			if ( rules.min != null && rules.max != null ) {
				rules.range = [ rules.min, rules.max ];
				delete rules.min;
				delete rules.max;
			}
			if ( rules.minlength != null && rules.maxlength != null ) {
				rules.rangelength = [ rules.minlength, rules.maxlength ];
				delete rules.minlength;
				delete rules.maxlength;
			}
		}

		return rules;
	},

	// Converts a simple string to a {string: true} rule, e.g., "required" to {required:true}
	normalizeRule: function( data ) {
		if ( typeof data === "string" ) {
			var transformed = {};
			$.each( data.split( /\s/ ), function() {
				transformed[ this ] = true;
			} );
			data = transformed;
		}
		return data;
	},

	// https://jqueryvalidation.org/jQuery.validator.addMethod/
	addMethod: function( name, method, message ) {
		$.validator.methods[ name ] = method;
		$.validator.messages[ name ] = message !== undefined ? message : $.validator.messages[ name ];
		if ( method.length < 3 ) {
			$.validator.addClassRules( name, $.validator.normalizeRule( name ) );
		}
	},

	// https://jqueryvalidation.org/jQuery.validator.methods/
	methods: {

		// https://jqueryvalidation.org/required-method/
		required: function( value, element, param ) {

			// Check if dependency is met
			if ( !this.depend( param, element ) ) {
				return "dependency-mismatch";
			}
			if ( element.nodeName.toLowerCase() === "select" ) {

				// Could be an array for select-multiple or a string, both are fine this way
				var val = $( element ).val();
				return val && val.length > 0;
			}
			if ( this.checkable( element ) ) {
				return this.getLength( value, element ) > 0;
			}
			return value !== undefined && value !== null && value.length > 0;
		},

		// https://jqueryvalidation.org/email-method/
		email: function( value, element ) {

			// From https://html.spec.whatwg.org/multipage/forms.html#valid-e-mail-address
			// Retrieved 2014-01-14
			// If you have a problem with this implementation, report a bug against the above spec
			// Or use custom methods to implement your own email validation
			return this.optional( element ) || /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test( value );
		},

		// https://jqueryvalidation.org/url-method/
		url: function( value, element ) {

			// Copyright (c) 2010-2013 Diego Perini, MIT licensed
			// https://gist.github.com/dperini/729294
			// see also https://mathiasbynens.be/demo/url-regex
			// modified to allow protocol-relative URLs
			return this.optional( element ) || /^(?:(?:(?:https?|ftp):)?\/\/)(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff]\.)+(?:[a-z\u00a1-\uffff]{2,}\.?))(?::\d{2,5})?(?:[/?#]\S*)?$/i.test( value );
		},

		// https://jqueryvalidation.org/date-method/
		date: ( function() {
			var called = false;

			return function( value, element ) {
				if ( !called ) {
					called = true;
					if ( this.settings.debug && window.console ) {
						console.warn(
							"The `date` method is deprecated and will be removed in version '2.0.0'.\n" +
							"Please don't use it, since it relies on the Date constructor, which\n" +
							"behaves very differently across browsers and locales. Use `dateISO`\n" +
							"instead or one of the locale specific methods in `localizations/`\n" +
							"and `additional-methods.js`."
						);
					}
				}

				return this.optional( element ) || !/Invalid|NaN/.test( new Date( value ).toString() );
			};
		}() ),

		// https://jqueryvalidation.org/dateISO-method/
		dateISO: function( value, element ) {
			return this.optional( element ) || /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/.test( value );
		},

		// https://jqueryvalidation.org/number-method/
		number: function( value, element ) {
			return this.optional( element ) || /^(?:-?\d+|-?\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test( value );
		},

		// https://jqueryvalidation.org/digits-method/
		digits: function( value, element ) {
			return this.optional( element ) || /^\d+$/.test( value );
		},

		// https://jqueryvalidation.org/minlength-method/
		minlength: function( value, element, param ) {
			var length = Array.isArray( value ) ? value.length : this.getLength( value, element );
			return this.optional( element ) || length >= param;
		},

		// https://jqueryvalidation.org/maxlength-method/
		maxlength: function( value, element, param ) {
			var length = Array.isArray( value ) ? value.length : this.getLength( value, element );
			return this.optional( element ) || length <= param;
		},

		// https://jqueryvalidation.org/rangelength-method/
		rangelength: function( value, element, param ) {
			var length = Array.isArray( value ) ? value.length : this.getLength( value, element );
			return this.optional( element ) || ( length >= param[ 0 ] && length <= param[ 1 ] );
		},

		// https://jqueryvalidation.org/min-method/
		min: function( value, element, param ) {
			return this.optional( element ) || value >= param;
		},

		// https://jqueryvalidation.org/max-method/
		max: function( value, element, param ) {
			return this.optional( element ) || value <= param;
		},

		// https://jqueryvalidation.org/range-method/
		range: function( value, element, param ) {
			return this.optional( element ) || ( value >= param[ 0 ] && value <= param[ 1 ] );
		},

		// https://jqueryvalidation.org/step-method/
		step: function( value, element, param ) {
			var type = $( element ).attr( "type" ),
				errorMessage = "Step attribute on input type " + type + " is not supported.",
				supportedTypes = [ "text", "number", "range" ],
				re = new RegExp( "\\b" + type + "\\b" ),
				notSupported = type && !re.test( supportedTypes.join() ),
				decimalPlaces = function( num ) {
					var match = ( "" + num ).match( /(?:\.(\d+))?$/ );
					if ( !match ) {
						return 0;
					}

					// Number of digits right of decimal point.
					return match[ 1 ] ? match[ 1 ].length : 0;
				},
				toInt = function( num ) {
					return Math.round( num * Math.pow( 10, decimals ) );
				},
				valid = true,
				decimals;

			// Works only for text, number and range input types
			// TODO find a way to support input types date, datetime, datetime-local, month, time and week
			if ( notSupported ) {
				throw new Error( errorMessage );
			}

			decimals = decimalPlaces( param );

			// Value can't have too many decimals
			if ( decimalPlaces( value ) > decimals || toInt( value ) % toInt( param ) !== 0 ) {
				valid = false;
			}

			return this.optional( element ) || valid;
		},

		// https://jqueryvalidation.org/equalTo-method/
		equalTo: function( value, element, param ) {

			// Bind to the blur event of the target in order to revalidate whenever the target field is updated
			var target = $( param );
			if ( this.settings.onfocusout && target.not( ".validate-equalTo-blur" ).length ) {
				target.addClass( "validate-equalTo-blur" ).on( "blur.validate-equalTo", function() {
					$( element ).valid();
				} );
			}
			return value === target.val();
		},

		// https://jqueryvalidation.org/remote-method/
		remote: function( value, element, param, method ) {
			if ( this.optional( element ) ) {
				return "dependency-mismatch";
			}

			method = typeof method === "string" && method || "remote";

			var previous = this.previousValue( element, method ),
				validator, data, optionDataString;

			if ( !this.settings.messages[ element.name ] ) {
				this.settings.messages[ element.name ] = {};
			}
			previous.originalMessage = previous.originalMessage || this.settings.messages[ element.name ][ method ];
			this.settings.messages[ element.name ][ method ] = previous.message;

			param = typeof param === "string" && { url: param } || param;
			optionDataString = $.param( $.extend( { data: value }, param.data ) );
			if ( previous.old === optionDataString ) {
				return previous.valid;
			}

			previous.old = optionDataString;
			validator = this;
			this.startRequest( element );
			data = {};
			data[ element.name ] = value;
			$.ajax( $.extend( true, {
				mode: "abort",
				port: "validate" + element.name,
				dataType: "json",
				data: data,
				context: validator.currentForm,
				success: function( response ) {
					var valid = response === true || response === "true",
						errors, message, submitted;

					validator.settings.messages[ element.name ][ method ] = previous.originalMessage;
					if ( valid ) {
						submitted = validator.formSubmitted;
						validator.resetInternals();
						validator.toHide = validator.errorsFor( element );
						validator.formSubmitted = submitted;
						validator.successList.push( element );
						validator.invalid[ element.name ] = false;
						validator.showErrors();
					} else {
						errors = {};
						message = response || validator.defaultMessage( element, { method: method, parameters: value } );
						errors[ element.name ] = previous.message = message;
						validator.invalid[ element.name ] = true;
						validator.showErrors( errors );
					}
					previous.valid = valid;
					validator.stopRequest( element, valid );
				}
			}, param ) );
			return "pending";
		}
	}

} );

// Ajax mode: abort
// usage: $.ajax({ mode: "abort"[, port: "uniqueport"]});
// if mode:"abort" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()

var pendingRequests = {},
	ajax;

// Use a prefilter if available (1.5+)
if ( $.ajaxPrefilter ) {
	$.ajaxPrefilter( function( settings, _, xhr ) {
		var port = settings.port;
		if ( settings.mode === "abort" ) {
			if ( pendingRequests[ port ] ) {
				pendingRequests[ port ].abort();
			}
			pendingRequests[ port ] = xhr;
		}
	} );
} else {

	// Proxy ajax
	ajax = $.ajax;
	$.ajax = function( settings ) {
		var mode = ( "mode" in settings ? settings : $.ajaxSettings ).mode,
			port = ( "port" in settings ? settings : $.ajaxSettings ).port;
		if ( mode === "abort" ) {
			if ( pendingRequests[ port ] ) {
				pendingRequests[ port ].abort();
			}
			pendingRequests[ port ] = ajax.apply( this, arguments );
			return pendingRequests[ port ];
		}
		return ajax.apply( this, arguments );
	};
}
return $;
}));
// Unobtrusive validation support library for jQuery and jQuery Validate
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.
// @version v3.2.12
!function(a){"function"==typeof define&&define.amd?define("jquery.validate.unobtrusive",["jquery-validation"],a):"object"==typeof module&&module.exports?module.exports=a(require("jquery-validation")):jQuery.validator.unobtrusive=a(jQuery)}(function(a){function e(a,e,n){a.rules[e]=n,a.message&&(a.messages[e]=a.message)}function n(a){return a.replace(/^\s+|\s+$/g,"").split(/\s*,\s*/g)}function t(a){return a.replace(/([!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~])/g,"\\$1")}function r(a){return a.substr(0,a.lastIndexOf(".")+1)}function i(a,e){return 0===a.indexOf("*.")&&(a=a.replace("*.",e)),a}function o(e,n){var r=a(this).find("[data-valmsg-for='"+t(n[0].name)+"']"),i=r.attr("data-valmsg-replace"),o=i?a.parseJSON(i)!==!1:null;r.removeClass("field-validation-valid").addClass("field-validation-error"),e.data("unobtrusiveContainer",r),o?(r.empty(),e.removeClass("input-validation-error").appendTo(r)):e.hide()}function d(e,n){var t=a(this).find("[data-valmsg-summary=true]"),r=t.find("ul");r&&r.length&&n.errorList.length&&(r.empty(),t.addClass("validation-summary-errors").removeClass("validation-summary-valid"),a.each(n.errorList,function(){a("<li />").html(this.message).appendTo(r)}))}function s(e){var n=e.data("unobtrusiveContainer");if(n){var t=n.attr("data-valmsg-replace"),r=t?a.parseJSON(t):null;n.addClass("field-validation-valid").removeClass("field-validation-error"),e.removeData("unobtrusiveContainer"),r&&n.empty()}}function l(e){var n=a(this),t="__jquery_unobtrusive_validation_form_reset";if(!n.data(t)){n.data(t,!0);try{n.data("validator").resetForm()}finally{n.removeData(t)}n.find(".validation-summary-errors").addClass("validation-summary-valid").removeClass("validation-summary-errors"),n.find(".field-validation-error").addClass("field-validation-valid").removeClass("field-validation-error").removeData("unobtrusiveContainer").find(">*").removeData("unobtrusiveContainer")}}function u(e){var n=a(e),t=n.data(v),r=a.proxy(l,e),i=f.unobtrusive.options||{},u=function(n,t){var r=i[n];r&&a.isFunction(r)&&r.apply(e,t)};return t||(t={options:{errorClass:i.errorClass||"input-validation-error",errorElement:i.errorElement||"span",errorPlacement:function(){o.apply(e,arguments),u("errorPlacement",arguments)},invalidHandler:function(){d.apply(e,arguments),u("invalidHandler",arguments)},messages:{},rules:{},success:function(){s.apply(e,arguments),u("success",arguments)}},attachValidation:function(){n.off("reset."+v,r).on("reset."+v,r).validate(this.options)},validate:function(){return n.validate(),n.valid()}},n.data(v,t)),t}var m,f=a.validator,v="unobtrusiveValidation";return f.unobtrusive={adapters:[],parseElement:function(e,n){var t,r,i,o=a(e),d=o.parents("form")[0];d&&(t=u(d),t.options.rules[e.name]=r={},t.options.messages[e.name]=i={},a.each(this.adapters,function(){var n="data-val-"+this.name,t=o.attr(n),s={};void 0!==t&&(n+="-",a.each(this.params,function(){s[this]=o.attr(n+this)}),this.adapt({element:e,form:d,message:t,params:s,rules:r,messages:i}))}),a.extend(r,{__dummy__:!0}),n||t.attachValidation())},parse:function(e){var n=a(e),t=n.parents().addBack().filter("form").add(n.find("form")).has("[data-val=true]");n.find("[data-val=true]").each(function(){f.unobtrusive.parseElement(this,!0)}),t.each(function(){var a=u(this);a&&a.attachValidation()})}},m=f.unobtrusive.adapters,m.add=function(a,e,n){return n||(n=e,e=[]),this.push({name:a,params:e,adapt:n}),this},m.addBool=function(a,n){return this.add(a,function(t){e(t,n||a,!0)})},m.addMinMax=function(a,n,t,r,i,o){return this.add(a,[i||"min",o||"max"],function(a){var i=a.params.min,o=a.params.max;i&&o?e(a,r,[i,o]):i?e(a,n,i):o&&e(a,t,o)})},m.addSingleVal=function(a,n,t){return this.add(a,[n||"val"],function(r){e(r,t||a,r.params[n])})},f.addMethod("__dummy__",function(a,e,n){return!0}),f.addMethod("regex",function(a,e,n){var t;return!!this.optional(e)||(t=new RegExp(n).exec(a),t&&0===t.index&&t[0].length===a.length)}),f.addMethod("nonalphamin",function(a,e,n){var t;return n&&(t=a.match(/\W/g),t=t&&t.length>=n),t}),f.methods.extension?(m.addSingleVal("accept","mimtype"),m.addSingleVal("extension","extension")):m.addSingleVal("extension","extension","accept"),m.addSingleVal("regex","pattern"),m.addBool("creditcard").addBool("date").addBool("digits").addBool("email").addBool("number").addBool("url"),m.addMinMax("length","minlength","maxlength","rangelength").addMinMax("range","min","max","range"),m.addMinMax("minlength","minlength").addMinMax("maxlength","minlength","maxlength"),m.add("equalto",["other"],function(n){var o=r(n.element.name),d=n.params.other,s=i(d,o),l=a(n.form).find(":input").filter("[name='"+t(s)+"']")[0];e(n,"equalTo",l)}),m.add("required",function(a){"INPUT"===a.element.tagName.toUpperCase()&&"CHECKBOX"===a.element.type.toUpperCase()||e(a,"required",!0)}),m.add("remote",["url","type","additionalfields"],function(o){var d={url:o.params.url,type:o.params.type||"GET",data:{}},s=r(o.element.name);a.each(n(o.params.additionalfields||o.element.name),function(e,n){var r=i(n,s);d.data[r]=function(){var e=a(o.form).find(":input").filter("[name='"+t(r)+"']");return e.is(":checkbox")?e.filter(":checked").val()||e.filter(":hidden").val()||"":e.is(":radio")?e.filter(":checked").val()||"":e.val()}}),e(o,"remote",d)}),m.add("password",["min","nonalphamin","regex"],function(a){a.params.min&&e(a,"minlength",a.params.min),a.params.nonalphamin&&e(a,"nonalphamin",a.params.nonalphamin),a.params.regex&&e(a,"regex",a.params.regex)}),m.add("fileextensions",["extensions"],function(a){e(a,"extension",a.params.extensions)}),a(function(){f.unobtrusive.parse(document)}),f.unobtrusive});
const editor = kendo.ui.Editor;

editor.defaultTools['insertLineBreak'].options.shift = false;
editor.defaultTools['insertParagraph'].options.shift = true;

window.kendoWindowOptions = {
    draggable: true,
    scrollable: true,
    visible: false,
    animation: false,
    resizable: true
}

$(() => {
    setControlsSettings();
});

function deletePopup(afterConfirmFunc, afterCancelFunc, confirmText) {
    if (!confirmText)
        confirmText = 'Вы уверены, что Вы хотите удалить запись? Это действие необратимо! Продолжить?';

    window.swal.fire({
        title: 'Вы уверены?',
        text: confirmText,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Удалить!',
        cancelButtonText: 'Отмена',
        focusCancel: true
    })
        .then((result) => {
            if (result.value)
                (afterConfirmFunc || jQuery.noop)();
            else
                (afterCancelFunc || jQuery.noop)();
        });
}

function formatUrl(url) {
    return url.replace(/&amp;/g, '&');
}

function numberOrNull(value) {
    if (!value) return null;
    const number = Number(value);
    return isNaN(number) ? null : number
}

function valueOrNull(value) {
    return value === 'novalue' ? null : value || null;
}

function simpleDtoOrNull(id) {
    return id && !isNaN(id)
        ? { Id: id }
        : null;
}

function addGridClickHandler(gridId, event, ...additionalSelectors) {
    let additionSelectorsString = "";
    
    if (additionalSelectors) 
        additionSelectorsString = additionalSelectors.join(" ");
    
    $(`#${gridId}`).on("dblclick", `tr.k-state-selected ${additionSelectorsString}`, event);
}

function adjustGridHeight(grid) {
    const resizeGrid = () => {
        const gridOffsetTop = grid.position().top;

        if (gridOffsetTop >= innerHeight - 100) {
            grid.addClass('k-grid_height-auto');
        } else {
            grid.css('height', innerHeight - gridOffsetTop - 15 + 'px');
            grid.removeClass('k-grid_height-auto');
        }
        setTimeout(kendo.resize.bind(null, grid));
    };

    resizeGrid();
    $(window).on('resize', resizeGrid);
}
function teleportHtmlElement(el, to, type = "prepend") {
    const htmlEl = $(el);
    const dataAttrTo = to? to : htmlEl.data('teleport-to');
    let typeMove = htmlEl.data('teleport-type');
    if(!typeMove) {
        typeMove = type;
    }
    htmlEl.removeAttr('data-teleport-to');
    htmlEl.removeAttr('data-teleport-type');
    
    switch (typeMove) {
        case "prepend":{
            $(dataAttrTo).prepend(htmlEl.detach());
            return;
        }
        case "append":{
            $(dataAttrTo).append(htmlEl.detach());
            return;
        }
    }
    
}

$(() => setTimeout(() => $('[data-teleport-to]').each((_, el) => teleportHtmlElement(el))));
function formResult(result) {
    lockPage(false);
    
    if (!result.StatusCode)
        return false;

    const statusCodeGroup = parseInt(result.StatusCode / 100);
    switch (statusCodeGroup) {
        // Если статус сообщения ОК - выводим положительное сообщение
        case 2:
            if(result.Message !== '')
                window.swal.fire('Успешно!', `${result.Message}`, 'success');

            // Если путь для редиректа указан - переходим по нему
            if (result.RedirectPath)
                setTimeout( () => window.location.href = result.RedirectPath, 1000);
            return true;
        // Если ошибка сервера или запроса - выводим сообщение об ошибке
        case 4:
        case 5:
            window.swal.fire('Внимание!', `${result.Message}`, 'warning');
            break;
        // Если неожиданный код или неверный ответ - выводим предупреждение
        default:
            window.swal.fire('Внимание!', result.Message ? `${result.Message}` : "Неверный ответ сервера. Данные, возможно, не изменены.", 'warning');
            break;
    }
    
    return false;
}

function onImageResult(result) {
    formResult(result.response);

    const hiddenBlock = $(`#${result.sender.element[0].id.charAt(0).toUpperCase() + result.sender.element[0].id.slice(1)}`);
    
    switch (result.operation) {
        case 'upload': {
            if (result.response.StatusCode === 400) {
                const sender = $(`#${result.sender.element[0].id}`);
                const container = sender.parents('.k-upload').first();
                container.children('ul').children('li').last().remove();
                return;
            }

            // При загрузке файла, меняется его имя только на сервере, но не на клиенте 
            // Поэтому приходится отправлять назад новое имя файла и установить его в название, тайтл и хранилище 
            if (result.response.AdditionData && result.response.AdditionData["ImageName"]) {
                // Контейнер для поля загрузки картинки 
                const sender = $(`#${result.sender.element[0].id}`);
                const container = sender.parents('.k-upload').first();

                // Последний добавленный элемент
                const lastAddedImage = container.children('ul').children('li').last();

                // Поле с именем файла
                const textLabel = lastAddedImage
                    .children('.k-file-name-size-wrapper').last()   // Обёртка текста
                    .children().first();                            // Получение самого лабел

                // Установка текста с новым названием файла
                const imageName = result.response.AdditionData["ImageName"];
                textLabel.html(imageName);
                textLabel.prop("title", imageName);
                // Выгрузка старых данных и подмена имени
                const oldData = lastAddedImage.data('fileNames');
                oldData[0].name = imageName;

                // Обновление данных в хранилище
                lastAddedImage.data('fileNames', oldData);
                
                if(hiddenBlock)
                    hiddenBlock.val(imageName);

            }
            break;
        }
        case 'remove': {
            if(hiddenBlock)
                hiddenBlock.val(null);
            break;
        }
    }
}

// Событие загузки изображения для подмены на него стандартной картинки
function onImageSelect(e) {
    const wrapper = $(this.wrapper);
    e.files.forEach((file)  => addPreview(file, wrapper))
}

// Подмена изображения 
function addPreview(file, wrapper) {
    const raw = file.rawFile;
    const reader = new FileReader();

    if (raw) {
        reader.onloadend = function () {
            teleportHtmlElement($(`<img class='k-preview' src='${this.result}' alt=""/>`), wrapper.find('.k-file'));
        };
        reader.readAsDataURL(raw);
    }
}

function gridOperationBySelected(event, callback, key = "Id") {
    if(!event) return;
    const sender = event.sender || event;
    const elSelected = $(sender.select().first())
    const value = sender.dataItem(elSelected)[key];
    return callback? callback(value) : value;
}

function dropDownValueToKendoEditor(e) {
    const { sender } = e;
    const kendoEditor = $(`#${$(sender.element).attr('name')}`).data("kendoEditor");
    kendoEditor.value(kendoEditor.value() + sender.value());
    sender.select(0);
}

function initPanelBar(wrapper, item, callbackUrl) {
    // Очистка мусора
    $(item).html(null);

    // По клику на категорию, вытягиваем сайты из этой категории
    $(wrapper).click(function(element) {
        const id = element.currentTarget.id;
        const splitId = id.split('-');
        const siteId = splitId[splitId.length - 1];

        const insertArea = $(`#${id} ${item}`);

        // Если уже вытягивали элемент - не вытягиваем
        if (insertArea.html() !== '')
            return;

        // Вытягиваем сайты и записываем в контент категории
        $.ajax({
            url: callbackUrl(siteId),
            method: 'GET',
            success: function(result) {
                insertArea.html(result);
            }
        });
    });
}

function kendoUploadInit(id, pathId) {
    const kendoUploadWrapper = $(`#${id}`).data("kendoUpload");
    const kendoUploadPath = $(`#${pathId}`);

    function onComplete() {
        kendoUploadPath.val(kendoUploadWrapper.getFiles()[0].name);
    }

    function onRemove() {
        kendoUploadPath.val('');
    }

    kendoUploadWrapper.bind("complete", onComplete);
    kendoUploadWrapper.bind("remove", onRemove);
}

function lockPage(lock = true) {
    kendo.ui.progress($(document.body), lock);
}
function ajaxDelete(url, data, doneFunc, failFunc, alwaysFunc) {
    ajaxRequest(url, data, 'DELETE', doneFunc, failFunc, alwaysFunc);
}

function ajaxPost(url, data, doneFunc, failFunc, alwaysFunc) {
    ajaxRequest(url, data, 'POST', doneFunc, failFunc, alwaysFunc);
}

function ajaxGet(url, data, doneFunc, failFunc, alwaysFunc) {
    ajaxRequest(url, data, 'GET', doneFunc, failFunc, alwaysFunc);
}

function ajaxRequest(url, data, type, doneFunc, failFunc, alwaysFunc) {
    $.ajax({
        type: type,
        url: url,
        data: type !== 'GET' ? JSON.stringify(data) : data,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json'
    })
        .done(doneFunc)
        .fail(failFunc)
        .always(alwaysFunc);
}
function dataMultiSelectEvent(dataItem) {
    const valueAll = -1; //Значение пункта - Все
    const key = 'Id' in dataItem ? 'Id' : 'Value';
    const allElements = this.dataSource.data().map((el) => el[key]);
    const valueSelected = dataItem[key];

    const valueUpdate = (newValue) => {
        const scrollPos = this.ul.parent().scrollTop();

        this.value(newValue);

        if (newValue.length) {
            this.search();
            this.ul.parent().scrollTop(scrollPos);
        }
    };

    return {
        isAllItemSelect: valueAll === valueSelected,
        allElements,
        valueAll,
        valueSelected,
        valueUpdate
    };
}

function onMultiSelectSelect(event) {
    const {
        isAllItemSelect,
        allElements,
        valueAll,
        valueUpdate,
        valueSelected
    } = dataMultiSelectEvent.call(this, event.dataItem);

    this._maxTotal = allElements.includes(valueAll) ? allElements.length : allElements.length + 1;

    if (isAllItemSelect || (allElements.includes(valueAll) && this.value().length === allElements.length - 2)) {
        const excludeNum = isAllItemSelect ? valueAll : valueSelected;
        valueUpdate(allElements.filter((num) => num !== excludeNum));
    }
}

function onMultiSelectDeselect(event) {
    const {
        isAllItemSelect,
        valueSelected,
        valueAll,
        valueUpdate
    } = dataMultiSelectEvent.call(this, event.dataItem);

    if (isAllItemSelect) {
        valueUpdate([valueSelected]);
    } else {
        setTimeout(() => valueUpdate(this.value().filter((num) => valueAll !== num)));
    }
}

function msSelectAll() {
    if (this.value().length === 1 && this.value().includes(-1)) {
        const multiselect = this.element.data("kendoMultiSelect");
        const multiselectData = multiselect.dataSource.data();
        let selectedValues = "";
        let strComma = "";
        for (let i = 0; i < multiselectData.length; i++) {
            const item = multiselectData[i];
            
            selectedValues += strComma + (item.Value && item.Value.toString() ? item.Value.toString() : item.IdToString);
            strComma = ",";
        }
        multiselect.value(selectedValues.split(","));
    }
}

var queryFilterParams = {};

function rebindDataSource(control, dontGoToFirstPage) {
    if (!control) {
        console.warn("Rebinding failed, control wasn't found");
        return;
    }

    if (control.pager && !dontGoToFirstPage)
        control.pager.page(1);
    else
        control.dataSource.read();
}

function headerCheckbox_bindCheckEvent() {
    const checkboxGrid = $('.k-grid').has('.k-checkbox');
    const headChb = checkboxGrid.find('thead .k-checkbox');
    headChb.on('change', () => {
        const tableRows = checkboxGrid.find('tbody').find('tr');
        const rowCheckbox = tableRows.find('input[type="checkbox"]');
        if (headChb.is(':checked')) {
            tableRows.addClass('k-state-selected k-selected');
            rowCheckbox.prop('checked', true).attr('aria-checked', 'true');
        }
        else {
            tableRows.removeClass('k-state-selected k-selected');
            rowCheckbox.prop('checked', false).attr('aria-checked', 'false');
        }
    });
}

function autoInitControls() {
    let controlName;
    
    $('[data-role]').each((_, v) => {
        const elem = $(v);
        controlName = elem.attr('id');
        
        if (controlName && controlName.endsWith('_Id') && controlName[0].toUpperCase === controlName[0]) {
            controlName[0] = controlName[0].toLowerCase();
            controlName = controlName.substring(0, controlName.length() - 3);
        }
        
        const kendoTypeName = Object
            .getOwnPropertyNames(elem.data())
            .find((item) => item.startsWith('kendo') && item !== 'kendoPopup' && item !== 'kendoStaticList');
        
        if (!controlName || !kendoTypeName) return;
        // ReSharper disable ImplicitAnyError
        window[controlName] = elem.data(kendoTypeName);
        
        if (kendoTypeName === 'kendoUpload') {
            const entityType = $('#EntityType');
            const container = elem.parent().parent().parent();
            const id = $('#Id').val();
            const AddedImages = container.children('ul').children('li');
            $.each(AddedImages, (index, image) => {
                
                const textLabel = $(image).children('.k-file-name-size-wrapper').last().children().first();
                if (entityType && textLabel.text()) {
                    const url= '/Upload/GetFile';
                    const data = {
                        'fileName': textLabel.text(),
                        'entityType': entityType.val(),
                        'entityId': id
                    };

                    ajaxGet(url, data, (response) => {
                        const preview = $('<img class="image-preview">').attr('src', response);

                        if (elem.hasClass('small-image-preview')) {
                            preview.addClass('image-preview_small')
                        }

                        $(image).prepend(preview);
                    });
                }
            })
        }
        
        if (elem.hasClass('list-dynamic')) {
            elem.data(kendoTypeName).input.keydown(({ keyCode }) => {
                const inp = String.fromCharCode(keyCode);
                
                if (/[a-zA-Zа-яА-Я ]/.test(inp)) {
                    rebindDataSource(elem.data(kendoTypeName));
                }
            });
        }
    });
}

function collectFilters() {
    if (window.location.search.includes('?Id=') && !window.isLoaded)
        return;

    var filterString = '?IsFilter=0&';

    $('.filters input, .filters select, .filters .k-button-group').each(function () {
        const input = $(this);
        const noValue = 'novalue';
        if (input.hasClass('k-textbox')) {
            const control = input[0];
            if (!input.data().role && control.value)
                filterString += `${input[0].id}=${control.value}&`;
            else
                filterString += `${input[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'numerictextbox') {
            const control = input.data('kendoNumericTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'maskedtextbox') {
            const control = input.data('kendoMaskedTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'textbox') {
            const control = input.data('kendoTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'combobox') {
            const control = input.data('kendoComboBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'dropdownlist') {
            const control = input.data('kendoDropDownList');
            if (control.element[0].id && control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'multiselect') {
            const control = input.data('kendoMultiSelect');
            if (control.value().length > 0) {
                if (control.dataSource.data().length === control.value().length && control.dataSource.data().length !== 1)
                    filterString += `${control.element[0].id}=CI_All&`;
                else
                    filterString += `${control.element[0].id}=${control.value()}&`;
            }
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'datepicker') {
            const control = input.data('kendoDatePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleDateString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'timepicker') {
            const control = input.data('kendoTimePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleTimeString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'datetimepicker') {
            const control = input.data('kendoDateTimePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'buttongroup') {
            const control = input.data('kendoButtonGroup');
            filterString += `${control.element[0].id}=${control.selectedIndices.join()}&`;
        }
        else if (input.hasClass('k-checkbox')) {
            const control = (this);
            filterString += `${control.name}=${control.checked ? '1' : '0'}&`;
        }
    });
    const grid = findFirstGrid();
    if (grid)
        queryFilterParams['settings'] = getState(grid);

    Object.keys(queryFilterParams).forEach((key) => {
        filterString += `${key}=${queryFilterParams[key]}&`;
    });
    filterString = filterString.slice(0, -1);
    const newurl = window.location.protocol + '//' + window.location.host + window.location.pathname.toLowerCase() + filterString;
    window.history.pushState({
        path: newurl
    }, '', newurl);
}
function getState(grid) {
    const dataSource = grid.dataSource;
    const columns = grid.columns.filter(column => !column.hidden).map(c => c.field);
    return kendo.stringify({
        sort: dataSource.sort(),
        page: dataSource.page(),
        pageSize: dataSource.pageSize(),
        group: dataSource.group().map((c) => ({ field: c.field, dir: c.dir })),
        columns: columns
    });
}
function getGridId(grid) {
    if (!grid || !grid.wrapper)
        return null;
    return grid.wrapper.attr('id');
}
function findFirstGrid() {
    const gridElements = $('.k-grid:not(.grid-without-settings)');
    if (gridElements.length === 0) {
        console.warn('Not found any grids!');
        return null;
    }
    const firstGrid = gridElements.first().data('kendoGrid');
    if (gridElements.length > 1)
        console.warn(`Found ${gridElements.length} grid elements! Using first: ${getGridId(firstGrid)}`);
    return firstGrid;
}
function setFilters(grid, withoutRebind) {
    const paramDictionary = getQueryParams();
    Object.keys(paramDictionary).forEach(key => {
        const control = $(`#${key}`);
        const ms = control.data('kendoMultiSelect');
        const noValue = 'novalue';
        if (ms) {
            let ids;
            if (paramDictionary[key] === 'CI_All') {
                ids = ms.dataSource.data().map((a) => a.Id);
                ms.value(ids);
            }
            else if (paramDictionary[key] === noValue)
                ms.value(null);
            else {
                paramDictionary[key] = decodeURI(paramDictionary[key]);
                if (paramDictionary[key].includes('%2C'))
                    ids = paramDictionary[key].split('%2C').map((a) => a);
                else
                    ids = paramDictionary[key].split(',').map((a) => a);
                ms.value(ids);
                if (ms.dataSource.options.serverFiltering) {
                    updateDynamicMultiSelectItems(ms, ids.map((id) => ({
                        Id: id
                    })));
                }
            }
            return;
        }
        const cb = control.data('kendoComboBox');
        if (cb) {
            if (paramDictionary[key] !== noValue) {
                cb.value(decodeURI(paramDictionary[key]));
                if (cb.dataSource.options.serverFiltering)
                    cb.dataSource.read();
            }
            else
                cb.value('');
            return;
        }
        const dd = control.data('kendoDropDownList');
        if (dd) {
            if (paramDictionary[key] !== noValue)
                dd.value(decodeURI(paramDictionary[key]));
            else
                dd.value('');
            return;
        }
        const ntb = control.data('kendoNumericTextBox');
        if (ntb) {
            if (paramDictionary[key] !== noValue)
                ntb.value(paramDictionary[key]);
            else
                ntb.value('');
            return;
        }
        const mtb = control.data('kendoMaskedTextBox');
        if (mtb) {
            if (paramDictionary[key] !== noValue)
                mtb.value(paramDictionary[key]);
            else
                mtb.value('');
            return;
        }
        const tb = control.data('kendoTextBox');
        if (tb) {
            if (paramDictionary[key] !== noValue)
                tb.value(decodeURI(paramDictionary[key]));
            else
                tb.value('');
            return;
        }
        const bg = control.data('kendoButtonGroup');
        if (bg) {
            bg.select(parseInt(paramDictionary[key]));
            return;
        }
        const chb = control;
        if (chb.hasClass('k-checkbox')) {
            if (paramDictionary[key] !== noValue)
                $(chb)[0].checked = paramDictionary[key] === '1';
        }
        paramDictionary[key] = paramDictionary[key].replace(/%E2%80%8E/g, ''); //     #18843
        const dp = control.data('kendoDatePicker');
        if (dp) {
            if (paramDictionary[key] !== noValue)
                dp.value(paramDictionary[key]);
            else
                dp.value('');
            return;
        }
        const tp = control.data('kendoTimePicker');
        if (tp) {
            if (paramDictionary[key] !== noValue)
                tp.value(decodeURI(paramDictionary[key]));
            else
                tp.value('');
            return;
        }
        const dtp = control.data('kendoDateTimePicker');
        if (dtp) {
            if (paramDictionary[key] !== noValue)
                dtp.value(decodeURI(paramDictionary[key]));
            else
                dtp.value('');
            return;
        }
        if (paramDictionary[key] !== noValue)
            control.val(decodeURI(paramDictionary[key]));
        else
            control.val('');
        if (control.length === 0 && paramDictionary[key] !== noValue)
            queryFilterParams[key] = decodeURI(paramDictionary[key]);
    });
    if (grid && !withoutRebind)
        rebindDataSource(grid);
}
function getQueryParams() {
    const parsedSearch = kendo.parseQueryStringParams(location.search);
    delete parsedSearch['IsFilter'];
    return parsedSearch;
}

function updateDynamicMultiSelectItems(control, items) {
    const backControl = control;
    const missingItems = items.filter((ticket) => backControl.dataItems().filter((item) => ticket.Id === item.Id).length === 0);
    if (missingItems.length > 0) {
        const ids = items.map((x) => x.Id);
        const filter = {
            field: 'Text',
            operator: 'contains',
            value: ids.join(',')
        };
        backControl.dataSource.filter(filter);
        backControl.listView.setDSFilter(backControl.dataSource.filter());
        setTimeout(() => {
            backControl.value(ids);
        }, 2500);
    }
}

function getSettings() {
    const { settings } = kendo.parseQueryStringParams(location.search);
    return settings ? JSON.parse(settings) : null;
}

function collectFiltersOnChangeDataSource({ sender }) {
    if (location.search.includes('?Id=')) {
        return;
    }
    const currentUrl = new URL(location.href);
    const settingsGrid = getState(sender);

    currentUrl.searchParams.set('IsFilter', '0');

    $('.filters input, .filters select, .filters .k-button-group').each(function () {
        const input = $(this);
        const noValue = 'novalue';
        const key = this.id;

        if (input.hasClass('k-textbox')) {
            const value = input.val();
            const isExist = !input.data().role && value;
            currentUrl.searchParams.set(key, isExist ? value : noValue);
        }
        else if (input.hasClass('k-checkbox')) {
            currentUrl.searchParams.set(this.name, this.checked ? '1' : '0');
        }
        else {
            switch (input.data().role) {
                case 'numerictextbox': {
                    const control = input.data('kendoNumericTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'maskedtextbox': {
                    const control = input.data('kendoMaskedTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'textbox': {
                    const control = input.data('kendoTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'combobox': {
                    const control = input.data('kendoComboBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'dropdownlist': {
                    const control = input.data('kendoDropDownList');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'multiselect': {
                    const control = input.data('kendoMultiSelect');
                    const dataLength = control.dataSource.data().length;
                    const value = control.value();

                    if (value.length) {
                        currentUrl.searchParams.set(key, dataLength === value.length && dataLength !== 1 ? 'CI_All' : value);
                    }
                    else {
                        currentUrl.searchParams.set(key, noValue);
                    }
                    break;
                }
                case 'datepicker': {
                    const control = input.data('kendoDatePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleDateString('RU-ru') : noValue);
                    break;
                }
                case 'timepicker': {
                    const control = input.data('kendoTimePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleTimeString('RU-ru') : noValue);
                    break;
                }
                case 'datetimepicker': {
                    const control = input.data('kendoDateTimePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleString('RU-ru') : noValue);
                    break;
                }
                case 'buttongroup': {
                    const control = input.data('kendoButtonGroup');
                    currentUrl.searchParams.set(key, control.selectedIndices.join());
                    break;
                }
            }
        }
    });

    currentUrl.searchParams.set('settings', settingsGrid);
    
    if (!window.neededPushParamsToSearch) {
        window.neededPushParamsToSearch = true;
        return;
    }
    
    history.pushState({ path: currentUrl.href }, '', currentUrl.href);
}

function recollectFiltersOnSourceChange(instanceGrid) {
    if (!instanceGrid) return;
    instanceGrid.bind('columnShow', collectFiltersOnChangeDataSource);
    instanceGrid.bind('columnHide', collectFiltersOnChangeDataSource);
    instanceGrid.bind('dataBound', collectFiltersOnChangeDataSource);
}

function setSettingsGrid(instanceGrid) {
    if (!instanceGrid) return;

    const settings = getSettings();
    
    if (!settings) {
        /* Если в урле нет параметров - просто грузим грид */
        instanceGrid.dataSource.read();
        return;
    }

    if (settings.group) {
        const groups = settings.group;
        const aggregates = instanceGrid.dataSource.aggregate();

        groups.forEach((group) => group['aggregates'] = aggregates);
        instanceGrid.dataSource._group = groups;
    }

    if (settings.pageSize) {
        instanceGrid.dataSource._pageSize = settings.pageSize;
    }

    if (settings.page) {
        instanceGrid.dataSource._page = settings.page;
    }

    if (settings.columns) {
        instanceGrid.columns.forEach((col) => {
            const isExists = settings.columns.includes(col.field);
            instanceGrid[!isExists && col.field ? 'hideColumn' : 'showColumn'](col.field);
        });
    }

    if (settings.sort) {
        instanceGrid.dataSource.sort(settings.sort);
    } else {
        instanceGrid.dataSource.read();
    }
}
function dynamicComboBoxFilter(e, comboName, additionalParams = undefined) {
    let txt = '';
    if (e.filter && e.filter.filters[0])
        txt = e.filter.filters[0].value;
    else if (comboName) {
        comboName = comboName.replace(/\./g, '_');
        const combo = $(`#${comboName}`).data('kendoComboBox');
        if (combo)
            txt = combo.text();
    }
    const result = additionalParams ? additionalParams() : {};
    result.text = txt;
    return result;
}
function dynamicMultiSelectFilter(e, comboName, additionalParams = undefined) {
    let txt = '';
    if (e.filter && e.filter.filters[0])
        txt = e.filter.filters[0].value;
    else if (comboName) {
        comboName = comboName.replace(/\./g, '_');
        const combo = $(`#${comboName}`).data('kendoMultiSelect');
        if (combo)
            txt = combo.value();
    }
    const result = additionalParams ? additionalParams() : {};
    result.text = txt;
    return result;
}
function setGridPipelineStatusBackColor(grid, fieldName, colorFieldName) {
    if (!grid || !fieldName || !colorFieldName)
        return;
    let statusColumnIndex = getColumnIndexByField(grid, fieldName);
    if (statusColumnIndex !== -1) {
        const rows = statusColumnIndex < -1
            ? grid.lockedTable.children().last().children()
            : grid.tbody.children();
        statusColumnIndex = statusColumnIndex < -1 ? -statusColumnIndex - 2 : statusColumnIndex;
        for (let i = 0; i < rows.length; i++) {
            const row = $(rows[i]);
            const dataItem = grid.dataItem(row);
            if (dataItem && !row.hasClass('k-group-footer')) {
                const statusCell = row.children().eq(statusColumnIndex);
                const cell = statusCell[0];
                if(cell === null || cell === undefined)
                    continue;

                const color = dataItem.get(colorFieldName);
                if(color)
                    cell.style.setProperty('background-color', `#${color.replace('#', '')}`, 'important');
            }
        }
    }
}
function getColumnIndexByField(grid, field) {
    if (grid.wrapper.find(`.k-grid-content-locked`).length > 0) {
        const headers = grid.wrapper.find(`.k-grid-header`).children();
        return headers.first().find(`[data-field=${field}]`).length !== 0
            ? -headers.first().find(`[data-field=${field}]`).index() - 2
            : headers.last().find(`[data-field=${field}]`).index();
    }
    else {
        return grid.wrapper.find(`.k-grid-header [data-field=${field}]`).index();
    }
}
function setControlsSettings() {
    const filesGridDiv = $('#grFiles');
    
    if (filesGridDiv.length === 1) {
        filesGridDiv.on('mousedown', "tr[role='row']", gridRowRightClick);
    }
    
    setComboBoxSettings()
    
    $('[data-role=datepicker]').each(function () {
        const widget = $(this).data('kendoDatePicker');
        
        try {
            $(widget.element).on('change', validateDateInput);
        } catch (e) {
            console.log(`Кто то, что то упустил, ошибка: ${e.message}`);
        }
    });
    
    $('input[type=text]').focus(function () {
        var input = $(this);
        
        if (input[0].getAttribute('role') === 'combobox' || input[0].getAttribute('role') === 'multiselect') { 
            return; 
        }
        
        clearTimeout(input.data('selectTimeId'));
        
        const selectTimeId = setTimeout(() => input.select());
        
        input.data('selectTimeId', selectTimeId);
    }).blur(() => clearTimeout($(this).data('selectTimeId')));
    
    $('input').focus(function () {
        $(this).select();
    });
    
    $('input[data-role=numerictextbox]').focus(function () {
        const input = $(this).select();
        
        if (input.val() === '0') {
            input.val('');
        }
        
        input.on('paste', kendoNumericTextBoxOnPaste);
    });
}

function selectedKeys(grid) {
    return $('.k-grid-content-sticky').find("input[aria-checked='true']").map(function () {
        return grid.dataSource.getByUid($(this).parent().parent().data('uid')).get('Id');
    }).get();
}

function kendoNumericTextBoxOnPaste(e) {
    const data = e.originalEvent.clipboardData.getData('text');
    if (data.indexOf(' ') !== -1) {
        setTimeout(() => {
            $(e.target).data('kendoNumericTextBox').value(data.replace(' ', ''));
            $(e.target).data('kendoNumericTextBox').trigger('change');
        }, 100);
    }
}

function setColorsOnTicketsGrid(grid) {
    const priorityColumnIndex = getColumnIndexByField(grid, 'PriorityName');
    const pipelineStatusColumnIndex = getColumnIndexByField(grid, 'PipelineStatusName');
    const pipelineNameColumnIndex = getColumnIndexByField(grid, 'ColorName');
    const rows = grid.tbody.children();
    for (let i = 0; i < rows.length; i++) {
        if ($(rows[i]).hasClass('k-group-footer'))
            continue;
        const row = $(rows[i]);
        const dataItem = grid.dataItem(row);
        if (!dataItem)
            return;
        if (priorityColumnIndex !== -1) {
            const priorityColor = dataItem.get('PriorityColorColorValue');
            const priorityCell = row.children().eq(priorityColumnIndex);
            priorityCell.css('background', `#${priorityColor}`);
        }
        if (pipelineNameColumnIndex !== -1) {
            const pipelineColor = dataItem.get('ColorColorValue');
            const pipelineCell = row.children().eq(pipelineNameColumnIndex);
            pipelineCell.css('background', `#${pipelineColor}`);
        }
        if (pipelineStatusColumnIndex !== -1) {
            const pipelineStatusColor = dataItem.get('PipelineStatusColorColorValue');
            const pipelineStatusCell = row.children().eq(pipelineStatusColumnIndex);
            pipelineStatusCell.css('background', `#${pipelineStatusColor}`);
        }
    }
}

function setComboBoxSettings() {
    $('[data-role=combobox]').each(function () {
        const widget = $(this).data('kendoComboBox');
        
        if (widget.input.attr('aria-disabled') === 'true') return;
        
        widget.input.focus(() => {
            if (widget.options.enabled) {
                widget.open();
                widget.input.select();
            }
        });
        
        widget.input.focusout(() => {
            widget.close();
        });
        
        widget.input[0].setAttribute('autocomplete', 'off');
    });
}

function dtStart_onChange() {
    const dtEnd = window['dtEnd'];

    if (this.value() && dtEnd.value() && this.value() > dtEnd.value()) {
        dtEnd.value(this.value());
    }
}

function dtEnd_onChange() {
    const dtStart = window['dtStart'];

    if (dtStart.value() && this.value() && this.value() < dtStart.value()) {
        dtStart.value(this.value());
    }
}

function rebindAsync (instance) {
    return new Promise((resolve) => {
        instance.dataSource.read().done(resolve);
    });
}
function convertMinutesToHoursMinutes(minutes) {
    if (!minutes)
        return '';

    const hours = String(Math.floor(minutes / 60)).padStart(2, '0');
    const remainingMinutes = String(minutes % 60).padStart(2, '0');

    return `${hours}:${remainingMinutes}`;
}

function convertMinutesToDaysHoursMinutes(minutes) {
    if (!minutes)
        return '';

    const days = String(Math.floor(minutes / 1440)).padStart(2, '0'); // 24 * 60 = 1440
    const hours = String(Math.floor((minutes % 1440) / 60)).padStart(2, '0');
    const remainingMinutes = String(minutes % 60).padStart(2, '0');

    return `${days}:${hours}:${remainingMinutes}`;
}