function formResult(result) {
    lockPage(false);
    
    if (!result.StatusCode)
        return false;

    const statusCodeGroup = parseInt(result.StatusCode / 100);
    switch (statusCodeGroup) {
        // Если статус сообщения ОК - выводим положительное сообщение
        case 2:
            if(result.Message !== '')
                window.swal.fire('Успешно!', `${result.Message}`, 'success');

            // Если путь для редиректа указан - переходим по нему
            if (result.RedirectPath)
                setTimeout( () => window.location.href = result.RedirectPath, 1000);
            return true;
        // Если ошибка сервера или запроса - выводим сообщение об ошибке
        case 4:
        case 5:
            window.swal.fire('Внимание!', `${result.Message}`, 'warning');
            break;
        // Если неожиданный код или неверный ответ - выводим предупреждение
        default:
            window.swal.fire('Внимание!', result.Message ? `${result.Message}` : "Неверный ответ сервера. Данные, возможно, не изменены.", 'warning');
            break;
    }
    
    return false;
}

function onImageResult(result) {
    formResult(result.response);

    const hiddenBlock = $(`#${result.sender.element[0].id.charAt(0).toUpperCase() + result.sender.element[0].id.slice(1)}`);
    
    switch (result.operation) {
        case 'upload': {
            if (result.response.StatusCode === 400) {
                const sender = $(`#${result.sender.element[0].id}`);
                const container = sender.parents('.k-upload').first();
                container.children('ul').children('li').last().remove();
                return;
            }

            // При загрузке файла, меняется его имя только на сервере, но не на клиенте 
            // Поэтому приходится отправлять назад новое имя файла и установить его в название, тайтл и хранилище 
            if (result.response.AdditionData && result.response.AdditionData["ImageName"]) {
                // Контейнер для поля загрузки картинки 
                const sender = $(`#${result.sender.element[0].id}`);
                const container = sender.parents('.k-upload').first();

                // Последний добавленный элемент
                const lastAddedImage = container.children('ul').children('li').last();

                // Поле с именем файла
                const textLabel = lastAddedImage
                    .children('.k-file-name-size-wrapper').last()   // Обёртка текста
                    .children().first();                            // Получение самого лабел

                // Установка текста с новым названием файла
                const imageName = result.response.AdditionData["ImageName"];
                textLabel.html(imageName);
                textLabel.prop("title", imageName);
                // Выгрузка старых данных и подмена имени
                const oldData = lastAddedImage.data('fileNames');
                oldData[0].name = imageName;

                // Обновление данных в хранилище
                lastAddedImage.data('fileNames', oldData);
                
                if(hiddenBlock)
                    hiddenBlock.val(imageName);

            }
            break;
        }
        case 'remove': {
            if(hiddenBlock)
                hiddenBlock.val(null);
            break;
        }
    }
}

// Событие загузки изображения для подмены на него стандартной картинки
function onImageSelect(e) {
    const wrapper = $(this.wrapper);
    e.files.forEach((file)  => addPreview(file, wrapper))
}

// Подмена изображения 
function addPreview(file, wrapper) {
    const raw = file.rawFile;
    const reader = new FileReader();

    if (raw) {
        reader.onloadend = function () {
            teleportHtmlElement($(`<img class='k-preview' src='${this.result}' alt=""/>`), wrapper.find('.k-file'));
        };
        reader.readAsDataURL(raw);
    }
}

function gridOperationBySelected(event, callback, key = "Id") {
    if(!event) return;
    const sender = event.sender || event;
    const elSelected = $(sender.select().first())
    const value = sender.dataItem(elSelected)[key];
    return callback? callback(value) : value;
}

function dropDownValueToKendoEditor(e) {
    const { sender } = e;
    const kendoEditor = $(`#${$(sender.element).attr('name')}`).data("kendoEditor");
    kendoEditor.value(kendoEditor.value() + sender.value());
    sender.select(0);
}

function initPanelBar(wrapper, item, callbackUrl) {
    // Очистка мусора
    $(item).html(null);

    // По клику на категорию, вытягиваем сайты из этой категории
    $(wrapper).click(function(element) {
        const id = element.currentTarget.id;
        const splitId = id.split('-');
        const siteId = splitId[splitId.length - 1];

        const insertArea = $(`#${id} ${item}`);

        // Если уже вытягивали элемент - не вытягиваем
        if (insertArea.html() !== '')
            return;

        // Вытягиваем сайты и записываем в контент категории
        $.ajax({
            url: callbackUrl(siteId),
            method: 'GET',
            success: function(result) {
                insertArea.html(result);
            }
        });
    });
}

function kendoUploadInit(id, pathId) {
    const kendoUploadWrapper = $(`#${id}`).data("kendoUpload");
    const kendoUploadPath = $(`#${pathId}`);

    function onComplete() {
        kendoUploadPath.val(kendoUploadWrapper.getFiles()[0].name);
    }

    function onRemove() {
        kendoUploadPath.val('');
    }

    kendoUploadWrapper.bind("complete", onComplete);
    kendoUploadWrapper.bind("remove", onRemove);
}

function lockPage(lock = true) {
    kendo.ui.progress($(document.body), lock);
}