﻿function dataMultiSelectEvent(dataItem) {
    const valueAll = -1; //Значение пункта - Все
    const key = 'Id' in dataItem ? 'Id' : 'Value';
    const allElements = this.dataSource.data().map((el) => el[key]);
    const valueSelected = dataItem[key];

    const valueUpdate = (newValue) => {
        const scrollPos = this.ul.parent().scrollTop();

        this.value(newValue);

        if (newValue.length) {
            this.search();
            this.ul.parent().scrollTop(scrollPos);
        }
    };

    return {
        isAllItemSelect: valueAll === valueSelected,
        allElements,
        valueAll,
        valueSelected,
        valueUpdate
    };
}

function onMultiSelectSelect(event) {
    const {
        isAllItemSelect,
        allElements,
        valueAll,
        valueUpdate,
        valueSelected
    } = dataMultiSelectEvent.call(this, event.dataItem);

    this._maxTotal = allElements.includes(valueAll) ? allElements.length : allElements.length + 1;

    if (isAllItemSelect || (allElements.includes(valueAll) && this.value().length === allElements.length - 2)) {
        const excludeNum = isAllItemSelect ? valueAll : valueSelected;
        valueUpdate(allElements.filter((num) => num !== excludeNum));
    }
}

function onMultiSelectDeselect(event) {
    const {
        isAllItemSelect,
        valueSelected,
        valueAll,
        valueUpdate
    } = dataMultiSelectEvent.call(this, event.dataItem);

    if (isAllItemSelect) {
        valueUpdate([valueSelected]);
    } else {
        setTimeout(() => valueUpdate(this.value().filter((num) => valueAll !== num)));
    }
}

function msSelectAll() {
    if (this.value().length === 1 && this.value().includes(-1)) {
        const multiselect = this.element.data("kendoMultiSelect");
        const multiselectData = multiselect.dataSource.data();
        let selectedValues = "";
        let strComma = "";
        for (let i = 0; i < multiselectData.length; i++) {
            const item = multiselectData[i];
            
            selectedValues += strComma + (item.Value && item.Value.toString() ? item.Value.toString() : item.IdToString);
            strComma = ",";
        }
        multiselect.value(selectedValues.split(","));
    }
}

var queryFilterParams = {};

function rebindDataSource(control, dontGoToFirstPage) {
    if (!control) {
        console.warn("Rebinding failed, control wasn't found");
        return;
    }

    if (control.pager && !dontGoToFirstPage)
        control.pager.page(1);
    else
        control.dataSource.read();
}

function headerCheckbox_bindCheckEvent() {
    const checkboxGrid = $('.k-grid').has('.k-checkbox');
    const headChb = checkboxGrid.find('thead .k-checkbox');
    headChb.on('change', () => {
        const tableRows = checkboxGrid.find('tbody').find('tr');
        const rowCheckbox = tableRows.find('input[type="checkbox"]');
        if (headChb.is(':checked')) {
            tableRows.addClass('k-state-selected k-selected');
            rowCheckbox.prop('checked', true).attr('aria-checked', 'true');
        }
        else {
            tableRows.removeClass('k-state-selected k-selected');
            rowCheckbox.prop('checked', false).attr('aria-checked', 'false');
        }
    });
}

function autoInitControls() {
    let controlName;
    
    $('[data-role]').each((_, v) => {
        const elem = $(v);
        controlName = elem.attr('id');
        
        if (controlName && controlName.endsWith('_Id') && controlName[0].toUpperCase === controlName[0]) {
            controlName[0] = controlName[0].toLowerCase();
            controlName = controlName.substring(0, controlName.length() - 3);
        }
        
        const kendoTypeName = Object
            .getOwnPropertyNames(elem.data())
            .find((item) => item.startsWith('kendo') && item !== 'kendoPopup' && item !== 'kendoStaticList');
        
        if (!controlName || !kendoTypeName) return;
        // ReSharper disable ImplicitAnyError
        window[controlName] = elem.data(kendoTypeName);
        
        if (kendoTypeName === 'kendoUpload') {
            const entityType = $('#EntityType');
            const container = elem.parent().parent().parent();
            const id = $('#Id').val();
            const AddedImages = container.children('ul').children('li');
            $.each(AddedImages, (index, image) => {
                
                const textLabel = $(image).children('.k-file-name-size-wrapper').last().children().first();
                if (entityType && textLabel.text()) {
                    const url= '/Upload/GetFile';
                    const data = {
                        'fileName': textLabel.text(),
                        'entityType': entityType.val(),
                        'entityId': id
                    };

                    ajaxGet(url, data, (response) => {
                        const preview = $('<img class="image-preview">').attr('src', response);

                        if (elem.hasClass('small-image-preview')) {
                            preview.addClass('image-preview_small')
                        }

                        $(image).prepend(preview);
                    });
                }
            })
        }
        
        if (elem.hasClass('list-dynamic')) {
            elem.data(kendoTypeName).input.keydown(({ keyCode }) => {
                const inp = String.fromCharCode(keyCode);
                
                if (/[a-zA-Zа-яА-Я ]/.test(inp)) {
                    rebindDataSource(elem.data(kendoTypeName));
                }
            });
        }
    });
}

function collectFilters() {
    if (window.location.search.includes('?Id=') && !window.isLoaded)
        return;

    var filterString = '?IsFilter=0&';

    $('.filters input, .filters select, .filters .k-button-group').each(function () {
        const input = $(this);
        const noValue = 'novalue';
        if (input.hasClass('k-textbox')) {
            const control = input[0];
            if (!input.data().role && control.value)
                filterString += `${input[0].id}=${control.value}&`;
            else
                filterString += `${input[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'numerictextbox') {
            const control = input.data('kendoNumericTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'maskedtextbox') {
            const control = input.data('kendoMaskedTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'textbox') {
            const control = input.data('kendoTextBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'combobox') {
            const control = input.data('kendoComboBox');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'dropdownlist') {
            const control = input.data('kendoDropDownList');
            if (control.element[0].id && control.value())
                filterString += `${control.element[0].id}=${control.value()}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'multiselect') {
            const control = input.data('kendoMultiSelect');
            if (control.value().length > 0) {
                if (control.dataSource.data().length === control.value().length && control.dataSource.data().length !== 1)
                    filterString += `${control.element[0].id}=CI_All&`;
                else
                    filterString += `${control.element[0].id}=${control.value()}&`;
            }
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'datepicker') {
            const control = input.data('kendoDatePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleDateString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'timepicker') {
            const control = input.data('kendoTimePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleTimeString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'datetimepicker') {
            const control = input.data('kendoDateTimePicker');
            if (control.value())
                filterString += `${control.element[0].id}=${control.value().toLocaleString('RU-ru')}&`;
            else
                filterString += `${control.element[0].id}=${noValue}&`;
        }
        else if (input.data().role === 'buttongroup') {
            const control = input.data('kendoButtonGroup');
            filterString += `${control.element[0].id}=${control.selectedIndices.join()}&`;
        }
        else if (input.hasClass('k-checkbox')) {
            const control = (this);
            filterString += `${control.name}=${control.checked ? '1' : '0'}&`;
        }
    });
    const grid = findFirstGrid();
    if (grid)
        queryFilterParams['settings'] = getState(grid);

    Object.keys(queryFilterParams).forEach((key) => {
        filterString += `${key}=${queryFilterParams[key]}&`;
    });
    filterString = filterString.slice(0, -1);
    const newurl = window.location.protocol + '//' + window.location.host + window.location.pathname.toLowerCase() + filterString;
    window.history.pushState({
        path: newurl
    }, '', newurl);
}
function getState(grid) {
    const dataSource = grid.dataSource;
    const columns = grid.columns.filter(column => !column.hidden).map(c => c.field);
    return kendo.stringify({
        sort: dataSource.sort(),
        page: dataSource.page(),
        pageSize: dataSource.pageSize(),
        group: dataSource.group().map((c) => ({ field: c.field, dir: c.dir })),
        columns: columns
    });
}
function getGridId(grid) {
    if (!grid || !grid.wrapper)
        return null;
    return grid.wrapper.attr('id');
}
function findFirstGrid() {
    const gridElements = $('.k-grid:not(.grid-without-settings)');
    if (gridElements.length === 0) {
        console.warn('Not found any grids!');
        return null;
    }
    const firstGrid = gridElements.first().data('kendoGrid');
    if (gridElements.length > 1)
        console.warn(`Found ${gridElements.length} grid elements! Using first: ${getGridId(firstGrid)}`);
    return firstGrid;
}
function setFilters(grid, withoutRebind) {
    const paramDictionary = getQueryParams();
    Object.keys(paramDictionary).forEach(key => {
        const control = $(`#${key}`);
        const ms = control.data('kendoMultiSelect');
        const noValue = 'novalue';
        if (ms) {
            let ids;
            if (paramDictionary[key] === 'CI_All') {
                ids = ms.dataSource.data().map((a) => a.Id);
                ms.value(ids);
            }
            else if (paramDictionary[key] === noValue)
                ms.value(null);
            else {
                paramDictionary[key] = decodeURI(paramDictionary[key]);
                if (paramDictionary[key].includes('%2C'))
                    ids = paramDictionary[key].split('%2C').map((a) => a);
                else
                    ids = paramDictionary[key].split(',').map((a) => a);
                ms.value(ids);
                if (ms.dataSource.options.serverFiltering) {
                    updateDynamicMultiSelectItems(ms, ids.map((id) => ({
                        Id: id
                    })));
                }
            }
            return;
        }
        const cb = control.data('kendoComboBox');
        if (cb) {
            if (paramDictionary[key] !== noValue) {
                cb.value(decodeURI(paramDictionary[key]));
                if (cb.dataSource.options.serverFiltering)
                    cb.dataSource.read();
            }
            else
                cb.value('');
            return;
        }
        const dd = control.data('kendoDropDownList');
        if (dd) {
            if (paramDictionary[key] !== noValue)
                dd.value(decodeURI(paramDictionary[key]));
            else
                dd.value('');
            return;
        }
        const ntb = control.data('kendoNumericTextBox');
        if (ntb) {
            if (paramDictionary[key] !== noValue)
                ntb.value(paramDictionary[key]);
            else
                ntb.value('');
            return;
        }
        const mtb = control.data('kendoMaskedTextBox');
        if (mtb) {
            if (paramDictionary[key] !== noValue)
                mtb.value(paramDictionary[key]);
            else
                mtb.value('');
            return;
        }
        const tb = control.data('kendoTextBox');
        if (tb) {
            if (paramDictionary[key] !== noValue)
                tb.value(decodeURI(paramDictionary[key]));
            else
                tb.value('');
            return;
        }
        const bg = control.data('kendoButtonGroup');
        if (bg) {
            bg.select(parseInt(paramDictionary[key]));
            return;
        }
        const chb = control;
        if (chb.hasClass('k-checkbox')) {
            if (paramDictionary[key] !== noValue)
                $(chb)[0].checked = paramDictionary[key] === '1';
        }
        paramDictionary[key] = paramDictionary[key].replace(/%E2%80%8E/g, ''); //     #18843
        const dp = control.data('kendoDatePicker');
        if (dp) {
            if (paramDictionary[key] !== noValue)
                dp.value(paramDictionary[key]);
            else
                dp.value('');
            return;
        }
        const tp = control.data('kendoTimePicker');
        if (tp) {
            if (paramDictionary[key] !== noValue)
                tp.value(decodeURI(paramDictionary[key]));
            else
                tp.value('');
            return;
        }
        const dtp = control.data('kendoDateTimePicker');
        if (dtp) {
            if (paramDictionary[key] !== noValue)
                dtp.value(decodeURI(paramDictionary[key]));
            else
                dtp.value('');
            return;
        }
        if (paramDictionary[key] !== noValue)
            control.val(decodeURI(paramDictionary[key]));
        else
            control.val('');
        if (control.length === 0 && paramDictionary[key] !== noValue)
            queryFilterParams[key] = decodeURI(paramDictionary[key]);
    });
    if (grid && !withoutRebind)
        rebindDataSource(grid);
}
function getQueryParams() {
    const parsedSearch = kendo.parseQueryStringParams(location.search);
    delete parsedSearch['IsFilter'];
    return parsedSearch;
}

function updateDynamicMultiSelectItems(control, items) {
    const backControl = control;
    const missingItems = items.filter((ticket) => backControl.dataItems().filter((item) => ticket.Id === item.Id).length === 0);
    if (missingItems.length > 0) {
        const ids = items.map((x) => x.Id);
        const filter = {
            field: 'Text',
            operator: 'contains',
            value: ids.join(',')
        };
        backControl.dataSource.filter(filter);
        backControl.listView.setDSFilter(backControl.dataSource.filter());
        setTimeout(() => {
            backControl.value(ids);
        }, 2500);
    }
}

function getSettings() {
    const { settings } = kendo.parseQueryStringParams(location.search);
    return settings ? JSON.parse(settings) : null;
}

function collectFiltersOnChangeDataSource({ sender }) {
    if (location.search.includes('?Id=')) {
        return;
    }
    const currentUrl = new URL(location.href);
    const settingsGrid = getState(sender);

    currentUrl.searchParams.set('IsFilter', '0');

    $('.filters input, .filters select, .filters .k-button-group').each(function () {
        const input = $(this);
        const noValue = 'novalue';
        const key = this.id;

        if (input.hasClass('k-textbox')) {
            const value = input.val();
            const isExist = !input.data().role && value;
            currentUrl.searchParams.set(key, isExist ? value : noValue);
        }
        else if (input.hasClass('k-checkbox')) {
            currentUrl.searchParams.set(this.name, this.checked ? '1' : '0');
        }
        else {
            switch (input.data().role) {
                case 'numerictextbox': {
                    const control = input.data('kendoNumericTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'maskedtextbox': {
                    const control = input.data('kendoMaskedTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'textbox': {
                    const control = input.data('kendoTextBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'combobox': {
                    const control = input.data('kendoComboBox');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'dropdownlist': {
                    const control = input.data('kendoDropDownList');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value || noValue);
                    break;
                }
                case 'multiselect': {
                    const control = input.data('kendoMultiSelect');
                    const dataLength = control.dataSource.data().length;
                    const value = control.value();

                    if (value.length) {
                        currentUrl.searchParams.set(key, dataLength === value.length && dataLength !== 1 ? 'CI_All' : value);
                    }
                    else {
                        currentUrl.searchParams.set(key, noValue);
                    }
                    break;
                }
                case 'datepicker': {
                    const control = input.data('kendoDatePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleDateString('RU-ru') : noValue);
                    break;
                }
                case 'timepicker': {
                    const control = input.data('kendoTimePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleTimeString('RU-ru') : noValue);
                    break;
                }
                case 'datetimepicker': {
                    const control = input.data('kendoDateTimePicker');
                    const value = control.value();
                    currentUrl.searchParams.set(key, value ? value.toLocaleString('RU-ru') : noValue);
                    break;
                }
                case 'buttongroup': {
                    const control = input.data('kendoButtonGroup');
                    currentUrl.searchParams.set(key, control.selectedIndices.join());
                    break;
                }
            }
        }
    });

    currentUrl.searchParams.set('settings', settingsGrid);
    
    if (!window.neededPushParamsToSearch) {
        window.neededPushParamsToSearch = true;
        return;
    }
    
    history.pushState({ path: currentUrl.href }, '', currentUrl.href);
}

function recollectFiltersOnSourceChange(instanceGrid) {
    if (!instanceGrid) return;
    instanceGrid.bind('columnShow', collectFiltersOnChangeDataSource);
    instanceGrid.bind('columnHide', collectFiltersOnChangeDataSource);
    instanceGrid.bind('dataBound', collectFiltersOnChangeDataSource);
}

function setSettingsGrid(instanceGrid) {
    if (!instanceGrid) return;

    const settings = getSettings();
    
    if (!settings) {
        /* Если в урле нет параметров - просто грузим грид */
        instanceGrid.dataSource.read();
        return;
    }

    if (settings.group) {
        const groups = settings.group;
        const aggregates = instanceGrid.dataSource.aggregate();

        groups.forEach((group) => group['aggregates'] = aggregates);
        instanceGrid.dataSource._group = groups;
    }

    if (settings.pageSize) {
        instanceGrid.dataSource._pageSize = settings.pageSize;
    }

    if (settings.page) {
        instanceGrid.dataSource._page = settings.page;
    }

    if (settings.columns) {
        instanceGrid.columns.forEach((col) => {
            const isExists = settings.columns.includes(col.field);
            instanceGrid[!isExists && col.field ? 'hideColumn' : 'showColumn'](col.field);
        });
    }

    if (settings.sort) {
        instanceGrid.dataSource.sort(settings.sort);
    } else {
        instanceGrid.dataSource.read();
    }
}