function setControlsSettings() {
    const filesGridDiv = $('#grFiles');
    
    if (filesGridDiv.length === 1) {
        filesGridDiv.on('mousedown', "tr[role='row']", gridRowRightClick);
    }
    
    setComboBoxSettings()
    
    $('[data-role=datepicker]').each(function () {
        const widget = $(this).data('kendoDatePicker');
        
        try {
            $(widget.element).on('change', validateDateInput);
        } catch (e) {
            console.log(`Кто то, что то упустил, ошибка: ${e.message}`);
        }
    });
    
    $('input[type=text]').focus(function () {
        var input = $(this);
        
        if (input[0].getAttribute('role') === 'combobox' || input[0].getAttribute('role') === 'multiselect') { 
            return; 
        }
        
        clearTimeout(input.data('selectTimeId'));
        
        const selectTimeId = setTimeout(() => input.select());
        
        input.data('selectTimeId', selectTimeId);
    }).blur(() => clearTimeout($(this).data('selectTimeId')));
    
    $('input').focus(function () {
        $(this).select();
    });
    
    $('input[data-role=numerictextbox]').focus(function () {
        const input = $(this).select();
        
        if (input.val() === '0') {
            input.val('');
        }
        
        input.on('paste', kendoNumericTextBoxOnPaste);
    });
}

function selectedKeys(grid) {
    return $('.k-grid-content-sticky').find("input[aria-checked='true']").map(function () {
        return grid.dataSource.getByUid($(this).parent().parent().data('uid')).get('Id');
    }).get();
}

function kendoNumericTextBoxOnPaste(e) {
    const data = e.originalEvent.clipboardData.getData('text');
    if (data.indexOf(' ') !== -1) {
        setTimeout(() => {
            $(e.target).data('kendoNumericTextBox').value(data.replace(' ', ''));
            $(e.target).data('kendoNumericTextBox').trigger('change');
        }, 100);
    }
}

function setColorsOnTicketsGrid(grid) {
    const priorityColumnIndex = getColumnIndexByField(grid, 'PriorityName');
    const pipelineStatusColumnIndex = getColumnIndexByField(grid, 'PipelineStatusName');
    const pipelineNameColumnIndex = getColumnIndexByField(grid, 'ColorName');
    const rows = grid.tbody.children();
    for (let i = 0; i < rows.length; i++) {
        if ($(rows[i]).hasClass('k-group-footer'))
            continue;
        const row = $(rows[i]);
        const dataItem = grid.dataItem(row);
        if (!dataItem)
            return;
        if (priorityColumnIndex !== -1) {
            const priorityColor = dataItem.get('PriorityColorColorValue');
            const priorityCell = row.children().eq(priorityColumnIndex);
            priorityCell.css('background', `#${priorityColor}`);
        }
        if (pipelineNameColumnIndex !== -1) {
            const pipelineColor = dataItem.get('ColorColorValue');
            const pipelineCell = row.children().eq(pipelineNameColumnIndex);
            pipelineCell.css('background', `#${pipelineColor}`);
        }
        if (pipelineStatusColumnIndex !== -1) {
            const pipelineStatusColor = dataItem.get('PipelineStatusColorColorValue');
            const pipelineStatusCell = row.children().eq(pipelineStatusColumnIndex);
            pipelineStatusCell.css('background', `#${pipelineStatusColor}`);
        }
    }
}

function setComboBoxSettings() {
    $('[data-role=combobox]').each(function () {
        const widget = $(this).data('kendoComboBox');
        
        if (widget.input.attr('aria-disabled') === 'true') return;
        
        widget.input.focus(() => {
            if (widget.options.enabled) {
                widget.open();
                widget.input.select();
            }
        });
        
        widget.input.focusout(() => {
            widget.close();
        });
        
        widget.input[0].setAttribute('autocomplete', 'off');
    });
}

function dtStart_onChange() {
    const dtEnd = window['dtEnd'];

    if (this.value() && dtEnd.value() && this.value() > dtEnd.value()) {
        dtEnd.value(this.value());
    }
}

function dtEnd_onChange() {
    const dtStart = window['dtStart'];

    if (dtStart.value() && this.value() && this.value() < dtStart.value()) {
        dtStart.value(this.value());
    }
}

function rebindAsync (instance) {
    return new Promise((resolve) => {
        instance.dataSource.read().done(resolve);
    });
}