const editor = kendo.ui.Editor;

editor.defaultTools['insertLineBreak'].options.shift = false;
editor.defaultTools['insertParagraph'].options.shift = true;

window.kendoWindowOptions = {
    draggable: true,
    scrollable: true,
    visible: false,
    animation: false,
    resizable: true
}

$(() => {
    setControlsSettings();
});

function deletePopup(afterConfirmFunc, afterCancelFunc, confirmText) {
    if (!confirmText)
        confirmText = 'Вы уверены, что Вы хотите удалить запись? Это действие необратимо! Продолжить?';

    window.swal.fire({
        title: 'Вы уверены?',
        text: confirmText,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Удалить!',
        cancelButtonText: 'Отмена',
        focusCancel: true
    })
        .then((result) => {
            if (result.value)
                (afterConfirmFunc || jQuery.noop)();
            else
                (afterCancelFunc || jQuery.noop)();
        });
}

function formatUrl(url) {
    return url.replace(/&amp;/g, '&');
}

function numberOrNull(value) {
    if (!value) return null;
    const number = Number(value);
    return isNaN(number) ? null : number
}

function valueOrNull(value) {
    return value === 'novalue' ? null : value || null;
}

function simpleDtoOrNull(id) {
    return id && !isNaN(id)
        ? { Id: id }
        : null;
}

function addGridClickHandler(gridId, event, ...additionalSelectors) {
    let additionSelectorsString = "";
    
    if (additionalSelectors) 
        additionSelectorsString = additionalSelectors.join(" ");
    
    $(`#${gridId}`).on("dblclick", `tr.k-state-selected ${additionSelectorsString}`, event);
}

function adjustGridHeight(grid) {
    const resizeGrid = () => {
        const gridOffsetTop = grid.position().top;

        if (gridOffsetTop >= innerHeight - 100) {
            grid.addClass('k-grid_height-auto');
        } else {
            grid.css('height', innerHeight - gridOffsetTop - 15 + 'px');
            grid.removeClass('k-grid_height-auto');
        }
        setTimeout(kendo.resize.bind(null, grid));
    };

    resizeGrid();
    $(window).on('resize', resizeGrid);
}